/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the X86 target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 152;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(X86InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(X86InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static X86InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static X86InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s80,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v32s1,
  GILLT_v32s8,
  GILLT_v32s16,
  GILLT_v64s1,
  GILLT_v64s8,
};
const static size_t NumTypeObjects = 25;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(80),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(32), 1),
  LLT::vector(ElementCount::getFixed(32), 8),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(64), 1),
  LLT::vector(ElementCount::getFixed(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_TruePredicateBit = 63,
  Feature_HasEGPRBit = 5,
  Feature_NoEGPRBit = 4,
  Feature_HasNDDBit = 6,
  Feature_NoNDDBit = 27,
  Feature_HasZUBit = 151,
  Feature_HasCFBit = 30,
  Feature_HasCMOVBit = 29,
  Feature_NoCMOVBit = 137,
  Feature_HasMMXBit = 109,
  Feature_HasSSE1Bit = 49,
  Feature_UseSSE1Bit = 56,
  Feature_HasSSE2Bit = 48,
  Feature_UseSSE2Bit = 57,
  Feature_HasSSE3Bit = 40,
  Feature_UseSSE3Bit = 66,
  Feature_HasSSSE3Bit = 110,
  Feature_UseSSSE3Bit = 67,
  Feature_UseSSE41Bit = 64,
  Feature_UseSSE42Bit = 71,
  Feature_HasSSE4ABit = 81,
  Feature_NoAVXBit = 77,
  Feature_HasAVXBit = 58,
  Feature_HasAVX2Bit = 52,
  Feature_HasAVX1OnlyBit = 50,
  Feature_HasEVEX512Bit = 144,
  Feature_HasAVX10_2Bit = 108,
  Feature_HasAVX10_2_512Bit = 107,
  Feature_NoAVX10_2Bit = 70,
  Feature_HasAVX512Bit = 94,
  Feature_UseAVXBit = 54,
  Feature_NoAVX512Bit = 45,
  Feature_HasCDIBit = 98,
  Feature_HasVPOPCNTDQBit = 102,
  Feature_HasDQIBit = 96,
  Feature_NoDQIBit = 68,
  Feature_HasBWIBit = 97,
  Feature_NoBWIBit = 65,
  Feature_HasVLXBit = 95,
  Feature_NoVLXBit = 44,
  Feature_NoVLX_Or_NoBWIBit = 62,
  Feature_HasVNNIBit = 104,
  Feature_HasVP2INTERSECTBit = 106,
  Feature_HasFP16Bit = 100,
  Feature_HasAVXVNNIINT16Bit = 93,
  Feature_HasAVXVNNIINT8Bit = 88,
  Feature_HasAVXVNNIBit = 82,
  Feature_NoVLX_Or_NoVNNIBit = 83,
  Feature_HasBITALGBit = 105,
  Feature_HasPOPCNTBit = 69,
  Feature_HasAESBit = 74,
  Feature_HasVAESBit = 76,
  Feature_NoVLX_Or_NoVAESBit = 75,
  Feature_HasFXSRBit = 41,
  Feature_HasX87Bit = 39,
  Feature_HasXSAVEBit = 126,
  Feature_HasXSAVEOPTBit = 127,
  Feature_HasXSAVECBit = 128,
  Feature_HasXSAVESBit = 129,
  Feature_HasPCLMULBit = 78,
  Feature_NoVLX_Or_NoVPCLMULQDQBit = 79,
  Feature_HasVPCLMULQDQBit = 80,
  Feature_HasGFNIBit = 85,
  Feature_HasFMABit = 42,
  Feature_HasFMA4Bit = 46,
  Feature_NoFMA4Bit = 43,
  Feature_HasXOPBit = 47,
  Feature_HasTBMBit = 26,
  Feature_NoTBMBit = 142,
  Feature_HasLWPBit = 12,
  Feature_HasMOVBEBit = 3,
  Feature_NoNDD_Or_NoMOVBEBit = 2,
  Feature_HasRDRANDBit = 7,
  Feature_HasF16CBit = 84,
  Feature_HasFSGSBaseBit = 130,
  Feature_HasLZCNTBit = 9,
  Feature_HasBMIBit = 10,
  Feature_HasBMI2Bit = 11,
  Feature_NoBMI2Bit = 141,
  Feature_HasVBMIBit = 99,
  Feature_HasVBMI2Bit = 103,
  Feature_HasIFMABit = 101,
  Feature_HasAVXIFMABit = 86,
  Feature_NoVLX_Or_NoIFMABit = 87,
  Feature_HasRTMBit = 112,
  Feature_HasSHABit = 73,
  Feature_HasSHA512Bit = 90,
  Feature_HasSM3Bit = 91,
  Feature_HasRDSEEDBit = 8,
  Feature_HasSSEPrefetchBit = 59,
  Feature_HasPREFETCHIBit = 20,
  Feature_HasPrefetchWBit = 111,
  Feature_HasMWAITXBit = 140,
  Feature_HasCLDEMOTEBit = 24,
  Feature_HasMOVDIRIBit = 14,
  Feature_HasMOVDIR64BBit = 15,
  Feature_HasMOVRSBit = 25,
  Feature_HasPTWRITEBit = 133,
  Feature_FPStackf32Bit = 37,
  Feature_FPStackf64Bit = 38,
  Feature_HasSM4Bit = 92,
  Feature_HasCLFLUSHBit = 60,
  Feature_HasCLFLUSHOPTBit = 22,
  Feature_HasCLWBBit = 23,
  Feature_HasWBNOINVDBit = 125,
  Feature_HasRDPIDBit = 132,
  Feature_HasWAITPKGBit = 13,
  Feature_HasINVPCIDBit = 131,
  Feature_HasCX8Bit = 138,
  Feature_HasCX16Bit = 139,
  Feature_HasENQCMDBit = 16,
  Feature_HasAMXFP16Bit = 117,
  Feature_HasCMPCCXADDBit = 21,
  Feature_HasAVXNECONVERTBit = 89,
  Feature_HasKLBit = 113,
  Feature_HasRAOINTBit = 123,
  Feature_HasSERIALIZEBit = 17,
  Feature_HasTSXLDTRKBit = 18,
  Feature_HasAMXTILEBit = 114,
  Feature_HasAMXBF16Bit = 116,
  Feature_HasAMXINT8Bit = 115,
  Feature_HasAMXCOMPLEXBit = 118,
  Feature_HasAMXFP8Bit = 119,
  Feature_HasAMXTRANSPOSEBit = 120,
  Feature_HasAMXAVX512Bit = 121,
  Feature_HasAMXTF32Bit = 122,
  Feature_HasUINTRBit = 19,
  Feature_HasUSERMSRBit = 124,
  Feature_HasCRC32Bit = 72,
  Feature_Not64BitModeBit = 0,
  Feature_In64BitModeBit = 1,
  Feature_IsLP64Bit = 135,
  Feature_NotLP64Bit = 134,
  Feature_NotWin64WithoutFPBit = 136,
  Feature_IsPSBit = 146,
  Feature_NotPSBit = 145,
  Feature_KernelCodeBit = 147,
  Feature_NearDataBit = 149,
  Feature_IsNotPICBit = 148,
  Feature_OptForSizeBit = 53,
  Feature_OptForMinSizeBit = 51,
  Feature_OptForSpeedBit = 143,
  Feature_UseIncDecBit = 28,
  Feature_NoSSE41_Or_OptForSizeBit = 55,
  Feature_ImportCallOptimizationEnabledBit = 35,
  Feature_ImportCallOptimizationDisabledBit = 33,
  Feature_CallImmAddrBit = 150,
  Feature_FavorMemIndirectCallBit = 31,
  Feature_HasFastSHLDRotateBit = 36,
  Feature_HasMFenceBit = 61,
  Feature_UseIndirectThunkCallsBit = 34,
  Feature_NotUseIndirectThunkCallsBit = 32,
};

PredicateBitset X86InstructionSelector::
computeAvailableModuleFeatures(const X86Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (true)
    Features.set(Feature_TruePredicateBit);
  if (Subtarget->hasEGPR())
    Features.set(Feature_HasEGPRBit);
  if (!Subtarget->hasEGPR())
    Features.set(Feature_NoEGPRBit);
  if (Subtarget->hasNDD())
    Features.set(Feature_HasNDDBit);
  if (!Subtarget->hasNDD())
    Features.set(Feature_NoNDDBit);
  if (Subtarget->hasZU())
    Features.set(Feature_HasZUBit);
  if (Subtarget->hasCF())
    Features.set(Feature_HasCFBit);
  if (Subtarget->canUseCMOV())
    Features.set(Feature_HasCMOVBit);
  if (!Subtarget->canUseCMOV())
    Features.set(Feature_NoCMOVBit);
  if (Subtarget->hasMMX())
    Features.set(Feature_HasMMXBit);
  if (Subtarget->hasSSE1())
    Features.set(Feature_HasSSE1Bit);
  if (Subtarget->hasSSE1() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE1Bit);
  if (Subtarget->hasSSE2())
    Features.set(Feature_HasSSE2Bit);
  if (Subtarget->hasSSE2() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE2Bit);
  if (Subtarget->hasSSE3())
    Features.set(Feature_HasSSE3Bit);
  if (Subtarget->hasSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE3Bit);
  if (Subtarget->hasSSSE3())
    Features.set(Feature_HasSSSE3Bit);
  if (Subtarget->hasSSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSSE3Bit);
  if (Subtarget->hasSSE41() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE41Bit);
  if (Subtarget->hasSSE42() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE42Bit);
  if (Subtarget->hasSSE4A())
    Features.set(Feature_HasSSE4ABit);
  if (!Subtarget->hasAVX())
    Features.set(Feature_NoAVXBit);
  if (Subtarget->hasAVX())
    Features.set(Feature_HasAVXBit);
  if (Subtarget->hasAVX2())
    Features.set(Feature_HasAVX2Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX2())
    Features.set(Feature_HasAVX1OnlyBit);
  if (Subtarget->hasEVEX512())
    Features.set(Feature_HasEVEX512Bit);
  if (Subtarget->hasAVX10_2())
    Features.set(Feature_HasAVX10_2Bit);
  if (Subtarget->hasAVX10_2_512())
    Features.set(Feature_HasAVX10_2_512Bit);
  if (!Subtarget->hasAVX10_2())
    Features.set(Feature_NoAVX10_2Bit);
  if (Subtarget->hasAVX512())
    Features.set(Feature_HasAVX512Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX512())
    Features.set(Feature_UseAVXBit);
  if (!Subtarget->hasAVX512())
    Features.set(Feature_NoAVX512Bit);
  if (Subtarget->hasCDI())
    Features.set(Feature_HasCDIBit);
  if (Subtarget->hasVPOPCNTDQ())
    Features.set(Feature_HasVPOPCNTDQBit);
  if (Subtarget->hasDQI())
    Features.set(Feature_HasDQIBit);
  if (!Subtarget->hasDQI())
    Features.set(Feature_NoDQIBit);
  if (Subtarget->hasBWI())
    Features.set(Feature_HasBWIBit);
  if (!Subtarget->hasBWI())
    Features.set(Feature_NoBWIBit);
  if (Subtarget->hasVLX())
    Features.set(Feature_HasVLXBit);
  if (!Subtarget->hasVLX())
    Features.set(Feature_NoVLXBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasBWI())
    Features.set(Feature_NoVLX_Or_NoBWIBit);
  if (Subtarget->hasVNNI())
    Features.set(Feature_HasVNNIBit);
  if (Subtarget->hasVP2INTERSECT())
    Features.set(Feature_HasVP2INTERSECTBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasAVXVNNIINT16())
    Features.set(Feature_HasAVXVNNIINT16Bit);
  if (Subtarget->hasAVXVNNIINT8())
    Features.set(Feature_HasAVXVNNIINT8Bit);
  if (Subtarget->hasAVXVNNI())
    Features.set(Feature_HasAVXVNNIBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVNNI())
    Features.set(Feature_NoVLX_Or_NoVNNIBit);
  if (Subtarget->hasBITALG())
    Features.set(Feature_HasBITALGBit);
  if (Subtarget->hasPOPCNT())
    Features.set(Feature_HasPOPCNTBit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasVAES())
    Features.set(Feature_HasVAESBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVAES())
    Features.set(Feature_NoVLX_Or_NoVAESBit);
  if (Subtarget->hasFXSR())
    Features.set(Feature_HasFXSRBit);
  if (Subtarget->hasX87())
    Features.set(Feature_HasX87Bit);
  if (Subtarget->hasXSAVE())
    Features.set(Feature_HasXSAVEBit);
  if (Subtarget->hasXSAVEOPT())
    Features.set(Feature_HasXSAVEOPTBit);
  if (Subtarget->hasXSAVEC())
    Features.set(Feature_HasXSAVECBit);
  if (Subtarget->hasXSAVES())
    Features.set(Feature_HasXSAVESBit);
  if (Subtarget->hasPCLMUL())
    Features.set(Feature_HasPCLMULBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_NoVLX_Or_NoVPCLMULQDQBit);
  if (Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_HasVPCLMULQDQBit);
  if (Subtarget->hasGFNI())
    Features.set(Feature_HasGFNIBit);
  if (Subtarget->hasFMA())
    Features.set(Feature_HasFMABit);
  if (Subtarget->hasFMA4())
    Features.set(Feature_HasFMA4Bit);
  if (!Subtarget->hasFMA4())
    Features.set(Feature_NoFMA4Bit);
  if (Subtarget->hasXOP())
    Features.set(Feature_HasXOPBit);
  if (Subtarget->hasTBM())
    Features.set(Feature_HasTBMBit);
  if (!Subtarget->hasTBM())
    Features.set(Feature_NoTBMBit);
  if (Subtarget->hasLWP())
    Features.set(Feature_HasLWPBit);
  if (Subtarget->hasMOVBE())
    Features.set(Feature_HasMOVBEBit);
  if (!Subtarget->hasNDD() || !Subtarget->hasMOVBE())
    Features.set(Feature_NoNDD_Or_NoMOVBEBit);
  if (Subtarget->hasRDRAND())
    Features.set(Feature_HasRDRANDBit);
  if (Subtarget->hasF16C())
    Features.set(Feature_HasF16CBit);
  if (Subtarget->hasFSGSBase())
    Features.set(Feature_HasFSGSBaseBit);
  if (Subtarget->hasLZCNT())
    Features.set(Feature_HasLZCNTBit);
  if (Subtarget->hasBMI())
    Features.set(Feature_HasBMIBit);
  if (Subtarget->hasBMI2())
    Features.set(Feature_HasBMI2Bit);
  if (!Subtarget->hasBMI2())
    Features.set(Feature_NoBMI2Bit);
  if (Subtarget->hasVBMI())
    Features.set(Feature_HasVBMIBit);
  if (Subtarget->hasVBMI2())
    Features.set(Feature_HasVBMI2Bit);
  if (Subtarget->hasIFMA())
    Features.set(Feature_HasIFMABit);
  if (Subtarget->hasAVXIFMA())
    Features.set(Feature_HasAVXIFMABit);
  if (!Subtarget->hasVLX() || !Subtarget->hasIFMA())
    Features.set(Feature_NoVLX_Or_NoIFMABit);
  if (Subtarget->hasRTM())
    Features.set(Feature_HasRTMBit);
  if (Subtarget->hasSHA())
    Features.set(Feature_HasSHABit);
  if (Subtarget->hasSHA512())
    Features.set(Feature_HasSHA512Bit);
  if (Subtarget->hasSM3())
    Features.set(Feature_HasSM3Bit);
  if (Subtarget->hasRDSEED())
    Features.set(Feature_HasRDSEEDBit);
  if (Subtarget->hasSSEPrefetch())
    Features.set(Feature_HasSSEPrefetchBit);
  if (Subtarget->hasPREFETCHI())
    Features.set(Feature_HasPREFETCHIBit);
  if (Subtarget->hasPrefetchW())
    Features.set(Feature_HasPrefetchWBit);
  if (Subtarget->hasMWAITX())
    Features.set(Feature_HasMWAITXBit);
  if (Subtarget->hasCLDEMOTE())
    Features.set(Feature_HasCLDEMOTEBit);
  if (Subtarget->hasMOVDIRI())
    Features.set(Feature_HasMOVDIRIBit);
  if (Subtarget->hasMOVDIR64B())
    Features.set(Feature_HasMOVDIR64BBit);
  if (Subtarget->hasMOVRS())
    Features.set(Feature_HasMOVRSBit);
  if (Subtarget->hasPTWRITE())
    Features.set(Feature_HasPTWRITEBit);
  if (!Subtarget->hasSSE1())
    Features.set(Feature_FPStackf32Bit);
  if (!Subtarget->hasSSE2())
    Features.set(Feature_FPStackf64Bit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasCLFLUSH())
    Features.set(Feature_HasCLFLUSHBit);
  if (Subtarget->hasCLFLUSHOPT())
    Features.set(Feature_HasCLFLUSHOPTBit);
  if (Subtarget->hasCLWB())
    Features.set(Feature_HasCLWBBit);
  if (Subtarget->hasWBNOINVD())
    Features.set(Feature_HasWBNOINVDBit);
  if (Subtarget->hasRDPID())
    Features.set(Feature_HasRDPIDBit);
  if (Subtarget->hasWAITPKG())
    Features.set(Feature_HasWAITPKGBit);
  if (Subtarget->hasINVPCID())
    Features.set(Feature_HasINVPCIDBit);
  if (Subtarget->hasCX8())
    Features.set(Feature_HasCX8Bit);
  if (Subtarget->hasCX16())
    Features.set(Feature_HasCX16Bit);
  if (Subtarget->hasENQCMD())
    Features.set(Feature_HasENQCMDBit);
  if (Subtarget->hasAMXFP16())
    Features.set(Feature_HasAMXFP16Bit);
  if (Subtarget->hasCMPCCXADD())
    Features.set(Feature_HasCMPCCXADDBit);
  if (Subtarget->hasAVXNECONVERT())
    Features.set(Feature_HasAVXNECONVERTBit);
  if (Subtarget->hasKL())
    Features.set(Feature_HasKLBit);
  if (Subtarget->hasRAOINT())
    Features.set(Feature_HasRAOINTBit);
  if (Subtarget->hasSERIALIZE())
    Features.set(Feature_HasSERIALIZEBit);
  if (Subtarget->hasTSXLDTRK())
    Features.set(Feature_HasTSXLDTRKBit);
  if (Subtarget->hasAMXTILE())
    Features.set(Feature_HasAMXTILEBit);
  if (Subtarget->hasAMXBF16())
    Features.set(Feature_HasAMXBF16Bit);
  if (Subtarget->hasAMXINT8())
    Features.set(Feature_HasAMXINT8Bit);
  if (Subtarget->hasAMXCOMPLEX())
    Features.set(Feature_HasAMXCOMPLEXBit);
  if (Subtarget->hasAMXFP8())
    Features.set(Feature_HasAMXFP8Bit);
  if (Subtarget->hasAMXTRANSPOSE())
    Features.set(Feature_HasAMXTRANSPOSEBit);
  if (Subtarget->hasAMXAVX512())
    Features.set(Feature_HasAMXAVX512Bit);
  if (Subtarget->hasAMXTF32())
    Features.set(Feature_HasAMXTF32Bit);
  if (Subtarget->hasUINTR())
    Features.set(Feature_HasUINTRBit);
  if (Subtarget->hasUSERMSR())
    Features.set(Feature_HasUSERMSRBit);
  if (Subtarget->hasCRC32())
    Features.set(Feature_HasCRC32Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_Not64BitModeBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->isTarget64BitLP64())
    Features.set(Feature_IsLP64Bit);
  if (!Subtarget->isTarget64BitLP64())
    Features.set(Feature_NotLP64Bit);
  if (Subtarget->isTargetPS())
    Features.set(Feature_IsPSBit);
  if (!Subtarget->isTargetPS())
    Features.set(Feature_NotPSBit);
  if (TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_KernelCodeBit);
  if (TM.getCodeModel() == CodeModel::Small ||TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_NearDataBit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_IsNotPICBit);
  if (Subtarget->isLegalToCallImmediateAddr())
    Features.set(Feature_CallImmAddrBit);
  if (!Subtarget->slowTwoMemOps())
    Features.set(Feature_FavorMemIndirectCallBit);
  if (Subtarget->hasFastSHLDRotate())
    Features.set(Feature_HasFastSHLDRotateBit);
  if (Subtarget->hasMFence())
    Features.set(Feature_HasMFenceBit);
  if (Subtarget->useIndirectThunkCalls())
    Features.set(Feature_UseIndirectThunkCallsBit);
  if (!Subtarget->useIndirectThunkCalls())
    Features.set(Feature_NotUseIndirectThunkCallsBit);
  return Features;
}

void X86InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const X86Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset X86InstructionSelector::
computeAvailableFunctionFeatures(const X86Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!Subtarget->isTargetWin64() ||Subtarget->getFrameLowering()->hasFP(*MF))
    Features.set(Feature_NotWin64WithoutFPBit);
  if (shouldOptForSize(MF))
    Features.set(Feature_OptForSizeBit);
  if (MF->getFunction().hasMinSize())
    Features.set(Feature_OptForMinSizeBit);
  if (!shouldOptForSize(MF))
    Features.set(Feature_OptForSpeedBit);
  if (!Subtarget->slowIncDec() || shouldOptForSize(MF))
    Features.set(Feature_UseIncDecBit);
  if (shouldOptForSize(MF) || !Subtarget->hasSSE41())
    Features.set(Feature_NoSSE41_Or_OptForSizeBit);
  if (MF->getFunction().getParent()->getModuleFlag("import-call-optimization"))
    Features.set(Feature_ImportCallOptimizationEnabledBit);
  if (!MF->getFunction().getParent()->getModuleFlag("import-call-optimization"))
    Features.set(Feature_ImportCallOptimizationDisabledBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_FPStackf32,
  GIFBS_FPStackf64,
  GIFBS_HasAVX,
  GIFBS_HasAVX1Only,
  GIFBS_HasAVX2,
  GIFBS_HasAVX512,
  GIFBS_HasAVXNECONVERT,
  GIFBS_HasBITALG,
  GIFBS_HasBMI,
  GIFBS_HasBWI,
  GIFBS_HasCDI,
  GIFBS_HasCLDEMOTE,
  GIFBS_HasCLFLUSH,
  GIFBS_HasCLFLUSHOPT,
  GIFBS_HasCLWB,
  GIFBS_HasDQI,
  GIFBS_HasFP16,
  GIFBS_HasFXSR,
  GIFBS_HasFastSHLDRotate,
  GIFBS_HasKL,
  GIFBS_HasLWP,
  GIFBS_HasLZCNT,
  GIFBS_HasMFence,
  GIFBS_HasMMX,
  GIFBS_HasMOVBE,
  GIFBS_HasMOVRS,
  GIFBS_HasMWAITX,
  GIFBS_HasNDD,
  GIFBS_HasPOPCNT,
  GIFBS_HasPTWRITE,
  GIFBS_HasPrefetchW,
  GIFBS_HasRTM,
  GIFBS_HasSERIALIZE,
  GIFBS_HasSHA,
  GIFBS_HasSHA512,
  GIFBS_HasSM3,
  GIFBS_HasSM4,
  GIFBS_HasSSE1,
  GIFBS_HasSSE2,
  GIFBS_HasSSE3,
  GIFBS_HasSSE4A,
  GIFBS_HasSSEPrefetch,
  GIFBS_HasTBM,
  GIFBS_HasTSXLDTRK,
  GIFBS_HasVBMI2,
  GIFBS_HasVLX,
  GIFBS_HasVPOPCNTDQ,
  GIFBS_HasWAITPKG,
  GIFBS_HasWBNOINVD,
  GIFBS_HasX87,
  GIFBS_HasXOP,
  GIFBS_HasXSAVE,
  GIFBS_HasXSAVEC,
  GIFBS_HasXSAVEOPT,
  GIFBS_HasXSAVES,
  GIFBS_HasZU,
  GIFBS_In64BitMode,
  GIFBS_IsPS,
  GIFBS_NoAVX,
  GIFBS_NoDQI,
  GIFBS_NoEGPR,
  GIFBS_NoNDD,
  GIFBS_NoNDD_Or_NoMOVBE,
  GIFBS_Not64BitMode,
  GIFBS_NotPS,
  GIFBS_UseAVX,
  GIFBS_UseIncDec,
  GIFBS_UseSSE1,
  GIFBS_UseSSE2,
  GIFBS_UseSSE3,
  GIFBS_UseSSE41,
  GIFBS_UseSSSE3,
  GIFBS_HasAES_HasAVX,
  GIFBS_HasAES_NoAVX,
  GIFBS_HasAMXBF16_In64BitMode,
  GIFBS_HasAMXCOMPLEX_In64BitMode,
  GIFBS_HasAMXFP16_In64BitMode,
  GIFBS_HasAMXFP8_In64BitMode,
  GIFBS_HasAMXINT8_In64BitMode,
  GIFBS_HasAMXTF32_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode,
  GIFBS_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAVX_In64BitMode,
  GIFBS_HasAVX_NoBWI,
  GIFBS_HasAVX_NoVLX,
  GIFBS_HasAVX_NoVLX_Or_NoBWI,
  GIFBS_HasAVX10_2_HasSM4,
  GIFBS_HasAVX10_2_512_HasSM4,
  GIFBS_HasAVX2_NoVLX,
  GIFBS_HasAVX2_NoVLX_Or_NoBWI,
  GIFBS_HasAVX512_HasVAES,
  GIFBS_HasAVX512_HasVLX,
  GIFBS_HasAVX512_HasVPCLMULQDQ,
  GIFBS_HasAVX512_NoBWI,
  GIFBS_HasAVX512_NoDQI,
  GIFBS_HasAVX512_NoEGPR,
  GIFBS_HasAVX512_OptForSize,
  GIFBS_HasBITALG_HasVLX,
  GIFBS_HasBMI_HasEGPR,
  GIFBS_HasBMI_NoEGPR,
  GIFBS_HasBMI2_HasEGPR,
  GIFBS_HasBMI2_NoEGPR,
  GIFBS_HasBWI_HasVLX,
  GIFBS_HasBWI_NoEGPR,
  GIFBS_HasCDI_HasVLX,
  GIFBS_HasCRC32_NoEGPR,
  GIFBS_HasDQI_HasVLX,
  GIFBS_HasDQI_NoBWI,
  GIFBS_HasDQI_NoEGPR,
  GIFBS_HasEGPR_HasINVPCID,
  GIFBS_HasEGPR_In64BitMode,
  GIFBS_HasEVEX512_NoVLX,
  GIFBS_HasFMA4_NoAVX512,
  GIFBS_HasFMA4_NoVLX,
  GIFBS_HasFP16_HasVLX,
  GIFBS_HasFP16_In64BitMode,
  GIFBS_HasFP16_OptForSize,
  GIFBS_HasFSGSBase_In64BitMode,
  GIFBS_HasFXSR_In64BitMode,
  GIFBS_HasINVPCID_NoEGPR,
  GIFBS_HasINVPCID_Not64BitMode,
  GIFBS_HasMOVBE_NoEGPR,
  GIFBS_HasMOVDIR64B_NoEGPR,
  GIFBS_HasMOVDIRI_NoEGPR,
  GIFBS_HasNDD_In64BitMode,
  GIFBS_HasNDD_UseIncDec,
  GIFBS_HasPCLMUL_NoAVX,
  GIFBS_HasPREFETCHI_In64BitMode,
  GIFBS_HasPTWRITE_In64BitMode,
  GIFBS_HasRDPID_In64BitMode,
  GIFBS_HasRDPID_Not64BitMode,
  GIFBS_HasUINTR_In64BitMode,
  GIFBS_HasUSERMSR_NoEGPR,
  GIFBS_HasVAES_HasVLX,
  GIFBS_HasVAES_NoVLX,
  GIFBS_HasVBMI2_HasVLX,
  GIFBS_HasVLX_HasVPCLMULQDQ,
  GIFBS_HasVLX_HasVPOPCNTDQ,
  GIFBS_HasVPCLMULQDQ_NoVLX,
  GIFBS_HasWAITPKG_In64BitMode,
  GIFBS_HasWAITPKG_Not64BitMode,
  GIFBS_HasXSAVE_In64BitMode,
  GIFBS_HasXSAVEC_In64BitMode,
  GIFBS_HasXSAVEOPT_In64BitMode,
  GIFBS_HasXSAVES_In64BitMode,
  GIFBS_In64BitMode_UseIncDec,
  GIFBS_In64BitMode_UseSSE2,
  GIFBS_NoNDD_UseIncDec,
  GIFBS_Not64BitMode_OptForSize,
  GIFBS_NotWin64WithoutFP_OptForMinSize,
  GIFBS_OptForSize_UseAVX,
  GIFBS_OptForSize_UseSSE1,
  GIFBS_OptForSize_UseSSE2,
  GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES,
  GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode,
  GIFBS_HasAMXBF16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXFP16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXTF32_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXTILE_HasEGPR_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode_NoEGPR,
  GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ,
  GIFBS_HasAVX10_2_HasMOVRS_In64BitMode,
  GIFBS_HasAVX10_2_512_HasMOVRS_In64BitMode,
  GIFBS_HasAVX512_HasEGPR_In64BitMode,
  GIFBS_HasAVX512_HasEVEX512_NoVLX,
  GIFBS_HasBITALG_HasEVEX512_NoVLX,
  GIFBS_HasBWI_HasEGPR_In64BitMode,
  GIFBS_HasBWI_HasEVEX512_NoVLX,
  GIFBS_HasCDI_HasEVEX512_NoVLX,
  GIFBS_HasCRC32_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEVEX512_NoVLX,
  GIFBS_HasDQI_HasVLX_NoBWI,
  GIFBS_HasEGPR_HasMOVBE_In64BitMode,
  GIFBS_HasEGPR_HasMOVDIR64B_In64BitMode,
  GIFBS_HasEGPR_HasMOVDIRI_In64BitMode,
  GIFBS_HasEGPR_HasMOVRS_In64BitMode,
  GIFBS_HasEGPR_HasUSERMSR_In64BitMode,
  GIFBS_HasEVEX512_HasVPOPCNTDQ_NoVLX,
  GIFBS_HasFMA_NoAVX512_NoFMA4,
  GIFBS_HasFMA_NoFMA4_NoVLX,
  GIFBS_HasMOVBE_HasNDD_In64BitMode,
  GIFBS_HasMOVDIR64B_In64BitMode_NoEGPR,
  GIFBS_HasMOVDIRI_In64BitMode_NoEGPR,
  GIFBS_HasMOVRS_In64BitMode_NoEGPR,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_FPStackf32Bit, },
  {Feature_FPStackf64Bit, },
  {Feature_HasAVXBit, },
  {Feature_HasAVX1OnlyBit, },
  {Feature_HasAVX2Bit, },
  {Feature_HasAVX512Bit, },
  {Feature_HasAVXNECONVERTBit, },
  {Feature_HasBITALGBit, },
  {Feature_HasBMIBit, },
  {Feature_HasBWIBit, },
  {Feature_HasCDIBit, },
  {Feature_HasCLDEMOTEBit, },
  {Feature_HasCLFLUSHBit, },
  {Feature_HasCLFLUSHOPTBit, },
  {Feature_HasCLWBBit, },
  {Feature_HasDQIBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFXSRBit, },
  {Feature_HasFastSHLDRotateBit, },
  {Feature_HasKLBit, },
  {Feature_HasLWPBit, },
  {Feature_HasLZCNTBit, },
  {Feature_HasMFenceBit, },
  {Feature_HasMMXBit, },
  {Feature_HasMOVBEBit, },
  {Feature_HasMOVRSBit, },
  {Feature_HasMWAITXBit, },
  {Feature_HasNDDBit, },
  {Feature_HasPOPCNTBit, },
  {Feature_HasPTWRITEBit, },
  {Feature_HasPrefetchWBit, },
  {Feature_HasRTMBit, },
  {Feature_HasSERIALIZEBit, },
  {Feature_HasSHABit, },
  {Feature_HasSHA512Bit, },
  {Feature_HasSM3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSSE1Bit, },
  {Feature_HasSSE2Bit, },
  {Feature_HasSSE3Bit, },
  {Feature_HasSSE4ABit, },
  {Feature_HasSSEPrefetchBit, },
  {Feature_HasTBMBit, },
  {Feature_HasTSXLDTRKBit, },
  {Feature_HasVBMI2Bit, },
  {Feature_HasVLXBit, },
  {Feature_HasVPOPCNTDQBit, },
  {Feature_HasWAITPKGBit, },
  {Feature_HasWBNOINVDBit, },
  {Feature_HasX87Bit, },
  {Feature_HasXOPBit, },
  {Feature_HasXSAVEBit, },
  {Feature_HasXSAVECBit, },
  {Feature_HasXSAVEOPTBit, },
  {Feature_HasXSAVESBit, },
  {Feature_HasZUBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsPSBit, },
  {Feature_NoAVXBit, },
  {Feature_NoDQIBit, },
  {Feature_NoEGPRBit, },
  {Feature_NoNDDBit, },
  {Feature_NoNDD_Or_NoMOVBEBit, },
  {Feature_Not64BitModeBit, },
  {Feature_NotPSBit, },
  {Feature_UseAVXBit, },
  {Feature_UseIncDecBit, },
  {Feature_UseSSE1Bit, },
  {Feature_UseSSE2Bit, },
  {Feature_UseSSE3Bit, },
  {Feature_UseSSE41Bit, },
  {Feature_UseSSSE3Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, },
  {Feature_HasAESBit, Feature_NoAVXBit, },
  {Feature_HasAMXBF16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXINT8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_NoBWIBit, },
  {Feature_HasAVXBit, Feature_NoVLXBit, },
  {Feature_HasAVXBit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX10_2Bit, Feature_HasSM4Bit, },
  {Feature_HasAVX10_2_512Bit, Feature_HasSM4Bit, },
  {Feature_HasAVX2Bit, Feature_NoVLXBit, },
  {Feature_HasAVX2Bit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_HasVAESBit, },
  {Feature_HasAVX512Bit, Feature_HasVLXBit, },
  {Feature_HasAVX512Bit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_NoDQIBit, },
  {Feature_HasAVX512Bit, Feature_NoEGPRBit, },
  {Feature_HasAVX512Bit, Feature_OptForSizeBit, },
  {Feature_HasBITALGBit, Feature_HasVLXBit, },
  {Feature_HasBMIBit, Feature_HasEGPRBit, },
  {Feature_HasBMIBit, Feature_NoEGPRBit, },
  {Feature_HasBMI2Bit, Feature_HasEGPRBit, },
  {Feature_HasBMI2Bit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_HasVLXBit, },
  {Feature_HasBWIBit, Feature_NoEGPRBit, },
  {Feature_HasCDIBit, Feature_HasVLXBit, },
  {Feature_HasCRC32Bit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, },
  {Feature_HasDQIBit, Feature_NoBWIBit, },
  {Feature_HasDQIBit, Feature_NoEGPRBit, },
  {Feature_HasEGPRBit, Feature_HasINVPCIDBit, },
  {Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasFMA4Bit, Feature_NoAVX512Bit, },
  {Feature_HasFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasFP16Bit, Feature_HasVLXBit, },
  {Feature_HasFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasFP16Bit, Feature_OptForSizeBit, },
  {Feature_HasFSGSBaseBit, Feature_In64BitModeBit, },
  {Feature_HasFXSRBit, Feature_In64BitModeBit, },
  {Feature_HasINVPCIDBit, Feature_NoEGPRBit, },
  {Feature_HasINVPCIDBit, Feature_Not64BitModeBit, },
  {Feature_HasMOVBEBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIR64BBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIRIBit, Feature_NoEGPRBit, },
  {Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_UseIncDecBit, },
  {Feature_HasPCLMULBit, Feature_NoAVXBit, },
  {Feature_HasPREFETCHIBit, Feature_In64BitModeBit, },
  {Feature_HasPTWRITEBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_Not64BitModeBit, },
  {Feature_HasUINTRBit, Feature_In64BitModeBit, },
  {Feature_HasUSERMSRBit, Feature_NoEGPRBit, },
  {Feature_HasVAESBit, Feature_HasVLXBit, },
  {Feature_HasVAESBit, Feature_NoVLXBit, },
  {Feature_HasVBMI2Bit, Feature_HasVLXBit, },
  {Feature_HasVLXBit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasVLXBit, Feature_HasVPOPCNTDQBit, },
  {Feature_HasVPCLMULQDQBit, Feature_NoVLXBit, },
  {Feature_HasWAITPKGBit, Feature_In64BitModeBit, },
  {Feature_HasWAITPKGBit, Feature_Not64BitModeBit, },
  {Feature_HasXSAVEBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVECBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVEOPTBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVESBit, Feature_In64BitModeBit, },
  {Feature_In64BitModeBit, Feature_UseIncDecBit, },
  {Feature_In64BitModeBit, Feature_UseSSE2Bit, },
  {Feature_NoNDDBit, Feature_UseIncDecBit, },
  {Feature_Not64BitModeBit, Feature_OptForSizeBit, },
  {Feature_NotWin64WithoutFPBit, Feature_OptForMinSizeBit, },
  {Feature_OptForSizeBit, Feature_UseAVXBit, },
  {Feature_OptForSizeBit, Feature_UseSSE1Bit, },
  {Feature_OptForSizeBit, Feature_UseSSE2Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, Feature_NoVLX_Or_NoVAESBit, },
  {Feature_HasAMXAVX512Bit, Feature_HasAVX10_2_512Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXBF16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasAVXBit, Feature_HasPCLMULBit, Feature_NoVLX_Or_NoVPCLMULQDQBit, },
  {Feature_HasAVX10_2Bit, Feature_HasMOVRSBit, Feature_In64BitModeBit, },
  {Feature_HasAVX10_2_512Bit, Feature_HasMOVRSBit, Feature_In64BitModeBit, },
  {Feature_HasAVX512Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasAVX512Bit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBITALGBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBWIBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasBWIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCDIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCRC32Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, Feature_NoBWIBit, },
  {Feature_HasEGPRBit, Feature_HasMOVBEBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVDIR64BBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVDIRIBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVRSBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasUSERMSRBit, Feature_In64BitModeBit, },
  {Feature_HasEVEX512Bit, Feature_HasVPOPCNTDQBit, Feature_NoVLXBit, },
  {Feature_HasFMABit, Feature_NoAVX512Bit, Feature_NoFMA4Bit, },
  {Feature_HasFMABit, Feature_NoFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasMOVBEBit, Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasMOVDIR64BBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIRIBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasMOVRSBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addr,
};
// See constructor for table contents

X86InstructionSelector::ComplexMatcherMemFn
X86InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &X86InstructionSelector::selectAddr, // gi_addr
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_alignedload = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_alignedstore,
  GICXXPred_MI_Predicate_imm_su,
  GICXXPred_MI_Predicate_loadi8,
  GICXXPred_MI_Predicate_loadi16,
  GICXXPred_MI_Predicate_loadi32,
  GICXXPred_MI_Predicate_or_disjoint,
};
bool X86InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_alignedload: {
    
        auto &LdSt = cast<GLoadStore>(MI);
        return LdSt.getAlign() >= LdSt.getMemSize().getValue();
      
    llvm_unreachable("alignedload should have returned");
  }
  case GICXXPred_MI_Predicate_alignedstore: {
    
        auto &LdSt = cast<GLoadStore>(MI);
        return LdSt.getAlign() >= LdSt.getMemSize().getValue();
      
    llvm_unreachable("alignedstore should have returned");
  }
  case GICXXPred_MI_Predicate_imm_su: {
     return true; 
  }
  case GICXXPred_MI_Predicate_loadi8: {
     return isa<GLoad>(MI); 
  }
  case GICXXPred_MI_Predicate_loadi16: {
    
        auto &Load = cast<GLoad>(MI);
        LLT Ty = MRI.getType(Load.getDstReg());
        // Non extending load has MMO and destination types of the same size
        if (Load.getMemSizeInBits() == Ty.getSizeInBits())
           return true;
        return Load.getAlign() >= 2 && Load.isSimple();
      
    llvm_unreachable("loadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_loadi32: {
    
        auto &Load = cast<GLoad>(MI);
        LLT Ty = MRI.getType(Load.getDstReg());
        // Non extending load has MMO and destination types of the same size
        if (Load.getMemSizeInBits() == Ty.getSizeInBits())
           return true;
        return Load.getAlign() >= 4 && Load.isSimple();
      
    llvm_unreachable("loadi32 should have returned");
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AndMask64 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BTCBTSMask64,
  GICXXPred_I64_Predicate_BTRMask64,
  GICXXPred_I64_Predicate_i16immSExt8,
  GICXXPred_I64_Predicate_i32immSExt8,
  GICXXPred_I64_Predicate_i64immSExt8,
  GICXXPred_I64_Predicate_i64immSExt32,
  GICXXPred_I64_Predicate_i64immZExt32,
  GICXXPred_I64_Predicate_i64immZExt32SExt8,
  GICXXPred_I64_Predicate_i64timmSExt32,
  GICXXPred_I64_Predicate_immff00_ffff,
};
bool X86InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AndMask64: {
    
      return isMask_64(Imm) && !isUInt<32>(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTCBTSMask64: {
    
      return !isInt<32>(Imm) && isPowerOf2_64(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTRMask64: {
    
      return !isUInt<32>(Imm) && !isInt<32>(Imm) && isPowerOf2_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_i16immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32: {
     return isUInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32SExt8: {
    
      return isUInt<32>(Imm) && isInt<8>(static_cast<int32_t>(Imm));
    
  }
  case GICXXPred_I64_Predicate_i64timmSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_immff00_ffff: {
    
      return Imm >= 0xff00 && Imm <= 0xffff;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm1,
  GICXXPred_APFloat_Predicate_fpimmneg0,
  GICXXPred_APFloat_Predicate_fpimmneg1,
};
bool X86InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm1: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg1: {
    
      return Imm.isExactlyValue(-1.0);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool X86InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("X86InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
X86InstructionSelector::CustomRendererFn
X86InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool X86InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool X86InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("X86InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *X86InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(346), /*)*//*default:*//*Label 80*/ GIMT_Encode4(236852),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1182),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(7415),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(10951), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(14734),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(25326),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(33730), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    114 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 6*/ GIMT_Encode4(46431), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 7*/ GIMT_Encode4(46598), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    150 */ /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 8*/ GIMT_Encode4(48888),
     /*    154 */ /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 9*/ GIMT_Encode4(52066), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 10*/ GIMT_Encode4(53286),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 11*/ GIMT_Encode4(59511),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 12*/ GIMT_Encode4(59844), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 13*/ GIMT_Encode4(60499), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 14*/ GIMT_Encode4(85962),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 15*/ GIMT_Encode4(86198), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 16*/ GIMT_Encode4(86446), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 17*/ GIMT_Encode4(86765),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 18*/ GIMT_Encode4(100591), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 19*/ GIMT_Encode4(109666),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 20*/ GIMT_Encode4(110101), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 21*/ GIMT_Encode4(111190),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 22*/ GIMT_Encode4(111796), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 23*/ GIMT_Encode4(112249),
     /*    370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 24*/ GIMT_Encode4(113921),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 25*/ GIMT_Encode4(114163),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 26*/ GIMT_Encode4(116147),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 27*/ GIMT_Encode4(118431),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 28*/ GIMT_Encode4(120475),
     /*    390 */ /*TargetOpcode::G_FSHL*//*Label 29*/ GIMT_Encode4(122519),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 30*/ GIMT_Encode4(123247),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 31*/ GIMT_Encode4(123935),
     /*    402 */ /*TargetOpcode::G_ROTL*//*Label 32*/ GIMT_Encode4(127433),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 33*/ GIMT_Encode4(131153), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 34*/ GIMT_Encode4(132810), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 35*/ GIMT_Encode4(140476),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 36*/ GIMT_Encode4(141341),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 37*/ GIMT_Encode4(142206),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 38*/ GIMT_Encode4(143892),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 39*/ GIMT_Encode4(145578),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 40*/ GIMT_Encode4(146644), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 41*/ GIMT_Encode4(147710),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 42*/ GIMT_Encode4(153624),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 43*/ GIMT_Encode4(157806),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 44*/ GIMT_Encode4(163720), GIMT_Encode4(0),
     /*    550 */ /*TargetOpcode::G_FDIV*//*Label 45*/ GIMT_Encode4(169708), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 46*/ GIMT_Encode4(173890),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 47*/ GIMT_Encode4(174013),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 48*/ GIMT_Encode4(174945),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 49*/ GIMT_Encode4(175331),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 50*/ GIMT_Encode4(176712),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 51*/ GIMT_Encode4(177268),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 52*/ GIMT_Encode4(180644), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 53*/ GIMT_Encode4(182891), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 54*/ GIMT_Encode4(183014),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 55*/ GIMT_Encode4(186335),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 56*/ GIMT_Encode4(189656),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 57*/ GIMT_Encode4(192977),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 58*/ GIMT_Encode4(196298), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 59*/ GIMT_Encode4(198179), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    762 */ /*TargetOpcode::G_EXTRACT_SUBVECTOR*//*Label 60*/ GIMT_Encode4(198195), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    786 */ /*TargetOpcode::G_VECTOR_COMPRESS*//*Label 61*/ GIMT_Encode4(201124),
     /*    790 */ /*TargetOpcode::G_CTTZ*//*Label 62*/ GIMT_Encode4(203106),
     /*    794 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 63*/ GIMT_Encode4(203412),
     /*    798 */ /*TargetOpcode::G_CTLZ*//*Label 64*/ GIMT_Encode4(203799), GIMT_Encode4(0),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 65*/ GIMT_Encode4(205103),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 66*/ GIMT_Encode4(207365), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 67*/ GIMT_Encode4(207865), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 68*/ GIMT_Encode4(210034),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 69*/ GIMT_Encode4(214964),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 70*/ GIMT_Encode4(218654),
     /*    918 */ /*TargetOpcode::G_STRICT_FDIV*//*Label 71*/ GIMT_Encode4(223584), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 72*/ GIMT_Encode4(227274),
     /*    930 */ /*TargetOpcode::G_STRICT_FSQRT*//*Label 73*/ GIMT_Encode4(233262), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    966 */ /*TargetOpcode::G_TRAP*//*Label 74*/ GIMT_Encode4(235431),
     /*    970 */ /*TargetOpcode::G_DEBUGTRAP*//*Label 75*/ GIMT_Encode4(235444),
     /*    974 */ /*TargetOpcode::G_UBSANTRAP*//*Label 76*/ GIMT_Encode4(235480), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1170 */ /*X86::G_FILD*//*Label 77*/ GIMT_Encode4(235496),
     /*   1174 */ /*X86::G_FIST*//*Label 78*/ GIMT_Encode4(235955),
     /*   1178 */ /*X86::G_FNSTCW16*//*Label 79*/ GIMT_Encode4(236819),
     /*   1182 */ // Label 0: @1182
     /*   1182 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 97*/ GIMT_Encode4(7414),
     /*   1193 */ /*GILLT_s8*//*Label 81*/ GIMT_Encode4(1289),
     /*   1197 */ /*GILLT_s16*//*Label 82*/ GIMT_Encode4(1794),
     /*   1201 */ /*GILLT_s32*//*Label 83*/ GIMT_Encode4(2444),
     /*   1205 */ /*GILLT_s64*//*Label 84*/ GIMT_Encode4(3094), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1221 */ /*GILLT_v2s64*//*Label 85*/ GIMT_Encode4(3918), GIMT_Encode4(0),
     /*   1229 */ /*GILLT_v4s32*//*Label 86*/ GIMT_Encode4(4260),
     /*   1233 */ /*GILLT_v4s64*//*Label 87*/ GIMT_Encode4(4724), GIMT_Encode4(0),
     /*   1241 */ /*GILLT_v8s16*//*Label 88*/ GIMT_Encode4(5039),
     /*   1245 */ /*GILLT_v8s32*//*Label 89*/ GIMT_Encode4(5503),
     /*   1249 */ /*GILLT_v8s64*//*Label 90*/ GIMT_Encode4(5818), GIMT_Encode4(0),
     /*   1257 */ /*GILLT_v16s8*//*Label 91*/ GIMT_Encode4(5974),
     /*   1261 */ /*GILLT_v16s16*//*Label 92*/ GIMT_Encode4(6316),
     /*   1265 */ /*GILLT_v16s32*//*Label 93*/ GIMT_Encode4(6631), GIMT_Encode4(0),
     /*   1273 */ /*GILLT_v32s8*//*Label 94*/ GIMT_Encode4(6787),
     /*   1277 */ /*GILLT_v32s16*//*Label 95*/ GIMT_Encode4(7102), GIMT_Encode4(0),
     /*   1285 */ /*GILLT_v64s8*//*Label 96*/ GIMT_Encode4(7258),
     /*   1289 */ // Label 81: @1289
     /*   1289 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1793),
     /*   1294 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*   1297 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*   1300 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1304 */   GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1365), // Rule ID 26054 //
     /*   1309 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1312 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1316 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1320 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1323 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1327 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1331 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1335 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1337 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1344 */     // (add:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (ADD8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1344 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm),
     /*   1347 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1349 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1351 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1355 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1358 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1363 */     GIR_RootConstrainSelectedInstOperands,
     /*   1364 */     // GIR_Coverage, 26054,
     /*   1364 */     GIR_EraseRootFromParent_Done,
     /*   1365 */   // Label 99: @1365
     /*   1365 */   GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1426), // Rule ID 26073 //
     /*   1370 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1373 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1377 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1381 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1384 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1388 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1392 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1396 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1398 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1405 */     // (add:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (ADD8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1405 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm_ND),
     /*   1408 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1410 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1412 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1416 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1419 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1424 */     GIR_RootConstrainSelectedInstOperands,
     /*   1425 */     // GIR_Coverage, 26073,
     /*   1425 */     GIR_EraseRootFromParent_Done,
     /*   1426 */   // Label 100: @1426
     /*   1426 */   GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1487), // Rule ID 22796 //
     /*   1431 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1434 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1438 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1442 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1446 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1449 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1453 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1457 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1459 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1466 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (ADD8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1466 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm),
     /*   1469 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1471 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1473 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1477 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1480 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1485 */     GIR_RootConstrainSelectedInstOperands,
     /*   1486 */     // GIR_Coverage, 22796,
     /*   1486 */     GIR_EraseRootFromParent_Done,
     /*   1487 */   // Label 101: @1487
     /*   1487 */   GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1548), // Rule ID 22886 //
     /*   1492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1495 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1507 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1510 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1514 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1518 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1520 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1527 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (ADD8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1527 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm_ND),
     /*   1530 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1532 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1534 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1538 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1541 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1546 */     GIR_RootConstrainSelectedInstOperands,
     /*   1547 */     // GIR_Coverage, 22886,
     /*   1547 */     GIR_EraseRootFromParent_Done,
     /*   1548 */   // Label 102: @1548
     /*   1548 */   GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1576), // Rule ID 22862 //
     /*   1553 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   1556 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1560 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   1564 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r),
     /*   1567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1569 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1571 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1574 */     GIR_RootConstrainSelectedInstOperands,
     /*   1575 */     // GIR_Coverage, 22862,
     /*   1575 */     GIR_EraseRootFromParent_Done,
     /*   1576 */   // Label 103: @1576
     /*   1576 */   GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1604), // Rule ID 22866 //
     /*   1581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   1584 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1588 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   1592 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1592 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r),
     /*   1595 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1597 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1599 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1602 */     GIR_RootConstrainSelectedInstOperands,
     /*   1603 */     // GIR_Coverage, 22866,
     /*   1603 */     GIR_EraseRootFromParent_Done,
     /*   1604 */   // Label 104: @1604
     /*   1604 */   GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1632), // Rule ID 22952 //
     /*   1609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   1612 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1616 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   1620 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r_ND),
     /*   1623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1625 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1627 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1630 */     GIR_RootConstrainSelectedInstOperands,
     /*   1631 */     // GIR_Coverage, 22952,
     /*   1631 */     GIR_EraseRootFromParent_Done,
     /*   1632 */   // Label 105: @1632
     /*   1632 */   GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1660), // Rule ID 22956 //
     /*   1637 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   1640 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1644 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   1648 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1648 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r_ND),
     /*   1651 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1653 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1655 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1658 */     GIR_RootConstrainSelectedInstOperands,
     /*   1659 */     // GIR_Coverage, 22956,
     /*   1659 */     GIR_EraseRootFromParent_Done,
     /*   1660 */   // Label 106: @1660
     /*   1660 */   GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1697), // Rule ID 22800 //
     /*   1665 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1668 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1672 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1676 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1680 */     // MIs[1] Operand 1
     /*   1680 */     // No operand predicates
     /*   1680 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1682 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   1682 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
     /*   1685 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1687 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1689 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   1692 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1695 */     GIR_RootConstrainSelectedInstOperands,
     /*   1696 */     // GIR_Coverage, 22800,
     /*   1696 */     GIR_EraseRootFromParent_Done,
     /*   1697 */   // Label 107: @1697
     /*   1697 */   GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1734), // Rule ID 22890 //
     /*   1702 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1705 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1709 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1713 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1717 */     // MIs[1] Operand 1
     /*   1717 */     // No operand predicates
     /*   1717 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1719 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   1719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri_ND),
     /*   1722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1724 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1726 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   1729 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1732 */     GIR_RootConstrainSelectedInstOperands,
     /*   1733 */     // GIR_Coverage, 22890,
     /*   1733 */     GIR_EraseRootFromParent_Done,
     /*   1734 */   // Label 108: @1734
     /*   1734 */   GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1763), // Rule ID 22792 //
     /*   1739 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1742 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1746 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1750 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   1750 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr),
     /*   1755 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   1761 */     GIR_RootConstrainSelectedInstOperands,
     /*   1762 */     // GIR_Coverage, 22792,
     /*   1762 */     GIR_Done,
     /*   1763 */   // Label 109: @1763
     /*   1763 */   GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1792), // Rule ID 22882 //
     /*   1768 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1771 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1775 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1779 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   1779 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr_ND),
     /*   1784 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   1790 */     GIR_RootConstrainSelectedInstOperands,
     /*   1791 */     // GIR_Coverage, 22882,
     /*   1791 */     GIR_Done,
     /*   1792 */   // Label 110: @1792
     /*   1792 */   GIM_Reject,
     /*   1793 */ // Label 98: @1793
     /*   1793 */ GIM_Reject,
     /*   1794 */ // Label 82: @1794
     /*   1794 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(2443),
     /*   1799 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*   1802 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*   1805 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1809 */   GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1878), // Rule ID 22617 //
     /*   1814 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1817 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1821 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1825 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1828 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1832 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1836 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   1847 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1849 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1856 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, 128:{ *:[i16] })  =>  (SUB16mi_ND:{ *:[i16] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i16] })
     /*   1856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16mi_ND),
     /*   1859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1861 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   1865 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   1868 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1871 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1876 */     GIR_RootConstrainSelectedInstOperands,
     /*   1877 */     // GIR_Coverage, 22617,
     /*   1877 */     GIR_EraseRootFromParent_Done,
     /*   1878 */   // Label 112: @1878
     /*   1878 */   GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1939), // Rule ID 26055 //
     /*   1883 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1886 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1890 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1894 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1897 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1901 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1905 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1909 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1911 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1918 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (ADD16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1918 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm),
     /*   1921 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1923 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1925 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1929 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1932 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1937 */     GIR_RootConstrainSelectedInstOperands,
     /*   1938 */     // GIR_Coverage, 26055,
     /*   1938 */     GIR_EraseRootFromParent_Done,
     /*   1939 */   // Label 113: @1939
     /*   1939 */   GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(2000), // Rule ID 26074 //
     /*   1944 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1947 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1951 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1955 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1958 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1962 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1966 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1970 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1972 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1979 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (ADD16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1979 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm_ND),
     /*   1982 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1984 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1986 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1990 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1993 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1998 */     GIR_RootConstrainSelectedInstOperands,
     /*   1999 */     // GIR_Coverage, 26074,
     /*   1999 */     GIR_EraseRootFromParent_Done,
     /*   2000 */   // Label 114: @2000
     /*   2000 */   GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2061), // Rule ID 22797 //
     /*   2005 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2008 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2012 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2016 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2020 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2023 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2027 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   2031 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2033 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2040 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (ADD16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2040 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm),
     /*   2043 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2045 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2047 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2051 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2054 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2059 */     GIR_RootConstrainSelectedInstOperands,
     /*   2060 */     // GIR_Coverage, 22797,
     /*   2060 */     GIR_EraseRootFromParent_Done,
     /*   2061 */   // Label 115: @2061
     /*   2061 */   GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2122), // Rule ID 22887 //
     /*   2066 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2069 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2073 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2077 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2081 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2084 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2088 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   2092 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2094 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2101 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (ADD16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2101 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm_ND),
     /*   2104 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2106 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2108 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2112 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2115 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2120 */     GIR_RootConstrainSelectedInstOperands,
     /*   2121 */     // GIR_Coverage, 22887,
     /*   2121 */     GIR_EraseRootFromParent_Done,
     /*   2122 */   // Label 116: @2122
     /*   2122 */   GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2160), // Rule ID 22602 //
     /*   2127 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2130 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2134 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2145 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
     /*   2145 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
     /*   2148 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2150 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2152 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   2155 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2158 */     GIR_RootConstrainSelectedInstOperands,
     /*   2159 */     // GIR_Coverage, 22602,
     /*   2159 */     GIR_EraseRootFromParent_Done,
     /*   2160 */   // Label 117: @2160
     /*   2160 */   GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2198), // Rule ID 22608 //
     /*   2165 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2168 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2172 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2183 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
     /*   2183 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
     /*   2186 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2188 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2190 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   2193 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2196 */     GIR_RootConstrainSelectedInstOperands,
     /*   2197 */     // GIR_Coverage, 22608,
     /*   2197 */     GIR_EraseRootFromParent_Done,
     /*   2198 */   // Label 118: @2198
     /*   2198 */   GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2226), // Rule ID 22863 //
     /*   2203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2206 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2210 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2214 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2214 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r),
     /*   2217 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2219 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2221 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2224 */     GIR_RootConstrainSelectedInstOperands,
     /*   2225 */     // GIR_Coverage, 22863,
     /*   2225 */     GIR_EraseRootFromParent_Done,
     /*   2226 */   // Label 119: @2226
     /*   2226 */   GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2254), // Rule ID 22867 //
     /*   2231 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2234 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2238 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   2242 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r),
     /*   2245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2247 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2249 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2252 */     GIR_RootConstrainSelectedInstOperands,
     /*   2253 */     // GIR_Coverage, 22867,
     /*   2253 */     GIR_EraseRootFromParent_Done,
     /*   2254 */   // Label 120: @2254
     /*   2254 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2282), // Rule ID 22953 //
     /*   2259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2262 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2266 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2270 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2270 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r_ND),
     /*   2273 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2275 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2277 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2280 */     GIR_RootConstrainSelectedInstOperands,
     /*   2281 */     // GIR_Coverage, 22953,
     /*   2281 */     GIR_EraseRootFromParent_Done,
     /*   2282 */   // Label 121: @2282
     /*   2282 */   GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2310), // Rule ID 22957 //
     /*   2287 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2290 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2294 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   2298 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2298 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r_ND),
     /*   2301 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2303 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2305 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2308 */     GIR_RootConstrainSelectedInstOperands,
     /*   2309 */     // GIR_Coverage, 22957,
     /*   2309 */     GIR_EraseRootFromParent_Done,
     /*   2310 */   // Label 122: @2310
     /*   2310 */   GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2347), // Rule ID 22801 //
     /*   2315 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2318 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2322 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2326 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2330 */     // MIs[1] Operand 1
     /*   2330 */     // No operand predicates
     /*   2330 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2332 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   2332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
     /*   2335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2337 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2339 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   2342 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2345 */     GIR_RootConstrainSelectedInstOperands,
     /*   2346 */     // GIR_Coverage, 22801,
     /*   2346 */     GIR_EraseRootFromParent_Done,
     /*   2347 */   // Label 123: @2347
     /*   2347 */   GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2384), // Rule ID 22891 //
     /*   2352 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2355 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2359 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2363 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2367 */     // MIs[1] Operand 1
     /*   2367 */     // No operand predicates
     /*   2367 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2369 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   2369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri_ND),
     /*   2372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2374 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2376 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   2379 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2382 */     GIR_RootConstrainSelectedInstOperands,
     /*   2383 */     // GIR_Coverage, 22891,
     /*   2383 */     GIR_EraseRootFromParent_Done,
     /*   2384 */   // Label 124: @2384
     /*   2384 */   GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2413), // Rule ID 22793 //
     /*   2389 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2392 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2396 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2400 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   2400 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr),
     /*   2405 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   2411 */     GIR_RootConstrainSelectedInstOperands,
     /*   2412 */     // GIR_Coverage, 22793,
     /*   2412 */     GIR_Done,
     /*   2413 */   // Label 125: @2413
     /*   2413 */   GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2442), // Rule ID 22883 //
     /*   2418 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2421 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2425 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2429 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   2429 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr_ND),
     /*   2434 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   2440 */     GIR_RootConstrainSelectedInstOperands,
     /*   2441 */     // GIR_Coverage, 22883,
     /*   2441 */     GIR_Done,
     /*   2442 */   // Label 126: @2442
     /*   2442 */   GIM_Reject,
     /*   2443 */ // Label 111: @2443
     /*   2443 */ GIM_Reject,
     /*   2444 */ // Label 83: @2444
     /*   2444 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(3093),
     /*   2449 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2452 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2455 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2459 */   GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2528), // Rule ID 22618 //
     /*   2464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2467 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2471 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2475 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2478 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2482 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2486 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2497 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2499 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2506 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, 128:{ *:[i32] })  =>  (SUB32mi_ND:{ *:[i32] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i32] })
     /*   2506 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32mi_ND),
     /*   2509 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2511 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   2515 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   2518 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2521 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2526 */     GIR_RootConstrainSelectedInstOperands,
     /*   2527 */     // GIR_Coverage, 22618,
     /*   2527 */     GIR_EraseRootFromParent_Done,
     /*   2528 */   // Label 128: @2528
     /*   2528 */   GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2589), // Rule ID 26056 //
     /*   2533 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2536 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2540 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2544 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2547 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2551 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2555 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2559 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2561 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2568 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (ADD32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm),
     /*   2571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2573 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   2575 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2579 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2582 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2587 */     GIR_RootConstrainSelectedInstOperands,
     /*   2588 */     // GIR_Coverage, 26056,
     /*   2588 */     GIR_EraseRootFromParent_Done,
     /*   2589 */   // Label 129: @2589
     /*   2589 */   GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2650), // Rule ID 26075 //
     /*   2594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2597 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2601 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2605 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2608 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2612 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2616 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2620 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2622 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2629 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (ADD32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2629 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm_ND),
     /*   2632 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2634 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   2636 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2640 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2643 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2648 */     GIR_RootConstrainSelectedInstOperands,
     /*   2649 */     // GIR_Coverage, 26075,
     /*   2649 */     GIR_EraseRootFromParent_Done,
     /*   2650 */   // Label 130: @2650
     /*   2650 */   GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2711), // Rule ID 22798 //
     /*   2655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2658 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2670 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2673 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2677 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2681 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2683 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2690 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ADD32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2690 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm),
     /*   2693 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2695 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2697 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2701 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2704 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2709 */     GIR_RootConstrainSelectedInstOperands,
     /*   2710 */     // GIR_Coverage, 22798,
     /*   2710 */     GIR_EraseRootFromParent_Done,
     /*   2711 */   // Label 131: @2711
     /*   2711 */   GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2772), // Rule ID 22888 //
     /*   2716 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2719 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2723 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2727 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2731 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2734 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2738 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2742 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2744 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2751 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ADD32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2751 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm_ND),
     /*   2754 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2756 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2758 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2762 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2765 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2770 */     GIR_RootConstrainSelectedInstOperands,
     /*   2771 */     // GIR_Coverage, 22888,
     /*   2771 */     GIR_EraseRootFromParent_Done,
     /*   2772 */   // Label 132: @2772
     /*   2772 */   GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2810), // Rule ID 22603 //
     /*   2777 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2780 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2784 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2795 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
     /*   2795 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
     /*   2798 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2800 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2802 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   2805 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2808 */     GIR_RootConstrainSelectedInstOperands,
     /*   2809 */     // GIR_Coverage, 22603,
     /*   2809 */     GIR_EraseRootFromParent_Done,
     /*   2810 */   // Label 133: @2810
     /*   2810 */   GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2848), // Rule ID 22609 //
     /*   2815 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2818 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2822 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2833 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
     /*   2833 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
     /*   2836 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2838 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2840 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   2843 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2846 */     GIR_RootConstrainSelectedInstOperands,
     /*   2847 */     // GIR_Coverage, 22609,
     /*   2847 */     GIR_EraseRootFromParent_Done,
     /*   2848 */   // Label 134: @2848
     /*   2848 */   GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2876), // Rule ID 22864 //
     /*   2853 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2856 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2860 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2864 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2864 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r),
     /*   2867 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2869 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2871 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2874 */     GIR_RootConstrainSelectedInstOperands,
     /*   2875 */     // GIR_Coverage, 22864,
     /*   2875 */     GIR_EraseRootFromParent_Done,
     /*   2876 */   // Label 135: @2876
     /*   2876 */   GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2904), // Rule ID 22868 //
     /*   2881 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2884 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2888 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   2892 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2892 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r),
     /*   2895 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2897 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2899 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2902 */     GIR_RootConstrainSelectedInstOperands,
     /*   2903 */     // GIR_Coverage, 22868,
     /*   2903 */     GIR_EraseRootFromParent_Done,
     /*   2904 */   // Label 136: @2904
     /*   2904 */   GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2932), // Rule ID 22954 //
     /*   2909 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2912 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2916 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2920 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r_ND),
     /*   2923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2925 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2927 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2930 */     GIR_RootConstrainSelectedInstOperands,
     /*   2931 */     // GIR_Coverage, 22954,
     /*   2931 */     GIR_EraseRootFromParent_Done,
     /*   2932 */   // Label 137: @2932
     /*   2932 */   GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2960), // Rule ID 22958 //
     /*   2937 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2940 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2944 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   2948 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2948 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r_ND),
     /*   2951 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2953 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2955 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2958 */     GIR_RootConstrainSelectedInstOperands,
     /*   2959 */     // GIR_Coverage, 22958,
     /*   2959 */     GIR_EraseRootFromParent_Done,
     /*   2960 */   // Label 138: @2960
     /*   2960 */   GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2997), // Rule ID 22802 //
     /*   2965 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2968 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2972 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2976 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2980 */     // MIs[1] Operand 1
     /*   2980 */     // No operand predicates
     /*   2980 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2982 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   2982 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
     /*   2985 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2987 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2989 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   2992 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2995 */     GIR_RootConstrainSelectedInstOperands,
     /*   2996 */     // GIR_Coverage, 22802,
     /*   2996 */     GIR_EraseRootFromParent_Done,
     /*   2997 */   // Label 139: @2997
     /*   2997 */   GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(3034), // Rule ID 22892 //
     /*   3002 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3005 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3009 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3013 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3017 */     // MIs[1] Operand 1
     /*   3017 */     // No operand predicates
     /*   3017 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3019 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   3019 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri_ND),
     /*   3022 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3024 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3026 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3029 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3032 */     GIR_RootConstrainSelectedInstOperands,
     /*   3033 */     // GIR_Coverage, 22892,
     /*   3033 */     GIR_EraseRootFromParent_Done,
     /*   3034 */   // Label 140: @3034
     /*   3034 */   GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(3063), // Rule ID 22794 //
     /*   3039 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3042 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3046 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3050 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   3050 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr),
     /*   3055 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3061 */     GIR_RootConstrainSelectedInstOperands,
     /*   3062 */     // GIR_Coverage, 22794,
     /*   3062 */     GIR_Done,
     /*   3063 */   // Label 141: @3063
     /*   3063 */   GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(3092), // Rule ID 22884 //
     /*   3068 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3071 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3075 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3079 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   3079 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr_ND),
     /*   3084 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3090 */     GIR_RootConstrainSelectedInstOperands,
     /*   3091 */     // GIR_Coverage, 22884,
     /*   3091 */     GIR_Done,
     /*   3092 */   // Label 142: @3092
     /*   3092 */   GIM_Reject,
     /*   3093 */ // Label 127: @3093
     /*   3093 */ GIM_Reject,
     /*   3094 */ // Label 84: @3094
     /*   3094 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(3917),
     /*   3099 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   3102 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   3105 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3109 */   GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(3178), // Rule ID 22619 //
     /*   3114 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3117 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3121 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3125 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3128 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3132 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3136 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3147 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3149 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3156 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_load>>, 128:{ *:[i64] })  =>  (SUB64mi32_ND:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i64] })
     /*   3156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64mi32_ND),
     /*   3159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3161 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   3165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   3168 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3171 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3176 */     GIR_RootConstrainSelectedInstOperands,
     /*   3177 */     // GIR_Coverage, 22619,
     /*   3177 */     GIR_EraseRootFromParent_Done,
     /*   3178 */   // Label 144: @3178
     /*   3178 */   GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(3254), // Rule ID 22625 //
     /*   3183 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3186 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3190 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3194 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3197 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3201 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3205 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3216 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3218 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3225 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_load>>, 2147483648:{ *:[i64] })  =>  (SUB64mi32_ND:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -2147483648:{ *:[i64] })
     /*   3225 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64mi32_ND),
     /*   3228 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3230 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   3234 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
     /*   3244 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3247 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3252 */     GIR_RootConstrainSelectedInstOperands,
     /*   3253 */     // GIR_Coverage, 22625,
     /*   3253 */     GIR_EraseRootFromParent_Done,
     /*   3254 */   // Label 145: @3254
     /*   3254 */   GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(3315), // Rule ID 26057 //
     /*   3259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3262 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3266 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3270 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3273 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3277 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3281 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3285 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3287 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3294 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (ADD64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3294 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm),
     /*   3297 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3299 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3301 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3305 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3308 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3313 */     GIR_RootConstrainSelectedInstOperands,
     /*   3314 */     // GIR_Coverage, 26057,
     /*   3314 */     GIR_EraseRootFromParent_Done,
     /*   3315 */   // Label 146: @3315
     /*   3315 */   GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(3376), // Rule ID 26076 //
     /*   3320 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3323 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3327 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3331 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3334 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3338 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3342 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3346 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3348 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3355 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (ADD64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3355 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm_ND),
     /*   3358 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3360 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3362 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3366 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3369 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3374 */     GIR_RootConstrainSelectedInstOperands,
     /*   3375 */     // GIR_Coverage, 26076,
     /*   3375 */     GIR_EraseRootFromParent_Done,
     /*   3376 */   // Label 147: @3376
     /*   3376 */   GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3437), // Rule ID 22799 //
     /*   3381 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3384 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3388 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3392 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3396 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3399 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3403 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3407 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3409 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3416 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ADD64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3416 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm),
     /*   3419 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3421 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3423 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3427 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3430 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3435 */     GIR_RootConstrainSelectedInstOperands,
     /*   3436 */     // GIR_Coverage, 22799,
     /*   3436 */     GIR_EraseRootFromParent_Done,
     /*   3437 */   // Label 148: @3437
     /*   3437 */   GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3498), // Rule ID 22889 //
     /*   3442 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3445 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3449 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3453 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3457 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3460 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3464 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3468 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3470 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3477 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ADD64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm_ND),
     /*   3480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3482 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3484 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3488 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3491 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3496 */     GIR_RootConstrainSelectedInstOperands,
     /*   3497 */     // GIR_Coverage, 22889,
     /*   3497 */     GIR_EraseRootFromParent_Done,
     /*   3498 */   // Label 149: @3498
     /*   3498 */   GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(3536), // Rule ID 22604 //
     /*   3503 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3506 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3510 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3521 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
     /*   3521 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   3524 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3526 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3528 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   3531 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3534 */     GIR_RootConstrainSelectedInstOperands,
     /*   3535 */     // GIR_Coverage, 22604,
     /*   3535 */     GIR_EraseRootFromParent_Done,
     /*   3536 */   // Label 150: @3536
     /*   3536 */   GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3574), // Rule ID 22610 //
     /*   3541 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3544 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3548 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3559 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
     /*   3559 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   3562 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3564 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3566 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
     /*   3569 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3572 */     GIR_RootConstrainSelectedInstOperands,
     /*   3573 */     // GIR_Coverage, 22610,
     /*   3573 */     GIR_EraseRootFromParent_Done,
     /*   3574 */   // Label 151: @3574
     /*   3574 */   GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(3619), // Rule ID 22620 //
     /*   3579 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3582 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3586 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3597 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
     /*   3597 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   3600 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3602 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3604 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
     /*   3614 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3617 */     GIR_RootConstrainSelectedInstOperands,
     /*   3618 */     // GIR_Coverage, 22620,
     /*   3618 */     GIR_EraseRootFromParent_Done,
     /*   3619 */   // Label 152: @3619
     /*   3619 */   GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3664), // Rule ID 22622 //
     /*   3624 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3627 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3631 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3642 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
     /*   3642 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   3645 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3647 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3649 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
     /*   3659 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3662 */     GIR_RootConstrainSelectedInstOperands,
     /*   3663 */     // GIR_Coverage, 22622,
     /*   3663 */     GIR_EraseRootFromParent_Done,
     /*   3664 */   // Label 153: @3664
     /*   3664 */   GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3692), // Rule ID 22865 //
     /*   3669 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   3672 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3676 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   3680 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3680 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r),
     /*   3683 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3685 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3687 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3690 */     GIR_RootConstrainSelectedInstOperands,
     /*   3691 */     // GIR_Coverage, 22865,
     /*   3691 */     GIR_EraseRootFromParent_Done,
     /*   3692 */   // Label 154: @3692
     /*   3692 */   GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3720), // Rule ID 22869 //
     /*   3697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   3700 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3704 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   3708 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3708 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r),
     /*   3711 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3713 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3715 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3718 */     GIR_RootConstrainSelectedInstOperands,
     /*   3719 */     // GIR_Coverage, 22869,
     /*   3719 */     GIR_EraseRootFromParent_Done,
     /*   3720 */   // Label 155: @3720
     /*   3720 */   GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3748), // Rule ID 22955 //
     /*   3725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   3728 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3732 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   3736 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3736 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r_ND),
     /*   3739 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3741 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3743 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3746 */     GIR_RootConstrainSelectedInstOperands,
     /*   3747 */     // GIR_Coverage, 22955,
     /*   3747 */     GIR_EraseRootFromParent_Done,
     /*   3748 */   // Label 156: @3748
     /*   3748 */   GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3776), // Rule ID 22959 //
     /*   3753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   3756 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3760 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*   3764 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r_ND),
     /*   3767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3769 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3771 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3774 */     GIR_RootConstrainSelectedInstOperands,
     /*   3775 */     // GIR_Coverage, 22959,
     /*   3775 */     GIR_EraseRootFromParent_Done,
     /*   3776 */   // Label 157: @3776
     /*   3776 */   GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3817), // Rule ID 22803 //
     /*   3781 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3784 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3788 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3792 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3796 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   3800 */     // MIs[1] Operand 1
     /*   3800 */     // No operand predicates
     /*   3800 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3802 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   3802 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32),
     /*   3805 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3807 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3809 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3812 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3815 */     GIR_RootConstrainSelectedInstOperands,
     /*   3816 */     // GIR_Coverage, 22803,
     /*   3816 */     GIR_EraseRootFromParent_Done,
     /*   3817 */   // Label 158: @3817
     /*   3817 */   GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3858), // Rule ID 22893 //
     /*   3822 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3825 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3829 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3833 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3837 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   3841 */     // MIs[1] Operand 1
     /*   3841 */     // No operand predicates
     /*   3841 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3843 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   3843 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32_ND),
     /*   3846 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3848 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3850 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3853 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3856 */     GIR_RootConstrainSelectedInstOperands,
     /*   3857 */     // GIR_Coverage, 22893,
     /*   3857 */     GIR_EraseRootFromParent_Done,
     /*   3858 */   // Label 159: @3858
     /*   3858 */   GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3887), // Rule ID 22795 //
     /*   3863 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3866 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3870 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3874 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   3874 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr),
     /*   3879 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3885 */     GIR_RootConstrainSelectedInstOperands,
     /*   3886 */     // GIR_Coverage, 22795,
     /*   3886 */     GIR_Done,
     /*   3887 */   // Label 160: @3887
     /*   3887 */   GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3916), // Rule ID 22885 //
     /*   3892 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3895 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3899 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3903 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   3903 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr_ND),
     /*   3908 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3914 */     GIR_RootConstrainSelectedInstOperands,
     /*   3915 */     // GIR_Coverage, 22885,
     /*   3915 */     GIR_Done,
     /*   3916 */   // Label 161: @3916
     /*   3916 */   GIM_Reject,
     /*   3917 */ // Label 143: @3917
     /*   3917 */ GIM_Reject,
     /*   3918 */ // Label 85: @3918
     /*   3918 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(4259),
     /*   3923 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   3926 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   3929 */   GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3991), // Rule ID 23438 //
     /*   3934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   3937 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   3941 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3945 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3949 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3952 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3956 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3960 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   3964 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3966 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3973 */     // (add:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPADDQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3973 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQrm),
     /*   3976 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3978 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3980 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3984 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3989 */     GIR_RootConstrainSelectedInstOperands,
     /*   3990 */     // GIR_Coverage, 23438,
     /*   3990 */     GIR_EraseRootFromParent_Done,
     /*   3991 */   // Label 163: @3991
     /*   3991 */   GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(4053), // Rule ID 23708 //
     /*   3996 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   3999 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4003 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4007 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4011 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4014 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4018 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4022 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4026 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4028 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4035 */     // (add:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPADDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4035 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rm),
     /*   4038 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4040 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4042 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4046 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4051 */     GIR_RootConstrainSelectedInstOperands,
     /*   4052 */     // GIR_Coverage, 23708,
     /*   4052 */     GIR_EraseRootFromParent_Done,
     /*   4053 */   // Label 164: @4053
     /*   4053 */   GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(4115), // Rule ID 2541 //
     /*   4058 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4061 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4065 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4069 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4073 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4077 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4080 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4084 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4088 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4090 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4097 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4097 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQrm),
     /*   4100 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4102 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4104 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4108 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4113 */     GIR_RootConstrainSelectedInstOperands,
     /*   4114 */     // GIR_Coverage, 2541,
     /*   4114 */     GIR_EraseRootFromParent_Done,
     /*   4115 */   // Label 165: @4115
     /*   4115 */   GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(4177), // Rule ID 4654 //
     /*   4120 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4123 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4127 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4131 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4135 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4139 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4142 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4146 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4150 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4152 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4159 */     // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4159 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rm),
     /*   4162 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4164 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4166 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4170 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4175 */     GIR_RootConstrainSelectedInstOperands,
     /*   4176 */     // GIR_Coverage, 4654,
     /*   4176 */     GIR_EraseRootFromParent_Done,
     /*   4177 */   // Label 166: @4177
     /*   4177 */   GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(4204), // Rule ID 2540 //
     /*   4182 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4185 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4189 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4193 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4197 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   4197 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQrr),
     /*   4202 */     GIR_RootConstrainSelectedInstOperands,
     /*   4203 */     // GIR_Coverage, 2540,
     /*   4203 */     GIR_Done,
     /*   4204 */   // Label 167: @4204
     /*   4204 */   GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(4231), // Rule ID 2542 //
     /*   4209 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   4212 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4216 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4220 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4224 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   4224 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDQrr),
     /*   4229 */     GIR_RootConstrainSelectedInstOperands,
     /*   4230 */     // GIR_Coverage, 2542,
     /*   4230 */     GIR_Done,
     /*   4231 */   // Label 168: @4231
     /*   4231 */   GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(4258), // Rule ID 4651 //
     /*   4236 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4239 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4243 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4247 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4251 */     // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPADDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*   4251 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rr),
     /*   4256 */     GIR_RootConstrainSelectedInstOperands,
     /*   4257 */     // GIR_Coverage, 4651,
     /*   4257 */     GIR_Done,
     /*   4258 */   // Label 169: @4258
     /*   4258 */   GIM_Reject,
     /*   4259 */ // Label 162: @4259
     /*   4259 */ GIM_Reject,
     /*   4260 */ // Label 86: @4260
     /*   4260 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(4723),
     /*   4265 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4268 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4271 */   GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(4333), // Rule ID 23435 //
     /*   4276 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4279 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4283 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4287 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4291 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4294 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4298 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4302 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4306 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4308 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4315 */     // (add:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPADDDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4315 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDrm),
     /*   4318 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4320 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4322 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4326 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4331 */     GIR_RootConstrainSelectedInstOperands,
     /*   4332 */     // GIR_Coverage, 23435,
     /*   4332 */     GIR_EraseRootFromParent_Done,
     /*   4333 */   // Label 171: @4333
     /*   4333 */   GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(4395), // Rule ID 23726 //
     /*   4338 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4341 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4345 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4349 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4353 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4356 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4360 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4364 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4368 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4370 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4377 */     // (add:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPADDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4377 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rm),
     /*   4380 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4382 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4384 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4388 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4393 */     GIR_RootConstrainSelectedInstOperands,
     /*   4394 */     // GIR_Coverage, 23726,
     /*   4394 */     GIR_EraseRootFromParent_Done,
     /*   4395 */   // Label 172: @4395
     /*   4395 */   GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(4457), // Rule ID 2535 //
     /*   4400 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4403 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4407 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4411 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4415 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4419 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4422 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4426 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4430 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4432 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4439 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4439 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDrm),
     /*   4442 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4444 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4446 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4450 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4455 */     GIR_RootConstrainSelectedInstOperands,
     /*   4456 */     // GIR_Coverage, 2535,
     /*   4456 */     GIR_EraseRootFromParent_Done,
     /*   4457 */   // Label 173: @4457
     /*   4457 */   GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(4519), // Rule ID 4681 //
     /*   4462 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4465 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4469 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4473 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4477 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4481 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4484 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4488 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4492 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4494 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4501 */     // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4501 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rm),
     /*   4504 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4506 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4508 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4512 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4517 */     GIR_RootConstrainSelectedInstOperands,
     /*   4518 */     // GIR_Coverage, 4681,
     /*   4518 */     GIR_EraseRootFromParent_Done,
     /*   4519 */   // Label 174: @4519
     /*   4519 */   GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(4580), // Rule ID 17867 //
     /*   4524 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   4527 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4531 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4535 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4539 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4543 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4547 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4552 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4557 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4561 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4563 */     // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2), VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
     /*   4563 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
     /*   4566 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4568 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   4572 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   4576 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   4578 */     GIR_RootConstrainSelectedInstOperands,
     /*   4579 */     // GIR_Coverage, 17867,
     /*   4579 */     GIR_EraseRootFromParent_Done,
     /*   4580 */   // Label 175: @4580
     /*   4580 */   GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(4641), // Rule ID 25190 //
     /*   4585 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   4588 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4592 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4596 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4608 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4612 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4617 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4622 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4624 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src3, (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2))  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
     /*   4624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
     /*   4627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4629 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   4633 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   4637 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   4639 */     GIR_RootConstrainSelectedInstOperands,
     /*   4640 */     // GIR_Coverage, 25190,
     /*   4640 */     GIR_EraseRootFromParent_Done,
     /*   4641 */   // Label 176: @4641
     /*   4641 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(4668), // Rule ID 2534 //
     /*   4646 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4649 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4653 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4657 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4661 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   4661 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDrr),
     /*   4666 */     GIR_RootConstrainSelectedInstOperands,
     /*   4667 */     // GIR_Coverage, 2534,
     /*   4667 */     GIR_Done,
     /*   4668 */   // Label 177: @4668
     /*   4668 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(4695), // Rule ID 2536 //
     /*   4673 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   4676 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4680 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4684 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4688 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   4688 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDDrr),
     /*   4693 */     GIR_RootConstrainSelectedInstOperands,
     /*   4694 */     // GIR_Coverage, 2536,
     /*   4694 */     GIR_Done,
     /*   4695 */   // Label 178: @4695
     /*   4695 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(4722), // Rule ID 4678 //
     /*   4700 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4703 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4707 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4711 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4715 */     // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPADDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*   4715 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rr),
     /*   4720 */     GIR_RootConstrainSelectedInstOperands,
     /*   4721 */     // GIR_Coverage, 4678,
     /*   4721 */     GIR_Done,
     /*   4722 */   // Label 179: @4722
     /*   4722 */   GIM_Reject,
     /*   4723 */ // Label 170: @4723
     /*   4723 */ GIM_Reject,
     /*   4724 */ // Label 87: @4724
     /*   4724 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(5038),
     /*   4729 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*   4732 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*   4735 */   GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(4797), // Rule ID 23440 //
     /*   4740 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   4743 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4747 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4751 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4755 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4758 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4762 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4766 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4770 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4772 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4779 */     // (add:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPADDQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4779 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQYrm),
     /*   4782 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4784 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4786 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4790 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4795 */     GIR_RootConstrainSelectedInstOperands,
     /*   4796 */     // GIR_Coverage, 23440,
     /*   4796 */     GIR_EraseRootFromParent_Done,
     /*   4797 */   // Label 181: @4797
     /*   4797 */   GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(4859), // Rule ID 23702 //
     /*   4802 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4805 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4809 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4813 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4817 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4820 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4824 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4828 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4832 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4834 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4841 */     // (add:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPADDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4841 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rm),
     /*   4844 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4846 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4848 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4852 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4857 */     GIR_RootConstrainSelectedInstOperands,
     /*   4858 */     // GIR_Coverage, 23702,
     /*   4858 */     GIR_EraseRootFromParent_Done,
     /*   4859 */   // Label 182: @4859
     /*   4859 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(4921), // Rule ID 2545 //
     /*   4864 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   4867 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4871 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4875 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4879 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4883 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4886 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4890 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4894 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4896 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4903 */     // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQYrm),
     /*   4906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4908 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4910 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4914 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4919 */     GIR_RootConstrainSelectedInstOperands,
     /*   4920 */     // GIR_Coverage, 2545,
     /*   4920 */     GIR_EraseRootFromParent_Done,
     /*   4921 */   // Label 183: @4921
     /*   4921 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(4983), // Rule ID 4645 //
     /*   4926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4929 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4933 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4937 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4941 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4945 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4948 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4952 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4956 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4958 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4965 */     // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4965 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rm),
     /*   4968 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4970 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4972 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4976 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4981 */     GIR_RootConstrainSelectedInstOperands,
     /*   4982 */     // GIR_Coverage, 4645,
     /*   4982 */     GIR_EraseRootFromParent_Done,
     /*   4983 */   // Label 184: @4983
     /*   4983 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(5010), // Rule ID 2544 //
     /*   4988 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   4991 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4995 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4999 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5003 */     // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPADDQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*   5003 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQYrr),
     /*   5008 */     GIR_RootConstrainSelectedInstOperands,
     /*   5009 */     // GIR_Coverage, 2544,
     /*   5009 */     GIR_Done,
     /*   5010 */   // Label 185: @5010
     /*   5010 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5037), // Rule ID 4642 //
     /*   5015 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5018 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5022 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5026 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5030 */     // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPADDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*   5030 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rr),
     /*   5035 */     GIR_RootConstrainSelectedInstOperands,
     /*   5036 */     // GIR_Coverage, 4642,
     /*   5036 */     GIR_Done,
     /*   5037 */   // Label 186: @5037
     /*   5037 */   GIM_Reject,
     /*   5038 */ // Label 180: @5038
     /*   5038 */ GIM_Reject,
     /*   5039 */ // Label 88: @5039
     /*   5039 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5502),
     /*   5044 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5047 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5050 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(5112), // Rule ID 23432 //
     /*   5055 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5058 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5062 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5066 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5070 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5073 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5077 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5081 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5085 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5087 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5094 */     // (add:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPADDWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5094 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWrm),
     /*   5097 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5099 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5101 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5105 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5110 */     GIR_RootConstrainSelectedInstOperands,
     /*   5111 */     // GIR_Coverage, 23432,
     /*   5111 */     GIR_EraseRootFromParent_Done,
     /*   5112 */   // Label 188: @5112
     /*   5112 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(5174), // Rule ID 23738 //
     /*   5117 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5124 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5128 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5132 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5135 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5139 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5143 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5147 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5149 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5156 */     // (add:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPADDWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rm),
     /*   5159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5161 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5163 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5167 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5172 */     GIR_RootConstrainSelectedInstOperands,
     /*   5173 */     // GIR_Coverage, 23738,
     /*   5173 */     GIR_EraseRootFromParent_Done,
     /*   5174 */   // Label 189: @5174
     /*   5174 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(5236), // Rule ID 2529 //
     /*   5179 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5182 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5186 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5198 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5201 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5205 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5209 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5211 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5218 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5218 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWrm),
     /*   5221 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5223 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5225 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5229 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5234 */     GIR_RootConstrainSelectedInstOperands,
     /*   5235 */     // GIR_Coverage, 2529,
     /*   5235 */     GIR_EraseRootFromParent_Done,
     /*   5236 */   // Label 190: @5236
     /*   5236 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(5298), // Rule ID 4702 //
     /*   5241 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5244 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5248 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5260 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5263 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5267 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5271 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5273 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5280 */     // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5280 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rm),
     /*   5283 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5285 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5287 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5291 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5296 */     GIR_RootConstrainSelectedInstOperands,
     /*   5297 */     // GIR_Coverage, 4702,
     /*   5297 */     GIR_EraseRootFromParent_Done,
     /*   5298 */   // Label 191: @5298
     /*   5298 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(5359), // Rule ID 17866 //
     /*   5303 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   5306 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5310 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5314 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5318 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5322 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5326 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5331 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5336 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5340 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5342 */     // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2), VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
     /*   5342 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
     /*   5345 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5347 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   5351 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   5355 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   5357 */     GIR_RootConstrainSelectedInstOperands,
     /*   5358 */     // GIR_Coverage, 17866,
     /*   5358 */     GIR_EraseRootFromParent_Done,
     /*   5359 */   // Label 192: @5359
     /*   5359 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(5420), // Rule ID 25189 //
     /*   5364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   5367 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5371 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5375 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5379 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5383 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5387 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5391 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5396 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5401 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5403 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src3, (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2))  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
     /*   5403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
     /*   5406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   5412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   5416 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   5418 */     GIR_RootConstrainSelectedInstOperands,
     /*   5419 */     // GIR_Coverage, 25189,
     /*   5419 */     GIR_EraseRootFromParent_Done,
     /*   5420 */   // Label 193: @5420
     /*   5420 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(5447), // Rule ID 2528 //
     /*   5425 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5428 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5432 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5436 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5440 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   5440 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWrr),
     /*   5445 */     GIR_RootConstrainSelectedInstOperands,
     /*   5446 */     // GIR_Coverage, 2528,
     /*   5446 */     GIR_Done,
     /*   5447 */   // Label 194: @5447
     /*   5447 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(5474), // Rule ID 2530 //
     /*   5452 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   5455 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5459 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5463 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5467 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   5467 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDWrr),
     /*   5472 */     GIR_RootConstrainSelectedInstOperands,
     /*   5473 */     // GIR_Coverage, 2530,
     /*   5473 */     GIR_Done,
     /*   5474 */   // Label 195: @5474
     /*   5474 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(5501), // Rule ID 4699 //
     /*   5479 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5482 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5486 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5490 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5494 */     // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPADDWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*   5494 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rr),
     /*   5499 */     GIR_RootConstrainSelectedInstOperands,
     /*   5500 */     // GIR_Coverage, 4699,
     /*   5500 */     GIR_Done,
     /*   5501 */   // Label 196: @5501
     /*   5501 */   GIM_Reject,
     /*   5502 */ // Label 187: @5502
     /*   5502 */ GIM_Reject,
     /*   5503 */ // Label 89: @5503
     /*   5503 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(5817),
     /*   5508 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*   5511 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*   5514 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(5576), // Rule ID 23437 //
     /*   5519 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5522 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5526 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5530 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5534 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5537 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5541 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5545 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5549 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5551 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5558 */     // (add:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPADDDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5558 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDYrm),
     /*   5561 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5563 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5565 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5569 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5574 */     GIR_RootConstrainSelectedInstOperands,
     /*   5575 */     // GIR_Coverage, 23437,
     /*   5575 */     GIR_EraseRootFromParent_Done,
     /*   5576 */   // Label 198: @5576
     /*   5576 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(5638), // Rule ID 23720 //
     /*   5581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5588 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5592 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5596 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5599 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5603 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5607 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5611 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5613 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5620 */     // (add:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPADDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rm),
     /*   5623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5625 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5627 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5631 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5636 */     GIR_RootConstrainSelectedInstOperands,
     /*   5637 */     // GIR_Coverage, 23720,
     /*   5637 */     GIR_EraseRootFromParent_Done,
     /*   5638 */   // Label 199: @5638
     /*   5638 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(5700), // Rule ID 2539 //
     /*   5643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5650 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5654 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5658 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5662 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5665 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5669 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5673 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5675 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5682 */     // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5682 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDYrm),
     /*   5685 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5687 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5689 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5693 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5698 */     GIR_RootConstrainSelectedInstOperands,
     /*   5699 */     // GIR_Coverage, 2539,
     /*   5699 */     GIR_EraseRootFromParent_Done,
     /*   5700 */   // Label 200: @5700
     /*   5700 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(5762), // Rule ID 4672 //
     /*   5705 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5708 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5716 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5720 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5724 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5727 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5731 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5735 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5737 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5744 */     // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5744 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rm),
     /*   5747 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5749 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5751 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5755 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5760 */     GIR_RootConstrainSelectedInstOperands,
     /*   5761 */     // GIR_Coverage, 4672,
     /*   5761 */     GIR_EraseRootFromParent_Done,
     /*   5762 */   // Label 201: @5762
     /*   5762 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(5789), // Rule ID 2538 //
     /*   5767 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5770 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5774 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5778 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5782 */     // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPADDDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*   5782 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDYrr),
     /*   5787 */     GIR_RootConstrainSelectedInstOperands,
     /*   5788 */     // GIR_Coverage, 2538,
     /*   5788 */     GIR_Done,
     /*   5789 */   // Label 202: @5789
     /*   5789 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(5816), // Rule ID 4669 //
     /*   5794 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5797 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5801 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5805 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5809 */     // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPADDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*   5809 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rr),
     /*   5814 */     GIR_RootConstrainSelectedInstOperands,
     /*   5815 */     // GIR_Coverage, 4669,
     /*   5815 */     GIR_Done,
     /*   5816 */   // Label 203: @5816
     /*   5816 */   GIM_Reject,
     /*   5817 */ // Label 197: @5817
     /*   5817 */ GIM_Reject,
     /*   5818 */ // Label 90: @5818
     /*   5818 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(5973),
     /*   5823 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*   5826 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*   5829 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5833 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(5891), // Rule ID 23696 //
     /*   5838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5841 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5845 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5849 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5852 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5856 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5860 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5864 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5866 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5873 */     // (add:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPADDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5873 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZrm),
     /*   5876 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5878 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5880 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5884 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5889 */     GIR_RootConstrainSelectedInstOperands,
     /*   5890 */     // GIR_Coverage, 23696,
     /*   5890 */     GIR_EraseRootFromParent_Done,
     /*   5891 */   // Label 205: @5891
     /*   5891 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(5949), // Rule ID 4636 //
     /*   5896 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5899 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5903 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5907 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5911 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5914 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5918 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5922 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5924 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5931 */     // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5931 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZrm),
     /*   5934 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5936 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5938 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5942 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5947 */     GIR_RootConstrainSelectedInstOperands,
     /*   5948 */     // GIR_Coverage, 4636,
     /*   5948 */     GIR_EraseRootFromParent_Done,
     /*   5949 */   // Label 206: @5949
     /*   5949 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(5972), // Rule ID 4633 //
     /*   5954 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5957 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5961 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5965 */     // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPADDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*   5965 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZrr),
     /*   5970 */     GIR_RootConstrainSelectedInstOperands,
     /*   5971 */     // GIR_Coverage, 4633,
     /*   5971 */     GIR_Done,
     /*   5972 */   // Label 207: @5972
     /*   5972 */   GIM_Reject,
     /*   5973 */ // Label 204: @5973
     /*   5973 */ GIM_Reject,
     /*   5974 */ // Label 91: @5974
     /*   5974 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(6315),
     /*   5979 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   5982 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   5985 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(6047), // Rule ID 23429 //
     /*   5990 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5993 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5997 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6001 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6005 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6008 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6012 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6016 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6020 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6022 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6029 */     // (add:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPADDBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6029 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBrm),
     /*   6032 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6034 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6036 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6040 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6045 */     GIR_RootConstrainSelectedInstOperands,
     /*   6046 */     // GIR_Coverage, 23429,
     /*   6046 */     GIR_EraseRootFromParent_Done,
     /*   6047 */   // Label 209: @6047
     /*   6047 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(6109), // Rule ID 23747 //
     /*   6052 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6055 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6059 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6063 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6067 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6070 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6074 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6078 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6082 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6084 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6091 */     // (add:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPADDBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6091 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rm),
     /*   6094 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6096 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6098 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6102 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6107 */     GIR_RootConstrainSelectedInstOperands,
     /*   6108 */     // GIR_Coverage, 23747,
     /*   6108 */     GIR_EraseRootFromParent_Done,
     /*   6109 */   // Label 210: @6109
     /*   6109 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(6171), // Rule ID 2523 //
     /*   6114 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   6117 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6121 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6125 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6129 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6133 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6136 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6140 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6144 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6146 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6153 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6153 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBrm),
     /*   6156 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6158 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6160 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6164 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6169 */     GIR_RootConstrainSelectedInstOperands,
     /*   6170 */     // GIR_Coverage, 2523,
     /*   6170 */     GIR_EraseRootFromParent_Done,
     /*   6171 */   // Label 211: @6171
     /*   6171 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(6233), // Rule ID 4720 //
     /*   6176 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6179 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6183 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6187 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6191 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6195 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6198 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6202 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6206 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6208 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6215 */     // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6215 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rm),
     /*   6218 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6220 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6222 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6226 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6231 */     GIR_RootConstrainSelectedInstOperands,
     /*   6232 */     // GIR_Coverage, 4720,
     /*   6232 */     GIR_EraseRootFromParent_Done,
     /*   6233 */   // Label 212: @6233
     /*   6233 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(6260), // Rule ID 2522 //
     /*   6238 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   6241 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6245 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6249 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6253 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*   6253 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBrr),
     /*   6258 */     GIR_RootConstrainSelectedInstOperands,
     /*   6259 */     // GIR_Coverage, 2522,
     /*   6259 */     GIR_Done,
     /*   6260 */   // Label 213: @6260
     /*   6260 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(6287), // Rule ID 2524 //
     /*   6265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   6268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6272 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6276 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6280 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*   6280 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDBrr),
     /*   6285 */     GIR_RootConstrainSelectedInstOperands,
     /*   6286 */     // GIR_Coverage, 2524,
     /*   6286 */     GIR_Done,
     /*   6287 */   // Label 214: @6287
     /*   6287 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(6314), // Rule ID 4717 //
     /*   6292 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6295 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6299 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6303 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6307 */     // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPADDBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*   6307 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rr),
     /*   6312 */     GIR_RootConstrainSelectedInstOperands,
     /*   6313 */     // GIR_Coverage, 4717,
     /*   6313 */     GIR_Done,
     /*   6314 */   // Label 215: @6314
     /*   6314 */   GIM_Reject,
     /*   6315 */ // Label 208: @6315
     /*   6315 */ GIM_Reject,
     /*   6316 */ // Label 92: @6316
     /*   6316 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(6630),
     /*   6321 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*   6324 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*   6327 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(6389), // Rule ID 23434 //
     /*   6332 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6335 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6339 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6343 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6347 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6350 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6354 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6358 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6362 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6364 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6371 */     // (add:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPADDWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6371 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWYrm),
     /*   6374 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6376 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6378 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6382 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6387 */     GIR_RootConstrainSelectedInstOperands,
     /*   6388 */     // GIR_Coverage, 23434,
     /*   6388 */     GIR_EraseRootFromParent_Done,
     /*   6389 */   // Label 217: @6389
     /*   6389 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(6451), // Rule ID 23735 //
     /*   6394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6409 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6412 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6416 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6424 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6426 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6433 */     // (add:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPADDWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6433 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rm),
     /*   6436 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6438 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6440 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6444 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6449 */     GIR_RootConstrainSelectedInstOperands,
     /*   6450 */     // GIR_Coverage, 23735,
     /*   6450 */     GIR_EraseRootFromParent_Done,
     /*   6451 */   // Label 218: @6451
     /*   6451 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(6513), // Rule ID 2533 //
     /*   6456 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6459 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6463 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6467 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6471 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6475 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6478 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6482 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6486 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6488 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6495 */     // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6495 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWYrm),
     /*   6498 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6500 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6502 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6506 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6511 */     GIR_RootConstrainSelectedInstOperands,
     /*   6512 */     // GIR_Coverage, 2533,
     /*   6512 */     GIR_EraseRootFromParent_Done,
     /*   6513 */   // Label 219: @6513
     /*   6513 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(6575), // Rule ID 4696 //
     /*   6518 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6521 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6525 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6529 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6533 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6537 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6540 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6544 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6548 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6550 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6557 */     // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6557 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rm),
     /*   6560 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6562 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6564 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6568 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6573 */     GIR_RootConstrainSelectedInstOperands,
     /*   6574 */     // GIR_Coverage, 4696,
     /*   6574 */     GIR_EraseRootFromParent_Done,
     /*   6575 */   // Label 220: @6575
     /*   6575 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(6602), // Rule ID 2532 //
     /*   6580 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6583 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6587 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6591 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6595 */     // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPADDWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*   6595 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWYrr),
     /*   6600 */     GIR_RootConstrainSelectedInstOperands,
     /*   6601 */     // GIR_Coverage, 2532,
     /*   6601 */     GIR_Done,
     /*   6602 */   // Label 221: @6602
     /*   6602 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(6629), // Rule ID 4693 //
     /*   6607 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6610 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6614 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6618 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6622 */     // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPADDWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*   6622 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rr),
     /*   6627 */     GIR_RootConstrainSelectedInstOperands,
     /*   6628 */     // GIR_Coverage, 4693,
     /*   6628 */     GIR_Done,
     /*   6629 */   // Label 222: @6629
     /*   6629 */   GIM_Reject,
     /*   6630 */ // Label 216: @6630
     /*   6630 */ GIM_Reject,
     /*   6631 */ // Label 93: @6631
     /*   6631 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(6786),
     /*   6636 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*   6639 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*   6642 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6646 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(6704), // Rule ID 23714 //
     /*   6651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6654 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6658 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6662 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6665 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6669 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6673 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6677 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6679 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6686 */     // (add:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPADDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6686 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZrm),
     /*   6689 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6691 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6693 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6697 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6702 */     GIR_RootConstrainSelectedInstOperands,
     /*   6703 */     // GIR_Coverage, 23714,
     /*   6703 */     GIR_EraseRootFromParent_Done,
     /*   6704 */   // Label 224: @6704
     /*   6704 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(6762), // Rule ID 4663 //
     /*   6709 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6716 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6720 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6724 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6727 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6731 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6735 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6737 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6744 */     // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6744 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZrm),
     /*   6747 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6749 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6751 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6755 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6760 */     GIR_RootConstrainSelectedInstOperands,
     /*   6761 */     // GIR_Coverage, 4663,
     /*   6761 */     GIR_EraseRootFromParent_Done,
     /*   6762 */   // Label 225: @6762
     /*   6762 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(6785), // Rule ID 4660 //
     /*   6767 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6770 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6774 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6778 */     // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPADDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*   6778 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZrr),
     /*   6783 */     GIR_RootConstrainSelectedInstOperands,
     /*   6784 */     // GIR_Coverage, 4660,
     /*   6784 */     GIR_Done,
     /*   6785 */   // Label 226: @6785
     /*   6785 */   GIM_Reject,
     /*   6786 */ // Label 223: @6786
     /*   6786 */ GIM_Reject,
     /*   6787 */ // Label 94: @6787
     /*   6787 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(7101),
     /*   6792 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*   6795 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*   6798 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(6860), // Rule ID 23431 //
     /*   6803 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6806 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6810 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6814 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6818 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6821 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6825 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6829 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6833 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6835 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6842 */     // (add:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VPADDBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6842 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBYrm),
     /*   6845 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6847 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6849 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6853 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6858 */     GIR_RootConstrainSelectedInstOperands,
     /*   6859 */     // GIR_Coverage, 23431,
     /*   6859 */     GIR_EraseRootFromParent_Done,
     /*   6860 */   // Label 228: @6860
     /*   6860 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(6922), // Rule ID 23744 //
     /*   6865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6872 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6876 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6880 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6883 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6887 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6891 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6895 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6897 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6904 */     // (add:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v32i8] }:$src1)  =>  (VPADDBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6904 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rm),
     /*   6907 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6909 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6911 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6915 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6920 */     GIR_RootConstrainSelectedInstOperands,
     /*   6921 */     // GIR_Coverage, 23744,
     /*   6921 */     GIR_EraseRootFromParent_Done,
     /*   6922 */   // Label 229: @6922
     /*   6922 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(6984), // Rule ID 2527 //
     /*   6927 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6930 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6934 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6946 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6949 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6953 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6957 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6959 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6966 */     // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6966 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBYrm),
     /*   6969 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6971 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6973 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6977 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6982 */     GIR_RootConstrainSelectedInstOperands,
     /*   6983 */     // GIR_Coverage, 2527,
     /*   6983 */     GIR_EraseRootFromParent_Done,
     /*   6984 */   // Label 230: @6984
     /*   6984 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(7046), // Rule ID 4714 //
     /*   6989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6992 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6996 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7008 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7011 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7015 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7019 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7021 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7028 */     // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7028 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rm),
     /*   7031 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7033 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7035 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7039 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7044 */     GIR_RootConstrainSelectedInstOperands,
     /*   7045 */     // GIR_Coverage, 4714,
     /*   7045 */     GIR_EraseRootFromParent_Done,
     /*   7046 */   // Label 231: @7046
     /*   7046 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(7073), // Rule ID 2526 //
     /*   7051 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   7054 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7058 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7062 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7066 */     // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPADDBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*   7066 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBYrr),
     /*   7071 */     GIR_RootConstrainSelectedInstOperands,
     /*   7072 */     // GIR_Coverage, 2526,
     /*   7072 */     GIR_Done,
     /*   7073 */   // Label 232: @7073
     /*   7073 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(7100), // Rule ID 4711 //
     /*   7078 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   7081 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7085 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7089 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7093 */     // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPADDBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*   7093 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rr),
     /*   7098 */     GIR_RootConstrainSelectedInstOperands,
     /*   7099 */     // GIR_Coverage, 4711,
     /*   7099 */     GIR_Done,
     /*   7100 */   // Label 233: @7100
     /*   7100 */   GIM_Reject,
     /*   7101 */ // Label 227: @7101
     /*   7101 */ GIM_Reject,
     /*   7102 */ // Label 95: @7102
     /*   7102 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(7257),
     /*   7107 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*   7110 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*   7113 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7117 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(7175), // Rule ID 23732 //
     /*   7122 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7125 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7129 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7133 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7136 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7140 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7144 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7148 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7150 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7157 */     // (add:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPADDWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZrm),
     /*   7160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7162 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7164 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7168 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7173 */     GIR_RootConstrainSelectedInstOperands,
     /*   7174 */     // GIR_Coverage, 23732,
     /*   7174 */     GIR_EraseRootFromParent_Done,
     /*   7175 */   // Label 235: @7175
     /*   7175 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(7233), // Rule ID 4690 //
     /*   7180 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7183 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7187 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7191 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7195 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7198 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7202 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7206 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7208 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7215 */     // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7215 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZrm),
     /*   7218 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7220 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7222 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7226 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7231 */     GIR_RootConstrainSelectedInstOperands,
     /*   7232 */     // GIR_Coverage, 4690,
     /*   7232 */     GIR_EraseRootFromParent_Done,
     /*   7233 */   // Label 236: @7233
     /*   7233 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(7256), // Rule ID 4687 //
     /*   7238 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7241 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7245 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7249 */     // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPADDWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*   7249 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZrr),
     /*   7254 */     GIR_RootConstrainSelectedInstOperands,
     /*   7255 */     // GIR_Coverage, 4687,
     /*   7255 */     GIR_Done,
     /*   7256 */   // Label 237: @7256
     /*   7256 */   GIM_Reject,
     /*   7257 */ // Label 234: @7257
     /*   7257 */ GIM_Reject,
     /*   7258 */ // Label 96: @7258
     /*   7258 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(7413),
     /*   7263 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*   7266 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*   7269 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7273 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(7331), // Rule ID 23741 //
     /*   7278 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7281 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7285 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7289 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7292 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7296 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7300 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7304 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7306 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7313 */     // (add:{ *:[v64i8] } (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v64i8] }:$src1)  =>  (VPADDBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7313 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZrm),
     /*   7316 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7318 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7320 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7324 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7329 */     GIR_RootConstrainSelectedInstOperands,
     /*   7330 */     // GIR_Coverage, 23741,
     /*   7330 */     GIR_EraseRootFromParent_Done,
     /*   7331 */   // Label 239: @7331
     /*   7331 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(7389), // Rule ID 4708 //
     /*   7336 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7339 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7343 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7347 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7351 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7354 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7358 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7362 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7364 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7371 */     // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7371 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZrm),
     /*   7374 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7376 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7378 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7382 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7387 */     GIR_RootConstrainSelectedInstOperands,
     /*   7388 */     // GIR_Coverage, 4708,
     /*   7388 */     GIR_EraseRootFromParent_Done,
     /*   7389 */   // Label 240: @7389
     /*   7389 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(7412), // Rule ID 4705 //
     /*   7394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7401 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7405 */     // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPADDBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*   7405 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZrr),
     /*   7410 */     GIR_RootConstrainSelectedInstOperands,
     /*   7411 */     // GIR_Coverage, 4705,
     /*   7411 */     GIR_Done,
     /*   7412 */   // Label 241: @7412
     /*   7412 */   GIM_Reject,
     /*   7413 */ // Label 238: @7413
     /*   7413 */ GIM_Reject,
     /*   7414 */ // Label 97: @7414
     /*   7414 */ GIM_Reject,
     /*   7415 */ // Label 1: @7415
     /*   7415 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 258*/ GIMT_Encode4(10950),
     /*   7426 */ /*GILLT_s8*//*Label 242*/ GIMT_Encode4(7522),
     /*   7430 */ /*GILLT_s16*//*Label 243*/ GIMT_Encode4(7874),
     /*   7434 */ /*GILLT_s32*//*Label 244*/ GIMT_Encode4(8226),
     /*   7438 */ /*GILLT_s64*//*Label 245*/ GIMT_Encode4(8578), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   7454 */ /*GILLT_v2s64*//*Label 246*/ GIMT_Encode4(8938), GIMT_Encode4(0),
     /*   7462 */ /*GILLT_v4s32*//*Label 247*/ GIMT_Encode4(9156),
     /*   7466 */ /*GILLT_v4s64*//*Label 248*/ GIMT_Encode4(9374), GIMT_Encode4(0),
     /*   7474 */ /*GILLT_v8s16*//*Label 249*/ GIMT_Encode4(9565),
     /*   7478 */ /*GILLT_v8s32*//*Label 250*/ GIMT_Encode4(9783),
     /*   7482 */ /*GILLT_v8s64*//*Label 251*/ GIMT_Encode4(9974), GIMT_Encode4(0),
     /*   7490 */ /*GILLT_v16s8*//*Label 252*/ GIMT_Encode4(10068),
     /*   7494 */ /*GILLT_v16s16*//*Label 253*/ GIMT_Encode4(10286),
     /*   7498 */ /*GILLT_v16s32*//*Label 254*/ GIMT_Encode4(10477), GIMT_Encode4(0),
     /*   7506 */ /*GILLT_v32s8*//*Label 255*/ GIMT_Encode4(10571),
     /*   7510 */ /*GILLT_v32s16*//*Label 256*/ GIMT_Encode4(10762), GIMT_Encode4(0),
     /*   7518 */ /*GILLT_v64s8*//*Label 257*/ GIMT_Encode4(10856),
     /*   7522 */ // Label 242: @7522
     /*   7522 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(7873),
     /*   7527 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*   7530 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*   7533 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7537 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(7598), // Rule ID 22808 //
     /*   7542 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7545 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7549 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7553 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7557 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7560 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7564 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   7568 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7570 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7577 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (SUB8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7577 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8rm),
     /*   7580 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7582 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7584 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7588 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7591 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7596 */     GIR_RootConstrainSelectedInstOperands,
     /*   7597 */     // GIR_Coverage, 22808,
     /*   7597 */     GIR_EraseRootFromParent_Done,
     /*   7598 */   // Label 260: @7598
     /*   7598 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(7659), // Rule ID 22898 //
     /*   7603 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7606 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7610 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7614 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7618 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7621 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7625 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   7629 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7631 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7638 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (SUB8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8rm_ND),
     /*   7641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7643 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7645 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7649 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7652 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7657 */     GIR_RootConstrainSelectedInstOperands,
     /*   7658 */     // GIR_Coverage, 22898,
     /*   7658 */     GIR_EraseRootFromParent_Done,
     /*   7659 */   // Label 261: @7659
     /*   7659 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(7687), // Rule ID 241 //
     /*   7664 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7667 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7671 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7675 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
     /*   7675 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r),
     /*   7678 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7680 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7682 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7685 */     GIR_RootConstrainSelectedInstOperands,
     /*   7686 */     // GIR_Coverage, 241,
     /*   7686 */     GIR_EraseRootFromParent_Done,
     /*   7687 */   // Label 262: @7687
     /*   7687 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(7715), // Rule ID 249 //
     /*   7692 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   7695 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7699 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7703 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
     /*   7703 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_ND),
     /*   7706 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7708 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7710 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7713 */     GIR_RootConstrainSelectedInstOperands,
     /*   7714 */     // GIR_Coverage, 249,
     /*   7714 */     GIR_EraseRootFromParent_Done,
     /*   7715 */   // Label 263: @7715
     /*   7715 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(7740), // Rule ID 257 //
     /*   7720 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   7723 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7727 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7731 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_NF_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
     /*   7731 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_NF_ND),
     /*   7734 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7736 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7738 */     GIR_RootConstrainSelectedInstOperands,
     /*   7739 */     // GIR_Coverage, 257,
     /*   7739 */     GIR_EraseRootFromParent_Done,
     /*   7740 */   // Label 264: @7740
     /*   7740 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(7777), // Rule ID 22812 //
     /*   7745 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7748 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7752 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7756 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7760 */     // MIs[1] Operand 1
     /*   7760 */     // No operand predicates
     /*   7760 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7762 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   7762 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri),
     /*   7765 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7767 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7769 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   7772 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7775 */     GIR_RootConstrainSelectedInstOperands,
     /*   7776 */     // GIR_Coverage, 22812,
     /*   7776 */     GIR_EraseRootFromParent_Done,
     /*   7777 */   // Label 265: @7777
     /*   7777 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(7814), // Rule ID 22902 //
     /*   7782 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7785 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7789 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7793 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7797 */     // MIs[1] Operand 1
     /*   7797 */     // No operand predicates
     /*   7797 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7799 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   7799 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri_ND),
     /*   7802 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7804 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7806 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   7809 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7812 */     GIR_RootConstrainSelectedInstOperands,
     /*   7813 */     // GIR_Coverage, 22902,
     /*   7813 */     GIR_EraseRootFromParent_Done,
     /*   7814 */   // Label 266: @7814
     /*   7814 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(7843), // Rule ID 22804 //
     /*   7819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7822 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7826 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7830 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   7830 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr),
     /*   7835 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   7841 */     GIR_RootConstrainSelectedInstOperands,
     /*   7842 */     // GIR_Coverage, 22804,
     /*   7842 */     GIR_Done,
     /*   7843 */   // Label 267: @7843
     /*   7843 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(7872), // Rule ID 22894 //
     /*   7848 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7851 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7855 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7859 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   7859 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr_ND),
     /*   7864 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   7870 */     GIR_RootConstrainSelectedInstOperands,
     /*   7871 */     // GIR_Coverage, 22894,
     /*   7871 */     GIR_Done,
     /*   7872 */   // Label 268: @7872
     /*   7872 */   GIM_Reject,
     /*   7873 */ // Label 259: @7873
     /*   7873 */ GIM_Reject,
     /*   7874 */ // Label 243: @7874
     /*   7874 */ GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(8225),
     /*   7879 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*   7882 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*   7885 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7889 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(7950), // Rule ID 22809 //
     /*   7894 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7897 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7901 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7905 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7909 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7912 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7916 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   7920 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7922 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7929 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (SUB16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7929 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16rm),
     /*   7932 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7934 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7936 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7940 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7943 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7948 */     GIR_RootConstrainSelectedInstOperands,
     /*   7949 */     // GIR_Coverage, 22809,
     /*   7949 */     GIR_EraseRootFromParent_Done,
     /*   7950 */   // Label 270: @7950
     /*   7950 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(8011), // Rule ID 22899 //
     /*   7955 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7958 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7962 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7966 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7970 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7973 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7977 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   7981 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7983 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7990 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (SUB16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7990 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16rm_ND),
     /*   7993 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7995 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7997 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8001 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8004 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8009 */     GIR_RootConstrainSelectedInstOperands,
     /*   8010 */     // GIR_Coverage, 22899,
     /*   8010 */     GIR_EraseRootFromParent_Done,
     /*   8011 */   // Label 271: @8011
     /*   8011 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(8039), // Rule ID 242 //
     /*   8016 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8019 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8023 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8027 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
     /*   8027 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r),
     /*   8030 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8032 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8034 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8037 */     GIR_RootConstrainSelectedInstOperands,
     /*   8038 */     // GIR_Coverage, 242,
     /*   8038 */     GIR_EraseRootFromParent_Done,
     /*   8039 */   // Label 272: @8039
     /*   8039 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(8067), // Rule ID 250 //
     /*   8044 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8047 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8051 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8055 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
     /*   8055 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_ND),
     /*   8058 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8060 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8062 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8065 */     GIR_RootConstrainSelectedInstOperands,
     /*   8066 */     // GIR_Coverage, 250,
     /*   8066 */     GIR_EraseRootFromParent_Done,
     /*   8067 */   // Label 273: @8067
     /*   8067 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(8092), // Rule ID 258 //
     /*   8072 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8075 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8079 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8083 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_NF_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
     /*   8083 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_NF_ND),
     /*   8086 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8088 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8090 */     GIR_RootConstrainSelectedInstOperands,
     /*   8091 */     // GIR_Coverage, 258,
     /*   8091 */     GIR_EraseRootFromParent_Done,
     /*   8092 */   // Label 274: @8092
     /*   8092 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(8129), // Rule ID 22813 //
     /*   8097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8100 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8112 */     // MIs[1] Operand 1
     /*   8112 */     // No operand predicates
     /*   8112 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8114 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   8114 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
     /*   8117 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8119 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8121 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8124 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8127 */     GIR_RootConstrainSelectedInstOperands,
     /*   8128 */     // GIR_Coverage, 22813,
     /*   8128 */     GIR_EraseRootFromParent_Done,
     /*   8129 */   // Label 275: @8129
     /*   8129 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(8166), // Rule ID 22903 //
     /*   8134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8137 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8141 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8145 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8149 */     // MIs[1] Operand 1
     /*   8149 */     // No operand predicates
     /*   8149 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8151 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   8151 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
     /*   8154 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8156 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8158 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8161 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8164 */     GIR_RootConstrainSelectedInstOperands,
     /*   8165 */     // GIR_Coverage, 22903,
     /*   8165 */     GIR_EraseRootFromParent_Done,
     /*   8166 */   // Label 276: @8166
     /*   8166 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(8195), // Rule ID 22805 //
     /*   8171 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8174 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8178 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8182 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   8182 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr),
     /*   8187 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8193 */     GIR_RootConstrainSelectedInstOperands,
     /*   8194 */     // GIR_Coverage, 22805,
     /*   8194 */     GIR_Done,
     /*   8195 */   // Label 277: @8195
     /*   8195 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(8224), // Rule ID 22895 //
     /*   8200 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8203 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8207 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8211 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   8211 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr_ND),
     /*   8216 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8222 */     GIR_RootConstrainSelectedInstOperands,
     /*   8223 */     // GIR_Coverage, 22895,
     /*   8223 */     GIR_Done,
     /*   8224 */   // Label 278: @8224
     /*   8224 */   GIM_Reject,
     /*   8225 */ // Label 269: @8225
     /*   8225 */ GIM_Reject,
     /*   8226 */ // Label 244: @8226
     /*   8226 */ GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(8577),
     /*   8231 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   8234 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   8237 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8241 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(8302), // Rule ID 22810 //
     /*   8246 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8249 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8253 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8257 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8261 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8264 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8268 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   8272 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8274 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8281 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (SUB32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8281 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32rm),
     /*   8284 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8286 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8288 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8292 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8295 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8300 */     GIR_RootConstrainSelectedInstOperands,
     /*   8301 */     // GIR_Coverage, 22810,
     /*   8301 */     GIR_EraseRootFromParent_Done,
     /*   8302 */   // Label 280: @8302
     /*   8302 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(8363), // Rule ID 22900 //
     /*   8307 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8310 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8314 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8318 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8322 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8325 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8329 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   8333 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8335 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8342 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (SUB32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8342 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32rm_ND),
     /*   8345 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8347 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8349 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8353 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8356 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8361 */     GIR_RootConstrainSelectedInstOperands,
     /*   8362 */     // GIR_Coverage, 22900,
     /*   8362 */     GIR_EraseRootFromParent_Done,
     /*   8363 */   // Label 281: @8363
     /*   8363 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(8391), // Rule ID 243 //
     /*   8368 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8371 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8375 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8379 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8379 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r),
     /*   8382 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8384 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8386 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8389 */     GIR_RootConstrainSelectedInstOperands,
     /*   8390 */     // GIR_Coverage, 243,
     /*   8390 */     GIR_EraseRootFromParent_Done,
     /*   8391 */   // Label 282: @8391
     /*   8391 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(8419), // Rule ID 251 //
     /*   8396 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8399 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8403 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8407 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8407 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_ND),
     /*   8410 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8412 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8414 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8417 */     GIR_RootConstrainSelectedInstOperands,
     /*   8418 */     // GIR_Coverage, 251,
     /*   8418 */     GIR_EraseRootFromParent_Done,
     /*   8419 */   // Label 283: @8419
     /*   8419 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(8444), // Rule ID 259 //
     /*   8424 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8427 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8431 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8435 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_NF_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8435 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_NF_ND),
     /*   8438 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8440 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8442 */     GIR_RootConstrainSelectedInstOperands,
     /*   8443 */     // GIR_Coverage, 259,
     /*   8443 */     GIR_EraseRootFromParent_Done,
     /*   8444 */   // Label 284: @8444
     /*   8444 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(8481), // Rule ID 22814 //
     /*   8449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8452 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8464 */     // MIs[1] Operand 1
     /*   8464 */     // No operand predicates
     /*   8464 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8466 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   8466 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
     /*   8469 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8471 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8473 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8476 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8479 */     GIR_RootConstrainSelectedInstOperands,
     /*   8480 */     // GIR_Coverage, 22814,
     /*   8480 */     GIR_EraseRootFromParent_Done,
     /*   8481 */   // Label 285: @8481
     /*   8481 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(8518), // Rule ID 22904 //
     /*   8486 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8489 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8493 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8497 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8501 */     // MIs[1] Operand 1
     /*   8501 */     // No operand predicates
     /*   8501 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8503 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   8503 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
     /*   8506 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8508 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8510 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8513 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8516 */     GIR_RootConstrainSelectedInstOperands,
     /*   8517 */     // GIR_Coverage, 22904,
     /*   8517 */     GIR_EraseRootFromParent_Done,
     /*   8518 */   // Label 286: @8518
     /*   8518 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(8547), // Rule ID 22806 //
     /*   8523 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8526 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8530 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8534 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   8534 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr),
     /*   8539 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8545 */     GIR_RootConstrainSelectedInstOperands,
     /*   8546 */     // GIR_Coverage, 22806,
     /*   8546 */     GIR_Done,
     /*   8547 */   // Label 287: @8547
     /*   8547 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(8576), // Rule ID 22896 //
     /*   8552 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8555 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8559 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8563 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   8563 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr_ND),
     /*   8568 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8574 */     GIR_RootConstrainSelectedInstOperands,
     /*   8575 */     // GIR_Coverage, 22896,
     /*   8575 */     GIR_Done,
     /*   8576 */   // Label 288: @8576
     /*   8576 */   GIM_Reject,
     /*   8577 */ // Label 279: @8577
     /*   8577 */ GIM_Reject,
     /*   8578 */ // Label 245: @8578
     /*   8578 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(8937),
     /*   8583 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   8586 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   8589 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8593 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(8654), // Rule ID 22811 //
     /*   8598 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8601 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8605 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8609 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8613 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8616 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8620 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8624 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8626 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8633 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (SUB64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8633 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64rm),
     /*   8636 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8638 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8640 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8644 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8647 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8652 */     GIR_RootConstrainSelectedInstOperands,
     /*   8653 */     // GIR_Coverage, 22811,
     /*   8653 */     GIR_EraseRootFromParent_Done,
     /*   8654 */   // Label 290: @8654
     /*   8654 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(8715), // Rule ID 22901 //
     /*   8659 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8662 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8666 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8670 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8674 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8677 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8681 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8685 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8687 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8694 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (SUB64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64rm_ND),
     /*   8697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8699 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8701 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8705 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8708 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8713 */     GIR_RootConstrainSelectedInstOperands,
     /*   8714 */     // GIR_Coverage, 22901,
     /*   8714 */     GIR_EraseRootFromParent_Done,
     /*   8715 */   // Label 291: @8715
     /*   8715 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(8743), // Rule ID 244 //
     /*   8720 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8723 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8727 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8731 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
     /*   8731 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r),
     /*   8734 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8736 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8738 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8741 */     GIR_RootConstrainSelectedInstOperands,
     /*   8742 */     // GIR_Coverage, 244,
     /*   8742 */     GIR_EraseRootFromParent_Done,
     /*   8743 */   // Label 292: @8743
     /*   8743 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(8771), // Rule ID 252 //
     /*   8748 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8751 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8755 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8759 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
     /*   8759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_ND),
     /*   8762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8764 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8766 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8769 */     GIR_RootConstrainSelectedInstOperands,
     /*   8770 */     // GIR_Coverage, 252,
     /*   8770 */     GIR_EraseRootFromParent_Done,
     /*   8771 */   // Label 293: @8771
     /*   8771 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(8796), // Rule ID 260 //
     /*   8776 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8779 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8783 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8787 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_NF_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
     /*   8787 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_NF_ND),
     /*   8790 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8792 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8794 */     GIR_RootConstrainSelectedInstOperands,
     /*   8795 */     // GIR_Coverage, 260,
     /*   8795 */     GIR_EraseRootFromParent_Done,
     /*   8796 */   // Label 294: @8796
     /*   8796 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(8837), // Rule ID 22815 //
     /*   8801 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8804 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8808 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8812 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8816 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   8820 */     // MIs[1] Operand 1
     /*   8820 */     // No operand predicates
     /*   8820 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8822 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   8822 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   8825 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8827 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8829 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8832 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8835 */     GIR_RootConstrainSelectedInstOperands,
     /*   8836 */     // GIR_Coverage, 22815,
     /*   8836 */     GIR_EraseRootFromParent_Done,
     /*   8837 */   // Label 295: @8837
     /*   8837 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(8878), // Rule ID 22905 //
     /*   8842 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8845 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8849 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8853 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8857 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   8861 */     // MIs[1] Operand 1
     /*   8861 */     // No operand predicates
     /*   8861 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8863 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   8863 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   8866 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8868 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8870 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8873 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8876 */     GIR_RootConstrainSelectedInstOperands,
     /*   8877 */     // GIR_Coverage, 22905,
     /*   8877 */     GIR_EraseRootFromParent_Done,
     /*   8878 */   // Label 296: @8878
     /*   8878 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(8907), // Rule ID 22807 //
     /*   8883 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8886 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8890 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8894 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   8894 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr),
     /*   8899 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8905 */     GIR_RootConstrainSelectedInstOperands,
     /*   8906 */     // GIR_Coverage, 22807,
     /*   8906 */     GIR_Done,
     /*   8907 */   // Label 297: @8907
     /*   8907 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(8936), // Rule ID 22897 //
     /*   8912 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8915 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8919 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8923 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   8923 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr_ND),
     /*   8928 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8934 */     GIR_RootConstrainSelectedInstOperands,
     /*   8935 */     // GIR_Coverage, 22897,
     /*   8935 */     GIR_Done,
     /*   8936 */   // Label 298: @8936
     /*   8936 */   GIM_Reject,
     /*   8937 */ // Label 289: @8937
     /*   8937 */ GIM_Reject,
     /*   8938 */ // Label 246: @8938
     /*   8938 */ GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(9155),
     /*   8943 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   8946 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   8949 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(9011), // Rule ID 2607 //
     /*   8954 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   8957 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   8961 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   8965 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8969 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8973 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8976 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8980 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8984 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8986 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8993 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQrm),
     /*   8996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8998 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9000 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9004 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9009 */     GIR_RootConstrainSelectedInstOperands,
     /*   9010 */     // GIR_Coverage, 2607,
     /*   9010 */     GIR_EraseRootFromParent_Done,
     /*   9011 */   // Label 300: @9011
     /*   9011 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(9073), // Rule ID 4744 //
     /*   9016 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9019 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9023 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9027 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9031 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9035 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9038 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9042 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9046 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9048 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9055 */     // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9055 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rm),
     /*   9058 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9060 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9062 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9066 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9071 */     GIR_RootConstrainSelectedInstOperands,
     /*   9072 */     // GIR_Coverage, 4744,
     /*   9072 */     GIR_EraseRootFromParent_Done,
     /*   9073 */   // Label 301: @9073
     /*   9073 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(9100), // Rule ID 2606 //
     /*   9078 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9081 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9085 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9089 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9093 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   9093 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQrr),
     /*   9098 */     GIR_RootConstrainSelectedInstOperands,
     /*   9099 */     // GIR_Coverage, 2606,
     /*   9099 */     GIR_Done,
     /*   9100 */   // Label 302: @9100
     /*   9100 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(9127), // Rule ID 2608 //
     /*   9105 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9108 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9112 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9116 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9120 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   9120 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBQrr),
     /*   9125 */     GIR_RootConstrainSelectedInstOperands,
     /*   9126 */     // GIR_Coverage, 2608,
     /*   9126 */     GIR_Done,
     /*   9127 */   // Label 303: @9127
     /*   9127 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(9154), // Rule ID 4741 //
     /*   9132 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9135 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9139 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9143 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9147 */     // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPSUBQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*   9147 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rr),
     /*   9152 */     GIR_RootConstrainSelectedInstOperands,
     /*   9153 */     // GIR_Coverage, 4741,
     /*   9153 */     GIR_Done,
     /*   9154 */   // Label 304: @9154
     /*   9154 */   GIM_Reject,
     /*   9155 */ // Label 299: @9155
     /*   9155 */ GIM_Reject,
     /*   9156 */ // Label 247: @9156
     /*   9156 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(9373),
     /*   9161 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9164 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9167 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(9229), // Rule ID 2601 //
     /*   9172 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9175 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9179 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9183 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9187 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9191 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9194 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9198 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9202 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9204 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9211 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDrm),
     /*   9214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9216 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9218 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9222 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9227 */     GIR_RootConstrainSelectedInstOperands,
     /*   9228 */     // GIR_Coverage, 2601,
     /*   9228 */     GIR_EraseRootFromParent_Done,
     /*   9229 */   // Label 306: @9229
     /*   9229 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(9291), // Rule ID 4771 //
     /*   9234 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9237 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9241 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9245 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9249 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9253 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9256 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9260 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9264 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9266 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9273 */     // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9273 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rm),
     /*   9276 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9278 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9280 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9284 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9289 */     GIR_RootConstrainSelectedInstOperands,
     /*   9290 */     // GIR_Coverage, 4771,
     /*   9290 */     GIR_EraseRootFromParent_Done,
     /*   9291 */   // Label 307: @9291
     /*   9291 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(9318), // Rule ID 2600 //
     /*   9296 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9299 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9303 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9307 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9311 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   9311 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDrr),
     /*   9316 */     GIR_RootConstrainSelectedInstOperands,
     /*   9317 */     // GIR_Coverage, 2600,
     /*   9317 */     GIR_Done,
     /*   9318 */   // Label 308: @9318
     /*   9318 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(9345), // Rule ID 2602 //
     /*   9323 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9326 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9330 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9334 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9338 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   9338 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBDrr),
     /*   9343 */     GIR_RootConstrainSelectedInstOperands,
     /*   9344 */     // GIR_Coverage, 2602,
     /*   9344 */     GIR_Done,
     /*   9345 */   // Label 309: @9345
     /*   9345 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(9372), // Rule ID 4768 //
     /*   9350 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9353 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9357 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9361 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9365 */     // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPSUBDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*   9365 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rr),
     /*   9370 */     GIR_RootConstrainSelectedInstOperands,
     /*   9371 */     // GIR_Coverage, 4768,
     /*   9371 */     GIR_Done,
     /*   9372 */   // Label 310: @9372
     /*   9372 */   GIM_Reject,
     /*   9373 */ // Label 305: @9373
     /*   9373 */ GIM_Reject,
     /*   9374 */ // Label 248: @9374
     /*   9374 */ GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(9564),
     /*   9379 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*   9382 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*   9385 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(9447), // Rule ID 2611 //
     /*   9390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9409 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9412 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9416 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9420 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9422 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9429 */     // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrm),
     /*   9432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9434 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9436 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9440 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9445 */     GIR_RootConstrainSelectedInstOperands,
     /*   9446 */     // GIR_Coverage, 2611,
     /*   9446 */     GIR_EraseRootFromParent_Done,
     /*   9447 */   // Label 312: @9447
     /*   9447 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(9509), // Rule ID 4735 //
     /*   9452 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9455 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9459 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9463 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9467 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9471 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9474 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9478 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9482 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9484 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9491 */     // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9491 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rm),
     /*   9494 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9496 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9498 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9502 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9507 */     GIR_RootConstrainSelectedInstOperands,
     /*   9508 */     // GIR_Coverage, 4735,
     /*   9508 */     GIR_EraseRootFromParent_Done,
     /*   9509 */   // Label 313: @9509
     /*   9509 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(9536), // Rule ID 2610 //
     /*   9514 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9517 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9521 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9525 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9529 */     // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPSUBQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*   9529 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrr),
     /*   9534 */     GIR_RootConstrainSelectedInstOperands,
     /*   9535 */     // GIR_Coverage, 2610,
     /*   9535 */     GIR_Done,
     /*   9536 */   // Label 314: @9536
     /*   9536 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(9563), // Rule ID 4732 //
     /*   9541 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9544 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9548 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9552 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9556 */     // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPSUBQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*   9556 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rr),
     /*   9561 */     GIR_RootConstrainSelectedInstOperands,
     /*   9562 */     // GIR_Coverage, 4732,
     /*   9562 */     GIR_Done,
     /*   9563 */   // Label 315: @9563
     /*   9563 */   GIM_Reject,
     /*   9564 */ // Label 311: @9564
     /*   9564 */ GIM_Reject,
     /*   9565 */ // Label 249: @9565
     /*   9565 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(9782),
     /*   9570 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   9573 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   9576 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(9638), // Rule ID 2595 //
     /*   9581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   9584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9588 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9592 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9596 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9600 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9603 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9607 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9611 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9613 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9620 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWrm),
     /*   9623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9625 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9627 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9631 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9636 */     GIR_RootConstrainSelectedInstOperands,
     /*   9637 */     // GIR_Coverage, 2595,
     /*   9637 */     GIR_EraseRootFromParent_Done,
     /*   9638 */   // Label 317: @9638
     /*   9638 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(9700), // Rule ID 4792 //
     /*   9643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   9646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9650 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9654 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9658 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9662 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9665 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9669 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9673 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9675 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9682 */     // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9682 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rm),
     /*   9685 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9687 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9689 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9693 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9698 */     GIR_RootConstrainSelectedInstOperands,
     /*   9699 */     // GIR_Coverage, 4792,
     /*   9699 */     GIR_EraseRootFromParent_Done,
     /*   9700 */   // Label 318: @9700
     /*   9700 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(9727), // Rule ID 2594 //
     /*   9705 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   9708 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9716 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9720 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   9720 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWrr),
     /*   9725 */     GIR_RootConstrainSelectedInstOperands,
     /*   9726 */     // GIR_Coverage, 2594,
     /*   9726 */     GIR_Done,
     /*   9727 */   // Label 319: @9727
     /*   9727 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(9754), // Rule ID 2596 //
     /*   9732 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9735 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9739 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9743 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9747 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   9747 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBWrr),
     /*   9752 */     GIR_RootConstrainSelectedInstOperands,
     /*   9753 */     // GIR_Coverage, 2596,
     /*   9753 */     GIR_Done,
     /*   9754 */   // Label 320: @9754
     /*   9754 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(9781), // Rule ID 4789 //
     /*   9759 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   9762 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9766 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9770 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9774 */     // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPSUBWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*   9774 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rr),
     /*   9779 */     GIR_RootConstrainSelectedInstOperands,
     /*   9780 */     // GIR_Coverage, 4789,
     /*   9780 */     GIR_Done,
     /*   9781 */   // Label 321: @9781
     /*   9781 */   GIM_Reject,
     /*   9782 */ // Label 316: @9782
     /*   9782 */ GIM_Reject,
     /*   9783 */ // Label 250: @9783
     /*   9783 */ GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(9973),
     /*   9788 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*   9791 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*   9794 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(9856), // Rule ID 2605 //
     /*   9799 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9802 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9806 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9810 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9814 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9818 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9821 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9825 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9829 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9831 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9838 */     // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9838 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrm),
     /*   9841 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9843 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9845 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9849 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9854 */     GIR_RootConstrainSelectedInstOperands,
     /*   9855 */     // GIR_Coverage, 2605,
     /*   9855 */     GIR_EraseRootFromParent_Done,
     /*   9856 */   // Label 323: @9856
     /*   9856 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(9918), // Rule ID 4762 //
     /*   9861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9864 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9868 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9872 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9876 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9880 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9883 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9887 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9891 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9893 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9900 */     // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rm),
     /*   9903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9905 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9907 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9911 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9916 */     GIR_RootConstrainSelectedInstOperands,
     /*   9917 */     // GIR_Coverage, 4762,
     /*   9917 */     GIR_EraseRootFromParent_Done,
     /*   9918 */   // Label 324: @9918
     /*   9918 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(9945), // Rule ID 2604 //
     /*   9923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9930 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9934 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9938 */     // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSUBDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*   9938 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrr),
     /*   9943 */     GIR_RootConstrainSelectedInstOperands,
     /*   9944 */     // GIR_Coverage, 2604,
     /*   9944 */     GIR_Done,
     /*   9945 */   // Label 325: @9945
     /*   9945 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(9972), // Rule ID 4759 //
     /*   9950 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9953 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9957 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9961 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9965 */     // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPSUBDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*   9965 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rr),
     /*   9970 */     GIR_RootConstrainSelectedInstOperands,
     /*   9971 */     // GIR_Coverage, 4759,
     /*   9971 */     GIR_Done,
     /*   9972 */   // Label 326: @9972
     /*   9972 */   GIM_Reject,
     /*   9973 */ // Label 322: @9973
     /*   9973 */ GIM_Reject,
     /*   9974 */ // Label 251: @9974
     /*   9974 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(10067),
     /*   9979 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*   9982 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*   9985 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   9989 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   9993 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(10047), // Rule ID 4726 //
     /*   9998 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10001 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10005 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10009 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10012 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10016 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10020 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10022 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10029 */     // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10029 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrm),
     /*  10032 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10034 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10036 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10040 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10045 */     GIR_RootConstrainSelectedInstOperands,
     /*  10046 */     // GIR_Coverage, 4726,
     /*  10046 */     GIR_EraseRootFromParent_Done,
     /*  10047 */   // Label 328: @10047
     /*  10047 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(10066), // Rule ID 4723 //
     /*  10052 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10055 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10059 */     // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPSUBQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  10059 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrr),
     /*  10064 */     GIR_RootConstrainSelectedInstOperands,
     /*  10065 */     // GIR_Coverage, 4723,
     /*  10065 */     GIR_Done,
     /*  10066 */   // Label 329: @10066
     /*  10066 */   GIM_Reject,
     /*  10067 */ // Label 327: @10067
     /*  10067 */ GIM_Reject,
     /*  10068 */ // Label 252: @10068
     /*  10068 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(10285),
     /*  10073 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  10076 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  10079 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(10141), // Rule ID 2589 //
     /*  10084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  10087 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10091 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10095 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10099 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10103 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10106 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10110 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10114 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10116 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10123 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBrm),
     /*  10126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10128 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10130 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10134 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10139 */     GIR_RootConstrainSelectedInstOperands,
     /*  10140 */     // GIR_Coverage, 2589,
     /*  10140 */     GIR_EraseRootFromParent_Done,
     /*  10141 */   // Label 331: @10141
     /*  10141 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(10203), // Rule ID 4810 //
     /*  10146 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10149 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10153 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10157 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10161 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10165 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10168 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10172 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10176 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10178 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10185 */     // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10185 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rm),
     /*  10188 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10190 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10192 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10196 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10201 */     GIR_RootConstrainSelectedInstOperands,
     /*  10202 */     // GIR_Coverage, 4810,
     /*  10202 */     GIR_EraseRootFromParent_Done,
     /*  10203 */   // Label 332: @10203
     /*  10203 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(10230), // Rule ID 2588 //
     /*  10208 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  10211 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10215 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10219 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10223 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  10223 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBrr),
     /*  10228 */     GIR_RootConstrainSelectedInstOperands,
     /*  10229 */     // GIR_Coverage, 2588,
     /*  10229 */     GIR_Done,
     /*  10230 */   // Label 333: @10230
     /*  10230 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(10257), // Rule ID 2590 //
     /*  10235 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  10238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10242 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10246 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10250 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  10250 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBBrr),
     /*  10255 */     GIR_RootConstrainSelectedInstOperands,
     /*  10256 */     // GIR_Coverage, 2590,
     /*  10256 */     GIR_Done,
     /*  10257 */   // Label 334: @10257
     /*  10257 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(10284), // Rule ID 4807 //
     /*  10262 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10265 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10269 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10273 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10277 */     // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPSUBBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  10277 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rr),
     /*  10282 */     GIR_RootConstrainSelectedInstOperands,
     /*  10283 */     // GIR_Coverage, 4807,
     /*  10283 */     GIR_Done,
     /*  10284 */   // Label 335: @10284
     /*  10284 */   GIM_Reject,
     /*  10285 */ // Label 330: @10285
     /*  10285 */ GIM_Reject,
     /*  10286 */ // Label 253: @10286
     /*  10286 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(10476),
     /*  10291 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  10294 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  10297 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(10359), // Rule ID 2599 //
     /*  10302 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10305 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10309 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10313 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10317 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10321 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10324 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10328 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10332 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10334 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10341 */     // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10341 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrm),
     /*  10344 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10346 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10348 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10352 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10357 */     GIR_RootConstrainSelectedInstOperands,
     /*  10358 */     // GIR_Coverage, 2599,
     /*  10358 */     GIR_EraseRootFromParent_Done,
     /*  10359 */   // Label 337: @10359
     /*  10359 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(10421), // Rule ID 4786 //
     /*  10364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10367 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10371 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10375 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10379 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10383 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10386 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10390 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10394 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10396 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10403 */     // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rm),
     /*  10406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10408 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10410 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10414 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10419 */     GIR_RootConstrainSelectedInstOperands,
     /*  10420 */     // GIR_Coverage, 4786,
     /*  10420 */     GIR_EraseRootFromParent_Done,
     /*  10421 */   // Label 338: @10421
     /*  10421 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(10448), // Rule ID 2598 //
     /*  10426 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10429 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10433 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10437 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10441 */     // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSUBWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  10441 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrr),
     /*  10446 */     GIR_RootConstrainSelectedInstOperands,
     /*  10447 */     // GIR_Coverage, 2598,
     /*  10447 */     GIR_Done,
     /*  10448 */   // Label 339: @10448
     /*  10448 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(10475), // Rule ID 4783 //
     /*  10453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10460 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10464 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10468 */     // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPSUBWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  10468 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rr),
     /*  10473 */     GIR_RootConstrainSelectedInstOperands,
     /*  10474 */     // GIR_Coverage, 4783,
     /*  10474 */     GIR_Done,
     /*  10475 */   // Label 340: @10475
     /*  10475 */   GIM_Reject,
     /*  10476 */ // Label 336: @10476
     /*  10476 */ GIM_Reject,
     /*  10477 */ // Label 254: @10477
     /*  10477 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(10570),
     /*  10482 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  10485 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  10488 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10492 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10496 */   GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(10550), // Rule ID 4753 //
     /*  10501 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10512 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10515 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10519 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10523 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10525 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10532 */     // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10532 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrm),
     /*  10535 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10537 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10539 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10543 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10548 */     GIR_RootConstrainSelectedInstOperands,
     /*  10549 */     // GIR_Coverage, 4753,
     /*  10549 */     GIR_EraseRootFromParent_Done,
     /*  10550 */   // Label 342: @10550
     /*  10550 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(10569), // Rule ID 4750 //
     /*  10555 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10558 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10562 */     // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPSUBDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  10562 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrr),
     /*  10567 */     GIR_RootConstrainSelectedInstOperands,
     /*  10568 */     // GIR_Coverage, 4750,
     /*  10568 */     GIR_Done,
     /*  10569 */   // Label 343: @10569
     /*  10569 */   GIM_Reject,
     /*  10570 */ // Label 341: @10570
     /*  10570 */ GIM_Reject,
     /*  10571 */ // Label 255: @10571
     /*  10571 */ GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(10761),
     /*  10576 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*  10579 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*  10582 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(10644), // Rule ID 2593 //
     /*  10587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10594 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10598 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10602 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10606 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10609 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10613 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10617 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10619 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10626 */     // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrm),
     /*  10629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10631 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10633 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10637 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10642 */     GIR_RootConstrainSelectedInstOperands,
     /*  10643 */     // GIR_Coverage, 2593,
     /*  10643 */     GIR_EraseRootFromParent_Done,
     /*  10644 */   // Label 345: @10644
     /*  10644 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(10706), // Rule ID 4804 //
     /*  10649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10656 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10668 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10671 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10675 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10679 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10681 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10688 */     // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10688 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rm),
     /*  10691 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10693 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10695 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10699 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10704 */     GIR_RootConstrainSelectedInstOperands,
     /*  10705 */     // GIR_Coverage, 4804,
     /*  10705 */     GIR_EraseRootFromParent_Done,
     /*  10706 */   // Label 346: @10706
     /*  10706 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(10733), // Rule ID 2592 //
     /*  10711 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10714 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10718 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10722 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10726 */     // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSUBBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  10726 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrr),
     /*  10731 */     GIR_RootConstrainSelectedInstOperands,
     /*  10732 */     // GIR_Coverage, 2592,
     /*  10732 */     GIR_Done,
     /*  10733 */   // Label 347: @10733
     /*  10733 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(10760), // Rule ID 4801 //
     /*  10738 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10741 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10745 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10749 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10753 */     // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPSUBBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*  10753 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rr),
     /*  10758 */     GIR_RootConstrainSelectedInstOperands,
     /*  10759 */     // GIR_Coverage, 4801,
     /*  10759 */     GIR_Done,
     /*  10760 */   // Label 348: @10760
     /*  10760 */   GIM_Reject,
     /*  10761 */ // Label 344: @10761
     /*  10761 */ GIM_Reject,
     /*  10762 */ // Label 256: @10762
     /*  10762 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(10855),
     /*  10767 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  10770 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  10773 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10777 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10781 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(10835), // Rule ID 4780 //
     /*  10786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10789 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10793 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10797 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10800 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10804 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10808 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10810 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10817 */     // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10817 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrm),
     /*  10820 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10822 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10824 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10828 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10833 */     GIR_RootConstrainSelectedInstOperands,
     /*  10834 */     // GIR_Coverage, 4780,
     /*  10834 */     GIR_EraseRootFromParent_Done,
     /*  10835 */   // Label 350: @10835
     /*  10835 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(10854), // Rule ID 4777 //
     /*  10840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10843 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10847 */     // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPSUBWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  10847 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrr),
     /*  10852 */     GIR_RootConstrainSelectedInstOperands,
     /*  10853 */     // GIR_Coverage, 4777,
     /*  10853 */     GIR_Done,
     /*  10854 */   // Label 351: @10854
     /*  10854 */   GIM_Reject,
     /*  10855 */ // Label 349: @10855
     /*  10855 */ GIM_Reject,
     /*  10856 */ // Label 257: @10856
     /*  10856 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(10949),
     /*  10861 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*  10864 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*  10867 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10871 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10875 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(10929), // Rule ID 4798 //
     /*  10880 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10883 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10887 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10891 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10894 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10898 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10902 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10904 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10911 */     // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10911 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrm),
     /*  10914 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10916 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10918 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10922 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10927 */     GIR_RootConstrainSelectedInstOperands,
     /*  10928 */     // GIR_Coverage, 4798,
     /*  10928 */     GIR_EraseRootFromParent_Done,
     /*  10929 */   // Label 353: @10929
     /*  10929 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(10948), // Rule ID 4795 //
     /*  10934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10937 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10941 */     // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPSUBBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*  10941 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrr),
     /*  10946 */     GIR_RootConstrainSelectedInstOperands,
     /*  10947 */     // GIR_Coverage, 4795,
     /*  10947 */     GIR_Done,
     /*  10948 */   // Label 354: @10948
     /*  10948 */   GIM_Reject,
     /*  10949 */ // Label 352: @10949
     /*  10949 */ GIM_Reject,
     /*  10950 */ // Label 258: @10950
     /*  10950 */ GIM_Reject,
     /*  10951 */ // Label 2: @10951
     /*  10951 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(23), /*)*//*default:*//*Label 367*/ GIMT_Encode4(14733),
     /*  10962 */ /*GILLT_s16*//*Label 355*/ GIMT_Encode4(11046),
     /*  10966 */ /*GILLT_s32*//*Label 356*/ GIMT_Encode4(11463),
     /*  10970 */ /*GILLT_s64*//*Label 357*/ GIMT_Encode4(11880), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  10986 */ /*GILLT_v2s64*//*Label 358*/ GIMT_Encode4(12305), GIMT_Encode4(0),
     /*  10994 */ /*GILLT_v4s32*//*Label 359*/ GIMT_Encode4(12634),
     /*  10998 */ /*GILLT_v4s64*//*Label 360*/ GIMT_Encode4(12976), GIMT_Encode4(0),
     /*  11006 */ /*GILLT_v8s16*//*Label 361*/ GIMT_Encode4(13293),
     /*  11010 */ /*GILLT_v8s32*//*Label 362*/ GIMT_Encode4(13635),
     /*  11014 */ /*GILLT_v8s64*//*Label 363*/ GIMT_Encode4(13950), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  11026 */ /*GILLT_v16s16*//*Label 364*/ GIMT_Encode4(14106),
     /*  11030 */ /*GILLT_v16s32*//*Label 365*/ GIMT_Encode4(14421), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  11042 */ /*GILLT_v32s16*//*Label 366*/ GIMT_Encode4(14577),
     /*  11046 */ // Label 355: @11046
     /*  11046 */ GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(11462),
     /*  11051 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  11054 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  11057 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11061 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(11125), // Rule ID 22979 //
     /*  11066 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11070 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11074 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11077 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11081 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11085 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11089 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11093 */     // MIs[2] Operand 1
     /*  11093 */     // No operand predicates
     /*  11093 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11095 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11102 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rmi:{ *:[i16] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  11102 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rmi),
     /*  11105 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11107 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11111 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11114 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11117 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11123 */     GIR_RootConstrainSelectedInstOperands,
     /*  11124 */     // GIR_Coverage, 22979,
     /*  11124 */     GIR_EraseRootFromParent_Done,
     /*  11125 */   // Label 369: @11125
     /*  11125 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(11186), // Rule ID 26058 //
     /*  11130 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11133 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11137 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11141 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11144 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11148 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11152 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11156 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11158 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11165 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (IMUL16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm),
     /*  11168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11170 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11172 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11176 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11179 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11184 */     GIR_RootConstrainSelectedInstOperands,
     /*  11185 */     // GIR_Coverage, 26058,
     /*  11185 */     GIR_EraseRootFromParent_Done,
     /*  11186 */   // Label 370: @11186
     /*  11186 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(11247), // Rule ID 26077 //
     /*  11191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11194 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11198 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11202 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11205 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11209 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11213 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11217 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11219 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11226 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (IMUL16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11226 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm_ND),
     /*  11229 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11231 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11233 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11237 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11240 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11245 */     GIR_RootConstrainSelectedInstOperands,
     /*  11246 */     // GIR_Coverage, 26077,
     /*  11246 */     GIR_EraseRootFromParent_Done,
     /*  11247 */   // Label 371: @11247
     /*  11247 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(11308), // Rule ID 22823 //
     /*  11252 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11255 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11259 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11263 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11267 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11270 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11274 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11278 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11280 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11287 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (IMUL16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11287 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm),
     /*  11290 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11292 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11294 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11298 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11301 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11306 */     GIR_RootConstrainSelectedInstOperands,
     /*  11307 */     // GIR_Coverage, 22823,
     /*  11307 */     GIR_EraseRootFromParent_Done,
     /*  11308 */   // Label 372: @11308
     /*  11308 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(11369), // Rule ID 22913 //
     /*  11313 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11316 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11320 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11324 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11328 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11331 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11335 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11339 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11341 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11348 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (IMUL16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11348 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm_ND),
     /*  11351 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11353 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11355 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11359 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11362 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11367 */     GIR_RootConstrainSelectedInstOperands,
     /*  11368 */     // GIR_Coverage, 22913,
     /*  11368 */     GIR_EraseRootFromParent_Done,
     /*  11369 */   // Label 373: @11369
     /*  11369 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(11403), // Rule ID 22976 //
     /*  11374 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11378 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11382 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11386 */     // MIs[1] Operand 1
     /*  11386 */     // No operand predicates
     /*  11386 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11388 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  11388 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rri),
     /*  11391 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11393 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11395 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  11398 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11401 */     GIR_RootConstrainSelectedInstOperands,
     /*  11402 */     // GIR_Coverage, 22976,
     /*  11402 */     GIR_EraseRootFromParent_Done,
     /*  11403 */   // Label 374: @11403
     /*  11403 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(11432), // Rule ID 22820 //
     /*  11408 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11411 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11415 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11419 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  11419 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr),
     /*  11424 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11430 */     GIR_RootConstrainSelectedInstOperands,
     /*  11431 */     // GIR_Coverage, 22820,
     /*  11431 */     GIR_Done,
     /*  11432 */   // Label 375: @11432
     /*  11432 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(11461), // Rule ID 22910 //
     /*  11437 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11440 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11444 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11448 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  11448 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr_ND),
     /*  11453 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11459 */     GIR_RootConstrainSelectedInstOperands,
     /*  11460 */     // GIR_Coverage, 22910,
     /*  11460 */     GIR_Done,
     /*  11461 */   // Label 376: @11461
     /*  11461 */   GIM_Reject,
     /*  11462 */ // Label 368: @11462
     /*  11462 */ GIM_Reject,
     /*  11463 */ // Label 356: @11463
     /*  11463 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(11879),
     /*  11468 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  11471 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  11474 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11478 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(11542), // Rule ID 22980 //
     /*  11483 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11487 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11491 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11494 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11498 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11502 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11506 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11510 */     // MIs[2] Operand 1
     /*  11510 */     // No operand predicates
     /*  11510 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11512 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11519 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rmi:{ *:[i32] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  11519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rmi),
     /*  11522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11524 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11528 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11531 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11534 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11540 */     GIR_RootConstrainSelectedInstOperands,
     /*  11541 */     // GIR_Coverage, 22980,
     /*  11541 */     GIR_EraseRootFromParent_Done,
     /*  11542 */   // Label 378: @11542
     /*  11542 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(11603), // Rule ID 26059 //
     /*  11547 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11550 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11554 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11558 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11561 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11565 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11569 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11573 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11575 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11582 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (IMUL32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11582 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm),
     /*  11585 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11587 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11589 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11593 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11596 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11601 */     GIR_RootConstrainSelectedInstOperands,
     /*  11602 */     // GIR_Coverage, 26059,
     /*  11602 */     GIR_EraseRootFromParent_Done,
     /*  11603 */   // Label 379: @11603
     /*  11603 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(11664), // Rule ID 26078 //
     /*  11608 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11611 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11615 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11619 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11622 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11626 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11630 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11634 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11636 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11643 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (IMUL32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11643 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm_ND),
     /*  11646 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11648 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11650 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11654 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11657 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11662 */     GIR_RootConstrainSelectedInstOperands,
     /*  11663 */     // GIR_Coverage, 26078,
     /*  11663 */     GIR_EraseRootFromParent_Done,
     /*  11664 */   // Label 380: @11664
     /*  11664 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(11725), // Rule ID 22824 //
     /*  11669 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11672 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11676 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11680 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11684 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11687 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11691 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11695 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11697 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11704 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (IMUL32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm),
     /*  11707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11709 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11711 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11715 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11718 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11723 */     GIR_RootConstrainSelectedInstOperands,
     /*  11724 */     // GIR_Coverage, 22824,
     /*  11724 */     GIR_EraseRootFromParent_Done,
     /*  11725 */   // Label 381: @11725
     /*  11725 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(11786), // Rule ID 22914 //
     /*  11730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11733 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11737 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11741 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11745 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11748 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11752 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11756 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11758 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11765 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (IMUL32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11765 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm_ND),
     /*  11768 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11770 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11772 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11776 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11779 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11784 */     GIR_RootConstrainSelectedInstOperands,
     /*  11785 */     // GIR_Coverage, 22914,
     /*  11785 */     GIR_EraseRootFromParent_Done,
     /*  11786 */   // Label 382: @11786
     /*  11786 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(11820), // Rule ID 22977 //
     /*  11791 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11795 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11799 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11803 */     // MIs[1] Operand 1
     /*  11803 */     // No operand predicates
     /*  11803 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11805 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  11805 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rri),
     /*  11808 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11810 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11812 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  11815 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11818 */     GIR_RootConstrainSelectedInstOperands,
     /*  11819 */     // GIR_Coverage, 22977,
     /*  11819 */     GIR_EraseRootFromParent_Done,
     /*  11820 */   // Label 383: @11820
     /*  11820 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(11849), // Rule ID 22821 //
     /*  11825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11828 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11832 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11836 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  11836 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr),
     /*  11841 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11847 */     GIR_RootConstrainSelectedInstOperands,
     /*  11848 */     // GIR_Coverage, 22821,
     /*  11848 */     GIR_Done,
     /*  11849 */   // Label 384: @11849
     /*  11849 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(11878), // Rule ID 22911 //
     /*  11854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11857 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11861 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11865 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  11865 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr_ND),
     /*  11870 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11876 */     GIR_RootConstrainSelectedInstOperands,
     /*  11877 */     // GIR_Coverage, 22911,
     /*  11877 */     GIR_Done,
     /*  11878 */   // Label 385: @11878
     /*  11878 */   GIM_Reject,
     /*  11879 */ // Label 377: @11879
     /*  11879 */ GIM_Reject,
     /*  11880 */ // Label 357: @11880
     /*  11880 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(12304),
     /*  11885 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  11888 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  11891 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  11895 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(11963), // Rule ID 22981 //
     /*  11900 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11904 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11908 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11911 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  11915 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11919 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11923 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11927 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  11931 */     // MIs[2] Operand 1
     /*  11931 */     // No operand predicates
     /*  11931 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11933 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11940 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rmi32:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  11940 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rmi32),
     /*  11943 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11945 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11949 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11952 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11955 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11961 */     GIR_RootConstrainSelectedInstOperands,
     /*  11962 */     // GIR_Coverage, 22981,
     /*  11962 */     GIR_EraseRootFromParent_Done,
     /*  11963 */   // Label 387: @11963
     /*  11963 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(12024), // Rule ID 26060 //
     /*  11968 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11971 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11975 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11979 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11982 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  11986 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11990 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  11994 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11996 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12003 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (IMUL64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12003 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm),
     /*  12006 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12008 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12010 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12014 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12017 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12022 */     GIR_RootConstrainSelectedInstOperands,
     /*  12023 */     // GIR_Coverage, 26060,
     /*  12023 */     GIR_EraseRootFromParent_Done,
     /*  12024 */   // Label 388: @12024
     /*  12024 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(12085), // Rule ID 26079 //
     /*  12029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12032 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12036 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12040 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12043 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12047 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12051 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12055 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12057 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12064 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (IMUL64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12064 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm_ND),
     /*  12067 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12069 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12071 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12075 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12078 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12083 */     GIR_RootConstrainSelectedInstOperands,
     /*  12084 */     // GIR_Coverage, 26079,
     /*  12084 */     GIR_EraseRootFromParent_Done,
     /*  12085 */   // Label 389: @12085
     /*  12085 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(12146), // Rule ID 22825 //
     /*  12090 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  12093 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12097 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12101 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12105 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12108 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12112 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12116 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12118 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12125 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (IMUL64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12125 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm),
     /*  12128 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12130 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12132 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12136 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12139 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12144 */     GIR_RootConstrainSelectedInstOperands,
     /*  12145 */     // GIR_Coverage, 22825,
     /*  12145 */     GIR_EraseRootFromParent_Done,
     /*  12146 */   // Label 390: @12146
     /*  12146 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(12207), // Rule ID 22915 //
     /*  12151 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12154 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12158 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12162 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12166 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12169 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12173 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12177 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12179 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12186 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (IMUL64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12186 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm_ND),
     /*  12189 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12191 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12193 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12197 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12200 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12205 */     GIR_RootConstrainSelectedInstOperands,
     /*  12206 */     // GIR_Coverage, 22915,
     /*  12206 */     GIR_EraseRootFromParent_Done,
     /*  12207 */   // Label 391: @12207
     /*  12207 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(12245), // Rule ID 22978 //
     /*  12212 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  12224 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  12228 */     // MIs[1] Operand 1
     /*  12228 */     // No operand predicates
     /*  12228 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12230 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  12230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rri32),
     /*  12233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12235 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12237 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  12240 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12243 */     GIR_RootConstrainSelectedInstOperands,
     /*  12244 */     // GIR_Coverage, 22978,
     /*  12244 */     GIR_EraseRootFromParent_Done,
     /*  12245 */   // Label 392: @12245
     /*  12245 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(12274), // Rule ID 22822 //
     /*  12250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  12253 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12257 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12261 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  12261 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr),
     /*  12266 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  12272 */     GIR_RootConstrainSelectedInstOperands,
     /*  12273 */     // GIR_Coverage, 22822,
     /*  12273 */     GIR_Done,
     /*  12274 */   // Label 393: @12274
     /*  12274 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(12303), // Rule ID 22912 //
     /*  12279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12282 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12286 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12290 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  12290 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr_ND),
     /*  12295 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  12301 */     GIR_RootConstrainSelectedInstOperands,
     /*  12302 */     // GIR_Coverage, 22912,
     /*  12302 */     GIR_Done,
     /*  12303 */   // Label 394: @12303
     /*  12303 */   GIM_Reject,
     /*  12304 */ // Label 386: @12304
     /*  12304 */ GIM_Reject,
     /*  12305 */ // Label 358: @12305
     /*  12305 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(12633),
     /*  12310 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  12313 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  12316 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(12378), // Rule ID 23825 //
     /*  12321 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12324 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12328 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12332 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12336 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12339 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12343 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12347 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12351 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12353 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12360 */     // (mul:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPMULLQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12360 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rm),
     /*  12363 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12365 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12367 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12371 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12376 */     GIR_RootConstrainSelectedInstOperands,
     /*  12377 */     // GIR_Coverage, 23825,
     /*  12377 */     GIR_EraseRootFromParent_Done,
     /*  12378 */   // Label 396: @12378
     /*  12378 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(12440), // Rule ID 5023 //
     /*  12383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12390 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12402 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12405 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12409 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12415 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12422 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12422 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rm),
     /*  12425 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12427 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12429 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12433 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12438 */     GIR_RootConstrainSelectedInstOperands,
     /*  12439 */     // GIR_Coverage, 5023,
     /*  12439 */     GIR_EraseRootFromParent_Done,
     /*  12440 */   // Label 397: @12440
     /*  12440 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(12467), // Rule ID 5020 //
     /*  12445 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12448 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12452 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12456 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12460 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPMULLQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  12460 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rr),
     /*  12465 */     GIR_RootConstrainSelectedInstOperands,
     /*  12466 */     // GIR_Coverage, 5020,
     /*  12466 */     GIR_Done,
     /*  12467 */   // Label 398: @12467
     /*  12467 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(12632), // Rule ID 19998 //
     /*  12472 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
     /*  12475 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
     /*  12479 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12483 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12487 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src1, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src2, sub_xmm:{ *:[i32] })), sub_xmm:{ *:[i32] })
     /*  12487 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
     /*  12490 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  12494 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12499 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
     /*  12501 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
     /*  12504 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  12508 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12513 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  12516 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  12520 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
     /*  12523 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  12528 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12533 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
     /*  12538 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
     /*  12541 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  12545 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12550 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  12552 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
     /*  12555 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  12559 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12564 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  12567 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  12571 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
     /*  12574 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  12579 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12584 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
     /*  12589 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
     /*  12592 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  12596 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12601 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  12604 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
     /*  12607 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12614 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
     /*  12621 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
     /*  12626 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12631 */     // GIR_Coverage, 19998,
     /*  12631 */     GIR_EraseRootFromParent_Done,
     /*  12632 */   // Label 399: @12632
     /*  12632 */   GIM_Reject,
     /*  12633 */ // Label 395: @12633
     /*  12633 */ GIM_Reject,
     /*  12634 */ // Label 359: @12634
     /*  12634 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(12975),
     /*  12639 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12642 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12645 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(12707), // Rule ID 23528 //
     /*  12650 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12653 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12657 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12661 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12665 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12668 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12672 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12676 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12680 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12682 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12689 */     // (mul:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPMULLDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12689 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDrm),
     /*  12692 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12694 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12696 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12700 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12705 */     GIR_RootConstrainSelectedInstOperands,
     /*  12706 */     // GIR_Coverage, 23528,
     /*  12706 */     GIR_EraseRootFromParent_Done,
     /*  12707 */   // Label 401: @12707
     /*  12707 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(12769), // Rule ID 23798 //
     /*  12712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12719 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12723 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12727 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12730 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12734 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12738 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12742 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12744 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12751 */     // (mul:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPMULLDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12751 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rm),
     /*  12754 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12756 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12758 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12762 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12767 */     GIR_RootConstrainSelectedInstOperands,
     /*  12768 */     // GIR_Coverage, 23798,
     /*  12768 */     GIR_EraseRootFromParent_Done,
     /*  12769 */   // Label 402: @12769
     /*  12769 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(12831), // Rule ID 3240 //
     /*  12774 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12777 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12781 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12785 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12789 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12793 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12796 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12800 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12804 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12806 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12813 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12813 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDrm),
     /*  12816 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12818 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12820 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12824 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12829 */     GIR_RootConstrainSelectedInstOperands,
     /*  12830 */     // GIR_Coverage, 3240,
     /*  12830 */     GIR_EraseRootFromParent_Done,
     /*  12831 */   // Label 403: @12831
     /*  12831 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(12893), // Rule ID 4978 //
     /*  12836 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12839 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12843 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12847 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12851 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12855 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12858 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12862 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12866 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12868 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12875 */     // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12875 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rm),
     /*  12878 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12880 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12882 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12886 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12891 */     GIR_RootConstrainSelectedInstOperands,
     /*  12892 */     // GIR_Coverage, 4978,
     /*  12892 */     GIR_EraseRootFromParent_Done,
     /*  12893 */   // Label 404: @12893
     /*  12893 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(12920), // Rule ID 3239 //
     /*  12898 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12901 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12905 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12909 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12913 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  12913 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDrr),
     /*  12918 */     GIR_RootConstrainSelectedInstOperands,
     /*  12919 */     // GIR_Coverage, 3239,
     /*  12919 */     GIR_Done,
     /*  12920 */   // Label 405: @12920
     /*  12920 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(12947), // Rule ID 3247 //
     /*  12925 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
     /*  12928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12932 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12936 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12940 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  12940 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLDrr),
     /*  12945 */     GIR_RootConstrainSelectedInstOperands,
     /*  12946 */     // GIR_Coverage, 3247,
     /*  12946 */     GIR_Done,
     /*  12947 */   // Label 406: @12947
     /*  12947 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(12974), // Rule ID 4975 //
     /*  12952 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12955 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12959 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12963 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12967 */     // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPMULLDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  12967 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rr),
     /*  12972 */     GIR_RootConstrainSelectedInstOperands,
     /*  12973 */     // GIR_Coverage, 4975,
     /*  12973 */     GIR_Done,
     /*  12974 */   // Label 407: @12974
     /*  12974 */   GIM_Reject,
     /*  12975 */ // Label 400: @12975
     /*  12975 */ GIM_Reject,
     /*  12976 */ // Label 360: @12976
     /*  12976 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(13292),
     /*  12981 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  12984 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  12987 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  12991 */   GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(13049), // Rule ID 23819 //
     /*  12996 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12999 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13003 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13007 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13010 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13014 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13018 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13022 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13024 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13031 */     // (mul:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPMULLQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rm),
     /*  13034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13036 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13038 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13042 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13047 */     GIR_RootConstrainSelectedInstOperands,
     /*  13048 */     // GIR_Coverage, 23819,
     /*  13048 */     GIR_EraseRootFromParent_Done,
     /*  13049 */   // Label 409: @13049
     /*  13049 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(13107), // Rule ID 5014 //
     /*  13054 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  13057 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13061 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13065 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13069 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13072 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13076 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13080 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13082 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13089 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13089 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rm),
     /*  13092 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13094 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13096 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13100 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13105 */     GIR_RootConstrainSelectedInstOperands,
     /*  13106 */     // GIR_Coverage, 5014,
     /*  13106 */     GIR_EraseRootFromParent_Done,
     /*  13107 */   // Label 410: @13107
     /*  13107 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(13130), // Rule ID 5011 //
     /*  13112 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  13115 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13119 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13123 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPMULLQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  13123 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rr),
     /*  13128 */     GIR_RootConstrainSelectedInstOperands,
     /*  13129 */     // GIR_Coverage, 5011,
     /*  13129 */     GIR_Done,
     /*  13130 */   // Label 411: @13130
     /*  13130 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(13291), // Rule ID 19996 //
     /*  13135 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
     /*  13138 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13142 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13146 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src1, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src2, sub_ymm:{ *:[i32] })), sub_ymm:{ *:[i32] })
     /*  13146 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
     /*  13149 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13153 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13158 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
     /*  13160 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
     /*  13163 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13167 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13172 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  13175 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  13179 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
     /*  13182 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  13187 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13192 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13197 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
     /*  13200 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13204 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13209 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13211 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
     /*  13214 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13218 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13223 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13226 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  13230 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
     /*  13233 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  13238 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13243 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13248 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
     /*  13251 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  13255 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13260 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13263 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
     /*  13266 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13268 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13271 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13273 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
     /*  13280 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13285 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13290 */     // GIR_Coverage, 19996,
     /*  13290 */     GIR_EraseRootFromParent_Done,
     /*  13291 */   // Label 412: @13291
     /*  13291 */   GIM_Reject,
     /*  13292 */ // Label 408: @13292
     /*  13292 */ GIM_Reject,
     /*  13293 */ // Label 361: @13293
     /*  13293 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(13634),
     /*  13298 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  13301 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  13304 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(13366), // Rule ID 23453 //
     /*  13309 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13312 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13316 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13320 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13324 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13327 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13331 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13335 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13339 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13341 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13348 */     // (mul:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPMULLWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13348 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWrm),
     /*  13351 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13353 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13355 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13359 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13364 */     GIR_RootConstrainSelectedInstOperands,
     /*  13365 */     // GIR_Coverage, 23453,
     /*  13365 */     GIR_EraseRootFromParent_Done,
     /*  13366 */   // Label 414: @13366
     /*  13366 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(13428), // Rule ID 23810 //
     /*  13371 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13374 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13378 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13382 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13386 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13389 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13393 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13397 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13401 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13403 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13410 */     // (mul:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPMULLWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13410 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rm),
     /*  13413 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13415 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13417 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13421 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13426 */     GIR_RootConstrainSelectedInstOperands,
     /*  13427 */     // GIR_Coverage, 23810,
     /*  13427 */     GIR_EraseRootFromParent_Done,
     /*  13428 */   // Label 415: @13428
     /*  13428 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(13490), // Rule ID 2571 //
     /*  13433 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13436 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13440 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13452 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13455 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13459 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13463 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13465 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13472 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13472 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWrm),
     /*  13475 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13477 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13479 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13483 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13488 */     GIR_RootConstrainSelectedInstOperands,
     /*  13489 */     // GIR_Coverage, 2571,
     /*  13489 */     GIR_EraseRootFromParent_Done,
     /*  13490 */   // Label 416: @13490
     /*  13490 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(13552), // Rule ID 4999 //
     /*  13495 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13498 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13502 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13506 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13510 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13514 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13517 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13521 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13525 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13527 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13534 */     // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rm),
     /*  13537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13539 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13541 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13545 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13550 */     GIR_RootConstrainSelectedInstOperands,
     /*  13551 */     // GIR_Coverage, 4999,
     /*  13551 */     GIR_EraseRootFromParent_Done,
     /*  13552 */   // Label 417: @13552
     /*  13552 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(13579), // Rule ID 2570 //
     /*  13557 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13560 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13564 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13568 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13572 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  13572 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWrr),
     /*  13577 */     GIR_RootConstrainSelectedInstOperands,
     /*  13578 */     // GIR_Coverage, 2570,
     /*  13578 */     GIR_Done,
     /*  13579 */   // Label 418: @13579
     /*  13579 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(13606), // Rule ID 2572 //
     /*  13584 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  13587 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13591 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13595 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13599 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  13599 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLWrr),
     /*  13604 */     GIR_RootConstrainSelectedInstOperands,
     /*  13605 */     // GIR_Coverage, 2572,
     /*  13605 */     GIR_Done,
     /*  13606 */   // Label 419: @13606
     /*  13606 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(13633), // Rule ID 4996 //
     /*  13611 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13614 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13618 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13622 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13626 */     // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPMULLWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  13626 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rr),
     /*  13631 */     GIR_RootConstrainSelectedInstOperands,
     /*  13632 */     // GIR_Coverage, 4996,
     /*  13632 */     GIR_Done,
     /*  13633 */   // Label 420: @13633
     /*  13633 */   GIM_Reject,
     /*  13634 */ // Label 413: @13634
     /*  13634 */ GIM_Reject,
     /*  13635 */ // Label 362: @13635
     /*  13635 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(13949),
     /*  13640 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  13643 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  13646 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(13708), // Rule ID 23530 //
     /*  13651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13654 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13658 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13662 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13666 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13669 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13673 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13677 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13681 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13683 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13690 */     // (mul:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPMULLDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13690 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrm),
     /*  13693 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13695 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13697 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13701 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13706 */     GIR_RootConstrainSelectedInstOperands,
     /*  13707 */     // GIR_Coverage, 23530,
     /*  13707 */     GIR_EraseRootFromParent_Done,
     /*  13708 */   // Label 422: @13708
     /*  13708 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(13770), // Rule ID 23792 //
     /*  13713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13720 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13724 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13728 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13731 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13735 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13739 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13743 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13745 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13752 */     // (mul:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPMULLDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13752 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rm),
     /*  13755 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13757 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13759 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13763 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13768 */     GIR_RootConstrainSelectedInstOperands,
     /*  13769 */     // GIR_Coverage, 23792,
     /*  13769 */     GIR_EraseRootFromParent_Done,
     /*  13770 */   // Label 423: @13770
     /*  13770 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(13832), // Rule ID 3244 //
     /*  13775 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13778 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13782 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13786 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13790 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13794 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13797 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13801 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13805 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13807 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13814 */     // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13814 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrm),
     /*  13817 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13819 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13821 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13825 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13830 */     GIR_RootConstrainSelectedInstOperands,
     /*  13831 */     // GIR_Coverage, 3244,
     /*  13831 */     GIR_EraseRootFromParent_Done,
     /*  13832 */   // Label 424: @13832
     /*  13832 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(13894), // Rule ID 4969 //
     /*  13837 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13840 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13844 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13848 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13852 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13856 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13859 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13863 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13867 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13869 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13876 */     // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13876 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rm),
     /*  13879 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13881 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13883 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13887 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13892 */     GIR_RootConstrainSelectedInstOperands,
     /*  13893 */     // GIR_Coverage, 4969,
     /*  13893 */     GIR_EraseRootFromParent_Done,
     /*  13894 */   // Label 425: @13894
     /*  13894 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(13921), // Rule ID 3243 //
     /*  13899 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13902 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13906 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13910 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13914 */     // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPMULLDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  13914 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrr),
     /*  13919 */     GIR_RootConstrainSelectedInstOperands,
     /*  13920 */     // GIR_Coverage, 3243,
     /*  13920 */     GIR_Done,
     /*  13921 */   // Label 426: @13921
     /*  13921 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(13948), // Rule ID 4966 //
     /*  13926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13929 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13933 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13937 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13941 */     // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPMULLDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  13941 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rr),
     /*  13946 */     GIR_RootConstrainSelectedInstOperands,
     /*  13947 */     // GIR_Coverage, 4966,
     /*  13947 */     GIR_Done,
     /*  13948 */   // Label 427: @13948
     /*  13948 */   GIM_Reject,
     /*  13949 */ // Label 421: @13949
     /*  13949 */ GIM_Reject,
     /*  13950 */ // Label 363: @13950
     /*  13950 */ GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(14105),
     /*  13955 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  13958 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  13961 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  13965 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(14023), // Rule ID 23813 //
     /*  13970 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  13973 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13977 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13981 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13984 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13988 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13992 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  13996 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13998 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14005 */     // (mul:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPMULLQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14005 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrm),
     /*  14008 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14010 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14012 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14016 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14021 */     GIR_RootConstrainSelectedInstOperands,
     /*  14022 */     // GIR_Coverage, 23813,
     /*  14022 */     GIR_EraseRootFromParent_Done,
     /*  14023 */   // Label 429: @14023
     /*  14023 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(14081), // Rule ID 5005 //
     /*  14028 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  14031 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14035 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14039 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14043 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14046 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14050 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14054 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14056 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14063 */     // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14063 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrm),
     /*  14066 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14068 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14070 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14074 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14079 */     GIR_RootConstrainSelectedInstOperands,
     /*  14080 */     // GIR_Coverage, 5005,
     /*  14080 */     GIR_EraseRootFromParent_Done,
     /*  14081 */   // Label 430: @14081
     /*  14081 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(14104), // Rule ID 5002 //
     /*  14086 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  14089 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14093 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14097 */     // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPMULLQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  14097 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  14102 */     GIR_RootConstrainSelectedInstOperands,
     /*  14103 */     // GIR_Coverage, 5002,
     /*  14103 */     GIR_Done,
     /*  14104 */   // Label 431: @14104
     /*  14104 */   GIM_Reject,
     /*  14105 */ // Label 428: @14105
     /*  14105 */ GIM_Reject,
     /*  14106 */ // Label 364: @14106
     /*  14106 */ GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(14420),
     /*  14111 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  14114 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  14117 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(14179), // Rule ID 23455 //
     /*  14122 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14125 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14129 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14133 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14137 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14140 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14144 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14148 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14152 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14154 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14161 */     // (mul:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPMULLWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrm),
     /*  14164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14166 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14168 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14172 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14177 */     GIR_RootConstrainSelectedInstOperands,
     /*  14178 */     // GIR_Coverage, 23455,
     /*  14178 */     GIR_EraseRootFromParent_Done,
     /*  14179 */   // Label 433: @14179
     /*  14179 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(14241), // Rule ID 23807 //
     /*  14184 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14187 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14191 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14195 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14199 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14202 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14206 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14210 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14214 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14216 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14223 */     // (mul:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPMULLWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14223 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rm),
     /*  14226 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14228 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14230 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14234 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14239 */     GIR_RootConstrainSelectedInstOperands,
     /*  14240 */     // GIR_Coverage, 23807,
     /*  14240 */     GIR_EraseRootFromParent_Done,
     /*  14241 */   // Label 434: @14241
     /*  14241 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(14303), // Rule ID 2575 //
     /*  14246 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14249 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14253 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14257 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14261 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14265 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14268 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14272 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14276 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14278 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14285 */     // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14285 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrm),
     /*  14288 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14290 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14292 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14296 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14301 */     GIR_RootConstrainSelectedInstOperands,
     /*  14302 */     // GIR_Coverage, 2575,
     /*  14302 */     GIR_EraseRootFromParent_Done,
     /*  14303 */   // Label 435: @14303
     /*  14303 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(14365), // Rule ID 4993 //
     /*  14308 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14311 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14315 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14319 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14323 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14327 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14330 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14334 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14338 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14340 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14347 */     // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rm),
     /*  14350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14352 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14354 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14358 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14363 */     GIR_RootConstrainSelectedInstOperands,
     /*  14364 */     // GIR_Coverage, 4993,
     /*  14364 */     GIR_EraseRootFromParent_Done,
     /*  14365 */   // Label 436: @14365
     /*  14365 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(14392), // Rule ID 2574 //
     /*  14370 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14373 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14377 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14381 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14385 */     // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPMULLWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  14385 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrr),
     /*  14390 */     GIR_RootConstrainSelectedInstOperands,
     /*  14391 */     // GIR_Coverage, 2574,
     /*  14391 */     GIR_Done,
     /*  14392 */   // Label 437: @14392
     /*  14392 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(14419), // Rule ID 4990 //
     /*  14397 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14400 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14404 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14408 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14412 */     // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPMULLWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  14412 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rr),
     /*  14417 */     GIR_RootConstrainSelectedInstOperands,
     /*  14418 */     // GIR_Coverage, 4990,
     /*  14418 */     GIR_Done,
     /*  14419 */   // Label 438: @14419
     /*  14419 */   GIM_Reject,
     /*  14420 */ // Label 432: @14420
     /*  14420 */ GIM_Reject,
     /*  14421 */ // Label 365: @14421
     /*  14421 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(14576),
     /*  14426 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  14429 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  14432 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14436 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(14494), // Rule ID 23786 //
     /*  14441 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14452 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14455 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14459 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14463 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14467 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14469 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14476 */     // (mul:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPMULLDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14476 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrm),
     /*  14479 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14481 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14483 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14487 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14492 */     GIR_RootConstrainSelectedInstOperands,
     /*  14493 */     // GIR_Coverage, 23786,
     /*  14493 */     GIR_EraseRootFromParent_Done,
     /*  14494 */   // Label 440: @14494
     /*  14494 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(14552), // Rule ID 4960 //
     /*  14499 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14502 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14506 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14510 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14514 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14517 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14521 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14525 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14527 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14534 */     // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrm),
     /*  14537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14539 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14541 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14545 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14550 */     GIR_RootConstrainSelectedInstOperands,
     /*  14551 */     // GIR_Coverage, 4960,
     /*  14551 */     GIR_EraseRootFromParent_Done,
     /*  14552 */   // Label 441: @14552
     /*  14552 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(14575), // Rule ID 4957 //
     /*  14557 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14560 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14564 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14568 */     // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPMULLDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  14568 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrr),
     /*  14573 */     GIR_RootConstrainSelectedInstOperands,
     /*  14574 */     // GIR_Coverage, 4957,
     /*  14574 */     GIR_Done,
     /*  14575 */   // Label 442: @14575
     /*  14575 */   GIM_Reject,
     /*  14576 */ // Label 439: @14576
     /*  14576 */ GIM_Reject,
     /*  14577 */ // Label 366: @14577
     /*  14577 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(14732),
     /*  14582 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  14585 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  14588 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14592 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(14650), // Rule ID 23804 //
     /*  14597 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14608 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14611 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14615 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14619 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14623 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14625 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14632 */     // (mul:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPMULLWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrm),
     /*  14635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14637 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14639 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14643 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14648 */     GIR_RootConstrainSelectedInstOperands,
     /*  14649 */     // GIR_Coverage, 23804,
     /*  14649 */     GIR_EraseRootFromParent_Done,
     /*  14650 */   // Label 444: @14650
     /*  14650 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(14708), // Rule ID 4987 //
     /*  14655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14658 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14670 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14673 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14677 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14681 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14683 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14690 */     // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14690 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrm),
     /*  14693 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14695 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14697 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14701 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14706 */     GIR_RootConstrainSelectedInstOperands,
     /*  14707 */     // GIR_Coverage, 4987,
     /*  14707 */     GIR_EraseRootFromParent_Done,
     /*  14708 */   // Label 445: @14708
     /*  14708 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(14731), // Rule ID 4984 //
     /*  14713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14716 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14720 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14724 */     // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPMULLWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  14724 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrr),
     /*  14729 */     GIR_RootConstrainSelectedInstOperands,
     /*  14730 */     // GIR_Coverage, 4984,
     /*  14730 */     GIR_Done,
     /*  14731 */   // Label 446: @14731
     /*  14731 */   GIM_Reject,
     /*  14732 */ // Label 443: @14732
     /*  14732 */ GIM_Reject,
     /*  14733 */ // Label 367: @14733
     /*  14733 */ GIM_Reject,
     /*  14734 */ // Label 3: @14734
     /*  14734 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 470*/ GIMT_Encode4(25325),
     /*  14745 */ /*GILLT_s1*//*Label 447*/ GIMT_Encode4(14845),
     /*  14749 */ /*GILLT_s8*//*Label 448*/ GIMT_Encode4(15191),
     /*  14753 */ /*GILLT_s16*//*Label 449*/ GIMT_Encode4(15584),
     /*  14757 */ /*GILLT_s32*//*Label 450*/ GIMT_Encode4(16269),
     /*  14761 */ /*GILLT_s64*//*Label 451*/ GIMT_Encode4(18095), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14773 */ /*GILLT_v2s1*//*Label 452*/ GIMT_Encode4(19799),
     /*  14777 */ /*GILLT_v2s64*//*Label 453*/ GIMT_Encode4(20145),
     /*  14781 */ /*GILLT_v4s1*//*Label 454*/ GIMT_Encode4(20487),
     /*  14785 */ /*GILLT_v4s32*//*Label 455*/ GIMT_Encode4(20833),
     /*  14789 */ /*GILLT_v4s64*//*Label 456*/ GIMT_Encode4(21175),
     /*  14793 */ /*GILLT_v8s1*//*Label 457*/ GIMT_Encode4(21641),
     /*  14797 */ /*GILLT_v8s16*//*Label 458*/ GIMT_Encode4(22139),
     /*  14801 */ /*GILLT_v8s32*//*Label 459*/ GIMT_Encode4(22481),
     /*  14805 */ /*GILLT_v8s64*//*Label 460*/ GIMT_Encode4(22947),
     /*  14809 */ /*GILLT_v16s1*//*Label 461*/ GIMT_Encode4(23103),
     /*  14813 */ /*GILLT_v16s8*//*Label 462*/ GIMT_Encode4(23263),
     /*  14817 */ /*GILLT_v16s16*//*Label 463*/ GIMT_Encode4(23605),
     /*  14821 */ /*GILLT_v16s32*//*Label 464*/ GIMT_Encode4(24071),
     /*  14825 */ /*GILLT_v32s1*//*Label 465*/ GIMT_Encode4(24227),
     /*  14829 */ /*GILLT_v32s8*//*Label 466*/ GIMT_Encode4(24387),
     /*  14833 */ /*GILLT_v32s16*//*Label 467*/ GIMT_Encode4(24853),
     /*  14837 */ /*GILLT_v64s1*//*Label 468*/ GIMT_Encode4(25009),
     /*  14841 */ /*GILLT_v64s8*//*Label 469*/ GIMT_Encode4(25169),
     /*  14845 */ // Label 447: @14845
     /*  14845 */ GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(15190),
     /*  14850 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  14853 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  14856 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14860 */   GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(14980), // Rule ID 19488 //
     /*  14865 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14869 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14873 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  14877 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*  14881 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14886 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  14890 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14896 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  14898 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14902 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14904 */     // (and:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  14904 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  14907 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14911 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14916 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  14920 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  14925 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  14928 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14932 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14937 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  14941 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  14946 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  14949 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  14953 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14958 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14961 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  14964 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14966 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14969 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14971 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  14974 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  14979 */     // GIR_Coverage, 19488,
     /*  14979 */     GIR_EraseRootFromParent_Done,
     /*  14980 */   // Label 472: @14980
     /*  14980 */   GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(15100), // Rule ID 25367 //
     /*  14985 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14989 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14993 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14997 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  15001 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*  15005 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15010 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15014 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15020 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  15022 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15024 */     // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  15024 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  15027 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15031 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15036 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  15040 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15045 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  15048 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15052 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15057 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  15061 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15066 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  15069 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  15073 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15078 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15081 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  15084 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  15086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15091 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15094 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  15099 */     // GIR_Coverage, 25367,
     /*  15099 */     GIR_EraseRootFromParent_Done,
     /*  15100 */   // Label 473: @15100
     /*  15100 */   GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(15189), // Rule ID 19484 //
     /*  15105 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15109 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15113 */     // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  15113 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  15116 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15120 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15125 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  15129 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15134 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  15137 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15141 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15146 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  15150 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15155 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  15158 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  15162 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15167 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15170 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  15173 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  15175 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15178 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15180 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15183 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  15188 */     // GIR_Coverage, 19484,
     /*  15188 */     GIR_EraseRootFromParent_Done,
     /*  15189 */   // Label 474: @15189
     /*  15189 */   GIM_Reject,
     /*  15190 */ // Label 471: @15190
     /*  15190 */ GIM_Reject,
     /*  15191 */ // Label 448: @15191
     /*  15191 */ GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(15583),
     /*  15196 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*  15199 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*  15202 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15206 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(15267), // Rule ID 26069 //
     /*  15211 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15214 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15218 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15222 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15225 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15229 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15233 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15237 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15239 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15246 */     // (and:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (AND8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm),
     /*  15249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15251 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15253 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15257 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15260 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15265 */     GIR_RootConstrainSelectedInstOperands,
     /*  15266 */     // GIR_Coverage, 26069,
     /*  15266 */     GIR_EraseRootFromParent_Done,
     /*  15267 */   // Label 476: @15267
     /*  15267 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(15328), // Rule ID 26088 //
     /*  15272 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15275 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15279 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15283 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15286 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15290 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15294 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15298 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15300 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15307 */     // (and:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (AND8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm_ND),
     /*  15310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15312 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15314 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15318 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15321 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15326 */     GIR_RootConstrainSelectedInstOperands,
     /*  15327 */     // GIR_Coverage, 26088,
     /*  15327 */     GIR_EraseRootFromParent_Done,
     /*  15328 */   // Label 477: @15328
     /*  15328 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(15389), // Rule ID 22854 //
     /*  15333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15336 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15348 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15351 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15355 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15359 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15361 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15368 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (AND8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm),
     /*  15371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15373 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15375 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15379 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15382 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15387 */     GIR_RootConstrainSelectedInstOperands,
     /*  15388 */     // GIR_Coverage, 22854,
     /*  15388 */     GIR_EraseRootFromParent_Done,
     /*  15389 */   // Label 478: @15389
     /*  15389 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(15450), // Rule ID 22944 //
     /*  15394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15409 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15412 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15416 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15420 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15422 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15429 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (AND8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm_ND),
     /*  15432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15434 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15436 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15440 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15443 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15448 */     GIR_RootConstrainSelectedInstOperands,
     /*  15449 */     // GIR_Coverage, 22944,
     /*  15449 */     GIR_EraseRootFromParent_Done,
     /*  15450 */   // Label 479: @15450
     /*  15450 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(15487), // Rule ID 22858 //
     /*  15455 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15458 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15462 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15466 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15470 */     // MIs[1] Operand 1
     /*  15470 */     // No operand predicates
     /*  15470 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15472 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  15472 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri),
     /*  15475 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15477 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15479 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  15482 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15485 */     GIR_RootConstrainSelectedInstOperands,
     /*  15486 */     // GIR_Coverage, 22858,
     /*  15486 */     GIR_EraseRootFromParent_Done,
     /*  15487 */   // Label 480: @15487
     /*  15487 */   GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(15524), // Rule ID 22948 //
     /*  15492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15495 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15507 */     // MIs[1] Operand 1
     /*  15507 */     // No operand predicates
     /*  15507 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15509 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  15509 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri_ND),
     /*  15512 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15514 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15516 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  15519 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15522 */     GIR_RootConstrainSelectedInstOperands,
     /*  15523 */     // GIR_Coverage, 22948,
     /*  15523 */     GIR_EraseRootFromParent_Done,
     /*  15524 */   // Label 481: @15524
     /*  15524 */   GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(15553), // Rule ID 22850 //
     /*  15529 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15532 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15536 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15540 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  15540 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr),
     /*  15545 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  15551 */     GIR_RootConstrainSelectedInstOperands,
     /*  15552 */     // GIR_Coverage, 22850,
     /*  15552 */     GIR_Done,
     /*  15553 */   // Label 482: @15553
     /*  15553 */   GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(15582), // Rule ID 22940 //
     /*  15558 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15561 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15565 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15569 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  15569 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr_ND),
     /*  15574 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  15580 */     GIR_RootConstrainSelectedInstOperands,
     /*  15581 */     // GIR_Coverage, 22940,
     /*  15581 */     GIR_Done,
     /*  15582 */   // Label 483: @15582
     /*  15582 */   GIM_Reject,
     /*  15583 */ // Label 475: @15583
     /*  15583 */ GIM_Reject,
     /*  15584 */ // Label 449: @15584
     /*  15584 */ GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(16268),
     /*  15589 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  15592 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  15595 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15599 */   GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(15660), // Rule ID 26070 //
     /*  15604 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15607 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15611 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15615 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15618 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15622 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15626 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15630 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15632 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15639 */     // (and:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (AND16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15639 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm),
     /*  15642 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15644 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15646 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15650 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15653 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15658 */     GIR_RootConstrainSelectedInstOperands,
     /*  15659 */     // GIR_Coverage, 26070,
     /*  15659 */     GIR_EraseRootFromParent_Done,
     /*  15660 */   // Label 485: @15660
     /*  15660 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(15721), // Rule ID 26089 //
     /*  15665 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15668 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15672 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15676 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15679 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15683 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15687 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15691 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15693 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15700 */     // (and:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (AND16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15700 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm_ND),
     /*  15703 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15705 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15707 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15711 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15714 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15719 */     GIR_RootConstrainSelectedInstOperands,
     /*  15720 */     // GIR_Coverage, 26089,
     /*  15720 */     GIR_EraseRootFromParent_Done,
     /*  15721 */   // Label 486: @15721
     /*  15721 */   GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(15782), // Rule ID 22855 //
     /*  15726 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15729 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15733 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15737 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15741 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15744 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15748 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15752 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15754 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15761 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (AND16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15761 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm),
     /*  15764 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15766 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15768 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15772 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15775 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15780 */     GIR_RootConstrainSelectedInstOperands,
     /*  15781 */     // GIR_Coverage, 22855,
     /*  15781 */     GIR_EraseRootFromParent_Done,
     /*  15782 */   // Label 487: @15782
     /*  15782 */   GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(15843), // Rule ID 22945 //
     /*  15787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15790 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15794 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15798 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15802 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15805 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15809 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15813 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15815 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15822 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (AND16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15822 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm_ND),
     /*  15825 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15827 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15829 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15833 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15836 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15841 */     GIR_RootConstrainSelectedInstOperands,
     /*  15842 */     // GIR_Coverage, 22945,
     /*  15842 */     GIR_EraseRootFromParent_Done,
     /*  15843 */   // Label 488: @15843
     /*  15843 */   GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(15945), // Rule ID 26036 //
     /*  15848 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15852 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  15856 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15860 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  15864 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  15868 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15873 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15877 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15879 */     // (and:{ *:[i16] } (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  15879 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  15882 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15886 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15891 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  15893 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  15896 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  15900 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15905 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15908 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  15912 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  15915 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  15920 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  15925 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  15930 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
     /*  15933 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15935 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15937 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15940 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15943 */     GIR_RootConstrainSelectedInstOperands,
     /*  15944 */     // GIR_Coverage, 26036,
     /*  15944 */     GIR_EraseRootFromParent_Done,
     /*  15945 */   // Label 489: @15945
     /*  15945 */   GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(16047), // Rule ID 22774 //
     /*  15950 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15954 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15958 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  15962 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15966 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  15970 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  15974 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15979 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15981 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  15981 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  15984 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15988 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15993 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  15995 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  15998 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  16002 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16007 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  16010 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  16014 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  16017 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  16022 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  16027 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  16032 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
     /*  16035 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16037 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16039 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  16042 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16045 */     GIR_RootConstrainSelectedInstOperands,
     /*  16046 */     // GIR_Coverage, 22774,
     /*  16046 */     GIR_EraseRootFromParent_Done,
     /*  16047 */   // Label 490: @16047
     /*  16047 */   GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(16135), // Rule ID 22634 //
     /*  16052 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16056 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  16067 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, 255:{ *:[i16] })  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src1, sub_8bit:{ *:[i32] })), sub_16bit:{ *:[i32] })
     /*  16067 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s8,
     /*  16070 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  16074 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16079 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
     /*  16085 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
     /*  16090 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  16095 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  16098 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
     /*  16102 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16107 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  16110 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  16112 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  16115 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16117 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
     /*  16124 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  16129 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  16134 */     // GIR_Coverage, 22634,
     /*  16134 */     GIR_EraseRootFromParent_Done,
     /*  16135 */   // Label 491: @16135
     /*  16135 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(16172), // Rule ID 22859 //
     /*  16140 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16143 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16147 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16151 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16155 */     // MIs[1] Operand 1
     /*  16155 */     // No operand predicates
     /*  16155 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16157 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  16157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri),
     /*  16160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16162 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16164 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  16167 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16170 */     GIR_RootConstrainSelectedInstOperands,
     /*  16171 */     // GIR_Coverage, 22859,
     /*  16171 */     GIR_EraseRootFromParent_Done,
     /*  16172 */   // Label 492: @16172
     /*  16172 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(16209), // Rule ID 22949 //
     /*  16177 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16180 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16184 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16188 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16192 */     // MIs[1] Operand 1
     /*  16192 */     // No operand predicates
     /*  16192 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16194 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  16194 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri_ND),
     /*  16197 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16199 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16201 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  16204 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16207 */     GIR_RootConstrainSelectedInstOperands,
     /*  16208 */     // GIR_Coverage, 22949,
     /*  16208 */     GIR_EraseRootFromParent_Done,
     /*  16209 */   // Label 493: @16209
     /*  16209 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(16238), // Rule ID 22851 //
     /*  16214 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16217 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16221 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16225 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  16225 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr),
     /*  16230 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  16236 */     GIR_RootConstrainSelectedInstOperands,
     /*  16237 */     // GIR_Coverage, 22851,
     /*  16237 */     GIR_Done,
     /*  16238 */   // Label 494: @16238
     /*  16238 */   GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(16267), // Rule ID 22941 //
     /*  16243 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16246 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16254 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  16254 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr_ND),
     /*  16259 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  16265 */     GIR_RootConstrainSelectedInstOperands,
     /*  16266 */     // GIR_Coverage, 22941,
     /*  16266 */     GIR_Done,
     /*  16267 */   // Label 495: @16267
     /*  16267 */   GIM_Reject,
     /*  16268 */ // Label 484: @16268
     /*  16268 */ GIM_Reject,
     /*  16269 */ // Label 450: @16269
     /*  16269 */ GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(18094),
     /*  16274 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  16277 */   GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(16369), // Rule ID 17546 //
     /*  16282 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  16285 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16288 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16292 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16296 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16300 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16304 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16308 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16313 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16317 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16321 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16325 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16328 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  16332 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16336 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16338 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16345 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ANDN32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16345 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm),
     /*  16348 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16350 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  16354 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16358 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16361 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16367 */     GIR_RootConstrainSelectedInstOperands,
     /*  16368 */     // GIR_Coverage, 17546,
     /*  16368 */     GIR_EraseRootFromParent_Done,
     /*  16369 */   // Label 497: @16369
     /*  16369 */   GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(16461), // Rule ID 17550 //
     /*  16374 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  16377 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16392 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16396 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16400 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16405 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16409 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16413 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16417 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16420 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  16424 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16428 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16430 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16437 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ANDN32rm_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16437 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm_EVEX),
     /*  16440 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  16446 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16450 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16453 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16459 */     GIR_RootConstrainSelectedInstOperands,
     /*  16460 */     // GIR_Coverage, 17550,
     /*  16460 */     GIR_EraseRootFromParent_Done,
     /*  16461 */   // Label 498: @16461
     /*  16461 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(16553), // Rule ID 25103 //
     /*  16466 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  16469 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16484 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16487 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16491 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16495 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16499 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16503 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16507 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16511 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16516 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  16520 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16522 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16529 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16529 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm),
     /*  16532 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16534 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  16538 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16542 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16545 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16551 */     GIR_RootConstrainSelectedInstOperands,
     /*  16552 */     // GIR_Coverage, 25103,
     /*  16552 */     GIR_EraseRootFromParent_Done,
     /*  16553 */   // Label 499: @16553
     /*  16553 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(16645), // Rule ID 25107 //
     /*  16558 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  16561 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16564 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16568 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16572 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16576 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16579 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16583 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16587 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16591 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16595 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16599 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16603 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16608 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  16612 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16614 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16621 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rm_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm_EVEX),
     /*  16624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  16630 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16634 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16637 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16643 */     GIR_RootConstrainSelectedInstOperands,
     /*  16644 */     // GIR_Coverage, 25107,
     /*  16644 */     GIR_EraseRootFromParent_Done,
     /*  16645 */   // Label 500: @16645
     /*  16645 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(16713), // Rule ID 26071 //
     /*  16650 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16653 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16668 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16671 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16675 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16679 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16683 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16685 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16692 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (AND32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16692 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm),
     /*  16695 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16697 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  16699 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16703 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16706 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16711 */     GIR_RootConstrainSelectedInstOperands,
     /*  16712 */     // GIR_Coverage, 26071,
     /*  16712 */     GIR_EraseRootFromParent_Done,
     /*  16713 */   // Label 501: @16713
     /*  16713 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(16781), // Rule ID 26090 //
     /*  16718 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16721 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16724 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16736 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16739 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16743 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16747 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16751 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16753 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16760 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (AND32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16760 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm_ND),
     /*  16763 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16765 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  16767 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16771 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16774 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16779 */     GIR_RootConstrainSelectedInstOperands,
     /*  16780 */     // GIR_Coverage, 26090,
     /*  16780 */     GIR_EraseRootFromParent_Done,
     /*  16781 */   // Label 502: @16781
     /*  16781 */   GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(16849), // Rule ID 22856 //
     /*  16786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16789 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16792 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16796 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16808 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16811 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16815 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16819 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16821 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16828 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (AND32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16828 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm),
     /*  16831 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16833 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16835 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16839 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16842 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16847 */     GIR_RootConstrainSelectedInstOperands,
     /*  16848 */     // GIR_Coverage, 22856,
     /*  16848 */     GIR_EraseRootFromParent_Done,
     /*  16849 */   // Label 503: @16849
     /*  16849 */   GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(16917), // Rule ID 22946 //
     /*  16854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16857 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16860 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16864 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16868 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16872 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16876 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16879 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16883 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16887 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16889 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16896 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (AND32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16896 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm_ND),
     /*  16899 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16901 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16903 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16907 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16910 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16915 */     GIR_RootConstrainSelectedInstOperands,
     /*  16916 */     // GIR_Coverage, 22946,
     /*  16916 */     GIR_EraseRootFromParent_Done,
     /*  16917 */   // Label 504: @16917
     /*  16917 */   GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(16994), // Rule ID 24995 //
     /*  16922 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  16925 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16932 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16936 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16940 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16944 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16948 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16953 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  16957 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16961 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16965 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16969 */     // MIs[2] src
     /*  16969 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16974 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  16978 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16980 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  16980 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
     /*  16983 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16985 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  16989 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16992 */     GIR_RootConstrainSelectedInstOperands,
     /*  16993 */     // GIR_Coverage, 24995,
     /*  16993 */     GIR_EraseRootFromParent_Done,
     /*  16994 */   // Label 505: @16994
     /*  16994 */   GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(17071), // Rule ID 25007 //
     /*  16999 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17002 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17005 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17009 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17013 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17017 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17021 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17025 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17030 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17034 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17038 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17042 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17046 */     // MIs[2] src
     /*  17046 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17051 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  17055 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17057 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17057 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
     /*  17060 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17062 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17066 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17069 */     GIR_RootConstrainSelectedInstOperands,
     /*  17070 */     // GIR_Coverage, 25007,
     /*  17070 */     GIR_EraseRootFromParent_Done,
     /*  17071 */   // Label 506: @17071
     /*  17071 */   GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(17148), // Rule ID 17356 //
     /*  17076 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17079 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17082 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17086 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17090 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17094 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17098 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17102 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17107 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17111 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17115 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17119 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17123 */     // MIs[2] src
     /*  17123 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17128 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  17132 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17134 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17134 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
     /*  17137 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17143 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17146 */     GIR_RootConstrainSelectedInstOperands,
     /*  17147 */     // GIR_Coverage, 17356,
     /*  17147 */     GIR_EraseRootFromParent_Done,
     /*  17148 */   // Label 507: @17148
     /*  17148 */   GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(17225), // Rule ID 17368 //
     /*  17153 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17156 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17159 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17163 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17167 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17171 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17175 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17179 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17184 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17188 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17192 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17196 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17200 */     // MIs[2] src
     /*  17200 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17205 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  17209 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17211 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
     /*  17214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17220 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17223 */     GIR_RootConstrainSelectedInstOperands,
     /*  17224 */     // GIR_Coverage, 17368,
     /*  17224 */     GIR_EraseRootFromParent_Done,
     /*  17225 */   // Label 508: @17225
     /*  17225 */   GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(17283), // Rule ID 24989 //
     /*  17230 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17233 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17237 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17241 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17245 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17249 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17253 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17258 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  17262 */     // MIs[0] src
     /*  17262 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17267 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17269 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17269 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
     /*  17272 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17274 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17278 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17281 */     GIR_RootConstrainSelectedInstOperands,
     /*  17282 */     // GIR_Coverage, 24989,
     /*  17282 */     GIR_EraseRootFromParent_Done,
     /*  17283 */   // Label 509: @17283
     /*  17283 */   GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(17392), // Rule ID 26042 //
     /*  17288 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  17303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  17311 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  17315 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  17320 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17324 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17326 */     // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  17326 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17329 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  17333 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17338 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  17340 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17343 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  17347 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17352 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17355 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  17359 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  17362 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17367 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17372 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  17377 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
     /*  17380 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17382 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  17384 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17387 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17390 */     GIR_RootConstrainSelectedInstOperands,
     /*  17391 */     // GIR_Coverage, 26042,
     /*  17391 */     GIR_EraseRootFromParent_Done,
     /*  17392 */   // Label 510: @17392
     /*  17392 */   GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(17446), // Rule ID 17350 //
     /*  17397 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17400 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17403 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17407 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17411 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17415 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17419 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17423 */     // MIs[1] src
     /*  17423 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  17428 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  17432 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17434 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17434 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
     /*  17437 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17439 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  17441 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17444 */     GIR_RootConstrainSelectedInstOperands,
     /*  17445 */     // GIR_Coverage, 17350,
     /*  17445 */     GIR_EraseRootFromParent_Done,
     /*  17446 */   // Label 511: @17446
     /*  17446 */   GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(17555), // Rule ID 22780 //
     /*  17451 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17458 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17462 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17466 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  17470 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17474 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  17478 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  17482 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  17487 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17489 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  17489 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17492 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  17496 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17501 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  17503 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17506 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  17510 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17515 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17518 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  17522 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  17525 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17530 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17535 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  17540 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
     /*  17543 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17545 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17547 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17550 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17553 */     GIR_RootConstrainSelectedInstOperands,
     /*  17554 */     // GIR_Coverage, 22780,
     /*  17554 */     GIR_EraseRootFromParent_Done,
     /*  17555 */   // Label 512: @17555
     /*  17555 */   GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(17620), // Rule ID 22632 //
     /*  17560 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17563 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17567 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17571 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
     /*  17582 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 65535:{ *:[i32] })  =>  (MOVZX32rr16:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src1, sub_16bit:{ *:[i32] }))
     /*  17582 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  17585 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17589 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17594 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src1
     /*  17600 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  17605 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  17610 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
     /*  17613 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17615 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17618 */     GIR_RootConstrainSelectedInstOperands,
     /*  17619 */     // GIR_Coverage, 22632,
     /*  17619 */     GIR_EraseRootFromParent_Done,
     /*  17620 */   // Label 513: @17620
     /*  17620 */   GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(17685), // Rule ID 22633 //
     /*  17625 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17628 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17632 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17636 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  17647 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 255:{ *:[i32] })  =>  (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src1, sub_8bit:{ *:[i32] }))
     /*  17647 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s8,
     /*  17650 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17654 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17659 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
     /*  17665 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
     /*  17670 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  17675 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
     /*  17678 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17680 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17683 */     GIR_RootConstrainSelectedInstOperands,
     /*  17684 */     // GIR_Coverage, 22633,
     /*  17684 */     GIR_EraseRootFromParent_Done,
     /*  17685 */   // Label 514: @17685
     /*  17685 */   GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(17729), // Rule ID 22860 //
     /*  17690 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  17693 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17696 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17700 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17704 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17708 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17712 */     // MIs[1] Operand 1
     /*  17712 */     // No operand predicates
     /*  17712 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17714 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  17714 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri),
     /*  17717 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17719 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17721 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  17724 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17727 */     GIR_RootConstrainSelectedInstOperands,
     /*  17728 */     // GIR_Coverage, 22860,
     /*  17728 */     GIR_EraseRootFromParent_Done,
     /*  17729 */   // Label 515: @17729
     /*  17729 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(17773), // Rule ID 22950 //
     /*  17734 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  17737 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17740 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17744 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17748 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17752 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17756 */     // MIs[1] Operand 1
     /*  17756 */     // No operand predicates
     /*  17756 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17758 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  17758 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri_ND),
     /*  17761 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17763 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17765 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  17768 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17771 */     GIR_RootConstrainSelectedInstOperands,
     /*  17772 */     // GIR_Coverage, 22950,
     /*  17772 */     GIR_EraseRootFromParent_Done,
     /*  17773 */   // Label 516: @17773
     /*  17773 */   GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(17835), // Rule ID 17544 //
     /*  17778 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  17781 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17784 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17788 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17792 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17796 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17800 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17804 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17809 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17813 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17817 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17819 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
     /*  17822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17824 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17828 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  17830 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17833 */     GIR_RootConstrainSelectedInstOperands,
     /*  17834 */     // GIR_Coverage, 17544,
     /*  17834 */     GIR_EraseRootFromParent_Done,
     /*  17835 */   // Label 517: @17835
     /*  17835 */   GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(17897), // Rule ID 17548 //
     /*  17840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  17843 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17846 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17850 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17854 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17858 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17862 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17866 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17871 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17875 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17879 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17881 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17881 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
     /*  17884 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17886 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17890 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  17892 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17895 */     GIR_RootConstrainSelectedInstOperands,
     /*  17896 */     // GIR_Coverage, 17548,
     /*  17896 */     GIR_EraseRootFromParent_Done,
     /*  17897 */   // Label 518: @17897
     /*  17897 */   GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(17959), // Rule ID 25101 //
     /*  17902 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  17905 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17908 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17912 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17916 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17920 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17924 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17928 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17932 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17937 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17941 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17943 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
     /*  17946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17948 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17952 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  17954 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17957 */     GIR_RootConstrainSelectedInstOperands,
     /*  17958 */     // GIR_Coverage, 25101,
     /*  17958 */     GIR_EraseRootFromParent_Done,
     /*  17959 */   // Label 519: @17959
     /*  17959 */   GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(18021), // Rule ID 25105 //
     /*  17964 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  17967 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17970 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17974 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17978 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17982 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17986 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17990 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17994 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17999 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  18003 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18005 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18005 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
     /*  18008 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18014 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  18016 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18019 */     GIR_RootConstrainSelectedInstOperands,
     /*  18020 */     // GIR_Coverage, 25105,
     /*  18020 */     GIR_EraseRootFromParent_Done,
     /*  18021 */   // Label 520: @18021
     /*  18021 */   GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(18057), // Rule ID 22852 //
     /*  18026 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18029 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  18032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18036 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18040 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18044 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18044 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr),
     /*  18049 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  18055 */     GIR_RootConstrainSelectedInstOperands,
     /*  18056 */     // GIR_Coverage, 22852,
     /*  18056 */     GIR_Done,
     /*  18057 */   // Label 521: @18057
     /*  18057 */   GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(18093), // Rule ID 22942 //
     /*  18062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18065 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  18068 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18072 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18076 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18080 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18080 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr_ND),
     /*  18085 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  18091 */     GIR_RootConstrainSelectedInstOperands,
     /*  18092 */     // GIR_Coverage, 22942,
     /*  18092 */     GIR_Done,
     /*  18093 */   // Label 522: @18093
     /*  18093 */   GIM_Reject,
     /*  18094 */ // Label 496: @18094
     /*  18094 */ GIM_Reject,
     /*  18095 */ // Label 451: @18095
     /*  18095 */ GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(19798),
     /*  18100 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  18103 */   GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(18195), // Rule ID 17547 //
     /*  18108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  18111 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18114 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18118 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18122 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18126 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18130 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18134 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18139 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  18143 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18147 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18151 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18154 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/2, /*MMO*/0, /*OpIdx*/0,
     /*  18158 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  18162 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18164 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18171 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ANDN64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18171 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm),
     /*  18174 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18180 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18184 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18187 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18193 */     GIR_RootConstrainSelectedInstOperands,
     /*  18194 */     // GIR_Coverage, 17547,
     /*  18194 */     GIR_EraseRootFromParent_Done,
     /*  18195 */   // Label 524: @18195
     /*  18195 */   GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(18287), // Rule ID 17551 //
     /*  18200 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  18203 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18210 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18214 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18218 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18222 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18226 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18231 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  18235 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18239 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18243 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18246 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/2, /*MMO*/0, /*OpIdx*/0,
     /*  18250 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  18254 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18256 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18263 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ANDN64rm_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18263 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm_EVEX),
     /*  18266 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18268 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18272 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18276 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18279 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18285 */     GIR_RootConstrainSelectedInstOperands,
     /*  18286 */     // GIR_Coverage, 17551,
     /*  18286 */     GIR_EraseRootFromParent_Done,
     /*  18287 */   // Label 525: @18287
     /*  18287 */   GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(18379), // Rule ID 25104 //
     /*  18292 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  18295 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18298 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18302 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18306 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18310 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18313 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18317 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18321 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18325 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18329 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  18333 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18337 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18342 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  18346 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18348 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18355 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18355 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm),
     /*  18358 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18360 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  18364 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18368 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18371 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18377 */     GIR_RootConstrainSelectedInstOperands,
     /*  18378 */     // GIR_Coverage, 25104,
     /*  18378 */     GIR_EraseRootFromParent_Done,
     /*  18379 */   // Label 526: @18379
     /*  18379 */   GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(18471), // Rule ID 25108 //
     /*  18384 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  18387 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18390 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18402 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18405 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18409 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18413 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18417 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18421 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  18425 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18429 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18434 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  18438 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18440 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18447 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rm_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm_EVEX),
     /*  18450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  18456 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18460 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18463 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18469 */     GIR_RootConstrainSelectedInstOperands,
     /*  18470 */     // GIR_Coverage, 25108,
     /*  18470 */     GIR_EraseRootFromParent_Done,
     /*  18471 */   // Label 527: @18471
     /*  18471 */   GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(18539), // Rule ID 26072 //
     /*  18476 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18479 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18482 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18486 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18490 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18494 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18497 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18501 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18505 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18509 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18511 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18518 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (AND64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18518 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm),
     /*  18521 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18523 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  18525 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18529 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18532 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18537 */     GIR_RootConstrainSelectedInstOperands,
     /*  18538 */     // GIR_Coverage, 26072,
     /*  18538 */     GIR_EraseRootFromParent_Done,
     /*  18539 */   // Label 528: @18539
     /*  18539 */   GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(18607), // Rule ID 26091 //
     /*  18544 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18547 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18550 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18554 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18558 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18562 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18565 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18569 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18573 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18577 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18579 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18586 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (AND64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18586 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm_ND),
     /*  18589 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18591 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  18593 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18597 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18600 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18605 */     GIR_RootConstrainSelectedInstOperands,
     /*  18606 */     // GIR_Coverage, 26091,
     /*  18606 */     GIR_EraseRootFromParent_Done,
     /*  18607 */   // Label 529: @18607
     /*  18607 */   GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(18675), // Rule ID 22857 //
     /*  18612 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18615 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18618 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18622 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18626 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18630 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18634 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18637 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18641 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18645 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18647 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18654 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (AND64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm),
     /*  18657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18659 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  18661 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18665 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18668 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18673 */     GIR_RootConstrainSelectedInstOperands,
     /*  18674 */     // GIR_Coverage, 22857,
     /*  18674 */     GIR_EraseRootFromParent_Done,
     /*  18675 */   // Label 530: @18675
     /*  18675 */   GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(18743), // Rule ID 22947 //
     /*  18680 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18683 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18690 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18702 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18705 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18709 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18713 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18715 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18722 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (AND64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm_ND),
     /*  18725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18727 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  18729 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18733 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18736 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18741 */     GIR_RootConstrainSelectedInstOperands,
     /*  18742 */     // GIR_Coverage, 22947,
     /*  18742 */     GIR_EraseRootFromParent_Done,
     /*  18743 */   // Label 531: @18743
     /*  18743 */   GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(18820), // Rule ID 24996 //
     /*  18748 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18751 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18754 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18766 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18770 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18774 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18779 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  18783 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18787 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18791 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18795 */     // MIs[2] src
     /*  18795 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18800 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  18804 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18806 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18806 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
     /*  18809 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18815 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18818 */     GIR_RootConstrainSelectedInstOperands,
     /*  18819 */     // GIR_Coverage, 24996,
     /*  18819 */     GIR_EraseRootFromParent_Done,
     /*  18820 */   // Label 532: @18820
     /*  18820 */   GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(18897), // Rule ID 25008 //
     /*  18825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18828 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18831 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18835 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18839 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18843 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18847 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18851 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18856 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  18860 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18864 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18868 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18872 */     // MIs[2] src
     /*  18872 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18877 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  18881 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18883 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18883 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
     /*  18886 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18888 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18892 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18895 */     GIR_RootConstrainSelectedInstOperands,
     /*  18896 */     // GIR_Coverage, 25008,
     /*  18896 */     GIR_EraseRootFromParent_Done,
     /*  18897 */   // Label 533: @18897
     /*  18897 */   GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(18974), // Rule ID 17357 //
     /*  18902 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18905 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18908 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18912 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18916 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18920 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18924 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18928 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18933 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  18937 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18941 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18945 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18949 */     // MIs[2] src
     /*  18949 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18954 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  18958 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18960 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18960 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
     /*  18963 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18965 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18969 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18972 */     GIR_RootConstrainSelectedInstOperands,
     /*  18973 */     // GIR_Coverage, 17357,
     /*  18973 */     GIR_EraseRootFromParent_Done,
     /*  18974 */   // Label 534: @18974
     /*  18974 */   GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(19051), // Rule ID 17369 //
     /*  18979 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18982 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18985 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18989 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18993 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18997 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19001 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19005 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19010 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  19014 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  19018 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19022 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19026 */     // MIs[2] src
     /*  19026 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19031 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  19035 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19037 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19037 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
     /*  19040 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  19046 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19049 */     GIR_RootConstrainSelectedInstOperands,
     /*  19050 */     // GIR_Coverage, 17369,
     /*  19050 */     GIR_EraseRootFromParent_Done,
     /*  19051 */   // Label 535: @19051
     /*  19051 */   GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(19109), // Rule ID 24990 //
     /*  19056 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  19059 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19063 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19067 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19071 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19075 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19079 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19084 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  19088 */     // MIs[0] src
     /*  19088 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19093 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19095 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19095 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
     /*  19098 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19100 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  19104 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19107 */     GIR_RootConstrainSelectedInstOperands,
     /*  19108 */     // GIR_Coverage, 24990,
     /*  19108 */     GIR_EraseRootFromParent_Done,
     /*  19109 */   // Label 536: @19109
     /*  19109 */   GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(19218), // Rule ID 26048 //
     /*  19114 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19117 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19121 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19125 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  19129 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19133 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  19137 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  19141 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  19146 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19150 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19152 */     // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  19152 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  19155 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  19159 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19164 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  19166 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  19169 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  19173 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19178 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19181 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  19185 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  19188 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19193 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19198 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  19203 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
     /*  19206 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19208 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  19210 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19213 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19216 */     GIR_RootConstrainSelectedInstOperands,
     /*  19217 */     // GIR_Coverage, 26048,
     /*  19217 */     GIR_EraseRootFromParent_Done,
     /*  19218 */   // Label 537: @19218
     /*  19218 */   GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(19272), // Rule ID 17351 //
     /*  19223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  19226 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19229 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19233 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19237 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19241 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19245 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19249 */     // MIs[1] src
     /*  19249 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  19254 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  19258 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19260 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19260 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
     /*  19263 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19265 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  19267 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19270 */     GIR_RootConstrainSelectedInstOperands,
     /*  19271 */     // GIR_Coverage, 17351,
     /*  19271 */     GIR_EraseRootFromParent_Done,
     /*  19272 */   // Label 538: @19272
     /*  19272 */   GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(19381), // Rule ID 22786 //
     /*  19277 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19284 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19288 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19292 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  19296 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19300 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  19304 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  19308 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  19313 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19315 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  19315 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  19318 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  19322 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19327 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  19329 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  19332 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  19336 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19341 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19344 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  19348 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  19351 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19356 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19361 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  19366 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
     /*  19369 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19371 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19373 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19376 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19379 */     GIR_RootConstrainSelectedInstOperands,
     /*  19380 */     // GIR_Coverage, 22786,
     /*  19380 */     GIR_EraseRootFromParent_Done,
     /*  19381 */   // Label 539: @19381
     /*  19381 */   GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(19429), // Rule ID 22861 //
     /*  19386 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  19389 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19392 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19396 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19408 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  19412 */     // MIs[1] Operand 1
     /*  19412 */     // No operand predicates
     /*  19412 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19414 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  19414 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32),
     /*  19417 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19419 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19421 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  19424 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19427 */     GIR_RootConstrainSelectedInstOperands,
     /*  19428 */     // GIR_Coverage, 22861,
     /*  19428 */     GIR_EraseRootFromParent_Done,
     /*  19429 */   // Label 540: @19429
     /*  19429 */   GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(19477), // Rule ID 22951 //
     /*  19434 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  19437 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19444 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19448 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19452 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19456 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  19460 */     // MIs[1] Operand 1
     /*  19460 */     // No operand predicates
     /*  19460 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19462 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  19462 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32_ND),
     /*  19465 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19467 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19469 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  19472 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19475 */     GIR_RootConstrainSelectedInstOperands,
     /*  19476 */     // GIR_Coverage, 22951,
     /*  19476 */     GIR_EraseRootFromParent_Done,
     /*  19477 */   // Label 541: @19477
     /*  19477 */   GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(19539), // Rule ID 17545 //
     /*  19482 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  19485 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19488 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19492 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19496 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19500 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19504 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19508 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19513 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  19517 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19521 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19523 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19523 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
     /*  19526 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19528 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19532 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  19534 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19537 */     GIR_RootConstrainSelectedInstOperands,
     /*  19538 */     // GIR_Coverage, 17545,
     /*  19538 */     GIR_EraseRootFromParent_Done,
     /*  19539 */   // Label 542: @19539
     /*  19539 */   GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(19601), // Rule ID 17549 //
     /*  19544 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  19547 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19550 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19554 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19558 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19562 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19566 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19570 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19575 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  19579 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19583 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19585 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
     /*  19588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19594 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  19596 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19599 */     GIR_RootConstrainSelectedInstOperands,
     /*  19600 */     // GIR_Coverage, 17549,
     /*  19600 */     GIR_EraseRootFromParent_Done,
     /*  19601 */   // Label 543: @19601
     /*  19601 */   GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(19663), // Rule ID 25102 //
     /*  19606 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  19609 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19612 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19616 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19620 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19624 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19628 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19632 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19636 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19641 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  19645 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19647 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19647 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
     /*  19650 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19656 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  19658 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19661 */     GIR_RootConstrainSelectedInstOperands,
     /*  19662 */     // GIR_Coverage, 25102,
     /*  19662 */     GIR_EraseRootFromParent_Done,
     /*  19663 */   // Label 544: @19663
     /*  19663 */   GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(19725), // Rule ID 25106 //
     /*  19668 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  19671 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19674 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19678 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19682 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19686 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19690 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19694 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19698 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19703 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  19707 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19709 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19709 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
     /*  19712 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19714 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19718 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  19720 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19723 */     GIR_RootConstrainSelectedInstOperands,
     /*  19724 */     // GIR_Coverage, 25106,
     /*  19724 */     GIR_EraseRootFromParent_Done,
     /*  19725 */   // Label 545: @19725
     /*  19725 */   GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(19761), // Rule ID 22853 //
     /*  19730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  19733 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19740 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19744 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19748 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19748 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr),
     /*  19753 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  19759 */     GIR_RootConstrainSelectedInstOperands,
     /*  19760 */     // GIR_Coverage, 22853,
     /*  19760 */     GIR_Done,
     /*  19761 */   // Label 546: @19761
     /*  19761 */   GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(19797), // Rule ID 22943 //
     /*  19766 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  19769 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19772 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19776 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19780 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19784 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19784 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr_ND),
     /*  19789 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  19795 */     GIR_RootConstrainSelectedInstOperands,
     /*  19796 */     // GIR_Coverage, 22943,
     /*  19796 */     GIR_Done,
     /*  19797 */   // Label 547: @19797
     /*  19797 */   GIM_Reject,
     /*  19798 */ // Label 523: @19798
     /*  19798 */ GIM_Reject,
     /*  19799 */ // Label 452: @19799
     /*  19799 */ GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(20144),
     /*  19804 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19807 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19810 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19814 */   GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(19934), // Rule ID 19489 //
     /*  19819 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19823 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19827 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19831 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19835 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19840 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19844 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19850 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  19852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19856 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19858 */     // (and:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  19858 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  19861 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19865 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19870 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  19874 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  19879 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  19882 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19886 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19891 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19895 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  19900 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  19903 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  19907 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19912 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19915 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  19918 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  19920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19925 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19928 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  19933 */     // GIR_Coverage, 19489,
     /*  19933 */     GIR_EraseRootFromParent_Done,
     /*  19934 */   // Label 549: @19934
     /*  19934 */   GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(20054), // Rule ID 25368 //
     /*  19939 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19943 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19947 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19951 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19955 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19959 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19964 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19968 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19974 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  19976 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19978 */     // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  19978 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  19981 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19985 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19990 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  19994 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  19999 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20002 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20006 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20011 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20015 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20020 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20023 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20027 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20032 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20035 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20038 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20040 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20043 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20045 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20048 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  20053 */     // GIR_Coverage, 25368,
     /*  20053 */     GIR_EraseRootFromParent_Done,
     /*  20054 */   // Label 550: @20054
     /*  20054 */   GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(20143), // Rule ID 19485 //
     /*  20059 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  20063 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  20067 */     // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  20067 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20070 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20074 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20079 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20083 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20088 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20091 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20095 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20100 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  20104 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20109 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20112 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  20116 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20121 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20124 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20127 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20129 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20132 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20134 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20137 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  20142 */     // GIR_Coverage, 19485,
     /*  20142 */     GIR_EraseRootFromParent_Done,
     /*  20143 */   // Label 551: @20143
     /*  20143 */   GIM_Reject,
     /*  20144 */ // Label 548: @20144
     /*  20144 */ GIM_Reject,
     /*  20145 */ // Label 453: @20145
     /*  20145 */ GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(20486),
     /*  20150 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20153 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  20156 */   GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(20218), // Rule ID 23360 //
     /*  20161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20164 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20176 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20179 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20183 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20187 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20191 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20193 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20200 */     // (and:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPANDrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20205 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20207 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20211 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20216 */     GIR_RootConstrainSelectedInstOperands,
     /*  20217 */     // GIR_Coverage, 23360,
     /*  20217 */     GIR_EraseRootFromParent_Done,
     /*  20218 */   // Label 553: @20218
     /*  20218 */   GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(20280), // Rule ID 24149 //
     /*  20223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20226 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20230 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20234 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20238 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20241 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20245 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20249 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20253 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20255 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20262 */     // (and:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPANDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20262 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  20265 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20267 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20269 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20273 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20278 */     GIR_RootConstrainSelectedInstOperands,
     /*  20279 */     // GIR_Coverage, 24149,
     /*  20279 */     GIR_EraseRootFromParent_Done,
     /*  20280 */   // Label 554: @20280
     /*  20280 */   GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(20342), // Rule ID 2111 //
     /*  20285 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20288 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20292 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20296 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20300 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20304 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20307 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20311 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20315 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20317 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20324 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20324 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20327 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20329 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  20331 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20335 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20340 */     GIR_RootConstrainSelectedInstOperands,
     /*  20341 */     // GIR_Coverage, 2111,
     /*  20341 */     GIR_EraseRootFromParent_Done,
     /*  20342 */   // Label 555: @20342
     /*  20342 */   GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(20404), // Rule ID 5707 //
     /*  20347 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20350 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20354 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20358 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20362 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20366 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20369 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20373 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20377 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20379 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20386 */     // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20386 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  20389 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20391 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  20393 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20397 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20402 */     GIR_RootConstrainSelectedInstOperands,
     /*  20403 */     // GIR_Coverage, 5707,
     /*  20403 */     GIR_EraseRootFromParent_Done,
     /*  20404 */   // Label 556: @20404
     /*  20404 */   GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(20431), // Rule ID 2110 //
     /*  20409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20416 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20424 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  20424 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  20429 */     GIR_RootConstrainSelectedInstOperands,
     /*  20430 */     // GIR_Coverage, 2110,
     /*  20430 */     GIR_Done,
     /*  20431 */   // Label 557: @20431
     /*  20431 */   GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(20458), // Rule ID 2112 //
     /*  20436 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  20439 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20443 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20447 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20451 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  20451 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  20456 */     GIR_RootConstrainSelectedInstOperands,
     /*  20457 */     // GIR_Coverage, 2112,
     /*  20457 */     GIR_Done,
     /*  20458 */   // Label 558: @20458
     /*  20458 */   GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(20485), // Rule ID 5704 //
     /*  20463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20466 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20470 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20474 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20478 */     // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPANDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  20478 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  20483 */     GIR_RootConstrainSelectedInstOperands,
     /*  20484 */     // GIR_Coverage, 5704,
     /*  20484 */     GIR_Done,
     /*  20485 */   // Label 559: @20485
     /*  20485 */   GIM_Reject,
     /*  20486 */ // Label 552: @20486
     /*  20486 */ GIM_Reject,
     /*  20487 */ // Label 454: @20487
     /*  20487 */ GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(20832),
     /*  20492 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20495 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20498 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20502 */   GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(20622), // Rule ID 19490 //
     /*  20507 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20511 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20515 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20519 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20523 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20528 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20532 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20538 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  20540 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20544 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20546 */     // (and:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20546 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20549 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20553 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20558 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20562 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20567 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20570 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20574 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20579 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20583 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20588 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20591 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20595 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20600 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20603 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20606 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20608 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20611 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20613 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20616 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20621 */     // GIR_Coverage, 19490,
     /*  20621 */     GIR_EraseRootFromParent_Done,
     /*  20622 */   // Label 561: @20622
     /*  20622 */   GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(20742), // Rule ID 25369 //
     /*  20627 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20631 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20635 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20639 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20643 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20647 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20652 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20656 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20662 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  20664 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20666 */     // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20666 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20669 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20673 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20678 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  20682 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20687 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20690 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20694 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20699 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20703 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20708 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20711 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20715 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20720 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20723 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20726 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20728 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20731 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20733 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20736 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20741 */     // GIR_Coverage, 25369,
     /*  20741 */     GIR_EraseRootFromParent_Done,
     /*  20742 */   // Label 562: @20742
     /*  20742 */   GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(20831), // Rule ID 19486 //
     /*  20747 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20751 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20755 */     // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20755 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20758 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20762 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20767 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20771 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20776 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20779 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20783 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20788 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  20792 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20797 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20800 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  20804 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20809 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20812 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20815 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20817 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20820 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20822 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20825 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20830 */     // GIR_Coverage, 19486,
     /*  20830 */     GIR_EraseRootFromParent_Done,
     /*  20831 */   // Label 563: @20831
     /*  20831 */   GIM_Reject,
     /*  20832 */ // Label 560: @20832
     /*  20832 */ GIM_Reject,
     /*  20833 */ // Label 455: @20833
     /*  20833 */ GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(21174),
     /*  20838 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20841 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20844 */   GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(20906), // Rule ID 24167 //
     /*  20849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20852 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20856 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20860 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20864 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20867 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20871 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20875 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20879 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20881 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20888 */     // (and:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPANDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rm),
     /*  20891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20893 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20895 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20899 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20904 */     GIR_RootConstrainSelectedInstOperands,
     /*  20905 */     // GIR_Coverage, 24167,
     /*  20905 */     GIR_EraseRootFromParent_Done,
     /*  20906 */   // Label 565: @20906
     /*  20906 */   GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(20968), // Rule ID 25253 //
     /*  20911 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20914 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20918 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20922 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20926 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20929 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20933 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20937 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20941 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20943 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20950 */     // (and:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPANDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20950 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20953 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20955 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20957 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20961 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20966 */     GIR_RootConstrainSelectedInstOperands,
     /*  20967 */     // GIR_Coverage, 25253,
     /*  20967 */     GIR_EraseRootFromParent_Done,
     /*  20968 */   // Label 566: @20968
     /*  20968 */   GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(21030), // Rule ID 5734 //
     /*  20973 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20976 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20980 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20984 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20988 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20992 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20995 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20999 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21003 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21005 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21012 */     // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21012 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rm),
     /*  21015 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21017 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21019 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21023 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21028 */     GIR_RootConstrainSelectedInstOperands,
     /*  21029 */     // GIR_Coverage, 5734,
     /*  21029 */     GIR_EraseRootFromParent_Done,
     /*  21030 */   // Label 567: @21030
     /*  21030 */   GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(21092), // Rule ID 18160 //
     /*  21035 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  21038 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21042 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21046 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21050 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21054 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21057 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21061 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21065 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21067 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21074 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21074 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  21077 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21079 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21081 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21085 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21090 */     GIR_RootConstrainSelectedInstOperands,
     /*  21091 */     // GIR_Coverage, 18160,
     /*  21091 */     GIR_EraseRootFromParent_Done,
     /*  21092 */   // Label 568: @21092
     /*  21092 */   GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(21119), // Rule ID 5731 //
     /*  21097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21100 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21104 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21108 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21112 */     // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPANDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  21112 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rr),
     /*  21117 */     GIR_RootConstrainSelectedInstOperands,
     /*  21118 */     // GIR_Coverage, 5731,
     /*  21118 */     GIR_Done,
     /*  21119 */   // Label 569: @21119
     /*  21119 */   GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(21146), // Rule ID 18148 //
     /*  21124 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  21127 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21131 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21135 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21139 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  21139 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  21144 */     GIR_RootConstrainSelectedInstOperands,
     /*  21145 */     // GIR_Coverage, 18148,
     /*  21145 */     GIR_Done,
     /*  21146 */   // Label 570: @21146
     /*  21146 */   GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(21173), // Rule ID 18172 //
     /*  21151 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  21154 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21158 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21162 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21166 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  21166 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  21171 */     GIR_RootConstrainSelectedInstOperands,
     /*  21172 */     // GIR_Coverage, 18172,
     /*  21172 */     GIR_Done,
     /*  21173 */   // Label 571: @21173
     /*  21173 */   GIM_Reject,
     /*  21174 */ // Label 564: @21174
     /*  21174 */ GIM_Reject,
     /*  21175 */ // Label 456: @21175
     /*  21175 */ GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(21640),
     /*  21180 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  21183 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  21186 */   GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(21248), // Rule ID 23362 //
     /*  21191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21198 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21206 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21209 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21213 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21217 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21221 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21223 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21230 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPANDYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  21233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21235 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21237 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21241 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21246 */     GIR_RootConstrainSelectedInstOperands,
     /*  21247 */     // GIR_Coverage, 23362,
     /*  21247 */     GIR_EraseRootFromParent_Done,
     /*  21248 */   // Label 573: @21248
     /*  21248 */   GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(21310), // Rule ID 24143 //
     /*  21253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21260 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21264 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21268 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21271 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21275 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21279 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21283 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21285 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21292 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPANDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21292 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  21295 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21297 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21299 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21303 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21308 */     GIR_RootConstrainSelectedInstOperands,
     /*  21309 */     // GIR_Coverage, 24143,
     /*  21309 */     GIR_EraseRootFromParent_Done,
     /*  21310 */   // Label 574: @21310
     /*  21310 */   GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(21372), // Rule ID 25242 //
     /*  21315 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21318 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21322 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21326 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21330 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21333 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21337 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21341 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21345 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21347 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21354 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VANDPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21354 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  21357 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21359 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21361 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21365 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21370 */     GIR_RootConstrainSelectedInstOperands,
     /*  21371 */     // GIR_Coverage, 25242,
     /*  21371 */     GIR_EraseRootFromParent_Done,
     /*  21372 */   // Label 575: @21372
     /*  21372 */   GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(21434), // Rule ID 2115 //
     /*  21377 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21384 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21388 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21392 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21396 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21399 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21403 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21407 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21409 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21416 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21416 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  21419 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21421 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21423 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21427 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21432 */     GIR_RootConstrainSelectedInstOperands,
     /*  21433 */     // GIR_Coverage, 2115,
     /*  21433 */     GIR_EraseRootFromParent_Done,
     /*  21434 */   // Label 576: @21434
     /*  21434 */   GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(21496), // Rule ID 5698 //
     /*  21439 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21442 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21446 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21450 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21454 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21458 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21461 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21465 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21469 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21471 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21478 */     // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21478 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  21481 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21483 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21485 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21489 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21494 */     GIR_RootConstrainSelectedInstOperands,
     /*  21495 */     // GIR_Coverage, 5698,
     /*  21495 */     GIR_EraseRootFromParent_Done,
     /*  21496 */   // Label 577: @21496
     /*  21496 */   GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(21558), // Rule ID 18133 //
     /*  21501 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21504 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21508 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21512 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21516 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21520 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21523 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21527 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21531 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21533 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21540 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21540 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  21543 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21545 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21547 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21551 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21556 */     GIR_RootConstrainSelectedInstOperands,
     /*  21557 */     // GIR_Coverage, 18133,
     /*  21557 */     GIR_EraseRootFromParent_Done,
     /*  21558 */   // Label 578: @21558
     /*  21558 */   GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(21585), // Rule ID 2114 //
     /*  21563 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21566 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21570 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21574 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21578 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPANDYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  21578 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  21583 */     GIR_RootConstrainSelectedInstOperands,
     /*  21584 */     // GIR_Coverage, 2114,
     /*  21584 */     GIR_Done,
     /*  21585 */   // Label 579: @21585
     /*  21585 */   GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(21612), // Rule ID 5695 //
     /*  21590 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21593 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21597 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21601 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21605 */     // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPANDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  21605 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  21610 */     GIR_RootConstrainSelectedInstOperands,
     /*  21611 */     // GIR_Coverage, 5695,
     /*  21611 */     GIR_Done,
     /*  21612 */   // Label 580: @21612
     /*  21612 */   GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(21639), // Rule ID 18117 //
     /*  21617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21620 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21624 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21628 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21632 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VANDPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  21632 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  21637 */     GIR_RootConstrainSelectedInstOperands,
     /*  21638 */     // GIR_Coverage, 18117,
     /*  21638 */     GIR_Done,
     /*  21639 */   // Label 581: @21639
     /*  21639 */   GIM_Reject,
     /*  21640 */ // Label 572: @21640
     /*  21640 */ GIM_Reject,
     /*  21641 */ // Label 457: @21641
     /*  21641 */ GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(22138),
     /*  21646 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21649 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21652 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21656 */   GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(21716), // Rule ID 4431 //
     /*  21661 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  21664 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21668 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21672 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21676 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21680 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21685 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21689 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21695 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21697 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21701 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21703 */     // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  21703 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
     /*  21706 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21708 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21712 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  21714 */     GIR_RootConstrainSelectedInstOperands,
     /*  21715 */     // GIR_Coverage, 4431,
     /*  21715 */     GIR_EraseRootFromParent_Done,
     /*  21716 */   // Label 583: @21716
     /*  21716 */   GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(21839), // Rule ID 19487 //
     /*  21721 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  21724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21732 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21736 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21740 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21745 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21749 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21755 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21757 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21761 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21763 */     // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  21763 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  21766 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21770 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21775 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  21779 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21784 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  21787 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21791 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21796 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21800 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21805 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  21808 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  21812 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21817 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  21820 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  21823 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  21825 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21828 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21830 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  21833 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  21838 */     // GIR_Coverage, 19487,
     /*  21838 */     GIR_EraseRootFromParent_Done,
     /*  21839 */   // Label 584: @21839
     /*  21839 */   GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(21899), // Rule ID 23692 //
     /*  21844 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  21847 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21851 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21855 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21859 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21863 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21867 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21872 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21876 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21882 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21884 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21886 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  21886 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
     /*  21889 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21891 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21895 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  21897 */     GIR_RootConstrainSelectedInstOperands,
     /*  21898 */     // GIR_Coverage, 23692,
     /*  21898 */     GIR_EraseRootFromParent_Done,
     /*  21899 */   // Label 585: @21899
     /*  21899 */   GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(22022), // Rule ID 25366 //
     /*  21904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  21907 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21911 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21915 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21919 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21923 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21927 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21932 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21936 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21942 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21944 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21946 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  21946 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  21949 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21953 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21958 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  21962 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21967 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  21970 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21974 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21979 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21983 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21988 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  21991 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  21995 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22000 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  22003 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  22006 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22008 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22011 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22013 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  22016 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  22021 */     // GIR_Coverage, 25366,
     /*  22021 */     GIR_EraseRootFromParent_Done,
     /*  22022 */   // Label 586: @22022
     /*  22022 */   GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(22045), // Rule ID 4415 //
     /*  22027 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  22030 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22034 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22038 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KANDBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  22038 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDBkk),
     /*  22043 */     GIR_RootConstrainSelectedInstOperands,
     /*  22044 */     // GIR_Coverage, 4415,
     /*  22044 */     GIR_Done,
     /*  22045 */   // Label 587: @22045
     /*  22045 */   GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(22137), // Rule ID 19483 //
     /*  22050 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  22053 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22057 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22061 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  22061 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  22064 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22068 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22073 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  22077 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  22082 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  22085 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22089 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22094 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  22098 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  22103 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  22106 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  22110 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22115 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  22118 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  22121 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22128 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  22131 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  22136 */     // GIR_Coverage, 19483,
     /*  22136 */     GIR_EraseRootFromParent_Done,
     /*  22137 */   // Label 588: @22137
     /*  22137 */   GIM_Reject,
     /*  22138 */ // Label 582: @22138
     /*  22138 */ GIM_Reject,
     /*  22139 */ // Label 458: @22139
     /*  22139 */ GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(22480),
     /*  22144 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22147 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  22150 */   GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(22212), // Rule ID 25252 //
     /*  22155 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22158 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22162 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22166 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22170 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22173 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22177 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22181 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22185 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22187 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22194 */     // (and:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPANDrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22194 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  22197 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22199 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22201 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22205 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22210 */     GIR_RootConstrainSelectedInstOperands,
     /*  22211 */     // GIR_Coverage, 25252,
     /*  22211 */     GIR_EraseRootFromParent_Done,
     /*  22212 */   // Label 590: @22212
     /*  22212 */   GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(22274), // Rule ID 25433 //
     /*  22217 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22220 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22224 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22228 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22232 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22235 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22239 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22243 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22247 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22249 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22256 */     // (and:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPANDQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  22259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22261 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22263 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22267 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22272 */     GIR_RootConstrainSelectedInstOperands,
     /*  22273 */     // GIR_Coverage, 25433,
     /*  22273 */     GIR_EraseRootFromParent_Done,
     /*  22274 */   // Label 591: @22274
     /*  22274 */   GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(22336), // Rule ID 18159 //
     /*  22279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22286 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22290 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22294 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22298 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22301 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22305 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22309 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22311 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22318 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  22321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22323 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22325 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22329 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22334 */     GIR_RootConstrainSelectedInstOperands,
     /*  22335 */     // GIR_Coverage, 18159,
     /*  22335 */     GIR_EraseRootFromParent_Done,
     /*  22336 */   // Label 592: @22336
     /*  22336 */   GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(22398), // Rule ID 20025 //
     /*  22341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22348 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22360 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22363 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22367 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22371 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22373 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22380 */     // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  22383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22385 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22387 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22391 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22396 */     GIR_RootConstrainSelectedInstOperands,
     /*  22397 */     // GIR_Coverage, 20025,
     /*  22397 */     GIR_EraseRootFromParent_Done,
     /*  22398 */   // Label 593: @22398
     /*  22398 */   GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(22425), // Rule ID 18147 //
     /*  22403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22410 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22414 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22418 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  22418 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  22423 */     GIR_RootConstrainSelectedInstOperands,
     /*  22424 */     // GIR_Coverage, 18147,
     /*  22424 */     GIR_Done,
     /*  22425 */   // Label 594: @22425
     /*  22425 */   GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(22452), // Rule ID 18171 //
     /*  22430 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  22433 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22437 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22441 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22445 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  22445 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  22450 */     GIR_RootConstrainSelectedInstOperands,
     /*  22451 */     // GIR_Coverage, 18171,
     /*  22451 */     GIR_Done,
     /*  22452 */   // Label 595: @22452
     /*  22452 */   GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(22479), // Rule ID 20017 //
     /*  22457 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22460 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22464 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22468 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22472 */     // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPANDQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  22472 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  22477 */     GIR_RootConstrainSelectedInstOperands,
     /*  22478 */     // GIR_Coverage, 20017,
     /*  22478 */     GIR_Done,
     /*  22479 */   // Label 596: @22479
     /*  22479 */   GIM_Reject,
     /*  22480 */ // Label 589: @22480
     /*  22480 */ GIM_Reject,
     /*  22481 */ // Label 459: @22481
     /*  22481 */ GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(22946),
     /*  22486 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  22489 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  22492 */   GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(22554), // Rule ID 24161 //
     /*  22497 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22500 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22512 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22515 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22519 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22523 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22527 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22529 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22536 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPANDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22536 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rm),
     /*  22539 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22541 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22543 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22547 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22552 */     GIR_RootConstrainSelectedInstOperands,
     /*  22553 */     // GIR_Coverage, 24161,
     /*  22553 */     GIR_EraseRootFromParent_Done,
     /*  22554 */   // Label 598: @22554
     /*  22554 */   GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(22616), // Rule ID 25232 //
     /*  22559 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22562 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22566 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22570 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22574 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22577 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22581 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22585 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22589 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22591 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22598 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPANDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22598 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  22601 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22603 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22605 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22609 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22614 */     GIR_RootConstrainSelectedInstOperands,
     /*  22615 */     // GIR_Coverage, 25232,
     /*  22615 */     GIR_EraseRootFromParent_Done,
     /*  22616 */   // Label 599: @22616
     /*  22616 */   GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(22678), // Rule ID 25241 //
     /*  22621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22628 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22632 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22636 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22639 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22643 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22647 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22651 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22653 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22660 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VANDPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  22663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22665 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22667 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22671 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22676 */     GIR_RootConstrainSelectedInstOperands,
     /*  22677 */     // GIR_Coverage, 25241,
     /*  22677 */     GIR_EraseRootFromParent_Done,
     /*  22678 */   // Label 600: @22678
     /*  22678 */   GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(22740), // Rule ID 5725 //
     /*  22683 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22690 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22702 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22705 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22709 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22713 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22715 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22722 */     // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rm),
     /*  22725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22727 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22729 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22733 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22738 */     GIR_RootConstrainSelectedInstOperands,
     /*  22739 */     // GIR_Coverage, 5725,
     /*  22739 */     GIR_EraseRootFromParent_Done,
     /*  22740 */   // Label 601: @22740
     /*  22740 */   GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(22802), // Rule ID 18104 //
     /*  22745 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22748 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22752 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22756 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22760 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22764 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22767 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22771 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22775 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22777 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22784 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22784 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  22787 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22789 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22791 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22795 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22800 */     GIR_RootConstrainSelectedInstOperands,
     /*  22801 */     // GIR_Coverage, 18104,
     /*  22801 */     GIR_EraseRootFromParent_Done,
     /*  22802 */   // Label 602: @22802
     /*  22802 */   GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(22864), // Rule ID 18132 //
     /*  22807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22810 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22814 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22818 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22822 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22826 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22829 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22833 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22837 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22839 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22846 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22846 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  22849 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22851 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22853 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22857 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22862 */     GIR_RootConstrainSelectedInstOperands,
     /*  22863 */     // GIR_Coverage, 18132,
     /*  22863 */     GIR_EraseRootFromParent_Done,
     /*  22864 */   // Label 603: @22864
     /*  22864 */   GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(22891), // Rule ID 5722 //
     /*  22869 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22872 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22876 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22880 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22884 */     // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPANDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  22884 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rr),
     /*  22889 */     GIR_RootConstrainSelectedInstOperands,
     /*  22890 */     // GIR_Coverage, 5722,
     /*  22890 */     GIR_Done,
     /*  22891 */   // Label 604: @22891
     /*  22891 */   GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(22918), // Rule ID 18092 //
     /*  22896 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22899 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22903 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22907 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22911 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPANDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  22911 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  22916 */     GIR_RootConstrainSelectedInstOperands,
     /*  22917 */     // GIR_Coverage, 18092,
     /*  22917 */     GIR_Done,
     /*  22918 */   // Label 605: @22918
     /*  22918 */   GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(22945), // Rule ID 18116 //
     /*  22923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22930 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22934 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22938 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VANDPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  22938 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  22943 */     GIR_RootConstrainSelectedInstOperands,
     /*  22944 */     // GIR_Coverage, 18116,
     /*  22944 */     GIR_Done,
     /*  22945 */   // Label 606: @22945
     /*  22945 */   GIM_Reject,
     /*  22946 */ // Label 597: @22946
     /*  22946 */ GIM_Reject,
     /*  22947 */ // Label 460: @22947
     /*  22947 */ GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(23102),
     /*  22952 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  22955 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  22958 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  22962 */   GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(23020), // Rule ID 24137 //
     /*  22967 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  22970 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22974 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22978 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22981 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22985 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22989 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  22993 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22995 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23002 */     // (and:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPANDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23002 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  23005 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23007 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23009 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23013 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23018 */     GIR_RootConstrainSelectedInstOperands,
     /*  23019 */     // GIR_Coverage, 24137,
     /*  23019 */     GIR_EraseRootFromParent_Done,
     /*  23020 */   // Label 608: @23020
     /*  23020 */   GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(23078), // Rule ID 5689 //
     /*  23025 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23028 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23032 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23036 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23040 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23043 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23047 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23051 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23053 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23060 */     // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23060 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  23063 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23065 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23067 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23071 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23076 */     GIR_RootConstrainSelectedInstOperands,
     /*  23077 */     // GIR_Coverage, 5689,
     /*  23077 */     GIR_EraseRootFromParent_Done,
     /*  23078 */   // Label 609: @23078
     /*  23078 */   GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(23101), // Rule ID 5686 //
     /*  23083 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23086 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23090 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23094 */     // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPANDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  23094 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  23099 */     GIR_RootConstrainSelectedInstOperands,
     /*  23100 */     // GIR_Coverage, 5686,
     /*  23100 */     GIR_Done,
     /*  23101 */   // Label 610: @23101
     /*  23101 */   GIM_Reject,
     /*  23102 */ // Label 607: @23102
     /*  23102 */ GIM_Reject,
     /*  23103 */ // Label 461: @23103
     /*  23103 */ GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(23262),
     /*  23108 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23111 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23114 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23118 */   GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(23178), // Rule ID 4432 //
     /*  23123 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23126 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23130 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23134 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23138 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23142 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23147 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23151 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23157 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  23159 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23163 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23165 */     // (and:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  23168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23170 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  23174 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  23176 */     GIR_RootConstrainSelectedInstOperands,
     /*  23177 */     // GIR_Coverage, 4432,
     /*  23177 */     GIR_EraseRootFromParent_Done,
     /*  23178 */   // Label 612: @23178
     /*  23178 */   GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(23238), // Rule ID 23693 //
     /*  23183 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23186 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23198 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23202 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23206 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23211 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23215 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23221 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  23223 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23225 */     // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23225 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  23228 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23230 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  23234 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  23236 */     GIR_RootConstrainSelectedInstOperands,
     /*  23237 */     // GIR_Coverage, 23693,
     /*  23237 */     GIR_EraseRootFromParent_Done,
     /*  23238 */   // Label 613: @23238
     /*  23238 */   GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(23261), // Rule ID 4416 //
     /*  23243 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23246 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23254 */     // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KANDWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23254 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  23259 */     GIR_RootConstrainSelectedInstOperands,
     /*  23260 */     // GIR_Coverage, 4416,
     /*  23260 */     GIR_Done,
     /*  23261 */   // Label 614: @23261
     /*  23261 */   GIM_Reject,
     /*  23262 */ // Label 611: @23262
     /*  23262 */ GIM_Reject,
     /*  23263 */ // Label 462: @23263
     /*  23263 */ GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(23604),
     /*  23268 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  23271 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  23274 */   GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(23336), // Rule ID 25251 //
     /*  23279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23286 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23290 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23294 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23297 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23301 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23305 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23309 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23311 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23318 */     // (and:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPANDrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  23321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23323 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23325 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23329 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23334 */     GIR_RootConstrainSelectedInstOperands,
     /*  23335 */     // GIR_Coverage, 25251,
     /*  23335 */     GIR_EraseRootFromParent_Done,
     /*  23336 */   // Label 616: @23336
     /*  23336 */   GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(23398), // Rule ID 25432 //
     /*  23341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23356 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23359 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23363 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23367 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23371 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23373 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23380 */     // (and:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPANDQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  23383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23385 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23387 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23391 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23396 */     GIR_RootConstrainSelectedInstOperands,
     /*  23397 */     // GIR_Coverage, 25432,
     /*  23397 */     GIR_EraseRootFromParent_Done,
     /*  23398 */   // Label 617: @23398
     /*  23398 */   GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(23460), // Rule ID 18158 //
     /*  23403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23410 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23414 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23418 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23422 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23425 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23429 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23433 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23435 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23442 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23442 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  23445 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23447 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23449 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23453 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23458 */     GIR_RootConstrainSelectedInstOperands,
     /*  23459 */     // GIR_Coverage, 18158,
     /*  23459 */     GIR_EraseRootFromParent_Done,
     /*  23460 */   // Label 618: @23460
     /*  23460 */   GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(23522), // Rule ID 20024 //
     /*  23465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23468 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23472 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23484 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23487 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23491 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23497 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23504 */     // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23504 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  23507 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23509 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23511 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23515 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23520 */     GIR_RootConstrainSelectedInstOperands,
     /*  23521 */     // GIR_Coverage, 20024,
     /*  23521 */     GIR_EraseRootFromParent_Done,
     /*  23522 */   // Label 619: @23522
     /*  23522 */   GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(23549), // Rule ID 18146 //
     /*  23527 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23530 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23534 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23538 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23542 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  23542 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  23547 */     GIR_RootConstrainSelectedInstOperands,
     /*  23548 */     // GIR_Coverage, 18146,
     /*  23548 */     GIR_Done,
     /*  23549 */   // Label 620: @23549
     /*  23549 */   GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(23576), // Rule ID 18170 //
     /*  23554 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  23557 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23561 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23565 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23569 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  23569 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  23574 */     GIR_RootConstrainSelectedInstOperands,
     /*  23575 */     // GIR_Coverage, 18170,
     /*  23575 */     GIR_Done,
     /*  23576 */   // Label 621: @23576
     /*  23576 */   GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(23603), // Rule ID 20016 //
     /*  23581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23588 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23592 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23596 */     // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPANDQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  23596 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  23601 */     GIR_RootConstrainSelectedInstOperands,
     /*  23602 */     // GIR_Coverage, 20016,
     /*  23602 */     GIR_Done,
     /*  23603 */   // Label 622: @23603
     /*  23603 */   GIM_Reject,
     /*  23604 */ // Label 615: @23604
     /*  23604 */ GIM_Reject,
     /*  23605 */ // Label 463: @23605
     /*  23605 */ GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(24070),
     /*  23610 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  23613 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  23616 */   GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(23678), // Rule ID 25231 //
     /*  23621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  23624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23628 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23632 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23636 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23639 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23643 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23647 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23651 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23653 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23660 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPANDYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  23663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23665 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23667 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23671 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23676 */     GIR_RootConstrainSelectedInstOperands,
     /*  23677 */     // GIR_Coverage, 25231,
     /*  23677 */     GIR_EraseRootFromParent_Done,
     /*  23678 */   // Label 624: @23678
     /*  23678 */   GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(23740), // Rule ID 25240 //
     /*  23683 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  23686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23690 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23694 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23698 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23701 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23705 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23709 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23713 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23715 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23722 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VANDPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  23725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23727 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23729 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23733 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23738 */     GIR_RootConstrainSelectedInstOperands,
     /*  23739 */     // GIR_Coverage, 25240,
     /*  23739 */     GIR_EraseRootFromParent_Done,
     /*  23740 */   // Label 625: @23740
     /*  23740 */   GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(23802), // Rule ID 25439 //
     /*  23745 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23748 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23752 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23756 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23760 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23763 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23767 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23771 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23775 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23777 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23784 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPANDQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23784 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  23787 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23789 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23791 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23795 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23800 */     GIR_RootConstrainSelectedInstOperands,
     /*  23801 */     // GIR_Coverage, 25439,
     /*  23801 */     GIR_EraseRootFromParent_Done,
     /*  23802 */   // Label 626: @23802
     /*  23802 */   GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(23864), // Rule ID 18103 //
     /*  23807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  23810 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23814 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23818 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23822 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23826 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23829 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23833 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23837 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23839 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23846 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23846 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  23849 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23851 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23853 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23857 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23862 */     GIR_RootConstrainSelectedInstOperands,
     /*  23863 */     // GIR_Coverage, 18103,
     /*  23863 */     GIR_EraseRootFromParent_Done,
     /*  23864 */   // Label 627: @23864
     /*  23864 */   GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(23926), // Rule ID 18131 //
     /*  23869 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  23872 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23876 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23880 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23884 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23888 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23891 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23895 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23899 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23901 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23908 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23908 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  23911 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23913 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23915 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23919 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23924 */     GIR_RootConstrainSelectedInstOperands,
     /*  23925 */     // GIR_Coverage, 18131,
     /*  23925 */     GIR_EraseRootFromParent_Done,
     /*  23926 */   // Label 628: @23926
     /*  23926 */   GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(23988), // Rule ID 20041 //
     /*  23931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23938 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23942 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23946 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23950 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23953 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23957 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23961 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23963 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23970 */     // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23970 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  23973 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23975 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23977 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23981 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23986 */     GIR_RootConstrainSelectedInstOperands,
     /*  23987 */     // GIR_Coverage, 20041,
     /*  23987 */     GIR_EraseRootFromParent_Done,
     /*  23988 */   // Label 629: @23988
     /*  23988 */   GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(24015), // Rule ID 18091 //
     /*  23993 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  23996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24000 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24004 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24008 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPANDYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  24008 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  24013 */     GIR_RootConstrainSelectedInstOperands,
     /*  24014 */     // GIR_Coverage, 18091,
     /*  24014 */     GIR_Done,
     /*  24015 */   // Label 630: @24015
     /*  24015 */   GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(24042), // Rule ID 18115 //
     /*  24020 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24023 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24027 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24031 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24035 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VANDPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  24035 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  24040 */     GIR_RootConstrainSelectedInstOperands,
     /*  24041 */     // GIR_Coverage, 18115,
     /*  24041 */     GIR_Done,
     /*  24042 */   // Label 631: @24042
     /*  24042 */   GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(24069), // Rule ID 20033 //
     /*  24047 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24050 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24054 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24058 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24062 */     // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPANDQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  24062 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  24067 */     GIR_RootConstrainSelectedInstOperands,
     /*  24068 */     // GIR_Coverage, 20033,
     /*  24068 */     GIR_Done,
     /*  24069 */   // Label 632: @24069
     /*  24069 */   GIM_Reject,
     /*  24070 */ // Label 623: @24070
     /*  24070 */ GIM_Reject,
     /*  24071 */ // Label 464: @24071
     /*  24071 */ GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(24226),
     /*  24076 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  24079 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  24082 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24086 */   GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(24144), // Rule ID 24155 //
     /*  24091 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24094 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24098 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24102 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24105 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24109 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24113 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24117 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24119 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24126 */     // (and:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPANDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24126 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZrm),
     /*  24129 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24131 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24133 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24137 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24142 */     GIR_RootConstrainSelectedInstOperands,
     /*  24143 */     // GIR_Coverage, 24155,
     /*  24143 */     GIR_EraseRootFromParent_Done,
     /*  24144 */   // Label 634: @24144
     /*  24144 */   GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(24202), // Rule ID 5716 //
     /*  24149 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24152 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24156 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24160 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24164 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24167 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24171 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24175 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24177 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24184 */     // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24184 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZrm),
     /*  24187 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24189 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24191 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24195 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24200 */     GIR_RootConstrainSelectedInstOperands,
     /*  24201 */     // GIR_Coverage, 5716,
     /*  24201 */     GIR_EraseRootFromParent_Done,
     /*  24202 */   // Label 635: @24202
     /*  24202 */   GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(24225), // Rule ID 5713 //
     /*  24207 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24210 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24214 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24218 */     // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPANDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  24218 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZrr),
     /*  24223 */     GIR_RootConstrainSelectedInstOperands,
     /*  24224 */     // GIR_Coverage, 5713,
     /*  24224 */     GIR_Done,
     /*  24225 */   // Label 636: @24225
     /*  24225 */   GIM_Reject,
     /*  24226 */ // Label 633: @24226
     /*  24226 */ GIM_Reject,
     /*  24227 */ // Label 465: @24227
     /*  24227 */ GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(24386),
     /*  24232 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24235 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24238 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24242 */   GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(24302), // Rule ID 4433 //
     /*  24247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24250 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24254 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24258 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24262 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24266 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24271 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24275 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24281 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  24283 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24287 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24289 */     // (and:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
     /*  24292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24294 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  24298 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  24300 */     GIR_RootConstrainSelectedInstOperands,
     /*  24301 */     // GIR_Coverage, 4433,
     /*  24301 */     GIR_EraseRootFromParent_Done,
     /*  24302 */   // Label 638: @24302
     /*  24302 */   GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(24362), // Rule ID 23694 //
     /*  24307 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24310 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24314 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24318 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24322 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24326 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24330 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24335 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24339 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24345 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  24347 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24349 */     // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24349 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
     /*  24352 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24354 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  24358 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  24360 */     GIR_RootConstrainSelectedInstOperands,
     /*  24361 */     // GIR_Coverage, 23694,
     /*  24361 */     GIR_EraseRootFromParent_Done,
     /*  24362 */   // Label 639: @24362
     /*  24362 */   GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(24385), // Rule ID 4417 //
     /*  24367 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24370 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24374 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24378 */     // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KANDDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24378 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDDkk),
     /*  24383 */     GIR_RootConstrainSelectedInstOperands,
     /*  24384 */     // GIR_Coverage, 4417,
     /*  24384 */     GIR_Done,
     /*  24385 */   // Label 640: @24385
     /*  24385 */   GIM_Reject,
     /*  24386 */ // Label 637: @24386
     /*  24386 */ GIM_Reject,
     /*  24387 */ // Label 466: @24387
     /*  24387 */ GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(24852),
     /*  24392 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*  24395 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*  24398 */   GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(24460), // Rule ID 25230 //
     /*  24403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24410 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24418 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24421 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24425 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24429 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24433 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24435 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24442 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VPANDYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24442 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  24445 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24447 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24449 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24453 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24458 */     GIR_RootConstrainSelectedInstOperands,
     /*  24459 */     // GIR_Coverage, 25230,
     /*  24459 */     GIR_EraseRootFromParent_Done,
     /*  24460 */   // Label 642: @24460
     /*  24460 */   GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(24522), // Rule ID 25239 //
     /*  24465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24468 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24472 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24476 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24480 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24483 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24487 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24491 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24497 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24504 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VANDPSYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24504 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  24507 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24509 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24511 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24515 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24520 */     GIR_RootConstrainSelectedInstOperands,
     /*  24521 */     // GIR_Coverage, 25239,
     /*  24521 */     GIR_EraseRootFromParent_Done,
     /*  24522 */   // Label 643: @24522
     /*  24522 */   GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(24584), // Rule ID 25438 //
     /*  24527 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24530 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24534 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24538 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24542 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24545 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24549 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24553 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24557 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24559 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24566 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v32i8] }:$src1)  =>  (VPANDQZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24566 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  24569 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24571 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24573 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24577 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24582 */     GIR_RootConstrainSelectedInstOperands,
     /*  24583 */     // GIR_Coverage, 25438,
     /*  24583 */     GIR_EraseRootFromParent_Done,
     /*  24584 */   // Label 644: @24584
     /*  24584 */   GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(24646), // Rule ID 18102 //
     /*  24589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24596 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24608 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24611 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24615 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24619 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24621 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24628 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  24631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24633 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24635 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24639 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24644 */     GIR_RootConstrainSelectedInstOperands,
     /*  24645 */     // GIR_Coverage, 18102,
     /*  24645 */     GIR_EraseRootFromParent_Done,
     /*  24646 */   // Label 645: @24646
     /*  24646 */   GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(24708), // Rule ID 18130 //
     /*  24651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24654 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24658 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24670 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24673 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24677 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24681 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24683 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24690 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24690 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  24693 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24695 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24697 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24701 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24706 */     GIR_RootConstrainSelectedInstOperands,
     /*  24707 */     // GIR_Coverage, 18130,
     /*  24707 */     GIR_EraseRootFromParent_Done,
     /*  24708 */   // Label 646: @24708
     /*  24708 */   GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(24770), // Rule ID 20040 //
     /*  24713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24720 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24732 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24735 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24739 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24743 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24745 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24752 */     // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24752 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  24755 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24757 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24759 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24763 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24768 */     GIR_RootConstrainSelectedInstOperands,
     /*  24769 */     // GIR_Coverage, 20040,
     /*  24769 */     GIR_EraseRootFromParent_Done,
     /*  24770 */   // Label 647: @24770
     /*  24770 */   GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(24797), // Rule ID 18090 //
     /*  24775 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24778 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24782 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24786 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24790 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPANDYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  24790 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  24795 */     GIR_RootConstrainSelectedInstOperands,
     /*  24796 */     // GIR_Coverage, 18090,
     /*  24796 */     GIR_Done,
     /*  24797 */   // Label 648: @24797
     /*  24797 */   GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(24824), // Rule ID 18114 //
     /*  24802 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24805 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24809 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24813 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24817 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VANDPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  24817 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  24822 */     GIR_RootConstrainSelectedInstOperands,
     /*  24823 */     // GIR_Coverage, 18114,
     /*  24823 */     GIR_Done,
     /*  24824 */   // Label 649: @24824
     /*  24824 */   GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(24851), // Rule ID 20032 //
     /*  24829 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24832 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24836 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24840 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24844 */     // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPANDQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*  24844 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  24849 */     GIR_RootConstrainSelectedInstOperands,
     /*  24850 */     // GIR_Coverage, 20032,
     /*  24850 */     GIR_Done,
     /*  24851 */   // Label 650: @24851
     /*  24851 */   GIM_Reject,
     /*  24852 */ // Label 641: @24852
     /*  24852 */ GIM_Reject,
     /*  24853 */ // Label 467: @24853
     /*  24853 */ GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(25008),
     /*  24858 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  24861 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  24864 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24868 */   GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(24926), // Rule ID 25445 //
     /*  24873 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24876 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24880 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24884 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24887 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24891 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24895 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24899 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24901 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24908 */     // (and:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPANDQZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24908 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  24911 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24913 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24915 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24919 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24924 */     GIR_RootConstrainSelectedInstOperands,
     /*  24925 */     // GIR_Coverage, 25445,
     /*  24925 */     GIR_EraseRootFromParent_Done,
     /*  24926 */   // Label 652: @24926
     /*  24926 */   GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(24984), // Rule ID 20057 //
     /*  24931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24934 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24946 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24949 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24953 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24957 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24959 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24966 */     // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24966 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  24969 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24971 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24973 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24977 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24982 */     GIR_RootConstrainSelectedInstOperands,
     /*  24983 */     // GIR_Coverage, 20057,
     /*  24983 */     GIR_EraseRootFromParent_Done,
     /*  24984 */   // Label 653: @24984
     /*  24984 */   GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(25007), // Rule ID 20049 //
     /*  24989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24992 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24996 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25000 */     // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPANDQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  25000 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  25005 */     GIR_RootConstrainSelectedInstOperands,
     /*  25006 */     // GIR_Coverage, 20049,
     /*  25006 */     GIR_Done,
     /*  25007 */   // Label 654: @25007
     /*  25007 */   GIM_Reject,
     /*  25008 */ // Label 651: @25008
     /*  25008 */ GIM_Reject,
     /*  25009 */ // Label 468: @25009
     /*  25009 */ GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(25168),
     /*  25014 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25017 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25020 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25024 */   GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(25084), // Rule ID 4434 //
     /*  25029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25032 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25036 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25040 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25044 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25048 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25053 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25057 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25063 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  25065 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25069 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  25071 */     // (and:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
     /*  25074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  25080 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  25082 */     GIR_RootConstrainSelectedInstOperands,
     /*  25083 */     // GIR_Coverage, 4434,
     /*  25083 */     GIR_EraseRootFromParent_Done,
     /*  25084 */   // Label 656: @25084
     /*  25084 */   GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(25144), // Rule ID 23695 //
     /*  25089 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25092 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25096 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25100 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25104 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25108 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25112 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25117 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25121 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25127 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  25129 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  25131 */     // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25131 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
     /*  25134 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  25140 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  25142 */     GIR_RootConstrainSelectedInstOperands,
     /*  25143 */     // GIR_Coverage, 23695,
     /*  25143 */     GIR_EraseRootFromParent_Done,
     /*  25144 */   // Label 657: @25144
     /*  25144 */   GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(25167), // Rule ID 4418 //
     /*  25149 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25152 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25156 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25160 */     // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KANDQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25160 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDQkk),
     /*  25165 */     GIR_RootConstrainSelectedInstOperands,
     /*  25166 */     // GIR_Coverage, 4418,
     /*  25166 */     GIR_Done,
     /*  25167 */   // Label 658: @25167
     /*  25167 */   GIM_Reject,
     /*  25168 */ // Label 655: @25168
     /*  25168 */ GIM_Reject,
     /*  25169 */ // Label 469: @25169
     /*  25169 */ GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(25324),
     /*  25174 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*  25177 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*  25180 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25184 */   GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(25242), // Rule ID 25444 //
     /*  25189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25192 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25196 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25200 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25203 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  25207 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25211 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25215 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25217 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25224 */     // (and:{ *:[v64i8] } (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v64i8] }:$src1)  =>  (VPANDQZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25224 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  25227 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25229 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25231 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25235 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25240 */     GIR_RootConstrainSelectedInstOperands,
     /*  25241 */     // GIR_Coverage, 25444,
     /*  25241 */     GIR_EraseRootFromParent_Done,
     /*  25242 */   // Label 660: @25242
     /*  25242 */   GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(25300), // Rule ID 20056 //
     /*  25247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25250 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25254 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25258 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25262 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25265 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  25269 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25273 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25275 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25282 */     // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25282 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  25285 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25287 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25289 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25293 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25298 */     GIR_RootConstrainSelectedInstOperands,
     /*  25299 */     // GIR_Coverage, 20056,
     /*  25299 */     GIR_EraseRootFromParent_Done,
     /*  25300 */   // Label 661: @25300
     /*  25300 */   GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(25323), // Rule ID 20048 //
     /*  25305 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25308 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25312 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25316 */     // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPANDQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*  25316 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  25321 */     GIR_RootConstrainSelectedInstOperands,
     /*  25322 */     // GIR_Coverage, 20048,
     /*  25322 */     GIR_Done,
     /*  25323 */   // Label 662: @25323
     /*  25323 */   GIM_Reject,
     /*  25324 */ // Label 659: @25324
     /*  25324 */ GIM_Reject,
     /*  25325 */ // Label 470: @25325
     /*  25325 */ GIM_Reject,
     /*  25326 */ // Label 4: @25326
     /*  25326 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 686*/ GIMT_Encode4(33729),
     /*  25337 */ /*GILLT_s1*//*Label 663*/ GIMT_Encode4(25437),
     /*  25341 */ /*GILLT_s8*//*Label 664*/ GIMT_Encode4(25537),
     /*  25345 */ /*GILLT_s16*//*Label 665*/ GIMT_Encode4(25930),
     /*  25349 */ /*GILLT_s32*//*Label 666*/ GIMT_Encode4(26527),
     /*  25353 */ /*GILLT_s64*//*Label 667*/ GIMT_Encode4(27983), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  25365 */ /*GILLT_v2s1*//*Label 668*/ GIMT_Encode4(29447),
     /*  25369 */ /*GILLT_v2s64*//*Label 669*/ GIMT_Encode4(29547),
     /*  25373 */ /*GILLT_v4s1*//*Label 670*/ GIMT_Encode4(29889),
     /*  25377 */ /*GILLT_v4s32*//*Label 671*/ GIMT_Encode4(29989),
     /*  25381 */ /*GILLT_v4s64*//*Label 672*/ GIMT_Encode4(30331),
     /*  25385 */ /*GILLT_v8s1*//*Label 673*/ GIMT_Encode4(30797),
     /*  25389 */ /*GILLT_v8s16*//*Label 674*/ GIMT_Encode4(30921),
     /*  25393 */ /*GILLT_v8s32*//*Label 675*/ GIMT_Encode4(31263),
     /*  25397 */ /*GILLT_v8s64*//*Label 676*/ GIMT_Encode4(31729),
     /*  25401 */ /*GILLT_v16s1*//*Label 677*/ GIMT_Encode4(31885),
     /*  25405 */ /*GILLT_v16s8*//*Label 678*/ GIMT_Encode4(31919),
     /*  25409 */ /*GILLT_v16s16*//*Label 679*/ GIMT_Encode4(32261),
     /*  25413 */ /*GILLT_v16s32*//*Label 680*/ GIMT_Encode4(32727),
     /*  25417 */ /*GILLT_v32s1*//*Label 681*/ GIMT_Encode4(32883),
     /*  25421 */ /*GILLT_v32s8*//*Label 682*/ GIMT_Encode4(32917),
     /*  25425 */ /*GILLT_v32s16*//*Label 683*/ GIMT_Encode4(33383),
     /*  25429 */ /*GILLT_v64s1*//*Label 684*/ GIMT_Encode4(33539),
     /*  25433 */ /*GILLT_v64s8*//*Label 685*/ GIMT_Encode4(33573),
     /*  25437 */ // Label 663: @25437
     /*  25437 */ GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(25536), // Rule ID 19492 //
     /*  25442 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  25445 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  25448 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25452 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25456 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25460 */   // (or:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  25460 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  25463 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25467 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25472 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  25476 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  25481 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  25484 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25488 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25493 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  25497 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  25502 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  25505 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  25509 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25514 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  25517 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  25520 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  25522 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25525 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25527 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25530 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  25535 */   // GIR_Coverage, 19492,
     /*  25535 */   GIR_EraseRootFromParent_Done,
     /*  25536 */ // Label 687: @25536
     /*  25536 */ GIM_Reject,
     /*  25537 */ // Label 664: @25537
     /*  25537 */ GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(25929),
     /*  25542 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*  25545 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*  25548 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25552 */   GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(25613), // Rule ID 26061 //
     /*  25557 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25560 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25564 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25568 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25571 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25575 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25579 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25583 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25585 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25592 */     // (or:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (OR8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25592 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm),
     /*  25595 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25597 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25599 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25603 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25606 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25611 */     GIR_RootConstrainSelectedInstOperands,
     /*  25612 */     // GIR_Coverage, 26061,
     /*  25612 */     GIR_EraseRootFromParent_Done,
     /*  25613 */   // Label 689: @25613
     /*  25613 */   GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(25674), // Rule ID 26080 //
     /*  25618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25621 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25625 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25629 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25632 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25636 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25640 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25644 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25646 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25653 */     // (or:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (OR8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm_ND),
     /*  25656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25658 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25660 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25664 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25667 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25672 */     GIR_RootConstrainSelectedInstOperands,
     /*  25673 */     // GIR_Coverage, 26080,
     /*  25673 */     GIR_EraseRootFromParent_Done,
     /*  25674 */   // Label 690: @25674
     /*  25674 */   GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(25735), // Rule ID 22830 //
     /*  25679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25682 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25694 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25697 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25701 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25705 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25707 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25714 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (OR8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25714 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm),
     /*  25717 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25719 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25721 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25725 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25728 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25733 */     GIR_RootConstrainSelectedInstOperands,
     /*  25734 */     // GIR_Coverage, 22830,
     /*  25734 */     GIR_EraseRootFromParent_Done,
     /*  25735 */   // Label 691: @25735
     /*  25735 */   GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(25796), // Rule ID 22920 //
     /*  25740 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25743 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25747 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25751 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25755 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25758 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25762 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25766 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25768 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25775 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (OR8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25775 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm_ND),
     /*  25778 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25780 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25782 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25786 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25789 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25794 */     GIR_RootConstrainSelectedInstOperands,
     /*  25795 */     // GIR_Coverage, 22920,
     /*  25795 */     GIR_EraseRootFromParent_Done,
     /*  25796 */   // Label 692: @25796
     /*  25796 */   GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(25833), // Rule ID 22834 //
     /*  25801 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25804 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25808 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25812 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25816 */     // MIs[1] Operand 1
     /*  25816 */     // No operand predicates
     /*  25816 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25818 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  25818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri),
     /*  25821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25823 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25825 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  25828 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25831 */     GIR_RootConstrainSelectedInstOperands,
     /*  25832 */     // GIR_Coverage, 22834,
     /*  25832 */     GIR_EraseRootFromParent_Done,
     /*  25833 */   // Label 693: @25833
     /*  25833 */   GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(25870), // Rule ID 22924 //
     /*  25838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25841 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25845 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25849 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25853 */     // MIs[1] Operand 1
     /*  25853 */     // No operand predicates
     /*  25853 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25855 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  25855 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri_ND),
     /*  25858 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25860 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25862 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  25865 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25868 */     GIR_RootConstrainSelectedInstOperands,
     /*  25869 */     // GIR_Coverage, 22924,
     /*  25869 */     GIR_EraseRootFromParent_Done,
     /*  25870 */   // Label 694: @25870
     /*  25870 */   GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(25899), // Rule ID 22826 //
     /*  25875 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25878 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25882 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25886 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  25886 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr),
     /*  25891 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  25897 */     GIR_RootConstrainSelectedInstOperands,
     /*  25898 */     // GIR_Coverage, 22826,
     /*  25898 */     GIR_Done,
     /*  25899 */   // Label 695: @25899
     /*  25899 */   GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(25928), // Rule ID 22916 //
     /*  25904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25907 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25911 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25915 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  25915 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr_ND),
     /*  25920 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  25926 */     GIR_RootConstrainSelectedInstOperands,
     /*  25927 */     // GIR_Coverage, 22916,
     /*  25927 */     GIR_Done,
     /*  25928 */   // Label 696: @25928
     /*  25928 */   GIM_Reject,
     /*  25929 */ // Label 688: @25929
     /*  25929 */ GIM_Reject,
     /*  25930 */ // Label 665: @25930
     /*  25930 */ GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(26526),
     /*  25935 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  25938 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  25941 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  25945 */   GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(26006), // Rule ID 26062 //
     /*  25950 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25953 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25957 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25961 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25964 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25968 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  25972 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  25976 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25978 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25985 */     // (or:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (OR16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25985 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm),
     /*  25988 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25990 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25992 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25996 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25999 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26004 */     GIR_RootConstrainSelectedInstOperands,
     /*  26005 */     // GIR_Coverage, 26062,
     /*  26005 */     GIR_EraseRootFromParent_Done,
     /*  26006 */   // Label 698: @26006
     /*  26006 */   GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(26067), // Rule ID 26081 //
     /*  26011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26014 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26018 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26022 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26025 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26029 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26033 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26037 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26039 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26046 */     // (or:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (OR16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26046 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm_ND),
     /*  26049 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26051 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26053 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26057 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26060 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26065 */     GIR_RootConstrainSelectedInstOperands,
     /*  26066 */     // GIR_Coverage, 26081,
     /*  26066 */     GIR_EraseRootFromParent_Done,
     /*  26067 */   // Label 699: @26067
     /*  26067 */   GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(26128), // Rule ID 22831 //
     /*  26072 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26075 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26079 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26083 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26087 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26090 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26094 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26098 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26100 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26107 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (OR16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26107 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm),
     /*  26110 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26112 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26114 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26118 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26121 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26126 */     GIR_RootConstrainSelectedInstOperands,
     /*  26127 */     // GIR_Coverage, 22831,
     /*  26127 */     GIR_EraseRootFromParent_Done,
     /*  26128 */   // Label 700: @26128
     /*  26128 */   GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(26189), // Rule ID 22921 //
     /*  26133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26136 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26148 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26151 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26155 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26159 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26161 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26168 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (OR16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm_ND),
     /*  26171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26173 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26175 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26179 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26182 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26187 */     GIR_RootConstrainSelectedInstOperands,
     /*  26188 */     // GIR_Coverage, 22921,
     /*  26188 */     GIR_EraseRootFromParent_Done,
     /*  26189 */   // Label 701: @26189
     /*  26189 */   GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(26291), // Rule ID 26037 //
     /*  26194 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26198 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  26202 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  26206 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  26210 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  26214 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  26219 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26223 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26225 */     // (or:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  26225 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  26228 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  26232 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26237 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  26239 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  26242 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  26246 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26251 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  26254 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  26258 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  26261 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  26266 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  26271 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  26276 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
     /*  26279 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26281 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26283 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26286 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26289 */     GIR_RootConstrainSelectedInstOperands,
     /*  26290 */     // GIR_Coverage, 26037,
     /*  26290 */     GIR_EraseRootFromParent_Done,
     /*  26291 */   // Label 702: @26291
     /*  26291 */   GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(26393), // Rule ID 22775 //
     /*  26296 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26300 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26304 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  26308 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  26312 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  26316 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  26320 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  26325 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26327 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  26327 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  26330 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  26334 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26339 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  26341 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  26344 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  26348 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26353 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  26356 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  26360 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  26363 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  26368 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  26373 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  26378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
     /*  26381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26383 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26385 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26388 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26391 */     GIR_RootConstrainSelectedInstOperands,
     /*  26392 */     // GIR_Coverage, 22775,
     /*  26392 */     GIR_EraseRootFromParent_Done,
     /*  26393 */   // Label 703: @26393
     /*  26393 */   GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(26430), // Rule ID 22835 //
     /*  26398 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26401 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26405 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26409 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26413 */     // MIs[1] Operand 1
     /*  26413 */     // No operand predicates
     /*  26413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26415 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  26415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri),
     /*  26418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26420 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26422 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  26425 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26428 */     GIR_RootConstrainSelectedInstOperands,
     /*  26429 */     // GIR_Coverage, 22835,
     /*  26429 */     GIR_EraseRootFromParent_Done,
     /*  26430 */   // Label 704: @26430
     /*  26430 */   GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(26467), // Rule ID 22925 //
     /*  26435 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26438 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26442 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26446 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26450 */     // MIs[1] Operand 1
     /*  26450 */     // No operand predicates
     /*  26450 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26452 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  26452 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri_ND),
     /*  26455 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26457 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26459 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  26462 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26465 */     GIR_RootConstrainSelectedInstOperands,
     /*  26466 */     // GIR_Coverage, 22925,
     /*  26466 */     GIR_EraseRootFromParent_Done,
     /*  26467 */   // Label 705: @26467
     /*  26467 */   GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(26496), // Rule ID 22827 //
     /*  26472 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26475 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26479 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26483 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  26483 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr),
     /*  26488 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  26494 */     GIR_RootConstrainSelectedInstOperands,
     /*  26495 */     // GIR_Coverage, 22827,
     /*  26495 */     GIR_Done,
     /*  26496 */   // Label 706: @26496
     /*  26496 */   GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(26525), // Rule ID 22917 //
     /*  26501 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26504 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26508 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26512 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  26512 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr_ND),
     /*  26517 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  26523 */     GIR_RootConstrainSelectedInstOperands,
     /*  26524 */     // GIR_Coverage, 22917,
     /*  26524 */     GIR_Done,
     /*  26525 */   // Label 707: @26525
     /*  26525 */   GIM_Reject,
     /*  26526 */ // Label 697: @26526
     /*  26526 */ GIM_Reject,
     /*  26527 */ // Label 666: @26527
     /*  26527 */ GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(27982),
     /*  26532 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  26535 */   GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(26603), // Rule ID 26063 //
     /*  26540 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26543 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26546 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26550 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26554 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26558 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26561 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26565 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26569 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26573 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26575 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26582 */     // (or:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (OR32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26582 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm),
     /*  26585 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26587 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26589 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26593 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26596 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26601 */     GIR_RootConstrainSelectedInstOperands,
     /*  26602 */     // GIR_Coverage, 26063,
     /*  26602 */     GIR_EraseRootFromParent_Done,
     /*  26603 */   // Label 709: @26603
     /*  26603 */   GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(26671), // Rule ID 26082 //
     /*  26608 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26611 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26614 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26618 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26622 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26626 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26629 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26633 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26637 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26641 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26643 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26650 */     // (or:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (OR32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26650 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm_ND),
     /*  26653 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26655 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26657 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26661 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26664 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26669 */     GIR_RootConstrainSelectedInstOperands,
     /*  26670 */     // GIR_Coverage, 26082,
     /*  26670 */     GIR_EraseRootFromParent_Done,
     /*  26671 */   // Label 710: @26671
     /*  26671 */   GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(26739), // Rule ID 22832 //
     /*  26676 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26679 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26682 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26686 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26690 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26694 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26698 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26701 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26705 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26709 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26711 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26718 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (OR32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm),
     /*  26721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26723 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26725 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26729 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26732 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26737 */     GIR_RootConstrainSelectedInstOperands,
     /*  26738 */     // GIR_Coverage, 22832,
     /*  26738 */     GIR_EraseRootFromParent_Done,
     /*  26739 */   // Label 711: @26739
     /*  26739 */   GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(26807), // Rule ID 22922 //
     /*  26744 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26747 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26750 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26754 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26766 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26769 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26773 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26777 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26779 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26786 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (OR32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26786 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm_ND),
     /*  26789 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26791 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26793 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26797 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26800 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26805 */     GIR_RootConstrainSelectedInstOperands,
     /*  26806 */     // GIR_Coverage, 22922,
     /*  26806 */     GIR_EraseRootFromParent_Done,
     /*  26807 */   // Label 712: @26807
     /*  26807 */   GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(26884), // Rule ID 25003 //
     /*  26812 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26815 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26818 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26822 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26830 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26834 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26838 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26843 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  26847 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  26851 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26855 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26859 */     // MIs[2] src
     /*  26859 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  26864 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  26868 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26870 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  26870 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
     /*  26873 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26875 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  26879 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26882 */     GIR_RootConstrainSelectedInstOperands,
     /*  26883 */     // GIR_Coverage, 25003,
     /*  26883 */     GIR_EraseRootFromParent_Done,
     /*  26884 */   // Label 713: @26884
     /*  26884 */   GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(26961), // Rule ID 25005 //
     /*  26889 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26892 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26895 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26899 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26903 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26907 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26911 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26915 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26920 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  26924 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  26928 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26932 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26936 */     // MIs[2] src
     /*  26936 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  26941 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  26945 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26947 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  26947 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
     /*  26950 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26952 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  26956 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26959 */     GIR_RootConstrainSelectedInstOperands,
     /*  26960 */     // GIR_Coverage, 25005,
     /*  26960 */     GIR_EraseRootFromParent_Done,
     /*  26961 */   // Label 714: @26961
     /*  26961 */   GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(27039), // Rule ID 24991 //
     /*  26966 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26969 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26973 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26977 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26981 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26985 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26989 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26993 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26997 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27001 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27005 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27010 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27014 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27018 */     // MIs[0] src
     /*  27018 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27023 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27025 */     // (or:{ *:[i32] } (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27025 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27028 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27030 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
     /*  27034 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27037 */     GIR_RootConstrainSelectedInstOperands,
     /*  27038 */     // GIR_Coverage, 24991,
     /*  27038 */     GIR_EraseRootFromParent_Done,
     /*  27039 */   // Label 715: @27039
     /*  27039 */   GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(27116), // Rule ID 17364 //
     /*  27044 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27047 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27050 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27054 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27058 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27062 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27066 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27070 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27075 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27079 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27083 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27087 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27091 */     // MIs[2] src
     /*  27091 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27096 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  27100 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27102 */     // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27102 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
     /*  27105 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27107 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27111 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27114 */     GIR_RootConstrainSelectedInstOperands,
     /*  27115 */     // GIR_Coverage, 17364,
     /*  27115 */     GIR_EraseRootFromParent_Done,
     /*  27116 */   // Label 716: @27116
     /*  27116 */   GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(27193), // Rule ID 17366 //
     /*  27121 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27124 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27127 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27131 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27135 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27139 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27143 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27147 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27152 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27156 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27160 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27164 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27168 */     // MIs[2] src
     /*  27168 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27173 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27177 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27179 */     // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27179 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
     /*  27182 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27188 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27191 */     GIR_RootConstrainSelectedInstOperands,
     /*  27192 */     // GIR_Coverage, 17366,
     /*  27192 */     GIR_EraseRootFromParent_Done,
     /*  27193 */   // Label 717: @27193
     /*  27193 */   GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(27267), // Rule ID 17352 //
     /*  27198 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27201 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27204 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27208 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27212 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27216 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27220 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27224 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27228 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27232 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27236 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27240 */     // MIs[2] src
     /*  27240 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27245 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27249 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27253 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27255 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27255 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27258 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27260 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27262 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27265 */     GIR_RootConstrainSelectedInstOperands,
     /*  27266 */     // GIR_Coverage, 17352,
     /*  27266 */     GIR_EraseRootFromParent_Done,
     /*  27267 */   // Label 718: @27267
     /*  27267 */   GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(27325), // Rule ID 24999 //
     /*  27272 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27275 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27279 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27283 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27287 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27295 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27300 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  27304 */     // MIs[0] src
     /*  27304 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27309 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27311 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27311 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
     /*  27314 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27320 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27323 */     GIR_RootConstrainSelectedInstOperands,
     /*  27324 */     // GIR_Coverage, 24999,
     /*  27324 */     GIR_EraseRootFromParent_Done,
     /*  27325 */   // Label 719: @27325
     /*  27325 */   GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(27383), // Rule ID 25001 //
     /*  27330 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27333 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27337 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27341 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27345 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27349 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27353 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27358 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27362 */     // MIs[0] src
     /*  27362 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27367 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27369 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
     /*  27372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27374 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27378 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27381 */     GIR_RootConstrainSelectedInstOperands,
     /*  27382 */     // GIR_Coverage, 25001,
     /*  27382 */     GIR_EraseRootFromParent_Done,
     /*  27383 */   // Label 720: @27383
     /*  27383 */   GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(27492), // Rule ID 26043 //
     /*  27388 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27391 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27395 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27399 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  27403 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27407 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  27411 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  27415 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  27420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27424 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27426 */     // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  27426 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  27429 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  27433 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27438 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  27440 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  27443 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  27447 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27452 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  27455 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  27459 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  27462 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27467 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27472 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  27477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
     /*  27480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27482 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  27484 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  27487 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27490 */     GIR_RootConstrainSelectedInstOperands,
     /*  27491 */     // GIR_Coverage, 26043,
     /*  27491 */     GIR_EraseRootFromParent_Done,
     /*  27492 */   // Label 721: @27492
     /*  27492 */   GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(27550), // Rule ID 24993 //
     /*  27497 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27500 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  27512 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27516 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27520 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  27524 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27529 */     // MIs[0] src
     /*  27529 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  27534 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27536 */     // (or:{ *:[i32] } (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27536 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27539 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
     /*  27545 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27548 */     GIR_RootConstrainSelectedInstOperands,
     /*  27549 */     // GIR_Coverage, 24993,
     /*  27549 */     GIR_EraseRootFromParent_Done,
     /*  27550 */   // Label 722: @27550
     /*  27550 */   GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(27604), // Rule ID 17360 //
     /*  27555 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27558 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27565 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27569 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27573 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27577 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27581 */     // MIs[1] src
     /*  27581 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27586 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  27590 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27592 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27592 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
     /*  27595 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27597 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27599 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27602 */     GIR_RootConstrainSelectedInstOperands,
     /*  27603 */     // GIR_Coverage, 17360,
     /*  27603 */     GIR_EraseRootFromParent_Done,
     /*  27604 */   // Label 723: @27604
     /*  27604 */   GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(27658), // Rule ID 17362 //
     /*  27609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27612 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27615 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27619 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27623 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27627 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27631 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27635 */     // MIs[1] src
     /*  27635 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27640 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  27644 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27646 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27646 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
     /*  27649 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27651 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27653 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27656 */     GIR_RootConstrainSelectedInstOperands,
     /*  27657 */     // GIR_Coverage, 17362,
     /*  27657 */     GIR_EraseRootFromParent_Done,
     /*  27658 */   // Label 724: @27658
     /*  27658 */   GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(27767), // Rule ID 22781 //
     /*  27663 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27666 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27670 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  27682 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27686 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  27690 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  27694 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  27699 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27701 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  27701 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  27704 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  27708 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27713 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  27715 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  27718 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  27722 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27727 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  27730 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  27734 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  27737 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27742 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27747 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  27752 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
     /*  27755 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27757 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27759 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  27762 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27765 */     GIR_RootConstrainSelectedInstOperands,
     /*  27766 */     // GIR_Coverage, 22781,
     /*  27766 */     GIR_EraseRootFromParent_Done,
     /*  27767 */   // Label 725: @27767
     /*  27767 */   GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(27821), // Rule ID 17354 //
     /*  27772 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27775 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27778 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27782 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27786 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27790 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  27794 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27798 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  27802 */     // MIs[1] src
     /*  27802 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27807 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27809 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27809 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27812 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27814 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27816 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27819 */     GIR_RootConstrainSelectedInstOperands,
     /*  27820 */     // GIR_Coverage, 17354,
     /*  27820 */     GIR_EraseRootFromParent_Done,
     /*  27821 */   // Label 726: @27821
     /*  27821 */   GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(27865), // Rule ID 22836 //
     /*  27826 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  27829 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27832 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27836 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27840 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27844 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27848 */     // MIs[1] Operand 1
     /*  27848 */     // No operand predicates
     /*  27848 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27850 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  27850 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri),
     /*  27853 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27855 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27857 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  27860 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27863 */     GIR_RootConstrainSelectedInstOperands,
     /*  27864 */     // GIR_Coverage, 22836,
     /*  27864 */     GIR_EraseRootFromParent_Done,
     /*  27865 */   // Label 727: @27865
     /*  27865 */   GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(27909), // Rule ID 22926 //
     /*  27870 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  27873 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27876 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27880 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27884 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27888 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27892 */     // MIs[1] Operand 1
     /*  27892 */     // No operand predicates
     /*  27892 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27894 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  27894 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri_ND),
     /*  27897 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27899 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27901 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  27904 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27907 */     GIR_RootConstrainSelectedInstOperands,
     /*  27908 */     // GIR_Coverage, 22926,
     /*  27908 */     GIR_EraseRootFromParent_Done,
     /*  27909 */   // Label 728: @27909
     /*  27909 */   GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(27945), // Rule ID 22828 //
     /*  27914 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  27917 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27920 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27924 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27928 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27932 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  27932 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr),
     /*  27937 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  27943 */     GIR_RootConstrainSelectedInstOperands,
     /*  27944 */     // GIR_Coverage, 22828,
     /*  27944 */     GIR_Done,
     /*  27945 */   // Label 729: @27945
     /*  27945 */   GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(27981), // Rule ID 22918 //
     /*  27950 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  27953 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27960 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27964 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27968 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  27968 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr_ND),
     /*  27973 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  27979 */     GIR_RootConstrainSelectedInstOperands,
     /*  27980 */     // GIR_Coverage, 22918,
     /*  27980 */     GIR_Done,
     /*  27981 */   // Label 730: @27981
     /*  27981 */   GIM_Reject,
     /*  27982 */ // Label 708: @27982
     /*  27982 */ GIM_Reject,
     /*  27983 */ // Label 667: @27983
     /*  27983 */ GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(29446),
     /*  27988 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27991 */   GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(28059), // Rule ID 26064 //
     /*  27996 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  27999 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28002 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28014 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28017 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28021 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28025 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28029 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28031 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28038 */     // (or:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (OR64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28038 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm),
     /*  28041 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28043 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28045 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28049 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28052 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28057 */     GIR_RootConstrainSelectedInstOperands,
     /*  28058 */     // GIR_Coverage, 26064,
     /*  28058 */     GIR_EraseRootFromParent_Done,
     /*  28059 */   // Label 732: @28059
     /*  28059 */   GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(28127), // Rule ID 26083 //
     /*  28064 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  28067 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28070 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28074 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28078 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28082 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28085 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28089 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28093 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28097 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28099 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28106 */     // (or:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (OR64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm_ND),
     /*  28109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28111 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28113 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28117 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28120 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28125 */     GIR_RootConstrainSelectedInstOperands,
     /*  28126 */     // GIR_Coverage, 26083,
     /*  28126 */     GIR_EraseRootFromParent_Done,
     /*  28127 */   // Label 733: @28127
     /*  28127 */   GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(28195), // Rule ID 22833 //
     /*  28132 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  28135 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28138 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28142 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28146 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28150 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28154 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28157 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28161 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28165 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28167 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28174 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (OR64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28174 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm),
     /*  28177 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28179 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  28181 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28185 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28188 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28193 */     GIR_RootConstrainSelectedInstOperands,
     /*  28194 */     // GIR_Coverage, 22833,
     /*  28194 */     GIR_EraseRootFromParent_Done,
     /*  28195 */   // Label 734: @28195
     /*  28195 */   GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(28263), // Rule ID 22923 //
     /*  28200 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  28203 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28210 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28214 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28218 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28222 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28225 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28229 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28233 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28235 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28242 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (OR64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm_ND),
     /*  28245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28247 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  28249 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28253 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28256 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28261 */     GIR_RootConstrainSelectedInstOperands,
     /*  28262 */     // GIR_Coverage, 22923,
     /*  28262 */     GIR_EraseRootFromParent_Done,
     /*  28263 */   // Label 735: @28263
     /*  28263 */   GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(28340), // Rule ID 25004 //
     /*  28268 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28271 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28274 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28278 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28282 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28286 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28290 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28294 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28299 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28303 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28307 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28311 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28315 */     // MIs[2] src
     /*  28315 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28320 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  28324 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28326 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28326 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
     /*  28329 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28331 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28335 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28338 */     GIR_RootConstrainSelectedInstOperands,
     /*  28339 */     // GIR_Coverage, 25004,
     /*  28339 */     GIR_EraseRootFromParent_Done,
     /*  28340 */   // Label 736: @28340
     /*  28340 */   GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(28417), // Rule ID 25006 //
     /*  28345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28348 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28351 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28355 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28359 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28363 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28367 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28371 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28376 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  28380 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28384 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28388 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28392 */     // MIs[2] src
     /*  28392 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28397 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  28401 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28403 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
     /*  28406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28412 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28415 */     GIR_RootConstrainSelectedInstOperands,
     /*  28416 */     // GIR_Coverage, 25006,
     /*  28416 */     GIR_EraseRootFromParent_Done,
     /*  28417 */   // Label 737: @28417
     /*  28417 */   GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(28495), // Rule ID 24992 //
     /*  28422 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28425 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28429 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28433 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28437 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28441 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28445 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28449 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28453 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  28457 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28461 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28466 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28470 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28474 */     // MIs[0] src
     /*  28474 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28479 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28481 */     // (or:{ *:[i64] } (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28481 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  28484 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
     /*  28490 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28493 */     GIR_RootConstrainSelectedInstOperands,
     /*  28494 */     // GIR_Coverage, 24992,
     /*  28494 */     GIR_EraseRootFromParent_Done,
     /*  28495 */   // Label 738: @28495
     /*  28495 */   GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(28572), // Rule ID 17365 //
     /*  28500 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28503 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28506 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28510 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28514 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28518 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28522 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28526 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28531 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28535 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28539 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28543 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28547 */     // MIs[2] src
     /*  28547 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28552 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
     /*  28556 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28558 */     // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28558 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
     /*  28561 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28563 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28567 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28570 */     GIR_RootConstrainSelectedInstOperands,
     /*  28571 */     // GIR_Coverage, 17365,
     /*  28571 */     GIR_EraseRootFromParent_Done,
     /*  28572 */   // Label 739: @28572
     /*  28572 */   GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(28649), // Rule ID 17367 //
     /*  28577 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28580 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28583 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28587 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28591 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28595 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28599 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28603 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28608 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28612 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28616 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28620 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28624 */     // MIs[2] src
     /*  28624 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28629 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28633 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28635 */     // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28635 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
     /*  28638 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28640 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28644 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28647 */     GIR_RootConstrainSelectedInstOperands,
     /*  28648 */     // GIR_Coverage, 17367,
     /*  28648 */     GIR_EraseRootFromParent_Done,
     /*  28649 */   // Label 740: @28649
     /*  28649 */   GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(28723), // Rule ID 17353 //
     /*  28654 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28657 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28664 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28668 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28672 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28676 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28680 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28684 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28688 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28692 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28696 */     // MIs[2] src
     /*  28696 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  28701 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28705 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28709 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28711 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28711 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  28714 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28716 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28718 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28721 */     GIR_RootConstrainSelectedInstOperands,
     /*  28722 */     // GIR_Coverage, 17353,
     /*  28722 */     GIR_EraseRootFromParent_Done,
     /*  28723 */   // Label 741: @28723
     /*  28723 */   GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(28781), // Rule ID 25000 //
     /*  28728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28731 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28735 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28739 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28743 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28747 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28751 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28756 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  28760 */     // MIs[0] src
     /*  28760 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28765 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28767 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28767 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
     /*  28770 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28776 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28779 */     GIR_RootConstrainSelectedInstOperands,
     /*  28780 */     // GIR_Coverage, 25000,
     /*  28780 */     GIR_EraseRootFromParent_Done,
     /*  28781 */   // Label 742: @28781
     /*  28781 */   GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(28839), // Rule ID 25002 //
     /*  28786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28789 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28793 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28797 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28801 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28805 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28809 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28814 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  28818 */     // MIs[0] src
     /*  28818 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28823 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28825 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28825 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
     /*  28828 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28830 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28834 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28837 */     GIR_RootConstrainSelectedInstOperands,
     /*  28838 */     // GIR_Coverage, 25002,
     /*  28838 */     GIR_EraseRootFromParent_Done,
     /*  28839 */   // Label 743: @28839
     /*  28839 */   GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(28948), // Rule ID 26049 //
     /*  28844 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28847 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28851 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28855 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  28859 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28863 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  28867 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  28871 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  28876 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28880 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28882 */     // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  28882 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  28885 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  28889 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  28894 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  28896 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  28899 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  28903 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  28908 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  28911 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  28915 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  28918 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  28923 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  28928 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  28933 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
     /*  28936 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28938 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28940 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  28943 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28946 */     GIR_RootConstrainSelectedInstOperands,
     /*  28947 */     // GIR_Coverage, 26049,
     /*  28947 */     GIR_EraseRootFromParent_Done,
     /*  28948 */   // Label 744: @28948
     /*  28948 */   GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(29006), // Rule ID 24994 //
     /*  28953 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28960 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28964 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  28968 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28972 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28976 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  28980 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28985 */     // MIs[0] src
     /*  28985 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  28990 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28992 */     // (or:{ *:[i64] } (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  28995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
     /*  29001 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29004 */     GIR_RootConstrainSelectedInstOperands,
     /*  29005 */     // GIR_Coverage, 24994,
     /*  29005 */     GIR_EraseRootFromParent_Done,
     /*  29006 */   // Label 745: @29006
     /*  29006 */   GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(29060), // Rule ID 17361 //
     /*  29011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29014 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29017 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29021 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29025 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29029 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29033 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  29037 */     // MIs[1] src
     /*  29037 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29042 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  29046 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29048 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
     /*  29051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29053 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29055 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29058 */     GIR_RootConstrainSelectedInstOperands,
     /*  29059 */     // GIR_Coverage, 17361,
     /*  29059 */     GIR_EraseRootFromParent_Done,
     /*  29060 */   // Label 746: @29060
     /*  29060 */   GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(29114), // Rule ID 17363 //
     /*  29065 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29068 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29071 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29075 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29079 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29083 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29087 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  29091 */     // MIs[1] src
     /*  29091 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29096 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  29100 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29102 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29102 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
     /*  29105 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29107 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29109 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29112 */     GIR_RootConstrainSelectedInstOperands,
     /*  29113 */     // GIR_Coverage, 17363,
     /*  29113 */     GIR_EraseRootFromParent_Done,
     /*  29114 */   // Label 747: @29114
     /*  29114 */   GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(29223), // Rule ID 22787 //
     /*  29119 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29122 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29126 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29130 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29134 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  29138 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  29142 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  29146 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  29150 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  29155 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29157 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  29157 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  29160 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29164 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29169 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  29171 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  29174 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  29178 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29183 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29186 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  29190 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  29193 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  29198 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  29203 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  29208 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
     /*  29211 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29213 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29215 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29218 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29221 */     GIR_RootConstrainSelectedInstOperands,
     /*  29222 */     // GIR_Coverage, 22787,
     /*  29222 */     GIR_EraseRootFromParent_Done,
     /*  29223 */   // Label 748: @29223
     /*  29223 */   GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(29277), // Rule ID 17355 //
     /*  29228 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29231 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29234 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29238 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29242 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29246 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  29250 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  29254 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
     /*  29258 */     // MIs[1] src
     /*  29258 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29263 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29265 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29265 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  29268 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29270 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29272 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29275 */     GIR_RootConstrainSelectedInstOperands,
     /*  29276 */     // GIR_Coverage, 17355,
     /*  29276 */     GIR_EraseRootFromParent_Done,
     /*  29277 */   // Label 749: @29277
     /*  29277 */   GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(29325), // Rule ID 22837 //
     /*  29282 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  29285 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29288 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29292 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29296 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29300 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29304 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  29308 */     // MIs[1] Operand 1
     /*  29308 */     // No operand predicates
     /*  29308 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29310 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  29310 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32),
     /*  29313 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29315 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29317 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  29320 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29323 */     GIR_RootConstrainSelectedInstOperands,
     /*  29324 */     // GIR_Coverage, 22837,
     /*  29324 */     GIR_EraseRootFromParent_Done,
     /*  29325 */   // Label 750: @29325
     /*  29325 */   GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(29373), // Rule ID 22927 //
     /*  29330 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  29333 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29340 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29344 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29348 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29352 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  29356 */     // MIs[1] Operand 1
     /*  29356 */     // No operand predicates
     /*  29356 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29358 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  29358 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32_ND),
     /*  29361 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29363 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29365 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  29368 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29371 */     GIR_RootConstrainSelectedInstOperands,
     /*  29372 */     // GIR_Coverage, 22927,
     /*  29372 */     GIR_EraseRootFromParent_Done,
     /*  29373 */   // Label 751: @29373
     /*  29373 */   GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(29409), // Rule ID 22829 //
     /*  29378 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  29381 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29384 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29388 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29392 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29396 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  29396 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr),
     /*  29401 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  29407 */     GIR_RootConstrainSelectedInstOperands,
     /*  29408 */     // GIR_Coverage, 22829,
     /*  29408 */     GIR_Done,
     /*  29409 */   // Label 752: @29409
     /*  29409 */   GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(29445), // Rule ID 22919 //
     /*  29414 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  29417 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29420 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29424 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29428 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29432 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  29432 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr_ND),
     /*  29437 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  29443 */     GIR_RootConstrainSelectedInstOperands,
     /*  29444 */     // GIR_Coverage, 22919,
     /*  29444 */     GIR_Done,
     /*  29445 */   // Label 753: @29445
     /*  29445 */   GIM_Reject,
     /*  29446 */ // Label 731: @29446
     /*  29446 */ GIM_Reject,
     /*  29447 */ // Label 668: @29447
     /*  29447 */ GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(29546), // Rule ID 19493 //
     /*  29452 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  29455 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  29458 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29462 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29466 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29470 */   // (or:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  29470 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  29473 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29477 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29482 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  29486 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29491 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  29494 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29498 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29503 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  29507 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29512 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  29515 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  29519 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29524 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29527 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  29530 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  29532 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29535 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29537 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29540 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  29545 */   // GIR_Coverage, 19493,
     /*  29545 */   GIR_EraseRootFromParent_Done,
     /*  29546 */ // Label 754: @29546
     /*  29546 */ GIM_Reject,
     /*  29547 */ // Label 669: @29547
     /*  29547 */ GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(29888),
     /*  29552 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  29555 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  29558 */   GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(29620), // Rule ID 23363 //
     /*  29563 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29566 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29570 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29574 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29578 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29581 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29585 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29589 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29593 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29595 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29602 */     // (or:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPORrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29602 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  29605 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29607 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  29609 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29613 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29618 */     GIR_RootConstrainSelectedInstOperands,
     /*  29619 */     // GIR_Coverage, 23363,
     /*  29619 */     GIR_EraseRootFromParent_Done,
     /*  29620 */   // Label 756: @29620
     /*  29620 */   GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(29682), // Rule ID 24185 //
     /*  29625 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29628 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29632 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29636 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29640 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29643 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29647 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29651 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29655 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29657 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29664 */     // (or:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPORQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29664 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  29667 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29669 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  29671 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29675 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29680 */     GIR_RootConstrainSelectedInstOperands,
     /*  29681 */     // GIR_Coverage, 24185,
     /*  29681 */     GIR_EraseRootFromParent_Done,
     /*  29682 */   // Label 757: @29682
     /*  29682 */   GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(29744), // Rule ID 2117 //
     /*  29687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29690 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29694 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29698 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29702 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29706 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29709 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29713 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29717 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29719 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29726 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29726 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  29729 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29731 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29733 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29737 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29742 */     GIR_RootConstrainSelectedInstOperands,
     /*  29743 */     // GIR_Coverage, 2117,
     /*  29743 */     GIR_EraseRootFromParent_Done,
     /*  29744 */   // Label 758: @29744
     /*  29744 */   GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(29806), // Rule ID 5761 //
     /*  29749 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29752 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29756 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29768 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29771 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29775 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29779 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29781 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29788 */     // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29788 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  29791 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29793 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29795 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29799 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29804 */     GIR_RootConstrainSelectedInstOperands,
     /*  29805 */     // GIR_Coverage, 5761,
     /*  29805 */     GIR_EraseRootFromParent_Done,
     /*  29806 */   // Label 759: @29806
     /*  29806 */   GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(29833), // Rule ID 2116 //
     /*  29811 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29814 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29818 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29822 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29826 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  29826 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  29831 */     GIR_RootConstrainSelectedInstOperands,
     /*  29832 */     // GIR_Coverage, 2116,
     /*  29832 */     GIR_Done,
     /*  29833 */   // Label 760: @29833
     /*  29833 */   GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(29860), // Rule ID 2118 //
     /*  29838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  29841 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29845 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29849 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29853 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  29853 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  29858 */     GIR_RootConstrainSelectedInstOperands,
     /*  29859 */     // GIR_Coverage, 2118,
     /*  29859 */     GIR_Done,
     /*  29860 */   // Label 761: @29860
     /*  29860 */   GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(29887), // Rule ID 5758 //
     /*  29865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29872 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29876 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29880 */     // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  29880 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  29885 */     GIR_RootConstrainSelectedInstOperands,
     /*  29886 */     // GIR_Coverage, 5758,
     /*  29886 */     GIR_Done,
     /*  29887 */   // Label 762: @29887
     /*  29887 */   GIM_Reject,
     /*  29888 */ // Label 755: @29888
     /*  29888 */ GIM_Reject,
     /*  29889 */ // Label 670: @29889
     /*  29889 */ GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(29988), // Rule ID 19494 //
     /*  29894 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  29897 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  29900 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29904 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29908 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29912 */   // (or:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  29912 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  29915 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29919 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29924 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  29928 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29933 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  29936 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29940 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29945 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  29949 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29954 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  29957 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  29961 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29966 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29969 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  29972 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  29974 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29977 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29979 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29982 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  29987 */   // GIR_Coverage, 19494,
     /*  29987 */   GIR_EraseRootFromParent_Done,
     /*  29988 */ // Label 763: @29988
     /*  29988 */ GIM_Reject,
     /*  29989 */ // Label 671: @29989
     /*  29989 */ GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(30330),
     /*  29994 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29997 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30000 */   GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(30062), // Rule ID 24203 //
     /*  30005 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30008 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30012 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30016 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30020 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30023 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30027 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30031 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30035 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30037 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30044 */     // (or:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPORDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30044 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rm),
     /*  30047 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30049 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30051 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30055 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30060 */     GIR_RootConstrainSelectedInstOperands,
     /*  30061 */     // GIR_Coverage, 24203,
     /*  30061 */     GIR_EraseRootFromParent_Done,
     /*  30062 */   // Label 765: @30062
     /*  30062 */   GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(30124), // Rule ID 25256 //
     /*  30067 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30070 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30074 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30078 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30082 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30085 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30089 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30093 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30097 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30099 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30106 */     // (or:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPORrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30111 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30113 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30117 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30122 */     GIR_RootConstrainSelectedInstOperands,
     /*  30123 */     // GIR_Coverage, 25256,
     /*  30123 */     GIR_EraseRootFromParent_Done,
     /*  30124 */   // Label 766: @30124
     /*  30124 */   GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(30186), // Rule ID 5788 //
     /*  30129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30132 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30136 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30148 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30151 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30155 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30159 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30161 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30168 */     // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rm),
     /*  30171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30173 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30175 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30179 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30184 */     GIR_RootConstrainSelectedInstOperands,
     /*  30185 */     // GIR_Coverage, 5788,
     /*  30185 */     GIR_EraseRootFromParent_Done,
     /*  30186 */   // Label 767: @30186
     /*  30186 */   GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(30248), // Rule ID 18163 //
     /*  30191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30198 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30210 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30213 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30217 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30221 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30223 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30230 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30235 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30237 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30241 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30246 */     GIR_RootConstrainSelectedInstOperands,
     /*  30247 */     // GIR_Coverage, 18163,
     /*  30247 */     GIR_EraseRootFromParent_Done,
     /*  30248 */   // Label 768: @30248
     /*  30248 */   GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(30275), // Rule ID 5785 //
     /*  30253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30260 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30264 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30268 */     // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  30268 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rr),
     /*  30273 */     GIR_RootConstrainSelectedInstOperands,
     /*  30274 */     // GIR_Coverage, 5785,
     /*  30274 */     GIR_Done,
     /*  30275 */   // Label 769: @30275
     /*  30275 */   GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(30302), // Rule ID 18151 //
     /*  30280 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30283 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30287 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30291 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30295 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  30295 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  30300 */     GIR_RootConstrainSelectedInstOperands,
     /*  30301 */     // GIR_Coverage, 18151,
     /*  30301 */     GIR_Done,
     /*  30302 */   // Label 770: @30302
     /*  30302 */   GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(30329), // Rule ID 18175 //
     /*  30307 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  30310 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30314 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30318 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30322 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  30322 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  30327 */     GIR_RootConstrainSelectedInstOperands,
     /*  30328 */     // GIR_Coverage, 18175,
     /*  30328 */     GIR_Done,
     /*  30329 */   // Label 771: @30329
     /*  30329 */   GIM_Reject,
     /*  30330 */ // Label 764: @30330
     /*  30330 */ GIM_Reject,
     /*  30331 */ // Label 672: @30331
     /*  30331 */ GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(30796),
     /*  30336 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  30339 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  30342 */   GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(30404), // Rule ID 23365 //
     /*  30347 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30350 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30354 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30358 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30362 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30365 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30369 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30373 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30377 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30379 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30386 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPORYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30386 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  30389 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30391 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30393 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30397 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30402 */     GIR_RootConstrainSelectedInstOperands,
     /*  30403 */     // GIR_Coverage, 23365,
     /*  30403 */     GIR_EraseRootFromParent_Done,
     /*  30404 */   // Label 773: @30404
     /*  30404 */   GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(30466), // Rule ID 24179 //
     /*  30409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30416 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30420 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30424 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30427 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30431 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30435 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30439 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30441 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30448 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPORQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30448 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  30451 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30453 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30455 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30459 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30464 */     GIR_RootConstrainSelectedInstOperands,
     /*  30465 */     // GIR_Coverage, 24179,
     /*  30465 */     GIR_EraseRootFromParent_Done,
     /*  30466 */   // Label 774: @30466
     /*  30466 */   GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(30528), // Rule ID 25246 //
     /*  30471 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30474 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30478 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30482 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30486 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30489 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30493 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30497 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30501 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30503 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30510 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VORPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30510 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  30513 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30515 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30517 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30521 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30526 */     GIR_RootConstrainSelectedInstOperands,
     /*  30527 */     // GIR_Coverage, 25246,
     /*  30527 */     GIR_EraseRootFromParent_Done,
     /*  30528 */   // Label 775: @30528
     /*  30528 */   GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(30590), // Rule ID 2121 //
     /*  30533 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30536 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30540 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30544 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30548 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30552 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30555 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30559 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30563 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30565 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30572 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30572 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  30575 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30577 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30579 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30583 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30588 */     GIR_RootConstrainSelectedInstOperands,
     /*  30589 */     // GIR_Coverage, 2121,
     /*  30589 */     GIR_EraseRootFromParent_Done,
     /*  30590 */   // Label 776: @30590
     /*  30590 */   GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(30652), // Rule ID 5752 //
     /*  30595 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30598 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30602 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30606 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30610 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30614 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30617 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30621 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30625 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30627 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30634 */     // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30634 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  30637 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30639 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30641 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30645 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30650 */     GIR_RootConstrainSelectedInstOperands,
     /*  30651 */     // GIR_Coverage, 5752,
     /*  30651 */     GIR_EraseRootFromParent_Done,
     /*  30652 */   // Label 777: @30652
     /*  30652 */   GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(30714), // Rule ID 18137 //
     /*  30657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30664 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30668 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30672 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30676 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30679 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30683 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30687 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30689 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30696 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  30699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30701 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30703 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30707 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30712 */     GIR_RootConstrainSelectedInstOperands,
     /*  30713 */     // GIR_Coverage, 18137,
     /*  30713 */     GIR_EraseRootFromParent_Done,
     /*  30714 */   // Label 778: @30714
     /*  30714 */   GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(30741), // Rule ID 2120 //
     /*  30719 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30722 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30726 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30730 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30734 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  30734 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  30739 */     GIR_RootConstrainSelectedInstOperands,
     /*  30740 */     // GIR_Coverage, 2120,
     /*  30740 */     GIR_Done,
     /*  30741 */   // Label 779: @30741
     /*  30741 */   GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(30768), // Rule ID 5749 //
     /*  30746 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30749 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30753 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30757 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30761 */     // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  30761 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
     /*  30766 */     GIR_RootConstrainSelectedInstOperands,
     /*  30767 */     // GIR_Coverage, 5749,
     /*  30767 */     GIR_Done,
     /*  30768 */   // Label 780: @30768
     /*  30768 */   GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(30795), // Rule ID 18121 //
     /*  30773 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30776 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30780 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30784 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30788 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  30788 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  30793 */     GIR_RootConstrainSelectedInstOperands,
     /*  30794 */     // GIR_Coverage, 18121,
     /*  30794 */     GIR_Done,
     /*  30795 */   // Label 781: @30795
     /*  30795 */   GIM_Reject,
     /*  30796 */ // Label 772: @30796
     /*  30796 */ GIM_Reject,
     /*  30797 */ // Label 673: @30797
     /*  30797 */ GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(30920),
     /*  30802 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  30805 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  30808 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30812 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30816 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30820 */   GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(30835), // Rule ID 4419 //
     /*  30825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  30828 */     // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  30828 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORBkk),
     /*  30833 */     GIR_RootConstrainSelectedInstOperands,
     /*  30834 */     // GIR_Coverage, 4419,
     /*  30834 */     GIR_Done,
     /*  30835 */   // Label 783: @30835
     /*  30835 */   GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(30919), // Rule ID 19491 //
     /*  30840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  30843 */     // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  30843 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  30846 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30850 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30855 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  30859 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  30864 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  30867 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30871 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30876 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  30880 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  30885 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  30888 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  30892 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30897 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  30900 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  30903 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  30905 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30908 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30910 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  30913 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  30918 */     // GIR_Coverage, 19491,
     /*  30918 */     GIR_EraseRootFromParent_Done,
     /*  30919 */   // Label 784: @30919
     /*  30919 */   GIM_Reject,
     /*  30920 */ // Label 782: @30920
     /*  30920 */ GIM_Reject,
     /*  30921 */ // Label 674: @30921
     /*  30921 */ GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(31262),
     /*  30926 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30929 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  30932 */   GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(30994), // Rule ID 25255 //
     /*  30937 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30940 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30944 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30948 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30952 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30955 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30959 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30963 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30967 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30969 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30976 */     // (or:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPORrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30976 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30979 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30981 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30983 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30987 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30992 */     GIR_RootConstrainSelectedInstOperands,
     /*  30993 */     // GIR_Coverage, 25255,
     /*  30993 */     GIR_EraseRootFromParent_Done,
     /*  30994 */   // Label 786: @30994
     /*  30994 */   GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(31056), // Rule ID 25435 //
     /*  30999 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31002 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31014 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31017 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31021 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31025 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31029 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31031 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31038 */     // (or:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPORQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31038 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  31041 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31043 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31045 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31049 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31054 */     GIR_RootConstrainSelectedInstOperands,
     /*  31055 */     // GIR_Coverage, 25435,
     /*  31055 */     GIR_EraseRootFromParent_Done,
     /*  31056 */   // Label 787: @31056
     /*  31056 */   GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(31118), // Rule ID 18162 //
     /*  31061 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31064 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31068 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31072 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31076 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31080 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31083 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31087 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31091 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31093 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31100 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31100 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  31103 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31105 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31107 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31111 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31116 */     GIR_RootConstrainSelectedInstOperands,
     /*  31117 */     // GIR_Coverage, 18162,
     /*  31117 */     GIR_EraseRootFromParent_Done,
     /*  31118 */   // Label 788: @31118
     /*  31118 */   GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(31180), // Rule ID 20027 //
     /*  31123 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31130 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31134 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31138 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31142 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31145 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31149 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31153 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31155 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31162 */     // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31162 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  31165 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31167 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31169 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31173 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31178 */     GIR_RootConstrainSelectedInstOperands,
     /*  31179 */     // GIR_Coverage, 20027,
     /*  31179 */     GIR_EraseRootFromParent_Done,
     /*  31180 */   // Label 789: @31180
     /*  31180 */   GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(31207), // Rule ID 18150 //
     /*  31185 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31188 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31192 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31196 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31200 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  31200 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  31205 */     GIR_RootConstrainSelectedInstOperands,
     /*  31206 */     // GIR_Coverage, 18150,
     /*  31206 */     GIR_Done,
     /*  31207 */   // Label 790: @31207
     /*  31207 */   GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(31234), // Rule ID 18174 //
     /*  31212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  31215 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31219 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31223 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31227 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  31227 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  31232 */     GIR_RootConstrainSelectedInstOperands,
     /*  31233 */     // GIR_Coverage, 18174,
     /*  31233 */     GIR_Done,
     /*  31234 */   // Label 791: @31234
     /*  31234 */   GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(31261), // Rule ID 20019 //
     /*  31239 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31242 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31246 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31254 */     // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  31254 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  31259 */     GIR_RootConstrainSelectedInstOperands,
     /*  31260 */     // GIR_Coverage, 20019,
     /*  31260 */     GIR_Done,
     /*  31261 */   // Label 792: @31261
     /*  31261 */   GIM_Reject,
     /*  31262 */ // Label 785: @31262
     /*  31262 */ GIM_Reject,
     /*  31263 */ // Label 675: @31263
     /*  31263 */ GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(31728),
     /*  31268 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  31271 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  31274 */   GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(31336), // Rule ID 24197 //
     /*  31279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31286 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31290 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31294 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31297 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31301 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31305 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31309 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31311 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31318 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPORDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rm),
     /*  31321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31323 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31325 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31329 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31334 */     GIR_RootConstrainSelectedInstOperands,
     /*  31335 */     // GIR_Coverage, 24197,
     /*  31335 */     GIR_EraseRootFromParent_Done,
     /*  31336 */   // Label 794: @31336
     /*  31336 */   GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(31398), // Rule ID 25235 //
     /*  31341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31356 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31359 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31363 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31367 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31371 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31373 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31380 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPORYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  31383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31385 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31387 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31391 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31396 */     GIR_RootConstrainSelectedInstOperands,
     /*  31397 */     // GIR_Coverage, 25235,
     /*  31397 */     GIR_EraseRootFromParent_Done,
     /*  31398 */   // Label 795: @31398
     /*  31398 */   GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(31460), // Rule ID 25245 //
     /*  31403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31410 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31418 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31421 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31425 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31429 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31433 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31435 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31442 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VORPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31442 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  31445 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31447 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31449 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31453 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31458 */     GIR_RootConstrainSelectedInstOperands,
     /*  31459 */     // GIR_Coverage, 25245,
     /*  31459 */     GIR_EraseRootFromParent_Done,
     /*  31460 */   // Label 796: @31460
     /*  31460 */   GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(31522), // Rule ID 5779 //
     /*  31465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31468 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31472 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31484 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31487 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31491 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31497 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31504 */     // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31504 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rm),
     /*  31507 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31509 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31511 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31515 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31520 */     GIR_RootConstrainSelectedInstOperands,
     /*  31521 */     // GIR_Coverage, 5779,
     /*  31521 */     GIR_EraseRootFromParent_Done,
     /*  31522 */   // Label 797: @31522
     /*  31522 */   GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(31584), // Rule ID 18107 //
     /*  31527 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31530 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31534 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31538 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31542 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31546 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31549 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31553 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31557 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31559 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31566 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31566 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  31569 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31571 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31573 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31577 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31582 */     GIR_RootConstrainSelectedInstOperands,
     /*  31583 */     // GIR_Coverage, 18107,
     /*  31583 */     GIR_EraseRootFromParent_Done,
     /*  31584 */   // Label 798: @31584
     /*  31584 */   GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(31646), // Rule ID 18136 //
     /*  31589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31596 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31608 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31611 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31615 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31619 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31621 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31628 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  31631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31633 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31635 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31639 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31644 */     GIR_RootConstrainSelectedInstOperands,
     /*  31645 */     // GIR_Coverage, 18136,
     /*  31645 */     GIR_EraseRootFromParent_Done,
     /*  31646 */   // Label 799: @31646
     /*  31646 */   GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(31673), // Rule ID 5776 //
     /*  31651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31654 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31658 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31662 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31666 */     // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  31666 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rr),
     /*  31671 */     GIR_RootConstrainSelectedInstOperands,
     /*  31672 */     // GIR_Coverage, 5776,
     /*  31672 */     GIR_Done,
     /*  31673 */   // Label 800: @31673
     /*  31673 */   GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(31700), // Rule ID 18095 //
     /*  31678 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31681 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31685 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31689 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31693 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  31693 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  31698 */     GIR_RootConstrainSelectedInstOperands,
     /*  31699 */     // GIR_Coverage, 18095,
     /*  31699 */     GIR_Done,
     /*  31700 */   // Label 801: @31700
     /*  31700 */   GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(31727), // Rule ID 18120 //
     /*  31705 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31708 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31716 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31720 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  31720 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  31725 */     GIR_RootConstrainSelectedInstOperands,
     /*  31726 */     // GIR_Coverage, 18120,
     /*  31726 */     GIR_Done,
     /*  31727 */   // Label 802: @31727
     /*  31727 */   GIM_Reject,
     /*  31728 */ // Label 793: @31728
     /*  31728 */ GIM_Reject,
     /*  31729 */ // Label 676: @31729
     /*  31729 */ GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(31884),
     /*  31734 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  31737 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  31740 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31744 */   GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(31802), // Rule ID 24173 //
     /*  31749 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31752 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31756 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31760 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31763 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31767 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31771 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31775 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31777 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31784 */     // (or:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPORQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31784 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZrm),
     /*  31787 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31789 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31791 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31795 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31800 */     GIR_RootConstrainSelectedInstOperands,
     /*  31801 */     // GIR_Coverage, 24173,
     /*  31801 */     GIR_EraseRootFromParent_Done,
     /*  31802 */   // Label 804: @31802
     /*  31802 */   GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(31860), // Rule ID 5743 //
     /*  31807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31810 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31814 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31818 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31822 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31825 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31829 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31833 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31835 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31842 */     // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31842 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZrm),
     /*  31845 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31847 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31849 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31853 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31858 */     GIR_RootConstrainSelectedInstOperands,
     /*  31859 */     // GIR_Coverage, 5743,
     /*  31859 */     GIR_EraseRootFromParent_Done,
     /*  31860 */   // Label 805: @31860
     /*  31860 */   GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(31883), // Rule ID 5740 //
     /*  31865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31868 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31872 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31876 */     // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  31876 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
     /*  31881 */     GIR_RootConstrainSelectedInstOperands,
     /*  31882 */     // GIR_Coverage, 5740,
     /*  31882 */     GIR_Done,
     /*  31883 */   // Label 806: @31883
     /*  31883 */   GIM_Reject,
     /*  31884 */ // Label 803: @31884
     /*  31884 */ GIM_Reject,
     /*  31885 */ // Label 677: @31885
     /*  31885 */ GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(31918), // Rule ID 4420 //
     /*  31890 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31893 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  31896 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  31899 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31903 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31907 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31911 */   // (or:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  31911 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  31916 */   GIR_RootConstrainSelectedInstOperands,
     /*  31917 */   // GIR_Coverage, 4420,
     /*  31917 */   GIR_Done,
     /*  31918 */ // Label 807: @31918
     /*  31918 */ GIM_Reject,
     /*  31919 */ // Label 678: @31919
     /*  31919 */ GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(32260),
     /*  31924 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31927 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  31930 */   GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(31992), // Rule ID 25254 //
     /*  31935 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31938 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31942 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31946 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31950 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31953 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31957 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31961 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31965 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31967 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31974 */     // (or:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPORrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31974 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  31977 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31979 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31981 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31985 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31990 */     GIR_RootConstrainSelectedInstOperands,
     /*  31991 */     // GIR_Coverage, 25254,
     /*  31991 */     GIR_EraseRootFromParent_Done,
     /*  31992 */   // Label 809: @31992
     /*  31992 */   GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(32054), // Rule ID 25434 //
     /*  31997 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32000 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32004 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32008 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32012 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32015 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32019 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32023 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32027 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32029 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32036 */     // (or:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPORQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32036 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  32039 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32041 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32043 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32047 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32052 */     GIR_RootConstrainSelectedInstOperands,
     /*  32053 */     // GIR_Coverage, 25434,
     /*  32053 */     GIR_EraseRootFromParent_Done,
     /*  32054 */   // Label 810: @32054
     /*  32054 */   GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(32116), // Rule ID 18161 //
     /*  32059 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  32062 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32066 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32070 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32074 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32078 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32081 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32085 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32089 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32091 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32098 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  32101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32103 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32105 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32109 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32114 */     GIR_RootConstrainSelectedInstOperands,
     /*  32115 */     // GIR_Coverage, 18161,
     /*  32115 */     GIR_EraseRootFromParent_Done,
     /*  32116 */   // Label 811: @32116
     /*  32116 */   GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(32178), // Rule ID 20026 //
     /*  32121 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32124 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32128 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32132 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32136 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32140 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32143 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32147 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32151 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32153 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32160 */     // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32160 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  32163 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32165 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32167 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32171 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32176 */     GIR_RootConstrainSelectedInstOperands,
     /*  32177 */     // GIR_Coverage, 20026,
     /*  32177 */     GIR_EraseRootFromParent_Done,
     /*  32178 */   // Label 812: @32178
     /*  32178 */   GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(32205), // Rule ID 18149 //
     /*  32183 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  32186 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32190 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32194 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32198 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  32198 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  32203 */     GIR_RootConstrainSelectedInstOperands,
     /*  32204 */     // GIR_Coverage, 18149,
     /*  32204 */     GIR_Done,
     /*  32205 */   // Label 813: @32205
     /*  32205 */   GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(32232), // Rule ID 18173 //
     /*  32210 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  32213 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32217 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32221 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32225 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  32225 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  32230 */     GIR_RootConstrainSelectedInstOperands,
     /*  32231 */     // GIR_Coverage, 18173,
     /*  32231 */     GIR_Done,
     /*  32232 */   // Label 814: @32232
     /*  32232 */   GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(32259), // Rule ID 20018 //
     /*  32237 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32240 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32244 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32248 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32252 */     // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  32252 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  32257 */     GIR_RootConstrainSelectedInstOperands,
     /*  32258 */     // GIR_Coverage, 20018,
     /*  32258 */     GIR_Done,
     /*  32259 */   // Label 815: @32259
     /*  32259 */   GIM_Reject,
     /*  32260 */ // Label 808: @32260
     /*  32260 */ GIM_Reject,
     /*  32261 */ // Label 679: @32261
     /*  32261 */ GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(32726),
     /*  32266 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  32269 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  32272 */   GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(32334), // Rule ID 25234 //
     /*  32277 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32284 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32288 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32292 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32295 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32299 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32303 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32307 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32309 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32316 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPORYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32316 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  32319 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32321 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32323 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32327 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32332 */     GIR_RootConstrainSelectedInstOperands,
     /*  32333 */     // GIR_Coverage, 25234,
     /*  32333 */     GIR_EraseRootFromParent_Done,
     /*  32334 */   // Label 817: @32334
     /*  32334 */   GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(32396), // Rule ID 25244 //
     /*  32339 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32342 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32346 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32350 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32354 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32357 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32361 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32365 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32369 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32371 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32378 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VORPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  32381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32383 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32385 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32389 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32394 */     GIR_RootConstrainSelectedInstOperands,
     /*  32395 */     // GIR_Coverage, 25244,
     /*  32395 */     GIR_EraseRootFromParent_Done,
     /*  32396 */   // Label 818: @32396
     /*  32396 */   GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(32458), // Rule ID 25441 //
     /*  32401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32408 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32412 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32416 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32419 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32423 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32427 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32431 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32433 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32440 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPORQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32440 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  32443 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32445 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32447 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32451 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32456 */     GIR_RootConstrainSelectedInstOperands,
     /*  32457 */     // GIR_Coverage, 25441,
     /*  32457 */     GIR_EraseRootFromParent_Done,
     /*  32458 */   // Label 819: @32458
     /*  32458 */   GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(32520), // Rule ID 18106 //
     /*  32463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32466 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32470 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32474 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32478 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32482 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32485 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32489 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32493 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32495 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32502 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32502 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  32505 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32507 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32509 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32513 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32518 */     GIR_RootConstrainSelectedInstOperands,
     /*  32519 */     // GIR_Coverage, 18106,
     /*  32519 */     GIR_EraseRootFromParent_Done,
     /*  32520 */   // Label 820: @32520
     /*  32520 */   GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(32582), // Rule ID 18135 //
     /*  32525 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32528 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32532 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32536 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32540 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32544 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32547 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32551 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32555 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32557 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32564 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  32567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32569 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32571 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32575 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32580 */     GIR_RootConstrainSelectedInstOperands,
     /*  32581 */     // GIR_Coverage, 18135,
     /*  32581 */     GIR_EraseRootFromParent_Done,
     /*  32582 */   // Label 821: @32582
     /*  32582 */   GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(32644), // Rule ID 20043 //
     /*  32587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32594 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32598 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32602 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32606 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32609 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32613 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32617 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32619 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32626 */     // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  32629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32631 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32633 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32637 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32642 */     GIR_RootConstrainSelectedInstOperands,
     /*  32643 */     // GIR_Coverage, 20043,
     /*  32643 */     GIR_EraseRootFromParent_Done,
     /*  32644 */   // Label 822: @32644
     /*  32644 */   GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(32671), // Rule ID 18094 //
     /*  32649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32656 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32660 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32664 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  32664 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  32669 */     GIR_RootConstrainSelectedInstOperands,
     /*  32670 */     // GIR_Coverage, 18094,
     /*  32670 */     GIR_Done,
     /*  32671 */   // Label 823: @32671
     /*  32671 */   GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(32698), // Rule ID 18119 //
     /*  32676 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32679 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32683 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32687 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32691 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  32691 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  32696 */     GIR_RootConstrainSelectedInstOperands,
     /*  32697 */     // GIR_Coverage, 18119,
     /*  32697 */     GIR_Done,
     /*  32698 */   // Label 824: @32698
     /*  32698 */   GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(32725), // Rule ID 20035 //
     /*  32703 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32706 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32710 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32714 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32718 */     // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  32718 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
     /*  32723 */     GIR_RootConstrainSelectedInstOperands,
     /*  32724 */     // GIR_Coverage, 20035,
     /*  32724 */     GIR_Done,
     /*  32725 */   // Label 825: @32725
     /*  32725 */   GIM_Reject,
     /*  32726 */ // Label 816: @32726
     /*  32726 */ GIM_Reject,
     /*  32727 */ // Label 680: @32727
     /*  32727 */ GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(32882),
     /*  32732 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  32735 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  32738 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32742 */   GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(32800), // Rule ID 24191 //
     /*  32747 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  32750 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32754 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32758 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32761 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32765 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32769 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32773 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32775 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32782 */     // (or:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPORDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32782 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZrm),
     /*  32785 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32787 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32789 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32793 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32798 */     GIR_RootConstrainSelectedInstOperands,
     /*  32799 */     // GIR_Coverage, 24191,
     /*  32799 */     GIR_EraseRootFromParent_Done,
     /*  32800 */   // Label 827: @32800
     /*  32800 */   GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(32858), // Rule ID 5770 //
     /*  32805 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  32808 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32812 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32816 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32820 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32823 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32827 */     GIM_CheckPointe