
/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/transport/gen_vrt_if_packet.py on Mon Oct 13 20:27:01 2025
 **********************************************************************/

#include <uhd/exception.hpp>
#include <uhd/transport/vrt_if_packet.hpp>
#include <uhd/utils/byteswap.hpp>
#include <uhd/types/endianness.hpp>
#include <vector>

//define the endian macros to convert integers
#ifdef UHD_BIG_ENDIAN
    #define BE_MACRO(x) (x)
    #define LE_MACRO(x) uhd::byteswap(x)
#else
    #define BE_MACRO(x) uhd::byteswap(x)
    #define LE_MACRO(x) (x)
#endif

using namespace uhd;
using namespace uhd::transport;
using namespace uhd::transport::vrt;

typedef size_t pred_type;
typedef std::vector<pred_type> pred_table_type;
#define pred_table_index(hdr) ((hdr >> 20) & 0x1ff)

static pred_table_type get_pred_unpack_table(void)
{
    pred_table_type table(1 << 9, 0); //only 9 bits useful here (20-28)
    for (size_t i = 0; i < table.size(); i++){
        uint32_t vrt_hdr_word = i << 20;
        if(vrt_hdr_word & 0x10000000) table[i] |= 0x1;
        if(vrt_hdr_word & 0x8000000) table[i] |= 0x2;
        if(vrt_hdr_word & 0xc00000) table[i] |= 0x4;
        if(vrt_hdr_word & 0x300000) table[i] |= 0x8;
        if(vrt_hdr_word & 0x4000000) table[i] |= 0x10;
        if(vrt_hdr_word & 0x1000000) table[i] |= 0x40;
        if(vrt_hdr_word & 0x2000000) table[i] |= 0x20;
    }
    return table;
}

static const pred_table_type pred_unpack_table(get_pred_unpack_table());

//maps trailer bits to num empty bytes
//maps num empty bytes to trailer bits
static const uint32_t occ_table[] = {0, 2, 1, 3};

const uint32_t VRLP = ('V' << 24) | ('R' << 16) | ('L' << 8) | ('P' << 0);
const uint32_t VEND = ('V' << 24) | ('E' << 16) | ('N' << 8) | ('D' << 0);

UHD_INLINE static uint32_t chdr_to_vrt(const uint32_t chdr, if_packet_info_t &info)
{
    const uint32_t bytes = chdr & 0xffff;
    uint32_t vrt = (bytes + 3)/4;
    info.packet_count = (chdr >> 16) & 0xfff;
    vrt |= ((chdr >> 31) & 0x1) << 30; //context packet
    vrt |= ((chdr >> 29) & 0x1) << 20; //has tsf
    vrt |= ((chdr >> 28) & 0x1) << 24; //has eob
    vrt |= (0x1) << 28; //has sid (always)
    return vrt;
}

UHD_INLINE static uint32_t vrt_to_chdr(const uint32_t vrt, const if_packet_info_t &info)
{
    const uint32_t words32 = vrt & 0xffff;
    int bytes_rem = info.num_payload_bytes % 4;
    if (bytes_rem != 0) bytes_rem -= 4; //adjust for round up
    uint32_t chdr = (words32 * 4) + bytes_rem;
    chdr |= (info.packet_count & 0xfff) << 16;
    chdr |= ((vrt >> 30) & 0x1) << 31; //context packet
    chdr |= ((vrt >> 20) & 0x1) << 29; //has tsf
    chdr |= ((vrt >> 24) & 0x1) << 28; //has eob
    return chdr;
}




/***********************************************************************
 * internal impl of packing VRT IF header only
 **********************************************************************/
UHD_INLINE void __if_hdr_pack_be(
    uint32_t *packet_buff,
    if_packet_info_t &if_packet_info,
    uint32_t &vrt_hdr_word32
){
    uint32_t vrt_hdr_flags = 0;

    pred_type pred = 0;
    if (if_packet_info.has_sid) pred |= 0x1;
    if (if_packet_info.has_cid) pred |= 0x2;
    if (if_packet_info.has_tsi) pred |= 0x4;
    if (if_packet_info.has_tsf) pred |= 0x8;
    if (if_packet_info.has_tlr) pred |= 0x10;
    if (if_packet_info.eob)     pred |= 0x40;
    if (if_packet_info.sob)     pred |= 0x20;

    switch(pred){
    case 0:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x0;
        break;
    case 1:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10000000;
        break;
    case 2:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8000000;
        break;
    case 3:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18000000;
        break;
    case 4:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc00000;
        break;
    case 5:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10c00000;
        break;
    case 6:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8c00000;
        break;
    case 7:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18c00000;
        break;
    case 8:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x100000;
        break;
    case 9:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10100000;
        break;
    case 10:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8100000;
        break;
    case 11:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18100000;
        break;
    case 12:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd00000;
        break;
    case 13:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10d00000;
        break;
    case 14:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8d00000;
        break;
    case 15:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18d00000;
        break;
    case 16:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4000000;
        break;
    case 17:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14000000;
        break;
    case 18:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc000000;
        break;
    case 19:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c000000;
        break;
    case 20:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4c00000;
        break;
    case 21:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14c00000;
        break;
    case 22:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xcc00000;
        break;
    case 23:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1cc00000;
        break;
    case 24:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4100000;
        break;
    case 25:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14100000;
        break;
    case 26:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc100000;
        break;
    case 27:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c100000;
        break;
    case 28:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4d00000;
        break;
    case 29:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14d00000;
        break;
    case 30:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xcd00000;
        break;
    case 31:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1cd00000;
        break;
    case 32:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2000000;
        break;
    case 33:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12000000;
        break;
    case 34:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xa000000;
        break;
    case 35:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1a000000;
        break;
    case 36:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2c00000;
        break;
    case 37:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12c00000;
        break;
    case 38:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xac00000;
        break;
    case 39:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ac00000;
        break;
    case 40:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2100000;
        break;
    case 41:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12100000;
        break;
    case 42:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xa100000;
        break;
    case 43:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1a100000;
        break;
    case 44:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2d00000;
        break;
    case 45:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12d00000;
        break;
    case 46:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xad00000;
        break;
    case 47:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ad00000;
        break;
    case 48:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6000000;
        break;
    case 49:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16000000;
        break;
    case 50:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xe000000;
        break;
    case 51:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1e000000;
        break;
    case 52:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6c00000;
        break;
    case 53:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16c00000;
        break;
    case 54:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xec00000;
        break;
    case 55:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ec00000;
        break;
    case 56:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6100000;
        break;
    case 57:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16100000;
        break;
    case 58:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xe100000;
        break;
    case 59:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1e100000;
        break;
    case 60:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6d00000;
        break;
    case 61:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16d00000;
        break;
    case 62:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xed00000;
        break;
    case 63:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ed00000;
        break;
    case 64:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1000000;
        break;
    case 65:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11000000;
        break;
    case 66:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9000000;
        break;
    case 67:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19000000;
        break;
    case 68:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c00000;
        break;
    case 69:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11c00000;
        break;
    case 70:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9c00000;
        break;
    case 71:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19c00000;
        break;
    case 72:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1100000;
        break;
    case 73:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11100000;
        break;
    case 74:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9100000;
        break;
    case 75:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19100000;
        break;
    case 76:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d00000;
        break;
    case 77:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11d00000;
        break;
    case 78:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9d00000;
        break;
    case 79:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19d00000;
        break;
    case 80:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5000000;
        break;
    case 81:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15000000;
        break;
    case 82:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd000000;
        break;
    case 83:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d000000;
        break;
    case 84:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5c00000;
        break;
    case 85:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15c00000;
        break;
    case 86:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xdc00000;
        break;
    case 87:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1dc00000;
        break;
    case 88:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5100000;
        break;
    case 89:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15100000;
        break;
    case 90:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd100000;
        break;
    case 91:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d100000;
        break;
    case 92:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5d00000;
        break;
    case 93:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15d00000;
        break;
    case 94:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xdd00000;
        break;
    case 95:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1dd00000;
        break;
    case 96:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3000000;
        break;
    case 97:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13000000;
        break;
    case 98:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xb000000;
        break;
    case 99:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1b000000;
        break;
    case 100:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3c00000;
        break;
    case 101:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13c00000;
        break;
    case 102:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xbc00000;
        break;
    case 103:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1bc00000;
        break;
    case 104:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3100000;
        break;
    case 105:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13100000;
        break;
    case 106:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xb100000;
        break;
    case 107:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1b100000;
        break;
    case 108:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3d00000;
        break;
    case 109:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13d00000;
        break;
    case 110:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xbd00000;
        break;
    case 111:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1bd00000;
        break;
    case 112:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7000000;
        break;
    case 113:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17000000;
        break;
    case 114:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xf000000;
        break;
    case 115:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1f000000;
        break;
    case 116:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7c00000;
        break;
    case 117:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17c00000;
        break;
    case 118:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xfc00000;
        break;
    case 119:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1fc00000;
        break;
    case 120:
            packet_buff[1] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7100000;
        break;
    case 121:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17100000;
        break;
    case 122:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xf100000;
        break;
    case 123:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1f100000;
        break;
    case 124:
            packet_buff[1] = BE_MACRO(if_packet_info.tsi);
            packet_buff[2] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7d00000;
        break;
    case 125:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = BE_MACRO(if_packet_info.tsi);
            packet_buff[3] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17d00000;
        break;
    case 126:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = BE_MACRO(if_packet_info.tsi);
            packet_buff[4] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xfd00000;
        break;
    case 127:
            packet_buff[1] = BE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = BE_MACRO(if_packet_info.tsi);
            packet_buff[5] = BE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = BE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = BE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1fd00000;
        break;
    }

    //fill in complete header word
    vrt_hdr_word32 = uint32_t(0
        | (if_packet_info.packet_type << 29)
        | vrt_hdr_flags
        | ((if_packet_info.packet_count & 0xf) << 16)
        | (if_packet_info.num_packet_words32 & 0xffff)
    );
}

/***********************************************************************
 * internal impl of unpacking VRT IF header only
 **********************************************************************/
UHD_INLINE void __if_hdr_unpack_be(
    const uint32_t *packet_buff,
    if_packet_info_t &if_packet_info,
    const uint32_t vrt_hdr_word32
){
    const size_t packet_words32 = vrt_hdr_word32 & 0xffff;

    //failure case
    if (if_packet_info.num_packet_words32 < packet_words32)
        throw uhd::value_error("bad vrt header or packet fragment");

    //extract fields from the header
    if_packet_info.packet_type = if_packet_info_t::packet_type_t(vrt_hdr_word32 >> 29);
    if_packet_info.packet_count = (vrt_hdr_word32 >> 16) & 0xf;

    const pred_type pred = pred_unpack_table[pred_table_index(vrt_hdr_word32)];

    size_t empty_bytes = 0;

    switch(pred){
    case 0:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 1:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 2:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 3:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 4:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 5:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 6:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 7:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 8:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 9:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 10:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 11:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 12:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 13:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 14:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 15:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 16:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 17:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 18:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 19:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 20:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 21:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 22:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 23:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 24:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 25:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 26:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 27:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 28:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 29:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 30:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 31:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 32:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 33:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 34:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 35:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 36:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 37:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 38:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 39:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 40:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 41:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 42:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 43:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 44:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 45:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 46:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 47:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 48:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 49:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 50:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 51:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 52:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 53:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 54:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 55:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 56:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 57:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 58:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 59:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 60:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 61:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 62:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 63:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 64:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 65:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 66:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 67:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 68:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 69:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 70:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 71:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 72:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 73:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 74:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 75:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 76:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 77:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 78:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 79:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 80:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 81:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 82:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 83:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 84:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 85:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 86:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 87:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 88:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 89:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 90:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 91:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 92:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 93:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 94:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 95:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 96:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 97:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 98:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 99:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 100:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 101:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 102:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 103:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 104:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 105:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 106:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 107:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 108:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 109:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 110:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 111:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 112:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 113:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 114:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 115:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 116:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 117:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 118:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 119:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 120:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 121:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 122:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 123:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 124:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 125:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 126:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 127:
            if_packet_info.has_sid = true;
            if_packet_info.sid = BE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = BE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(BE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= BE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = BE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    }
}

/***********************************************************************
 * link layer + VRT IF packing
 **********************************************************************/
void vrt::if_hdr_pack_be(
    uint32_t *packet_buff,
    if_packet_info_t &if_packet_info
){
    uint32_t vrt_hdr_word32 = 0;
    switch (if_packet_info.link_type)
    {
    case if_packet_info_t::LINK_TYPE_NONE:
        __if_hdr_pack_be(packet_buff, if_packet_info, vrt_hdr_word32);
        packet_buff[0] = BE_MACRO(vrt_hdr_word32);
        break;

    case if_packet_info_t::LINK_TYPE_CHDR:
    {
        __if_hdr_pack_be(packet_buff, if_packet_info, vrt_hdr_word32);
        const uint32_t chdr = vrt_to_chdr(vrt_hdr_word32, if_packet_info);
        packet_buff[0] = BE_MACRO(chdr);
        break;
    }

    case if_packet_info_t::LINK_TYPE_VRLP:
        __if_hdr_pack_be(packet_buff+2, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_header_words32 += 2;
        if_packet_info.num_packet_words32 += 3;
        packet_buff[0] = BE_MACRO(VRLP);
        packet_buff[1] = BE_MACRO(uint32_t(
            (if_packet_info.num_packet_words32 & 0xfffff) |
            ((if_packet_info.packet_count & 0xfff) << 20)
        ));
        packet_buff[2] = BE_MACRO(vrt_hdr_word32);
        packet_buff[if_packet_info.num_packet_words32-1] = BE_MACRO(VEND);
        break;
    }
}

/***********************************************************************
 * link layer + VRT IF unpacking
 **********************************************************************/
void vrt::if_hdr_unpack_be(
    const uint32_t *packet_buff,
    if_packet_info_t &if_packet_info
){
    uint32_t vrt_hdr_word32 = 0;
    switch (if_packet_info.link_type)
    {
    case if_packet_info_t::LINK_TYPE_NONE:
        vrt_hdr_word32 = BE_MACRO(packet_buff[0]);
        __if_hdr_unpack_be(packet_buff, if_packet_info, vrt_hdr_word32);
        break;

    case if_packet_info_t::LINK_TYPE_CHDR:
    {
        const uint32_t chdr = BE_MACRO(packet_buff[0]);
        vrt_hdr_word32 = chdr_to_vrt(chdr, if_packet_info);
        size_t packet_count = if_packet_info.packet_count;
        __if_hdr_unpack_be(packet_buff, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_payload_bytes -= (~chdr + 1) & 0x3;
        if_packet_info.packet_count = packet_count;
        break;
    }

    case if_packet_info_t::LINK_TYPE_VRLP:
    {
        if (BE_MACRO(packet_buff[0]) != VRLP) throw uhd::value_error("bad vrl header VRLP");
        const uint32_t vrl_hdr = BE_MACRO(packet_buff[1]);
        vrt_hdr_word32 = BE_MACRO(packet_buff[2]);
        if (if_packet_info.num_packet_words32 < (vrl_hdr & 0xfffff)) throw uhd::value_error("bad vrl header or packet fragment");
        if (BE_MACRO(packet_buff[(vrl_hdr & 0xfffff)-1]) != VEND) throw uhd::value_error("bad vrl trailer VEND");
        __if_hdr_unpack_be(packet_buff+2, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_header_words32 += 2; //add vrl header
        if_packet_info.packet_count = (vrl_hdr >> 20) & 0xfff;
        break;
    }
    }
}



/***********************************************************************
 * internal impl of packing VRT IF header only
 **********************************************************************/
UHD_INLINE void __if_hdr_pack_le(
    uint32_t *packet_buff,
    if_packet_info_t &if_packet_info,
    uint32_t &vrt_hdr_word32
){
    uint32_t vrt_hdr_flags = 0;

    pred_type pred = 0;
    if (if_packet_info.has_sid) pred |= 0x1;
    if (if_packet_info.has_cid) pred |= 0x2;
    if (if_packet_info.has_tsi) pred |= 0x4;
    if (if_packet_info.has_tsf) pred |= 0x8;
    if (if_packet_info.has_tlr) pred |= 0x10;
    if (if_packet_info.eob)     pred |= 0x40;
    if (if_packet_info.sob)     pred |= 0x20;

    switch(pred){
    case 0:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x0;
        break;
    case 1:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10000000;
        break;
    case 2:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8000000;
        break;
    case 3:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18000000;
        break;
    case 4:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc00000;
        break;
    case 5:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10c00000;
        break;
    case 6:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8c00000;
        break;
    case 7:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18c00000;
        break;
    case 8:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x100000;
        break;
    case 9:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10100000;
        break;
    case 10:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8100000;
        break;
    case 11:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18100000;
        break;
    case 12:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd00000;
        break;
    case 13:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x10d00000;
        break;
    case 14:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x8d00000;
        break;
    case 15:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x18d00000;
        break;
    case 16:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4000000;
        break;
    case 17:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14000000;
        break;
    case 18:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc000000;
        break;
    case 19:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c000000;
        break;
    case 20:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4c00000;
        break;
    case 21:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14c00000;
        break;
    case 22:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xcc00000;
        break;
    case 23:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1cc00000;
        break;
    case 24:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4100000;
        break;
    case 25:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14100000;
        break;
    case 26:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xc100000;
        break;
    case 27:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c100000;
        break;
    case 28:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x4d00000;
        break;
    case 29:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x14d00000;
        break;
    case 30:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xcd00000;
        break;
    case 31:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1cd00000;
        break;
    case 32:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2000000;
        break;
    case 33:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12000000;
        break;
    case 34:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xa000000;
        break;
    case 35:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1a000000;
        break;
    case 36:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2c00000;
        break;
    case 37:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12c00000;
        break;
    case 38:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xac00000;
        break;
    case 39:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ac00000;
        break;
    case 40:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2100000;
        break;
    case 41:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12100000;
        break;
    case 42:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xa100000;
        break;
    case 43:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1a100000;
        break;
    case 44:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x2d00000;
        break;
    case 45:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x12d00000;
        break;
    case 46:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xad00000;
        break;
    case 47:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ad00000;
        break;
    case 48:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6000000;
        break;
    case 49:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16000000;
        break;
    case 50:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xe000000;
        break;
    case 51:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1e000000;
        break;
    case 52:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6c00000;
        break;
    case 53:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16c00000;
        break;
    case 54:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xec00000;
        break;
    case 55:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ec00000;
        break;
    case 56:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6100000;
        break;
    case 57:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16100000;
        break;
    case 58:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xe100000;
        break;
    case 59:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1e100000;
        break;
    case 60:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x6d00000;
        break;
    case 61:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x16d00000;
        break;
    case 62:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xed00000;
        break;
    case 63:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1ed00000;
        break;
    case 64:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1000000;
        break;
    case 65:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11000000;
        break;
    case 66:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9000000;
        break;
    case 67:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19000000;
        break;
    case 68:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1c00000;
        break;
    case 69:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11c00000;
        break;
    case 70:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9c00000;
        break;
    case 71:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19c00000;
        break;
    case 72:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1100000;
        break;
    case 73:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11100000;
        break;
    case 74:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9100000;
        break;
    case 75:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19100000;
        break;
    case 76:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d00000;
        break;
    case 77:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x11d00000;
        break;
    case 78:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x9d00000;
        break;
    case 79:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x19d00000;
        break;
    case 80:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5000000;
        break;
    case 81:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15000000;
        break;
    case 82:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd000000;
        break;
    case 83:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d000000;
        break;
    case 84:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5c00000;
        break;
    case 85:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15c00000;
        break;
    case 86:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xdc00000;
        break;
    case 87:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1dc00000;
        break;
    case 88:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5100000;
        break;
    case 89:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15100000;
        break;
    case 90:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xd100000;
        break;
    case 91:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1d100000;
        break;
    case 92:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x5d00000;
        break;
    case 93:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x15d00000;
        break;
    case 94:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xdd00000;
        break;
    case 95:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1dd00000;
        break;
    case 96:


            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 1 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3000000;
        break;
    case 97:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13000000;
        break;
    case 98:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xb000000;
        break;
    case 99:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1b000000;
        break;
    case 100:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3c00000;
        break;
    case 101:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13c00000;
        break;
    case 102:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xbc00000;
        break;
    case 103:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1bc00000;
        break;
    case 104:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3100000;
        break;
    case 105:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13100000;
        break;
    case 106:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xb100000;
        break;
    case 107:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1b100000;
        break;
    case 108:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x3d00000;
        break;
    case 109:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x13d00000;
        break;
    case 110:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xbd00000;
        break;
    case 111:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));


            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1bd00000;
        break;
    case 112:

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[1+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_packet_words32 = 2 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7000000;
        break;
    case 113:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17000000;
        break;
    case 114:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xf000000;
        break;
    case 115:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1f000000;
        break;
    case 116:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[2+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_packet_words32 = 3 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7c00000;
        break;
    case 117:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17c00000;
        break;
    case 118:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xfc00000;
        break;
    case 119:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1fc00000;
        break;
    case 120:
            packet_buff[1] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[3+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_packet_words32 = 4 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7100000;
        break;
    case 121:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17100000;
        break;
    case 122:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xf100000;
        break;
    case 123:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1f100000;
        break;
    case 124:
            packet_buff[1] = LE_MACRO(if_packet_info.tsi);
            packet_buff[2] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[4+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_packet_words32 = 5 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x7d00000;
        break;
    case 125:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = LE_MACRO(if_packet_info.tsi);
            packet_buff[3] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[5+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_packet_words32 = 6 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x17d00000;
        break;
    case 126:
            packet_buff[1] = 0; //not implemented
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = LE_MACRO(if_packet_info.tsi);
            packet_buff[4] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[6+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_packet_words32 = 7 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0xfd00000;
        break;
    case 127:
            packet_buff[1] = LE_MACRO(if_packet_info.sid);
            packet_buff[2] = 0; //not implemented
            packet_buff[3] = 0; //not implemented
            packet_buff[4] = LE_MACRO(if_packet_info.tsi);
            packet_buff[5] = LE_MACRO(uint32_t(if_packet_info.tsf >> 32));
            packet_buff[6] = LE_MACRO(uint32_t(if_packet_info.tsf >> 0));

            {
                const size_t empty_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - if_packet_info.num_payload_bytes;
                if_packet_info.tlr = (0x3 << 22) | (occ_table[empty_bytes & 0x3] << 10);
            }
            packet_buff[7+if_packet_info.num_payload_words32] = LE_MACRO(if_packet_info.tlr);
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_packet_words32 = 8 + if_packet_info.num_payload_words32;
            vrt_hdr_flags = 0x1fd00000;
        break;
    }

    //fill in complete header word
    vrt_hdr_word32 = uint32_t(0
        | (if_packet_info.packet_type << 29)
        | vrt_hdr_flags
        | ((if_packet_info.packet_count & 0xf) << 16)
        | (if_packet_info.num_packet_words32 & 0xffff)
    );
}

/***********************************************************************
 * internal impl of unpacking VRT IF header only
 **********************************************************************/
UHD_INLINE void __if_hdr_unpack_le(
    const uint32_t *packet_buff,
    if_packet_info_t &if_packet_info,
    const uint32_t vrt_hdr_word32
){
    const size_t packet_words32 = vrt_hdr_word32 & 0xffff;

    //failure case
    if (if_packet_info.num_packet_words32 < packet_words32)
        throw uhd::value_error("bad vrt header or packet fragment");

    //extract fields from the header
    if_packet_info.packet_type = if_packet_info_t::packet_type_t(vrt_hdr_word32 >> 29);
    if_packet_info.packet_count = (vrt_hdr_word32 >> 16) & 0xf;

    const pred_type pred = pred_unpack_table[pred_table_index(vrt_hdr_word32)];

    size_t empty_bytes = 0;

    switch(pred){
    case 0:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 1:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 2:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 3:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 4:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 5:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 6:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 7:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 8:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 9:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 10:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 11:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 12:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 13:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 14:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 15:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 16:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 17:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 18:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 19:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 20:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 21:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 22:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 23:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 24:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 25:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 26:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 27:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 28:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 29:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 30:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 31:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 32:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 33:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 34:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 35:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 36:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 37:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 38:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 39:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 40:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 41:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 42:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 43:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 44:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 45:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 46:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 47:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 48:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 49:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 50:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 51:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 52:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 53:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 54:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 55:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 56:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 57:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 58:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 59:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 60:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 61:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 62:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 63:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = false;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 64:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 65:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 66:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 67:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 68:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 69:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 70:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 71:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 72:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 73:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 74:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 75:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 76:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 77:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 78:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 79:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 80:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 81:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 82:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 83:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 84:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 85:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 86:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 87:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 88:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 89:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 90:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 91:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 92:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 93:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 94:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 95:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = false;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 96:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 1)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 1;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 97:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 98:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 99:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 100:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 101:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 102:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 103:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 104:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 105:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 106:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 107:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 108:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 109:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 110:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 111:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = false;
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 112:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 2)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 1;
            if_packet_info.num_payload_words32 = packet_words32 - 2;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 113:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 114:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 115:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 116:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 3)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 2;
            if_packet_info.num_payload_words32 = packet_words32 - 3;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 117:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 118:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 119:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = false;
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 120:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[1])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[2]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 4)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 3;
            if_packet_info.num_payload_words32 = packet_words32 - 4;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 121:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 122:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 123:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = false;
            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 124:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[1]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[2])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[3]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 5)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 4;
            if_packet_info.num_payload_words32 = packet_words32 - 5;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 125:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = false;
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[2]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[3])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[4]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 6)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 5;
            if_packet_info.num_payload_words32 = packet_words32 - 6;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 126:
            if_packet_info.has_sid = false;
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[3]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[4])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[5]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 7)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 6;
            if_packet_info.num_payload_words32 = packet_words32 - 7;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    case 127:
            if_packet_info.has_sid = true;
            if_packet_info.sid = LE_MACRO(packet_buff[1]);
            if_packet_info.has_cid = true;
            if_packet_info.cid = 0; //not implemented
            if_packet_info.has_tsi = true;
            if_packet_info.tsi = LE_MACRO(packet_buff[4]);

            if_packet_info.has_tsf = true;
            if_packet_info.tsf = uint64_t(LE_MACRO(packet_buff[5])) << 32;
            if_packet_info.tsf |= LE_MACRO(packet_buff[6]);
            if_packet_info.eob = true;
            if_packet_info.sob = true;
            if_packet_info.has_tlr = true;
            if_packet_info.tlr = LE_MACRO(packet_buff[packet_words32-1]);
            {
                const int indicators = (if_packet_info.tlr >> 20) & (if_packet_info.tlr >> 8);
                if ((indicators & (1 << 0)) != 0) if_packet_info.eob = true;
                if ((indicators & (1 << 1)) != 0) if_packet_info.sob = true;
                empty_bytes = occ_table[(indicators >> 2) & 0x3];
            }
            //another failure case
            if (packet_words32 < 8)
                throw uhd::value_error("bad vrt header or invalid packet length");
            if_packet_info.num_header_words32 = 7;
            if_packet_info.num_payload_words32 = packet_words32 - 8;
            if_packet_info.num_payload_bytes = if_packet_info.num_payload_words32*sizeof(uint32_t) - empty_bytes;
        break;
    }
}

/***********************************************************************
 * link layer + VRT IF packing
 **********************************************************************/
void vrt::if_hdr_pack_le(
    uint32_t *packet_buff,
    if_packet_info_t &if_packet_info
){
    uint32_t vrt_hdr_word32 = 0;
    switch (if_packet_info.link_type)
    {
    case if_packet_info_t::LINK_TYPE_NONE:
        __if_hdr_pack_le(packet_buff, if_packet_info, vrt_hdr_word32);
        packet_buff[0] = LE_MACRO(vrt_hdr_word32);
        break;

    case if_packet_info_t::LINK_TYPE_CHDR:
    {
        __if_hdr_pack_le(packet_buff, if_packet_info, vrt_hdr_word32);
        const uint32_t chdr = vrt_to_chdr(vrt_hdr_word32, if_packet_info);
        packet_buff[0] = LE_MACRO(chdr);
        break;
    }

    case if_packet_info_t::LINK_TYPE_VRLP:
        __if_hdr_pack_le(packet_buff+2, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_header_words32 += 2;
        if_packet_info.num_packet_words32 += 3;
        packet_buff[0] = LE_MACRO(VRLP);
        packet_buff[1] = LE_MACRO(uint32_t(
            (if_packet_info.num_packet_words32 & 0xfffff) |
            ((if_packet_info.packet_count & 0xfff) << 20)
        ));
        packet_buff[2] = LE_MACRO(vrt_hdr_word32);
        packet_buff[if_packet_info.num_packet_words32-1] = LE_MACRO(VEND);
        break;
    }
}

/***********************************************************************
 * link layer + VRT IF unpacking
 **********************************************************************/
void vrt::if_hdr_unpack_le(
    const uint32_t *packet_buff,
    if_packet_info_t &if_packet_info
){
    uint32_t vrt_hdr_word32 = 0;
    switch (if_packet_info.link_type)
    {
    case if_packet_info_t::LINK_TYPE_NONE:
        vrt_hdr_word32 = LE_MACRO(packet_buff[0]);
        __if_hdr_unpack_le(packet_buff, if_packet_info, vrt_hdr_word32);
        break;

    case if_packet_info_t::LINK_TYPE_CHDR:
    {
        const uint32_t chdr = LE_MACRO(packet_buff[0]);
        vrt_hdr_word32 = chdr_to_vrt(chdr, if_packet_info);
        size_t packet_count = if_packet_info.packet_count;
        __if_hdr_unpack_le(packet_buff, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_payload_bytes -= (~chdr + 1) & 0x3;
        if_packet_info.packet_count = packet_count;
        break;
    }

    case if_packet_info_t::LINK_TYPE_VRLP:
    {
        if (LE_MACRO(packet_buff[0]) != VRLP) throw uhd::value_error("bad vrl header VRLP");
        const uint32_t vrl_hdr = LE_MACRO(packet_buff[1]);
        vrt_hdr_word32 = LE_MACRO(packet_buff[2]);
        if (if_packet_info.num_packet_words32 < (vrl_hdr & 0xfffff)) throw uhd::value_error("bad vrl header or packet fragment");
        if (LE_MACRO(packet_buff[(vrl_hdr & 0xfffff)-1]) != VEND) throw uhd::value_error("bad vrl trailer VEND");
        __if_hdr_unpack_le(packet_buff+2, if_packet_info, vrt_hdr_word32);
        if_packet_info.num_header_words32 += 2; //add vrl header
        if_packet_info.packet_count = (vrl_hdr >> 20) & 0xfff;
        break;
    }
    }
}


