#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x006e";
static constexpr OUStringLiteral langDefaultName = u"\x0045\x006e\x0067\x006c\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x0042\x005a";
static constexpr OUStringLiteral countryDefaultName = u"\x0042\x0065\x006c\x0069\x007a\x0065";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_en_BZ(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}


static constexpr OUStringLiteral LC_CTYPE_Unoid = u"";
static constexpr OUStringLiteral dateSeparator = u"\x002f";
static constexpr OUStringLiteral thousandSeparator = u"\x002c";
static constexpr OUStringLiteral decimalSeparator = u"\x002e";
static constexpr OUStringLiteral decimalSeparatorAlternative = u"";
static constexpr OUStringLiteral timeSeparator = u"\x003a";
static constexpr OUStringLiteral time100SecSeparator = u"\x002e";
static constexpr OUStringLiteral listSeparator = u"\x003b";
static constexpr OUStringLiteral LongDateDayOfWeekSeparator = u"\x002c\x0020";
static constexpr OUStringLiteral LongDateDaySeparator = u"\x002c\x0020";
static constexpr OUStringLiteral LongDateMonthSeparator = u"\x0020";
static constexpr OUStringLiteral LongDateYearSeparator = u"\x0020";
static constexpr OUStringLiteral quotationStart = u"\x2018";
static constexpr OUStringLiteral quotationEnd = u"\x2019";
static constexpr OUStringLiteral doubleQuotationStart = u"\x201c";
static constexpr OUStringLiteral doubleQuotationEnd = u"\x201d";
static constexpr OUStringLiteral timeAM = u"\x0041\x004d";
static constexpr OUStringLiteral timePM = u"\x0050\x004d";
static constexpr OUStringLiteral measurementSystem = u"\x006d\x0065\x0074\x0072\x0069\x0063";

static constexpr OUString LCType[] = {
	LC_CTYPE_Unoid,
	dateSeparator,
	thousandSeparator,
	decimalSeparator,
	timeSeparator,
	time100SecSeparator,
	listSeparator,
	quotationStart,
	quotationEnd,
	doubleQuotationStart,
	doubleQuotationEnd,
	timeAM,
	timePM,
	measurementSystem,
	LongDateDayOfWeekSeparator,
	LongDateDaySeparator,
	LongDateMonthSeparator,
	LongDateYearSeparator,
	decimalSeparatorAlternative
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLocaleItem_en_BZ(sal_Int16& count)
{
	count = std::size(LCType);
	return (OUString const *)LCType;
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x42, 0x5a, 0x24, 0x2d, 0x32, 0x38, 0x30, 0x39, 0x5d, 0x0};
extern OUString const * getAllFormats0_en_US(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_en_BZ(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_en_US(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_en_BZ(sal_Int16& count)
{
	return getDateAcceptancePatterns_en_US(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_en_BZ(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_en_BZ(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_en_BZ(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_en_BZ(sal_Int16& count)
{
	return getIndexAlgorithm_en_US(count);
}
extern const OUString *  getUnicodeScripts_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_en_BZ(sal_Int16& count)
{
	return getUnicodeScripts_en_US(count);
}
extern const OUString *  getFollowPageWords_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_en_BZ(sal_Int16& count)
{
	return getFollowPageWords_en_US(count);
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral dayRefName0 = u"\x0065\x006e\x005f\x0055\x0053\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral monthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral monthRefName0 = u"\x0065\x006e\x005f\x0055\x0053\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral genitiveMonthRefName0 = u"\x0065\x006e\x005f\x0055\x0053\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral partitiveMonthRefName0 = u"\x0065\x006e\x005f\x0055\x0053\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral eraRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral eraRefName0 = u"\x0065\x006e\x005f\x0055\x0053\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x1";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x0";
static constexpr OUStringLiteral nbOfMonths = u"\x0";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfEras = u"\x0";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayRef0,
	dayRefName0,
	monthRef0,
	monthRefName0,
	genitiveMonthRef0,
	genitiveMonthRefName0,
	partitiveMonthRef0,
	partitiveMonthRefName0,
	eraRef0,
	eraRefName0,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_en_BZ(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0042\x005a\x0044";
static constexpr OUStringLiteral currencySymbol0 = u"\x0042\x005a\x0024";
static constexpr OUStringLiteral bankSymbol0 = u"\x0042\x005a\x0044";
static constexpr OUStringLiteral currencyName0 = u"\x0042\x0065\x006c\x0069\x007a\x0065\x0020\x0044\x006f\x006c\x006c\x0061\x0072";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_en_BZ(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_en_BZ(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_en_BZ(sal_Int16& count)
{
	return getForbiddenCharacters_en_US(count);
}
extern const OUString *  getBreakIteratorRules_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_en_BZ(sal_Int16& count)
{
	return getBreakIteratorRules_en_US(count);
}
extern const OUString *  getReservedWords_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_en_BZ(sal_Int16& count)
{
	return getReservedWords_en_US(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_en_BZ(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_en_BZ(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

