// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_reserved_marshaling_guest
//
// (header) generated by ../mesa-25.3.3/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.3/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.3/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/lib32-mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "vk_platform_compat.h"

#include "goldfish_vk_marshaling_guest.h"
#include "goldfish_vk_private_defs.h"
#include "VulkanStreamGuest.h"

// Stuff we are not going to use but if included,
// will cause compile errors. These are Android Vulkan
// required extensions, but the approach will be to
// implement them completely on the guest side.
#undef VK_KHR_android_surface
#undef VK_ANDROID_external_memory_android_hardware_buffer


namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
void reservedmarshal_VkExtent2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent2D* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExtent3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtent3D* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkOffset2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset2D* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkOffset3D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkOffset3D* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRect2D(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRect2D* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBaseInStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseInStructure* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBaseOutStructure(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBaseOutStructure* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDispatchIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDrawIndexedIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDrawIndirectCommand(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrawIndirectCommand* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageSubresourceRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceRange* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryBarrier(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineCacheHeaderVersionOne(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAllocationCallbacks(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAllocationCallbacks* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkApplicationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkApplicationInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkInstanceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInstanceCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryHeap(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryHeap* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryType(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryType* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceLimits(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSparseProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkQueueFamilyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceQueueCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExtensionProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExtensionProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkLayerProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkLayerProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMappedMemoryRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMappedMemoryRange* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseMemoryBind* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseBufferMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageSubresource(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageMemoryBind(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageMemoryBindInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindSparseInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkEventCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkEventCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkQueryPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubresourceLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkComponentMapping(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComponentMapping* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageViewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkShaderModuleCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineCacheCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSpecializationMapEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationMapEntry* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSpecializationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSpecializationInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineShaderStageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkComputePipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkVertexInputBindingDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkVertexInputAttributeDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineTessellationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkViewport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkViewport* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineViewportStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkStencilOpState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkStencilOpState* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineColorBlendAttachmentState(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineDynamicStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkGraphicsPipelineCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPushConstantRange(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantRange* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSamplerCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyDescriptorSet* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorImageInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorPoolSize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolSize* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetLayoutBinding(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkWriteDescriptorSet(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSet* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFramebufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassDependency(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandPoolCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandBufferAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandBufferInheritanceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageSubresourceLayers(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresourceLayers* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkClearColorValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearColorValue* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkClearDepthStencilValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearDepthStencilValue* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkClearValue(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearValue* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkClearAttachment(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearAttachment* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkClearRect(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkClearRect* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageBlit(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_VERSION_1_1
void reservedmarshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindBufferMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindImageMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryDedicatedRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryDedicatedAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryAllocateFlagsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceGroupSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceGroupBindSparseInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceGroupProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceGroupDeviceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryRequirements2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageMemoryRequirements2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceFeatures2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkQueueFamilyProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSparseImageFormatProperties2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePointClippingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkInputAttachmentAspectReference(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageViewUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassMultiviewCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* forMarshaling,
    uint8_t** ptr);

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceVariablePointersFeatures, reservedmarshal_VkPhysicalDeviceVariablePointerFeatures)

void reservedmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceQueueInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkProtectedSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSamplerYcbcrConversionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindImagePlaneMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorUpdateTemplateEntry(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalMemoryProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalImageFormatProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalBufferProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalBufferProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceIDProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalMemoryImageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalMemoryBufferCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExportMemoryAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalFenceProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalFenceProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExportFenceCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExportSemaphoreCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkExternalSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* forMarshaling,
    uint8_t** ptr);

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderDrawParametersFeatures, reservedmarshal_VkPhysicalDeviceShaderDrawParameterFeatures)

#endif
#ifdef VK_VERSION_1_2
void reservedmarshal_VkPhysicalDeviceVulkan11Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkan12Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkConformanceVersion(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkConformanceVersion* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageFormatListCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescription2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentReference2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReference2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassDescription2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescription2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassDependency2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDependency2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassCreateInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassBeginInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassEndInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassEndInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDriverProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageStencilUsageCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSamplerReductionModeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFramebufferAttachmentImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassAttachmentBeginInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentReferenceStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkAttachmentDescriptionStencilLayout(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreTypeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkTimelineSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreWaitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreSignalInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferDeviceAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_VERSION_1_3
void reservedmarshal_VkPhysicalDeviceVulkan13Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineCreationFeedback(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceToolProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDevicePrivateDataCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPrivateDataSlotCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryBarrier2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageMemoryBarrier2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDependencyInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDependencyInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandBufferSubmitInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubmitInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubmitInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferCopy2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCopy2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferImageCopy2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferImageCopy2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyBufferToImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyImageToBufferInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageBlit2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageBlit2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBlitImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBlitImageInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageResolve2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageResolve2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkResolveImageInfo2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkResolveImageInfo2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingAttachmentInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRenderingCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFormatProperties3(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFormatProperties3* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceBufferMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceImageMemoryRequirements(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_VERSION_1_4
void reservedmarshal_VkPhysicalDeviceVulkan14Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVulkan14Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceQueueGlobalPriorityCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkQueueFamilyGlobalPriorityProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderFloatControls2Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceShaderExpectAssumeFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceLineRasterizationFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceLineRasterizationProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRasterizationLineStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkVertexInputBindingDivisorDescription(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineVertexInputDivisorStateCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceIndexTypeUint8Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryMapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryMapInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryUnmapInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance5Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance5Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingAreaInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAreaInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageSubresource2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageSubresource2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceImageSubresourceInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubresourceLayout2(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceLayout2* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineCreateFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBufferUsageFlags2CreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePushDescriptorProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingAttachmentLocationInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingInputAttachmentIndexInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance6Features(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceMaintenance6Properties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindMemoryStatus(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindMemoryStatus* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkBindDescriptorSetsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPushConstantsInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushConstantsInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPushDescriptorSetInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPushDescriptorSetWithTemplateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePipelineProtectedAccessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePipelineRobustnessFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePipelineRobustnessProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRobustnessCreateInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceHostImageCopyFeatures(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceHostImageCopyProperties(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkMemoryToImageCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkMemoryToImageCopy* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageToMemoryCopy(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageToMemoryCopy* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyMemoryToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyImageToMemoryInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCopyImageToImageInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkHostImageLayoutTransitionInfo(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSubresourceHostMemcpySize(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkHostImageCopyDevicePerformanceQuery(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_KHR_dynamic_rendering
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderingInfo, reservedmarshal_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderingAttachmentInfo, reservedmarshal_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineRenderingCreateInfo, reservedmarshal_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceDynamicRenderingFeatures, reservedmarshal_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCommandBufferInheritanceRenderingInfo, reservedmarshal_VkCommandBufferInheritanceRenderingInfoKHR)

#endif
#ifdef VK_KHR_multiview
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderPassMultiviewCreateInfo, reservedmarshal_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMultiviewFeatures, reservedmarshal_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMultiviewProperties, reservedmarshal_VkPhysicalDeviceMultiviewPropertiesKHR)

#endif
#ifdef VK_KHR_get_physical_device_properties2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceFeatures2, reservedmarshal_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceProperties2, reservedmarshal_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkFormatProperties2, reservedmarshal_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageFormatProperties2, reservedmarshal_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceImageFormatInfo2, reservedmarshal_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkQueueFamilyProperties2, reservedmarshal_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMemoryProperties2, reservedmarshal_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSparseImageFormatProperties2, reservedmarshal_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceSparseImageFormatInfo2, reservedmarshal_VkPhysicalDeviceSparseImageFormatInfo2KHR)

#endif
#ifdef VK_KHR_external_memory_capabilities
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalMemoryProperties, reservedmarshal_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceExternalImageFormatInfo, reservedmarshal_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalImageFormatProperties, reservedmarshal_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceExternalBufferInfo, reservedmarshal_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalBufferProperties, reservedmarshal_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceIDProperties, reservedmarshal_VkPhysicalDeviceIDPropertiesKHR)

#endif
#ifdef VK_KHR_external_memory
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalMemoryImageCreateInfo, reservedmarshal_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalMemoryBufferCreateInfo, reservedmarshal_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExportMemoryAllocateInfo, reservedmarshal_VkExportMemoryAllocateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_capabilities
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceExternalSemaphoreInfo, reservedmarshal_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalSemaphoreProperties, reservedmarshal_VkExternalSemaphorePropertiesKHR)

#endif
#ifdef VK_KHR_external_semaphore
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExportSemaphoreCreateInfo, reservedmarshal_VkExportSemaphoreCreateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_fd
void reservedmarshal_VkImportSemaphoreFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSemaphoreGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_KHR_shader_float16_int8
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderFloat16Int8Features, reservedmarshal_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderFloat16Int8Features, reservedmarshal_VkPhysicalDeviceFloat16Int8FeaturesKHR)

#endif
#ifdef VK_KHR_incremental_present
void reservedmarshal_VkRectLayerKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRectLayerKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPresentRegionKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPresentRegionsKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPresentRegionsKHR* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_KHR_descriptor_update_template
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDescriptorUpdateTemplateEntry, reservedmarshal_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDescriptorUpdateTemplateCreateInfo, reservedmarshal_VkDescriptorUpdateTemplateCreateInfoKHR)

#endif
#ifdef VK_KHR_imageless_framebuffer
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceImagelessFramebufferFeatures, reservedmarshal_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkFramebufferAttachmentsCreateInfo, reservedmarshal_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkFramebufferAttachmentImageInfo, reservedmarshal_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderPassAttachmentBeginInfo, reservedmarshal_VkRenderPassAttachmentBeginInfoKHR)

#endif
#ifdef VK_KHR_create_renderpass2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderPassCreateInfo2, reservedmarshal_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkAttachmentDescription2, reservedmarshal_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkAttachmentReference2, reservedmarshal_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubpassDescription2, reservedmarshal_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubpassDependency2, reservedmarshal_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubpassBeginInfo, reservedmarshal_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubpassEndInfo, reservedmarshal_VkSubpassEndInfoKHR)

#endif
#ifdef VK_KHR_external_fence_capabilities
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceExternalFenceInfo, reservedmarshal_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExternalFenceProperties, reservedmarshal_VkExternalFencePropertiesKHR)

#endif
#ifdef VK_KHR_external_fence
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkExportFenceCreateInfo, reservedmarshal_VkExportFenceCreateInfoKHR)

#endif
#ifdef VK_KHR_external_fence_fd
void reservedmarshal_VkImportFenceFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkFenceGetFdInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_KHR_maintenance2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDevicePointClippingProperties, reservedmarshal_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderPassInputAttachmentAspectCreateInfo, reservedmarshal_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkInputAttachmentAspectReference, reservedmarshal_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageViewUsageCreateInfo, reservedmarshal_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineTessellationDomainOriginStateCreateInfo, reservedmarshal_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

#endif
#ifdef VK_KHR_dedicated_allocation
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryDedicatedRequirements, reservedmarshal_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryDedicatedAllocateInfo, reservedmarshal_VkMemoryDedicatedAllocateInfoKHR)

#endif
#ifdef VK_KHR_get_memory_requirements2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferMemoryRequirementsInfo2, reservedmarshal_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageMemoryRequirementsInfo2, reservedmarshal_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageSparseMemoryRequirementsInfo2, reservedmarshal_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryRequirements2, reservedmarshal_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSparseImageMemoryRequirements2, reservedmarshal_VkSparseImageMemoryRequirements2KHR)

#endif
#ifdef VK_KHR_image_format_list
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageFormatListCreateInfo, reservedmarshal_VkImageFormatListCreateInfoKHR)

#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSamplerYcbcrConversionCreateInfo, reservedmarshal_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSamplerYcbcrConversionInfo, reservedmarshal_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBindImagePlaneMemoryInfo, reservedmarshal_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImagePlaneMemoryRequirementsInfo, reservedmarshal_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures, reservedmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSamplerYcbcrConversionImageFormatProperties, reservedmarshal_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

#endif
#ifdef VK_KHR_bind_memory2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBindBufferMemoryInfo, reservedmarshal_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBindImageMemoryInfo, reservedmarshal_VkBindImageMemoryInfoKHR)

#endif
#ifdef VK_KHR_maintenance3
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMaintenance3Properties, reservedmarshal_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDescriptorSetLayoutSupport, reservedmarshal_VkDescriptorSetLayoutSupportKHR)

#endif
#ifdef VK_KHR_shader_subgroup_extended_types
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, reservedmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

#endif
#ifdef VK_KHR_global_priority
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDeviceQueueGlobalPriorityCreateInfo, reservedmarshal_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceGlobalPriorityQueryFeatures, reservedmarshal_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkQueueFamilyGlobalPriorityProperties, reservedmarshal_VkQueueFamilyGlobalPriorityPropertiesKHR)

#endif
#ifdef VK_KHR_vulkan_memory_model
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures, reservedmarshal_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

#endif
#ifdef VK_KHR_shader_terminate_invocation
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures, reservedmarshal_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

#endif
#ifdef VK_KHR_buffer_device_address
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures, reservedmarshal_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferDeviceAddressInfo, reservedmarshal_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferOpaqueCaptureAddressCreateInfo, reservedmarshal_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo, reservedmarshal_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo, reservedmarshal_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

#endif
#ifdef VK_KHR_pipeline_executable_properties
void reservedmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineInfoKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineExecutablePropertiesKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineExecutableInfoKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineExecutableStatisticKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_KHR_shader_integer_dot_product
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures, reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties, reservedmarshal_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

#endif
#ifdef VK_KHR_synchronization2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryBarrier2, reservedmarshal_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferMemoryBarrier2, reservedmarshal_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageMemoryBarrier2, reservedmarshal_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDependencyInfo, reservedmarshal_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubmitInfo2, reservedmarshal_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSemaphoreSubmitInfo, reservedmarshal_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCommandBufferSubmitInfo, reservedmarshal_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceSynchronization2Features, reservedmarshal_VkPhysicalDeviceSynchronization2FeaturesKHR)

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, reservedmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

#endif
#ifdef VK_KHR_copy_commands2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyBufferInfo2, reservedmarshal_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyImageInfo2, reservedmarshal_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyBufferToImageInfo2, reservedmarshal_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyImageToBufferInfo2, reservedmarshal_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBlitImageInfo2, reservedmarshal_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkResolveImageInfo2, reservedmarshal_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferCopy2, reservedmarshal_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageCopy2, reservedmarshal_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageBlit2, reservedmarshal_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferImageCopy2, reservedmarshal_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageResolve2, reservedmarshal_VkImageResolve2KHR)

#endif
#ifdef VK_KHR_format_feature_flags2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkFormatProperties3, reservedmarshal_VkFormatProperties3KHR)

#endif
#ifdef VK_KHR_maintenance4
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMaintenance4Features, reservedmarshal_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMaintenance4Properties, reservedmarshal_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDeviceBufferMemoryRequirements, reservedmarshal_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDeviceImageMemoryRequirements, reservedmarshal_VkDeviceImageMemoryRequirementsKHR)

#endif
#ifdef VK_KHR_maintenance5
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMaintenance5Features, reservedmarshal_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceMaintenance5Properties, reservedmarshal_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkRenderingAreaInfo, reservedmarshal_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDeviceImageSubresourceInfo, reservedmarshal_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageSubresource2, reservedmarshal_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubresourceLayout2, reservedmarshal_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineCreateFlags2CreateInfo, reservedmarshal_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkBufferUsageFlags2CreateInfo, reservedmarshal_VkBufferUsageFlags2CreateInfoKHR)

#endif
#ifdef VK_KHR_line_rasterization
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceLineRasterizationFeatures, reservedmarshal_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceLineRasterizationProperties, reservedmarshal_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineRasterizationLineStateCreateInfo, reservedmarshal_VkPipelineRasterizationLineStateCreateInfoKHR)

#endif
#ifdef VK_ANDROID_native_buffer
void reservedmarshal_VkNativeBufferUsage2ANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkNativeBufferANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkNativeBufferANDROID* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_transform_feedback
void reservedmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_texture_compression_astc_hdr
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, reservedmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

#endif
#ifdef VK_EXT_depth_clip_enable
void reservedmarshal_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_inline_uniform_block
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceInlineUniformBlockFeatures, reservedmarshal_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceInlineUniformBlockProperties, reservedmarshal_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkWriteDescriptorSetInlineUniformBlock, reservedmarshal_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo, reservedmarshal_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

#endif
#ifdef VK_EXT_image_drm_format_modifier
void reservedmarshal_VkDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDrmFormatModifierPropertiesListEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageDrmFormatModifierListCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageDrmFormatModifierPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDrmFormatModifierProperties2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDrmFormatModifierPropertiesList2EXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* forMarshaling,
    uint8_t** ptr);

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkVertexInputBindingDivisorDescription, reservedmarshal_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineVertexInputDivisorStateCreateInfo, reservedmarshal_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorFeatures, reservedmarshal_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

#endif
#ifdef VK_EXT_pipeline_creation_feedback
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineCreationFeedbackCreateInfo, reservedmarshal_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineCreationFeedback, reservedmarshal_VkPipelineCreationFeedbackEXT)

#endif
#ifdef VK_EXT_fragment_density_map
void reservedmarshal_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderPassFragmentDensityMapCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_scalar_block_layout
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures, reservedmarshal_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

#endif
#ifdef VK_EXT_subgroup_size_control
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures, reservedmarshal_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceSubgroupSizeControlProperties, reservedmarshal_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, reservedmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

#endif
#ifdef VK_EXT_memory_budget
void reservedmarshal_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_tooling_info
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceToolProperties, reservedmarshal_VkPhysicalDeviceToolPropertiesEXT)

#endif
#ifdef VK_EXT_provoking_vertex
void reservedmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_line_rasterization
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceLineRasterizationFeatures, reservedmarshal_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceLineRasterizationProperties, reservedmarshal_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPipelineRasterizationLineStateCreateInfo, reservedmarshal_VkPipelineRasterizationLineStateCreateInfoEXT)

#endif
#ifdef VK_EXT_index_type_uint8
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceIndexTypeUint8Features, reservedmarshal_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

#endif
#ifdef VK_EXT_extended_dynamic_state
void reservedmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_host_image_copy
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceHostImageCopyFeatures, reservedmarshal_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceHostImageCopyProperties, reservedmarshal_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkMemoryToImageCopy, reservedmarshal_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageToMemoryCopy, reservedmarshal_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyMemoryToImageInfo, reservedmarshal_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyImageToMemoryInfo, reservedmarshal_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkCopyImageToImageInfo, reservedmarshal_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkHostImageLayoutTransitionInfo, reservedmarshal_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubresourceHostMemcpySize, reservedmarshal_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkHostImageCopyDevicePerformanceQuery, reservedmarshal_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkSubresourceLayout2, reservedmarshal_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkImageSubresource2, reservedmarshal_VkImageSubresource2EXT)

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, reservedmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

#endif
#ifdef VK_EXT_texel_buffer_alignment
void reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forMarshaling,
    uint8_t** ptr);

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties, reservedmarshal_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

#endif
#ifdef VK_EXT_device_memory_report
void reservedmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_robustness2
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceRobustness2FeaturesKHR, reservedmarshal_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceRobustness2PropertiesKHR, reservedmarshal_VkPhysicalDeviceRobustness2PropertiesEXT)

#endif
#ifdef VK_EXT_custom_border_color
void reservedmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_private_data
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDevicePrivateDataFeatures, reservedmarshal_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkDevicePrivateDataCreateInfo, reservedmarshal_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPrivateDataSlotCreateInfo, reservedmarshal_VkPrivateDataSlotCreateInfoEXT)

#endif
#ifdef VK_EXT_pipeline_creation_cache_control
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures, reservedmarshal_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

#endif
#ifdef VK_EXT_graphics_pipeline_library
void reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkGraphicsPipelineLibraryCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void reservedmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_image_robustness
DEFINE_ALIAS_FUNCTION(reservedmarshal_VkPhysicalDeviceImageRobustnessFeatures, reservedmarshal_VkPhysicalDeviceImageRobustnessFeaturesEXT)

#endif
#ifdef VK_EXT_image_compression_control
void reservedmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageCompressionControlEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImageCompressionPropertiesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_4444_formats
void reservedmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void reservedmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_extended_dynamic_state2
void reservedmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_color_write_enable
void reservedmarshal_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkPipelineColorWriteCreateInfoEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_GOOGLE_gfxstream
void reservedmarshal_VkImportColorBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkImportBufferGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* forMarshaling,
    uint8_t** ptr);

void reservedmarshal_VkCreateBlobGOOGLE(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* forMarshaling,
    uint8_t** ptr);

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void reservedmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStreamGuest* vkStream,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forMarshaling,
    uint8_t** ptr);

#endif
}  // namespace vk
}  // namespace gfxstream
