/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Register Bank Source Fragments                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_REGBANK_DECLARATIONS
#undef GET_REGBANK_DECLARATIONS
namespace llvm {
namespace ARM {
enum : unsigned {
  InvalidRegBankID = ~0u,
  FPRRegBankID = 0,
  GPRRegBankID = 1,
  NumRegisterBanks,
};
} // end namespace ARM
} // end namespace llvm
#endif // GET_REGBANK_DECLARATIONS

#ifdef GET_TARGET_REGBANK_CLASS
#undef GET_TARGET_REGBANK_CLASS
private:
  static const RegisterBank *RegBanks[];
  static const unsigned Sizes[];

public:
  const RegisterBank &getRegBankFromRegClass(const TargetRegisterClass &RC, LLT Ty) const override;
protected:
  ARMGenRegisterBankInfo(unsigned HwMode = 0);

#endif // GET_TARGET_REGBANK_CLASS

#ifdef GET_TARGET_REGBANK_IMPL
#undef GET_TARGET_REGBANK_IMPL
namespace llvm {
namespace ARM {
const uint32_t FPRRegBankCoverageData[] = {
    // 0-31
    (1u << (ARM::HPRRegClassID - 0)) |
    (1u << (ARM::SPRRegClassID - 0)) |
    (1u << (ARM::SPR_8RegClassID - 0)) |
    (1u << (ARM::FPWithVPRRegClassID - 0)) |
    (1u << (ARM::FPWithVPR_with_ssub_0RegClassID - 0)) |
    (1u << (ARM::FPWithVPR_with_ssub_0_with_ssub_0_in_SPR_8RegClassID - 0)) |
    0,
    // 32-63
    (1u << (ARM::DPRRegClassID - 32)) |
    (1u << (ARM::DPR_VFP2RegClassID - 32)) |
    (1u << (ARM::DPR_8RegClassID - 32)) |
    0,
    // 64-95
    (1u << (ARM::QPRRegClassID - 64)) |
    (1u << (ARM::MQPRRegClassID - 64)) |
    (1u << (ARM::QPR_VFP2RegClassID - 64)) |
    (1u << (ARM::QPR_8RegClassID - 64)) |
    0,
    // 96-127
    0,
    // 128-159
    0,
};
const uint32_t GPRRegBankCoverageData[] = {
    // 0-31
    (1u << (ARM::GPRRegClassID - 0)) |
    (1u << (ARM::GPRnopcRegClassID - 0)) |
    (1u << (ARM::rGPRRegClassID - 0)) |
    (1u << (ARM::GPRnoip_and_GPRwithAPSR_NZCVnospRegClassID - 0)) |
    (1u << (ARM::tGPRRegClassID - 0)) |
    (1u << (ARM::GPRnoip_and_tGPREvenRegClassID - 0)) |
    (1u << (ARM::tGPROddRegClassID - 0)) |
    (1u << (ARM::tGPREvenRegClassID - 0)) |
    (1u << (ARM::GPRnosp_and_GPRnopc_and_hGPRRegClassID - 0)) |
    (1u << (ARM::tcGPRRegClassID - 0)) |
    (1u << (ARM::GPRnoip_and_GPRnopcRegClassID - 0)) |
    (1u << (ARM::GPRnopc_and_GPRnoip_and_hGPRRegClassID - 0)) |
    (1u << (ARM::GPRnopc_and_hGPRRegClassID - 0)) |
    (1u << (ARM::GPRnospRegClassID - 0)) |
    (1u << (ARM::GPRnoip_and_GPRnospRegClassID - 0)) |
    (1u << (ARM::tGPRwithpcRegClassID - 0)) |
    (1u << (ARM::GPRnosp_and_GPRnoip_and_hGPRRegClassID - 0)) |
    (1u << (ARM::GPRnosp_and_hGPRRegClassID - 0)) |
    (1u << (ARM::GPRnoipRegClassID - 0)) |
    (1u << (ARM::GPRnoip_and_hGPRRegClassID - 0)) |
    (1u << (ARM::hGPRRegClassID - 0)) |
    (1u << (ARM::GPRwithAPSRRegClassID - 0)) |
    (1u << (ARM::GPRwithAPSR_NZCVnospRegClassID - 0)) |
    0,
    // 32-63
    (1u << (ARM::tGPR_and_tGPREvenRegClassID - 32)) |
    (1u << (ARM::tGPREven_and_tcGPRnotr12RegClassID - 32)) |
    (1u << (ARM::tGPR_and_tGPROddRegClassID - 32)) |
    (1u << (ARM::tGPROdd_and_tcGPRRegClassID - 32)) |
    (1u << (ARM::tcGPRnotr12RegClassID - 32)) |
    (1u << (ARM::hGPR_and_GPRnoip_and_tGPREvenRegClassID - 32)) |
    (1u << (ARM::hGPR_and_tGPROddRegClassID - 32)) |
    (1u << (ARM::GPRnosp_and_GPRnopc_and_GPRnoip_and_hGPRRegClassID - 32)) |
    (1u << (ARM::hGPR_and_tGPREvenRegClassID - 32)) |
    (1u << (ARM::GPRlrRegClassID - 32)) |
    (1u << (ARM::hGPR_and_tcGPRRegClassID - 32)) |
    (1u << (ARM::tGPREven_and_tcGPRRegClassID - 32)) |
    (1u << (ARM::GPRspRegClassID - 32)) |
    (1u << (ARM::hGPR_and_tGPRwithpcRegClassID - 32)) |
    0,
    // 64-95
    0,
    // 96-127
    0,
    // 128-159
    0,
};

constexpr RegisterBank FPRRegBank(/* ID */ ARM::FPRRegBankID, /* Name */ "FPRB", /* CoveredRegClasses */ FPRRegBankCoverageData, /* NumRegClasses */ 137);
constexpr RegisterBank GPRRegBank(/* ID */ ARM::GPRRegBankID, /* Name */ "GPRB", /* CoveredRegClasses */ GPRRegBankCoverageData, /* NumRegClasses */ 137);
} // end namespace ARM

const RegisterBank *ARMGenRegisterBankInfo::RegBanks[] = {
    &ARM::FPRRegBank,
    &ARM::GPRRegBank,
};

const unsigned ARMGenRegisterBankInfo::Sizes[] = {
    // Mode = 0 (Default)
    128,
    32,
};

ARMGenRegisterBankInfo::ARMGenRegisterBankInfo(unsigned HwMode)
    : RegisterBankInfo(RegBanks, ARM::NumRegisterBanks, Sizes, HwMode) {
  // Assert that RegBank indices match their ID's
#ifndef NDEBUG
  for (auto RB : enumerate(RegBanks))
    assert(RB.index() == RB.value()->getID() && "Index != ID");
#endif // NDEBUG
}
const RegisterBank &
ARMGenRegisterBankInfo::getRegBankFromRegClass(const TargetRegisterClass &RC, LLT) const {
  constexpr uint32_t InvalidRegBankID = uint32_t(ARM::InvalidRegBankID) & 3;
  static const uint32_t RegClass2RegBank[5] = {
    (uint32_t(ARM::FPRRegBankID) << 0) | // HPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 2) | // FPWithVPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 4) | // SPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 6) | // FPWithVPR_with_ssub_0RegClassID
    (uint32_t(ARM::GPRRegBankID) << 8) | // GPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 10) | // GPRwithAPSRRegClassID
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(ARM::FPRRegBankID) << 14) | // SPR_8RegClassID
    (uint32_t(ARM::GPRRegBankID) << 16) | // GPRnopcRegClassID
    (uint32_t(ARM::GPRRegBankID) << 18) | // GPRnospRegClassID
    (uint32_t(ARM::GPRRegBankID) << 20) | // GPRwithAPSR_NZCVnospRegClassID
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(ARM::GPRRegBankID) << 26) | // GPRnoipRegClassID
    (uint32_t(ARM::GPRRegBankID) << 28) | // rGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 30), // GPRnoip_and_GPRnopcRegClassID
    (uint32_t(ARM::GPRRegBankID) << 0) | // GPRnoip_and_GPRnospRegClassID
    (uint32_t(ARM::GPRRegBankID) << 2) | // GPRnoip_and_GPRwithAPSR_NZCVnospRegClassID
    (uint32_t(ARM::GPRRegBankID) << 4) | // tGPRwithpcRegClassID
    (uint32_t(ARM::FPRRegBankID) << 6) | // FPWithVPR_with_ssub_0_with_ssub_0_in_SPR_8RegClassID
    (uint32_t(ARM::GPRRegBankID) << 8) | // hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 10) | // tGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 12) | // tGPREvenRegClassID
    (uint32_t(ARM::GPRRegBankID) << 14) | // GPRnopc_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 16) | // GPRnosp_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 18) | // GPRnoip_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 20) | // GPRnoip_and_tGPREvenRegClassID
    (uint32_t(ARM::GPRRegBankID) << 22) | // GPRnosp_and_GPRnopc_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 24) | // tGPROddRegClassID
    (uint32_t(ARM::GPRRegBankID) << 26) | // GPRnopc_and_GPRnoip_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 28) | // GPRnosp_and_GPRnoip_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 30), // tcGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 0) | // GPRnosp_and_GPRnopc_and_GPRnoip_and_hGPRRegClassID
    (uint32_t(ARM::GPRRegBankID) << 2) | // hGPR_and_tGPREvenRegClassID
    (uint32_t(ARM::GPRRegBankID) << 4) | // tGPR_and_tGPREvenRegClassID
    (uint32_t(ARM::GPRRegBankID) << 6) | // tGPR_and_tGPROddRegClassID
    (uint32_t(ARM::GPRRegBankID) << 8) | // tcGPRnotr12RegClassID
    (uint32_t(ARM::GPRRegBankID) << 10) | // tGPREven_and_tcGPRRegClassID
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(ARM::GPRRegBankID) << 14) | // hGPR_and_GPRnoip_and_tGPREvenRegClassID
    (uint32_t(ARM::GPRRegBankID) << 16) | // hGPR_and_tGPROddRegClassID
    (uint32_t(ARM::GPRRegBankID) << 18) | // tGPREven_and_tcGPRnotr12RegClassID
    (uint32_t(ARM::GPRRegBankID) << 20) | // tGPROdd_and_tcGPRRegClassID
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(ARM::GPRRegBankID) << 26) | // GPRlrRegClassID
    (uint32_t(ARM::GPRRegBankID) << 28) | // GPRspRegClassID
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(ARM::GPRRegBankID) << 2) | // hGPR_and_tGPRwithpcRegClassID
    (uint32_t(ARM::GPRRegBankID) << 4) | // hGPR_and_tcGPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 6) | // DPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 8) | // DPR_VFP2RegClassID
    (uint32_t(ARM::FPRRegBankID) << 10) | // DPR_8RegClassID
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(InvalidRegBankID) << 16) |
    (uint32_t(InvalidRegBankID) << 18) |
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(InvalidRegBankID) << 22) |
    (uint32_t(InvalidRegBankID) << 24) |
    (uint32_t(InvalidRegBankID) << 26) |
    (uint32_t(InvalidRegBankID) << 28) |
    (uint32_t(InvalidRegBankID) << 30),
    (uint32_t(InvalidRegBankID) << 0) |
    (uint32_t(InvalidRegBankID) << 2) |
    (uint32_t(InvalidRegBankID) << 4) |
    (uint32_t(InvalidRegBankID) << 6) |
    (uint32_t(InvalidRegBankID) << 8) |
    (uint32_t(ARM::FPRRegBankID) << 10) | // QPRRegClassID
    (uint32_t(InvalidRegBankID) << 12) |
    (uint32_t(InvalidRegBankID) << 14) |
    (uint32_t(ARM::FPRRegBankID) << 16) | // MQPRRegClassID
    (uint32_t(ARM::FPRRegBankID) << 18) | // QPR_VFP2RegClassID
    (uint32_t(InvalidRegBankID) << 20) |
    (uint32_t(ARM::FPRRegBankID) << 22) // QPR_8RegClassID
  };
  const unsigned RegClassID = RC.getID();
  if (LLVM_LIKELY(RegClassID < 76)) {
    unsigned RegBankID = (RegClass2RegBank[RegClassID / 16] >> ((RegClassID % 16) * 2)) & 3;
    if (RegBankID != InvalidRegBankID)
      return getRegBank(RegBankID);
  }
  llvm_unreachable(llvm::Twine("Target needs to handle register class ID 0x").concat(llvm::Twine::utohexstr(RegClassID)).str().c_str());
}
} // end namespace llvm
#endif // GET_TARGET_REGBANK_IMPL
