//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armprivatedns

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
//     forms part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewPrivateZonesClient creates a new instance of PrivateZonesClient.
func (c *ClientFactory) NewPrivateZonesClient() *PrivateZonesClient {
	return &PrivateZonesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewRecordSetsClient creates a new instance of RecordSetsClient.
func (c *ClientFactory) NewRecordSetsClient() *RecordSetsClient {
	return &RecordSetsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewVirtualNetworkLinksClient creates a new instance of VirtualNetworkLinksClient.
func (c *ClientFactory) NewVirtualNetworkLinksClient() *VirtualNetworkLinksClient {
	return &VirtualNetworkLinksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
