/* event_type : conversion table */
const lookup_info ml_table_event_type[] = {
  { 0, 43 },
  { MLTAG_SELECTION_CLEAR, GDK_SELECTION_CLEAR },
  { MLTAG_TOUCHPAD_PINCH, GDK_TOUCHPAD_PINCH },
  { MLTAG_PROXIMITY_IN, GDK_PROXIMITY_IN },
  { MLTAG_DROP_START, GDK_DROP_START },
  { MLTAG_THREE_BUTTON_PRESS, GDK_3BUTTON_PRESS },
  { MLTAG_NOTHING, GDK_NOTHING },
  { MLTAG_DAMAGE, GDK_DAMAGE },
  { MLTAG_TOUCH_CANCEL, GDK_TOUCH_CANCEL },
  { MLTAG_VISIBILITY_NOTIFY, GDK_VISIBILITY_NOTIFY },
  { MLTAG_GRAB_BROKEN, GDK_GRAB_BROKEN },
  { MLTAG_BUTTON_RELEASE, GDK_BUTTON_RELEASE },
  { MLTAG_DRAG_STATUS, GDK_DRAG_STATUS },
  { MLTAG_KEY_PRESS, GDK_KEY_PRESS },
  { MLTAG_EXPOSE, GDK_EXPOSE },
  { MLTAG_SCROLL, GDK_SCROLL },
  { MLTAG_WINDOW_STATE, GDK_WINDOW_STATE },
  { MLTAG_KEY_RELEASE, GDK_KEY_RELEASE },
  { MLTAG_TOUCH_BEGIN, GDK_TOUCH_BEGIN },
  { MLTAG_MAP, GDK_MAP },
  { MLTAG_FOCUS_CHANGE, GDK_FOCUS_CHANGE },
  { MLTAG_SELECTION_NOTIFY, GDK_SELECTION_NOTIFY },
  { MLTAG_PROXIMITY_OUT, GDK_PROXIMITY_OUT },
  { MLTAG_SELECTION_REQUEST, GDK_SELECTION_REQUEST },
  { MLTAG_TOUCHPAD_SWIPE, GDK_TOUCHPAD_SWIPE },
  { MLTAG_TWO_BUTTON_PRESS, GDK_2BUTTON_PRESS },
  { MLTAG_ENTER_NOTIFY, GDK_ENTER_NOTIFY },
  { MLTAG_DELETE, GDK_DELETE },
  { MLTAG_DRAG_ENTER, GDK_DRAG_ENTER },
  { MLTAG_DRAG_LEAVE, GDK_DRAG_LEAVE },
  { MLTAG_BUTTON_PRESS, GDK_BUTTON_PRESS },
  { MLTAG_TOUCH_UPDATE, GDK_TOUCH_UPDATE },
  { MLTAG_DESTROY, GDK_DESTROY },
  { MLTAG_UNMAP, GDK_UNMAP },
  { MLTAG_SETTING, GDK_SETTING },
  { MLTAG_DROP_FINISHED, GDK_DROP_FINISHED },
  { MLTAG_CLIENT_EVENT, GDK_CLIENT_EVENT },
  { MLTAG_TOUCH_END, GDK_TOUCH_END },
  { MLTAG_DRAG_MOTION, GDK_DRAG_MOTION },
  { MLTAG_LEAVE_NOTIFY, GDK_LEAVE_NOTIFY },
  { MLTAG_OWNER_CHANGE, GDK_OWNER_CHANGE },
  { MLTAG_CONFIGURE, GDK_CONFIGURE },
  { MLTAG_MOTION_NOTIFY, GDK_MOTION_NOTIFY },
  { MLTAG_PROPERTY_NOTIFY, GDK_PROPERTY_NOTIFY },
};

/* gdkVisibilityState : conversion table */
const lookup_info ml_table_gdkVisibilityState[] = {
  { 0, 3 },
  { MLTAG_PARTIAL, GDK_VISIBILITY_PARTIAL },
  { MLTAG_UNOBSCURED, GDK_VISIBILITY_UNOBSCURED },
  { MLTAG_FULLY_OBSCURED, GDK_VISIBILITY_FULLY_OBSCURED },
};

/* GdkTouchpadGesturePhase : conversion table */
const lookup_info ml_table_GdkTouchpadGesturePhase[] = {
  { 0, 4 },
  { MLTAG_CANCEL, GDK_TOUCHPAD_GESTURE_PHASE_CANCEL },
  { MLTAG_END, GDK_TOUCHPAD_GESTURE_PHASE_END },
  { MLTAG_BEGIN, GDK_TOUCHPAD_GESTURE_PHASE_BEGIN },
  { MLTAG_UPDATE, GDK_TOUCHPAD_GESTURE_PHASE_UPDATE },
};

/* gdkScrollDirection : conversion table */
const lookup_info ml_table_gdkScrollDirection[] = {
  { 0, 5 },
  { MLTAG_RIGHT, GDK_SCROLL_RIGHT },
  { MLTAG_UP, GDK_SCROLL_UP },
  { MLTAG_DOWN, GDK_SCROLL_DOWN },
  { MLTAG_LEFT, GDK_SCROLL_LEFT },
  { MLTAG_SMOOTH, GDK_SCROLL_SMOOTH },
};

/* gdkCrossingMode : conversion table */
const lookup_info ml_table_gdkCrossingMode[] = {
  { 0, 9 },
  { MLTAG_GTK_UNGRAB, GDK_CROSSING_GTK_UNGRAB },
  { MLTAG_GTK_GRAB, GDK_CROSSING_GTK_GRAB },
  { MLTAG_STATE_CHANGED, GDK_CROSSING_STATE_CHANGED },
  { MLTAG_NORMAL, GDK_CROSSING_NORMAL },
  { MLTAG_DEVICE_SWITCH, GDK_CROSSING_DEVICE_SWITCH },
  { MLTAG_TOUCH_BEGIN, GDK_CROSSING_TOUCH_BEGIN },
  { MLTAG_UNGRAB, GDK_CROSSING_UNGRAB },
  { MLTAG_TOUCH_END, GDK_CROSSING_TOUCH_END },
  { MLTAG_GRAB, GDK_CROSSING_GRAB },
};

/* gdkNotifyType : conversion table */
const lookup_info ml_table_gdkNotifyType[] = {
  { 0, 6 },
  { MLTAG_UNKNOWN, GDK_NOTIFY_UNKNOWN },
  { MLTAG_INFERIOR, GDK_NOTIFY_INFERIOR },
  { MLTAG_NONLINEAR_VIRTUAL, GDK_NOTIFY_NONLINEAR_VIRTUAL },
  { MLTAG_ANCESTOR, GDK_NOTIFY_ANCESTOR },
  { MLTAG_VIRTUAL, GDK_NOTIFY_VIRTUAL },
  { MLTAG_NONLINEAR, GDK_NOTIFY_NONLINEAR },
};

/* gdkSettingAction : conversion table */
const lookup_info ml_table_gdkSettingAction[] = {
  { 0, 3 },
  { MLTAG_CHANGED, GDK_SETTING_ACTION_CHANGED },
  { MLTAG_NEW, GDK_SETTING_ACTION_NEW },
  { MLTAG_DELETED, GDK_SETTING_ACTION_DELETED },
};

/* GdkOwnerChange : conversion table */
const lookup_info ml_table_GdkOwnerChange[] = {
  { 0, 3 },
  { MLTAG_CLOSE, GDK_OWNER_CHANGE_CLOSE },
  { MLTAG_NEW_OWNER, GDK_OWNER_CHANGE_NEW_OWNER },
  { MLTAG_DESTROY, GDK_OWNER_CHANGE_DESTROY },
};

/* gdkWindowState : conversion table */
const lookup_info ml_table_gdkWindowState[] = {
  { 0, 9 },
  { MLTAG_FOCUSED, GDK_WINDOW_STATE_FOCUSED },
  { MLTAG_WITHDRAWN, GDK_WINDOW_STATE_WITHDRAWN },
  { MLTAG_ICONIFIED, GDK_WINDOW_STATE_ICONIFIED },
  { MLTAG_FULLSCREEN, GDK_WINDOW_STATE_FULLSCREEN },
  { MLTAG_MAXIMIZED, GDK_WINDOW_STATE_MAXIMIZED },
  { MLTAG_TILED, GDK_WINDOW_STATE_TILED },
  { MLTAG_ABOVE, GDK_WINDOW_STATE_ABOVE },
  { MLTAG_BELOW, GDK_WINDOW_STATE_BELOW },
  { MLTAG_STICKY, GDK_WINDOW_STATE_STICKY },
};

/* gdkInputSource : conversion table */
const lookup_info ml_table_gdkInputSource[] = {
  { 0, 7 },
  { MLTAG_KEYBOARD, GDK_SOURCE_KEYBOARD },
  { MLTAG_TOUCHSCREEN, GDK_SOURCE_TOUCHSCREEN },
  { MLTAG_TOUCHPAD, GDK_SOURCE_TOUCHPAD },
  { MLTAG_CURSOR, GDK_SOURCE_CURSOR },
  { MLTAG_ERASER, GDK_SOURCE_ERASER },
  { MLTAG_PEN, GDK_SOURCE_PEN },
  { MLTAG_MOUSE, GDK_SOURCE_MOUSE },
};

/* gdkInputMode : conversion table */
const lookup_info ml_table_gdkInputMode[] = {
  { 0, 3 },
  { MLTAG_DISABLED, GDK_MODE_DISABLED },
  { MLTAG_SCREEN, GDK_MODE_SCREEN },
  { MLTAG_WINDOW, GDK_MODE_WINDOW },
};

/* gdkDeviceType : conversion table */
const lookup_info ml_table_gdkDeviceType[] = {
  { 0, 3 },
  { MLTAG_MASTER, GDK_DEVICE_TYPE_MASTER },
  { MLTAG_SLAVE, GDK_DEVICE_TYPE_SLAVE },
  { MLTAG_FLOATING, GDK_DEVICE_TYPE_FLOATING },
};

/* gdkVisualType : conversion table */
const lookup_info ml_table_gdkVisualType[] = {
  { 0, 6 },
  { MLTAG_GRAYSCALE, GDK_VISUAL_GRAYSCALE },
  { MLTAG_PSEUDO_COLOR, GDK_VISUAL_PSEUDO_COLOR },
  { MLTAG_DIRECT_COLOR, GDK_VISUAL_DIRECT_COLOR },
  { MLTAG_STATIC_COLOR, GDK_VISUAL_STATIC_COLOR },
  { MLTAG_TRUE_COLOR, GDK_VISUAL_TRUE_COLOR },
  { MLTAG_STATIC_GRAY, GDK_VISUAL_STATIC_GRAY },
};

/* gdkDragAction : conversion table */
const lookup_info ml_table_gdkDragAction[] = {
  { 0, 6 },
  { MLTAG_ASK, GDK_ACTION_ASK },
  { MLTAG_PRIVATE, GDK_ACTION_PRIVATE },
  { MLTAG_DEFAULT, GDK_ACTION_DEFAULT },
  { MLTAG_COPY, GDK_ACTION_COPY },
  { MLTAG_LINK, GDK_ACTION_LINK },
  { MLTAG_MOVE, GDK_ACTION_MOVE },
};

/* gdkDragProtocol : conversion table */
const lookup_info ml_table_gdkDragProtocol[] = {
  { 0, 8 },
  { MLTAG_LOCAL, GDK_DRAG_PROTO_LOCAL },
  { MLTAG_MOTIF, GDK_DRAG_PROTO_MOTIF },
  { MLTAG_WAYLAND, GDK_DRAG_PROTO_WAYLAND },
  { MLTAG_ROOTWIN, GDK_DRAG_PROTO_ROOTWIN },
  { MLTAG_WIN32_DROPFILES, GDK_DRAG_PROTO_WIN32_DROPFILES },
  { MLTAG_NONE, GDK_DRAG_PROTO_NONE },
  { MLTAG_OLE2, GDK_DRAG_PROTO_OLE2 },
  { MLTAG_XDND, GDK_DRAG_PROTO_XDND },
};

/* xdata : conversion table */
const lookup_info ml_table_xdata[] = {
  { 0, 4 },
  { MLTAG_INT32S, 32 },
  { MLTAG_SHORTS, 16 },
  { MLTAG_NONE, 0 },
  { MLTAG_BYTES, 8 },
};

/* property_state : conversion table */
const lookup_info ml_table_property_state[] = {
  { 0, 2 },
  { MLTAG_NEW_VALUE, GDK_PROPERTY_NEW_VALUE },
  { MLTAG_DELETE, GDK_PROPERTY_DELETE },
};

/* property_mode : conversion table */
const lookup_info ml_table_property_mode[] = {
  { 0, 3 },
  { MLTAG_APPEND, GDK_PROP_MODE_APPEND },
  { MLTAG_REPLACE, GDK_PROP_MODE_REPLACE },
  { MLTAG_PREPEND, GDK_PROP_MODE_PREPEND },
};

/* GdkWindowWindowClass : conversion table */
const lookup_info ml_table_GdkWindowWindowClass[] = {
  { 0, 2 },
  { MLTAG_INPUT_ONLY, GDK_INPUT_ONLY },
  { MLTAG_INPUT_OUTPUT, GDK_INPUT_OUTPUT },
};

/* GdkWindowType : conversion table */
const lookup_info ml_table_GdkWindowType[] = {
  { 0, 7 },
  { MLTAG_CHILD, GDK_WINDOW_CHILD },
  { MLTAG_FOREIGN, GDK_WINDOW_FOREIGN },
  { MLTAG_SUBSURFACE, GDK_WINDOW_SUBSURFACE },
  { MLTAG_TOPLEVEL, GDK_WINDOW_TOPLEVEL },
  { MLTAG_OFFSCREEN, GDK_WINDOW_OFFSCREEN },
  { MLTAG_ROOT, GDK_WINDOW_ROOT },
  { MLTAG_TEMP, GDK_WINDOW_TEMP },
};

/* window_attributes_type : conversion table */
const lookup_info ml_table_window_attributes_type[] = {
  { 0, 8 },
  { MLTAG_CURSOR, GDK_WA_CURSOR },
  { MLTAG_X, GDK_WA_X },
  { MLTAG_Y, GDK_WA_Y },
  { MLTAG_TITLE, GDK_WA_TITLE },
  { MLTAG_TYPE_HINT, GDK_WA_TYPE_HINT },
  { MLTAG_VISUAL, GDK_WA_VISUAL },
  { MLTAG_NOREDIR, GDK_WA_NOREDIR },
  { MLTAG_WMCLASS, GDK_WA_WMCLASS },
};

/* window_hints : conversion table */
const lookup_info ml_table_window_hints[] = {
  { 0, 9 },
  { MLTAG_RESIZE_INC, GDK_HINT_RESIZE_INC },
  { MLTAG_MAX_SIZE, GDK_HINT_MAX_SIZE },
  { MLTAG_BASE_SIZE, GDK_HINT_BASE_SIZE },
  { MLTAG_ASPECT, GDK_HINT_ASPECT },
  { MLTAG_USER_SIZE, GDK_HINT_USER_SIZE },
  { MLTAG_POS, GDK_HINT_POS },
  { MLTAG_USER_POS, GDK_HINT_USER_POS },
  { MLTAG_WIN_GRAVITY, GDK_HINT_WIN_GRAVITY },
  { MLTAG_MIN_SIZE, GDK_HINT_MIN_SIZE },
};

/* GdkWMdecoration : conversion table */
const lookup_info ml_table_GdkWMdecoration[] = {
  { 0, 7 },
  { MLTAG_RESIZEH, GDK_DECOR_RESIZEH },
  { MLTAG_MINIMIZE, GDK_DECOR_MINIMIZE },
  { MLTAG_ALL, GDK_DECOR_ALL },
  { MLTAG_TITLE, GDK_DECOR_TITLE },
  { MLTAG_BORDER, GDK_DECOR_BORDER },
  { MLTAG_MAXIMIZE, GDK_DECOR_MAXIMIZE },
  { MLTAG_MENU, GDK_DECOR_MENU },
};

/* GdkWMFunction : conversion table */
const lookup_info ml_table_GdkWMFunction[] = {
  { 0, 6 },
  { MLTAG_CLOSE, GDK_FUNC_CLOSE },
  { MLTAG_MINIMIZE, GDK_FUNC_MINIMIZE },
  { MLTAG_ALL, GDK_FUNC_ALL },
  { MLTAG_MAXIMIZE, GDK_FUNC_MAXIMIZE },
  { MLTAG_MOVE, GDK_FUNC_MOVE },
  { MLTAG_RESIZE, GDK_FUNC_RESIZE },
};

/* gravity : conversion table */
const lookup_info ml_table_gravity[] = {
  { 0, 10 },
  { MLTAG_SOUTH_WEST, GDK_GRAVITY_SOUTH_WEST },
  { MLTAG_NORTH_EAST, GDK_GRAVITY_NORTH_EAST },
  { MLTAG_NORTH_WEST, GDK_GRAVITY_NORTH_WEST },
  { MLTAG_SOUTH, GDK_GRAVITY_SOUTH },
  { MLTAG_NORTH, GDK_GRAVITY_NORTH },
  { MLTAG_EAST, GDK_GRAVITY_EAST },
  { MLTAG_CENTER, GDK_GRAVITY_CENTER },
  { MLTAG_STATIC, GDK_GRAVITY_STATIC },
  { MLTAG_WEST, GDK_GRAVITY_WEST },
  { MLTAG_SOUTH_EAST, GDK_GRAVITY_SOUTH_EAST },
};

/* window_edge : conversion table */
const lookup_info ml_table_window_edge[] = {
  { 0, 8 },
  { MLTAG_SOUTH_WEST, GDK_WINDOW_EDGE_SOUTH_WEST },
  { MLTAG_NORTH_EAST, GDK_WINDOW_EDGE_NORTH_EAST },
  { MLTAG_NORTH_WEST, GDK_WINDOW_EDGE_NORTH_WEST },
  { MLTAG_SOUTH, GDK_WINDOW_EDGE_SOUTH },
  { MLTAG_NORTH, GDK_WINDOW_EDGE_NORTH },
  { MLTAG_EAST, GDK_WINDOW_EDGE_EAST },
  { MLTAG_WEST, GDK_WINDOW_EDGE_WEST },
  { MLTAG_SOUTH_EAST, GDK_WINDOW_EDGE_SOUTH_EAST },
};

/* fullscreen_mode : conversion table */
const lookup_info ml_table_fullscreen_mode[] = {
  { 0, 2 },
  { MLTAG_ON_ALL_MONITORS, GDK_FULLSCREEN_ON_ALL_MONITORS },
  { MLTAG_ON_CURRENT_MONITOR, GDK_FULLSCREEN_ON_CURRENT_MONITOR },
};

/* gdkModifier : conversion table */
const lookup_info ml_table_gdkModifier[] = {
  { 0, 17 },
  { MLTAG_BUTTON1, GDK_BUTTON1_MASK },
  { MLTAG_BUTTON2, GDK_BUTTON2_MASK },
  { MLTAG_BUTTON3, GDK_BUTTON3_MASK },
  { MLTAG_BUTTON4, GDK_BUTTON4_MASK },
  { MLTAG_BUTTON5, GDK_BUTTON5_MASK },
  { MLTAG_RELEASE, GDK_RELEASE_MASK },
  { MLTAG_SHIFT, GDK_SHIFT_MASK },
  { MLTAG_SUPER, GDK_SUPER_MASK },
  { MLTAG_CONTROL, GDK_CONTROL_MASK },
  { MLTAG_HYPER, GDK_HYPER_MASK },
  { MLTAG_LOCK, GDK_LOCK_MASK },
  { MLTAG_META, GDK_META_MASK },
  { MLTAG_MOD1, GDK_MOD1_MASK },
  { MLTAG_MOD2, GDK_MOD2_MASK },
  { MLTAG_MOD3, GDK_MOD3_MASK },
  { MLTAG_MOD4, GDK_MOD4_MASK },
  { MLTAG_MOD5, GDK_MOD5_MASK },
};

/* gtkModifierIntent : conversion table */
const lookup_info ml_table_gtkModifierIntent[] = {
  { 0, 7 },
  { MLTAG_NO_TEXT_INPUT, GDK_MODIFIER_INTENT_NO_TEXT_INPUT },
  { MLTAG_SHIFT_GROUP, GDK_MODIFIER_INTENT_SHIFT_GROUP },
  { MLTAG_CONTEXT_MENU, GDK_MODIFIER_INTENT_CONTEXT_MENU },
  { MLTAG_PRIMARY_ACCELERATOR, GDK_MODIFIER_INTENT_PRIMARY_ACCELERATOR },
  { MLTAG_DEFAULT_MOD_MASK, GDK_MODIFIER_INTENT_DEFAULT_MOD_MASK },
  { MLTAG_MODIFY_SELECTION, GDK_MODIFIER_INTENT_MODIFY_SELECTION },
  { MLTAG_EXTEND_SELECTION, GDK_MODIFIER_INTENT_EXTEND_SELECTION },
};

/* status : conversion table */
const lookup_info ml_table_status[] = {
  { 0, 5 },
  { MLTAG_ERROR, GDK_ERROR },
  { MLTAG_OK, GDK_OK },
  { MLTAG_ERROR_MEM, GDK_ERROR_MEM },
  { MLTAG_ERROR_PARAM, GDK_ERROR_PARAM },
  { MLTAG_ERROR_FILE, GDK_ERROR_FILE },
};

/* grab_status : conversion table */
const lookup_info ml_table_grab_status[] = {
  { 0, 6 },
  { MLTAG_FROZEN, GDK_GRAB_FROZEN },
  { MLTAG_ALREADY_GRABBED, GDK_GRAB_ALREADY_GRABBED },
  { MLTAG_NOT_VIEWABLE, GDK_GRAB_NOT_VIEWABLE },
  { MLTAG_FAILED, GDK_GRAB_FAILED },
  { MLTAG_INVALID_TIME, GDK_GRAB_INVALID_TIME },
  { MLTAG_SUCCESS, GDK_GRAB_SUCCESS },
};

/* grab_ownership : conversion table */
const lookup_info ml_table_grab_ownership[] = {
  { 0, 3 },
  { MLTAG_APPLICATION, GDK_OWNERSHIP_APPLICATION },
  { MLTAG_WINDOW, GDK_OWNERSHIP_WINDOW },
  { MLTAG_NONE, GDK_OWNERSHIP_NONE },
};

/* event_mask : conversion table */
const lookup_info ml_table_event_mask[] = {
  { 0, 25 },
  { MLTAG_PROPERTY_CHANGE, GDK_PROPERTY_CHANGE_MASK },
  { MLTAG_STRUCTURE, GDK_STRUCTURE_MASK },
  { MLTAG_PROXIMITY_IN, GDK_PROXIMITY_IN_MASK },
  { MLTAG_VISIBILITY_NOTIFY, GDK_VISIBILITY_NOTIFY_MASK },
  { MLTAG_BUTTON_RELEASE, GDK_BUTTON_RELEASE_MASK },
  { MLTAG_EXPOSURE, GDK_EXPOSURE_MASK },
  { MLTAG_BUTTON2_MOTION, GDK_BUTTON2_MOTION_MASK },
  { MLTAG_POINTER_MOTION_HINT, GDK_POINTER_MOTION_HINT_MASK },
  { MLTAG_KEY_PRESS, GDK_KEY_PRESS_MASK },
  { MLTAG_SUBSTRUCTURE, GDK_SUBSTRUCTURE_MASK },
  { MLTAG_SCROLL, GDK_SCROLL_MASK },
  { MLTAG_KEY_RELEASE, GDK_KEY_RELEASE_MASK },
  { MLTAG_FOCUS_CHANGE, GDK_FOCUS_CHANGE_MASK },
  { MLTAG_PROXIMITY_OUT, GDK_PROXIMITY_OUT_MASK },
  { MLTAG_POINTER_MOTION, GDK_POINTER_MOTION_MASK },
  { MLTAG_TOUCH, GDK_TOUCH_MASK },
  { MLTAG_ENTER_NOTIFY, GDK_ENTER_NOTIFY_MASK },
  { MLTAG_BUTTON_PRESS, GDK_BUTTON_PRESS_MASK },
  { MLTAG_BUTTON3_MOTION, GDK_BUTTON3_MOTION_MASK },
  { MLTAG_BUTTON_MOTION, GDK_BUTTON_MOTION_MASK },
  { MLTAG_ALL_EVENTS, GDK_ALL_EVENTS_MASK },
  { MLTAG_LEAVE_NOTIFY, GDK_LEAVE_NOTIFY_MASK },
  { MLTAG_BUTTON1_MOTION, GDK_BUTTON1_MOTION_MASK },
  { MLTAG_TOUCHPAD_GESTURE, GDK_TOUCHPAD_GESTURE_MASK },
  { MLTAG_SMOOTH_SCROLL, GDK_SMOOTH_SCROLL_MASK },
};

/* gl_error : conversion table */
const lookup_info ml_table_gl_error[] = {
  { 0, 3 },
  { MLTAG_UNSUPPORTED_FORMAT, GDK_GL_ERROR_UNSUPPORTED_FORMAT },
  { MLTAG_NOT_AVAILABLE, GDK_GL_ERROR_NOT_AVAILABLE },
  { MLTAG_UNSUPPORTED_PROFILE, GDK_GL_ERROR_UNSUPPORTED_PROFILE },
};

/* window_type_hint : conversion table */
const lookup_info ml_table_window_type_hint[] = {
  { 0, 14 },
  { MLTAG_POPUP_MENU, GDK_WINDOW_TYPE_HINT_POPUP_MENU },
  { MLTAG_COMBO, GDK_WINDOW_TYPE_HINT_COMBO },
  { MLTAG_DROPDOWN_MENU, GDK_WINDOW_TYPE_HINT_DROPDOWN_MENU },
  { MLTAG_NORMAL, GDK_WINDOW_TYPE_HINT_NORMAL },
  { MLTAG_DIALOG, GDK_WINDOW_TYPE_HINT_DIALOG },
  { MLTAG_TOOLBAR, GDK_WINDOW_TYPE_HINT_TOOLBAR },
  { MLTAG_TOOLTIP, GDK_WINDOW_TYPE_HINT_TOOLTIP },
  { MLTAG_SPLASHSCREEN, GDK_WINDOW_TYPE_HINT_SPLASHSCREEN },
  { MLTAG_NOTIFICATION, GDK_WINDOW_TYPE_HINT_NOTIFICATION },
  { MLTAG_DND, GDK_WINDOW_TYPE_HINT_DND },
  { MLTAG_DESKTOP, GDK_WINDOW_TYPE_HINT_DESKTOP },
  { MLTAG_UTILITY, GDK_WINDOW_TYPE_HINT_UTILITY },
  { MLTAG_DOCK, GDK_WINDOW_TYPE_HINT_DOCK },
  { MLTAG_MENU, GDK_WINDOW_TYPE_HINT_MENU },
};

/* axis_use : conversion table */
const lookup_info ml_table_axis_use[] = {
  { 0, 8 },
  { MLTAG_IGNORE, GDK_AXIS_IGNORE },
  { MLTAG_WHEEL, GDK_AXIS_WHEEL },
  { MLTAG_PRESSURE, GDK_AXIS_PRESSURE },
  { MLTAG_XTILT, GDK_AXIS_XTILT },
  { MLTAG_YTILT, GDK_AXIS_YTILT },
  { MLTAG_X, GDK_AXIS_X },
  { MLTAG_Y, GDK_AXIS_Y },
  { MLTAG_LAST, GDK_AXIS_LAST },
};

/* gdkCursorType : conversion table */
const lookup_info ml_table_gdkCursorType[] = {
  { 0, 77 },
  { MLTAG_BOTTOM_TEE, GDK_BOTTOM_TEE },
  { MLTAG_WATCH, GDK_WATCH },
  { MLTAG_DOUBLE_ARROW, GDK_DOUBLE_ARROW },
  { MLTAG_CLOCK, GDK_CLOCK },
  { MLTAG_LEFTBUTTON, GDK_LEFTBUTTON },
  { MLTAG_UMBRELLA, GDK_UMBRELLA },
  { MLTAG_LEFT_PTR, GDK_LEFT_PTR },
  { MLTAG_LEFT_TEE, GDK_LEFT_TEE },
  { MLTAG_CROSS, GDK_CROSS },
  { MLTAG_SB_DOWN_ARROW, GDK_SB_DOWN_ARROW },
  { MLTAG_GOBBLER, GDK_GOBBLER },
  { MLTAG_CENTER_PTR, GDK_CENTER_PTR },
  { MLTAG_RIGHT_SIDE, GDK_RIGHT_SIDE },
  { MLTAG_BOTTOM_LEFT_CORNER, GDK_BOTTOM_LEFT_CORNER },
  { MLTAG_RIGHT_PTR, GDK_RIGHT_PTR },
  { MLTAG_RIGHT_TEE, GDK_RIGHT_TEE },
  { MLTAG_MIDDLEBUTTON, GDK_MIDDLEBUTTON },
  { MLTAG_BOTTOM_RIGHT_CORNER, GDK_BOTTOM_RIGHT_CORNER },
  { MLTAG_TCROSS, GDK_TCROSS },
  { MLTAG_XTERM, GDK_XTERM },
  { MLTAG_DOTBOX, GDK_DOTBOX },
  { MLTAG_RIGHTBUTTON, GDK_RIGHTBUTTON },
  { MLTAG_LEFT_SIDE, GDK_LEFT_SIDE },
  { MLTAG_LR_ANGLE, GDK_LR_ANGLE },
  { MLTAG_PENCIL, GDK_PENCIL },
  { MLTAG_UR_ANGLE, GDK_UR_ANGLE },
  { MLTAG_SHUTTLE, GDK_SHUTTLE },
  { MLTAG_LL_ANGLE, GDK_LL_ANGLE },
  { MLTAG_SPIDER, GDK_SPIDER },
  { MLTAG_UL_ANGLE, GDK_UL_ANGLE },
  { MLTAG_QUESTION_ARROW, GDK_QUESTION_ARROW },
  { MLTAG_SIZING, GDK_SIZING },
  { MLTAG_SB_RIGHT_ARROW, GDK_SB_RIGHT_ARROW },
  { MLTAG_SPRAYCAN, GDK_SPRAYCAN },
  { MLTAG_IRON_CROSS, GDK_IRON_CROSS },
  { MLTAG_COFFEE_MUG, GDK_COFFEE_MUG },
  { MLTAG_DOT, GDK_DOT },
  { MLTAG_MAN, GDK_MAN },
  { MLTAG_TOP_SIDE, GDK_TOP_SIDE },
  { MLTAG_FLEUR, GDK_FLEUR },
  { MLTAG_SB_H_DOUBLE_ARROW, GDK_SB_H_DOUBLE_ARROW },
  { MLTAG_CROSSHAIR, GDK_CROSSHAIR },
  { MLTAG_CIRCLE, GDK_CIRCLE },
  { MLTAG_X_CURSOR, GDK_X_CURSOR },
  { MLTAG_MOUSE, GDK_MOUSE },
  { MLTAG_TOP_TEE, GDK_TOP_TEE },
  { MLTAG_DRAFT_LARGE, GDK_DRAFT_LARGE },
  { MLTAG_BOTTOM_SIDE, GDK_BOTTOM_SIDE },
  { MLTAG_BASED_ARROW_DOWN, GDK_BASED_ARROW_DOWN },
  { MLTAG_GUMBY, GDK_GUMBY },
  { MLTAG_TOP_LEFT_CORNER, GDK_TOP_LEFT_CORNER },
  { MLTAG_TOP_LEFT_ARROW, GDK_TOP_LEFT_ARROW },
  { MLTAG_EXCHANGE, GDK_EXCHANGE },
  { MLTAG_HAND1, GDK_HAND1 },
  { MLTAG_HAND2, GDK_HAND2 },
  { MLTAG_HEART, GDK_HEART },
  { MLTAG_ARROW, GDK_ARROW },
  { MLTAG_DRAFT_SMALL, GDK_DRAFT_SMALL },
  { MLTAG_CROSS_REVERSE, GDK_CROSS_REVERSE },
  { MLTAG_BASED_ARROW_UP, GDK_BASED_ARROW_UP },
  { MLTAG_DRAPED_BOX, GDK_DRAPED_BOX },
  { MLTAG_SB_V_DOUBLE_ARROW, GDK_SB_V_DOUBLE_ARROW },
  { MLTAG_BOGOSITY, GDK_BOGOSITY },
  { MLTAG_BOAT, GDK_BOAT },
  { MLTAG_DIAMOND_CROSS, GDK_DIAMOND_CROSS },
  { MLTAG_ICON, GDK_ICON },
  { MLTAG_BOX_SPIRAL, GDK_BOX_SPIRAL },
  { MLTAG_PLUS, GDK_PLUS },
  { MLTAG_TOP_RIGHT_CORNER, GDK_TOP_RIGHT_CORNER },
  { MLTAG_STAR, GDK_STAR },
  { MLTAG_TREK, GDK_TREK },
  { MLTAG_SAILBOAT, GDK_SAILBOAT },
  { MLTAG_TARGET, GDK_TARGET },
  { MLTAG_PIRATE, GDK_PIRATE },
  { MLTAG_SB_LEFT_ARROW, GDK_SB_LEFT_ARROW },
  { MLTAG_SB_UP_ARROW, GDK_SB_UP_ARROW },
  { MLTAG_RTL_LOGO, GDK_RTL_LOGO },
};

CAMLprim value ml_gdk_get_tables ()
{
  CAMLparam0 ();
  CAMLlocal1 (ml_lookup_tables);
  ml_lookup_tables = caml_alloc_tuple(37);
  Field(ml_lookup_tables,0) = Val_lookup_info(ml_table_event_type);
  Field(ml_lookup_tables,1) = Val_lookup_info(ml_table_gdkVisibilityState);
  Field(ml_lookup_tables,2) = Val_lookup_info(ml_table_GdkTouchpadGesturePhase);
  Field(ml_lookup_tables,3) = Val_lookup_info(ml_table_gdkScrollDirection);
  Field(ml_lookup_tables,4) = Val_lookup_info(ml_table_gdkCrossingMode);
  Field(ml_lookup_tables,5) = Val_lookup_info(ml_table_gdkNotifyType);
  Field(ml_lookup_tables,6) = Val_lookup_info(ml_table_gdkSettingAction);
  Field(ml_lookup_tables,7) = Val_lookup_info(ml_table_GdkOwnerChange);
  Field(ml_lookup_tables,8) = Val_lookup_info(ml_table_gdkWindowState);
  Field(ml_lookup_tables,9) = Val_lookup_info(ml_table_gdkInputSource);
  Field(ml_lookup_tables,10) = Val_lookup_info(ml_table_gdkInputMode);
  Field(ml_lookup_tables,11) = Val_lookup_info(ml_table_gdkDeviceType);
  Field(ml_lookup_tables,12) = Val_lookup_info(ml_table_gdkVisualType);
  Field(ml_lookup_tables,13) = Val_lookup_info(ml_table_gdkDragAction);
  Field(ml_lookup_tables,14) = Val_lookup_info(ml_table_gdkDragProtocol);
  Field(ml_lookup_tables,15) = Val_lookup_info(ml_table_xdata);
  Field(ml_lookup_tables,16) = Val_lookup_info(ml_table_property_state);
  Field(ml_lookup_tables,17) = Val_lookup_info(ml_table_property_mode);
  Field(ml_lookup_tables,18) = Val_lookup_info(ml_table_GdkWindowWindowClass);
  Field(ml_lookup_tables,19) = Val_lookup_info(ml_table_GdkWindowType);
  Field(ml_lookup_tables,20) = Val_lookup_info(ml_table_window_attributes_type);
  Field(ml_lookup_tables,21) = Val_lookup_info(ml_table_window_hints);
  Field(ml_lookup_tables,22) = Val_lookup_info(ml_table_GdkWMdecoration);
  Field(ml_lookup_tables,23) = Val_lookup_info(ml_table_GdkWMFunction);
  Field(ml_lookup_tables,24) = Val_lookup_info(ml_table_gravity);
  Field(ml_lookup_tables,25) = Val_lookup_info(ml_table_window_edge);
  Field(ml_lookup_tables,26) = Val_lookup_info(ml_table_fullscreen_mode);
  Field(ml_lookup_tables,27) = Val_lookup_info(ml_table_gdkModifier);
  Field(ml_lookup_tables,28) = Val_lookup_info(ml_table_gtkModifierIntent);
  Field(ml_lookup_tables,29) = Val_lookup_info(ml_table_status);
  Field(ml_lookup_tables,30) = Val_lookup_info(ml_table_grab_status);
  Field(ml_lookup_tables,31) = Val_lookup_info(ml_table_grab_ownership);
  Field(ml_lookup_tables,32) = Val_lookup_info(ml_table_event_mask);
  Field(ml_lookup_tables,33) = Val_lookup_info(ml_table_gl_error);
  Field(ml_lookup_tables,34) = Val_lookup_info(ml_table_window_type_hint);
  Field(ml_lookup_tables,35) = Val_lookup_info(ml_table_axis_use);
  Field(ml_lookup_tables,36) = Val_lookup_info(ml_table_gdkCursorType);
  CAMLreturn (ml_lookup_tables);
}
