// This file was generated by qtwaylandscanner
// source file is org-kde-plasma-virtual-desktop.xml

#include "qwayland-server-org-kde-plasma-virtual-desktop.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int org_kde_plasma_virtual_desktop_management::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_virtual_desktop_management *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_virtual_desktop_management_destroy_global();
        return 0;
    }

    org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_virtual_desktop_management::~org_kde_plasma_virtual_desktop_management()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->org_kde_plasma_virtual_desktop_management_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_virtual_desktop_management_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_virtual_desktop_management::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_virtual_desktop_management::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_virtual_desktop_management::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_virtual_desktop_management_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_virtual_desktop_management::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_virtual_desktop_management::interface()
    {
        return &::org_kde_plasma_virtual_desktop_management_interface;
    }

    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_destroy_global()
    {
    }

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_virtual_desktop_management::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_virtual_desktop_management *that = static_cast<org_kde_plasma_virtual_desktop_management *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_virtual_desktop_management::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_virtual_desktop_management *that = static_cast<org_kde_plasma_virtual_desktop_management::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_virtual_desktop_management::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_virtual_desktop_management *that = resource->org_kde_plasma_virtual_desktop_management_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_virtual_desktop_management_destroy_resource(resource);

            that = resource->org_kde_plasma_virtual_desktop_management_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_virtual_desktop_management::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_virtual_desktop_management_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_virtual_desktop_management_allocate();
        resource->org_kde_plasma_virtual_desktop_management_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_virtual_desktop_management_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_virtual_desktop_management_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_virtual_desktop_management::Resource *org_kde_plasma_virtual_desktop_management::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_virtual_desktop_management_interface, &m_org_kde_plasma_virtual_desktop_management_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_virtual_desktop_management_interface org_kde_plasma_virtual_desktop_management::m_org_kde_plasma_virtual_desktop_management_interface = {
        org_kde_plasma_virtual_desktop_management::handle_get_virtual_desktop,
        org_kde_plasma_virtual_desktop_management::handle_request_create_virtual_desktop,
        org_kde_plasma_virtual_desktop_management::handle_request_remove_virtual_desktop
    };

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_get_virtual_desktop(Resource *, uint32_t, const QString &)
    {
    }

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_request_create_virtual_desktop(Resource *, const QString &, uint32_t )
    {
    }

    void org_kde_plasma_virtual_desktop_management::org_kde_plasma_virtual_desktop_management_request_remove_virtual_desktop(Resource *, const QString &)
    {
    }


    void org_kde_plasma_virtual_desktop_management::handle_get_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        const char *desktop_id)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->org_kde_plasma_virtual_desktop_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_virtual_desktop_management *>(qtResource->org_kde_plasma_virtual_desktop_management_object)->org_kde_plasma_virtual_desktop_management_get_virtual_desktop(
            qtResource,
            id,
            QString::fromUtf8(desktop_id));
    }

    void org_kde_plasma_virtual_desktop_management::handle_request_create_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *name,
        uint32_t position)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->org_kde_plasma_virtual_desktop_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_virtual_desktop_management *>(qtResource->org_kde_plasma_virtual_desktop_management_object)->org_kde_plasma_virtual_desktop_management_request_create_virtual_desktop(
            qtResource,
            QString::fromUtf8(name),
            position);
    }

    void org_kde_plasma_virtual_desktop_management::handle_request_remove_virtual_desktop(
        ::wl_client *client,
        struct wl_resource *resource,
        const char *desktop_id)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->org_kde_plasma_virtual_desktop_management_object)) {
            return;
        }
        static_cast<org_kde_plasma_virtual_desktop_management *>(qtResource->org_kde_plasma_virtual_desktop_management_object)->org_kde_plasma_virtual_desktop_management_request_remove_virtual_desktop(
            qtResource,
            QString::fromUtf8(desktop_id));
    }

    void org_kde_plasma_virtual_desktop_management::send_desktop_created(const QString &desktop_id, uint32_t position)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop_management::desktop_created", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop_management::desktop_created as it's not initialised");
            return;
        }
        send_desktop_created(
            m_resource->handle,
            desktop_id,
            position);
    }

    void org_kde_plasma_virtual_desktop_management::send_desktop_created(struct ::wl_resource *resource, const QString &desktop_id, uint32_t position)
    {
        org_kde_plasma_virtual_desktop_management_send_desktop_created(
            resource,
            desktop_id.toUtf8().constData(),
            position);
    }


    void org_kde_plasma_virtual_desktop_management::send_desktop_removed(const QString &desktop_id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop_management::desktop_removed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop_management::desktop_removed as it's not initialised");
            return;
        }
        send_desktop_removed(
            m_resource->handle,
            desktop_id);
    }

    void org_kde_plasma_virtual_desktop_management::send_desktop_removed(struct ::wl_resource *resource, const QString &desktop_id)
    {
        org_kde_plasma_virtual_desktop_management_send_desktop_removed(
            resource,
            desktop_id.toUtf8().constData());
    }


    void org_kde_plasma_virtual_desktop_management::send_done()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop_management::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop_management::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void org_kde_plasma_virtual_desktop_management::send_done(struct ::wl_resource *resource)
    {
        org_kde_plasma_virtual_desktop_management_send_done(
            resource);
    }


    void org_kde_plasma_virtual_desktop_management::send_rows(uint32_t rows)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop_management::rows", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop_management::rows as it's not initialised");
            return;
        }
        send_rows(
            m_resource->handle,
            rows);
    }

    void org_kde_plasma_virtual_desktop_management::send_rows(struct ::wl_resource *resource, uint32_t rows)
    {
        org_kde_plasma_virtual_desktop_management_send_rows(
            resource,
            rows);
    }



    int org_kde_plasma_virtual_desktop::deferred_destroy_global_func(void *data) {
        auto object = static_cast<org_kde_plasma_virtual_desktop *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->org_kde_plasma_virtual_desktop_destroy_global();
        return 0;
    }

    org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    org_kde_plasma_virtual_desktop::~org_kde_plasma_virtual_desktop()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->org_kde_plasma_virtual_desktop_object = nullptr;

        if (m_resource)
            m_resource->org_kde_plasma_virtual_desktop_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void org_kde_plasma_virtual_desktop::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void org_kde_plasma_virtual_desktop::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void org_kde_plasma_virtual_desktop::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::org_kde_plasma_virtual_desktop_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = org_kde_plasma_virtual_desktop::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *org_kde_plasma_virtual_desktop::interface()
    {
        return &::org_kde_plasma_virtual_desktop_interface;
    }

    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop_allocate()
    {
        return new Resource;
    }

    void org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop_destroy_global()
    {
    }

    void org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop_bind_resource(Resource *)
    {
    }

    void org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop_destroy_resource(Resource *)
    {
    }

    void org_kde_plasma_virtual_desktop::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        org_kde_plasma_virtual_desktop *that = static_cast<org_kde_plasma_virtual_desktop *>(data);
        that->add(client, id, version);
    }

    void org_kde_plasma_virtual_desktop::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        org_kde_plasma_virtual_desktop *that = static_cast<org_kde_plasma_virtual_desktop::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void org_kde_plasma_virtual_desktop::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        org_kde_plasma_virtual_desktop *that = resource->org_kde_plasma_virtual_desktop_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->org_kde_plasma_virtual_desktop_destroy_resource(resource);

            that = resource->org_kde_plasma_virtual_desktop_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void org_kde_plasma_virtual_desktop::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 5000);
    }

    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::org_kde_plasma_virtual_desktop_interface, version, id);
        return bind(handle);
    }

    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::bind(struct ::wl_resource *handle)
    {
        Resource *resource = org_kde_plasma_virtual_desktop_allocate();
        resource->org_kde_plasma_virtual_desktop_object = this;

        wl_resource_set_implementation(handle, &m_org_kde_plasma_virtual_desktop_interface, resource, destroy_func);
        resource->handle = handle;
        org_kde_plasma_virtual_desktop_bind_resource(resource);
        return resource;
    }
    org_kde_plasma_virtual_desktop::Resource *org_kde_plasma_virtual_desktop::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::org_kde_plasma_virtual_desktop_interface, &m_org_kde_plasma_virtual_desktop_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::org_kde_plasma_virtual_desktop_interface org_kde_plasma_virtual_desktop::m_org_kde_plasma_virtual_desktop_interface = {
        org_kde_plasma_virtual_desktop::handle_request_activate
    };

    void org_kde_plasma_virtual_desktop::org_kde_plasma_virtual_desktop_request_activate(Resource *)
    {
    }


    void org_kde_plasma_virtual_desktop::handle_request_activate(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *qtResource = Resource::fromResource(resource);
        if (Q_UNLIKELY(!qtResource->org_kde_plasma_virtual_desktop_object)) {
            return;
        }
        static_cast<org_kde_plasma_virtual_desktop *>(qtResource->org_kde_plasma_virtual_desktop_object)->org_kde_plasma_virtual_desktop_request_activate(
            qtResource);
    }

    void org_kde_plasma_virtual_desktop::send_desktop_id(const QString &desktop_id)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::desktop_id", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::desktop_id as it's not initialised");
            return;
        }
        send_desktop_id(
            m_resource->handle,
            desktop_id);
    }

    void org_kde_plasma_virtual_desktop::send_desktop_id(struct ::wl_resource *resource, const QString &desktop_id)
    {
        org_kde_plasma_virtual_desktop_send_desktop_id(
            resource,
            desktop_id.toUtf8().constData());
    }


    void org_kde_plasma_virtual_desktop::send_name(const QString &name)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::name", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::name as it's not initialised");
            return;
        }
        send_name(
            m_resource->handle,
            name);
    }

    void org_kde_plasma_virtual_desktop::send_name(struct ::wl_resource *resource, const QString &name)
    {
        org_kde_plasma_virtual_desktop_send_name(
            resource,
            name.toUtf8().constData());
    }


    void org_kde_plasma_virtual_desktop::send_activated()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::activated", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::activated as it's not initialised");
            return;
        }
        send_activated(
            m_resource->handle);
    }

    void org_kde_plasma_virtual_desktop::send_activated(struct ::wl_resource *resource)
    {
        org_kde_plasma_virtual_desktop_send_activated(
            resource);
    }


    void org_kde_plasma_virtual_desktop::send_deactivated()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::deactivated", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::deactivated as it's not initialised");
            return;
        }
        send_deactivated(
            m_resource->handle);
    }

    void org_kde_plasma_virtual_desktop::send_deactivated(struct ::wl_resource *resource)
    {
        org_kde_plasma_virtual_desktop_send_deactivated(
            resource);
    }


    void org_kde_plasma_virtual_desktop::send_done()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::done", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::done as it's not initialised");
            return;
        }
        send_done(
            m_resource->handle);
    }

    void org_kde_plasma_virtual_desktop::send_done(struct ::wl_resource *resource)
    {
        org_kde_plasma_virtual_desktop_send_done(
            resource);
    }


    void org_kde_plasma_virtual_desktop::send_removed()
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::removed", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::removed as it's not initialised");
            return;
        }
        send_removed(
            m_resource->handle);
    }

    void org_kde_plasma_virtual_desktop::send_removed(struct ::wl_resource *resource)
    {
        org_kde_plasma_virtual_desktop_send_removed(
            resource);
    }


    void org_kde_plasma_virtual_desktop::send_position(uint32_t index)
    {
        Q_ASSERT_X(m_resource, "org_kde_plasma_virtual_desktop::position", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call org_kde_plasma_virtual_desktop::position as it's not initialised");
            return;
        }
        send_position(
            m_resource->handle,
            index);
    }

    void org_kde_plasma_virtual_desktop::send_position(struct ::wl_resource *resource, uint32_t index)
    {
        org_kde_plasma_virtual_desktop_send_position(
            resource,
            index);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
