
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kfuzzymatcher_wrapper.h"

// inner classes
#include "kfuzzymatcher_range_wrapper.h"
#include "kfuzzymatcher_result_wrapper.h"

// Argument includes
#include <QList>
#include <QStringView>
#include <kfuzzymatcher.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFuzzyMatcher_Type = nullptr;
static PyTypeObject *Sbk_KFuzzyMatcher_TypeF(void)
{
    return _Sbk_KFuzzyMatcher_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KFuzzyMatcher_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KFuzzyMatcher");
    return -1;
}

static PyObject *Sbk_KFuzzyMatcherFunc_match(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "match", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFuzzyMatcher::match(QStringView,QStringView)->KFuzzyMatcher::Result
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // match(QStringView,QStringView)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "match", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // match(QStringView,QStringView)
            KFuzzyMatcher::Result cppResult = ::KFuzzyMatcher::match(QStringView(cppArg0), QStringView(cppArg1));
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_Result_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFuzzyMatcherFunc_matchSimple(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "matchSimple", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFuzzyMatcher::matchSimple(QStringView,QStringView)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // matchSimple(QStringView,QStringView)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "matchSimple", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // matchSimple(QStringView,QStringView)
            bool cppResult = ::KFuzzyMatcher::matchSimple(QStringView(cppArg0), QStringView(cppArg1));
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFuzzyMatcherFunc_matchedRanges(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "matchedRanges", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:matchedRanges", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFuzzyMatcher::matchedRanges(QStringView,QStringView,KFuzzyMatcher::RangeType=)->QList<KFuzzyMatcher::Range>
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // matchedRanges(QStringView,QStringView,KFuzzyMatcher::RangeType)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_RangeType_IDX])))->converter, (pyArgs[2])))) {
            overloadId = 0; // matchedRanges(QStringView,QStringView,KFuzzyMatcher::RangeType)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "matchedRanges", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"type", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_RangeType_IDX])))->converter, (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "matchedRanges", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::KFuzzyMatcher::RangeType cppArg2(KFuzzyMatcher::RangeType::FullyMatched);
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // matchedRanges(QStringView,QStringView,KFuzzyMatcher::RangeType)
            QList<KFuzzyMatcher::Range> cppResult = ::KFuzzyMatcher::matchedRanges(QStringView(cppArg0), QStringView(cppArg1), cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KFuzzyMatcher_Range_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KFuzzyMatcher_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KFuzzyMatcher_EnumFlagInfo[] = {
    "RangeType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFuzzyMatcher_methods[] = {
    {"match", reinterpret_cast<PyCFunction>(Sbk_KFuzzyMatcherFunc_match), METH_VARARGS|METH_STATIC, nullptr},
    {"matchSimple", reinterpret_cast<PyCFunction>(Sbk_KFuzzyMatcherFunc_matchSimple), METH_VARARGS|METH_STATIC, nullptr},
    {"matchedRanges", reinterpret_cast<PyCFunction>(Sbk_KFuzzyMatcherFunc_matchedRanges), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFuzzyMatcher_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFuzzyMatcher_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFuzzyMatcher_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFuzzyMatcher_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFuzzyMatcher_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFuzzyMatcher_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFuzzyMatcher_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFuzzyMatcher_spec = {
    "1:KCoreAddons.KFuzzyMatcher",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFuzzyMatcher_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KFuzzyMatcher_RangeType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFuzzyMatcher::RangeType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFuzzyMatcher::RangeType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFuzzyMatcher_RangeType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_RangeType_IDX])))
        return Enum_PythonToCpp_KFuzzyMatcher_RangeType;
    return {};
}

static PyObject *KFuzzyMatcher_RangeType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFuzzyMatcher::RangeType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFuzzyMatcher::RangeType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKFuzzyMatcher_SignatureStrings[] = {
    "KCoreAddons.KFuzzyMatcher.match(pattern:QString,str:QString)->KCoreAddons.KFuzzyMatcher.Result",
    "KCoreAddons.KFuzzyMatcher.matchSimple(pattern:QString,str:QString)->bool",
    "KCoreAddons.KFuzzyMatcher.matchedRanges(pattern:QString,str:QString,type:KCoreAddons.KFuzzyMatcher.RangeType=KFuzzyMatcher.RangeType.FullyMatched)->QList[KCoreAddons.KFuzzyMatcher.Range]",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKFuzzyMatcher_SignatureByteSize = 137;
static constexpr uint8_t KCoreAddonsKFuzzyMatcher_SignatureBytes[137] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76,
    0x2b, 0xad, 0xaa, 0xaa, 0xf4, 0x4d, 0x2c, 0x49, 0xce, 0x48, 0x2d, 0xd2, 0xcb, 0x05, 0xd1, 0x1a,
    0x05, 0x89, 0x25, 0x25, 0xa9, 0x45, 0x79, 0x56, 0x81, 0xc1, 0x25, 0x45, 0x99, 0x79, 0xe9, 0x3a,
    0xc5, 0x25, 0x45, 0x30, 0xb6, 0xa6, 0xae, 0x9d, 0x37, 0x4e, 0xdd, 0x41, 0xa9, 0xc5, 0xa5, 0x39,
    0x25, 0x5c, 0xde, 0xf8, 0x8d, 0x0f, 0xce, 0xcc, 0x2d, 0xc8, 0x49, 0x25, 0x60, 0x49, 0x52, 0x7e,
    0x7e, 0x0e, 0x21, 0x83, 0x52, 0x53, 0x82, 0x12, 0xf3, 0xd2, 0x53, 0x8b, 0xf1, 0x19, 0xa5, 0x53,
    0x52, 0x59, 0x90, 0x6a, 0x85, 0xc7, 0xc9, 0x20, 0x13, 0x42, 0x80, 0x6a, 0x6c, 0x71, 0x88, 0xeb,
    0xb9, 0x95, 0xe6, 0xe4, 0x40, 0x85, 0x53, 0x80, 0x0e, 0x0b, 0xf4, 0xc9, 0x2c, 0x2e, 0x89, 0x26,
    0x60, 0x60, 0x2c, 0x17, 0x00, 0x73, 0xac, 0x84, 0xb7
};
#endif

PyTypeObject *init_KCoreAddonsKFuzzyMatcher(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX].type;

    Shiboken::AutoDecRef Sbk_KFuzzyMatcher_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFuzzyMatcher_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFuzzyMatcher",
        "KFuzzyMatcher",
        &Sbk_KFuzzyMatcher_spec,
        nullptr,
        Sbk_KFuzzyMatcher_Type_bases.object(),
        0);
    auto *pyType = Sbk_KFuzzyMatcher_TypeF(); // references _Sbk_KFuzzyMatcher_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKFuzzyMatcher_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKFuzzyMatcher_SignatureBytes, KCoreAddonsKFuzzyMatcher_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFuzzyMatcher_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFuzzyMatcher_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KFuzzyMatcher_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'RangeType'.
    const char *RangeType_Initializer[] = {
        "FullyMatched",
        "All",
        nullptr};
    // "uint8_t" used instead of "unsigned char"
    constexpr uint8_t RangeType_InitializerValues[] = {
        uint8_t(KFuzzyMatcher::RangeType::FullyMatched), //  0x00  0
        uint8_t(KFuzzyMatcher::RangeType::All)           //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFuzzyMatcher_TypeF(),
        "1:KCoreAddons.KFuzzyMatcher.RangeType",
        RangeType_Initializer, RangeType_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFuzzyMatcher_RangeType_IDX].type = EType;
    // Register converter for enum 'KFuzzyMatcher::RangeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFuzzyMatcher_RangeType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFuzzyMatcher_RangeType,
            is_Enum_PythonToCpp_KFuzzyMatcher_RangeType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFuzzyMatcher::RangeType");
        Shiboken::Conversions::registerConverterAlias(converter, "RangeType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'RangeType' enum.

    qRegisterMetaType< ::KFuzzyMatcher::RangeType >("KFuzzyMatcher::RangeType");

    return pyType;
}
