
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kfilesystemtype_wrapper.h"

// Argument includes
#include <QString>
#include <kfilesystemtype.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFileSystemType_Type = nullptr;
static PyTypeObject *Sbk_KFileSystemType_TypeF(void)
{
    return _Sbk_KFileSystemType_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KFileSystemType_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KFileSystemType");
    return -1;
}

static PyObject *Sbk_KFileSystemTypeFunc_fileSystemName(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KFileSystemType::fileSystemName(KFileSystemType::Type)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFileSystemType_Type_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // fileSystemName(KFileSystemType::Type)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fileSystemName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileSystemType_IDX]);

    // Call function/method
    {
        ::KFileSystemType::Type cppArg0{KFileSystemType::Unknown};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fileSystemName(KFileSystemType::Type)
            QString cppResult = ::KFileSystemType::fileSystemName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFileSystemTypeFunc_fileSystemType(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KFileSystemType::fileSystemType(QString)->KFileSystemType::Type
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fileSystemType(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fileSystemType", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileSystemType_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fileSystemType(QString)
            KFileSystemType::Type cppResult = ::KFileSystemType::fileSystemType(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFileSystemType_Type_IDX])))->converter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KFileSystemType_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KFileSystemType_EnumFlagInfo[] = {
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFileSystemType_methods[] = {
    {"fileSystemName", reinterpret_cast<PyCFunction>(Sbk_KFileSystemTypeFunc_fileSystemName), METH_O|METH_STATIC, nullptr},
    {"fileSystemType", reinterpret_cast<PyCFunction>(Sbk_KFileSystemTypeFunc_fileSystemType), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFileSystemType_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFileSystemType_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFileSystemType_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFileSystemType_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFileSystemType_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFileSystemType_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFileSystemType_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFileSystemType_spec = {
    "1:KCoreAddons.KFileSystemType",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFileSystemType_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KFileSystemType_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFileSystemType::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFileSystemType::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFileSystemType_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KFileSystemType_Type_IDX])))
        return Enum_PythonToCpp_KFileSystemType_Type;
    return {};
}

static PyObject *KFileSystemType_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFileSystemType::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFileSystemType::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKFileSystemType_SignatureStrings[] = {
    "KCoreAddons.KFileSystemType.fileSystemName(type:KCoreAddons.KFileSystemType.Type)->QString",
    "KCoreAddons.KFileSystemType.fileSystemType(path:QString)->KCoreAddons.KFileSystemType.Type",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKFileSystemType_SignatureByteSize = 82;
static constexpr uint8_t KCoreAddonsKFileSystemType_SignatureBytes[82] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76,
    0xcb, 0xcc, 0x49, 0x0d, 0xae, 0x2c, 0x2e, 0x49, 0xcd, 0x0d, 0xa9, 0x2c, 0x48, 0xd5, 0x4b, 0x83,
    0x73, 0xfd, 0x12, 0x73, 0x53, 0x35, 0x4a, 0x80, 0x62, 0x56, 0xde, 0x78, 0xd4, 0x83, 0x08, 0x4d,
    0x5d, 0xbb, 0xc0, 0xe0, 0x92, 0xa2, 0xcc, 0xbc, 0x74, 0x2e, 0x6f, 0xa2, 0x8c, 0x06, 0x71, 0x35,
    0x0a, 0x12, 0x4b, 0x32, 0xac, 0xa0, 0xfa, 0x80, 0x26, 0x10, 0xb2, 0x84, 0x0b, 0x00, 0x4f, 0x36,
    0x43, 0x9d
};
#endif

PyTypeObject *init_KCoreAddonsKFileSystemType(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileSystemType_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileSystemType_IDX].type;

    Shiboken::AutoDecRef Sbk_KFileSystemType_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFileSystemType_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFileSystemType",
        "KFileSystemType",
        &Sbk_KFileSystemType_spec,
        nullptr,
        Sbk_KFileSystemType_Type_bases.object(),
        0);
    auto *pyType = Sbk_KFileSystemType_TypeF(); // references _Sbk_KFileSystemType_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKFileSystemType_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKFileSystemType_SignatureBytes, KCoreAddonsKFileSystemType_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFileSystemType_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKFileSystemType_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KFileSystemType_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "Unknown",
        "Nfs",
        "Smb",
        "Fat",
        "Ramfs",
        "Other",
        "Ntfs",
        "Exfat",
        "Fuse",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(KFileSystemType::Type::Unknown), //  0x00  0
        uint8_t(KFileSystemType::Type::Nfs),     //  0x01  1
        uint8_t(KFileSystemType::Type::Smb),     //  0x02  2
        uint8_t(KFileSystemType::Type::Fat),     //  0x03  3
        uint8_t(KFileSystemType::Type::Ramfs),   //  0x04  4
        uint8_t(KFileSystemType::Type::Other),   //  0x05  5
        uint8_t(KFileSystemType::Type::Ntfs),    //  0x06  6
        uint8_t(KFileSystemType::Type::Exfat),   //  0x07  7
        uint8_t(KFileSystemType::Type::Fuse)     //  0x08  8
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFileSystemType_TypeF(),
        "1:KCoreAddons.KFileSystemType.Type",
        Type_Initializer, Type_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KFileSystemType_Type_IDX].type = EType;
    // Register converter for enum 'KFileSystemType::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFileSystemType_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFileSystemType_Type,
            is_Enum_PythonToCpp_KFileSystemType_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFileSystemType::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::KFileSystemType::Type >("KFileSystemType::Type");

    return pyType;
}
