
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kbackup_wrapper.h"

// Argument includes
#include <QString>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KBackup_Type = nullptr;
static PyTypeObject *Sbk_KBackup_TypeF(void)
{
    return _Sbk_KBackup_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KBackup_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KBackup");
    return -1;
}

static PyObject *Sbk_KBackupFunc_numberedBackupFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "numberedBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:numberedBackupFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KBackup::numberedBackupFile(QString,const QString&=,const QString&=,uint=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // numberedBackupFile(QString,QString,QString,uint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // numberedBackupFile(QString,QString,QString,uint)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // numberedBackupFile(QString,QString,QString,uint)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[3])))) {
                    overloadId = 0; // numberedBackupFile(QString,QString,QString,uint)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "numberedBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"backupDir", 1}, {"backupExtension", 2}, {"maxBackups", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "numberedBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QStringLiteral("~");
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        uint cppArg3 = 10;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // numberedBackupFile(QString,QString,QString,uint)
            bool cppResult = ::KBackup::numberedBackupFile(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KBackupFunc_simpleBackupFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "simpleBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:simpleBackupFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KBackup::simpleBackupFile(QString,const QString&=,const QString&=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // simpleBackupFile(QString,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // simpleBackupFile(QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                overloadId = 0; // simpleBackupFile(QString,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "simpleBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"backupDir", 1}, {"backupExtension", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "simpleBackupFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QStringLiteral("~");
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // simpleBackupFile(QString,QString,QString)
            bool cppResult = ::KBackup::simpleBackupFile(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KBackup_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KBackup_methods[] = {
    {"numberedBackupFile", reinterpret_cast<PyCFunction>(Sbk_KBackupFunc_numberedBackupFile), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"simpleBackupFile", reinterpret_cast<PyCFunction>(Sbk_KBackupFunc_simpleBackupFile), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KBackup_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KBackup_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KBackup_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KBackup_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KBackup_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KBackup_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KBackup_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KBackup_spec = {
    "1:KCoreAddons.KBackup",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KBackup_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKBackup_SignatureStrings[] = {
    R"CPP(KCoreAddons.KBackup.numberedBackupFile(filename:QString,backupDir:QString=QString(),backupExtension:QString=QStringLiteral("~"),maxBackups:uint=10)->bool)CPP",
    R"CPP(KCoreAddons.KBackup.simpleBackupFile(filename:QString,backupDir:QString=QString(),backupExtension:QString=QStringLiteral("~"))->bool)CPP",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKBackup_SignatureByteSize = 133;
static constexpr uint8_t KCoreAddonsKBackup_SignatureBytes[133] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76,
    0x4a, 0x4c, 0xce, 0x2e, 0x2d, 0xd0, 0xcb, 0x2b, 0xcd, 0x4d, 0x4a, 0x2d, 0x4a, 0x4d, 0x81, 0x70,
    0xdd, 0x32, 0x73, 0x52, 0x35, 0xd2, 0x80, 0x44, 0x5e, 0x62, 0x6e, 0xaa, 0x55, 0x60, 0x70, 0x49,
    0x51, 0x66, 0x5e, 0xba, 0x4e, 0x12, 0x58, 0xce, 0x25, 0xb3, 0x08, 0x26, 0x62, 0x0b, 0xa5, 0x35,
    0x34, 0xa1, 0x72, 0xae, 0x15, 0x25, 0xa9, 0x79, 0xc5, 0x99, 0xf9, 0x79, 0xe8, 0x2a, 0x7c, 0x32,
    0x4b, 0x52, 0x8b, 0x12, 0x73, 0x34, 0x94, 0xea, 0x94, 0x34, 0x75, 0x72, 0x13, 0x2b, 0x20, 0xd6,
    0x14, 0x5b, 0x95, 0x66, 0xe6, 0x95, 0xd8, 0x1a, 0x1a, 0x68, 0xea, 0xda, 0x25, 0xe5, 0xe7, 0xe7,
    0x70, 0x79, 0x63, 0x71, 0x59, 0x71, 0x66, 0x6e, 0x41, 0x4e, 0x2a, 0x1d, 0xdc, 0x05, 0x73, 0x04,
    0x00, 0x8f, 0xc4, 0x68, 0xd8
};
#endif

PyTypeObject *init_KCoreAddonsKBackup(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX].type;

    Shiboken::AutoDecRef Sbk_KBackup_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KBackup_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KBackup",
        "KBackup",
        &Sbk_KBackup_spec,
        nullptr,
        Sbk_KBackup_Type_bases.object(),
        0);
    auto *pyType = Sbk_KBackup_TypeF(); // references _Sbk_KBackup_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKBackup_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKBackup_SignatureBytes, KCoreAddonsKBackup_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KBackup_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKBackup_IDX].type = pyType;



    return pyType;
}
