/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	types "k8s.io/apimachinery/pkg/types"
)

// PodCertificateRequestSpecApplyConfiguration represents a declarative configuration of the PodCertificateRequestSpec type for use
// with apply.
type PodCertificateRequestSpecApplyConfiguration struct {
	SignerName           *string         `json:"signerName,omitempty"`
	PodName              *string         `json:"podName,omitempty"`
	PodUID               *types.UID      `json:"podUID,omitempty"`
	ServiceAccountName   *string         `json:"serviceAccountName,omitempty"`
	ServiceAccountUID    *types.UID      `json:"serviceAccountUID,omitempty"`
	NodeName             *types.NodeName `json:"nodeName,omitempty"`
	NodeUID              *types.UID      `json:"nodeUID,omitempty"`
	MaxExpirationSeconds *int32          `json:"maxExpirationSeconds,omitempty"`
	PKIXPublicKey        []byte          `json:"pkixPublicKey,omitempty"`
	ProofOfPossession    []byte          `json:"proofOfPossession,omitempty"`
}

// PodCertificateRequestSpecApplyConfiguration constructs a declarative configuration of the PodCertificateRequestSpec type for use with
// apply.
func PodCertificateRequestSpec() *PodCertificateRequestSpecApplyConfiguration {
	return &PodCertificateRequestSpecApplyConfiguration{}
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithSignerName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithPodName sets the PodName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPodName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.PodName = &value
	return b
}

// WithPodUID sets the PodUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPodUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.PodUID = &value
	return b
}

// WithServiceAccountName sets the ServiceAccountName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithServiceAccountName(value string) *PodCertificateRequestSpecApplyConfiguration {
	b.ServiceAccountName = &value
	return b
}

// WithServiceAccountUID sets the ServiceAccountUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ServiceAccountUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithServiceAccountUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.ServiceAccountUID = &value
	return b
}

// WithNodeName sets the NodeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeName field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithNodeName(value types.NodeName) *PodCertificateRequestSpecApplyConfiguration {
	b.NodeName = &value
	return b
}

// WithNodeUID sets the NodeUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NodeUID field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithNodeUID(value types.UID) *PodCertificateRequestSpecApplyConfiguration {
	b.NodeUID = &value
	return b
}

// WithMaxExpirationSeconds sets the MaxExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxExpirationSeconds field is set to the value of the last call.
func (b *PodCertificateRequestSpecApplyConfiguration) WithMaxExpirationSeconds(value int32) *PodCertificateRequestSpecApplyConfiguration {
	b.MaxExpirationSeconds = &value
	return b
}

// WithPKIXPublicKey adds the given value to the PKIXPublicKey field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PKIXPublicKey field.
func (b *PodCertificateRequestSpecApplyConfiguration) WithPKIXPublicKey(values ...byte) *PodCertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.PKIXPublicKey = append(b.PKIXPublicKey, values[i])
	}
	return b
}

// WithProofOfPossession adds the given value to the ProofOfPossession field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ProofOfPossession field.
func (b *PodCertificateRequestSpecApplyConfiguration) WithProofOfPossession(values ...byte) *PodCertificateRequestSpecApplyConfiguration {
	for i := range values {
		b.ProofOfPossession = append(b.ProofOfPossession, values[i])
	}
	return b
}
