/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha3

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisv1alpha3 "sigs.k8s.io/gateway-api/apis/v1alpha3"
	applyconfigurationapisv1alpha3 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1alpha3"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// BackendTLSPoliciesGetter has a method to return a BackendTLSPolicyInterface.
// A group's client should implement this interface.
type BackendTLSPoliciesGetter interface {
	BackendTLSPolicies(namespace string) BackendTLSPolicyInterface
}

// BackendTLSPolicyInterface has methods to work with BackendTLSPolicy resources.
type BackendTLSPolicyInterface interface {
	Create(ctx context.Context, backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, opts v1.CreateOptions) (*apisv1alpha3.BackendTLSPolicy, error)
	Update(ctx context.Context, backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, opts v1.UpdateOptions) (*apisv1alpha3.BackendTLSPolicy, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, backendTLSPolicy *apisv1alpha3.BackendTLSPolicy, opts v1.UpdateOptions) (*apisv1alpha3.BackendTLSPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisv1alpha3.BackendTLSPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisv1alpha3.BackendTLSPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisv1alpha3.BackendTLSPolicy, err error)
	Apply(ctx context.Context, backendTLSPolicy *applyconfigurationapisv1alpha3.BackendTLSPolicyApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha3.BackendTLSPolicy, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, backendTLSPolicy *applyconfigurationapisv1alpha3.BackendTLSPolicyApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha3.BackendTLSPolicy, err error)
	BackendTLSPolicyExpansion
}

// backendTLSPolicies implements BackendTLSPolicyInterface
type backendTLSPolicies struct {
	*gentype.ClientWithListAndApply[*apisv1alpha3.BackendTLSPolicy, *apisv1alpha3.BackendTLSPolicyList, *applyconfigurationapisv1alpha3.BackendTLSPolicyApplyConfiguration]
}

// newBackendTLSPolicies returns a BackendTLSPolicies
func newBackendTLSPolicies(c *GatewayV1alpha3Client, namespace string) *backendTLSPolicies {
	return &backendTLSPolicies{
		gentype.NewClientWithListAndApply[*apisv1alpha3.BackendTLSPolicy, *apisv1alpha3.BackendTLSPolicyList, *applyconfigurationapisv1alpha3.BackendTLSPolicyApplyConfiguration](
			"backendtlspolicies",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apisv1alpha3.BackendTLSPolicy { return &apisv1alpha3.BackendTLSPolicy{} },
			func() *apisv1alpha3.BackendTLSPolicyList { return &apisv1alpha3.BackendTLSPolicyList{} },
		),
	}
}
