/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_tglgt1.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_tglgt1.h"

static bool tglgt1_render_basic_Sampler00Bottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_render_basic_Sampler00Busy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_render_basic_SamplerBottleneck_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_render_basic_SamplersBusy_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "c17af13d-3953-432b-9bd1-81346b4c2092";
    metric_set->counters = calloc(34, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_basic__gti_read_throughput__read,
                .max_uint64 = tglgt1__render_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_basic__gti_write_throughput__read,
                .max_uint64 = tglgt1__render_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_basic__l3_shader_throughput__read,
                .max_uint64 = tglgt1__render_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Slice0 Dualsubslice0 is bottleneck",
                .symbol_name = "Sampler00Bottleneck",
                .desc = "The percentage of time when sampler slice0 dualsubslice0 is bottleneck",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__sampler00_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = tglgt1_render_basic_Sampler00Bottleneck_availability,
            },

            {
                .name = "Sampler00 Busy",
                .symbol_name = "Sampler00Busy",
                .desc = "The percentage of time in which Slice0 Sampler0 has been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__sampler00_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = tglgt1_render_basic_Sampler00Busy_availability,
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = tglgt1_render_basic_SamplerBottleneck_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers have been processing EU requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = tglgt1_render_basic_SamplersBusy_availability,
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_basic__slm_bytes_read__read,
                .max_uint64 = tglgt1__render_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_basic__slm_bytes_written__read,
                .max_uint64 = tglgt1__render_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 34);
}


static void
tglgt1_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "79a0514e-40d7-437a-90cf-33e02857adc6";
    metric_set->counters = calloc(30, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__compute_basic__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__compute_basic__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__compute_basic__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__compute_basic__gti_read_throughput__read,
                .max_uint64 = tglgt1__compute_basic__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__compute_basic__gti_write_throughput__read,
                .max_uint64 = tglgt1__compute_basic__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__compute_basic__l3_shader_throughput__read,
                .max_uint64 = tglgt1__compute_basic__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__compute_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__compute_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__compute_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__compute_basic__slm_bytes_read__read,
                .max_uint64 = tglgt1__compute_basic__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__compute_basic__slm_bytes_written__read,
                .max_uint64 = tglgt1__compute_basic__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__compute_basic__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 30);
}


static void
tglgt1_add_render_pipe_profile_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics set for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "619eabea-0191-4d75-aaca-4217837215aa";
    metric_set->counters = calloc(43, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_render_pipe_profile_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__render_pipe_profile__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__render_pipe_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC Bottleneck",
                .symbol_name = "BcBottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__bc_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Barycentric Calc",
            },

            {
                .name = "Clipper Bottleneck",
                .symbol_name = "ClBottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__cl_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CL Stall",
                .symbol_name = "ClStall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__cl_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Clipper",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Bottleneck",
                .symbol_name = "DsBottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__ds_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Stall",
                .symbol_name = "DsStall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__ds_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__render_pipe_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__render_pipe_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Bottleneck",
                .symbol_name = "GsBottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__gs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Hi-Depth Bottleneck",
                .symbol_name = "HiDepthBottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__hi_depth_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Bottleneck",
                .symbol_name = "HsBottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__hs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Stall",
                .symbol_name = "HsStall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__hs_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_pipe_profile__l3_shader_throughput__read,
                .max_uint64 = tglgt1__render_pipe_profile__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__render_pipe_profile__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__render_pipe_profile__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__render_pipe_profile__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Strip-Fans Bottleneck",
                .symbol_name = "SfBottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__sf_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "SF Stall",
                .symbol_name = "SfStall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__sf_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Rasterizer/Strip-Fans",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_pipe_profile__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_pipe_profile__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__render_pipe_profile__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_pipe_profile__slm_bytes_read__read,
                .max_uint64 = tglgt1__render_pipe_profile__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__render_pipe_profile__slm_bytes_written__read,
                .max_uint64 = tglgt1__render_pipe_profile__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SO Bottleneck",
                .symbol_name = "SoBottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__so_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "SO Stall",
                .symbol_name = "SoStall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__so_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Stream Output",
            },

            {
                .name = "VF Bottleneck",
                .symbol_name = "VfBottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__vf_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Input Assembler",
            },

            {
                .name = "VS Bottleneck",
                .symbol_name = "VsBottleneck",
                .desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__render_pipe_profile__vs_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "3D Pipe/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__render_pipe_profile__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 43);
}

static bool tglgt1_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}

static void
tglgt1_add_hdc_and_sf_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF";
    metric_set->symbol_name = "HDCAndSF";
    metric_set->hw_config_guid = "b1560378-cb32-4d4b-af30-ffeb163655e6";
    metric_set->counters = calloc(31, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_hdc_and_sf_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__hdc_and_sf__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__hdc_and_sf__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__hdc_and_sf__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__hdc_and_sf__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__hdc_and_sf__l3_shader_throughput__read,
                .max_uint64 = tglgt1__hdc_and_sf__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Slice0 Dualsubslice0 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader00AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = tglgt1_hdc_and_sf_NonSamplerShader00AccessStalledOnL3_availability,
            },

            {
                .name = "Slice0 Dualsubslice1 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader01AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Data Port",
                .availability = tglgt1_hdc_and_sf_NonSamplerShader01AccessStalledOnL3_availability,
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Polygon Data Ready",
                .symbol_name = "PolyDataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__hdc_and_sf__poly_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe/Strip-Fans",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__hdc_and_sf__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__hdc_and_sf__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__hdc_and_sf__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__hdc_and_sf__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__hdc_and_sf__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__hdc_and_sf__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__hdc_and_sf__slm_bytes_read__read,
                .max_uint64 = tglgt1__hdc_and_sf__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__hdc_and_sf__slm_bytes_written__read,
                .max_uint64 = tglgt1__hdc_and_sf__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__hdc_and_sf__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 31);
}

static bool tglgt1_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_rasterizer_and_pixel_backend_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend";
    metric_set->symbol_name = "RasterizerAndPixelBackend";
    metric_set->hw_config_guid = "36e7fc09-3fb7-4b46-a6ff-ba1ce767db7c";
    metric_set->counters = calloc(37, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_rasterizer_and_pixel_backend_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Early Depth Test",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "SQ00 is full",
                .symbol_name = "GTRequestQueue00Full",
                .desc = "The percentage of time when IDI0 SQ0 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__gt_request_queue00_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ01 is full",
                .symbol_name = "GTRequestQueue01Full",
                .desc = "The percentage of time when IDI0 SQ1 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__gt_request_queue01_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ10 is full",
                .symbol_name = "GTRequestQueue10Full",
                .desc = "The percentage of time when IDI1 SQ0 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__gt_request_queue10_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "SQ11 is full",
                .symbol_name = "GTRequestQueue11Full",
                .desc = "The percentage of time when IDI1 SQ1 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__gt_request_queue11_full__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer/Hi-Depth Test",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "L3 Shader Throughput",
                .symbol_name = "L3ShaderThroughput",
                .desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__l3_shader_throughput__read,
                .max_uint64 = tglgt1__rasterizer_and_pixel_backend__l3_shader_throughput__max,
                .group = "L3/Data Port",
            },

            {
                .name = "Slice0 Pipe0 PS Output Available",
                .symbol_name = "PSOutput00Available",
                .desc = "The percentage of time in which slice0 pipe0 PS output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__ps_output00_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData00Ready",
                .desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__pixel_data00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer/Early Depth Test",
            },

            {
                .name = "Slice0 Pipe0 Pixel Values Ready",
                .symbol_name = "PixelValues00Ready",
                .desc = "The percentage of time in which slice0 pipe0 pixel values are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__pixel_values00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/3D Pipe",
            },

            {
                .name = "Pixels Failing Tests",
                .symbol_name = "PixelsFailingPostPsTests",
                .desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Rasterized Pixels",
                .symbol_name = "RasterizedPixels",
                .desc = "The total number of rasterized pixels.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__rasterized_pixels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Rasterizer",
            },

            {
                .name = "Slice0 Rasterizer Input Available",
                .symbol_name = "Rasterizer0InputAvailable",
                .desc = "The percentage of time in which slice0 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__rasterizer0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = tglgt1_rasterizer_and_pixel_backend_Rasterizer0InputAvailable_availability,
            },

            {
                .name = "Slice0 Rasterizer Output Ready",
                .symbol_name = "Rasterizer0OutputReady",
                .desc = "The percentage of time in which slice0 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__rasterizer_and_pixel_backend__rasterizer0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Rasterizer",
                .availability = tglgt1_rasterizer_and_pixel_backend_Rasterizer0OutputReady_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Cache",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler/Sampler Input",
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Samples Killed in FS",
                .symbol_name = "SamplesKilledInPs",
                .desc = "The total number of samples or pixels dropped in fragment shaders.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__samples_killed_in_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Fragment Shader",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "3D Pipe/Output Merger",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port/Atomics",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Barrier",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3/Data Port",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmBytesRead",
                .desc = "The total number of GPU memory bytes read from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__slm_bytes_read__read,
                .max_uint64 = tglgt1__rasterizer_and_pixel_backend__slm_bytes_read__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "SLM Bytes Written",
                .symbol_name = "SlmBytesWritten",
                .desc = "The total number of GPU memory bytes written into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__slm_bytes_written__read,
                .max_uint64 = tglgt1__rasterizer_and_pixel_backend__slm_bytes_written__max,
                .group = "L3/Data Port/SLM",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__rasterizer_and_pixel_backend__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 37);
}

static bool tglgt1_l3_1_L30Bank0InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_l3_1_L30Bank1InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_1";
    metric_set->symbol_name = "L3_1";
    metric_set->hw_config_guid = "4a46a4ee-437d-4726-ac61-31e47072f706";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_1__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank0 Input Available",
                .symbol_name = "L30Bank0InputAvailable",
                .desc = "The percentage of time in which slice0 L3 bank0 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__l30_bank0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_1_L30Bank0InputAvailable_availability,
            },

            {
                .name = "Slice0 L3 Bank1 Input Available",
                .symbol_name = "L30Bank1InputAvailable",
                .desc = "The percentage of time in which slice0 L3 bank1 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_1__l30_bank1_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_1_L30Bank1InputAvailable_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool tglgt1_l3_2_L30Bank2InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_l3_2_L30Bank3InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_2";
    metric_set->symbol_name = "L3_2";
    metric_set->hw_config_guid = "2456d8be-5c99-430c-8172-8294fdc39331";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_2__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank2 Input Available",
                .symbol_name = "L30Bank2InputAvailable",
                .desc = "The percentage of time in which slice0 L3 bank2 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__l30_bank2_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_2_L30Bank2InputAvailable_availability,
            },

            {
                .name = "Slice0 L3 Bank3 Input Available",
                .symbol_name = "L30Bank3InputAvailable",
                .desc = "The percentage of time in which slice0 L3 bank3 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_2__l30_bank3_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_2_L30Bank3InputAvailable_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}

static bool tglgt1_l3_3_L30Bank0OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_3";
    metric_set->symbol_name = "L3_3";
    metric_set->hw_config_guid = "71e2a606-810c-4252-bf7e-16fed118f4b5";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_3__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_3__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_3__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_3__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank0 Output Ready",
                .symbol_name = "L30Bank0OutputReady",
                .desc = "The percentage of time in which slice0 L3 bank0 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_3__l30_bank0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_3_L30Bank0OutputReady_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_3__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 14);
}

static bool tglgt1_l3_4_L30Bank1OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_4";
    metric_set->symbol_name = "L3_4";
    metric_set->hw_config_guid = "327a91a5-f93c-449d-b5e1-ab92cb1180a1";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_4__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_4__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_4__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_4__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_4__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank1 Output Ready",
                .symbol_name = "L30Bank1OutputReady",
                .desc = "The percentage of time in which slice0 L3 bank1 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_4__l30_bank1_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_4_L30Bank1OutputReady_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_4__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 14);
}

static bool tglgt1_l3_5_L30Bank2OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_5";
    metric_set->symbol_name = "L3_5";
    metric_set->hw_config_guid = "a8de84ca-1624-4e0c-8046-d5265566c15b";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_5__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_5__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_5__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_5__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_5__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_5__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_5__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_5__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank2 Output Ready",
                .symbol_name = "L30Bank2OutputReady",
                .desc = "The percentage of time in which slice0 L3 bank2 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_5__l30_bank2_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_5_L30Bank2OutputReady_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_5__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 14);
}

static bool tglgt1_l3_6_L30Bank3OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & 1) {
        return true;
    }
    return false;
}

static void
tglgt1_add_l3_6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_6";
    metric_set->symbol_name = "L3_6";
    metric_set->hw_config_guid = "6f376729-c56a-4560-a0eb-f4a17ec6df84";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_l3_6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__l3_6__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__l3_6__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_6__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_6__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_6__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_6__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__l3_6__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__l3_6__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Slice0 L3 Bank3 Output Ready",
                .symbol_name = "L30Bank3OutputReady",
                .desc = "The percentage of time in which slice0 L3 bank3 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__l3_6__l30_bank3_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GTI/L3",
                .availability = tglgt1_l3_6_L30Bank3OutputReady_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__l3_6__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 14);
}

static bool tglgt1_sampler_1_Sampler00InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_sampler_1_Sampler00OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_sampler_1_Sampler01InputAvailable_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_sampler_1_Sampler01OutputReady_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}

static void
tglgt1_add_sampler_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_1";
    metric_set->symbol_name = "Sampler_1";
    metric_set->hw_config_guid = "4876283b-1889-4cef-880f-58de9dc676cb";
    metric_set->counters = calloc(17, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_sampler_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__sampler_1__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__sampler_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__sampler_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__sampler_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Slice0 DualSubslice0 Input Available",
                .symbol_name = "Sampler00InputAvailable",
                .desc = "The percentage of time in which slice0 dualsubslice0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__sampler00_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = tglgt1_sampler_1_Sampler00InputAvailable_availability,
            },

            {
                .name = "Slice0 DualSubslice0 Sampler Output Ready",
                .symbol_name = "Sampler00OutputReady",
                .desc = "The percentage of time in which slice0 dualsubslice0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__sampler00_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = tglgt1_sampler_1_Sampler00OutputReady_availability,
            },

            {
                .name = "Slice0 DualSubslice1 Input Available",
                .symbol_name = "Sampler01InputAvailable",
                .desc = "The percentage of time in which slice0 dualsubslice1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__sampler01_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = tglgt1_sampler_1_Sampler01InputAvailable_availability,
            },

            {
                .name = "Slice0 DualSubslice1 Sampler Output Ready",
                .symbol_name = "Sampler01OutputReady",
                .desc = "The percentage of time in which slice0 dualsubslice1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__sampler_1__sampler01_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Sampler",
                .availability = tglgt1_sampler_1_Sampler01OutputReady_availability,
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__sampler_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 17);
}

static bool tglgt1_tdl_1_NonPSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_NonPSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_PSThread00ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_PSThread01ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader00Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader00ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader00ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader00ReadyPort2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader00ReadyPort3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 1) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader01Ready_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader01ReadyPort0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader01ReadyPort1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader01ReadyPort2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}
static bool tglgt1_tdl_1_ThreadHeader01ReadyPort3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.subslice_mask & 2) {
        return true;
    }
    return false;
}

static void
tglgt1_add_tdl_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_1";
    metric_set->symbol_name = "TDL_1";
    metric_set->hw_config_guid = "aeddd71b-2f93-48de-9e69-1cba5865473f";
    metric_set->counters = calloc(27, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_tdl_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__tdl_1__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__tdl_1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__tdl_1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__tdl_1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice0 Thread Dispatcher",
                .symbol_name = "NonPSThread00ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__non_ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_NonPSThread00ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice1 Thread Dispatcher",
                .symbol_name = "NonPSThread01ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__non_ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_NonPSThread01ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice0 Thread Dispatcher",
                .symbol_name = "PSThread00ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__ps_thread00_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_PSThread00ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice1 Thread Dispatcher",
                .symbol_name = "PSThread01ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__ps_thread01_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_PSThread01ReadyForDispatch_availability,
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher",
                .symbol_name = "ThreadHeader00Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header00_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader00Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader00ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header00_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader00ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader00ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header00_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader00ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader00ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header00_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader00ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader00ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header00_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader00ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher",
                .symbol_name = "ThreadHeader01Ready",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header01_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader01Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader01ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header01_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader01ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader01ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header01_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader01ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader01ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header01_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader01ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader01ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__tdl_1__thread_header01_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU/Thread Dispatcher",
                .availability = tglgt1_tdl_1_ThreadHeader01ReadyPort3_availability,
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__tdl_1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 27);
}


static void
tglgt1_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "a4089c3f-a697-4213-a58b-70e150969226";
    metric_set->counters = calloc(22, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Any Engine Busy",
                .symbol_name = "AnyEngineBusy",
                .desc = "The percentage of time when any command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__any_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__gpu_busyness__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__gpu_busyness__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Blitter Ring Busy",
                .symbol_name = "BlitterBusy",
                .desc = "The percentage of time when blitter command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__blitter_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Active",
                .symbol_name = "EuActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__eu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Stall",
                .symbol_name = "EuStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__eu_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "EU Thread Occupancy",
                .symbol_name = "EuThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied EUs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__eu_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__gpu_busyness__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__gpu_busyness__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "Posh Ring Busy",
                .symbol_name = "PoshEngineBusy",
                .desc = "The percentage of time when posh command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__posh_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox0 Ring Busy",
                .symbol_name = "Vdbox0Busy",
                .desc = "The percentage of time when Vdbox0 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__vdbox0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vdbox1 Ring Busy",
                .symbol_name = "Vdbox1Busy",
                .desc = "The percentage of time when Vdbox1 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__vdbox1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Vebox Ring Busy",
                .symbol_name = "VeboxBusy",
                .desc = "The percentage of time when vebox command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__gpu_busyness__vebox_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__gpu_busyness__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 22);
}


static void
tglgt1_add_eu_activity1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity1";
    metric_set->symbol_name = "EuActivity1";
    metric_set->hw_config_guid = "ffde7a80-6d78-42c8-8603-838de28d07da";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity1__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EU Send Pipe Active",
                .symbol_name = "EuSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__eu_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity1__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity1__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity1__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity1__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "PS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity1__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity2";
    metric_set->symbol_name = "EuActivity2";
    metric_set->hw_config_guid = "bd3186a3-6e96-4c70-a5d9-65d4bea6f668";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity2__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS EM Pipe Active",
                .symbol_name = "CsEmActive",
                .desc = "The percentage of time in which EU FPU1 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__cs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "CS FPU Pipe Active",
                .symbol_name = "CsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__cs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "CS Send Pipeline Active",
                .symbol_name = "CsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__cs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity2__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity2__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity2__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity2__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity2__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity2__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity3";
    metric_set->symbol_name = "EuActivity3";
    metric_set->hw_config_guid = "b59e975f-044c-4e0c-afcd-46aee1107b81";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity3__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity3__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity3__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity3__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity3__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "PS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "PS Send Pipeline Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pixel Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity3__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity3__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity4";
    metric_set->symbol_name = "EuActivity4";
    metric_set->hw_config_guid = "948f1627-f642-42a6-8304-801d7db112d2";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity4__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS FPU Pipe Active",
                .symbol_name = "DsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a domain shader instructions.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__ds_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity4__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity4__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity4__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity4__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS FPU Pipe Active",
                .symbol_name = "HsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__hs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity4__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Vertex Shader",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity4__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity5";
    metric_set->symbol_name = "EuActivity5";
    metric_set->hw_config_guid = "243ffad2-626e-4d05-94a0-af7068e18a84";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity5__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity5__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS EM Pipe Active",
                .symbol_name = "DsEmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing a domain shader instructions.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__ds_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity5__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity5__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity5__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity5__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity5__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity5__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS EM Pipe Active",
                .symbol_name = "HsEmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing a hull shader instructions.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__hs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS Send Pipe Active",
                .symbol_name = "HsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__hs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity5__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity5__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity6";
    metric_set->symbol_name = "EuActivity6";
    metric_set->hw_config_guid = "1f367b67-1f45-469b-97fd-eac88aeb1f7c";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity6__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity6__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity6__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity6__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EM Pipe Active",
                .symbol_name = "GsEmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing a geometry shader instructions.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__gs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS FPU Pipe Active",
                .symbol_name = "GsFpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing a geometry shader instructions.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__gs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Send Pipe Active",
                .symbol_name = "GsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__gs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity6__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity6__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity6__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity6__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity6__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity6__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
tglgt1_add_eu_activity7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity7";
    metric_set->symbol_name = "EuActivity7";
    metric_set->hw_config_guid = "7c2db23c-1fb4-45df-a5d5-2345d23c10fc";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity7__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity7__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which EU EM pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU AVG IPC Rate",
                .symbol_name = "EuAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = tglgt1__eu_activity7__eu_avg_ipc_rate__read,
                .max_float = tglgt1__eu_activity7__eu_avg_ipc_rate__max,
                .group = "EU Array",
            },

            {
                .name = "EU FPU And EM Pipes Active",
                .symbol_name = "EuFpuEmActive",
                .desc = "The percentage of time in which EU FPU and EM pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__eu_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "EU FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which EU FPU pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Pipes",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity7__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity7__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity7__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity7__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity7__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity7__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity7__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity7__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}


static void
tglgt1_add_eu_activity8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity8";
    metric_set->symbol_name = "EuActivity8";
    metric_set->hw_config_guid = "b4c81162-2c96-4cf1-86ae-ecff3d57ee4d";
    metric_set->counters = calloc(16, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_eu_activity8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__eu_activity8__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__eu_activity8__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compute Ring Busy",
                .symbol_name = "ComputeBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity8__compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Compute Shader",
            },

            {
                .name = "DS Send Pipe Active",
                .symbol_name = "DsSendActive",
                .desc = "The percentage of time in which EU send pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity8__ds_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "The total number of domain shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Domain Shader",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity8__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__eu_activity8__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__eu_activity8__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "The total number of geometry shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Geometry Shader",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity8__gti_read_throughput__read,
                .max_uint64 = tglgt1__eu_activity8__gti_read_throughput__max,
                .group = "GTI",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = tglgt1__eu_activity8__gti_write_throughput__read,
                .max_uint64 = tglgt1__eu_activity8__gti_write_throughput__max,
                .group = "GTI",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "The total number of hull shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Hull Shader",
            },

            {
                .name = "FS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "The total number of fragment shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Fragment Shader",
            },

            {
                .name = "Render and compute engines are simultaneously busy",
                .symbol_name = "RenderAndComputeBusy",
                .desc = "The percentage of time when render and compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity8__render_and_compute_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = tglgt1__eu_activity8__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "GPU",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "The total number of vertex shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = tglgt1__eu_activity8__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "EU Array/Vertex Shader",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 16);
}


static void
tglgt1_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "6f27aaed-4f08-4e0f-95a9-231d9b4fa111";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    tglgt1_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = tglgt1__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = tglgt1__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.16666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.6666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "TestCounter9 - OAR enable",
                .symbol_name = "Counter9",
                .desc = "HW test counter 9. Should be equal to 1 in query.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = tglgt1__test_oa__counter9__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = tglgt1__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = tglgt1__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}

void
intel_perf_load_metrics_tglgt1(struct intel_perf *perf)
{
    tglgt1_add_render_basic_metric_set(perf);
    tglgt1_add_compute_basic_metric_set(perf);
    tglgt1_add_render_pipe_profile_metric_set(perf);
    tglgt1_add_hdc_and_sf_metric_set(perf);
    tglgt1_add_rasterizer_and_pixel_backend_metric_set(perf);
    tglgt1_add_l3_1_metric_set(perf);
    tglgt1_add_l3_2_metric_set(perf);
    tglgt1_add_l3_3_metric_set(perf);
    tglgt1_add_l3_4_metric_set(perf);
    tglgt1_add_l3_5_metric_set(perf);
    tglgt1_add_l3_6_metric_set(perf);
    tglgt1_add_sampler_1_metric_set(perf);
    tglgt1_add_tdl_1_metric_set(perf);
    tglgt1_add_gpu_busyness_metric_set(perf);
    tglgt1_add_eu_activity1_metric_set(perf);
    tglgt1_add_eu_activity2_metric_set(perf);
    tglgt1_add_eu_activity3_metric_set(perf);
    tglgt1_add_eu_activity4_metric_set(perf);
    tglgt1_add_eu_activity5_metric_set(perf);
    tglgt1_add_eu_activity6_metric_set(perf);
    tglgt1_add_eu_activity7_metric_set(perf);
    tglgt1_add_eu_activity8_metric_set(perf);
    tglgt1_add_test_oa_metric_set(perf);
}
