{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoGlyphString@ is used to store strings of glyphs with geometry
-- and visual attribute information.
-- 
-- The storage for the glyph information is owned by the structure
-- which simplifies memory management.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.GlyphString
    ( 

-- * Exported types
    GlyphString(..)                         ,
    newZeroGlyphString                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Pango.Structs.GlyphString#g:method:copy"), [extents]("GI.Pango.Structs.GlyphString#g:method:extents"), [extentsRange]("GI.Pango.Structs.GlyphString#g:method:extentsRange"), [free]("GI.Pango.Structs.GlyphString#g:method:free"), [indexToX]("GI.Pango.Structs.GlyphString#g:method:indexToX"), [indexToXFull]("GI.Pango.Structs.GlyphString#g:method:indexToXFull"), [xToIndex]("GI.Pango.Structs.GlyphString#g:method:xToIndex").
-- 
-- ==== Getters
-- [getWidth]("GI.Pango.Structs.GlyphString#g:method:getWidth").
-- 
-- ==== Setters
-- [setSize]("GI.Pango.Structs.GlyphString#g:method:setSize").

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphStringMethod                ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    GlyphStringCopyMethodInfo               ,
#endif
    glyphStringCopy                         ,


-- ** extents #method:extents#

#if defined(ENABLE_OVERLOADING)
    GlyphStringExtentsMethodInfo            ,
#endif
    glyphStringExtents                      ,


-- ** extentsRange #method:extentsRange#

#if defined(ENABLE_OVERLOADING)
    GlyphStringExtentsRangeMethodInfo       ,
#endif
    glyphStringExtentsRange                 ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    GlyphStringFreeMethodInfo               ,
#endif
    glyphStringFree                         ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    GlyphStringGetWidthMethodInfo           ,
#endif
    glyphStringGetWidth                     ,


-- ** indexToX #method:indexToX#

#if defined(ENABLE_OVERLOADING)
    GlyphStringIndexToXMethodInfo           ,
#endif
    glyphStringIndexToX                     ,


-- ** indexToXFull #method:indexToXFull#

#if defined(ENABLE_OVERLOADING)
    GlyphStringIndexToXFullMethodInfo       ,
#endif
    glyphStringIndexToXFull                 ,


-- ** new #method:new#

    glyphStringNew                          ,


-- ** setSize #method:setSize#

#if defined(ENABLE_OVERLOADING)
    GlyphStringSetSizeMethodInfo            ,
#endif
    glyphStringSetSize                      ,


-- ** xToIndex #method:xToIndex#

#if defined(ENABLE_OVERLOADING)
    GlyphStringXToIndexMethodInfo           ,
#endif
    glyphStringXToIndex                     ,




 -- * Properties


-- ** logClusters #attr:logClusters#
-- | logical cluster info, indexed by the byte index
--   within the text corresponding to the glyph string

    getGlyphStringLogClusters               ,
#if defined(ENABLE_OVERLOADING)
    glyphString_logClusters                 ,
#endif
    setGlyphStringLogClusters               ,


-- ** numGlyphs #attr:numGlyphs#
-- | number of glyphs in this glyph string

    getGlyphStringNumGlyphs                 ,
#if defined(ENABLE_OVERLOADING)
    glyphString_numGlyphs                   ,
#endif
    setGlyphStringNumGlyphs                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype GlyphString = GlyphString (SP.ManagedPtr GlyphString)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphString where
    toManagedPtr (GlyphString p) = p

foreign import ccall "pango_glyph_string_get_type" c_pango_glyph_string_get_type :: 
    IO GType

type instance O.ParentTypes GlyphString = '[]
instance O.HasParentTypes GlyphString

instance B.Types.TypedObject GlyphString where
    glibType = c_pango_glyph_string_get_type

instance B.Types.GBoxed GlyphString

-- | Convert t'GlyphString' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GlyphString) where
    gvalueGType_ = c_pango_glyph_string_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr GlyphString)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr GlyphString)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed GlyphString ptr
        else return P.Nothing
        
    

-- | Construct a t'GlyphString' struct initialized to zero.
newZeroGlyphString :: MonadIO m => m GlyphString
newZeroGlyphString = liftIO $ callocBoxedBytes 32 >>= wrapBoxed GlyphString

instance tag ~ 'AttrSet => Constructible GlyphString tag where
    new _ attrs = do
        o <- newZeroGlyphString
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@num_glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphString #numGlyphs
-- @
getGlyphStringNumGlyphs :: MonadIO m => GlyphString -> m Int32
getGlyphStringNumGlyphs s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@num_glyphs@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphString [ #numGlyphs 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphStringNumGlyphs :: MonadIO m => GlyphString -> Int32 -> m ()
setGlyphStringNumGlyphs s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphStringNumGlyphsFieldInfo
instance AttrInfo GlyphStringNumGlyphsFieldInfo where
    type AttrBaseTypeConstraint GlyphStringNumGlyphsFieldInfo = (~) GlyphString
    type AttrAllowedOps GlyphStringNumGlyphsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphStringNumGlyphsFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphStringNumGlyphsFieldInfo = (~)Int32
    type AttrTransferType GlyphStringNumGlyphsFieldInfo = Int32
    type AttrGetType GlyphStringNumGlyphsFieldInfo = Int32
    type AttrLabel GlyphStringNumGlyphsFieldInfo = "num_glyphs"
    type AttrOrigin GlyphStringNumGlyphsFieldInfo = GlyphString
    attrGet = getGlyphStringNumGlyphs
    attrSet = setGlyphStringNumGlyphs
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.numGlyphs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#g:attr:numGlyphs"
        })

glyphString_numGlyphs :: AttrLabelProxy "numGlyphs"
glyphString_numGlyphs = AttrLabelProxy

#endif


-- XXX Skipped attribute for "GlyphString:glyphs"
-- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 0 (TInterface (Name {namespace = "Pango", name = "GlyphInfo"}))
-- | Get the value of the “@log_clusters@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphString #logClusters
-- @
getGlyphStringLogClusters :: MonadIO m => GlyphString -> m Int32
getGlyphStringLogClusters s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@log_clusters@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphString [ #logClusters 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphStringLogClusters :: MonadIO m => GlyphString -> Int32 -> m ()
setGlyphStringLogClusters s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphStringLogClustersFieldInfo
instance AttrInfo GlyphStringLogClustersFieldInfo where
    type AttrBaseTypeConstraint GlyphStringLogClustersFieldInfo = (~) GlyphString
    type AttrAllowedOps GlyphStringLogClustersFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphStringLogClustersFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphStringLogClustersFieldInfo = (~)Int32
    type AttrTransferType GlyphStringLogClustersFieldInfo = Int32
    type AttrGetType GlyphStringLogClustersFieldInfo = Int32
    type AttrLabel GlyphStringLogClustersFieldInfo = "log_clusters"
    type AttrOrigin GlyphStringLogClustersFieldInfo = GlyphString
    attrGet = getGlyphStringLogClusters
    attrSet = setGlyphStringLogClusters
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.logClusters"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#g:attr:logClusters"
        })

glyphString_logClusters :: AttrLabelProxy "logClusters"
glyphString_logClusters = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphString
type instance O.AttributeList GlyphString = GlyphStringAttributeList
type GlyphStringAttributeList = ('[ '("numGlyphs", GlyphStringNumGlyphsFieldInfo), '("logClusters", GlyphStringLogClustersFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method GlyphString::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "GlyphString" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_new" pango_glyph_string_new :: 
    IO (Ptr GlyphString)

-- | Create a new @PangoGlyphString@.
glyphStringNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GlyphString
    -- ^ __Returns:__ the newly allocated @PangoGlyphString@, which
    --   should be freed with 'GI.Pango.Structs.GlyphString.glyphStringFree'.
glyphStringNew  = liftIO $ do
    result <- pango_glyph_string_new
    checkUnexpectedReturnNULL "glyphStringNew" result
    result' <- (wrapBoxed GlyphString) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GlyphString::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "string"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "GlyphString" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_copy" pango_glyph_string_copy :: 
    Ptr GlyphString ->                      -- string : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    IO (Ptr GlyphString)

-- | Copy a glyph string and associated storage.
glyphStringCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GlyphString)
    -- ^ /@string@/: a @PangoGlyphString@
    -> m (Maybe GlyphString)
    -- ^ __Returns:__ the newly allocated @PangoGlyphString@
glyphStringCopy string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- unsafeManagedPtrGetPtr jString
            return jString'
    result <- pango_glyph_string_copy maybeString
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed GlyphString) result'
        return result''
    whenJust string touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GlyphStringCopyMethodInfo
instance (signature ~ (m (Maybe GlyphString)), MonadIO m) => O.OverloadedMethod GlyphStringCopyMethodInfo GlyphString signature where
    overloadedMethod i = glyphStringCopy (Just i)

instance O.OverloadedMethodInfo GlyphStringCopyMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringCopy"
        })


#endif

-- method GlyphString::extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType = TInterface Name { namespace = "Pango" , name = "Font" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFont`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the extents of the glyph string as drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to store the logical extents of the glyph string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_extents" pango_glyph_string_extents :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    Ptr Pango.Font.Font ->                  -- font : TInterface (Name {namespace = "Pango", name = "Font"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Compute the logical and ink extents of a glyph string.
-- 
-- See the documentation for 'GI.Pango.Objects.Font.fontGetGlyphExtents' for details
-- about the interpretation of the rectangles.
-- 
-- Examples of logical (red) and ink (green) rects:
-- 
-- <<http://developer.gnome.org/pango/stable/rects1.png>> <<http://developer.gnome.org/pango/stable/rects2.png>>
glyphStringExtents ::
    (B.CallStack.HasCallStack, MonadIO m, Pango.Font.IsFont a) =>
    GlyphString
    -- ^ /@glyphs@/: a @PangoGlyphString@
    -> a
    -- ^ /@font@/: a @PangoFont@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
glyphStringExtents glyphs font = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    font' <- unsafeManagedPtrCastPtr font
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_glyph_string_extents glyphs' font' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr glyphs
    touchManagedPtr font
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data GlyphStringExtentsMethodInfo
instance (signature ~ (a -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m, Pango.Font.IsFont a) => O.OverloadedMethod GlyphStringExtentsMethodInfo GlyphString signature where
    overloadedMethod = glyphStringExtents

instance O.OverloadedMethodInfo GlyphStringExtentsMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringExtents"
        })


#endif

-- method GlyphString::extents_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "end index (the range is the set of bytes with\n  indices such that start <= index < end)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "font"
--           , argType = TInterface Name { namespace = "Pango" , name = "Font" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoFont`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to\n  store the extents of the glyph string range as drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "rectangle used to\n  store the logical extents of the glyph string range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_extents_range" pango_glyph_string_extents_range :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    Int32 ->                                -- start : TBasicType TInt
    Int32 ->                                -- end : TBasicType TInt
    Ptr Pango.Font.Font ->                  -- font : TInterface (Name {namespace = "Pango", name = "Font"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Computes the extents of a sub-portion of a glyph string.
-- 
-- The extents are relative to the start of the glyph string range
-- (the origin of their coordinate system is at the start of the range,
-- not at the start of the entire glyph string).
glyphStringExtentsRange ::
    (B.CallStack.HasCallStack, MonadIO m, Pango.Font.IsFont a) =>
    GlyphString
    -- ^ /@glyphs@/: a @PangoGlyphString@
    -> Int32
    -- ^ /@start@/: start index
    -> Int32
    -- ^ /@end@/: end index (the range is the set of bytes with
    --   indices such that start \<= index \< end)
    -> a
    -- ^ /@font@/: a @PangoFont@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
glyphStringExtentsRange glyphs start end font = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    font' <- unsafeManagedPtrCastPtr font
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_glyph_string_extents_range glyphs' start end font' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr glyphs
    touchManagedPtr font
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data GlyphStringExtentsRangeMethodInfo
instance (signature ~ (Int32 -> Int32 -> a -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m, Pango.Font.IsFont a) => O.OverloadedMethod GlyphStringExtentsRangeMethodInfo GlyphString signature where
    overloadedMethod = glyphStringExtentsRange

instance O.OverloadedMethodInfo GlyphStringExtentsRangeMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringExtentsRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringExtentsRange"
        })


#endif

-- method GlyphString::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "string"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_free" pango_glyph_string_free :: 
    Ptr GlyphString ->                      -- string : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    IO ()

-- | Free a glyph string and associated storage.
glyphStringFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GlyphString)
    -- ^ /@string@/: a @PangoGlyphString@, may be 'P.Nothing'
    -> m ()
glyphStringFree string = liftIO $ do
    maybeString <- case string of
        Nothing -> return FP.nullPtr
        Just jString -> do
            jString' <- unsafeManagedPtrGetPtr jString
            return jString'
    pango_glyph_string_free maybeString
    whenJust string touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data GlyphStringFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod GlyphStringFreeMethodInfo GlyphString signature where
    overloadedMethod i = glyphStringFree (Just i)

instance O.OverloadedMethodInfo GlyphStringFreeMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringFree"
        })


#endif

-- XXX Could not generate method GlyphString::get_logical_widths
-- Not implemented: Don't know how to allocate "logical_widths" of type TCArray False (-1) (-1) (TBasicType TInt)
-- method GlyphString::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_get_width" pango_glyph_string_get_width :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    IO Int32

-- | Computes the logical width of the glyph string.
-- 
-- This can also be computed using 'GI.Pango.Structs.GlyphString.glyphStringExtents'.
-- However, since this only computes the width, it\'s much faster. This
-- is in fact only a convenience function that computes the sum of
-- /@geometry@/.width for each glyph in the /@glyphs@/.
-- 
-- /Since: 1.14/
glyphStringGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphString
    -- ^ /@glyphs@/: a @PangoGlyphString@
    -> m Int32
    -- ^ __Returns:__ the logical width of the glyph string.
glyphStringGetWidth glyphs = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    result <- pango_glyph_string_get_width glyphs'
    touchManagedPtr glyphs
    return result

#if defined(ENABLE_OVERLOADING)
data GlyphStringGetWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod GlyphStringGetWidthMethodInfo GlyphString signature where
    overloadedMethod = glyphStringGetWidth

instance O.OverloadedMethodInfo GlyphStringGetWidthMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringGetWidth"
        })


#endif

-- method GlyphString::index_to_x
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the glyphs return from [func@shape]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text for the run"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes (not characters) in @text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "analysis"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Analysis" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the analysis information return from [func@itemize]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the byte index within @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether we should compute the result for the beginning (%FALSE)\n  or end (%TRUE) of the character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_index_to_x" pango_glyph_string_index_to_x :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- length : TBasicType TInt
    Ptr Pango.Analysis.Analysis ->          -- analysis : TInterface (Name {namespace = "Pango", name = "Analysis"})
    Int32 ->                                -- index_ : TBasicType TInt
    CInt ->                                 -- trailing : TBasicType TBoolean
    Ptr Int32 ->                            -- x_pos : TBasicType TInt
    IO ()

-- | Converts from character position to x position.
-- 
-- The X position is measured from the left edge of the run.
-- Character positions are obtained using font metrics for ligatures
-- where available, and computed by dividing up each cluster
-- into equal portions, otherwise.
-- 
-- \<picture>
--   \<source srcset=\"glyphstring-positions-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"Glyph positions\" src=\"glyphstring-positions-light.png\">
-- \<\/picture>
glyphStringIndexToX ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphString
    -- ^ /@glyphs@/: the glyphs return from [func/@shape@/]
    -> T.Text
    -- ^ /@text@/: the text for the run
    -> Int32
    -- ^ /@length@/: the number of bytes (not characters) in /@text@/.
    -> Pango.Analysis.Analysis
    -- ^ /@analysis@/: the analysis information return from [func/@itemize@/]
    -> Int32
    -- ^ /@index_@/: the byte index within /@text@/
    -> Bool
    -- ^ /@trailing@/: whether we should compute the result for the beginning ('P.False')
    --   or end ('P.True') of the character.
    -> m (Int32)
glyphStringIndexToX glyphs text length_ analysis index_ trailing = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    text' <- textToCString text
    analysis' <- unsafeManagedPtrGetPtr analysis
    let trailing' = (P.fromIntegral . P.fromEnum) trailing
    xPos <- allocMem :: IO (Ptr Int32)
    pango_glyph_string_index_to_x glyphs' text' length_ analysis' index_ trailing' xPos
    xPos' <- peek xPos
    touchManagedPtr glyphs
    touchManagedPtr analysis
    freeMem text'
    freeMem xPos
    return xPos'

#if defined(ENABLE_OVERLOADING)
data GlyphStringIndexToXMethodInfo
instance (signature ~ (T.Text -> Int32 -> Pango.Analysis.Analysis -> Int32 -> Bool -> m (Int32)), MonadIO m) => O.OverloadedMethod GlyphStringIndexToXMethodInfo GlyphString signature where
    overloadedMethod = glyphStringIndexToX

instance O.OverloadedMethodInfo GlyphStringIndexToXMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringIndexToX",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringIndexToX"
        })


#endif

-- method GlyphString::index_to_x_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the glyphs return from [func@shape]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text for the run"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes (not characters) in @text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "analysis"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Analysis" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the analysis information return from [func@itemize]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attrs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LogAttr" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "`PangoLogAttr` array for @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the byte index within @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether we should compute the result for the beginning (%FALSE)\n  or end (%TRUE) of the character."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_index_to_x_full" pango_glyph_string_index_to_x_full :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- length : TBasicType TInt
    Ptr Pango.Analysis.Analysis ->          -- analysis : TInterface (Name {namespace = "Pango", name = "Analysis"})
    Ptr Pango.LogAttr.LogAttr ->            -- attrs : TInterface (Name {namespace = "Pango", name = "LogAttr"})
    Int32 ->                                -- index_ : TBasicType TInt
    CInt ->                                 -- trailing : TBasicType TBoolean
    Ptr Int32 ->                            -- x_pos : TBasicType TInt
    IO ()

-- | Converts from character position to x position.
-- 
-- This variant of 'GI.Pango.Structs.GlyphString.glyphStringIndexToX' additionally
-- accepts a @PangoLogAttr@ array. The grapheme boundary information
-- in it can be used to disambiguate positioning inside some complex
-- clusters.
-- 
-- /Since: 1.50/
glyphStringIndexToXFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphString
    -- ^ /@glyphs@/: the glyphs return from [func/@shape@/]
    -> T.Text
    -- ^ /@text@/: the text for the run
    -> Int32
    -- ^ /@length@/: the number of bytes (not characters) in /@text@/.
    -> Pango.Analysis.Analysis
    -- ^ /@analysis@/: the analysis information return from [func/@itemize@/]
    -> Maybe (Pango.LogAttr.LogAttr)
    -- ^ /@attrs@/: @PangoLogAttr@ array for /@text@/
    -> Int32
    -- ^ /@index_@/: the byte index within /@text@/
    -> Bool
    -- ^ /@trailing@/: whether we should compute the result for the beginning ('P.False')
    --   or end ('P.True') of the character.
    -> m (Int32)
glyphStringIndexToXFull glyphs text length_ analysis attrs index_ trailing = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    text' <- textToCString text
    analysis' <- unsafeManagedPtrGetPtr analysis
    maybeAttrs <- case attrs of
        Nothing -> return FP.nullPtr
        Just jAttrs -> do
            jAttrs' <- unsafeManagedPtrGetPtr jAttrs
            return jAttrs'
    let trailing' = (P.fromIntegral . P.fromEnum) trailing
    xPos <- allocMem :: IO (Ptr Int32)
    pango_glyph_string_index_to_x_full glyphs' text' length_ analysis' maybeAttrs index_ trailing' xPos
    xPos' <- peek xPos
    touchManagedPtr glyphs
    touchManagedPtr analysis
    whenJust attrs touchManagedPtr
    freeMem text'
    freeMem xPos
    return xPos'

#if defined(ENABLE_OVERLOADING)
data GlyphStringIndexToXFullMethodInfo
instance (signature ~ (T.Text -> Int32 -> Pango.Analysis.Analysis -> Maybe (Pango.LogAttr.LogAttr) -> Int32 -> Bool -> m (Int32)), MonadIO m) => O.OverloadedMethod GlyphStringIndexToXFullMethodInfo GlyphString signature where
    overloadedMethod = glyphStringIndexToXFull

instance O.OverloadedMethodInfo GlyphStringIndexToXFullMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringIndexToXFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringIndexToXFull"
        })


#endif

-- method GlyphString::set_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "string"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoGlyphString`."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "new_len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new length of the string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_set_size" pango_glyph_string_set_size :: 
    Ptr GlyphString ->                      -- string : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    Int32 ->                                -- new_len : TBasicType TInt
    IO ()

-- | Resize a glyph string to the given length.
glyphStringSetSize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphString
    -- ^ /@string@/: a @PangoGlyphString@.
    -> Int32
    -- ^ /@newLen@/: the new length of the string
    -> m ()
glyphStringSetSize string newLen = liftIO $ do
    string' <- unsafeManagedPtrGetPtr string
    pango_glyph_string_set_size string' newLen
    touchManagedPtr string
    return ()

#if defined(ENABLE_OVERLOADING)
data GlyphStringSetSizeMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m) => O.OverloadedMethod GlyphStringSetSizeMethodInfo GlyphString signature where
    overloadedMethod = glyphStringSetSize

instance O.OverloadedMethodInfo GlyphStringSetSizeMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringSetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringSetSize"
        })


#endif

-- method GlyphString::x_to_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "glyphs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "GlyphString" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the glyphs returned from [func@shape]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text for the run"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes (not characters) in text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "analysis"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Analysis" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the analysis information return from [func@itemize]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the x offset (in Pango units)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store calculated byte index\n  within @text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store a boolean indicating\n  whether the user clicked on the leading or trailing edge of the\n  character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_glyph_string_x_to_index" pango_glyph_string_x_to_index :: 
    Ptr GlyphString ->                      -- glyphs : TInterface (Name {namespace = "Pango", name = "GlyphString"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- length : TBasicType TInt
    Ptr Pango.Analysis.Analysis ->          -- analysis : TInterface (Name {namespace = "Pango", name = "Analysis"})
    Int32 ->                                -- x_pos : TBasicType TInt
    Ptr Int32 ->                            -- index_ : TBasicType TInt
    Ptr Int32 ->                            -- trailing : TBasicType TInt
    IO ()

-- | Convert from x offset to character position.
-- 
-- Character positions are computed by dividing up each cluster into
-- equal portions. In scripts where positioning within a cluster is
-- not allowed (such as Thai), the returned value may not be a valid
-- cursor position; the caller must combine the result with the logical
-- attributes for the text to compute the valid cursor position.
glyphStringXToIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GlyphString
    -- ^ /@glyphs@/: the glyphs returned from [func/@shape@/]
    -> T.Text
    -- ^ /@text@/: the text for the run
    -> Int32
    -- ^ /@length@/: the number of bytes (not characters) in text.
    -> Pango.Analysis.Analysis
    -- ^ /@analysis@/: the analysis information return from [func/@itemize@/]
    -> Int32
    -- ^ /@xPos@/: the x offset (in Pango units)
    -> m ((Int32, Int32))
glyphStringXToIndex glyphs text length_ analysis xPos = liftIO $ do
    glyphs' <- unsafeManagedPtrGetPtr glyphs
    text' <- textToCString text
    analysis' <- unsafeManagedPtrGetPtr analysis
    index_ <- allocMem :: IO (Ptr Int32)
    trailing <- allocMem :: IO (Ptr Int32)
    pango_glyph_string_x_to_index glyphs' text' length_ analysis' xPos index_ trailing
    index_' <- peek index_
    trailing' <- peek trailing
    touchManagedPtr glyphs
    touchManagedPtr analysis
    freeMem text'
    freeMem index_
    freeMem trailing
    return (index_', trailing')

#if defined(ENABLE_OVERLOADING)
data GlyphStringXToIndexMethodInfo
instance (signature ~ (T.Text -> Int32 -> Pango.Analysis.Analysis -> Int32 -> m ((Int32, Int32))), MonadIO m) => O.OverloadedMethod GlyphStringXToIndexMethodInfo GlyphString signature where
    overloadedMethod = glyphStringXToIndex

instance O.OverloadedMethodInfo GlyphStringXToIndexMethodInfo GlyphString where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphString.glyphStringXToIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphString.html#v:glyphStringXToIndex"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphStringMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphStringMethod "copy" o = GlyphStringCopyMethodInfo
    ResolveGlyphStringMethod "extents" o = GlyphStringExtentsMethodInfo
    ResolveGlyphStringMethod "extentsRange" o = GlyphStringExtentsRangeMethodInfo
    ResolveGlyphStringMethod "free" o = GlyphStringFreeMethodInfo
    ResolveGlyphStringMethod "indexToX" o = GlyphStringIndexToXMethodInfo
    ResolveGlyphStringMethod "indexToXFull" o = GlyphStringIndexToXFullMethodInfo
    ResolveGlyphStringMethod "xToIndex" o = GlyphStringXToIndexMethodInfo
    ResolveGlyphStringMethod "getWidth" o = GlyphStringGetWidthMethodInfo
    ResolveGlyphStringMethod "setSize" o = GlyphStringSetSizeMethodInfo
    ResolveGlyphStringMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphStringMethod t GlyphString, O.OverloadedMethod info GlyphString p) => OL.IsLabel t (GlyphString -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphStringMethod t GlyphString, O.OverloadedMethod info GlyphString p, R.HasField t GlyphString p) => R.HasField t GlyphString p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphStringMethod t GlyphString, O.OverloadedMethodInfo info GlyphString) => OL.IsLabel t (O.MethodProxy info GlyphString) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


