{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrFloat@ structure is used to represent attributes with
-- a float or double value.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrFloat
    ( 

-- * Exported types
    AttrFloat(..)                           ,
    newZeroAttrFloat                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrFloatMethod                  ,
#endif



 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrFloat_attr                          ,
#endif
    getAttrFloatAttr                        ,


-- ** value #attr:value#
-- | the value of the attribute

#if defined(ENABLE_OVERLOADING)
    attrFloat_value                         ,
#endif
    getAttrFloatValue                       ,
    setAttrFloatValue                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- | Memory-managed wrapper type.
newtype AttrFloat = AttrFloat (SP.ManagedPtr AttrFloat)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrFloat where
    toManagedPtr (AttrFloat p) = p

instance BoxedPtr AttrFloat where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrFloat)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrFloat where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrFloat' struct initialized to zero.
newZeroAttrFloat :: MonadIO m => m AttrFloat
newZeroAttrFloat = liftIO $ boxedPtrCalloc >>= wrapPtr AttrFloat

instance tag ~ 'AttrSet => Constructible AttrFloat tag where
    new _ attrs = do
        o <- newZeroAttrFloat
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFloat #attr
-- @
getAttrFloatAttr :: MonadIO m => AttrFloat -> m Pango.Attribute.Attribute
getAttrFloatAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrFloatAttrFieldInfo
instance AttrInfo AttrFloatAttrFieldInfo where
    type AttrBaseTypeConstraint AttrFloatAttrFieldInfo = (~) AttrFloat
    type AttrAllowedOps AttrFloatAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrFloatAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrFloatAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrFloatAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrFloatAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrFloatAttrFieldInfo = "attr"
    type AttrOrigin AttrFloatAttrFieldInfo = AttrFloat
    attrGet = getAttrFloatAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFloat.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFloat.html#g:attr:attr"
        })

attrFloat_attr :: AttrLabelProxy "attr"
attrFloat_attr = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFloat #value
-- @
getAttrFloatValue :: MonadIO m => AttrFloat -> m Double
getAttrFloatValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrFloat [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrFloatValue :: MonadIO m => AttrFloat -> Double -> m ()
setAttrFloatValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data AttrFloatValueFieldInfo
instance AttrInfo AttrFloatValueFieldInfo where
    type AttrBaseTypeConstraint AttrFloatValueFieldInfo = (~) AttrFloat
    type AttrAllowedOps AttrFloatValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttrFloatValueFieldInfo = (~) Double
    type AttrTransferTypeConstraint AttrFloatValueFieldInfo = (~)Double
    type AttrTransferType AttrFloatValueFieldInfo = Double
    type AttrGetType AttrFloatValueFieldInfo = Double
    type AttrLabel AttrFloatValueFieldInfo = "value"
    type AttrOrigin AttrFloatValueFieldInfo = AttrFloat
    attrGet = getAttrFloatValue
    attrSet = setAttrFloatValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFloat.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFloat.html#g:attr:value"
        })

attrFloat_value :: AttrLabelProxy "value"
attrFloat_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrFloat
type instance O.AttributeList AttrFloat = AttrFloatAttributeList
type AttrFloatAttributeList = ('[ '("attr", AttrFloatAttrFieldInfo), '("value", AttrFloatValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrFloatMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrFloatMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrFloatMethod t AttrFloat, O.OverloadedMethod info AttrFloat p) => OL.IsLabel t (AttrFloat -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrFloatMethod t AttrFloat, O.OverloadedMethod info AttrFloat p, R.HasField t AttrFloat p) => R.HasField t AttrFloat p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrFloatMethod t AttrFloat, O.OverloadedMethodInfo info AttrFloat) => OL.IsLabel t (O.MethodProxy info AttrFloat) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


