{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Simd4F
    ( 

-- * Exported types
    Simd4F(..)                              ,
    newZeroSimd4F                           ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSimd4FMethod                     ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Simd4F = Simd4F (SP.ManagedPtr Simd4F)
    deriving (Eq)

instance SP.ManagedPtrNewtype Simd4F where
    toManagedPtr (Simd4F p) = p

instance BoxedPtr Simd4F where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr Simd4F)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Simd4F where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'Simd4F' struct initialized to zero.
newZeroSimd4F :: MonadIO m => m Simd4F
newZeroSimd4F = liftIO $ boxedPtrCalloc >>= wrapPtr Simd4F

instance tag ~ 'AttrSet => Constructible Simd4F tag where
    new _ attrs = do
        o <- newZeroSimd4F
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Simd4F
type instance O.AttributeList Simd4F = Simd4FAttributeList
type Simd4FAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSimd4FMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimd4FMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimd4FMethod t Simd4F, O.OverloadedMethod info Simd4F p) => OL.IsLabel t (Simd4F -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimd4FMethod t Simd4F, O.OverloadedMethod info Simd4F p, R.HasField t Simd4F p) => R.HasField t Simd4F p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimd4FMethod t Simd4F, O.OverloadedMethodInfo info Simd4F) => OL.IsLabel t (O.MethodProxy info Simd4F) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


