{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GParamSpec@ encapsulates the metadata required to specify parameters, such as @GObject@ properties.
-- 
-- == Parameter names
-- 
-- A property name consists of one or more segments consisting of ASCII letters
-- and digits, separated by either the @-@ or @_@ character. The first
-- character of a property name must be a letter. These are the same rules as
-- for signal naming (see @/GObject.signal_new/@).
-- 
-- When creating and looking up a @GParamSpec@, either separator can be
-- used, but they cannot be mixed. Using @-@ is considerably more
-- efficient, and is the ‘canonical form’. Using @_@ is discouraged.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Objects.ParamSpec
    ( 

-- * Exported types
    ParamSpec(..)                           ,
    IsParamSpec                             ,
    toParamSpec                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [sink]("GI.GObject.Objects.ParamSpec#g:method:sink"), [stealQdata]("GI.GObject.Objects.ParamSpec#g:method:stealQdata").
-- 
-- ==== Getters
-- [getBlurb]("GI.GObject.Objects.ParamSpec#g:method:getBlurb"), [getDefaultValue]("GI.GObject.Objects.ParamSpec#g:method:getDefaultValue"), [getName]("GI.GObject.Objects.ParamSpec#g:method:getName"), [getNameQuark]("GI.GObject.Objects.ParamSpec#g:method:getNameQuark"), [getNick]("GI.GObject.Objects.ParamSpec#g:method:getNick"), [getQdata]("GI.GObject.Objects.ParamSpec#g:method:getQdata"), [getRedirectTarget]("GI.GObject.Objects.ParamSpec#g:method:getRedirectTarget").
-- 
-- ==== Setters
-- [setQdata]("GI.GObject.Objects.ParamSpec#g:method:setQdata").

#if defined(ENABLE_OVERLOADING)
    ResolveParamSpecMethod                  ,
#endif

-- ** getBlurb #method:getBlurb#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetBlurbMethodInfo             ,
#endif
    paramSpecGetBlurb                       ,


-- ** getDefaultValue #method:getDefaultValue#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetDefaultValueMethodInfo      ,
#endif
    paramSpecGetDefaultValue                ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetNameMethodInfo              ,
#endif
    paramSpecGetName                        ,


-- ** getNameQuark #method:getNameQuark#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetNameQuarkMethodInfo         ,
#endif
    paramSpecGetNameQuark                   ,


-- ** getNick #method:getNick#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetNickMethodInfo              ,
#endif
    paramSpecGetNick                        ,


-- ** getQdata #method:getQdata#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetQdataMethodInfo             ,
#endif
    paramSpecGetQdata                       ,


-- ** getRedirectTarget #method:getRedirectTarget#

#if defined(ENABLE_OVERLOADING)
    ParamSpecGetRedirectTargetMethodInfo    ,
#endif
    paramSpecGetRedirectTarget              ,


-- ** isValidName #method:isValidName#

    paramSpecIsValidName                    ,


-- ** setQdata #method:setQdata#

#if defined(ENABLE_OVERLOADING)
    ParamSpecSetQdataMethodInfo             ,
#endif
    paramSpecSetQdata                       ,


-- ** sink #method:sink#

#if defined(ENABLE_OVERLOADING)
    ParamSpecSinkMethodInfo                 ,
#endif
    paramSpecSink                           ,


-- ** stealQdata #method:stealQdata#

#if defined(ENABLE_OVERLOADING)
    ParamSpecStealQdataMethodInfo           ,
#endif
    paramSpecStealQdata                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype ParamSpec = ParamSpec (SP.ManagedPtr ParamSpec)
    deriving (Eq)

instance SP.ManagedPtrNewtype ParamSpec where
    toManagedPtr (ParamSpec p) = p

foreign import ccall "haskell_gi_pspec_type_init_ParamSpec"
    c_haskell_gi_pspec_type_init_ParamSpec :: IO B.Types.GType

instance B.Types.TypedObject ParamSpec where
    glibType = c_haskell_gi_pspec_type_init_ParamSpec

-- | Type class for types which can be safely cast to t'ParamSpec', for instance with `toParamSpec`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ParamSpec o) => IsParamSpec o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ParamSpec o) => IsParamSpec o

instance O.HasParentTypes ParamSpec
type instance O.ParentTypes ParamSpec = '[]

-- | Cast to t'ParamSpec', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toParamSpec :: (MIO.MonadIO m, IsParamSpec o) => o -> m ParamSpec
toParamSpec = MIO.liftIO . B.ManagedPtr.unsafeCastTo ParamSpec

foreign import ccall "g_value_get_param" gv_get_g_value_get_param ::
    FP.Ptr B.GValue.GValue -> IO (FP.Ptr ParamSpec)

foreign import ccall "g_value_set_param" gv_set_g_value_set_param ::
    FP.Ptr B.GValue.GValue -> FP.Ptr ParamSpec -> IO ()

-- | Convert t'ParamSpec' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ParamSpec) where
    gvalueGType_ = c_haskell_gi_pspec_type_init_ParamSpec
    gvalueSet_ gv P.Nothing = gv_set_g_value_set_param gv (FP.nullPtr :: FP.Ptr ParamSpec)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (gv_set_g_value_set_param gv)
    gvalueGet_ gv = do
        ptr <- gv_get_g_value_get_param gv :: IO (FP.Ptr ParamSpec)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newPtr ParamSpec ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveParamSpecMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveParamSpecMethod "sink" o = ParamSpecSinkMethodInfo
    ResolveParamSpecMethod "stealQdata" o = ParamSpecStealQdataMethodInfo
    ResolveParamSpecMethod "getBlurb" o = ParamSpecGetBlurbMethodInfo
    ResolveParamSpecMethod "getDefaultValue" o = ParamSpecGetDefaultValueMethodInfo
    ResolveParamSpecMethod "getName" o = ParamSpecGetNameMethodInfo
    ResolveParamSpecMethod "getNameQuark" o = ParamSpecGetNameQuarkMethodInfo
    ResolveParamSpecMethod "getNick" o = ParamSpecGetNickMethodInfo
    ResolveParamSpecMethod "getQdata" o = ParamSpecGetQdataMethodInfo
    ResolveParamSpecMethod "getRedirectTarget" o = ParamSpecGetRedirectTargetMethodInfo
    ResolveParamSpecMethod "setQdata" o = ParamSpecSetQdataMethodInfo
    ResolveParamSpecMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveParamSpecMethod t ParamSpec, O.OverloadedMethod info ParamSpec p) => OL.IsLabel t (ParamSpec -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveParamSpecMethod t ParamSpec, O.OverloadedMethod info ParamSpec p, R.HasField t ParamSpec p) => R.HasField t ParamSpec p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveParamSpecMethod t ParamSpec, O.OverloadedMethodInfo info ParamSpec) => OL.IsLabel t (O.MethodProxy info ParamSpec) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

foreign import ccall "g_param_spec_ref_sink" _ParamSpec_copy_g_param_spec_ref_sink :: Ptr a -> IO (Ptr a)

foreign import ccall "g_param_spec_unref" _ParamSpec_free_g_param_spec_unref :: Ptr a -> IO ()

instance BoxedPtr ParamSpec where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (_ParamSpec_copy_g_param_spec_ref_sink >=> B.ManagedPtr.wrapPtr ParamSpec)
    boxedPtrFree = \p -> B.ManagedPtr.withManagedPtr p _ParamSpec_free_g_param_spec_unref


-- method ParamSpec::get_blurb
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_blurb" g_param_spec_get_blurb :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO CString

-- | Get the short description of a t'GI.GObject.Objects.ParamSpec.ParamSpec'.
paramSpecGetBlurb ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the short description of /@pspec@/.
paramSpecGetBlurb pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_blurb pspec'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr pspec
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetBlurbMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m) => O.OverloadedMethod ParamSpecGetBlurbMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetBlurb

instance O.OverloadedMethodInfo ParamSpecGetBlurbMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetBlurb",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetBlurb"
        })


#endif

-- method ParamSpec::get_default_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GParamSpec" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TGValue
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_default_value" g_param_spec_get_default_value :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO (Ptr GValue)

-- | Gets the default value of /@pspec@/ as a pointer to a t'GI.GObject.Structs.Value.Value'.
-- 
-- The t'GI.GObject.Structs.Value.Value' will remain valid for the life of /@pspec@/.
-- 
-- /Since: 2.38/
paramSpecGetDefaultValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m GValue
    -- ^ __Returns:__ a pointer to a t'GI.GObject.Structs.Value.Value' which must not be modified
paramSpecGetDefaultValue pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_default_value pspec'
    checkUnexpectedReturnNULL "paramSpecGetDefaultValue" result
    result' <- B.GValue.newGValueFromPtr result
    touchManagedPtr pspec
    return result'

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetDefaultValueMethodInfo
instance (signature ~ (m GValue), MonadIO m) => O.OverloadedMethod ParamSpecGetDefaultValueMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetDefaultValue

instance O.OverloadedMethodInfo ParamSpecGetDefaultValueMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetDefaultValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetDefaultValue"
        })


#endif

-- method ParamSpec::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_name" g_param_spec_get_name :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO CString

-- | Get the name of a t'GI.GObject.Objects.ParamSpec.ParamSpec'.
-- 
-- The name is always an \"interned\" string (as per 'GI.GLib.Functions.internString').
-- This allows for pointer-value comparisons.
paramSpecGetName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m T.Text
    -- ^ __Returns:__ the name of /@pspec@/.
paramSpecGetName pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_name pspec'
    checkUnexpectedReturnNULL "paramSpecGetName" result
    result' <- cstringToText result
    touchManagedPtr pspec
    return result'

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod ParamSpecGetNameMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetName

instance O.OverloadedMethodInfo ParamSpecGetNameMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetName"
        })


#endif

-- method ParamSpec::get_name_quark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GParamSpec" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_name_quark" g_param_spec_get_name_quark :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO Word32

-- | Gets the GQuark for the name.
-- 
-- /Since: 2.46/
paramSpecGetNameQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m Word32
    -- ^ __Returns:__ the GQuark for /@pspec@/->name.
paramSpecGetNameQuark pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_name_quark pspec'
    touchManagedPtr pspec
    return result

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetNameQuarkMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod ParamSpecGetNameQuarkMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetNameQuark

instance O.OverloadedMethodInfo ParamSpecGetNameQuarkMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetNameQuark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetNameQuark"
        })


#endif

-- method ParamSpec::get_nick
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_nick" g_param_spec_get_nick :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO CString

-- | Get the nickname of a t'GI.GObject.Objects.ParamSpec.ParamSpec'.
paramSpecGetNick ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m T.Text
    -- ^ __Returns:__ the nickname of /@pspec@/.
paramSpecGetNick pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_nick pspec'
    checkUnexpectedReturnNULL "paramSpecGetNick" result
    result' <- cstringToText result
    touchManagedPtr pspec
    return result'

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetNickMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod ParamSpecGetNickMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetNick

instance O.OverloadedMethodInfo ParamSpecGetNickMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetNick",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetNick"
        })


#endif

-- method ParamSpec::get_qdata
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark, naming the user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_qdata" g_param_spec_get_qdata :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Word32 ->                               -- quark : TBasicType TUInt32
    IO (Ptr ())

-- | Gets back user data pointers stored via 'GI.GObject.Objects.ParamSpec.paramSpecSetQdata'.
paramSpecGetQdata ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> Word32
    -- ^ /@quark@/: a @/GQuark/@, naming the user data pointer
    -> m (Ptr ())
    -- ^ __Returns:__ the user data pointer set, or 'P.Nothing'
paramSpecGetQdata pspec quark = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_qdata pspec' quark
    touchManagedPtr pspec
    return result

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetQdataMethodInfo
instance (signature ~ (Word32 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod ParamSpecGetQdataMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetQdata

instance O.OverloadedMethodInfo ParamSpecGetQdataMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetQdata",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetQdata"
        })


#endif

-- method ParamSpec::get_redirect_target
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GParamSpec" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TParamSpec
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_get_redirect_target" g_param_spec_get_redirect_target :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO (Ptr GParamSpec)

-- | If the paramspec redirects operations to another paramspec,
-- returns that paramspec. Redirect is used typically for
-- providing a new implementation of a property in a derived
-- type while preserving all the properties from the parent
-- type. Redirection is established by creating a property
-- of type t'GI.GObject.Objects.ParamSpecOverride.ParamSpecOverride'. See 'GI.GObject.Structs.ObjectClass.objectClassOverrideProperty'
-- for an example of the use of this capability.
-- 
-- /Since: 2.4/
paramSpecGetRedirectTarget ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m (Maybe GParamSpec)
    -- ^ __Returns:__ paramspec to which requests on this
    --          paramspec should be redirected, or 'P.Nothing' if none.
paramSpecGetRedirectTarget pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_get_redirect_target pspec'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GParamSpec.newGParamSpecFromPtr result'
        return result''
    touchManagedPtr pspec
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ParamSpecGetRedirectTargetMethodInfo
instance (signature ~ (m (Maybe GParamSpec)), MonadIO m) => O.OverloadedMethod ParamSpecGetRedirectTargetMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecGetRedirectTarget

instance O.OverloadedMethodInfo ParamSpecGetRedirectTargetMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecGetRedirectTarget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecGetRedirectTarget"
        })


#endif

-- method ParamSpec::set_qdata
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GParamSpec to set store a user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark, naming the user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an opaque user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_set_qdata" g_param_spec_set_qdata :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Word32 ->                               -- quark : TBasicType TUInt32
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Sets an opaque, named pointer on a t'GI.GObject.Objects.ParamSpec.ParamSpec'. The name is
-- specified through a @/GQuark/@ (retrieved e.g. via
-- 'GI.GLib.Functions.quarkFromStaticString'), and the pointer can be gotten back
-- from the /@pspec@/ with 'GI.GObject.Objects.ParamSpec.paramSpecGetQdata'.  Setting a
-- previously set user data pointer, overrides (frees) the old pointer
-- set, using 'P.Nothing' as pointer essentially removes the data stored.
paramSpecSetQdata ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' to set store a user data pointer
    -> Word32
    -- ^ /@quark@/: a @/GQuark/@, naming the user data pointer
    -> Ptr ()
    -- ^ /@data@/: an opaque user data pointer
    -> m ()
paramSpecSetQdata pspec quark data_ = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    g_param_spec_set_qdata pspec' quark data_
    touchManagedPtr pspec
    return ()

#if defined(ENABLE_OVERLOADING)
data ParamSpecSetQdataMethodInfo
instance (signature ~ (Word32 -> Ptr () -> m ()), MonadIO m) => O.OverloadedMethod ParamSpecSetQdataMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecSetQdata

instance O.OverloadedMethodInfo ParamSpecSetQdataMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecSetQdata",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecSetQdata"
        })


#endif

-- method ParamSpec::sink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GParamSpec"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_sink" g_param_spec_sink :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    IO ()

-- | The initial reference count of a newly created t'GI.GObject.Objects.ParamSpec.ParamSpec' is 1,
-- even though no one has explicitly called @/g_param_spec_ref()/@ on it
-- yet. So the initial reference count is flagged as \"floating\", until
-- someone calls @g_param_spec_ref (pspec); g_param_spec_sink
-- (pspec);@ in sequence on it, taking over the initial
-- reference count (thus ending up with a /@pspec@/ that has a reference
-- count of 1 still, but is not flagged \"floating\" anymore).
paramSpecSink ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: a valid t'GI.GObject.Objects.ParamSpec.ParamSpec'
    -> m ()
paramSpecSink pspec = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    g_param_spec_sink pspec'
    touchManagedPtr pspec
    return ()

#if defined(ENABLE_OVERLOADING)
data ParamSpecSinkMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ParamSpecSinkMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecSink

instance O.OverloadedMethodInfo ParamSpecSinkMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecSink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecSink"
        })


#endif

-- method ParamSpec::steal_qdata
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pspec"
--           , argType = TParamSpec
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GParamSpec to get a stored user data pointer from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "quark"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GQuark, naming the user data pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_steal_qdata" g_param_spec_steal_qdata :: 
    Ptr GParamSpec ->                       -- pspec : TParamSpec
    Word32 ->                               -- quark : TBasicType TUInt32
    IO (Ptr ())

-- | Gets back user data pointers stored via 'GI.GObject.Objects.ParamSpec.paramSpecSetQdata'
-- and removes the /@data@/ from /@pspec@/ without invoking its @/destroy()/@
-- function (if any was set).  Usually, calling this function is only
-- required to update user data pointers with a destroy notifier.
paramSpecStealQdata ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GParamSpec
    -- ^ /@pspec@/: the t'GI.GObject.Objects.ParamSpec.ParamSpec' to get a stored user data pointer from
    -> Word32
    -- ^ /@quark@/: a @/GQuark/@, naming the user data pointer
    -> m (Ptr ())
    -- ^ __Returns:__ the user data pointer set, or 'P.Nothing'
paramSpecStealQdata pspec quark = liftIO $ do
    pspec' <- unsafeManagedPtrGetPtr pspec
    result <- g_param_spec_steal_qdata pspec' quark
    touchManagedPtr pspec
    return result

#if defined(ENABLE_OVERLOADING)
data ParamSpecStealQdataMethodInfo
instance (signature ~ (Word32 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod ParamSpecStealQdataMethodInfo GParamSpec signature where
    overloadedMethod = paramSpecStealQdata

instance O.OverloadedMethodInfo ParamSpecStealQdataMethodInfo GParamSpec where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.ParamSpec.paramSpecStealQdata",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-ParamSpec.html#v:paramSpecStealQdata"
        })


#endif

-- method ParamSpec::is_valid_name
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the canonical name of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_param_spec_is_valid_name" g_param_spec_is_valid_name :: 
    CString ->                              -- name : TBasicType TUTF8
    IO CInt

-- | Validate a property name for a t'GI.GObject.Objects.ParamSpec.ParamSpec'. This can be useful for
-- dynamically-generated properties which need to be validated at run-time
-- before actually trying to create them.
-- 
-- See [canonical parameter names][class/@gObject@/.ParamSpec@/parameter/@-names]
-- for details of the rules for valid names.
-- 
-- /Since: 2.66/
paramSpecIsValidName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the canonical name of the property
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@name@/ is a valid property name, 'P.False' otherwise.
paramSpecIsValidName name = liftIO $ do
    name' <- textToCString name
    result <- g_param_spec_is_valid_name name'
    let result' = (/= 0) result
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


