{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure holding in-depth information for a specific signal.
-- 
-- See also: 'GI.GObject.Functions.signalQuery'

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Structs.SignalQuery
    ( 

-- * Exported types
    SignalQuery(..)                         ,
    newZeroSignalQuery                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveSignalQueryMethod                ,
#endif



 -- * Properties


-- ** itype #attr:itype#
-- | The interface\/instance type that this signal can be emitted for.

    getSignalQueryItype                     ,
    setSignalQueryItype                     ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_itype                       ,
#endif


-- ** nParams #attr:nParams#
-- | The number of parameters that user callbacks take.

    getSignalQueryNParams                   ,
    setSignalQueryNParams                   ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_nParams                     ,
#endif


-- ** returnType #attr:returnType#
-- | The return type for user callbacks.

    getSignalQueryReturnType                ,
    setSignalQueryReturnType                ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_returnType                  ,
#endif


-- ** signalFlags #attr:signalFlags#
-- | The signal flags as passed in to @/g_signal_new()/@.

    getSignalQuerySignalFlags               ,
    setSignalQuerySignalFlags               ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_signalFlags                 ,
#endif


-- ** signalId #attr:signalId#
-- | The signal id of the signal being queried, or 0 if the
--  signal to be queried was unknown.

    getSignalQuerySignalId                  ,
    setSignalQuerySignalId                  ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_signalId                    ,
#endif


-- ** signalName #attr:signalName#
-- | The signal name.

    clearSignalQuerySignalName              ,
    getSignalQuerySignalName                ,
    setSignalQuerySignalName                ,
#if defined(ENABLE_OVERLOADING)
    signalQuery_signalName                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#else
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags

#endif

-- | Memory-managed wrapper type.
newtype SignalQuery = SignalQuery (SP.ManagedPtr SignalQuery)
    deriving (Eq)

instance SP.ManagedPtrNewtype SignalQuery where
    toManagedPtr (SignalQuery p) = p

instance BoxedPtr SignalQuery where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr SignalQuery)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr SignalQuery where
    boxedPtrCalloc = callocBytes 56


-- | Construct a t'SignalQuery' struct initialized to zero.
newZeroSignalQuery :: MonadIO m => m SignalQuery
newZeroSignalQuery = liftIO $ boxedPtrCalloc >>= wrapPtr SignalQuery

instance tag ~ 'AttrSet => Constructible SignalQuery tag where
    new _ attrs = do
        o <- newZeroSignalQuery
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@signal_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #signalId
-- @
getSignalQuerySignalId :: MonadIO m => SignalQuery -> m Word32
getSignalQuerySignalId s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@signal_id@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #signalId 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQuerySignalId :: MonadIO m => SignalQuery -> Word32 -> m ()
setSignalQuerySignalId s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data SignalQuerySignalIdFieldInfo
instance AttrInfo SignalQuerySignalIdFieldInfo where
    type AttrBaseTypeConstraint SignalQuerySignalIdFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQuerySignalIdFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalQuerySignalIdFieldInfo = (~) Word32
    type AttrTransferTypeConstraint SignalQuerySignalIdFieldInfo = (~)Word32
    type AttrTransferType SignalQuerySignalIdFieldInfo = Word32
    type AttrGetType SignalQuerySignalIdFieldInfo = Word32
    type AttrLabel SignalQuerySignalIdFieldInfo = "signal_id"
    type AttrOrigin SignalQuerySignalIdFieldInfo = SignalQuery
    attrGet = getSignalQuerySignalId
    attrSet = setSignalQuerySignalId
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.signalId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:signalId"
        })

signalQuery_signalId :: AttrLabelProxy "signalId"
signalQuery_signalId = AttrLabelProxy

#endif


-- | Get the value of the “@signal_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #signalName
-- @
getSignalQuerySignalName :: MonadIO m => SignalQuery -> m (Maybe T.Text)
getSignalQuerySignalName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@signal_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #signalName 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQuerySignalName :: MonadIO m => SignalQuery -> CString -> m ()
setSignalQuerySignalName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@signal_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #signalName
-- @
clearSignalQuerySignalName :: MonadIO m => SignalQuery -> m ()
clearSignalQuerySignalName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data SignalQuerySignalNameFieldInfo
instance AttrInfo SignalQuerySignalNameFieldInfo where
    type AttrBaseTypeConstraint SignalQuerySignalNameFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQuerySignalNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint SignalQuerySignalNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint SignalQuerySignalNameFieldInfo = (~)CString
    type AttrTransferType SignalQuerySignalNameFieldInfo = CString
    type AttrGetType SignalQuerySignalNameFieldInfo = Maybe T.Text
    type AttrLabel SignalQuerySignalNameFieldInfo = "signal_name"
    type AttrOrigin SignalQuerySignalNameFieldInfo = SignalQuery
    attrGet = getSignalQuerySignalName
    attrSet = setSignalQuerySignalName
    attrConstruct = undefined
    attrClear = clearSignalQuerySignalName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.signalName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:signalName"
        })

signalQuery_signalName :: AttrLabelProxy "signalName"
signalQuery_signalName = AttrLabelProxy

#endif


-- | Get the value of the “@itype@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #itype
-- @
getSignalQueryItype :: MonadIO m => SignalQuery -> m GType
getSignalQueryItype s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CGType
    let val' = GType val
    return val'

-- | Set the value of the “@itype@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #itype 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQueryItype :: MonadIO m => SignalQuery -> GType -> m ()
setSignalQueryItype s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gtypeToCGType val
    poke (ptr `plusPtr` 16) (val' :: CGType)

#if defined(ENABLE_OVERLOADING)
data SignalQueryItypeFieldInfo
instance AttrInfo SignalQueryItypeFieldInfo where
    type AttrBaseTypeConstraint SignalQueryItypeFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQueryItypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalQueryItypeFieldInfo = (~) GType
    type AttrTransferTypeConstraint SignalQueryItypeFieldInfo = (~)GType
    type AttrTransferType SignalQueryItypeFieldInfo = GType
    type AttrGetType SignalQueryItypeFieldInfo = GType
    type AttrLabel SignalQueryItypeFieldInfo = "itype"
    type AttrOrigin SignalQueryItypeFieldInfo = SignalQuery
    attrGet = getSignalQueryItype
    attrSet = setSignalQueryItype
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.itype"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:itype"
        })

signalQuery_itype :: AttrLabelProxy "itype"
signalQuery_itype = AttrLabelProxy

#endif


-- | Get the value of the “@signal_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #signalFlags
-- @
getSignalQuerySignalFlags :: MonadIO m => SignalQuery -> m [GObject.Flags.SignalFlags]
getSignalQuerySignalFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@signal_flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #signalFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQuerySignalFlags :: MonadIO m => SignalQuery -> [GObject.Flags.SignalFlags] -> m ()
setSignalQuerySignalFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 24) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data SignalQuerySignalFlagsFieldInfo
instance AttrInfo SignalQuerySignalFlagsFieldInfo where
    type AttrBaseTypeConstraint SignalQuerySignalFlagsFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQuerySignalFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalQuerySignalFlagsFieldInfo = (~) [GObject.Flags.SignalFlags]
    type AttrTransferTypeConstraint SignalQuerySignalFlagsFieldInfo = (~)[GObject.Flags.SignalFlags]
    type AttrTransferType SignalQuerySignalFlagsFieldInfo = [GObject.Flags.SignalFlags]
    type AttrGetType SignalQuerySignalFlagsFieldInfo = [GObject.Flags.SignalFlags]
    type AttrLabel SignalQuerySignalFlagsFieldInfo = "signal_flags"
    type AttrOrigin SignalQuerySignalFlagsFieldInfo = SignalQuery
    attrGet = getSignalQuerySignalFlags
    attrSet = setSignalQuerySignalFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.signalFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:signalFlags"
        })

signalQuery_signalFlags :: AttrLabelProxy "signalFlags"
signalQuery_signalFlags = AttrLabelProxy

#endif


-- | Get the value of the “@return_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #returnType
-- @
getSignalQueryReturnType :: MonadIO m => SignalQuery -> m GType
getSignalQueryReturnType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CGType
    let val' = GType val
    return val'

-- | Set the value of the “@return_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #returnType 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQueryReturnType :: MonadIO m => SignalQuery -> GType -> m ()
setSignalQueryReturnType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gtypeToCGType val
    poke (ptr `plusPtr` 32) (val' :: CGType)

#if defined(ENABLE_OVERLOADING)
data SignalQueryReturnTypeFieldInfo
instance AttrInfo SignalQueryReturnTypeFieldInfo where
    type AttrBaseTypeConstraint SignalQueryReturnTypeFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQueryReturnTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalQueryReturnTypeFieldInfo = (~) GType
    type AttrTransferTypeConstraint SignalQueryReturnTypeFieldInfo = (~)GType
    type AttrTransferType SignalQueryReturnTypeFieldInfo = GType
    type AttrGetType SignalQueryReturnTypeFieldInfo = GType
    type AttrLabel SignalQueryReturnTypeFieldInfo = "return_type"
    type AttrOrigin SignalQueryReturnTypeFieldInfo = SignalQuery
    attrGet = getSignalQueryReturnType
    attrSet = setSignalQueryReturnType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.returnType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:returnType"
        })

signalQuery_returnType :: AttrLabelProxy "returnType"
signalQuery_returnType = AttrLabelProxy

#endif


-- | Get the value of the “@n_params@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalQuery #nParams
-- @
getSignalQueryNParams :: MonadIO m => SignalQuery -> m Word32
getSignalQueryNParams s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO Word32
    return val

-- | Set the value of the “@n_params@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalQuery [ #nParams 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalQueryNParams :: MonadIO m => SignalQuery -> Word32 -> m ()
setSignalQueryNParams s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data SignalQueryNParamsFieldInfo
instance AttrInfo SignalQueryNParamsFieldInfo where
    type AttrBaseTypeConstraint SignalQueryNParamsFieldInfo = (~) SignalQuery
    type AttrAllowedOps SignalQueryNParamsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint SignalQueryNParamsFieldInfo = (~) Word32
    type AttrTransferTypeConstraint SignalQueryNParamsFieldInfo = (~)Word32
    type AttrTransferType SignalQueryNParamsFieldInfo = Word32
    type AttrGetType SignalQueryNParamsFieldInfo = Word32
    type AttrLabel SignalQueryNParamsFieldInfo = "n_params"
    type AttrOrigin SignalQueryNParamsFieldInfo = SignalQuery
    attrGet = getSignalQueryNParams
    attrSet = setSignalQueryNParams
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Structs.SignalQuery.nParams"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Structs-SignalQuery.html#g:attr:nParams"
        })

signalQuery_nParams :: AttrLabelProxy "nParams"
signalQuery_nParams = AttrLabelProxy

#endif


-- XXX Skipped attribute for "SignalQuery:param_types"
-- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 5 (TBasicType TGType)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SignalQuery
type instance O.AttributeList SignalQuery = SignalQueryAttributeList
type SignalQueryAttributeList = ('[ '("signalId", SignalQuerySignalIdFieldInfo), '("signalName", SignalQuerySignalNameFieldInfo), '("itype", SignalQueryItypeFieldInfo), '("signalFlags", SignalQuerySignalFlagsFieldInfo), '("returnType", SignalQueryReturnTypeFieldInfo), '("nParams", SignalQueryNParamsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSignalQueryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSignalQueryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSignalQueryMethod t SignalQuery, O.OverloadedMethod info SignalQuery p) => OL.IsLabel t (SignalQuery -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSignalQueryMethod t SignalQuery, O.OverloadedMethod info SignalQuery p, R.HasField t SignalQuery p) => R.HasField t SignalQuery p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSignalQueryMethod t SignalQuery, O.OverloadedMethodInfo info SignalQuery) => OL.IsLabel t (O.MethodProxy info SignalQuery) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


