{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSignalGroup@ manages a collection of signals on a @GObject@.
-- 
-- @GSignalGroup@ simplifies the process of connecting  many signals to a @GObject@
-- as a group. As such there is no API to disconnect a signal from the group.
-- 
-- In particular, this allows you to:
-- 
-- * Change the target instance, which automatically causes disconnection
--   of the signals from the old instance and connecting to the new instance.
-- * Block and unblock signals as a group
-- * Ensuring that blocked state transfers across target instances.
-- 
-- 
-- One place you might want to use such a structure is with @GtkTextView@ and
-- @GtkTextBuffer@. Often times, you\'ll need to connect to many signals on
-- @GtkTextBuffer@ from a @GtkTextView@ subclass. This allows you to create a
-- signal group during instance construction, simply bind the
-- @GtkTextView:buffer@ property to @GSignalGroup:target@ and connect
-- all the signals you need. When the @GtkTextView:buffer@ property changes
-- all of the signals will be transitioned correctly.
-- 
-- /Since: 2.72/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GObject.Objects.SignalGroup
    ( 

-- * Exported types
    SignalGroup(..)                         ,
    IsSignalGroup                           ,
    toSignalGroup                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [block]("GI.GObject.Objects.SignalGroup#g:method:block"), [connectClosure]("GI.GObject.Objects.SignalGroup#g:method:connectClosure"), [connectData]("GI.GObject.Objects.SignalGroup#g:method:connectData"), [connectSwapped]("GI.GObject.Objects.SignalGroup#g:method:connectSwapped"), [dupTarget]("GI.GObject.Objects.SignalGroup#g:method:dupTarget"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unblock]("GI.GObject.Objects.SignalGroup#g:method:unblock"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTarget]("GI.GObject.Objects.SignalGroup#g:method:setTarget").

#if defined(ENABLE_OVERLOADING)
    ResolveSignalGroupMethod                ,
#endif

-- ** block #method:block#

#if defined(ENABLE_OVERLOADING)
    SignalGroupBlockMethodInfo              ,
#endif
    signalGroupBlock                        ,


-- ** connectClosure #method:connectClosure#

#if defined(ENABLE_OVERLOADING)
    SignalGroupConnectClosureMethodInfo     ,
#endif
    signalGroupConnectClosure               ,


-- ** connectData #method:connectData#

#if defined(ENABLE_OVERLOADING)
    SignalGroupConnectDataMethodInfo        ,
#endif
    signalGroupConnectData                  ,


-- ** connectSwapped #method:connectSwapped#

#if defined(ENABLE_OVERLOADING)
    SignalGroupConnectSwappedMethodInfo     ,
#endif
    signalGroupConnectSwapped               ,


-- ** dupTarget #method:dupTarget#

#if defined(ENABLE_OVERLOADING)
    SignalGroupDupTargetMethodInfo          ,
#endif
    signalGroupDupTarget                    ,


-- ** new #method:new#

    signalGroupNew                          ,


-- ** setTarget #method:setTarget#

#if defined(ENABLE_OVERLOADING)
    SignalGroupSetTargetMethodInfo          ,
#endif
    signalGroupSetTarget                    ,


-- ** unblock #method:unblock#

#if defined(ENABLE_OVERLOADING)
    SignalGroupUnblockMethodInfo            ,
#endif
    signalGroupUnblock                      ,




 -- * Properties


-- ** target #attr:target#
-- | The target instance used when connecting signals.
-- 
-- /Since: 2.72/

#if defined(ENABLE_OVERLOADING)
    SignalGroupTargetPropertyInfo           ,
#endif
    clearSignalGroupTarget                  ,
    constructSignalGroupTarget              ,
    getSignalGroupTarget                    ,
    setSignalGroupTarget                    ,
#if defined(ENABLE_OVERLOADING)
    signalGroupTarget                       ,
#endif


-- ** targetType #attr:targetType#
-- | The t'GType' of the target property.
-- 
-- /Since: 2.72/

#if defined(ENABLE_OVERLOADING)
    SignalGroupTargetTypePropertyInfo       ,
#endif
    constructSignalGroupTargetType          ,
    getSignalGroupTargetType                ,
#if defined(ENABLE_OVERLOADING)
    signalGroupTargetType                   ,
#endif




 -- * Signals


-- ** bind #signal:bind#

    SignalGroupBindCallback                 ,
#if defined(ENABLE_OVERLOADING)
    SignalGroupBindSignalInfo               ,
#endif
    afterSignalGroupBind                    ,
    onSignalGroupBind                       ,


-- ** unbind #signal:unbind#

    SignalGroupUnbindCallback               ,
#if defined(ENABLE_OVERLOADING)
    SignalGroupUnbindSignalInfo             ,
#endif
    afterSignalGroupUnbind                  ,
    onSignalGroupUnbind                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Interfaces.TypePlugin as GObject.TypePlugin
import {-# SOURCE #-} qualified GI.GObject.Objects.Binding as GObject.Binding
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GObject.Structs.InterfaceInfo as GObject.InterfaceInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeClass as GObject.TypeClass
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInfo as GObject.TypeInfo
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeInterface as GObject.TypeInterface
import {-# SOURCE #-} qualified GI.GObject.Structs.TypeValueTable as GObject.TypeValueTable

#else
import qualified GI.GObject.Callbacks as GObject.Callbacks
import {-# SOURCE #-} qualified GI.GObject.Flags as GObject.Flags
import {-# SOURCE #-} qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype SignalGroup = SignalGroup (SP.ManagedPtr SignalGroup)
    deriving (Eq)

instance SP.ManagedPtrNewtype SignalGroup where
    toManagedPtr (SignalGroup p) = p

foreign import ccall "g_signal_group_get_type"
    c_g_signal_group_get_type :: IO B.Types.GType

instance B.Types.TypedObject SignalGroup where
    glibType = c_g_signal_group_get_type

instance B.Types.GObject SignalGroup

-- | Type class for types which can be safely cast to t'SignalGroup', for instance with `toSignalGroup`.
class (SP.GObject o, O.IsDescendantOf SignalGroup o) => IsSignalGroup o
instance (SP.GObject o, O.IsDescendantOf SignalGroup o) => IsSignalGroup o

instance O.HasParentTypes SignalGroup
type instance O.ParentTypes SignalGroup = '[GObject.Object.Object]

-- | Cast to t'SignalGroup', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSignalGroup :: (MIO.MonadIO m, IsSignalGroup o) => o -> m SignalGroup
toSignalGroup = MIO.liftIO . B.ManagedPtr.unsafeCastTo SignalGroup

-- | Convert t'SignalGroup' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SignalGroup) where
    gvalueGType_ = c_g_signal_group_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SignalGroup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SignalGroup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SignalGroup ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSignalGroupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSignalGroupMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSignalGroupMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSignalGroupMethod "block" o = SignalGroupBlockMethodInfo
    ResolveSignalGroupMethod "connectClosure" o = SignalGroupConnectClosureMethodInfo
    ResolveSignalGroupMethod "connectData" o = SignalGroupConnectDataMethodInfo
    ResolveSignalGroupMethod "connectSwapped" o = SignalGroupConnectSwappedMethodInfo
    ResolveSignalGroupMethod "dupTarget" o = SignalGroupDupTargetMethodInfo
    ResolveSignalGroupMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSignalGroupMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSignalGroupMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSignalGroupMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSignalGroupMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSignalGroupMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSignalGroupMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSignalGroupMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSignalGroupMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSignalGroupMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSignalGroupMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSignalGroupMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSignalGroupMethod "unblock" o = SignalGroupUnblockMethodInfo
    ResolveSignalGroupMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSignalGroupMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSignalGroupMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSignalGroupMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSignalGroupMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSignalGroupMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSignalGroupMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSignalGroupMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSignalGroupMethod "setTarget" o = SignalGroupSetTargetMethodInfo
    ResolveSignalGroupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSignalGroupMethod t SignalGroup, O.OverloadedMethod info SignalGroup p) => OL.IsLabel t (SignalGroup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSignalGroupMethod t SignalGroup, O.OverloadedMethod info SignalGroup p, R.HasField t SignalGroup p) => R.HasField t SignalGroup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSignalGroupMethod t SignalGroup, O.OverloadedMethodInfo info SignalGroup) => OL.IsLabel t (O.MethodProxy info SignalGroup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SignalGroup::bind
-- | This signal is emitted when [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target") is set to a new value
-- other than 'P.Nothing'. It is similar to [Object::notify]("GI.GObject.Objects.Object#g:signal:notify") on @target@ except it
-- will not emit when [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target") is 'P.Nothing' and also allows for
-- receiving the t'GI.GObject.Objects.Object.Object' without a data-race.
-- 
-- /Since: 2.72/
type SignalGroupBindCallback =
    GObject.Object.Object
    -- ^ /@instance@/: a t'GI.GObject.Objects.Object.Object' containing the new value for [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target")
    -> IO ()

type C_SignalGroupBindCallback =
    Ptr SignalGroup ->                      -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalGroupBindCallback`.
foreign import ccall "wrapper"
    mk_SignalGroupBindCallback :: C_SignalGroupBindCallback -> IO (FunPtr C_SignalGroupBindCallback)

wrap_SignalGroupBindCallback :: 
    GObject a => (a -> SignalGroupBindCallback) ->
    C_SignalGroupBindCallback
wrap_SignalGroupBindCallback gi'cb gi'selfPtr instance_ _ = do
    instance_' <- (newObject GObject.Object.Object) instance_
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  instance_'


-- | Connect a signal handler for the [bind](#signal:bind) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalGroup #bind callback
-- @
-- 
-- 
onSignalGroupBind :: (IsSignalGroup a, MonadIO m) => a -> ((?self :: a) => SignalGroupBindCallback) -> m SignalHandlerId
onSignalGroupBind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalGroupBindCallback wrapped
    wrapped'' <- mk_SignalGroupBindCallback wrapped'
    connectSignalFunPtr obj "bind" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [bind](#signal:bind) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalGroup #bind callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalGroupBind :: (IsSignalGroup a, MonadIO m) => a -> ((?self :: a) => SignalGroupBindCallback) -> m SignalHandlerId
afterSignalGroupBind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalGroupBindCallback wrapped
    wrapped'' <- mk_SignalGroupBindCallback wrapped'
    connectSignalFunPtr obj "bind" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalGroupBindSignalInfo
instance SignalInfo SignalGroupBindSignalInfo where
    type HaskellCallbackType SignalGroupBindSignalInfo = SignalGroupBindCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalGroupBindCallback cb
        cb'' <- mk_SignalGroupBindCallback cb'
        connectSignalFunPtr obj "bind" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup::bind"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#g:signal:bind"})

#endif

-- signal SignalGroup::unbind
-- | This signal is emitted when the target instance of /@self@/ is set to a
-- new t'GI.GObject.Objects.Object.Object'.
-- 
-- This signal will only be emitted if the previous target of /@self@/ is
-- non-'P.Nothing'.
-- 
-- /Since: 2.72/
type SignalGroupUnbindCallback =
    IO ()

type C_SignalGroupUnbindCallback =
    Ptr SignalGroup ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalGroupUnbindCallback`.
foreign import ccall "wrapper"
    mk_SignalGroupUnbindCallback :: C_SignalGroupUnbindCallback -> IO (FunPtr C_SignalGroupUnbindCallback)

wrap_SignalGroupUnbindCallback :: 
    GObject a => (a -> SignalGroupUnbindCallback) ->
    C_SignalGroupUnbindCallback
wrap_SignalGroupUnbindCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [unbind](#signal:unbind) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalGroup #unbind callback
-- @
-- 
-- 
onSignalGroupUnbind :: (IsSignalGroup a, MonadIO m) => a -> ((?self :: a) => SignalGroupUnbindCallback) -> m SignalHandlerId
onSignalGroupUnbind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalGroupUnbindCallback wrapped
    wrapped'' <- mk_SignalGroupUnbindCallback wrapped'
    connectSignalFunPtr obj "unbind" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unbind](#signal:unbind) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalGroup #unbind callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalGroupUnbind :: (IsSignalGroup a, MonadIO m) => a -> ((?self :: a) => SignalGroupUnbindCallback) -> m SignalHandlerId
afterSignalGroupUnbind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalGroupUnbindCallback wrapped
    wrapped'' <- mk_SignalGroupUnbindCallback wrapped'
    connectSignalFunPtr obj "unbind" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalGroupUnbindSignalInfo
instance SignalInfo SignalGroupUnbindSignalInfo where
    type HaskellCallbackType SignalGroupUnbindSignalInfo = SignalGroupUnbindCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalGroupUnbindCallback cb
        cb'' <- mk_SignalGroupUnbindCallback cb'
        connectSignalFunPtr obj "unbind" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup::unbind"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#g:signal:unbind"})

#endif

-- VVV Prop "target"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@target@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalGroup #target
-- @
getSignalGroupTarget :: (MonadIO m, IsSignalGroup o) => o -> m (Maybe GObject.Object.Object)
getSignalGroupTarget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "target" GObject.Object.Object

-- | Set the value of the “@target@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' signalGroup [ #target 'Data.GI.Base.Attributes.:=' value ]
-- @
setSignalGroupTarget :: (MonadIO m, IsSignalGroup o, GObject.Object.IsObject a) => o -> a -> m ()
setSignalGroupTarget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "target" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@target@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSignalGroupTarget :: (IsSignalGroup o, MIO.MonadIO m, GObject.Object.IsObject a) => a -> m (GValueConstruct o)
constructSignalGroupTarget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "target" (P.Just val)

-- | Set the value of the “@target@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #target
-- @
clearSignalGroupTarget :: (MonadIO m, IsSignalGroup o) => o -> m ()
clearSignalGroupTarget obj = liftIO $ B.Properties.setObjectPropertyObject obj "target" (Nothing :: Maybe GObject.Object.Object)

#if defined(ENABLE_OVERLOADING)
data SignalGroupTargetPropertyInfo
instance AttrInfo SignalGroupTargetPropertyInfo where
    type AttrAllowedOps SignalGroupTargetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SignalGroupTargetPropertyInfo = IsSignalGroup
    type AttrSetTypeConstraint SignalGroupTargetPropertyInfo = GObject.Object.IsObject
    type AttrTransferTypeConstraint SignalGroupTargetPropertyInfo = GObject.Object.IsObject
    type AttrTransferType SignalGroupTargetPropertyInfo = GObject.Object.Object
    type AttrGetType SignalGroupTargetPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel SignalGroupTargetPropertyInfo = "target"
    type AttrOrigin SignalGroupTargetPropertyInfo = SignalGroup
    attrGet = getSignalGroupTarget
    attrSet = setSignalGroupTarget
    attrTransfer _ v = do
        unsafeCastTo GObject.Object.Object v
    attrConstruct = constructSignalGroupTarget
    attrClear = clearSignalGroupTarget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.target"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#g:attr:target"
        })
#endif

-- VVV Prop "target-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@target-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalGroup #targetType
-- @
getSignalGroupTargetType :: (MonadIO m, IsSignalGroup o) => o -> m GType
getSignalGroupTargetType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "target-type"

-- | Construct a t'GValueConstruct' with valid value for the “@target-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSignalGroupTargetType :: (IsSignalGroup o, MIO.MonadIO m) => GType -> m (GValueConstruct o)
constructSignalGroupTargetType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyGType "target-type" val

#if defined(ENABLE_OVERLOADING)
data SignalGroupTargetTypePropertyInfo
instance AttrInfo SignalGroupTargetTypePropertyInfo where
    type AttrAllowedOps SignalGroupTargetTypePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SignalGroupTargetTypePropertyInfo = IsSignalGroup
    type AttrSetTypeConstraint SignalGroupTargetTypePropertyInfo = (~) GType
    type AttrTransferTypeConstraint SignalGroupTargetTypePropertyInfo = (~) GType
    type AttrTransferType SignalGroupTargetTypePropertyInfo = GType
    type AttrGetType SignalGroupTargetTypePropertyInfo = GType
    type AttrLabel SignalGroupTargetTypePropertyInfo = "target-type"
    type AttrOrigin SignalGroupTargetTypePropertyInfo = SignalGroup
    attrGet = getSignalGroupTargetType
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructSignalGroupTargetType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.targetType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#g:attr:targetType"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SignalGroup
type instance O.AttributeList SignalGroup = SignalGroupAttributeList
type SignalGroupAttributeList = ('[ '("target", SignalGroupTargetPropertyInfo), '("targetType", SignalGroupTargetTypePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
signalGroupTarget :: AttrLabelProxy "target"
signalGroupTarget = AttrLabelProxy

signalGroupTargetType :: AttrLabelProxy "targetType"
signalGroupTargetType = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SignalGroup = SignalGroupSignalList
type SignalGroupSignalList = ('[ '("bind", SignalGroupBindSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("unbind", SignalGroupUnbindSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SignalGroup::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "target_type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GType of the target instance."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GObject" , name = "SignalGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_new" g_signal_group_new :: 
    CGType ->                               -- target_type : TBasicType TGType
    IO (Ptr SignalGroup)

-- | Creates a new t'GI.GObject.Objects.SignalGroup.SignalGroup' for target instances of /@targetType@/.
-- 
-- /Since: 2.72/
signalGroupNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GType
    -- ^ /@targetType@/: the t'GType' of the target instance.
    -> m SignalGroup
    -- ^ __Returns:__ a new t'GI.GObject.Objects.SignalGroup.SignalGroup'
signalGroupNew targetType = liftIO $ do
    let targetType' = gtypeToCGType targetType
    result <- g_signal_group_new targetType'
    checkUnexpectedReturnNULL "signalGroupNew" result
    result' <- (wrapObject SignalGroup) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SignalGroup::block
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_block" g_signal_group_block :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    IO ()

-- | Blocks all signal handlers managed by /@self@/ so they will not
-- be called during any signal emissions. Must be unblocked exactly
-- the same number of times it has been blocked to become active again.
-- 
-- This blocked state will be kept across changes of the target instance.
-- 
-- /Since: 2.72/
signalGroupBlock ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: the t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> m ()
signalGroupBlock self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    g_signal_group_block self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupBlockMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupBlockMethodInfo a signature where
    overloadedMethod = signalGroupBlock

instance O.OverloadedMethodInfo SignalGroupBlockMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupBlock",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupBlock"
        })


#endif

-- method SignalGroup::connect_closure
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a string of the form `signal-name` with optional `::signal-detail`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the closure to connect."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "after"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether the handler should be called before or after the\n default handler of the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_connect_closure" g_signal_group_connect_closure :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    CString ->                              -- detailed_signal : TBasicType TUTF8
    Ptr (GClosure ()) ->                    -- closure : TGClosure Nothing
    CInt ->                                 -- after : TBasicType TBoolean
    IO ()

-- | Connects /@closure@/ to the signal /@detailedSignal@/ on [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target").
-- 
-- You cannot connect a signal handler after [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target") has been set.
-- 
-- /Since: 2.74/
signalGroupConnectClosure ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: a t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> T.Text
    -- ^ /@detailedSignal@/: a string of the form @signal-name@ with optional @::signal-detail@
    -> GClosure b
    -- ^ /@closure@/: the closure to connect.
    -> Bool
    -- ^ /@after@/: whether the handler should be called before or after the
    --  default handler of the signal.
    -> m ()
signalGroupConnectClosure self detailedSignal closure after = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    detailedSignal' <- textToCString detailedSignal
    closure' <- unsafeManagedPtrCastPtr closure
    let after' = (P.fromIntegral . P.fromEnum) after
    g_signal_group_connect_closure self' detailedSignal' closure' after'
    touchManagedPtr self
    touchManagedPtr closure
    freeMem detailedSignal'
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupConnectClosureMethodInfo
instance (signature ~ (T.Text -> GClosure b -> Bool -> m ()), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupConnectClosureMethodInfo a signature where
    overloadedMethod = signalGroupConnectClosure

instance O.OverloadedMethodInfo SignalGroupConnectClosureMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupConnectClosure",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupConnectClosure"
        })


#endif

-- method SignalGroup::connect_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string of the form \"signal-name::detail\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c_handler"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCallback to connect"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to @c_handler calls"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ClosureNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to be called when disposing of @self"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "ConnectFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the flags used to create the signal connection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_connect_data" g_signal_group_connect_data :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    CString ->                              -- detailed_signal : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- c_handler : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GObject.Callbacks.C_ClosureNotify -> -- notify : TInterface (Name {namespace = "GObject", name = "ClosureNotify"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GObject", name = "ConnectFlags"})
    IO ()

-- | Connects /@cHandler@/ to the signal /@detailedSignal@/
-- on the target instance of /@self@/.
-- 
-- You cannot connect a signal handler after [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target") has been set.
-- 
-- /Since: 2.72/
signalGroupConnectData ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: a t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> T.Text
    -- ^ /@detailedSignal@/: a string of the form \"signal-name[detail](#g:signal:detail)\"
    -> GObject.Callbacks.Callback
    -- ^ /@cHandler@/: the t'GI.GObject.Callbacks.Callback' to connect
    -> [GObject.Flags.ConnectFlags]
    -- ^ /@flags@/: the flags used to create the signal connection
    -> m ()
signalGroupConnectData self detailedSignal cHandler flags = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    detailedSignal' <- textToCString detailedSignal
    cHandler' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback Nothing cHandler)
    let flags' = gflagsToWord flags
    let data_ = castFunPtrToPtr cHandler'
    let notify = SP.safeFreeFunPtrPtr'
    g_signal_group_connect_data self' detailedSignal' cHandler' data_ notify flags'
    touchManagedPtr self
    freeMem detailedSignal'
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupConnectDataMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> [GObject.Flags.ConnectFlags] -> m ()), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupConnectDataMethodInfo a signature where
    overloadedMethod = signalGroupConnectData

instance O.OverloadedMethodInfo SignalGroupConnectDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupConnectData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupConnectData"
        })


#endif

-- method SignalGroup::connect_swapped
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_signal"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string of the form \"signal-name::detail\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "c_handler"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCallback to connect"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to @c_handler calls"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_connect_swapped" g_signal_group_connect_swapped :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    CString ->                              -- detailed_signal : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- c_handler : TInterface (Name {namespace = "GObject", name = "Callback"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Connects /@cHandler@/ to the signal /@detailedSignal@/
-- on the target instance of /@self@/.
-- 
-- The instance on which the signal is emitted and /@data@/
-- will be swapped when calling /@cHandler@/.
-- 
-- You cannot connect a signal handler after [SignalGroup:target]("GI.GObject.Objects.SignalGroup#g:attr:target") has been set.
-- 
-- /Since: 2.72/
signalGroupConnectSwapped ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: a t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> T.Text
    -- ^ /@detailedSignal@/: a string of the form \"signal-name[detail](#g:signal:detail)\"
    -> GObject.Callbacks.Callback
    -- ^ /@cHandler@/: the t'GI.GObject.Callbacks.Callback' to connect
    -> m ()
signalGroupConnectSwapped self detailedSignal cHandler = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    detailedSignal' <- textToCString detailedSignal
    ptrcHandler <- callocMem :: IO (Ptr (FunPtr GObject.Callbacks.C_Callback))
    cHandler' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback (Just ptrcHandler) cHandler)
    poke ptrcHandler cHandler'
    let data_ = nullPtr
    g_signal_group_connect_swapped self' detailedSignal' cHandler' data_
    touchManagedPtr self
    freeMem detailedSignal'
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupConnectSwappedMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> m ()), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupConnectSwappedMethodInfo a signature where
    overloadedMethod = signalGroupConnectSwapped

instance O.OverloadedMethodInfo SignalGroupConnectSwappedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupConnectSwapped",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupConnectSwapped"
        })


#endif

-- method SignalGroup::dup_target
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_dup_target" g_signal_group_dup_target :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    IO (Ptr GObject.Object.Object)

-- | Gets the target instance used when connecting signals.
-- 
-- /Since: 2.72/
signalGroupDupTarget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: the t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The target instance
signalGroupDupTarget self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- g_signal_group_dup_target self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SignalGroupDupTargetMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupDupTargetMethodInfo a signature where
    overloadedMethod = signalGroupDupTarget

instance O.OverloadedMethodInfo SignalGroupDupTargetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupDupTarget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupDupTarget"
        })


#endif

-- method SignalGroup::set_target
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSignalGroup." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The target instance used\n    when connecting signals."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_set_target" g_signal_group_set_target :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    Ptr GObject.Object.Object ->            -- target : TInterface (Name {namespace = "GObject", name = "Object"})
    IO ()

-- | Sets the target instance used when connecting signals. Any signal
-- that has been registered with @/g_signal_group_connect_object()/@ or
-- similar functions will be connected to this object.
-- 
-- If the target instance was previously set, signals will be
-- disconnected from that object prior to connecting to /@target@/.
-- 
-- /Since: 2.72/
signalGroupSetTarget ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a, GObject.Object.IsObject b) =>
    a
    -- ^ /@self@/: the t'GI.GObject.Objects.SignalGroup.SignalGroup'.
    -> Maybe (b)
    -- ^ /@target@/: The target instance used
    --     when connecting signals.
    -> m ()
signalGroupSetTarget self target = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeTarget <- case target of
        Nothing -> return FP.nullPtr
        Just jTarget -> do
            jTarget' <- unsafeManagedPtrCastPtr jTarget
            return jTarget'
    g_signal_group_set_target self' maybeTarget
    touchManagedPtr self
    whenJust target touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupSetTargetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSignalGroup a, GObject.Object.IsObject b) => O.OverloadedMethod SignalGroupSetTargetMethodInfo a signature where
    overloadedMethod = signalGroupSetTarget

instance O.OverloadedMethodInfo SignalGroupSetTargetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupSetTarget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupSetTarget"
        })


#endif

-- method SignalGroup::unblock
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "SignalGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSignalGroup" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_signal_group_unblock" g_signal_group_unblock :: 
    Ptr SignalGroup ->                      -- self : TInterface (Name {namespace = "GObject", name = "SignalGroup"})
    IO ()

-- | Unblocks all signal handlers managed by /@self@/ so they will be
-- called again during any signal emissions unless it is blocked
-- again. Must be unblocked exactly the same number of times it
-- has been blocked to become active again.
-- 
-- /Since: 2.72/
signalGroupUnblock ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalGroup a) =>
    a
    -- ^ /@self@/: the t'GI.GObject.Objects.SignalGroup.SignalGroup'
    -> m ()
signalGroupUnblock self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    g_signal_group_unblock self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SignalGroupUnblockMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSignalGroup a) => O.OverloadedMethod SignalGroupUnblockMethodInfo a signature where
    overloadedMethod = signalGroupUnblock

instance O.OverloadedMethodInfo SignalGroupUnblockMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GObject.Objects.SignalGroup.signalGroupUnblock",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gobject-2.0.31/docs/GI-GObject-Objects-SignalGroup.html#v:signalGroupUnblock"
        })


#endif


