{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Structure used for scatter\/gather data output.
-- You generally pass in an array of @/GOutputVectors/@
-- and the operation will use all the buffers as if they were
-- one buffer.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.OutputVector
    ( 

-- * Exported types
    OutputVector(..)                        ,
    newZeroOutputVector                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOutputVectorMethod               ,
#endif



 -- * Properties


-- ** buffer #attr:buffer#
-- | Pointer to a buffer of data to read.

    clearOutputVectorBuffer                 ,
    getOutputVectorBuffer                   ,
#if defined(ENABLE_OVERLOADING)
    outputVector_buffer                     ,
#endif
    setOutputVectorBuffer                   ,


-- ** size #attr:size#
-- | the size of /@buffer@/.

    getOutputVectorSize                     ,
#if defined(ENABLE_OVERLOADING)
    outputVector_size                       ,
#endif
    setOutputVectorSize                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype OutputVector = OutputVector (SP.ManagedPtr OutputVector)
    deriving (Eq)

instance SP.ManagedPtrNewtype OutputVector where
    toManagedPtr (OutputVector p) = p

instance BoxedPtr OutputVector where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr OutputVector)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OutputVector where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'OutputVector' struct initialized to zero.
newZeroOutputVector :: MonadIO m => m OutputVector
newZeroOutputVector = liftIO $ boxedPtrCalloc >>= wrapPtr OutputVector

instance tag ~ 'AttrSet => Constructible OutputVector tag where
    new _ attrs = do
        o <- newZeroOutputVector
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@buffer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputVector #buffer
-- @
getOutputVectorBuffer :: MonadIO m => OutputVector -> m (Ptr ())
getOutputVectorBuffer s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@buffer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputVector [ #buffer 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputVectorBuffer :: MonadIO m => OutputVector -> Ptr () -> m ()
setOutputVectorBuffer s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@buffer@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #buffer
-- @
clearOutputVectorBuffer :: MonadIO m => OutputVector -> m ()
clearOutputVectorBuffer s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data OutputVectorBufferFieldInfo
instance AttrInfo OutputVectorBufferFieldInfo where
    type AttrBaseTypeConstraint OutputVectorBufferFieldInfo = (~) OutputVector
    type AttrAllowedOps OutputVectorBufferFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint OutputVectorBufferFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint OutputVectorBufferFieldInfo = (~)(Ptr ())
    type AttrTransferType OutputVectorBufferFieldInfo = (Ptr ())
    type AttrGetType OutputVectorBufferFieldInfo = Ptr ()
    type AttrLabel OutputVectorBufferFieldInfo = "buffer"
    type AttrOrigin OutputVectorBufferFieldInfo = OutputVector
    attrGet = getOutputVectorBuffer
    attrSet = setOutputVectorBuffer
    attrConstruct = undefined
    attrClear = clearOutputVectorBuffer
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputVector.buffer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-OutputVector.html#g:attr:buffer"
        })

outputVector_buffer :: AttrLabelProxy "buffer"
outputVector_buffer = AttrLabelProxy

#endif


-- | Get the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' outputVector #size
-- @
getOutputVectorSize :: MonadIO m => OutputVector -> m FCT.CSize
getOutputVectorSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO FCT.CSize
    return val

-- | Set the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' outputVector [ #size 'Data.GI.Base.Attributes.:=' value ]
-- @
setOutputVectorSize :: MonadIO m => OutputVector -> FCT.CSize -> m ()
setOutputVectorSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data OutputVectorSizeFieldInfo
instance AttrInfo OutputVectorSizeFieldInfo where
    type AttrBaseTypeConstraint OutputVectorSizeFieldInfo = (~) OutputVector
    type AttrAllowedOps OutputVectorSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OutputVectorSizeFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint OutputVectorSizeFieldInfo = (~)FCT.CSize
    type AttrTransferType OutputVectorSizeFieldInfo = FCT.CSize
    type AttrGetType OutputVectorSizeFieldInfo = FCT.CSize
    type AttrLabel OutputVectorSizeFieldInfo = "size"
    type AttrOrigin OutputVectorSizeFieldInfo = OutputVector
    attrGet = getOutputVectorSize
    attrSet = setOutputVectorSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.OutputVector.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-OutputVector.html#g:attr:size"
        })

outputVector_size :: AttrLabelProxy "size"
outputVector_size = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OutputVector
type instance O.AttributeList OutputVector = OutputVectorAttributeList
type OutputVectorAttributeList = ('[ '("buffer", OutputVectorBufferFieldInfo), '("size", OutputVectorSizeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOutputVectorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOutputVectorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOutputVectorMethod t OutputVector, O.OverloadedMethod info OutputVector p) => OL.IsLabel t (OutputVector -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOutputVectorMethod t OutputVector, O.OverloadedMethod info OutputVector p, R.HasField t OutputVector p) => R.HasField t OutputVector p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOutputVectorMethod t OutputVector, O.OverloadedMethodInfo info OutputVector) => OL.IsLabel t (O.MethodProxy info OutputVector) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


