{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSocketAddressEnumerator@ is an enumerator type for
-- t'GI.Gio.Objects.SocketAddress.SocketAddress' instances. It is returned by enumeration functions
-- such as 'GI.Gio.Interfaces.SocketConnectable.socketConnectableEnumerate', which returns a
-- @GSocketAddressEnumerator@ to list each t'GI.Gio.Objects.SocketAddress.SocketAddress' which could
-- be used to connect to that t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable'.
-- 
-- Enumeration is typically a blocking operation, so the asynchronous methods
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextAsync' and
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextFinish' should be used where
-- possible.
-- 
-- Each @GSocketAddressEnumerator@ can only be enumerated once. Once
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNext' has returned @NULL@, further
-- enumeration with that @GSocketAddressEnumerator@ is not possible, and it can
-- be unreffed.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketAddressEnumerator
    ( 

-- * Exported types
    SocketAddressEnumerator(..)             ,
    IsSocketAddressEnumerator               ,
    toSocketAddressEnumerator               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [next]("GI.Gio.Objects.SocketAddressEnumerator#g:method:next"), [nextAsync]("GI.Gio.Objects.SocketAddressEnumerator#g:method:nextAsync"), [nextFinish]("GI.Gio.Objects.SocketAddressEnumerator#g:method:nextFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketAddressEnumeratorMethod    ,
#endif

-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    SocketAddressEnumeratorNextMethodInfo   ,
#endif
    socketAddressEnumeratorNext             ,


-- ** nextAsync #method:nextAsync#

#if defined(ENABLE_OVERLOADING)
    SocketAddressEnumeratorNextAsyncMethodInfo,
#endif
    socketAddressEnumeratorNextAsync        ,


-- ** nextFinish #method:nextFinish#

#if defined(ENABLE_OVERLOADING)
    SocketAddressEnumeratorNextFinishMethodInfo,
#endif
    socketAddressEnumeratorNextFinish       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#endif

-- | Memory-managed wrapper type.
newtype SocketAddressEnumerator = SocketAddressEnumerator (SP.ManagedPtr SocketAddressEnumerator)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketAddressEnumerator where
    toManagedPtr (SocketAddressEnumerator p) = p

foreign import ccall "g_socket_address_enumerator_get_type"
    c_g_socket_address_enumerator_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketAddressEnumerator where
    glibType = c_g_socket_address_enumerator_get_type

instance B.Types.GObject SocketAddressEnumerator

-- | Type class for types which can be safely cast to t'SocketAddressEnumerator', for instance with `toSocketAddressEnumerator`.
class (SP.GObject o, O.IsDescendantOf SocketAddressEnumerator o) => IsSocketAddressEnumerator o
instance (SP.GObject o, O.IsDescendantOf SocketAddressEnumerator o) => IsSocketAddressEnumerator o

instance O.HasParentTypes SocketAddressEnumerator
type instance O.ParentTypes SocketAddressEnumerator = '[GObject.Object.Object]

-- | Cast to t'SocketAddressEnumerator', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSocketAddressEnumerator :: (MIO.MonadIO m, IsSocketAddressEnumerator o) => o -> m SocketAddressEnumerator
toSocketAddressEnumerator = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketAddressEnumerator

-- | Convert t'SocketAddressEnumerator' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketAddressEnumerator) where
    gvalueGType_ = c_g_socket_address_enumerator_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketAddressEnumerator)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketAddressEnumerator)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketAddressEnumerator ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketAddressEnumeratorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketAddressEnumeratorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketAddressEnumeratorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketAddressEnumeratorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketAddressEnumeratorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketAddressEnumeratorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketAddressEnumeratorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketAddressEnumeratorMethod "next" o = SocketAddressEnumeratorNextMethodInfo
    ResolveSocketAddressEnumeratorMethod "nextAsync" o = SocketAddressEnumeratorNextAsyncMethodInfo
    ResolveSocketAddressEnumeratorMethod "nextFinish" o = SocketAddressEnumeratorNextFinishMethodInfo
    ResolveSocketAddressEnumeratorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketAddressEnumeratorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketAddressEnumeratorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketAddressEnumeratorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketAddressEnumeratorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketAddressEnumeratorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketAddressEnumeratorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketAddressEnumeratorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketAddressEnumeratorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketAddressEnumeratorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketAddressEnumeratorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketAddressEnumeratorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketAddressEnumeratorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketAddressEnumeratorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketAddressEnumeratorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketAddressEnumeratorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketAddressEnumeratorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketAddressEnumeratorMethod t SocketAddressEnumerator, O.OverloadedMethod info SocketAddressEnumerator p) => OL.IsLabel t (SocketAddressEnumerator -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketAddressEnumeratorMethod t SocketAddressEnumerator, O.OverloadedMethod info SocketAddressEnumerator p, R.HasField t SocketAddressEnumerator p) => R.HasField t SocketAddressEnumerator p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketAddressEnumeratorMethod t SocketAddressEnumerator, O.OverloadedMethodInfo info SocketAddressEnumerator) => OL.IsLabel t (O.MethodProxy info SocketAddressEnumerator) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketAddressEnumerator
type instance O.AttributeList SocketAddressEnumerator = SocketAddressEnumeratorAttributeList
type SocketAddressEnumeratorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketAddressEnumerator = SocketAddressEnumeratorSignalList
type SocketAddressEnumeratorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketAddressEnumerator::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketAddressEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddressEnumerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketAddress" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_address_enumerator_next" g_socket_address_enumerator_next :: 
    Ptr SocketAddressEnumerator ->          -- enumerator : TInterface (Name {namespace = "Gio", name = "SocketAddressEnumerator"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketAddress.SocketAddress)

-- | Retrieves the next t'GI.Gio.Objects.SocketAddress.SocketAddress' from /@enumerator@/. Note that this
-- may block for some amount of time. (Eg, a t'GI.Gio.Objects.NetworkAddress.NetworkAddress' may need
-- to do a DNS lookup before it can return an address.) Use
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextAsync' if you need to avoid
-- blocking.
-- 
-- If /@enumerator@/ is expected to yield addresses, but for some reason
-- is unable to (eg, because of a DNS error), then the first call to
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNext' will return an appropriate error
-- in @*error@. However, if the first call to
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNext' succeeds, then any further
-- internal errors (other than /@cancellable@/ being triggered) will be
-- ignored.
socketAddressEnumeratorNext ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddressEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m (Maybe Gio.SocketAddress.SocketAddress)
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketAddress.SocketAddress' (owned by the caller), or 'P.Nothing' on
    --     error (in which case @*error@ will be set) or if there are no
    --     more addresses. /(Can throw 'Data.GI.Base.GError.GError')/
socketAddressEnumeratorNext enumerator cancellable = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_address_enumerator_next enumerator' maybeCancellable
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject Gio.SocketAddress.SocketAddress) result'
            return result''
        touchManagedPtr enumerator
        whenJust cancellable touchManagedPtr
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketAddressEnumeratorNextMethodInfo
instance (signature ~ (Maybe (b) -> m (Maybe Gio.SocketAddress.SocketAddress)), MonadIO m, IsSocketAddressEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketAddressEnumeratorNextMethodInfo a signature where
    overloadedMethod = socketAddressEnumeratorNext

instance O.OverloadedMethodInfo SocketAddressEnumeratorNextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddressEnumerator.html#v:socketAddressEnumeratorNext"
        })


#endif

-- method SocketAddressEnumerator::next_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketAddressEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddressEnumerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback to call\n  when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_address_enumerator_next_async" g_socket_address_enumerator_next_async :: 
    Ptr SocketAddressEnumerator ->          -- enumerator : TInterface (Name {namespace = "Gio", name = "SocketAddressEnumerator"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously retrieves the next t'GI.Gio.Objects.SocketAddress.SocketAddress' from /@enumerator@/
-- and then calls /@callback@/, which must call
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextFinish' to get the result.
-- 
-- It is an error to call this multiple times before the previous callback has finished.
socketAddressEnumeratorNextAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddressEnumerator a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback' to call
    --   when the request is satisfied
    -> m ()
socketAddressEnumeratorNextAsync enumerator cancellable callback = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_address_enumerator_next_async enumerator' maybeCancellable maybeCallback userData
    touchManagedPtr enumerator
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketAddressEnumeratorNextAsyncMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketAddressEnumerator a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketAddressEnumeratorNextAsyncMethodInfo a signature where
    overloadedMethod = socketAddressEnumeratorNextAsync

instance O.OverloadedMethodInfo SocketAddressEnumeratorNextAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddressEnumerator.html#v:socketAddressEnumeratorNextAsync"
        })


#endif

-- method SocketAddressEnumerator::next_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "enumerator"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "SocketAddressEnumerator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddressEnumerator"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketAddress" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_address_enumerator_next_finish" g_socket_address_enumerator_next_finish :: 
    Ptr SocketAddressEnumerator ->          -- enumerator : TInterface (Name {namespace = "Gio", name = "SocketAddressEnumerator"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketAddress.SocketAddress)

-- | Retrieves the result of a completed call to
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextAsync'. See
-- 'GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNext' for more information about
-- error handling.
socketAddressEnumeratorNextFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddressEnumerator a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@enumerator@/: a t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
    -> m (Maybe Gio.SocketAddress.SocketAddress)
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketAddress.SocketAddress' (owned by the caller), or 'P.Nothing' on
    --     error (in which case @*error@ will be set) or if there are no
    --     more addresses. /(Can throw 'Data.GI.Base.GError.GError')/
socketAddressEnumeratorNextFinish enumerator result_ = liftIO $ do
    enumerator' <- unsafeManagedPtrCastPtr enumerator
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_socket_address_enumerator_next_finish enumerator' result_'
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject Gio.SocketAddress.SocketAddress) result'
            return result''
        touchManagedPtr enumerator
        touchManagedPtr result_
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketAddressEnumeratorNextFinishMethodInfo
instance (signature ~ (b -> m (Maybe Gio.SocketAddress.SocketAddress)), MonadIO m, IsSocketAddressEnumerator a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketAddressEnumeratorNextFinishMethodInfo a signature where
    overloadedMethod = socketAddressEnumeratorNextFinish

instance O.OverloadedMethodInfo SocketAddressEnumeratorNextFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddressEnumerator.socketAddressEnumeratorNextFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddressEnumerator.html#v:socketAddressEnumeratorNextFinish"
        })


#endif


