{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GProxyAddressEnumerator@ is a wrapper around
-- t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator' which takes the t'GI.Gio.Objects.SocketAddress.SocketAddress'
-- instances returned by the t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator'
-- and wraps them in t'GI.Gio.Objects.ProxyAddress.ProxyAddress' instances, using the given
-- [ProxyAddressEnumerator:proxyResolver]("GI.Gio.Objects.ProxyAddressEnumerator#g:attr:proxyResolver").
-- 
-- This enumerator will be returned (for example, by
-- 'GI.Gio.Interfaces.SocketConnectable.socketConnectableEnumerate') as appropriate when a proxy is
-- configured; there should be no need to manually wrap a
-- t'GI.Gio.Objects.SocketAddressEnumerator.SocketAddressEnumerator' instance with one.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ProxyAddressEnumerator
    ( 

-- * Exported types
    ProxyAddressEnumerator(..)              ,
    IsProxyAddressEnumerator                ,
    toProxyAddressEnumerator                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [next]("GI.Gio.Objects.SocketAddressEnumerator#g:method:next"), [nextAsync]("GI.Gio.Objects.SocketAddressEnumerator#g:method:nextAsync"), [nextFinish]("GI.Gio.Objects.SocketAddressEnumerator#g:method:nextFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveProxyAddressEnumeratorMethod     ,
#endif



 -- * Properties


-- ** connectable #attr:connectable#
-- | The connectable being enumerated.

#if defined(ENABLE_OVERLOADING)
    ProxyAddressEnumeratorConnectablePropertyInfo,
#endif
    constructProxyAddressEnumeratorConnectable,
    getProxyAddressEnumeratorConnectable    ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressEnumeratorConnectable       ,
#endif


-- ** defaultPort #attr:defaultPort#
-- | The default port to use if [ProxyAddressEnumerator:uri]("GI.Gio.Objects.ProxyAddressEnumerator#g:attr:uri") does not
-- specify one.
-- 
-- /Since: 2.38/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressEnumeratorDefaultPortPropertyInfo,
#endif
    constructProxyAddressEnumeratorDefaultPort,
    getProxyAddressEnumeratorDefaultPort    ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressEnumeratorDefaultPort       ,
#endif


-- ** proxyResolver #attr:proxyResolver#
-- | The proxy resolver to use.
-- 
-- /Since: 2.36/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressEnumeratorProxyResolverPropertyInfo,
#endif
    clearProxyAddressEnumeratorProxyResolver,
    constructProxyAddressEnumeratorProxyResolver,
    getProxyAddressEnumeratorProxyResolver  ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressEnumeratorProxyResolver     ,
#endif
    setProxyAddressEnumeratorProxyResolver  ,


-- ** uri #attr:uri#
-- | The destination URI. Use @none:\/\/@ for a generic socket.

#if defined(ENABLE_OVERLOADING)
    ProxyAddressEnumeratorUriPropertyInfo   ,
#endif
    constructProxyAddressEnumeratorUri      ,
    getProxyAddressEnumeratorUri            ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressEnumeratorUri               ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#endif

-- | Memory-managed wrapper type.
newtype ProxyAddressEnumerator = ProxyAddressEnumerator (SP.ManagedPtr ProxyAddressEnumerator)
    deriving (Eq)

instance SP.ManagedPtrNewtype ProxyAddressEnumerator where
    toManagedPtr (ProxyAddressEnumerator p) = p

foreign import ccall "g_proxy_address_enumerator_get_type"
    c_g_proxy_address_enumerator_get_type :: IO B.Types.GType

instance B.Types.TypedObject ProxyAddressEnumerator where
    glibType = c_g_proxy_address_enumerator_get_type

instance B.Types.GObject ProxyAddressEnumerator

-- | Type class for types which can be safely cast to t'ProxyAddressEnumerator', for instance with `toProxyAddressEnumerator`.
class (SP.GObject o, O.IsDescendantOf ProxyAddressEnumerator o) => IsProxyAddressEnumerator o
instance (SP.GObject o, O.IsDescendantOf ProxyAddressEnumerator o) => IsProxyAddressEnumerator o

instance O.HasParentTypes ProxyAddressEnumerator
type instance O.ParentTypes ProxyAddressEnumerator = '[Gio.SocketAddressEnumerator.SocketAddressEnumerator, GObject.Object.Object]

-- | Cast to t'ProxyAddressEnumerator', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toProxyAddressEnumerator :: (MIO.MonadIO m, IsProxyAddressEnumerator o) => o -> m ProxyAddressEnumerator
toProxyAddressEnumerator = MIO.liftIO . B.ManagedPtr.unsafeCastTo ProxyAddressEnumerator

-- | Convert t'ProxyAddressEnumerator' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ProxyAddressEnumerator) where
    gvalueGType_ = c_g_proxy_address_enumerator_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ProxyAddressEnumerator)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ProxyAddressEnumerator)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ProxyAddressEnumerator ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveProxyAddressEnumeratorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveProxyAddressEnumeratorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveProxyAddressEnumeratorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveProxyAddressEnumeratorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveProxyAddressEnumeratorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveProxyAddressEnumeratorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveProxyAddressEnumeratorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveProxyAddressEnumeratorMethod "next" o = Gio.SocketAddressEnumerator.SocketAddressEnumeratorNextMethodInfo
    ResolveProxyAddressEnumeratorMethod "nextAsync" o = Gio.SocketAddressEnumerator.SocketAddressEnumeratorNextAsyncMethodInfo
    ResolveProxyAddressEnumeratorMethod "nextFinish" o = Gio.SocketAddressEnumerator.SocketAddressEnumeratorNextFinishMethodInfo
    ResolveProxyAddressEnumeratorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveProxyAddressEnumeratorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveProxyAddressEnumeratorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveProxyAddressEnumeratorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveProxyAddressEnumeratorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveProxyAddressEnumeratorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveProxyAddressEnumeratorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveProxyAddressEnumeratorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveProxyAddressEnumeratorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveProxyAddressEnumeratorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveProxyAddressEnumeratorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveProxyAddressEnumeratorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveProxyAddressEnumeratorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveProxyAddressEnumeratorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveProxyAddressEnumeratorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveProxyAddressEnumeratorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveProxyAddressEnumeratorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveProxyAddressEnumeratorMethod t ProxyAddressEnumerator, O.OverloadedMethod info ProxyAddressEnumerator p) => OL.IsLabel t (ProxyAddressEnumerator -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveProxyAddressEnumeratorMethod t ProxyAddressEnumerator, O.OverloadedMethod info ProxyAddressEnumerator p, R.HasField t ProxyAddressEnumerator p) => R.HasField t ProxyAddressEnumerator p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveProxyAddressEnumeratorMethod t ProxyAddressEnumerator, O.OverloadedMethodInfo info ProxyAddressEnumerator) => OL.IsLabel t (O.MethodProxy info ProxyAddressEnumerator) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "connectable"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@connectable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddressEnumerator #connectable
-- @
getProxyAddressEnumeratorConnectable :: (MonadIO m, IsProxyAddressEnumerator o) => o -> m (Maybe Gio.SocketConnectable.SocketConnectable)
getProxyAddressEnumeratorConnectable obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "connectable" Gio.SocketConnectable.SocketConnectable

-- | Construct a t'GValueConstruct' with valid value for the “@connectable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressEnumeratorConnectable :: (IsProxyAddressEnumerator o, MIO.MonadIO m, Gio.SocketConnectable.IsSocketConnectable a) => a -> m (GValueConstruct o)
constructProxyAddressEnumeratorConnectable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "connectable" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressEnumeratorConnectablePropertyInfo
instance AttrInfo ProxyAddressEnumeratorConnectablePropertyInfo where
    type AttrAllowedOps ProxyAddressEnumeratorConnectablePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressEnumeratorConnectablePropertyInfo = IsProxyAddressEnumerator
    type AttrSetTypeConstraint ProxyAddressEnumeratorConnectablePropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferTypeConstraint ProxyAddressEnumeratorConnectablePropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferType ProxyAddressEnumeratorConnectablePropertyInfo = Gio.SocketConnectable.SocketConnectable
    type AttrGetType ProxyAddressEnumeratorConnectablePropertyInfo = (Maybe Gio.SocketConnectable.SocketConnectable)
    type AttrLabel ProxyAddressEnumeratorConnectablePropertyInfo = "connectable"
    type AttrOrigin ProxyAddressEnumeratorConnectablePropertyInfo = ProxyAddressEnumerator
    attrGet = getProxyAddressEnumeratorConnectable
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.SocketConnectable.SocketConnectable v
    attrConstruct = constructProxyAddressEnumeratorConnectable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddressEnumerator.connectable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddressEnumerator.html#g:attr:connectable"
        })
#endif

-- VVV Prop "default-port"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@default-port@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddressEnumerator #defaultPort
-- @
getProxyAddressEnumeratorDefaultPort :: (MonadIO m, IsProxyAddressEnumerator o) => o -> m Word32
getProxyAddressEnumeratorDefaultPort obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "default-port"

-- | Construct a t'GValueConstruct' with valid value for the “@default-port@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressEnumeratorDefaultPort :: (IsProxyAddressEnumerator o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructProxyAddressEnumeratorDefaultPort val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "default-port" val

#if defined(ENABLE_OVERLOADING)
data ProxyAddressEnumeratorDefaultPortPropertyInfo
instance AttrInfo ProxyAddressEnumeratorDefaultPortPropertyInfo where
    type AttrAllowedOps ProxyAddressEnumeratorDefaultPortPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProxyAddressEnumeratorDefaultPortPropertyInfo = IsProxyAddressEnumerator
    type AttrSetTypeConstraint ProxyAddressEnumeratorDefaultPortPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint ProxyAddressEnumeratorDefaultPortPropertyInfo = (~) Word32
    type AttrTransferType ProxyAddressEnumeratorDefaultPortPropertyInfo = Word32
    type AttrGetType ProxyAddressEnumeratorDefaultPortPropertyInfo = Word32
    type AttrLabel ProxyAddressEnumeratorDefaultPortPropertyInfo = "default-port"
    type AttrOrigin ProxyAddressEnumeratorDefaultPortPropertyInfo = ProxyAddressEnumerator
    attrGet = getProxyAddressEnumeratorDefaultPort
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressEnumeratorDefaultPort
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddressEnumerator.defaultPort"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddressEnumerator.html#g:attr:defaultPort"
        })
#endif

-- VVV Prop "proxy-resolver"
   -- Type: TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@proxy-resolver@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddressEnumerator #proxyResolver
-- @
getProxyAddressEnumeratorProxyResolver :: (MonadIO m, IsProxyAddressEnumerator o) => o -> m (Maybe Gio.ProxyResolver.ProxyResolver)
getProxyAddressEnumeratorProxyResolver obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "proxy-resolver" Gio.ProxyResolver.ProxyResolver

-- | Set the value of the “@proxy-resolver@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' proxyAddressEnumerator [ #proxyResolver 'Data.GI.Base.Attributes.:=' value ]
-- @
setProxyAddressEnumeratorProxyResolver :: (MonadIO m, IsProxyAddressEnumerator o, Gio.ProxyResolver.IsProxyResolver a) => o -> a -> m ()
setProxyAddressEnumeratorProxyResolver obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "proxy-resolver" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@proxy-resolver@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressEnumeratorProxyResolver :: (IsProxyAddressEnumerator o, MIO.MonadIO m, Gio.ProxyResolver.IsProxyResolver a) => a -> m (GValueConstruct o)
constructProxyAddressEnumeratorProxyResolver val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "proxy-resolver" (P.Just val)

-- | Set the value of the “@proxy-resolver@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #proxyResolver
-- @
clearProxyAddressEnumeratorProxyResolver :: (MonadIO m, IsProxyAddressEnumerator o) => o -> m ()
clearProxyAddressEnumeratorProxyResolver obj = liftIO $ B.Properties.setObjectPropertyObject obj "proxy-resolver" (Nothing :: Maybe Gio.ProxyResolver.ProxyResolver)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressEnumeratorProxyResolverPropertyInfo
instance AttrInfo ProxyAddressEnumeratorProxyResolverPropertyInfo where
    type AttrAllowedOps ProxyAddressEnumeratorProxyResolverPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressEnumeratorProxyResolverPropertyInfo = IsProxyAddressEnumerator
    type AttrSetTypeConstraint ProxyAddressEnumeratorProxyResolverPropertyInfo = Gio.ProxyResolver.IsProxyResolver
    type AttrTransferTypeConstraint ProxyAddressEnumeratorProxyResolverPropertyInfo = Gio.ProxyResolver.IsProxyResolver
    type AttrTransferType ProxyAddressEnumeratorProxyResolverPropertyInfo = Gio.ProxyResolver.ProxyResolver
    type AttrGetType ProxyAddressEnumeratorProxyResolverPropertyInfo = (Maybe Gio.ProxyResolver.ProxyResolver)
    type AttrLabel ProxyAddressEnumeratorProxyResolverPropertyInfo = "proxy-resolver"
    type AttrOrigin ProxyAddressEnumeratorProxyResolverPropertyInfo = ProxyAddressEnumerator
    attrGet = getProxyAddressEnumeratorProxyResolver
    attrSet = setProxyAddressEnumeratorProxyResolver
    attrTransfer _ v = do
        unsafeCastTo Gio.ProxyResolver.ProxyResolver v
    attrConstruct = constructProxyAddressEnumeratorProxyResolver
    attrClear = clearProxyAddressEnumeratorProxyResolver
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddressEnumerator.proxyResolver"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddressEnumerator.html#g:attr:proxyResolver"
        })
#endif

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddressEnumerator #uri
-- @
getProxyAddressEnumeratorUri :: (MonadIO m, IsProxyAddressEnumerator o) => o -> m (Maybe T.Text)
getProxyAddressEnumeratorUri obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "uri"

-- | Construct a t'GValueConstruct' with valid value for the “@uri@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressEnumeratorUri :: (IsProxyAddressEnumerator o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressEnumeratorUri val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "uri" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressEnumeratorUriPropertyInfo
instance AttrInfo ProxyAddressEnumeratorUriPropertyInfo where
    type AttrAllowedOps ProxyAddressEnumeratorUriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressEnumeratorUriPropertyInfo = IsProxyAddressEnumerator
    type AttrSetTypeConstraint ProxyAddressEnumeratorUriPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressEnumeratorUriPropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressEnumeratorUriPropertyInfo = T.Text
    type AttrGetType ProxyAddressEnumeratorUriPropertyInfo = (Maybe T.Text)
    type AttrLabel ProxyAddressEnumeratorUriPropertyInfo = "uri"
    type AttrOrigin ProxyAddressEnumeratorUriPropertyInfo = ProxyAddressEnumerator
    attrGet = getProxyAddressEnumeratorUri
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressEnumeratorUri
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddressEnumerator.uri"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddressEnumerator.html#g:attr:uri"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ProxyAddressEnumerator
type instance O.AttributeList ProxyAddressEnumerator = ProxyAddressEnumeratorAttributeList
type ProxyAddressEnumeratorAttributeList = ('[ '("connectable", ProxyAddressEnumeratorConnectablePropertyInfo), '("defaultPort", ProxyAddressEnumeratorDefaultPortPropertyInfo), '("proxyResolver", ProxyAddressEnumeratorProxyResolverPropertyInfo), '("uri", ProxyAddressEnumeratorUriPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
proxyAddressEnumeratorConnectable :: AttrLabelProxy "connectable"
proxyAddressEnumeratorConnectable = AttrLabelProxy

proxyAddressEnumeratorDefaultPort :: AttrLabelProxy "defaultPort"
proxyAddressEnumeratorDefaultPort = AttrLabelProxy

proxyAddressEnumeratorProxyResolver :: AttrLabelProxy "proxyResolver"
proxyAddressEnumeratorProxyResolver = AttrLabelProxy

proxyAddressEnumeratorUri :: AttrLabelProxy "uri"
proxyAddressEnumeratorUri = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ProxyAddressEnumerator = ProxyAddressEnumeratorSignalList
type ProxyAddressEnumeratorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


