{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Objects.PixbufSimpleAnimIter
    ( 

-- * Exported types
    PixbufSimpleAnimIter(..)                ,
    IsPixbufSimpleAnimIter                  ,
    toPixbufSimpleAnimIter                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [advance]("GI.GdkPixbuf.Objects.PixbufAnimationIter#g:method:advance"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [onCurrentlyLoadingFrame]("GI.GdkPixbuf.Objects.PixbufAnimationIter#g:method:onCurrentlyLoadingFrame"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDelayTime]("GI.GdkPixbuf.Objects.PixbufAnimationIter#g:method:getDelayTime"), [getPixbuf]("GI.GdkPixbuf.Objects.PixbufAnimationIter#g:method:getPixbuf"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufSimpleAnimIterMethod       ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GdkPixbuf.Callbacks as GdkPixbuf.Callbacks
import {-# SOURCE #-} qualified GI.GdkPixbuf.Enums as GdkPixbuf.Enums
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter

#endif

-- | Memory-managed wrapper type.
newtype PixbufSimpleAnimIter = PixbufSimpleAnimIter (SP.ManagedPtr PixbufSimpleAnimIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufSimpleAnimIter where
    toManagedPtr (PixbufSimpleAnimIter p) = p

foreign import ccall "gdk_pixbuf_simple_anim_iter_get_type"
    c_gdk_pixbuf_simple_anim_iter_get_type :: IO B.Types.GType

instance B.Types.TypedObject PixbufSimpleAnimIter where
    glibType = c_gdk_pixbuf_simple_anim_iter_get_type

instance B.Types.GObject PixbufSimpleAnimIter

-- | Type class for types which can be safely cast to t'PixbufSimpleAnimIter', for instance with `toPixbufSimpleAnimIter`.
class (SP.GObject o, O.IsDescendantOf PixbufSimpleAnimIter o) => IsPixbufSimpleAnimIter o
instance (SP.GObject o, O.IsDescendantOf PixbufSimpleAnimIter o) => IsPixbufSimpleAnimIter o

instance O.HasParentTypes PixbufSimpleAnimIter
type instance O.ParentTypes PixbufSimpleAnimIter = '[GdkPixbuf.PixbufAnimationIter.PixbufAnimationIter, GObject.Object.Object]

-- | Cast to t'PixbufSimpleAnimIter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPixbufSimpleAnimIter :: (MIO.MonadIO m, IsPixbufSimpleAnimIter o) => o -> m PixbufSimpleAnimIter
toPixbufSimpleAnimIter = MIO.liftIO . B.ManagedPtr.unsafeCastTo PixbufSimpleAnimIter

-- | Convert t'PixbufSimpleAnimIter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PixbufSimpleAnimIter) where
    gvalueGType_ = c_gdk_pixbuf_simple_anim_iter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PixbufSimpleAnimIter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PixbufSimpleAnimIter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PixbufSimpleAnimIter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufSimpleAnimIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufSimpleAnimIterMethod "advance" o = GdkPixbuf.PixbufAnimationIter.PixbufAnimationIterAdvanceMethodInfo
    ResolvePixbufSimpleAnimIterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePixbufSimpleAnimIterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePixbufSimpleAnimIterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePixbufSimpleAnimIterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePixbufSimpleAnimIterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePixbufSimpleAnimIterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePixbufSimpleAnimIterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePixbufSimpleAnimIterMethod "onCurrentlyLoadingFrame" o = GdkPixbuf.PixbufAnimationIter.PixbufAnimationIterOnCurrentlyLoadingFrameMethodInfo
    ResolvePixbufSimpleAnimIterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePixbufSimpleAnimIterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePixbufSimpleAnimIterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePixbufSimpleAnimIterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePixbufSimpleAnimIterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePixbufSimpleAnimIterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePixbufSimpleAnimIterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePixbufSimpleAnimIterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getDelayTime" o = GdkPixbuf.PixbufAnimationIter.PixbufAnimationIterGetDelayTimeMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getPixbuf" o = GdkPixbuf.PixbufAnimationIter.PixbufAnimationIterGetPixbufMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePixbufSimpleAnimIterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePixbufSimpleAnimIterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePixbufSimpleAnimIterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePixbufSimpleAnimIterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePixbufSimpleAnimIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufSimpleAnimIterMethod t PixbufSimpleAnimIter, O.OverloadedMethod info PixbufSimpleAnimIter p) => OL.IsLabel t (PixbufSimpleAnimIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufSimpleAnimIterMethod t PixbufSimpleAnimIter, O.OverloadedMethod info PixbufSimpleAnimIter p, R.HasField t PixbufSimpleAnimIter p) => R.HasField t PixbufSimpleAnimIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufSimpleAnimIterMethod t PixbufSimpleAnimIter, O.OverloadedMethodInfo info PixbufSimpleAnimIter) => OL.IsLabel t (O.MethodProxy info PixbufSimpleAnimIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufSimpleAnimIter
type instance O.AttributeList PixbufSimpleAnimIter = PixbufSimpleAnimIterAttributeList
type PixbufSimpleAnimIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PixbufSimpleAnimIter = PixbufSimpleAnimIterSignalList
type PixbufSimpleAnimIterSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


