

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Flags
    ( 

 -- * Flags


-- ** AnchorHints #flag:AnchorHints#

    AnchorHints(..)                         ,


-- ** AxisFlags #flag:AxisFlags#

    AxisFlags(..)                           ,


-- ** DragAction #flag:DragAction#

    DragAction(..)                          ,


-- ** EventMask #flag:EventMask#

    EventMask(..)                           ,


-- ** FrameClockPhase #flag:FrameClockPhase#

    FrameClockPhase(..)                     ,


-- ** ModifierType #flag:ModifierType#

    ModifierType(..)                        ,


-- ** SeatCapabilities #flag:SeatCapabilities#

    SeatCapabilities(..)                    ,


-- ** WMDecoration #flag:WMDecoration#

    WMDecoration(..)                        ,


-- ** WMFunction #flag:WMFunction#

    WMFunction(..)                          ,


-- ** WindowAttributesType #flag:WindowAttributesType#

    WindowAttributesType(..)                ,


-- ** WindowHints #flag:WindowHints#

    WindowHints(..)                         ,


-- ** WindowState #flag:WindowState#

    WindowState(..)                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags WindowState
-- | Specifies the state of a toplevel window.
data WindowState = 
      WindowStateWithdrawn
    -- ^ the window is not shown.
    | WindowStateIconified
    -- ^ the window is minimized.
    | WindowStateMaximized
    -- ^ the window is maximized.
    | WindowStateSticky
    -- ^ the window is sticky.
    | WindowStateFullscreen
    -- ^ the window is maximized without
    --   decorations.
    | WindowStateAbove
    -- ^ the window is kept above other windows.
    | WindowStateBelow
    -- ^ the window is kept below other windows.
    | WindowStateFocused
    -- ^ the window is presented as focused (with active decorations).
    | WindowStateTiled
    -- ^ the window is in a tiled state, Since 3.10. Since 3.22.23, this
    --                          is deprecated in favor of per-edge information.
    | WindowStateTopTiled
    -- ^ whether the top edge is tiled, Since 3.22.23
    | WindowStateTopResizable
    -- ^ whether the top edge is resizable, Since 3.22.23
    | WindowStateRightTiled
    -- ^ whether the right edge is tiled, Since 3.22.23
    | WindowStateRightResizable
    -- ^ whether the right edge is resizable, Since 3.22.23
    | WindowStateBottomTiled
    -- ^ whether the bottom edge is tiled, Since 3.22.23
    | WindowStateBottomResizable
    -- ^ whether the bottom edge is resizable, Since 3.22.23
    | WindowStateLeftTiled
    -- ^ whether the left edge is tiled, Since 3.22.23
    | WindowStateLeftResizable
    -- ^ whether the left edge is resizable, Since 3.22.23
    | AnotherWindowState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowState where
    fromEnum WindowStateWithdrawn = 1
    fromEnum WindowStateIconified = 2
    fromEnum WindowStateMaximized = 4
    fromEnum WindowStateSticky = 8
    fromEnum WindowStateFullscreen = 16
    fromEnum WindowStateAbove = 32
    fromEnum WindowStateBelow = 64
    fromEnum WindowStateFocused = 128
    fromEnum WindowStateTiled = 256
    fromEnum WindowStateTopTiled = 512
    fromEnum WindowStateTopResizable = 1024
    fromEnum WindowStateRightTiled = 2048
    fromEnum WindowStateRightResizable = 4096
    fromEnum WindowStateBottomTiled = 8192
    fromEnum WindowStateBottomResizable = 16384
    fromEnum WindowStateLeftTiled = 32768
    fromEnum WindowStateLeftResizable = 65536
    fromEnum (AnotherWindowState k) = k

    toEnum 1 = WindowStateWithdrawn
    toEnum 2 = WindowStateIconified
    toEnum 4 = WindowStateMaximized
    toEnum 8 = WindowStateSticky
    toEnum 16 = WindowStateFullscreen
    toEnum 32 = WindowStateAbove
    toEnum 64 = WindowStateBelow
    toEnum 128 = WindowStateFocused
    toEnum 256 = WindowStateTiled
    toEnum 512 = WindowStateTopTiled
    toEnum 1024 = WindowStateTopResizable
    toEnum 2048 = WindowStateRightTiled
    toEnum 4096 = WindowStateRightResizable
    toEnum 8192 = WindowStateBottomTiled
    toEnum 16384 = WindowStateBottomResizable
    toEnum 32768 = WindowStateLeftTiled
    toEnum 65536 = WindowStateLeftResizable
    toEnum k = AnotherWindowState k

instance P.Ord WindowState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowState = '[]
instance O.HasParentTypes WindowState

foreign import ccall "gdk_window_state_get_type" c_gdk_window_state_get_type :: 
    IO GType

instance B.Types.TypedObject WindowState where
    glibType = c_gdk_window_state_get_type

instance B.Types.BoxedFlags WindowState

instance IsGFlag WindowState

-- Flags WindowHints
-- | Used to indicate which fields of a t'GI.Gdk.Structs.Geometry.Geometry' struct should be paid
-- attention to. Also, the presence\/absence of /@gDKHINTPOS@/,
-- /@gDKHINTUSERPOS@/, and /@gDKHINTUSERSIZE@/ is significant, though they don\'t
-- directly refer to t'GI.Gdk.Structs.Geometry.Geometry' fields. /@gDKHINTUSERPOS@/ will be set
-- automatically by @/GtkWindow/@ if you call @/gtk_window_move()/@.
-- /@gDKHINTUSERPOS@/ and /@gDKHINTUSERSIZE@/ should be set if the user
-- specified a size\/position using a --geometry command-line argument;
-- @/gtk_window_parse_geometry()/@ automatically sets these flags.
data WindowHints = 
      WindowHintsPos
    -- ^ indicates that the program has positioned the window
    | WindowHintsMinSize
    -- ^ min size fields are set
    | WindowHintsMaxSize
    -- ^ max size fields are set
    | WindowHintsBaseSize
    -- ^ base size fields are set
    | WindowHintsAspect
    -- ^ aspect ratio fields are set
    | WindowHintsResizeInc
    -- ^ resize increment fields are set
    | WindowHintsWinGravity
    -- ^ window gravity field is set
    | WindowHintsUserPos
    -- ^ indicates that the window’s position was explicitly set
    --  by the user
    | WindowHintsUserSize
    -- ^ indicates that the window’s size was explicitly set by
    --  the user
    | AnotherWindowHints Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowHints where
    fromEnum WindowHintsPos = 1
    fromEnum WindowHintsMinSize = 2
    fromEnum WindowHintsMaxSize = 4
    fromEnum WindowHintsBaseSize = 8
    fromEnum WindowHintsAspect = 16
    fromEnum WindowHintsResizeInc = 32
    fromEnum WindowHintsWinGravity = 64
    fromEnum WindowHintsUserPos = 128
    fromEnum WindowHintsUserSize = 256
    fromEnum (AnotherWindowHints k) = k

    toEnum 1 = WindowHintsPos
    toEnum 2 = WindowHintsMinSize
    toEnum 4 = WindowHintsMaxSize
    toEnum 8 = WindowHintsBaseSize
    toEnum 16 = WindowHintsAspect
    toEnum 32 = WindowHintsResizeInc
    toEnum 64 = WindowHintsWinGravity
    toEnum 128 = WindowHintsUserPos
    toEnum 256 = WindowHintsUserSize
    toEnum k = AnotherWindowHints k

instance P.Ord WindowHints where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowHints = '[]
instance O.HasParentTypes WindowHints

foreign import ccall "gdk_window_hints_get_type" c_gdk_window_hints_get_type :: 
    IO GType

instance B.Types.TypedObject WindowHints where
    glibType = c_gdk_window_hints_get_type

instance B.Types.BoxedFlags WindowHints

instance IsGFlag WindowHints

-- Flags WindowAttributesType
-- | Used to indicate which fields in the t'GI.Gdk.Structs.WindowAttr.WindowAttr' struct should be honored.
-- For example, if you filled in the “cursor” and “x” fields of t'GI.Gdk.Structs.WindowAttr.WindowAttr',
-- pass “/@gDKWAX@/ | /@gDKWACURSOR@/” to 'GI.Gdk.Objects.Window.windowNew'. Fields in
-- t'GI.Gdk.Structs.WindowAttr.WindowAttr' not covered by a bit in this enum are required; for example,
-- the /@width@/\//@height@/, /@wclass@/, and /@windowType@/ fields are required, they have
-- no corresponding flag in t'GI.Gdk.Flags.WindowAttributesType'.
data WindowAttributesType = 
      WindowAttributesTypeTitle
    -- ^ Honor the title field
    | WindowAttributesTypeX
    -- ^ Honor the X coordinate field
    | WindowAttributesTypeY
    -- ^ Honor the Y coordinate field
    | WindowAttributesTypeCursor
    -- ^ Honor the cursor field
    | WindowAttributesTypeVisual
    -- ^ Honor the visual field
    | WindowAttributesTypeWmclass
    -- ^ Honor the wmclass_class and wmclass_name fields
    | WindowAttributesTypeNoredir
    -- ^ Honor the override_redirect field
    | WindowAttributesTypeTypeHint
    -- ^ Honor the type_hint field
    | AnotherWindowAttributesType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WindowAttributesType where
    fromEnum WindowAttributesTypeTitle = 2
    fromEnum WindowAttributesTypeX = 4
    fromEnum WindowAttributesTypeY = 8
    fromEnum WindowAttributesTypeCursor = 16
    fromEnum WindowAttributesTypeVisual = 32
    fromEnum WindowAttributesTypeWmclass = 64
    fromEnum WindowAttributesTypeNoredir = 128
    fromEnum WindowAttributesTypeTypeHint = 256
    fromEnum (AnotherWindowAttributesType k) = k

    toEnum 2 = WindowAttributesTypeTitle
    toEnum 4 = WindowAttributesTypeX
    toEnum 8 = WindowAttributesTypeY
    toEnum 16 = WindowAttributesTypeCursor
    toEnum 32 = WindowAttributesTypeVisual
    toEnum 64 = WindowAttributesTypeWmclass
    toEnum 128 = WindowAttributesTypeNoredir
    toEnum 256 = WindowAttributesTypeTypeHint
    toEnum k = AnotherWindowAttributesType k

instance P.Ord WindowAttributesType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WindowAttributesType = '[]
instance O.HasParentTypes WindowAttributesType

foreign import ccall "gdk_window_attributes_type_get_type" c_gdk_window_attributes_type_get_type :: 
    IO GType

instance B.Types.TypedObject WindowAttributesType where
    glibType = c_gdk_window_attributes_type_get_type

instance B.Types.BoxedFlags WindowAttributesType

instance IsGFlag WindowAttributesType

-- Flags WMFunction
-- | These are hints originally defined by the Motif toolkit. The window manager
-- can use them when determining the functions to offer for the window. The
-- hint must be set before mapping the window.
data WMFunction = 
      WMFunctionAll
    -- ^ all functions should be offered.
    | WMFunctionResize
    -- ^ the window should be resizable.
    | WMFunctionMove
    -- ^ the window should be movable.
    | WMFunctionMinimize
    -- ^ the window should be minimizable.
    | WMFunctionMaximize
    -- ^ the window should be maximizable.
    | WMFunctionClose
    -- ^ the window should be closable.
    | AnotherWMFunction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WMFunction where
    fromEnum WMFunctionAll = 1
    fromEnum WMFunctionResize = 2
    fromEnum WMFunctionMove = 4
    fromEnum WMFunctionMinimize = 8
    fromEnum WMFunctionMaximize = 16
    fromEnum WMFunctionClose = 32
    fromEnum (AnotherWMFunction k) = k

    toEnum 1 = WMFunctionAll
    toEnum 2 = WMFunctionResize
    toEnum 4 = WMFunctionMove
    toEnum 8 = WMFunctionMinimize
    toEnum 16 = WMFunctionMaximize
    toEnum 32 = WMFunctionClose
    toEnum k = AnotherWMFunction k

instance P.Ord WMFunction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WMFunction = '[]
instance O.HasParentTypes WMFunction

foreign import ccall "gdk_wm_function_get_type" c_gdk_wm_function_get_type :: 
    IO GType

instance B.Types.TypedObject WMFunction where
    glibType = c_gdk_wm_function_get_type

instance B.Types.BoxedFlags WMFunction

instance IsGFlag WMFunction

-- Flags WMDecoration
-- | These are hints originally defined by the Motif toolkit.
-- The window manager can use them when determining how to decorate
-- the window. The hint must be set before mapping the window.
data WMDecoration = 
      WMDecorationAll
    -- ^ all decorations should be applied.
    | WMDecorationBorder
    -- ^ a frame should be drawn around the window.
    | WMDecorationResizeh
    -- ^ the frame should have resize handles.
    | WMDecorationTitle
    -- ^ a titlebar should be placed above the window.
    | WMDecorationMenu
    -- ^ a button for opening a menu should be included.
    | WMDecorationMinimize
    -- ^ a minimize button should be included.
    | WMDecorationMaximize
    -- ^ a maximize button should be included.
    | AnotherWMDecoration Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum WMDecoration where
    fromEnum WMDecorationAll = 1
    fromEnum WMDecorationBorder = 2
    fromEnum WMDecorationResizeh = 4
    fromEnum WMDecorationTitle = 8
    fromEnum WMDecorationMenu = 16
    fromEnum WMDecorationMinimize = 32
    fromEnum WMDecorationMaximize = 64
    fromEnum (AnotherWMDecoration k) = k

    toEnum 1 = WMDecorationAll
    toEnum 2 = WMDecorationBorder
    toEnum 4 = WMDecorationResizeh
    toEnum 8 = WMDecorationTitle
    toEnum 16 = WMDecorationMenu
    toEnum 32 = WMDecorationMinimize
    toEnum 64 = WMDecorationMaximize
    toEnum k = AnotherWMDecoration k

instance P.Ord WMDecoration where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes WMDecoration = '[]
instance O.HasParentTypes WMDecoration

foreign import ccall "gdk_wm_decoration_get_type" c_gdk_wm_decoration_get_type :: 
    IO GType

instance B.Types.TypedObject WMDecoration where
    glibType = c_gdk_wm_decoration_get_type

instance B.Types.BoxedFlags WMDecoration

instance IsGFlag WMDecoration

-- Flags SeatCapabilities
-- | Flags describing the seat capabilities.
-- 
-- /Since: 3.20/
data SeatCapabilities = 
      SeatCapabilitiesNone
    -- ^ No input capabilities
    | SeatCapabilitiesPointer
    -- ^ The seat has a pointer (e.g. mouse)
    | SeatCapabilitiesTouch
    -- ^ The seat has touchscreen(s) attached
    | SeatCapabilitiesTabletStylus
    -- ^ The seat has drawing tablet(s) attached
    | SeatCapabilitiesKeyboard
    -- ^ The seat has keyboard(s) attached
    | SeatCapabilitiesAllPointing
    -- ^ The union of all pointing capabilities
    | SeatCapabilitiesAll
    -- ^ The union of all capabilities
    | AnotherSeatCapabilities Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SeatCapabilities where
    fromEnum SeatCapabilitiesNone = 0
    fromEnum SeatCapabilitiesPointer = 1
    fromEnum SeatCapabilitiesTouch = 2
    fromEnum SeatCapabilitiesTabletStylus = 4
    fromEnum SeatCapabilitiesKeyboard = 8
    fromEnum SeatCapabilitiesAllPointing = 7
    fromEnum SeatCapabilitiesAll = 15
    fromEnum (AnotherSeatCapabilities k) = k

    toEnum 0 = SeatCapabilitiesNone
    toEnum 1 = SeatCapabilitiesPointer
    toEnum 2 = SeatCapabilitiesTouch
    toEnum 4 = SeatCapabilitiesTabletStylus
    toEnum 8 = SeatCapabilitiesKeyboard
    toEnum 7 = SeatCapabilitiesAllPointing
    toEnum 15 = SeatCapabilitiesAll
    toEnum k = AnotherSeatCapabilities k

instance P.Ord SeatCapabilities where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SeatCapabilities = '[]
instance O.HasParentTypes SeatCapabilities

foreign import ccall "gdk_seat_capabilities_get_type" c_gdk_seat_capabilities_get_type :: 
    IO GType

instance B.Types.TypedObject SeatCapabilities where
    glibType = c_gdk_seat_capabilities_get_type

instance B.Types.BoxedFlags SeatCapabilities

instance IsGFlag SeatCapabilities

-- Flags ModifierType
-- | A set of bit-flags to indicate the state of modifier keys and mouse buttons
-- in various event types. Typical modifier keys are Shift, Control, Meta,
-- Super, Hyper, Alt, Compose, Apple, CapsLock or ShiftLock.
-- 
-- Like the X Window System, GDK supports 8 modifier keys and 5 mouse buttons.
-- 
-- Since 2.10, GDK recognizes which of the Meta, Super or Hyper keys are mapped
-- to Mod2 - Mod5, and indicates this by setting 'GI.Gdk.Flags.ModifierTypeSuperMask',
-- 'GI.Gdk.Flags.ModifierTypeHyperMask' or 'GI.Gdk.Flags.ModifierTypeMetaMask' in the state field of key events.
-- 
-- Note that GDK may add internal values to events which include
-- reserved values such as 'GI.Gdk.Flags.ModifierTypeModifierReserved13Mask'.  Your code
-- should preserve and ignore them.  You can use 'GI.Gdk.Flags.ModifierTypeModifierMask' to
-- remove all reserved values.
-- 
-- Also note that the GDK X backend interprets button press events for button
-- 4-7 as scroll events, so 'GI.Gdk.Flags.ModifierTypeButton4Mask' and 'GI.Gdk.Flags.ModifierTypeButton5Mask' will never
-- be set.
data ModifierType = 
      ModifierTypeShiftMask
    -- ^ the Shift key.
    | ModifierTypeLockMask
    -- ^ a Lock key (depending on the modifier mapping of the
    --  X server this may either be CapsLock or ShiftLock).
    | ModifierTypeControlMask
    -- ^ the Control key.
    | ModifierTypeMod1Mask
    -- ^ the fourth modifier key (it depends on the modifier
    --  mapping of the X server which key is interpreted as this modifier, but
    --  normally it is the Alt key).
    | ModifierTypeMod2Mask
    -- ^ the fifth modifier key (it depends on the modifier
    --  mapping of the X server which key is interpreted as this modifier).
    | ModifierTypeMod3Mask
    -- ^ the sixth modifier key (it depends on the modifier
    --  mapping of the X server which key is interpreted as this modifier).
    | ModifierTypeMod4Mask
    -- ^ the seventh modifier key (it depends on the modifier
    --  mapping of the X server which key is interpreted as this modifier).
    | ModifierTypeMod5Mask
    -- ^ the eighth modifier key (it depends on the modifier
    --  mapping of the X server which key is interpreted as this modifier).
    | ModifierTypeButton1Mask
    -- ^ the first mouse button.
    | ModifierTypeButton2Mask
    -- ^ the second mouse button.
    | ModifierTypeButton3Mask
    -- ^ the third mouse button.
    | ModifierTypeButton4Mask
    -- ^ the fourth mouse button.
    | ModifierTypeButton5Mask
    -- ^ the fifth mouse button.
    | ModifierTypeModifierReserved13Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved14Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved15Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved16Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved17Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved18Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved19Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved20Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved21Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved22Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved23Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved24Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeModifierReserved25Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeSuperMask
    -- ^ the Super modifier. Since 2.10
    | ModifierTypeHyperMask
    -- ^ the Hyper modifier. Since 2.10
    | ModifierTypeMetaMask
    -- ^ the Meta modifier. Since 2.10
    | ModifierTypeModifierReserved29Mask
    -- ^ A reserved bit flag; do not use in your own code
    | ModifierTypeReleaseMask
    -- ^ not used in GDK itself. GTK+ uses it to differentiate
    --  between (keyval, modifiers) pairs from key press and release events.
    | ModifierTypeModifierMask
    -- ^ a mask covering all modifier types.
    | AnotherModifierType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ModifierType where
    fromEnum ModifierTypeShiftMask = 1
    fromEnum ModifierTypeLockMask = 2
    fromEnum ModifierTypeControlMask = 4
    fromEnum ModifierTypeMod1Mask = 8
    fromEnum ModifierTypeMod2Mask = 16
    fromEnum ModifierTypeMod3Mask = 32
    fromEnum ModifierTypeMod4Mask = 64
    fromEnum ModifierTypeMod5Mask = 128
    fromEnum ModifierTypeButton1Mask = 256
    fromEnum ModifierTypeButton2Mask = 512
    fromEnum ModifierTypeButton3Mask = 1024
    fromEnum ModifierTypeButton4Mask = 2048
    fromEnum ModifierTypeButton5Mask = 4096
    fromEnum ModifierTypeModifierReserved13Mask = 8192
    fromEnum ModifierTypeModifierReserved14Mask = 16384
    fromEnum ModifierTypeModifierReserved15Mask = 32768
    fromEnum ModifierTypeModifierReserved16Mask = 65536
    fromEnum ModifierTypeModifierReserved17Mask = 131072
    fromEnum ModifierTypeModifierReserved18Mask = 262144
    fromEnum ModifierTypeModifierReserved19Mask = 524288
    fromEnum ModifierTypeModifierReserved20Mask = 1048576
    fromEnum ModifierTypeModifierReserved21Mask = 2097152
    fromEnum ModifierTypeModifierReserved22Mask = 4194304
    fromEnum ModifierTypeModifierReserved23Mask = 8388608
    fromEnum ModifierTypeModifierReserved24Mask = 16777216
    fromEnum ModifierTypeModifierReserved25Mask = 33554432
    fromEnum ModifierTypeSuperMask = 67108864
    fromEnum ModifierTypeHyperMask = 134217728
    fromEnum ModifierTypeMetaMask = 268435456
    fromEnum ModifierTypeModifierReserved29Mask = 536870912
    fromEnum ModifierTypeReleaseMask = 1073741824
    fromEnum ModifierTypeModifierMask = 1543512063
    fromEnum (AnotherModifierType k) = k

    toEnum 1 = ModifierTypeShiftMask
    toEnum 2 = ModifierTypeLockMask
    toEnum 4 = ModifierTypeControlMask
    toEnum 8 = ModifierTypeMod1Mask
    toEnum 16 = ModifierTypeMod2Mask
    toEnum 32 = ModifierTypeMod3Mask
    toEnum 64 = ModifierTypeMod4Mask
    toEnum 128 = ModifierTypeMod5Mask
    toEnum 256 = ModifierTypeButton1Mask
    toEnum 512 = ModifierTypeButton2Mask
    toEnum 1024 = ModifierTypeButton3Mask
    toEnum 2048 = ModifierTypeButton4Mask
    toEnum 4096 = ModifierTypeButton5Mask
    toEnum 8192 = ModifierTypeModifierReserved13Mask
    toEnum 16384 = ModifierTypeModifierReserved14Mask
    toEnum 32768 = ModifierTypeModifierReserved15Mask
    toEnum 65536 = ModifierTypeModifierReserved16Mask
    toEnum 131072 = ModifierTypeModifierReserved17Mask
    toEnum 262144 = ModifierTypeModifierReserved18Mask
    toEnum 524288 = ModifierTypeModifierReserved19Mask
    toEnum 1048576 = ModifierTypeModifierReserved20Mask
    toEnum 2097152 = ModifierTypeModifierReserved21Mask
    toEnum 4194304 = ModifierTypeModifierReserved22Mask
    toEnum 8388608 = ModifierTypeModifierReserved23Mask
    toEnum 16777216 = ModifierTypeModifierReserved24Mask
    toEnum 33554432 = ModifierTypeModifierReserved25Mask
    toEnum 67108864 = ModifierTypeSuperMask
    toEnum 134217728 = ModifierTypeHyperMask
    toEnum 268435456 = ModifierTypeMetaMask
    toEnum 536870912 = ModifierTypeModifierReserved29Mask
    toEnum 1073741824 = ModifierTypeReleaseMask
    toEnum 1543512063 = ModifierTypeModifierMask
    toEnum k = AnotherModifierType k

instance P.Ord ModifierType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ModifierType = '[]
instance O.HasParentTypes ModifierType

foreign import ccall "gdk_modifier_type_get_type" c_gdk_modifier_type_get_type :: 
    IO GType

instance B.Types.TypedObject ModifierType where
    glibType = c_gdk_modifier_type_get_type

instance B.Types.BoxedFlags ModifierType

instance IsGFlag ModifierType

-- Flags FrameClockPhase
-- | t'GI.Gdk.Flags.FrameClockPhase' is used to represent the different paint clock
-- phases that can be requested. The elements of the enumeration
-- correspond to the signals of t'GI.Gdk.Objects.FrameClock.FrameClock'.
-- 
-- /Since: 3.8/
data FrameClockPhase = 
      FrameClockPhaseNone
    -- ^ no phase
    | FrameClockPhaseFlushEvents
    -- ^ corresponds to GdkFrameClock[flushEvents](#g:signal:flushEvents). Should not be handled by applications.
    | FrameClockPhaseBeforePaint
    -- ^ corresponds to GdkFrameClock[beforePaint](#g:signal:beforePaint). Should not be handled by applications.
    | FrameClockPhaseUpdate
    -- ^ corresponds to GdkFrameClock[update](#g:signal:update).
    | FrameClockPhaseLayout
    -- ^ corresponds to GdkFrameClock[layout](#g:signal:layout).
    | FrameClockPhasePaint
    -- ^ corresponds to GdkFrameClock[paint](#g:signal:paint).
    | FrameClockPhaseResumeEvents
    -- ^ corresponds to GdkFrameClock[resumeEvents](#g:signal:resumeEvents). Should not be handled by applications.
    | FrameClockPhaseAfterPaint
    -- ^ corresponds to GdkFrameClock[afterPaint](#g:signal:afterPaint). Should not be handled by applications.
    | AnotherFrameClockPhase Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FrameClockPhase where
    fromEnum FrameClockPhaseNone = 0
    fromEnum FrameClockPhaseFlushEvents = 1
    fromEnum FrameClockPhaseBeforePaint = 2
    fromEnum FrameClockPhaseUpdate = 4
    fromEnum FrameClockPhaseLayout = 8
    fromEnum FrameClockPhasePaint = 16
    fromEnum FrameClockPhaseResumeEvents = 32
    fromEnum FrameClockPhaseAfterPaint = 64
    fromEnum (AnotherFrameClockPhase k) = k

    toEnum 0 = FrameClockPhaseNone
    toEnum 1 = FrameClockPhaseFlushEvents
    toEnum 2 = FrameClockPhaseBeforePaint
    toEnum 4 = FrameClockPhaseUpdate
    toEnum 8 = FrameClockPhaseLayout
    toEnum 16 = FrameClockPhasePaint
    toEnum 32 = FrameClockPhaseResumeEvents
    toEnum 64 = FrameClockPhaseAfterPaint
    toEnum k = AnotherFrameClockPhase k

instance P.Ord FrameClockPhase where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FrameClockPhase = '[]
instance O.HasParentTypes FrameClockPhase

foreign import ccall "gdk_frame_clock_phase_get_type" c_gdk_frame_clock_phase_get_type :: 
    IO GType

instance B.Types.TypedObject FrameClockPhase where
    glibType = c_gdk_frame_clock_phase_get_type

instance B.Types.BoxedFlags FrameClockPhase

instance IsGFlag FrameClockPhase

-- Flags EventMask
-- | A set of bit-flags to indicate which events a window is to receive.
-- Most of these masks map onto one or more of the t'GI.Gdk.Enums.EventType' event types
-- above.
-- 
-- See the [input handling overview][chap-input-handling] for details of
-- [event masks][event-masks] and [event propagation][event-propagation].
-- 
-- 'GI.Gdk.Flags.EventMaskPointerMotionHintMask' is deprecated. It is a special mask
-- to reduce the number of 'GI.Gdk.Enums.EventTypeMotionNotify' events received. When using
-- 'GI.Gdk.Flags.EventMaskPointerMotionHintMask', fewer 'GI.Gdk.Enums.EventTypeMotionNotify' events will
-- be sent, some of which are marked as a hint (the is_hint member is
-- 'P.True'). To receive more motion events after a motion hint event,
-- the application needs to asks for more, by calling
-- 'GI.Gdk.Functions.eventRequestMotions'.
-- 
-- Since GTK 3.8, motion events are already compressed by default, independent
-- of this mechanism. This compression can be disabled with
-- 'GI.Gdk.Objects.Window.windowSetEventCompression'. See the documentation of that function
-- for details.
-- 
-- If 'GI.Gdk.Flags.EventMaskTouchMask' is enabled, the window will receive touch events
-- from touch-enabled devices. Those will come as sequences of t'GI.Gdk.Structs.EventTouch.EventTouch'
-- with type 'GI.Gdk.Enums.EventTypeTouchUpdate', enclosed by two events with
-- type 'GI.Gdk.Enums.EventTypeTouchBegin' and 'GI.Gdk.Enums.EventTypeTouchEnd' (or 'GI.Gdk.Enums.EventTypeTouchCancel').
-- 'GI.Gdk.Unions.Event.eventGetEventSequence' returns the event sequence for these
-- events, so different sequences may be distinguished.
data EventMask = 
      EventMaskExposureMask
    -- ^ receive expose events
    | EventMaskPointerMotionMask
    -- ^ receive all pointer motion events
    | EventMaskPointerMotionHintMask
    -- ^ deprecated. see the explanation above
    | EventMaskButtonMotionMask
    -- ^ receive pointer motion events while any button is pressed
    | EventMaskButton1MotionMask
    -- ^ receive pointer motion events while 1 button is pressed
    | EventMaskButton2MotionMask
    -- ^ receive pointer motion events while 2 button is pressed
    | EventMaskButton3MotionMask
    -- ^ receive pointer motion events while 3 button is pressed
    | EventMaskButtonPressMask
    -- ^ receive button press events
    | EventMaskButtonReleaseMask
    -- ^ receive button release events
    | EventMaskKeyPressMask
    -- ^ receive key press events
    | EventMaskKeyReleaseMask
    -- ^ receive key release events
    | EventMaskEnterNotifyMask
    -- ^ receive window enter events
    | EventMaskLeaveNotifyMask
    -- ^ receive window leave events
    | EventMaskFocusChangeMask
    -- ^ receive focus change events
    | EventMaskStructureMask
    -- ^ receive events about window configuration change
    | EventMaskPropertyChangeMask
    -- ^ receive property change events
    | EventMaskVisibilityNotifyMask
    -- ^ receive visibility change events
    | EventMaskProximityInMask
    -- ^ receive proximity in events
    | EventMaskProximityOutMask
    -- ^ receive proximity out events
    | EventMaskSubstructureMask
    -- ^ receive events about window configuration changes of
    --   child windows
    | EventMaskScrollMask
    -- ^ receive scroll events
    | EventMaskTouchMask
    -- ^ receive touch events. Since 3.4
    | EventMaskSmoothScrollMask
    -- ^ receive smooth scrolling events. Since 3.4
    | EventMaskTouchpadGestureMask
    -- ^ receive touchpad gesture events. Since 3.18
    | EventMaskTabletPadMask
    -- ^ receive tablet pad events. Since 3.22
    | EventMaskAllEventsMask
    -- ^ the combination of all the above event masks.
    | AnotherEventMask Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum EventMask where
    fromEnum EventMaskExposureMask = 2
    fromEnum EventMaskPointerMotionMask = 4
    fromEnum EventMaskPointerMotionHintMask = 8
    fromEnum EventMaskButtonMotionMask = 16
    fromEnum EventMaskButton1MotionMask = 32
    fromEnum EventMaskButton2MotionMask = 64
    fromEnum EventMaskButton3MotionMask = 128
    fromEnum EventMaskButtonPressMask = 256
    fromEnum EventMaskButtonReleaseMask = 512
    fromEnum EventMaskKeyPressMask = 1024
    fromEnum EventMaskKeyReleaseMask = 2048
    fromEnum EventMaskEnterNotifyMask = 4096
    fromEnum EventMaskLeaveNotifyMask = 8192
    fromEnum EventMaskFocusChangeMask = 16384
    fromEnum EventMaskStructureMask = 32768
    fromEnum EventMaskPropertyChangeMask = 65536
    fromEnum EventMaskVisibilityNotifyMask = 131072
    fromEnum EventMaskProximityInMask = 262144
    fromEnum EventMaskProximityOutMask = 524288
    fromEnum EventMaskSubstructureMask = 1048576
    fromEnum EventMaskScrollMask = 2097152
    fromEnum EventMaskTouchMask = 4194304
    fromEnum EventMaskSmoothScrollMask = 8388608
    fromEnum EventMaskTouchpadGestureMask = 16777216
    fromEnum EventMaskTabletPadMask = 33554432
    fromEnum EventMaskAllEventsMask = 67108862
    fromEnum (AnotherEventMask k) = k

    toEnum 2 = EventMaskExposureMask
    toEnum 4 = EventMaskPointerMotionMask
    toEnum 8 = EventMaskPointerMotionHintMask
    toEnum 16 = EventMaskButtonMotionMask
    toEnum 32 = EventMaskButton1MotionMask
    toEnum 64 = EventMaskButton2MotionMask
    toEnum 128 = EventMaskButton3MotionMask
    toEnum 256 = EventMaskButtonPressMask
    toEnum 512 = EventMaskButtonReleaseMask
    toEnum 1024 = EventMaskKeyPressMask
    toEnum 2048 = EventMaskKeyReleaseMask
    toEnum 4096 = EventMaskEnterNotifyMask
    toEnum 8192 = EventMaskLeaveNotifyMask
    toEnum 16384 = EventMaskFocusChangeMask
    toEnum 32768 = EventMaskStructureMask
    toEnum 65536 = EventMaskPropertyChangeMask
    toEnum 131072 = EventMaskVisibilityNotifyMask
    toEnum 262144 = EventMaskProximityInMask
    toEnum 524288 = EventMaskProximityOutMask
    toEnum 1048576 = EventMaskSubstructureMask
    toEnum 2097152 = EventMaskScrollMask
    toEnum 4194304 = EventMaskTouchMask
    toEnum 8388608 = EventMaskSmoothScrollMask
    toEnum 16777216 = EventMaskTouchpadGestureMask
    toEnum 33554432 = EventMaskTabletPadMask
    toEnum 67108862 = EventMaskAllEventsMask
    toEnum k = AnotherEventMask k

instance P.Ord EventMask where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes EventMask = '[]
instance O.HasParentTypes EventMask

foreign import ccall "gdk_event_mask_get_type" c_gdk_event_mask_get_type :: 
    IO GType

instance B.Types.TypedObject EventMask where
    glibType = c_gdk_event_mask_get_type

instance B.Types.BoxedFlags EventMask

instance IsGFlag EventMask

-- Flags DragAction
-- | Used in t'GI.Gdk.Objects.DragContext.DragContext' to indicate what the destination
-- should do with the dropped data.
data DragAction = 
      DragActionDefault
    -- ^ Means nothing, and should not be used.
    | DragActionCopy
    -- ^ Copy the data.
    | DragActionMove
    -- ^ Move the data, i.e. first copy it, then delete
    --  it from the source using the DELETE target of the X selection protocol.
    | DragActionLink
    -- ^ Add a link to the data. Note that this is only
    --  useful if source and destination agree on what it means.
    | DragActionPrivate
    -- ^ Special action which tells the source that the
    --  destination will do something that the source doesn’t understand.
    | DragActionAsk
    -- ^ Ask the user what to do with the data.
    | AnotherDragAction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DragAction where
    fromEnum DragActionDefault = 1
    fromEnum DragActionCopy = 2
    fromEnum DragActionMove = 4
    fromEnum DragActionLink = 8
    fromEnum DragActionPrivate = 16
    fromEnum DragActionAsk = 32
    fromEnum (AnotherDragAction k) = k

    toEnum 1 = DragActionDefault
    toEnum 2 = DragActionCopy
    toEnum 4 = DragActionMove
    toEnum 8 = DragActionLink
    toEnum 16 = DragActionPrivate
    toEnum 32 = DragActionAsk
    toEnum k = AnotherDragAction k

instance P.Ord DragAction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DragAction = '[]
instance O.HasParentTypes DragAction

foreign import ccall "gdk_drag_action_get_type" c_gdk_drag_action_get_type :: 
    IO GType

instance B.Types.TypedObject DragAction where
    glibType = c_gdk_drag_action_get_type

instance B.Types.BoxedFlags DragAction

instance IsGFlag DragAction

-- Flags AxisFlags
-- | Flags describing the current capabilities of a device\/tool.
-- 
-- /Since: 3.22/
data AxisFlags = 
      AxisFlagsX
    -- ^ X axis is present
    | AxisFlagsY
    -- ^ Y axis is present
    | AxisFlagsPressure
    -- ^ Pressure axis is present
    | AxisFlagsXtilt
    -- ^ X tilt axis is present
    | AxisFlagsYtilt
    -- ^ Y tilt axis is present
    | AxisFlagsWheel
    -- ^ Wheel axis is present
    | AxisFlagsDistance
    -- ^ Distance axis is present
    | AxisFlagsRotation
    -- ^ Z-axis rotation is present
    | AxisFlagsSlider
    -- ^ Slider axis is present
    | AnotherAxisFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AxisFlags where
    fromEnum AxisFlagsX = 2
    fromEnum AxisFlagsY = 4
    fromEnum AxisFlagsPressure = 8
    fromEnum AxisFlagsXtilt = 16
    fromEnum AxisFlagsYtilt = 32
    fromEnum AxisFlagsWheel = 64
    fromEnum AxisFlagsDistance = 128
    fromEnum AxisFlagsRotation = 256
    fromEnum AxisFlagsSlider = 512
    fromEnum (AnotherAxisFlags k) = k

    toEnum 2 = AxisFlagsX
    toEnum 4 = AxisFlagsY
    toEnum 8 = AxisFlagsPressure
    toEnum 16 = AxisFlagsXtilt
    toEnum 32 = AxisFlagsYtilt
    toEnum 64 = AxisFlagsWheel
    toEnum 128 = AxisFlagsDistance
    toEnum 256 = AxisFlagsRotation
    toEnum 512 = AxisFlagsSlider
    toEnum k = AnotherAxisFlags k

instance P.Ord AxisFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AxisFlags = '[]
instance O.HasParentTypes AxisFlags

foreign import ccall "gdk_axis_flags_get_type" c_gdk_axis_flags_get_type :: 
    IO GType

instance B.Types.TypedObject AxisFlags where
    glibType = c_gdk_axis_flags_get_type

instance B.Types.BoxedFlags AxisFlags

instance IsGFlag AxisFlags

-- Flags AnchorHints
-- | Positioning hints for aligning a window relative to a rectangle.
-- 
-- These hints determine how the window should be positioned in the case that
-- the window would fall off-screen if placed in its ideal position.
-- 
-- For example, 'GI.Gdk.Flags.AnchorHintsFlipX' will replace 'GI.Gdk.Enums.GravityNorthWest' with
-- 'GI.Gdk.Enums.GravityNorthEast' and vice versa if the window extends beyond the left
-- or right edges of the monitor.
-- 
-- If 'GI.Gdk.Flags.AnchorHintsSlideX' is set, the window can be shifted horizontally to fit
-- on-screen. If 'GI.Gdk.Flags.AnchorHintsResizeX' is set, the window can be shrunken
-- horizontally to fit.
-- 
-- In general, when multiple flags are set, flipping should take precedence over
-- sliding, which should take precedence over resizing.
-- 
-- /Since: 3.22/
data AnchorHints = 
      AnchorHintsFlipX
    -- ^ allow flipping anchors horizontally
    | AnchorHintsFlipY
    -- ^ allow flipping anchors vertically
    | AnchorHintsSlideX
    -- ^ allow sliding window horizontally
    | AnchorHintsSlideY
    -- ^ allow sliding window vertically
    | AnchorHintsResizeX
    -- ^ allow resizing window horizontally
    | AnchorHintsResizeY
    -- ^ allow resizing window vertically
    | AnchorHintsFlip
    -- ^ allow flipping anchors on both axes
    | AnchorHintsSlide
    -- ^ allow sliding window on both axes
    | AnchorHintsResize
    -- ^ allow resizing window on both axes
    | AnotherAnchorHints Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AnchorHints where
    fromEnum AnchorHintsFlipX = 1
    fromEnum AnchorHintsFlipY = 2
    fromEnum AnchorHintsSlideX = 4
    fromEnum AnchorHintsSlideY = 8
    fromEnum AnchorHintsResizeX = 16
    fromEnum AnchorHintsResizeY = 32
    fromEnum AnchorHintsFlip = 3
    fromEnum AnchorHintsSlide = 12
    fromEnum AnchorHintsResize = 48
    fromEnum (AnotherAnchorHints k) = k

    toEnum 1 = AnchorHintsFlipX
    toEnum 2 = AnchorHintsFlipY
    toEnum 4 = AnchorHintsSlideX
    toEnum 8 = AnchorHintsSlideY
    toEnum 16 = AnchorHintsResizeX
    toEnum 32 = AnchorHintsResizeY
    toEnum 3 = AnchorHintsFlip
    toEnum 12 = AnchorHintsSlide
    toEnum 48 = AnchorHintsResize
    toEnum k = AnotherAnchorHints k

instance P.Ord AnchorHints where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AnchorHints = '[]
instance O.HasParentTypes AnchorHints

foreign import ccall "gdk_anchor_hints_get_type" c_gdk_anchor_hints_get_type :: 
    IO GType

instance B.Types.TypedObject AnchorHints where
    glibType = c_gdk_anchor_hints_get_type

instance B.Types.BoxedFlags AnchorHints

instance IsGFlag AnchorHints


