{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a touch-based device.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.TouchEvent
    ( 

-- * Exported types
    TouchEvent(..)                          ,
    IsTouchEvent                            ,
    toTouchEvent                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEmulatingPointer]("GI.Gdk.Objects.TouchEvent#g:method:getEmulatingPointer"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveTouchEventMethod                 ,
#endif

-- ** getEmulatingPointer #method:getEmulatingPointer#

#if defined(ENABLE_OVERLOADING)
    TouchEventGetEmulatingPointerMethodInfo ,
#endif
    touchEventGetEmulatingPointer           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype TouchEvent = TouchEvent (SP.ManagedPtr TouchEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype TouchEvent where
    toManagedPtr (TouchEvent p) = p

foreign import ccall "gdk_touch_event_get_type"
    c_gdk_touch_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject TouchEvent where
    glibType = c_gdk_touch_event_get_type

-- | Type class for types which can be safely cast to t'TouchEvent', for instance with `toTouchEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TouchEvent o) => IsTouchEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf TouchEvent o) => IsTouchEvent o

instance O.HasParentTypes TouchEvent
type instance O.ParentTypes TouchEvent = '[Gdk.Event.Event]

-- | Cast to t'TouchEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTouchEvent :: (MIO.MonadIO m, IsTouchEvent o) => o -> m TouchEvent
toTouchEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo TouchEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveTouchEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTouchEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveTouchEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveTouchEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveTouchEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveTouchEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveTouchEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveTouchEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveTouchEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveTouchEventMethod "getEmulatingPointer" o = TouchEventGetEmulatingPointerMethodInfo
    ResolveTouchEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveTouchEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveTouchEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveTouchEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveTouchEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveTouchEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveTouchEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveTouchEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveTouchEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveTouchEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTouchEventMethod t TouchEvent, O.OverloadedMethod info TouchEvent p) => OL.IsLabel t (TouchEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTouchEventMethod t TouchEvent, O.OverloadedMethod info TouchEvent p, R.HasField t TouchEvent p) => R.HasField t TouchEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTouchEventMethod t TouchEvent, O.OverloadedMethodInfo info TouchEvent) => OL.IsLabel t (O.MethodProxy info TouchEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr TouchEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method TouchEvent::get_emulating_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "TouchEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a touch event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_touch_event_get_emulating_pointer" gdk_touch_event_get_emulating_pointer :: 
    Ptr TouchEvent ->                       -- event : TInterface (Name {namespace = "Gdk", name = "TouchEvent"})
    IO CInt

-- | Extracts whether a touch event is emulating a pointer event.
touchEventGetEmulatingPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsTouchEvent a) =>
    a
    -- ^ /@event@/: a touch event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@event@/ is emulating
touchEventGetEmulatingPointer event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_touch_event_get_emulating_pointer event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data TouchEventGetEmulatingPointerMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTouchEvent a) => O.OverloadedMethod TouchEventGetEmulatingPointerMethodInfo a signature where
    overloadedMethod = touchEventGetEmulatingPointer

instance O.OverloadedMethodInfo TouchEventGetEmulatingPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.TouchEvent.touchEventGetEmulatingPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-TouchEvent.html#v:touchEventGetEmulatingPointer"
        })


#endif


