{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GdkTexture@ representing a GL texture object.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.GLTexture
    ( 

-- * Exported types
    GLTexture(..)                           ,
    IsGLTexture                             ,
    toGLTexture                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [download]("GI.Gdk.Objects.Texture#g:method:download"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [load]("GI.Gio.Interfaces.LoadableIcon#g:method:load"), [loadAsync]("GI.Gio.Interfaces.LoadableIcon#g:method:loadAsync"), [loadFinish]("GI.Gio.Interfaces.LoadableIcon#g:method:loadFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [release]("GI.Gdk.Objects.GLTexture#g:method:release"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [saveToPng]("GI.Gdk.Objects.Texture#g:method:saveToPng"), [saveToPngBytes]("GI.Gdk.Objects.Texture#g:method:saveToPngBytes"), [saveToTiff]("GI.Gdk.Objects.Texture#g:method:saveToTiff"), [saveToTiffBytes]("GI.Gdk.Objects.Texture#g:method:saveToTiffBytes"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getColorState]("GI.Gdk.Objects.Texture#g:method:getColorState"), [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getFormat]("GI.Gdk.Objects.Texture#g:method:getFormat"), [getHeight]("GI.Gdk.Objects.Texture#g:method:getHeight"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidth]("GI.Gdk.Objects.Texture#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveGLTextureMethod                  ,
#endif

-- ** new #method:new#

    gLTextureNew                            ,


-- ** release #method:release#

#if defined(ENABLE_OVERLOADING)
    GLTextureReleaseMethodInfo              ,
#endif
    gLTextureRelease                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#endif

-- | Memory-managed wrapper type.
newtype GLTexture = GLTexture (SP.ManagedPtr GLTexture)
    deriving (Eq)

instance SP.ManagedPtrNewtype GLTexture where
    toManagedPtr (GLTexture p) = p

foreign import ccall "gdk_gl_texture_get_type"
    c_gdk_gl_texture_get_type :: IO B.Types.GType

instance B.Types.TypedObject GLTexture where
    glibType = c_gdk_gl_texture_get_type

instance B.Types.GObject GLTexture

-- | Type class for types which can be safely cast to t'GLTexture', for instance with `toGLTexture`.
class (SP.GObject o, O.IsDescendantOf GLTexture o) => IsGLTexture o
instance (SP.GObject o, O.IsDescendantOf GLTexture o) => IsGLTexture o

instance O.HasParentTypes GLTexture
type instance O.ParentTypes GLTexture = '[Gdk.Texture.Texture, GObject.Object.Object, Gdk.Paintable.Paintable, Gio.Icon.Icon, Gio.LoadableIcon.LoadableIcon]

-- | Cast to t'GLTexture', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGLTexture :: (MIO.MonadIO m, IsGLTexture o) => o -> m GLTexture
toGLTexture = MIO.liftIO . B.ManagedPtr.unsafeCastTo GLTexture

-- | Convert t'GLTexture' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GLTexture) where
    gvalueGType_ = c_gdk_gl_texture_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GLTexture)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GLTexture)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GLTexture ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGLTextureMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGLTextureMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGLTextureMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGLTextureMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveGLTextureMethod "download" o = Gdk.Texture.TextureDownloadMethodInfo
    ResolveGLTextureMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveGLTextureMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGLTextureMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGLTextureMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGLTextureMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveGLTextureMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveGLTextureMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveGLTextureMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGLTextureMethod "load" o = Gio.LoadableIcon.LoadableIconLoadMethodInfo
    ResolveGLTextureMethod "loadAsync" o = Gio.LoadableIcon.LoadableIconLoadAsyncMethodInfo
    ResolveGLTextureMethod "loadFinish" o = Gio.LoadableIcon.LoadableIconLoadFinishMethodInfo
    ResolveGLTextureMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGLTextureMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGLTextureMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGLTextureMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGLTextureMethod "release" o = GLTextureReleaseMethodInfo
    ResolveGLTextureMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGLTextureMethod "saveToPng" o = Gdk.Texture.TextureSaveToPngMethodInfo
    ResolveGLTextureMethod "saveToPngBytes" o = Gdk.Texture.TextureSaveToPngBytesMethodInfo
    ResolveGLTextureMethod "saveToTiff" o = Gdk.Texture.TextureSaveToTiffMethodInfo
    ResolveGLTextureMethod "saveToTiffBytes" o = Gdk.Texture.TextureSaveToTiffBytesMethodInfo
    ResolveGLTextureMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveGLTextureMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveGLTextureMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGLTextureMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGLTextureMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGLTextureMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveGLTextureMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGLTextureMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGLTextureMethod "getColorState" o = Gdk.Texture.TextureGetColorStateMethodInfo
    ResolveGLTextureMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveGLTextureMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGLTextureMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveGLTextureMethod "getFormat" o = Gdk.Texture.TextureGetFormatMethodInfo
    ResolveGLTextureMethod "getHeight" o = Gdk.Texture.TextureGetHeightMethodInfo
    ResolveGLTextureMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveGLTextureMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveGLTextureMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveGLTextureMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGLTextureMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGLTextureMethod "getWidth" o = Gdk.Texture.TextureGetWidthMethodInfo
    ResolveGLTextureMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGLTextureMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGLTextureMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGLTextureMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGLTextureMethod t GLTexture, O.OverloadedMethod info GLTexture p) => OL.IsLabel t (GLTexture -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGLTextureMethod t GLTexture, O.OverloadedMethod info GLTexture p, R.HasField t GLTexture p) => R.HasField t GLTexture p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGLTextureMethod t GLTexture, O.OverloadedMethodInfo info GLTexture) => OL.IsLabel t (O.MethodProxy info GLTexture) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GLTexture
type instance O.AttributeList GLTexture = GLTextureAttributeList
type GLTextureAttributeList = ('[ '("colorState", Gdk.Texture.TextureColorStatePropertyInfo), '("height", Gdk.Texture.TextureHeightPropertyInfo), '("width", Gdk.Texture.TextureWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GLTexture = GLTextureSignalList
type GLTextureSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GLTexture::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkGLContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the ID of a texture that was created with @context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the nominal width of the texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the nominal height of the texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a destroy notify that will be called when the GL resources\n  are released"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data that gets passed to @destroy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLTexture" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_new" gdk_gl_texture_new :: 
    Ptr Gdk.GLContext.GLContext ->          -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Word32 ->                               -- id : TBasicType TUInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO (Ptr GLTexture)

{-# DEPRECATED gLTextureNew ["(Since version 4.12)","t'GI.Gdk.Objects.GLTextureBuilder.GLTextureBuilder' supersedes this function","  and provides extended functionality for creating GL textures."] #-}
-- | Creates a new texture for an existing GL texture.
-- 
-- Note that the GL texture must not be modified until /@destroy@/ is called,
-- which will happen when the GdkTexture object is finalized, or due to
-- an explicit call of 'GI.Gdk.Objects.GLTexture.gLTextureRelease'.
gLTextureNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.GLContext.IsGLContext a) =>
    a
    -- ^ /@context@/: a @GdkGLContext@
    -> Word32
    -- ^ /@id@/: the ID of a texture that was created with /@context@/
    -> Int32
    -- ^ /@width@/: the nominal width of the texture
    -> Int32
    -- ^ /@height@/: the nominal height of the texture
    -> GLib.Callbacks.DestroyNotify
    -- ^ /@destroy@/: a destroy notify that will be called when the GL resources
    --   are released
    -> Ptr ()
    -- ^ /@data@/: data that gets passed to /@destroy@/
    -> m GLTexture
    -- ^ __Returns:__ A newly-created
    --   @GdkTexture@
gLTextureNew context id width height destroy data_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
    destroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) destroy)
    poke ptrdestroy destroy'
    result <- gdk_gl_texture_new context' id width height destroy' data_
    checkUnexpectedReturnNULL "gLTextureNew" result
    result' <- (wrapObject GLTexture) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GLTexture::release
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLTexture" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkTexture` wrapping a GL texture"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_texture_release" gdk_gl_texture_release :: 
    Ptr GLTexture ->                        -- self : TInterface (Name {namespace = "Gdk", name = "GLTexture"})
    IO ()

-- | Releases the GL resources held by a @GdkGLTexture@.
-- 
-- The texture contents are still available via the
-- 'GI.Gdk.Objects.Texture.textureDownload' function, after this
-- function has been called.
gLTextureRelease ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLTexture a) =>
    a
    -- ^ /@self@/: a @GdkTexture@ wrapping a GL texture
    -> m ()
gLTextureRelease self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gdk_gl_texture_release self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data GLTextureReleaseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsGLTexture a) => O.OverloadedMethod GLTextureReleaseMethodInfo a signature where
    overloadedMethod = gLTextureRelease

instance O.OverloadedMethodInfo GLTextureReleaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLTexture.gLTextureRelease",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-GLTexture.html#v:gLTextureRelease"
        })


#endif


