{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK interface which provides standard mechanism for manipulating hyperlinks.
-- 
-- An interface used for objects which implement linking between
-- multiple resource or content locations, or multiple \'markers\'
-- within a single document.  A Hypertext instance is associated with
-- one or more Hyperlinks, which are associated with particular
-- offsets within the Hypertext\'s included content.  While this
-- interface is derived from Text, there is no requirement that
-- Hypertext instances have textual content; they may implement Image
-- as well, and Hyperlinks need not have non-zero text offsets.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.Hypertext
    ( 

-- * Exported types
    Hypertext(..)                           ,
    IsHypertext                             ,
    toHypertext                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLink]("GI.Atk.Interfaces.Hypertext#g:method:getLink"), [getLinkIndex]("GI.Atk.Interfaces.Hypertext#g:method:getLinkIndex"), [getNLinks]("GI.Atk.Interfaces.Hypertext#g:method:getNLinks"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveHypertextMethod                  ,
#endif

-- ** getLink #method:getLink#

#if defined(ENABLE_OVERLOADING)
    HypertextGetLinkMethodInfo              ,
#endif
    hypertextGetLink                        ,


-- ** getLinkIndex #method:getLinkIndex#

#if defined(ENABLE_OVERLOADING)
    HypertextGetLinkIndexMethodInfo         ,
#endif
    hypertextGetLinkIndex                   ,


-- ** getNLinks #method:getNLinks#

#if defined(ENABLE_OVERLOADING)
    HypertextGetNLinksMethodInfo            ,
#endif
    hypertextGetNLinks                      ,




 -- * Signals


-- ** linkSelected #signal:linkSelected#

    HypertextLinkSelectedCallback           ,
#if defined(ENABLE_OVERLOADING)
    HypertextLinkSelectedSignalInfo         ,
#endif
    afterHypertextLinkSelected              ,
    onHypertextLinkSelected                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Objects.Hyperlink as Atk.Hyperlink
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Hyperlink as Atk.Hyperlink
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface Hypertext 
-- | Memory-managed wrapper type.
newtype Hypertext = Hypertext (SP.ManagedPtr Hypertext)
    deriving (Eq)

instance SP.ManagedPtrNewtype Hypertext where
    toManagedPtr (Hypertext p) = p

foreign import ccall "atk_hypertext_get_type"
    c_atk_hypertext_get_type :: IO B.Types.GType

instance B.Types.TypedObject Hypertext where
    glibType = c_atk_hypertext_get_type

instance B.Types.GObject Hypertext

-- | Type class for types which can be safely cast to t'Hypertext', for instance with `toHypertext`.
class (SP.GObject o, O.IsDescendantOf Hypertext o) => IsHypertext o
instance (SP.GObject o, O.IsDescendantOf Hypertext o) => IsHypertext o

instance O.HasParentTypes Hypertext
type instance O.ParentTypes Hypertext = '[GObject.Object.Object]

-- | Cast to t'Hypertext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toHypertext :: (MIO.MonadIO m, IsHypertext o) => o -> m Hypertext
toHypertext = MIO.liftIO . B.ManagedPtr.unsafeCastTo Hypertext

-- | Convert t'Hypertext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Hypertext) where
    gvalueGType_ = c_atk_hypertext_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Hypertext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Hypertext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Hypertext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Hypertext
type instance O.AttributeList Hypertext = HypertextAttributeList
type HypertextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveHypertextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHypertextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveHypertextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveHypertextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveHypertextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveHypertextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveHypertextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveHypertextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveHypertextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveHypertextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveHypertextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveHypertextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveHypertextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveHypertextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveHypertextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveHypertextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveHypertextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveHypertextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveHypertextMethod "getLink" o = HypertextGetLinkMethodInfo
    ResolveHypertextMethod "getLinkIndex" o = HypertextGetLinkIndexMethodInfo
    ResolveHypertextMethod "getNLinks" o = HypertextGetNLinksMethodInfo
    ResolveHypertextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveHypertextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveHypertextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveHypertextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveHypertextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveHypertextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHypertextMethod t Hypertext, O.OverloadedMethod info Hypertext p) => OL.IsLabel t (Hypertext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHypertextMethod t Hypertext, O.OverloadedMethod info Hypertext p, R.HasField t Hypertext p) => R.HasField t Hypertext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHypertextMethod t Hypertext, O.OverloadedMethodInfo info Hypertext) => OL.IsLabel t (O.MethodProxy info Hypertext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Hypertext::get_link
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hypertext"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hypertext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHypertext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "link_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an integer specifying the desired link"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Hyperlink" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_hypertext_get_link" atk_hypertext_get_link :: 
    Ptr Hypertext ->                        -- hypertext : TInterface (Name {namespace = "Atk", name = "Hypertext"})
    Int32 ->                                -- link_index : TBasicType TInt
    IO (Ptr Atk.Hyperlink.Hyperlink)

-- | Gets the link in this hypertext document at index
-- /@linkIndex@/
hypertextGetLink ::
    (B.CallStack.HasCallStack, MonadIO m, IsHypertext a) =>
    a
    -- ^ /@hypertext@/: an t'GI.Atk.Interfaces.Hypertext.Hypertext'
    -> Int32
    -- ^ /@linkIndex@/: an integer specifying the desired link
    -> m Atk.Hyperlink.Hyperlink
    -- ^ __Returns:__ the link in this hypertext document at
    -- index /@linkIndex@/
hypertextGetLink hypertext linkIndex = liftIO $ do
    hypertext' <- unsafeManagedPtrCastPtr hypertext
    result <- atk_hypertext_get_link hypertext' linkIndex
    checkUnexpectedReturnNULL "hypertextGetLink" result
    result' <- (newObject Atk.Hyperlink.Hyperlink) result
    touchManagedPtr hypertext
    return result'

#if defined(ENABLE_OVERLOADING)
data HypertextGetLinkMethodInfo
instance (signature ~ (Int32 -> m Atk.Hyperlink.Hyperlink), MonadIO m, IsHypertext a) => O.OverloadedMethod HypertextGetLinkMethodInfo a signature where
    overloadedMethod = hypertextGetLink

instance O.OverloadedMethodInfo HypertextGetLinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Hypertext.hypertextGetLink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Hypertext.html#v:hypertextGetLink"
        })


#endif

-- method Hypertext::get_link_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hypertext"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hypertext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHypertext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "char_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a character index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hypertext_get_link_index" atk_hypertext_get_link_index :: 
    Ptr Hypertext ->                        -- hypertext : TInterface (Name {namespace = "Atk", name = "Hypertext"})
    Int32 ->                                -- char_index : TBasicType TInt
    IO Int32

-- | Gets the index into the array of hyperlinks that is associated with
-- the character specified by /@charIndex@/.
hypertextGetLinkIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsHypertext a) =>
    a
    -- ^ /@hypertext@/: an t'GI.Atk.Interfaces.Hypertext.Hypertext'
    -> Int32
    -- ^ /@charIndex@/: a character index
    -> m Int32
    -- ^ __Returns:__ an index into the array of hyperlinks in /@hypertext@/,
    -- or -1 if there is no hyperlink associated with this character.
hypertextGetLinkIndex hypertext charIndex = liftIO $ do
    hypertext' <- unsafeManagedPtrCastPtr hypertext
    result <- atk_hypertext_get_link_index hypertext' charIndex
    touchManagedPtr hypertext
    return result

#if defined(ENABLE_OVERLOADING)
data HypertextGetLinkIndexMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsHypertext a) => O.OverloadedMethod HypertextGetLinkIndexMethodInfo a signature where
    overloadedMethod = hypertextGetLinkIndex

instance O.OverloadedMethodInfo HypertextGetLinkIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Hypertext.hypertextGetLinkIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Hypertext.html#v:hypertextGetLinkIndex"
        })


#endif

-- method Hypertext::get_n_links
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "hypertext"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hypertext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHypertext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hypertext_get_n_links" atk_hypertext_get_n_links :: 
    Ptr Hypertext ->                        -- hypertext : TInterface (Name {namespace = "Atk", name = "Hypertext"})
    IO Int32

-- | Gets the number of links within this hypertext document.
hypertextGetNLinks ::
    (B.CallStack.HasCallStack, MonadIO m, IsHypertext a) =>
    a
    -- ^ /@hypertext@/: an t'GI.Atk.Interfaces.Hypertext.Hypertext'
    -> m Int32
    -- ^ __Returns:__ the number of links within this hypertext document
hypertextGetNLinks hypertext = liftIO $ do
    hypertext' <- unsafeManagedPtrCastPtr hypertext
    result <- atk_hypertext_get_n_links hypertext'
    touchManagedPtr hypertext
    return result

#if defined(ENABLE_OVERLOADING)
data HypertextGetNLinksMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsHypertext a) => O.OverloadedMethod HypertextGetNLinksMethodInfo a signature where
    overloadedMethod = hypertextGetNLinks

instance O.OverloadedMethodInfo HypertextGetNLinksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Hypertext.hypertextGetNLinks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Hypertext.html#v:hypertextGetNLinks"
        })


#endif

-- signal Hypertext::link-selected
-- | The \"link-selected\" signal is emitted by an AtkHyperText
-- object when one of the hyperlinks associated with the object
-- is selected.
type HypertextLinkSelectedCallback =
    Int32
    -- ^ /@arg1@/: the index of the hyperlink which is selected
    -> IO ()

type C_HypertextLinkSelectedCallback =
    Ptr Hypertext ->                        -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_HypertextLinkSelectedCallback`.
foreign import ccall "wrapper"
    mk_HypertextLinkSelectedCallback :: C_HypertextLinkSelectedCallback -> IO (FunPtr C_HypertextLinkSelectedCallback)

wrap_HypertextLinkSelectedCallback :: 
    GObject a => (a -> HypertextLinkSelectedCallback) ->
    C_HypertextLinkSelectedCallback
wrap_HypertextLinkSelectedCallback gi'cb gi'selfPtr arg1 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1


-- | Connect a signal handler for the [linkSelected](#signal:linkSelected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' hypertext #linkSelected callback
-- @
-- 
-- 
onHypertextLinkSelected :: (IsHypertext a, MonadIO m) => a -> ((?self :: a) => HypertextLinkSelectedCallback) -> m SignalHandlerId
onHypertextLinkSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_HypertextLinkSelectedCallback wrapped
    wrapped'' <- mk_HypertextLinkSelectedCallback wrapped'
    connectSignalFunPtr obj "link-selected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [linkSelected](#signal:linkSelected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' hypertext #linkSelected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterHypertextLinkSelected :: (IsHypertext a, MonadIO m) => a -> ((?self :: a) => HypertextLinkSelectedCallback) -> m SignalHandlerId
afterHypertextLinkSelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_HypertextLinkSelectedCallback wrapped
    wrapped'' <- mk_HypertextLinkSelectedCallback wrapped'
    connectSignalFunPtr obj "link-selected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data HypertextLinkSelectedSignalInfo
instance SignalInfo HypertextLinkSelectedSignalInfo where
    type HaskellCallbackType HypertextLinkSelectedSignalInfo = HypertextLinkSelectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_HypertextLinkSelectedCallback cb
        cb'' <- mk_HypertextLinkSelectedCallback cb'
        connectSignalFunPtr obj "link-selected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Hypertext::link-selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-Hypertext.html#g:signal:linkSelected"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Hypertext = HypertextSignalList
type HypertextSignalList = ('[ '("linkSelected", HypertextLinkSelectedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


