{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A queryable interface which allows AtkHyperlink instances
-- associated with an AtkObject to be obtained.  AtkHyperlinkImpl
-- corresponds to AT-SPI\'s Hyperlink interface, and differs from
-- AtkHyperlink in that AtkHyperlink is an object type, rather than an
-- interface, and thus cannot be directly queried. FTW

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.HyperlinkImpl
    ( 

-- * Exported types
    HyperlinkImpl(..)                       ,
    IsHyperlinkImpl                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- /None/.
-- 
-- ==== Getters
-- [getHyperlink]("GI.Atk.Interfaces.HyperlinkImpl#g:method:getHyperlink").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveHyperlinkImplMethod              ,
#endif

-- ** getHyperlink #method:getHyperlink#

#if defined(ENABLE_OVERLOADING)
    HyperlinkImplGetHyperlinkMethodInfo     ,
#endif
    hyperlinkImplGetHyperlink               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Objects.Hyperlink as Atk.Hyperlink
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Hyperlink as Atk.Hyperlink

#endif

-- interface HyperlinkImpl 
-- | Memory-managed wrapper type.
newtype HyperlinkImpl = HyperlinkImpl (SP.ManagedPtr HyperlinkImpl)
    deriving (Eq)

instance SP.ManagedPtrNewtype HyperlinkImpl where
    toManagedPtr (HyperlinkImpl p) = p

-- | Type class for types which implement t'HyperlinkImpl'.
class (ManagedPtrNewtype o, O.IsDescendantOf HyperlinkImpl o) => IsHyperlinkImpl o
instance (ManagedPtrNewtype o, O.IsDescendantOf HyperlinkImpl o) => IsHyperlinkImpl o
-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr HyperlinkImpl where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
type family ResolveHyperlinkImplMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHyperlinkImplMethod "getHyperlink" o = HyperlinkImplGetHyperlinkMethodInfo
    ResolveHyperlinkImplMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHyperlinkImplMethod t HyperlinkImpl, O.OverloadedMethod info HyperlinkImpl p) => OL.IsLabel t (HyperlinkImpl -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHyperlinkImplMethod t HyperlinkImpl, O.OverloadedMethod info HyperlinkImpl p, R.HasField t HyperlinkImpl p) => R.HasField t HyperlinkImpl p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHyperlinkImplMethod t HyperlinkImpl, O.OverloadedMethodInfo info HyperlinkImpl) => OL.IsLabel t (O.MethodProxy info HyperlinkImpl) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method HyperlinkImpl::get_hyperlink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "impl"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "HyperlinkImpl" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkHyperlinkImplIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Hyperlink" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_impl_get_hyperlink" atk_hyperlink_impl_get_hyperlink :: 
    Ptr HyperlinkImpl ->                    -- impl : TInterface (Name {namespace = "Atk", name = "HyperlinkImpl"})
    IO (Ptr Atk.Hyperlink.Hyperlink)

-- | Gets the hyperlink associated with this object.
-- 
-- /Since: 1.12/
hyperlinkImplGetHyperlink ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlinkImpl a) =>
    a
    -- ^ /@impl@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkHyperlinkImplIface
    -> m Atk.Hyperlink.Hyperlink
    -- ^ __Returns:__ an AtkHyperlink object which points to this
    -- implementing AtkObject.
hyperlinkImplGetHyperlink impl = liftIO $ do
    impl' <- unsafeManagedPtrCastPtr impl
    result <- atk_hyperlink_impl_get_hyperlink impl'
    checkUnexpectedReturnNULL "hyperlinkImplGetHyperlink" result
    result' <- (wrapObject Atk.Hyperlink.Hyperlink) result
    touchManagedPtr impl
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkImplGetHyperlinkMethodInfo
instance (signature ~ (m Atk.Hyperlink.Hyperlink), MonadIO m, IsHyperlinkImpl a) => O.OverloadedMethod HyperlinkImplGetHyperlinkMethodInfo a signature where
    overloadedMethod = hyperlinkImplGetHyperlink

instance O.OverloadedMethodInfo HyperlinkImplGetHyperlinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.HyperlinkImpl.hyperlinkImplGetHyperlink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-HyperlinkImpl.html#v:hyperlinkImplGetHyperlink"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList HyperlinkImpl = HyperlinkImplSignalList
type HyperlinkImplSignalList = ('[ ] :: [(Symbol, DK.Type)])

#endif


