// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Span represents a single operation within a trace.
// See Span definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/trace/v1/trace.proto
type Span struct {
	TraceState             string
	Name                   string
	Attributes             []KeyValue
	Events                 []*SpanEvent
	Links                  []*SpanLink
	Status                 Status
	StartTimeUnixNano      uint64
	EndTimeUnixNano        uint64
	Flags                  uint32
	Kind                   SpanKind
	DroppedAttributesCount uint32
	DroppedEventsCount     uint32
	DroppedLinksCount      uint32
	TraceId                TraceID
	SpanId                 SpanID
	ParentSpanId           SpanID
}

var (
	protoPoolSpan = sync.Pool{
		New: func() any {
			return &Span{}
		},
	}
)

func NewSpan() *Span {
	if !UseProtoPooling.IsEnabled() {
		return &Span{}
	}
	return protoPoolSpan.Get().(*Span)
}

func DeleteSpan(orig *Span, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteTraceID(&orig.TraceId, false)
	DeleteSpanID(&orig.SpanId, false)

	DeleteSpanID(&orig.ParentSpanId, false)

	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	for i := range orig.Events {
		DeleteSpanEvent(orig.Events[i], true)
	}

	for i := range orig.Links {
		DeleteSpanLink(orig.Links[i], true)
	}

	DeleteStatus(&orig.Status, false)
	orig.Reset()
	if nullable {
		protoPoolSpan.Put(orig)
	}
}

func CopySpan(dest, src *Span) *Span {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSpan()
	}
	CopyTraceID(&dest.TraceId, &src.TraceId)

	CopySpanID(&dest.SpanId, &src.SpanId)

	dest.TraceState = src.TraceState
	CopySpanID(&dest.ParentSpanId, &src.ParentSpanId)

	dest.Flags = src.Flags
	dest.Name = src.Name
	dest.Kind = src.Kind
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.EndTimeUnixNano = src.EndTimeUnixNano
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Events = CopySpanEventPtrSlice(dest.Events, src.Events)

	dest.DroppedEventsCount = src.DroppedEventsCount
	dest.Links = CopySpanLinkPtrSlice(dest.Links, src.Links)

	dest.DroppedLinksCount = src.DroppedLinksCount
	CopyStatus(&dest.Status, &src.Status)

	return dest
}

func CopySpanSlice(dest, src []Span) []Span {
	var newDest []Span
	if cap(dest) < len(src) {
		newDest = make([]Span, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpan(&dest[i], false)
		}
	}
	for i := range src {
		CopySpan(&newDest[i], &src[i])
	}
	return newDest
}

func CopySpanPtrSlice(dest, src []*Span) []*Span {
	var newDest []*Span
	if cap(dest) < len(src) {
		newDest = make([]*Span, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpan()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpan(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpan()
		}
	}
	for i := range src {
		CopySpan(newDest[i], src[i])
	}
	return newDest
}

func (orig *Span) Reset() {
	*orig = Span{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Span) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if !orig.TraceId.IsEmpty() {
		dest.WriteObjectField("traceId")
		orig.TraceId.MarshalJSON(dest)
	}
	if !orig.SpanId.IsEmpty() {
		dest.WriteObjectField("spanId")
		orig.SpanId.MarshalJSON(dest)
	}
	if orig.TraceState != "" {
		dest.WriteObjectField("traceState")
		dest.WriteString(orig.TraceState)
	}
	if !orig.ParentSpanId.IsEmpty() {
		dest.WriteObjectField("parentSpanId")
		orig.ParentSpanId.MarshalJSON(dest)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig.Name != "" {
		dest.WriteObjectField("name")
		dest.WriteString(orig.Name)
	}

	if int32(orig.Kind) != 0 {
		dest.WriteObjectField("kind")
		dest.WriteInt32(int32(orig.Kind))
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.EndTimeUnixNano != uint64(0) {
		dest.WriteObjectField("endTimeUnixNano")
		dest.WriteUint64(orig.EndTimeUnixNano)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if len(orig.Events) > 0 {
		dest.WriteObjectField("events")
		dest.WriteArrayStart()
		orig.Events[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Events); i++ {
			dest.WriteMore()
			orig.Events[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedEventsCount != uint32(0) {
		dest.WriteObjectField("droppedEventsCount")
		dest.WriteUint32(orig.DroppedEventsCount)
	}
	if len(orig.Links) > 0 {
		dest.WriteObjectField("links")
		dest.WriteArrayStart()
		orig.Links[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Links); i++ {
			dest.WriteMore()
			orig.Links[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedLinksCount != uint32(0) {
		dest.WriteObjectField("droppedLinksCount")
		dest.WriteUint32(orig.DroppedLinksCount)
	}
	dest.WriteObjectField("status")
	orig.Status.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Span) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "traceId", "trace_id":

			orig.TraceId.UnmarshalJSON(iter)
		case "spanId", "span_id":

			orig.SpanId.UnmarshalJSON(iter)
		case "traceState", "trace_state":
			orig.TraceState = iter.ReadString()
		case "parentSpanId", "parent_span_id":

			orig.ParentSpanId.UnmarshalJSON(iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "name":
			orig.Name = iter.ReadString()
		case "kind":
			orig.Kind = SpanKind(iter.ReadEnumValue(SpanKind_value))
		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "endTimeUnixNano", "end_time_unix_nano":
			orig.EndTimeUnixNano = iter.ReadUint64()
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "events":
			for iter.ReadArray() {
				orig.Events = append(orig.Events, NewSpanEvent())
				orig.Events[len(orig.Events)-1].UnmarshalJSON(iter)
			}

		case "droppedEventsCount", "dropped_events_count":
			orig.DroppedEventsCount = iter.ReadUint32()
		case "links":
			for iter.ReadArray() {
				orig.Links = append(orig.Links, NewSpanLink())
				orig.Links[len(orig.Links)-1].UnmarshalJSON(iter)
			}

		case "droppedLinksCount", "dropped_links_count":
			orig.DroppedLinksCount = iter.ReadUint32()
		case "status":

			orig.Status.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *Span) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.TraceId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l

	l = len(orig.TraceState)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.ParentSpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != uint32(0) {
		n += 6
	}

	l = len(orig.Name)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Kind != SpanKind(0) {
		n += 1 + proto.Sov(uint64(orig.Kind))
	}
	if orig.StartTimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.EndTimeUnixNano != uint64(0) {
		n += 9
	}
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	for i := range orig.Events {
		l = orig.Events[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedEventsCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedEventsCount))
	}
	for i := range orig.Links {
		l = orig.Links[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedLinksCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedLinksCount))
	}
	l = orig.Status.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *Span) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.TraceId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = orig.SpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	l = len(orig.TraceState)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.TraceState)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	l = orig.ParentSpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x22

	if orig.Flags != uint32(0) {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x1
		pos--
		buf[pos] = 0x85
	}
	l = len(orig.Name)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Name)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	if orig.Kind != SpanKind(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Kind))
		pos--
		buf[pos] = 0x30
	}
	if orig.StartTimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x39
	}
	if orig.EndTimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.EndTimeUnixNano))
		pos--
		buf[pos] = 0x41
	}
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x4a
	}
	if orig.DroppedAttributesCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x50
	}
	for i := len(orig.Events) - 1; i >= 0; i-- {
		l = orig.Events[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig.DroppedEventsCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedEventsCount))
		pos--
		buf[pos] = 0x60
	}
	for i := len(orig.Links) - 1; i >= 0; i-- {
		l = orig.Links[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x6a
	}
	if orig.DroppedLinksCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedLinksCount))
		pos--
		buf[pos] = 0x70
	}
	l = orig.Status.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x7a

	return len(buf) - pos
}

func (orig *Span) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.TraceState = string(buf[startPos:pos])

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.ParentSpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 16:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Name = string(buf[startPos:pos])

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Kind = SpanKind(num)

		case 7:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 8:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.EndTimeUnixNano = uint64(num)

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedAttributesCount = uint32(num)

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Events = append(orig.Events, NewSpanEvent())
			err = orig.Events[len(orig.Events)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedEventsCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedEventsCount = uint32(num)

		case 13:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Links", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Links = append(orig.Links, NewSpanLink())
			err = orig.Links[len(orig.Links)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 14:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedLinksCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedLinksCount = uint32(num)

		case 15:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Status.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSpan() *Span {
	orig := NewSpan()
	orig.TraceId = *GenTestTraceID()
	orig.SpanId = *GenTestSpanID()
	orig.TraceState = "test_tracestate"
	orig.ParentSpanId = *GenTestSpanID()
	orig.Flags = uint32(13)
	orig.Name = "test_name"
	orig.Kind = SpanKind(13)
	orig.StartTimeUnixNano = uint64(13)
	orig.EndTimeUnixNano = uint64(13)
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.DroppedAttributesCount = uint32(13)
	orig.Events = []*SpanEvent{{}, GenTestSpanEvent()}
	orig.DroppedEventsCount = uint32(13)
	orig.Links = []*SpanLink{{}, GenTestSpanLink()}
	orig.DroppedLinksCount = uint32(13)
	orig.Status = *GenTestStatus()
	return orig
}

func GenTestSpanPtrSlice() []*Span {
	orig := make([]*Span, 5)
	orig[0] = NewSpan()
	orig[1] = GenTestSpan()
	orig[2] = NewSpan()
	orig[3] = GenTestSpan()
	orig[4] = NewSpan()
	return orig
}

func GenTestSpanSlice() []Span {
	orig := make([]Span, 5)
	orig[1] = *GenTestSpan()
	orig[3] = *GenTestSpan()
	return orig
}
