// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ProfilesDictionary is the reference table containing all data shared by profiles across the message being sent.
type ProfilesDictionary struct {
	MappingTable   []*Mapping
	LocationTable  []*Location
	FunctionTable  []*Function
	LinkTable      []*Link
	StringTable    []string
	AttributeTable []*KeyValueAndUnit
	StackTable     []*Stack
}

var (
	protoPoolProfilesDictionary = sync.Pool{
		New: func() any {
			return &ProfilesDictionary{}
		},
	}
)

func NewProfilesDictionary() *ProfilesDictionary {
	if !UseProtoPooling.IsEnabled() {
		return &ProfilesDictionary{}
	}
	return protoPoolProfilesDictionary.Get().(*ProfilesDictionary)
}

func DeleteProfilesDictionary(orig *ProfilesDictionary, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.MappingTable {
		DeleteMapping(orig.MappingTable[i], true)
	}
	for i := range orig.LocationTable {
		DeleteLocation(orig.LocationTable[i], true)
	}
	for i := range orig.FunctionTable {
		DeleteFunction(orig.FunctionTable[i], true)
	}
	for i := range orig.LinkTable {
		DeleteLink(orig.LinkTable[i], true)
	}

	for i := range orig.AttributeTable {
		DeleteKeyValueAndUnit(orig.AttributeTable[i], true)
	}
	for i := range orig.StackTable {
		DeleteStack(orig.StackTable[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolProfilesDictionary.Put(orig)
	}
}

func CopyProfilesDictionary(dest, src *ProfilesDictionary) *ProfilesDictionary {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewProfilesDictionary()
	}
	dest.MappingTable = CopyMappingPtrSlice(dest.MappingTable, src.MappingTable)

	dest.LocationTable = CopyLocationPtrSlice(dest.LocationTable, src.LocationTable)

	dest.FunctionTable = CopyFunctionPtrSlice(dest.FunctionTable, src.FunctionTable)

	dest.LinkTable = CopyLinkPtrSlice(dest.LinkTable, src.LinkTable)

	dest.StringTable = append(dest.StringTable[:0], src.StringTable...)

	dest.AttributeTable = CopyKeyValueAndUnitPtrSlice(dest.AttributeTable, src.AttributeTable)

	dest.StackTable = CopyStackPtrSlice(dest.StackTable, src.StackTable)

	return dest
}

func CopyProfilesDictionarySlice(dest, src []ProfilesDictionary) []ProfilesDictionary {
	var newDest []ProfilesDictionary
	if cap(dest) < len(src) {
		newDest = make([]ProfilesDictionary, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfilesDictionary(&dest[i], false)
		}
	}
	for i := range src {
		CopyProfilesDictionary(&newDest[i], &src[i])
	}
	return newDest
}

func CopyProfilesDictionaryPtrSlice(dest, src []*ProfilesDictionary) []*ProfilesDictionary {
	var newDest []*ProfilesDictionary
	if cap(dest) < len(src) {
		newDest = make([]*ProfilesDictionary, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfilesDictionary()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfilesDictionary(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfilesDictionary()
		}
	}
	for i := range src {
		CopyProfilesDictionary(newDest[i], src[i])
	}
	return newDest
}

func (orig *ProfilesDictionary) Reset() {
	*orig = ProfilesDictionary{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ProfilesDictionary) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.MappingTable) > 0 {
		dest.WriteObjectField("mappingTable")
		dest.WriteArrayStart()
		orig.MappingTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.MappingTable); i++ {
			dest.WriteMore()
			orig.MappingTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LocationTable) > 0 {
		dest.WriteObjectField("locationTable")
		dest.WriteArrayStart()
		orig.LocationTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.LocationTable); i++ {
			dest.WriteMore()
			orig.LocationTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.FunctionTable) > 0 {
		dest.WriteObjectField("functionTable")
		dest.WriteArrayStart()
		orig.FunctionTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.FunctionTable); i++ {
			dest.WriteMore()
			orig.FunctionTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.LinkTable) > 0 {
		dest.WriteObjectField("linkTable")
		dest.WriteArrayStart()
		orig.LinkTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.LinkTable); i++ {
			dest.WriteMore()
			orig.LinkTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.StringTable) > 0 {
		dest.WriteObjectField("stringTable")
		dest.WriteArrayStart()
		dest.WriteString(orig.StringTable[0])
		for i := 1; i < len(orig.StringTable); i++ {
			dest.WriteMore()
			dest.WriteString(orig.StringTable[i])
		}
		dest.WriteArrayEnd()
	}

	if len(orig.AttributeTable) > 0 {
		dest.WriteObjectField("attributeTable")
		dest.WriteArrayStart()
		orig.AttributeTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.AttributeTable); i++ {
			dest.WriteMore()
			orig.AttributeTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.StackTable) > 0 {
		dest.WriteObjectField("stackTable")
		dest.WriteArrayStart()
		orig.StackTable[0].MarshalJSON(dest)
		for i := 1; i < len(orig.StackTable); i++ {
			dest.WriteMore()
			orig.StackTable[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ProfilesDictionary) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "mappingTable", "mapping_table":
			for iter.ReadArray() {
				orig.MappingTable = append(orig.MappingTable, NewMapping())
				orig.MappingTable[len(orig.MappingTable)-1].UnmarshalJSON(iter)
			}

		case "locationTable", "location_table":
			for iter.ReadArray() {
				orig.LocationTable = append(orig.LocationTable, NewLocation())
				orig.LocationTable[len(orig.LocationTable)-1].UnmarshalJSON(iter)
			}

		case "functionTable", "function_table":
			for iter.ReadArray() {
				orig.FunctionTable = append(orig.FunctionTable, NewFunction())
				orig.FunctionTable[len(orig.FunctionTable)-1].UnmarshalJSON(iter)
			}

		case "linkTable", "link_table":
			for iter.ReadArray() {
				orig.LinkTable = append(orig.LinkTable, NewLink())
				orig.LinkTable[len(orig.LinkTable)-1].UnmarshalJSON(iter)
			}

		case "stringTable", "string_table":
			for iter.ReadArray() {
				orig.StringTable = append(orig.StringTable, iter.ReadString())
			}

		case "attributeTable", "attribute_table":
			for iter.ReadArray() {
				orig.AttributeTable = append(orig.AttributeTable, NewKeyValueAndUnit())
				orig.AttributeTable[len(orig.AttributeTable)-1].UnmarshalJSON(iter)
			}

		case "stackTable", "stack_table":
			for iter.ReadArray() {
				orig.StackTable = append(orig.StackTable, NewStack())
				orig.StackTable[len(orig.StackTable)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ProfilesDictionary) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.MappingTable {
		l = orig.MappingTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LocationTable {
		l = orig.LocationTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.FunctionTable {
		l = orig.FunctionTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.LinkTable {
		l = orig.LinkTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for _, s := range orig.StringTable {
		l = len(s)
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.AttributeTable {
		l = orig.AttributeTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.StackTable {
		l = orig.StackTable[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ProfilesDictionary) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.MappingTable) - 1; i >= 0; i-- {
		l = orig.MappingTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	for i := len(orig.LocationTable) - 1; i >= 0; i-- {
		l = orig.LocationTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	for i := len(orig.FunctionTable) - 1; i >= 0; i-- {
		l = orig.FunctionTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.LinkTable) - 1; i >= 0; i-- {
		l = orig.LinkTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	for i := len(orig.StringTable) - 1; i >= 0; i-- {
		l = len(orig.StringTable[i])
		pos -= l
		copy(buf[pos:], orig.StringTable[i])
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	for i := len(orig.AttributeTable) - 1; i >= 0; i-- {
		l = orig.AttributeTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	for i := len(orig.StackTable) - 1; i >= 0; i-- {
		l = orig.StackTable[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	return len(buf) - pos
}

func (orig *ProfilesDictionary) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.MappingTable = append(orig.MappingTable, NewMapping())
			err = orig.MappingTable[len(orig.MappingTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LocationTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.LocationTable = append(orig.LocationTable, NewLocation())
			err = orig.LocationTable[len(orig.LocationTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.FunctionTable = append(orig.FunctionTable, NewFunction())
			err = orig.FunctionTable[len(orig.FunctionTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.LinkTable = append(orig.LinkTable, NewLink())
			err = orig.LinkTable[len(orig.LinkTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field StringTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.StringTable = append(orig.StringTable, string(buf[startPos:pos]))

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.AttributeTable = append(orig.AttributeTable, NewKeyValueAndUnit())
			err = orig.AttributeTable[len(orig.AttributeTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field StackTable", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.StackTable = append(orig.StackTable, NewStack())
			err = orig.StackTable[len(orig.StackTable)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestProfilesDictionary() *ProfilesDictionary {
	orig := NewProfilesDictionary()
	orig.MappingTable = []*Mapping{{}, GenTestMapping()}
	orig.LocationTable = []*Location{{}, GenTestLocation()}
	orig.FunctionTable = []*Function{{}, GenTestFunction()}
	orig.LinkTable = []*Link{{}, GenTestLink()}
	orig.StringTable = []string{"", "test_stringtable"}
	orig.AttributeTable = []*KeyValueAndUnit{{}, GenTestKeyValueAndUnit()}
	orig.StackTable = []*Stack{{}, GenTestStack()}
	return orig
}

func GenTestProfilesDictionaryPtrSlice() []*ProfilesDictionary {
	orig := make([]*ProfilesDictionary, 5)
	orig[0] = NewProfilesDictionary()
	orig[1] = GenTestProfilesDictionary()
	orig[2] = NewProfilesDictionary()
	orig[3] = GenTestProfilesDictionary()
	orig[4] = NewProfilesDictionary()
	return orig
}

func GenTestProfilesDictionarySlice() []ProfilesDictionary {
	orig := make([]ProfilesDictionary, 5)
	orig[1] = *GenTestProfilesDictionary()
	orig[3] = *GenTestProfilesDictionary()
	return orig
}
