// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// KeyValueList is a list of KeyValue messages. We need KeyValueList as a message since oneof in AnyValue does not allow repeated fields.
type KeyValueList struct {
	Values []KeyValue
}

var (
	protoPoolKeyValueList = sync.Pool{
		New: func() any {
			return &KeyValueList{}
		},
	}
)

func NewKeyValueList() *KeyValueList {
	if !UseProtoPooling.IsEnabled() {
		return &KeyValueList{}
	}
	return protoPoolKeyValueList.Get().(*KeyValueList)
}

func DeleteKeyValueList(orig *KeyValueList, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.Values {
		DeleteKeyValue(&orig.Values[i], false)
	}
	orig.Reset()
	if nullable {
		protoPoolKeyValueList.Put(orig)
	}
}

func CopyKeyValueList(dest, src *KeyValueList) *KeyValueList {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewKeyValueList()
	}
	dest.Values = CopyKeyValueSlice(dest.Values, src.Values)

	return dest
}

func CopyKeyValueListSlice(dest, src []KeyValueList) []KeyValueList {
	var newDest []KeyValueList
	if cap(dest) < len(src) {
		newDest = make([]KeyValueList, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValueList(&dest[i], false)
		}
	}
	for i := range src {
		CopyKeyValueList(&newDest[i], &src[i])
	}
	return newDest
}

func CopyKeyValueListPtrSlice(dest, src []*KeyValueList) []*KeyValueList {
	var newDest []*KeyValueList
	if cap(dest) < len(src) {
		newDest = make([]*KeyValueList, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValueList()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValueList(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValueList()
		}
	}
	for i := range src {
		CopyKeyValueList(newDest[i], src[i])
	}
	return newDest
}

func (orig *KeyValueList) Reset() {
	*orig = KeyValueList{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *KeyValueList) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Values) > 0 {
		dest.WriteObjectField("values")
		dest.WriteArrayStart()
		orig.Values[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Values); i++ {
			dest.WriteMore()
			orig.Values[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *KeyValueList) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "values":
			for iter.ReadArray() {
				orig.Values = append(orig.Values, KeyValue{})
				orig.Values[len(orig.Values)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *KeyValueList) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Values {
		l = orig.Values[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *KeyValueList) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Values) - 1; i >= 0; i-- {
		l = orig.Values[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *KeyValueList) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Values = append(orig.Values, KeyValue{})
			err = orig.Values[len(orig.Values)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestKeyValueList() *KeyValueList {
	orig := NewKeyValueList()
	orig.Values = []KeyValue{{}, *GenTestKeyValue()}
	return orig
}

func GenTestKeyValueListPtrSlice() []*KeyValueList {
	orig := make([]*KeyValueList, 5)
	orig[0] = NewKeyValueList()
	orig[1] = GenTestKeyValueList()
	orig[2] = NewKeyValueList()
	orig[3] = GenTestKeyValueList()
	orig[4] = NewKeyValueList()
	return orig
}

func GenTestKeyValueListSlice() []KeyValueList {
	orig := make([]KeyValueList, 5)
	orig[1] = *GenTestKeyValueList()
	orig[3] = *GenTestKeyValueList()
	return orig
}
