// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Metrics is the top-level struct that is propagated through the metrics pipeline.
// Use NewMetrics to create new instance, zero-initialized instance is not valid for use.
type ExportMetricsServiceRequest struct {
	ResourceMetrics []*ResourceMetrics
}

var (
	protoPoolExportMetricsServiceRequest = sync.Pool{
		New: func() any {
			return &ExportMetricsServiceRequest{}
		},
	}
)

func NewExportMetricsServiceRequest() *ExportMetricsServiceRequest {
	if !UseProtoPooling.IsEnabled() {
		return &ExportMetricsServiceRequest{}
	}
	return protoPoolExportMetricsServiceRequest.Get().(*ExportMetricsServiceRequest)
}

func DeleteExportMetricsServiceRequest(orig *ExportMetricsServiceRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.ResourceMetrics {
		DeleteResourceMetrics(orig.ResourceMetrics[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolExportMetricsServiceRequest.Put(orig)
	}
}

func CopyExportMetricsServiceRequest(dest, src *ExportMetricsServiceRequest) *ExportMetricsServiceRequest {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportMetricsServiceRequest()
	}
	dest.ResourceMetrics = CopyResourceMetricsPtrSlice(dest.ResourceMetrics, src.ResourceMetrics)

	return dest
}

func CopyExportMetricsServiceRequestSlice(dest, src []ExportMetricsServiceRequest) []ExportMetricsServiceRequest {
	var newDest []ExportMetricsServiceRequest
	if cap(dest) < len(src) {
		newDest = make([]ExportMetricsServiceRequest, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsServiceRequest(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportMetricsServiceRequest(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportMetricsServiceRequestPtrSlice(dest, src []*ExportMetricsServiceRequest) []*ExportMetricsServiceRequest {
	var newDest []*ExportMetricsServiceRequest
	if cap(dest) < len(src) {
		newDest = make([]*ExportMetricsServiceRequest, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsServiceRequest()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsServiceRequest(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsServiceRequest()
		}
	}
	for i := range src {
		CopyExportMetricsServiceRequest(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportMetricsServiceRequest) Reset() {
	*orig = ExportMetricsServiceRequest{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportMetricsServiceRequest) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceMetrics) > 0 {
		dest.WriteObjectField("resourceMetrics")
		dest.WriteArrayStart()
		orig.ResourceMetrics[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ResourceMetrics); i++ {
			dest.WriteMore()
			orig.ResourceMetrics[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportMetricsServiceRequest) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceMetrics", "resource_metrics":
			for iter.ReadArray() {
				orig.ResourceMetrics = append(orig.ResourceMetrics, NewResourceMetrics())
				orig.ResourceMetrics[len(orig.ResourceMetrics)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ExportMetricsServiceRequest) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceMetrics {
		l = orig.ResourceMetrics[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExportMetricsServiceRequest) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceMetrics) - 1; i >= 0; i-- {
		l = orig.ResourceMetrics[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *ExportMetricsServiceRequest) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceMetrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceMetrics = append(orig.ResourceMetrics, NewResourceMetrics())
			err = orig.ResourceMetrics[len(orig.ResourceMetrics)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportMetricsServiceRequest() *ExportMetricsServiceRequest {
	orig := NewExportMetricsServiceRequest()
	orig.ResourceMetrics = []*ResourceMetrics{{}, GenTestResourceMetrics()}
	return orig
}

func GenTestExportMetricsServiceRequestPtrSlice() []*ExportMetricsServiceRequest {
	orig := make([]*ExportMetricsServiceRequest, 5)
	orig[0] = NewExportMetricsServiceRequest()
	orig[1] = GenTestExportMetricsServiceRequest()
	orig[2] = NewExportMetricsServiceRequest()
	orig[3] = GenTestExportMetricsServiceRequest()
	orig[4] = NewExportMetricsServiceRequest()
	return orig
}

func GenTestExportMetricsServiceRequestSlice() []ExportMetricsServiceRequest {
	orig := make([]ExportMetricsServiceRequest, 5)
	orig[1] = *GenTestExportMetricsServiceRequest()
	orig[3] = *GenTestExportMetricsServiceRequest()
	return orig
}
