// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExponentialHistogramDataPointBuckets are a set of bucket counts, encoded in a contiguous array of counts.
type ExponentialHistogramDataPointBuckets struct {
	BucketCounts []uint64
	Offset       int32
}

var (
	protoPoolExponentialHistogramDataPointBuckets = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPointBuckets{}
		},
	}
)

func NewExponentialHistogramDataPointBuckets() *ExponentialHistogramDataPointBuckets {
	if !UseProtoPooling.IsEnabled() {
		return &ExponentialHistogramDataPointBuckets{}
	}
	return protoPoolExponentialHistogramDataPointBuckets.Get().(*ExponentialHistogramDataPointBuckets)
}

func DeleteExponentialHistogramDataPointBuckets(orig *ExponentialHistogramDataPointBuckets, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogramDataPointBuckets.Put(orig)
	}
}

func CopyExponentialHistogramDataPointBuckets(dest, src *ExponentialHistogramDataPointBuckets) *ExponentialHistogramDataPointBuckets {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExponentialHistogramDataPointBuckets()
	}
	dest.Offset = src.Offset
	dest.BucketCounts = append(dest.BucketCounts[:0], src.BucketCounts...)

	return dest
}

func CopyExponentialHistogramDataPointBucketsSlice(dest, src []ExponentialHistogramDataPointBuckets) []ExponentialHistogramDataPointBuckets {
	var newDest []ExponentialHistogramDataPointBuckets
	if cap(dest) < len(src) {
		newDest = make([]ExponentialHistogramDataPointBuckets, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPointBuckets(&dest[i], false)
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPointBuckets(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExponentialHistogramDataPointBucketsPtrSlice(dest, src []*ExponentialHistogramDataPointBuckets) []*ExponentialHistogramDataPointBuckets {
	var newDest []*ExponentialHistogramDataPointBuckets
	if cap(dest) < len(src) {
		newDest = make([]*ExponentialHistogramDataPointBuckets, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPointBuckets()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPointBuckets(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPointBuckets()
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPointBuckets(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExponentialHistogramDataPointBuckets) Reset() {
	*orig = ExponentialHistogramDataPointBuckets{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExponentialHistogramDataPointBuckets) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Offset != int32(0) {
		dest.WriteObjectField("offset")
		dest.WriteInt32(orig.Offset)
	}
	if len(orig.BucketCounts) > 0 {
		dest.WriteObjectField("bucketCounts")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.BucketCounts[0])
		for i := 1; i < len(orig.BucketCounts); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.BucketCounts[i])
		}
		dest.WriteArrayEnd()
	}

	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExponentialHistogramDataPointBuckets) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "offset":
			orig.Offset = iter.ReadInt32()
		case "bucketCounts", "bucket_counts":
			for iter.ReadArray() {
				orig.BucketCounts = append(orig.BucketCounts, iter.ReadUint64())
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ExponentialHistogramDataPointBuckets) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.Offset != int32(0) {
		n += 1 + proto.Soz(uint64(orig.Offset))
	}

	if len(orig.BucketCounts) > 0 {
		l = 0
		for _, e := range orig.BucketCounts {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ExponentialHistogramDataPointBuckets) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Offset != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Offset)<<1)^uint32(orig.Offset>>31)))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.BucketCounts[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *ExponentialHistogramDataPointBuckets) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Offset = int32(uint32(num>>1) ^ uint32(int32((num&1)<<31)>>31))
		case 2:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.BucketCounts = append(orig.BucketCounts, uint64(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field BucketCounts", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.BucketCounts = append(orig.BucketCounts, uint64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExponentialHistogramDataPointBuckets() *ExponentialHistogramDataPointBuckets {
	orig := NewExponentialHistogramDataPointBuckets()
	orig.Offset = int32(13)
	orig.BucketCounts = []uint64{uint64(0), uint64(13)}
	return orig
}

func GenTestExponentialHistogramDataPointBucketsPtrSlice() []*ExponentialHistogramDataPointBuckets {
	orig := make([]*ExponentialHistogramDataPointBuckets, 5)
	orig[0] = NewExponentialHistogramDataPointBuckets()
	orig[1] = GenTestExponentialHistogramDataPointBuckets()
	orig[2] = NewExponentialHistogramDataPointBuckets()
	orig[3] = GenTestExponentialHistogramDataPointBuckets()
	orig[4] = NewExponentialHistogramDataPointBuckets()
	return orig
}

func GenTestExponentialHistogramDataPointBucketsSlice() []ExponentialHistogramDataPointBuckets {
	orig := make([]ExponentialHistogramDataPointBuckets, 5)
	orig[1] = *GenTestExponentialHistogramDataPointBuckets()
	orig[3] = *GenTestExponentialHistogramDataPointBuckets()
	return orig
}
