// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package tctracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfGoAddrKeyT struct {
	_    structs.HostLayout
	Pid  uint64
	Addr uint64
}

type BpfHttpFuncInvocationT struct {
	_               structs.HostLayout
	StartMonotimeNs uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfHttpInfoT struct {
	_               structs.HostLayout
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        BpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ReqMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len             uint32
	RespLen         uint32
	TaskTid         uint32
	Status          uint16
	Buf             [256]uint8
	HasLargeBuffers uint8
	Direction       uint8
	Submitted       uint8
	Pad             [3]uint8
}

type BpfPidConnectionInfoT struct {
	_    structs.HostLayout
	Conn BpfConnectionInfoT
	Pid  uint32
}

type BpfTpInfoPidT struct {
	_  structs.HostLayout
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfConnectionInfoT
	Type uint32
}

// LoadBpf returns the embedded CollectionSpec for Bpf.
func LoadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Bpf: %w", err)
	}

	return spec, err
}

// LoadBpfObjects loads Bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfObjects
//	*BpfPrograms
//	*BpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfSpecs struct {
	BpfProgramSpecs
	BpfMapSpecs
	BpfVariableSpecs
}

// BpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfProgramSpecs struct {
	ObiAppEgress  *ebpf.ProgramSpec `ebpf:"obi_app_egress"`
	ObiAppIngress *ebpf.ProgramSpec `ebpf:"obi_app_ingress"`
}

// BpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfMapSpecs struct {
	GoOngoingHttp               *ebpf.MapSpec `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.MapSpec `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	MsgBufferMem                *ebpf.MapSpec `ebpf:"msg_buffer_mem"`
	OngoingHttp                 *ebpf.MapSpec `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.MapSpec `ebpf:"sock_dir"`
	TraceMap                    *ebpf.MapSpec `ebpf:"trace_map"`
}

// BpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfVariableSpecs struct {
	EXTEND_SIZE       *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX         *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2       *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// BpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfObjects struct {
	BpfPrograms
	BpfMaps
	BpfVariables
}

func (o *BpfObjects) Close() error {
	return _BpfClose(
		&o.BpfPrograms,
		&o.BpfMaps,
	)
}

// BpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfMaps struct {
	GoOngoingHttp               *ebpf.Map `ebpf:"go_ongoing_http"`
	GoOngoingHttpClientRequests *ebpf.Map `ebpf:"go_ongoing_http_client_requests"`
	IncomingTraceMap            *ebpf.Map `ebpf:"incoming_trace_map"`
	MsgBufferMem                *ebpf.Map `ebpf:"msg_buffer_mem"`
	OngoingHttp                 *ebpf.Map `ebpf:"ongoing_http"`
	OutgoingTraceMap            *ebpf.Map `ebpf:"outgoing_trace_map"`
	SockDir                     *ebpf.Map `ebpf:"sock_dir"`
	TraceMap                    *ebpf.Map `ebpf:"trace_map"`
}

func (m *BpfMaps) Close() error {
	return _BpfClose(
		m.GoOngoingHttp,
		m.GoOngoingHttpClientRequests,
		m.IncomingTraceMap,
		m.MsgBufferMem,
		m.OngoingHttp,
		m.OutgoingTraceMap,
		m.SockDir,
		m.TraceMap,
	)
}

// BpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfVariables struct {
	EXTEND_SIZE       *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS       *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX         *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE    *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	DisableBlackBoxCp *ebpf.Variable `ebpf:"disable_black_box_cp"`
	Ip4ip6Prefix      *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused            *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2       *ebpf.Variable `ebpf:"unused_http2"`
}

// BpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfPrograms struct {
	ObiAppEgress  *ebpf.Program `ebpf:"obi_app_egress"`
	ObiAppIngress *ebpf.Program `ebpf:"obi_app_ingress"`
}

func (p *BpfPrograms) Close() error {
	return _BpfClose(
		p.ObiAppEgress,
		p.ObiAppIngress,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
