// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package ebpfcommon

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfDnsReqT struct {
	_     structs.HostLayout
	Flags uint8
	DnsQ  uint8
	Pad1  [2]uint8
	Len   uint32
	Conn  BpfConnectionInfoT
	Id    uint16
	Pad2  [2]uint8
	Tp    struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Buf  [512]uint8
	Pad3 [4]uint8
}

type BpfHttp2GrpcRequestT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Type            uint8
	Pad0            [1]uint8
	ConnInfo        BpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Data            [256]uint8
	RetData         [64]uint8
	Len             int32
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	NewConnId uint64
	Tp        struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfHttpInfoT struct {
	_               structs.HostLayout
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        BpfConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ReqMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len             uint32
	RespLen         uint32
	TaskTid         uint32
	Status          uint16
	Buf             [256]uint8
	HasLargeBuffers uint8
	Direction       uint8
	Submitted       uint8
	Pad             [3]uint8
}

type BpfHttpRequestTraceT struct {
	_                 structs.HostLayout
	Type              uint8
	Pad0              [1]uint8
	Status            uint16
	Method            [7]uint8
	Scheme            [10]uint8
	Pad1              [11]uint8
	GoStartMonotimeNs uint64
	StartMonotimeNs   uint64
	EndMonotimeNs     uint64
	ContentLength     int64
	ResponseLength    int64
	Path              [100]uint8
	Pattern           [96]uint8
	Host              [100]uint8
	Tp                struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Conn BpfConnectionInfoT
	Pid  struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type BpfKafkaClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Pad             [7]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Buf             [256]uint8
	Conn            BpfConnectionInfoT
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
}

type BpfKafkaGoReqT struct {
	_    structs.HostLayout
	Type uint8
	Op   uint8
	Pad0 [2]uint8
	Pid  struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Conn BpfConnectionInfoT
	Pad1 [4]uint8
	Tp   struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Topic           [64]uint8
}

type BpfMongoGoClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Op   [32]uint8
	Db   [32]uint8
	Coll [32]uint8
	Conn BpfConnectionInfoT
	Tp   struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfOtelSpanT struct {
	_         structs.HostLayout
	Type      uint8
	Pad       [7]uint8
	StartTime uint64
	EndTime   uint64
	ParentGo  uint64
	Tp        struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	PrevTp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Status   uint32
	SpanName struct {
		_   structs.HostLayout
		Buf [64]uint8
	}
	SpanDescription struct {
		_   structs.HostLayout
		Buf [64]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	SpanAttrs struct {
		_     structs.HostLayout
		Attrs [16]struct {
			_         structs.HostLayout
			ValLength uint16
			Vtype     uint8
			Reserved  uint8
			Key       [32]uint8
			Value     [128]uint8
		}
		ValidAttrs uint8
		Apad       uint8
	}
	Epad [6]uint8
}

type BpfRedisClientReqT struct {
	_               structs.HostLayout
	Type            uint8
	Err             uint8
	Pad             [6]uint8
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Buf  [256]uint8
	Conn BpfConnectionInfoT
	Tp   struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfSqlRequestTraceT struct {
	_      structs.HostLayout
	Type   uint8
	Pad    [1]uint8
	Status uint16
	Pid    struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Conn BpfConnectionInfoT
	Sql  [500]uint8
}

type BpfTcpLargeBufferT struct {
	_          structs.HostLayout
	Type       uint8
	PacketType uint8
	Action     uint8
	Direction  uint8
	Len        uint32
	ConnInfo   BpfConnectionInfoT
	Pad2       uint32
	Tp         struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Buf [0]uint8
}

type BpfTcpReqT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Direction       uint8
	HasLargeBuffers uint8
	ProtocolType    uint8
	Pad1            [3]uint8
	ConnInfo        BpfConnectionInfoT
	Len             uint32
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	ReqLen          uint32
	RespLen         uint32
	Pad2            [4]uint8
	Buf             [256]uint8
	Rbuf            [128]uint8
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

// LoadBpf returns the embedded CollectionSpec for Bpf.
func LoadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Bpf: %w", err)
	}

	return spec, err
}

// LoadBpfObjects loads Bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfObjects
//	*BpfPrograms
//	*BpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfSpecs struct {
	BpfProgramSpecs
	BpfMapSpecs
	BpfVariableSpecs
}

// BpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfProgramSpecs struct {
}

// BpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfMapSpecs struct {
	MsgBufferMem *ebpf.MapSpec `ebpf:"msg_buffer_mem"`
}

// BpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfVariableSpecs struct {
	Ip4ip6Prefix *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.VariableSpec `ebpf:"unused"`
	Unused10     *ebpf.VariableSpec `ebpf:"unused_10"`
	Unused11     *ebpf.VariableSpec `ebpf:"unused_11"`
	Unused12     *ebpf.VariableSpec `ebpf:"unused_12"`
	Unused3      *ebpf.VariableSpec `ebpf:"unused_3"`
	Unused4      *ebpf.VariableSpec `ebpf:"unused_4"`
	Unused5      *ebpf.VariableSpec `ebpf:"unused_5"`
	Unused6      *ebpf.VariableSpec `ebpf:"unused_6"`
	Unused7      *ebpf.VariableSpec `ebpf:"unused_7"`
	Unused8      *ebpf.VariableSpec `ebpf:"unused_8"`
	Unused9      *ebpf.VariableSpec `ebpf:"unused_9"`
	UnusedHttp2  *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// BpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfObjects struct {
	BpfPrograms
	BpfMaps
	BpfVariables
}

func (o *BpfObjects) Close() error {
	return _BpfClose(
		&o.BpfPrograms,
		&o.BpfMaps,
	)
}

// BpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfMaps struct {
	MsgBufferMem *ebpf.Map `ebpf:"msg_buffer_mem"`
}

func (m *BpfMaps) Close() error {
	return _BpfClose(
		m.MsgBufferMem,
	)
}

// BpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfVariables struct {
	Ip4ip6Prefix *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.Variable `ebpf:"unused"`
	Unused10     *ebpf.Variable `ebpf:"unused_10"`
	Unused11     *ebpf.Variable `ebpf:"unused_11"`
	Unused12     *ebpf.Variable `ebpf:"unused_12"`
	Unused3      *ebpf.Variable `ebpf:"unused_3"`
	Unused4      *ebpf.Variable `ebpf:"unused_4"`
	Unused5      *ebpf.Variable `ebpf:"unused_5"`
	Unused6      *ebpf.Variable `ebpf:"unused_6"`
	Unused7      *ebpf.Variable `ebpf:"unused_7"`
	Unused8      *ebpf.Variable `ebpf:"unused_8"`
	Unused9      *ebpf.Variable `ebpf:"unused_9"`
	UnusedHttp2  *ebpf.Variable `ebpf:"unused_http2"`
}

// BpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfPrograms struct {
}

func (p *BpfPrograms) Close() error {
	return _BpfClose()
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
