// Code generated by smithy-go-codegen DO NOT EDIT.

package servicediscovery

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/servicediscovery/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Discovers registered instances for a specified namespace and service. You can
// use DiscoverInstances to discover instances for any type of namespace.
// DiscoverInstances returns a randomized list of instances allowing customers to
// distribute traffic evenly across instances. For public and private DNS
// namespaces, you can also use DNS queries to discover instances.
func (c *Client) DiscoverInstances(ctx context.Context, params *DiscoverInstancesInput, optFns ...func(*Options)) (*DiscoverInstancesOutput, error) {
	if params == nil {
		params = &DiscoverInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DiscoverInstances", params, optFns, c.addOperationDiscoverInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DiscoverInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DiscoverInstancesInput struct {

	// The HttpName name of the namespace. The HttpName is found in the HttpProperties
	// member of the Properties member of the namespace. In most cases, Name and
	// HttpName match. However, if you reuse Name for namespace creation, a generated
	// hash is added to HttpName to distinguish the two.
	//
	// This member is required.
	NamespaceName *string

	// The name of the service that you specified when you registered the instance.
	//
	// This member is required.
	ServiceName *string

	// The health status of the instances that you want to discover. This parameter is
	// ignored for services that don't have a health check configured, and all
	// instances are returned.
	//
	// HEALTHY Returns healthy instances.
	//
	// UNHEALTHY Returns unhealthy instances.
	//
	// ALL Returns all instances.
	//
	// HEALTHY_OR_ELSE_ALL Returns healthy instances, unless none are reporting a
	// healthy state. In that case, return all instances. This is also called failing
	// open.
	HealthStatus types.HealthStatusFilter

	// The maximum number of instances that you want Cloud Map to return in the
	// response to a DiscoverInstances request. If you don't specify a value for
	// MaxResults , Cloud Map returns up to 100 instances.
	MaxResults *int32

	// Opportunistic filters to scope the results based on custom attributes. If there
	// are instances that match both the filters specified in both the QueryParameters
	// parameter and this parameter, all of these instances are returned. Otherwise,
	// the filters are ignored, and only instances that match the filters that are
	// specified in the QueryParameters parameter are returned.
	OptionalParameters map[string]string

	// The ID of the Amazon Web Services account that owns the namespace associated
	// with the instance, as specified in the namespace ResourceOwner field. For
	// instances associated with namespaces that are shared with your account, you must
	// specify an OwnerAccount .
	OwnerAccount *string

	// Filters to scope the results based on custom attributes for the instance (for
	// example, {version=v1, az=1a} ). Only instances that match all the specified
	// key-value pairs are returned.
	QueryParameters map[string]string

	noSmithyDocumentSerde
}

type DiscoverInstancesOutput struct {

	// A complex type that contains one HttpInstanceSummary for each registered
	// instance.
	Instances []types.HttpInstanceSummary

	// The increasing revision associated to the response Instances list. If a new
	// instance is registered or deregistered, the InstancesRevision updates. The
	// health status updates don't update InstancesRevision .
	InstancesRevision *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDiscoverInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDiscoverInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDiscoverInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DiscoverInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opDiscoverInstancesMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDiscoverInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDiscoverInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opDiscoverInstancesMiddleware struct {
}

func (*endpointPrefix_opDiscoverInstancesMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opDiscoverInstancesMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "data-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opDiscoverInstancesMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opDiscoverInstancesMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opDiscoverInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DiscoverInstances",
	}
}
