// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// TeamSyncAttributesType The type of synchronization operation. "link" connects teams by matching names. "provision" creates new teams when no match is found.
type TeamSyncAttributesType string

// List of TeamSyncAttributesType.
const (
	TEAMSYNCATTRIBUTESTYPE_LINK      TeamSyncAttributesType = "link"
	TEAMSYNCATTRIBUTESTYPE_PROVISION TeamSyncAttributesType = "provision"
)

var allowedTeamSyncAttributesTypeEnumValues = []TeamSyncAttributesType{
	TEAMSYNCATTRIBUTESTYPE_LINK,
	TEAMSYNCATTRIBUTESTYPE_PROVISION,
}

// GetAllowedValues reeturns the list of possible values.
func (v *TeamSyncAttributesType) GetAllowedValues() []TeamSyncAttributesType {
	return allowedTeamSyncAttributesTypeEnumValues
}

// UnmarshalJSON deserializes the given payload.
func (v *TeamSyncAttributesType) UnmarshalJSON(src []byte) error {
	var value string
	err := datadog.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	*v = TeamSyncAttributesType(value)
	return nil
}

// NewTeamSyncAttributesTypeFromValue returns a pointer to a valid TeamSyncAttributesType
// for the value passed as argument, or an error if the value passed is not allowed by the enum.
func NewTeamSyncAttributesTypeFromValue(v string) (*TeamSyncAttributesType, error) {
	ev := TeamSyncAttributesType(v)
	if ev.IsValid() {
		return &ev, nil
	}
	return nil, fmt.Errorf("invalid value '%v' for TeamSyncAttributesType: valid values are %v", v, allowedTeamSyncAttributesTypeEnumValues)
}

// IsValid return true if the value is valid for the enum, false otherwise.
func (v TeamSyncAttributesType) IsValid() bool {
	for _, existing := range allowedTeamSyncAttributesTypeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to TeamSyncAttributesType value.
func (v TeamSyncAttributesType) Ptr() *TeamSyncAttributesType {
	return &v
}
