// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV1

import (
	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// AWSAccount Returns the AWS account associated with this integration.
type AWSAccount struct {
	// Your AWS access key ID. Only required if your AWS account is a GovCloud or China account.
	AccessKeyId *string `json:"access_key_id,omitempty"`
	// Your AWS Account ID without dashes.
	AccountId *string `json:"account_id,omitempty"`
	// An object (in the form `{"namespace1":true/false, "namespace2":true/false}`) containing user-supplied overrides
	// for AWS namespace metric collection. **Important**: This field only contains namespaces explicitly configured through API calls,
	// not the comprehensive enabled or disabled status of all namespaces. If a namespace is absent from this field, it uses Datadog's
	// internal defaults (all namespaces enabled by default, except `AWS/SQS`, `AWS/ElasticMapReduce`, and `AWS/Usage`).
	// For a complete view of all namespace statuses, use the V2 AWS Integration API instead.
	AccountSpecificNamespaceRules map[string]bool `json:"account_specific_namespace_rules,omitempty"`
	// Whether Datadog collects cloud security posture management resources from your AWS account. This includes additional resources not covered under the general `resource_collection`.
	CspmResourceCollectionEnabled *bool `json:"cspm_resource_collection_enabled,omitempty"`
	// An array of [AWS regions](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints)
	// to exclude from metrics collection.
	ExcludedRegions []string `json:"excluded_regions,omitempty"`
	// Whether Datadog collects additional attributes and configuration information about the resources in your AWS account. Required for `cspm_resource_collection`.
	ExtendedResourceCollectionEnabled *bool `json:"extended_resource_collection_enabled,omitempty"`
	// The array of EC2 tags (in the form `key:value`) defines a filter that Datadog uses when collecting metrics from EC2.
	// Wildcards, such as `?` (for single characters) and `*` (for multiple characters) can also be used.
	// Only hosts that match one of the defined tags
	// will be imported into Datadog. The rest will be ignored.
	// Host matching a given tag can also be excluded by adding `!` before the tag.
	// For example, `env:production,instance-type:c1.*,!region:us-east-1`
	FilterTags []string `json:"filter_tags,omitempty"`
	// Array of tags (in the form `key:value`) to add to all hosts
	// and metrics reporting through this integration.
	HostTags []string `json:"host_tags,omitempty"`
	// Whether Datadog collects metrics for this AWS account.
	MetricsCollectionEnabled *bool `json:"metrics_collection_enabled,omitempty"`
	// Deprecated in favor of 'extended_resource_collection_enabled'. Whether Datadog collects a standard set of resources from your AWS account.
	// Deprecated
	ResourceCollectionEnabled *bool `json:"resource_collection_enabled,omitempty"`
	// Your Datadog role delegation name.
	RoleName *string `json:"role_name,omitempty"`
	// Your AWS secret access key. Only required if your AWS account is a GovCloud or China account.
	SecretAccessKey *string `json:"secret_access_key,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewAWSAccount instantiates a new AWSAccount object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewAWSAccount() *AWSAccount {
	this := AWSAccount{}
	var cspmResourceCollectionEnabled bool = false
	this.CspmResourceCollectionEnabled = &cspmResourceCollectionEnabled
	var extendedResourceCollectionEnabled bool = false
	this.ExtendedResourceCollectionEnabled = &extendedResourceCollectionEnabled
	var metricsCollectionEnabled bool = true
	this.MetricsCollectionEnabled = &metricsCollectionEnabled
	var resourceCollectionEnabled bool = false
	this.ResourceCollectionEnabled = &resourceCollectionEnabled
	return &this
}

// NewAWSAccountWithDefaults instantiates a new AWSAccount object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewAWSAccountWithDefaults() *AWSAccount {
	this := AWSAccount{}
	var cspmResourceCollectionEnabled bool = false
	this.CspmResourceCollectionEnabled = &cspmResourceCollectionEnabled
	var extendedResourceCollectionEnabled bool = false
	this.ExtendedResourceCollectionEnabled = &extendedResourceCollectionEnabled
	var metricsCollectionEnabled bool = true
	this.MetricsCollectionEnabled = &metricsCollectionEnabled
	var resourceCollectionEnabled bool = false
	this.ResourceCollectionEnabled = &resourceCollectionEnabled
	return &this
}

// GetAccessKeyId returns the AccessKeyId field value if set, zero value otherwise.
func (o *AWSAccount) GetAccessKeyId() string {
	if o == nil || o.AccessKeyId == nil {
		var ret string
		return ret
	}
	return *o.AccessKeyId
}

// GetAccessKeyIdOk returns a tuple with the AccessKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetAccessKeyIdOk() (*string, bool) {
	if o == nil || o.AccessKeyId == nil {
		return nil, false
	}
	return o.AccessKeyId, true
}

// HasAccessKeyId returns a boolean if a field has been set.
func (o *AWSAccount) HasAccessKeyId() bool {
	return o != nil && o.AccessKeyId != nil
}

// SetAccessKeyId gets a reference to the given string and assigns it to the AccessKeyId field.
func (o *AWSAccount) SetAccessKeyId(v string) {
	o.AccessKeyId = &v
}

// GetAccountId returns the AccountId field value if set, zero value otherwise.
func (o *AWSAccount) GetAccountId() string {
	if o == nil || o.AccountId == nil {
		var ret string
		return ret
	}
	return *o.AccountId
}

// GetAccountIdOk returns a tuple with the AccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetAccountIdOk() (*string, bool) {
	if o == nil || o.AccountId == nil {
		return nil, false
	}
	return o.AccountId, true
}

// HasAccountId returns a boolean if a field has been set.
func (o *AWSAccount) HasAccountId() bool {
	return o != nil && o.AccountId != nil
}

// SetAccountId gets a reference to the given string and assigns it to the AccountId field.
func (o *AWSAccount) SetAccountId(v string) {
	o.AccountId = &v
}

// GetAccountSpecificNamespaceRules returns the AccountSpecificNamespaceRules field value if set, zero value otherwise.
func (o *AWSAccount) GetAccountSpecificNamespaceRules() map[string]bool {
	if o == nil || o.AccountSpecificNamespaceRules == nil {
		var ret map[string]bool
		return ret
	}
	return o.AccountSpecificNamespaceRules
}

// GetAccountSpecificNamespaceRulesOk returns a tuple with the AccountSpecificNamespaceRules field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetAccountSpecificNamespaceRulesOk() (*map[string]bool, bool) {
	if o == nil || o.AccountSpecificNamespaceRules == nil {
		return nil, false
	}
	return &o.AccountSpecificNamespaceRules, true
}

// HasAccountSpecificNamespaceRules returns a boolean if a field has been set.
func (o *AWSAccount) HasAccountSpecificNamespaceRules() bool {
	return o != nil && o.AccountSpecificNamespaceRules != nil
}

// SetAccountSpecificNamespaceRules gets a reference to the given map[string]bool and assigns it to the AccountSpecificNamespaceRules field.
func (o *AWSAccount) SetAccountSpecificNamespaceRules(v map[string]bool) {
	o.AccountSpecificNamespaceRules = v
}

// GetCspmResourceCollectionEnabled returns the CspmResourceCollectionEnabled field value if set, zero value otherwise.
func (o *AWSAccount) GetCspmResourceCollectionEnabled() bool {
	if o == nil || o.CspmResourceCollectionEnabled == nil {
		var ret bool
		return ret
	}
	return *o.CspmResourceCollectionEnabled
}

// GetCspmResourceCollectionEnabledOk returns a tuple with the CspmResourceCollectionEnabled field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetCspmResourceCollectionEnabledOk() (*bool, bool) {
	if o == nil || o.CspmResourceCollectionEnabled == nil {
		return nil, false
	}
	return o.CspmResourceCollectionEnabled, true
}

// HasCspmResourceCollectionEnabled returns a boolean if a field has been set.
func (o *AWSAccount) HasCspmResourceCollectionEnabled() bool {
	return o != nil && o.CspmResourceCollectionEnabled != nil
}

// SetCspmResourceCollectionEnabled gets a reference to the given bool and assigns it to the CspmResourceCollectionEnabled field.
func (o *AWSAccount) SetCspmResourceCollectionEnabled(v bool) {
	o.CspmResourceCollectionEnabled = &v
}

// GetExcludedRegions returns the ExcludedRegions field value if set, zero value otherwise.
func (o *AWSAccount) GetExcludedRegions() []string {
	if o == nil || o.ExcludedRegions == nil {
		var ret []string
		return ret
	}
	return o.ExcludedRegions
}

// GetExcludedRegionsOk returns a tuple with the ExcludedRegions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetExcludedRegionsOk() (*[]string, bool) {
	if o == nil || o.ExcludedRegions == nil {
		return nil, false
	}
	return &o.ExcludedRegions, true
}

// HasExcludedRegions returns a boolean if a field has been set.
func (o *AWSAccount) HasExcludedRegions() bool {
	return o != nil && o.ExcludedRegions != nil
}

// SetExcludedRegions gets a reference to the given []string and assigns it to the ExcludedRegions field.
func (o *AWSAccount) SetExcludedRegions(v []string) {
	o.ExcludedRegions = v
}

// GetExtendedResourceCollectionEnabled returns the ExtendedResourceCollectionEnabled field value if set, zero value otherwise.
func (o *AWSAccount) GetExtendedResourceCollectionEnabled() bool {
	if o == nil || o.ExtendedResourceCollectionEnabled == nil {
		var ret bool
		return ret
	}
	return *o.ExtendedResourceCollectionEnabled
}

// GetExtendedResourceCollectionEnabledOk returns a tuple with the ExtendedResourceCollectionEnabled field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetExtendedResourceCollectionEnabledOk() (*bool, bool) {
	if o == nil || o.ExtendedResourceCollectionEnabled == nil {
		return nil, false
	}
	return o.ExtendedResourceCollectionEnabled, true
}

// HasExtendedResourceCollectionEnabled returns a boolean if a field has been set.
func (o *AWSAccount) HasExtendedResourceCollectionEnabled() bool {
	return o != nil && o.ExtendedResourceCollectionEnabled != nil
}

// SetExtendedResourceCollectionEnabled gets a reference to the given bool and assigns it to the ExtendedResourceCollectionEnabled field.
func (o *AWSAccount) SetExtendedResourceCollectionEnabled(v bool) {
	o.ExtendedResourceCollectionEnabled = &v
}

// GetFilterTags returns the FilterTags field value if set, zero value otherwise.
func (o *AWSAccount) GetFilterTags() []string {
	if o == nil || o.FilterTags == nil {
		var ret []string
		return ret
	}
	return o.FilterTags
}

// GetFilterTagsOk returns a tuple with the FilterTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetFilterTagsOk() (*[]string, bool) {
	if o == nil || o.FilterTags == nil {
		return nil, false
	}
	return &o.FilterTags, true
}

// HasFilterTags returns a boolean if a field has been set.
func (o *AWSAccount) HasFilterTags() bool {
	return o != nil && o.FilterTags != nil
}

// SetFilterTags gets a reference to the given []string and assigns it to the FilterTags field.
func (o *AWSAccount) SetFilterTags(v []string) {
	o.FilterTags = v
}

// GetHostTags returns the HostTags field value if set, zero value otherwise.
func (o *AWSAccount) GetHostTags() []string {
	if o == nil || o.HostTags == nil {
		var ret []string
		return ret
	}
	return o.HostTags
}

// GetHostTagsOk returns a tuple with the HostTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetHostTagsOk() (*[]string, bool) {
	if o == nil || o.HostTags == nil {
		return nil, false
	}
	return &o.HostTags, true
}

// HasHostTags returns a boolean if a field has been set.
func (o *AWSAccount) HasHostTags() bool {
	return o != nil && o.HostTags != nil
}

// SetHostTags gets a reference to the given []string and assigns it to the HostTags field.
func (o *AWSAccount) SetHostTags(v []string) {
	o.HostTags = v
}

// GetMetricsCollectionEnabled returns the MetricsCollectionEnabled field value if set, zero value otherwise.
func (o *AWSAccount) GetMetricsCollectionEnabled() bool {
	if o == nil || o.MetricsCollectionEnabled == nil {
		var ret bool
		return ret
	}
	return *o.MetricsCollectionEnabled
}

// GetMetricsCollectionEnabledOk returns a tuple with the MetricsCollectionEnabled field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetMetricsCollectionEnabledOk() (*bool, bool) {
	if o == nil || o.MetricsCollectionEnabled == nil {
		return nil, false
	}
	return o.MetricsCollectionEnabled, true
}

// HasMetricsCollectionEnabled returns a boolean if a field has been set.
func (o *AWSAccount) HasMetricsCollectionEnabled() bool {
	return o != nil && o.MetricsCollectionEnabled != nil
}

// SetMetricsCollectionEnabled gets a reference to the given bool and assigns it to the MetricsCollectionEnabled field.
func (o *AWSAccount) SetMetricsCollectionEnabled(v bool) {
	o.MetricsCollectionEnabled = &v
}

// GetResourceCollectionEnabled returns the ResourceCollectionEnabled field value if set, zero value otherwise.
// Deprecated
func (o *AWSAccount) GetResourceCollectionEnabled() bool {
	if o == nil || o.ResourceCollectionEnabled == nil {
		var ret bool
		return ret
	}
	return *o.ResourceCollectionEnabled
}

// GetResourceCollectionEnabledOk returns a tuple with the ResourceCollectionEnabled field value if set, nil otherwise
// and a boolean to check if the value has been set.
// Deprecated
func (o *AWSAccount) GetResourceCollectionEnabledOk() (*bool, bool) {
	if o == nil || o.ResourceCollectionEnabled == nil {
		return nil, false
	}
	return o.ResourceCollectionEnabled, true
}

// HasResourceCollectionEnabled returns a boolean if a field has been set.
func (o *AWSAccount) HasResourceCollectionEnabled() bool {
	return o != nil && o.ResourceCollectionEnabled != nil
}

// SetResourceCollectionEnabled gets a reference to the given bool and assigns it to the ResourceCollectionEnabled field.
// Deprecated
func (o *AWSAccount) SetResourceCollectionEnabled(v bool) {
	o.ResourceCollectionEnabled = &v
}

// GetRoleName returns the RoleName field value if set, zero value otherwise.
func (o *AWSAccount) GetRoleName() string {
	if o == nil || o.RoleName == nil {
		var ret string
		return ret
	}
	return *o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetRoleNameOk() (*string, bool) {
	if o == nil || o.RoleName == nil {
		return nil, false
	}
	return o.RoleName, true
}

// HasRoleName returns a boolean if a field has been set.
func (o *AWSAccount) HasRoleName() bool {
	return o != nil && o.RoleName != nil
}

// SetRoleName gets a reference to the given string and assigns it to the RoleName field.
func (o *AWSAccount) SetRoleName(v string) {
	o.RoleName = &v
}

// GetSecretAccessKey returns the SecretAccessKey field value if set, zero value otherwise.
func (o *AWSAccount) GetSecretAccessKey() string {
	if o == nil || o.SecretAccessKey == nil {
		var ret string
		return ret
	}
	return *o.SecretAccessKey
}

// GetSecretAccessKeyOk returns a tuple with the SecretAccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSAccount) GetSecretAccessKeyOk() (*string, bool) {
	if o == nil || o.SecretAccessKey == nil {
		return nil, false
	}
	return o.SecretAccessKey, true
}

// HasSecretAccessKey returns a boolean if a field has been set.
func (o *AWSAccount) HasSecretAccessKey() bool {
	return o != nil && o.SecretAccessKey != nil
}

// SetSecretAccessKey gets a reference to the given string and assigns it to the SecretAccessKey field.
func (o *AWSAccount) SetSecretAccessKey(v string) {
	o.SecretAccessKey = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o AWSAccount) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.AccessKeyId != nil {
		toSerialize["access_key_id"] = o.AccessKeyId
	}
	if o.AccountId != nil {
		toSerialize["account_id"] = o.AccountId
	}
	if o.AccountSpecificNamespaceRules != nil {
		toSerialize["account_specific_namespace_rules"] = o.AccountSpecificNamespaceRules
	}
	if o.CspmResourceCollectionEnabled != nil {
		toSerialize["cspm_resource_collection_enabled"] = o.CspmResourceCollectionEnabled
	}
	if o.ExcludedRegions != nil {
		toSerialize["excluded_regions"] = o.ExcludedRegions
	}
	if o.ExtendedResourceCollectionEnabled != nil {
		toSerialize["extended_resource_collection_enabled"] = o.ExtendedResourceCollectionEnabled
	}
	if o.FilterTags != nil {
		toSerialize["filter_tags"] = o.FilterTags
	}
	if o.HostTags != nil {
		toSerialize["host_tags"] = o.HostTags
	}
	if o.MetricsCollectionEnabled != nil {
		toSerialize["metrics_collection_enabled"] = o.MetricsCollectionEnabled
	}
	if o.ResourceCollectionEnabled != nil {
		toSerialize["resource_collection_enabled"] = o.ResourceCollectionEnabled
	}
	if o.RoleName != nil {
		toSerialize["role_name"] = o.RoleName
	}
	if o.SecretAccessKey != nil {
		toSerialize["secret_access_key"] = o.SecretAccessKey
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *AWSAccount) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		AccessKeyId                       *string         `json:"access_key_id,omitempty"`
		AccountId                         *string         `json:"account_id,omitempty"`
		AccountSpecificNamespaceRules     map[string]bool `json:"account_specific_namespace_rules,omitempty"`
		CspmResourceCollectionEnabled     *bool           `json:"cspm_resource_collection_enabled,omitempty"`
		ExcludedRegions                   []string        `json:"excluded_regions,omitempty"`
		ExtendedResourceCollectionEnabled *bool           `json:"extended_resource_collection_enabled,omitempty"`
		FilterTags                        []string        `json:"filter_tags,omitempty"`
		HostTags                          []string        `json:"host_tags,omitempty"`
		MetricsCollectionEnabled          *bool           `json:"metrics_collection_enabled,omitempty"`
		ResourceCollectionEnabled         *bool           `json:"resource_collection_enabled,omitempty"`
		RoleName                          *string         `json:"role_name,omitempty"`
		SecretAccessKey                   *string         `json:"secret_access_key,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"access_key_id", "account_id", "account_specific_namespace_rules", "cspm_resource_collection_enabled", "excluded_regions", "extended_resource_collection_enabled", "filter_tags", "host_tags", "metrics_collection_enabled", "resource_collection_enabled", "role_name", "secret_access_key"})
	} else {
		return err
	}
	o.AccessKeyId = all.AccessKeyId
	o.AccountId = all.AccountId
	o.AccountSpecificNamespaceRules = all.AccountSpecificNamespaceRules
	o.CspmResourceCollectionEnabled = all.CspmResourceCollectionEnabled
	o.ExcludedRegions = all.ExcludedRegions
	o.ExtendedResourceCollectionEnabled = all.ExtendedResourceCollectionEnabled
	o.FilterTags = all.FilterTags
	o.HostTags = all.HostTags
	o.MetricsCollectionEnabled = all.MetricsCollectionEnabled
	o.ResourceCollectionEnabled = all.ResourceCollectionEnabled
	o.RoleName = all.RoleName
	o.SecretAccessKey = all.SecretAccessKey

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	return nil
}
