// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/process/events.proto

package process

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ProcEventType is a type of process lifecycle event collected by the process-agent
type ProcEventType int32

const (
	ProcEventType_exec ProcEventType = 0
	ProcEventType_exit ProcEventType = 1
)

var ProcEventType_name = map[int32]string{
	0: "exec",
	1: "exit",
}

var ProcEventType_value = map[string]int32{
	"exec": 0,
	"exit": 1,
}

func (x ProcEventType) String() string {
	return proto.EnumName(ProcEventType_name, int32(x))
}

func (ProcEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_640c5601f215fdd9, []int{0}
}

// CollectorProcEvent is a payload used to send a batch of process lifecycle events
type CollectorProcEvent struct {
	Hostname  string          `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Host      *Host           `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	Info      *SystemInfo     `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	Events    []*ProcessEvent `protobuf:"bytes,4,rep,name=events,proto3" json:"events,omitempty"`
	GroupId   int32           `protobuf:"varint,5,opt,name=groupId,proto3" json:"groupId,omitempty"`
	GroupSize int32           `protobuf:"varint,6,opt,name=groupSize,proto3" json:"groupSize,omitempty"`
}

func (m *CollectorProcEvent) Reset()         { *m = CollectorProcEvent{} }
func (m *CollectorProcEvent) String() string { return proto.CompactTextString(m) }
func (*CollectorProcEvent) ProtoMessage()    {}
func (*CollectorProcEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_640c5601f215fdd9, []int{0}
}
func (m *CollectorProcEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectorProcEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CollectorProcEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CollectorProcEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectorProcEvent.Merge(m, src)
}
func (m *CollectorProcEvent) XXX_Size() int {
	return m.Size()
}
func (m *CollectorProcEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectorProcEvent.DiscardUnknown(m)
}

var xxx_messageInfo_CollectorProcEvent proto.InternalMessageInfo

func (m *CollectorProcEvent) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *CollectorProcEvent) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *CollectorProcEvent) GetInfo() *SystemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *CollectorProcEvent) GetEvents() []*ProcessEvent {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *CollectorProcEvent) GetGroupId() int32 {
	if m != nil {
		return m.GroupId
	}
	return 0
}

func (m *CollectorProcEvent) GetGroupSize() int32 {
	if m != nil {
		return m.GroupSize
	}
	return 0
}

// ProcessEvent holds information about a process lifeycle event
type ProcessEvent struct {
	Type           ProcEventType `protobuf:"varint,1,opt,name=type,proto3,enum=datadog.process_agent.ProcEventType" json:"type,omitempty"`
	CollectionTime int64         `protobuf:"varint,2,opt,name=collectionTime,proto3" json:"collectionTime,omitempty"`
	Pid            uint32        `protobuf:"varint,3,opt,name=pid,proto3" json:"pid,omitempty"`
	Command        *Command      `protobuf:"bytes,4,opt,name=command,proto3" json:"command,omitempty"`
	User           *ProcessUser  `protobuf:"bytes,5,opt,name=user,proto3" json:"user,omitempty"`
	Host           *Host         `protobuf:"bytes,6,opt,name=host,proto3" json:"host,omitempty"`
	ContainerId    string        `protobuf:"bytes,7,opt,name=containerId,proto3" json:"containerId,omitempty"`
	// Types that are valid to be assigned to TypedEvent:
	//	*ProcessEvent_Exec
	//	*ProcessEvent_Exit
	TypedEvent isProcessEvent_TypedEvent `protobuf_oneof:"typedEvent"`
}

func (m *ProcessEvent) Reset()         { *m = ProcessEvent{} }
func (m *ProcessEvent) String() string { return proto.CompactTextString(m) }
func (*ProcessEvent) ProtoMessage()    {}
func (*ProcessEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_640c5601f215fdd9, []int{1}
}
func (m *ProcessEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessEvent.Merge(m, src)
}
func (m *ProcessEvent) XXX_Size() int {
	return m.Size()
}
func (m *ProcessEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessEvent.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessEvent proto.InternalMessageInfo

type isProcessEvent_TypedEvent interface {
	isProcessEvent_TypedEvent()
	MarshalTo([]byte) (int, error)
	Size() int
}

type ProcessEvent_Exec struct {
	Exec *ProcessExec `protobuf:"bytes,8,opt,name=exec,proto3,oneof" json:"exec,omitempty"`
}
type ProcessEvent_Exit struct {
	Exit *ProcessExit `protobuf:"bytes,9,opt,name=exit,proto3,oneof" json:"exit,omitempty"`
}

func (*ProcessEvent_Exec) isProcessEvent_TypedEvent() {}
func (*ProcessEvent_Exit) isProcessEvent_TypedEvent() {}

func (m *ProcessEvent) GetTypedEvent() isProcessEvent_TypedEvent {
	if m != nil {
		return m.TypedEvent
	}
	return nil
}

func (m *ProcessEvent) GetType() ProcEventType {
	if m != nil {
		return m.Type
	}
	return ProcEventType_exec
}

func (m *ProcessEvent) GetCollectionTime() int64 {
	if m != nil {
		return m.CollectionTime
	}
	return 0
}

func (m *ProcessEvent) GetPid() uint32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *ProcessEvent) GetCommand() *Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *ProcessEvent) GetUser() *ProcessUser {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *ProcessEvent) GetHost() *Host {
	if m != nil {
		return m.Host
	}
	return nil
}

func (m *ProcessEvent) GetContainerId() string {
	if m != nil {
		return m.ContainerId
	}
	return ""
}

func (m *ProcessEvent) GetExec() *ProcessExec {
	if x, ok := m.GetTypedEvent().(*ProcessEvent_Exec); ok {
		return x.Exec
	}
	return nil
}

func (m *ProcessEvent) GetExit() *ProcessExit {
	if x, ok := m.GetTypedEvent().(*ProcessEvent_Exit); ok {
		return x.Exit
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ProcessEvent) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ProcessEvent_Exec)(nil),
		(*ProcessEvent_Exit)(nil),
	}
}

// ProcessExec holds information specific to exec events
type ProcessExec struct {
	ForkTime int64 `protobuf:"varint,1,opt,name=forkTime,proto3" json:"forkTime,omitempty"`
	ExecTime int64 `protobuf:"varint,2,opt,name=execTime,proto3" json:"execTime,omitempty"`
}

func (m *ProcessExec) Reset()         { *m = ProcessExec{} }
func (m *ProcessExec) String() string { return proto.CompactTextString(m) }
func (*ProcessExec) ProtoMessage()    {}
func (*ProcessExec) Descriptor() ([]byte, []int) {
	return fileDescriptor_640c5601f215fdd9, []int{2}
}
func (m *ProcessExec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessExec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessExec.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessExec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessExec.Merge(m, src)
}
func (m *ProcessExec) XXX_Size() int {
	return m.Size()
}
func (m *ProcessExec) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessExec.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessExec proto.InternalMessageInfo

func (m *ProcessExec) GetForkTime() int64 {
	if m != nil {
		return m.ForkTime
	}
	return 0
}

func (m *ProcessExec) GetExecTime() int64 {
	if m != nil {
		return m.ExecTime
	}
	return 0
}

// ProcessExit holds information specific to exit events
type ProcessExit struct {
	ExecTime int64 `protobuf:"varint,1,opt,name=execTime,proto3" json:"execTime,omitempty"`
	ExitTime int64 `protobuf:"varint,2,opt,name=exitTime,proto3" json:"exitTime,omitempty"`
	ExitCode int32 `protobuf:"varint,3,opt,name=exitCode,proto3" json:"exitCode,omitempty"`
}

func (m *ProcessExit) Reset()         { *m = ProcessExit{} }
func (m *ProcessExit) String() string { return proto.CompactTextString(m) }
func (*ProcessExit) ProtoMessage()    {}
func (*ProcessExit) Descriptor() ([]byte, []int) {
	return fileDescriptor_640c5601f215fdd9, []int{3}
}
func (m *ProcessExit) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessExit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessExit.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessExit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessExit.Merge(m, src)
}
func (m *ProcessExit) XXX_Size() int {
	return m.Size()
}
func (m *ProcessExit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessExit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessExit proto.InternalMessageInfo

func (m *ProcessExit) GetExecTime() int64 {
	if m != nil {
		return m.ExecTime
	}
	return 0
}

func (m *ProcessExit) GetExitTime() int64 {
	if m != nil {
		return m.ExitTime
	}
	return 0
}

func (m *ProcessExit) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func init() {
	proto.RegisterEnum("datadog.process_agent.ProcEventType", ProcEventType_name, ProcEventType_value)
	proto.RegisterType((*CollectorProcEvent)(nil), "datadog.process_agent.CollectorProcEvent")
	proto.RegisterType((*ProcessEvent)(nil), "datadog.process_agent.ProcessEvent")
	proto.RegisterType((*ProcessExec)(nil), "datadog.process_agent.ProcessExec")
	proto.RegisterType((*ProcessExit)(nil), "datadog.process_agent.ProcessExit")
}

func init() { proto.RegisterFile("proto/process/events.proto", fileDescriptor_640c5601f215fdd9) }

var fileDescriptor_640c5601f215fdd9 = []byte{
	// 523 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x5d, 0x6b, 0xdb, 0x30,
	0x14, 0x8d, 0x1a, 0xe7, 0x4b, 0x69, 0x4b, 0x10, 0x0c, 0xb4, 0x6c, 0x98, 0x2c, 0x1d, 0x23, 0x6c,
	0x2c, 0x81, 0x8c, 0x8e, 0xc2, 0xde, 0x9a, 0x06, 0x9a, 0xb7, 0xa2, 0x76, 0x2f, 0x7b, 0x19, 0xaa,
	0xad, 0xa4, 0x62, 0xb1, 0xaf, 0xb1, 0x95, 0xd2, 0xec, 0x3f, 0x0c, 0xf6, 0xb3, 0xb6, 0xb7, 0x3e,
	0xee, 0x71, 0x24, 0x7f, 0x64, 0xf8, 0xaa, 0xf1, 0xec, 0xb1, 0x94, 0xbc, 0xe9, 0xdc, 0x7b, 0xce,
	0x95, 0x74, 0x8e, 0x44, 0xdb, 0x51, 0x0c, 0x06, 0x06, 0x51, 0x0c, 0x9e, 0x4a, 0x92, 0x81, 0xba,
	0x55, 0xa1, 0x49, 0xfa, 0x58, 0x64, 0x4f, 0x7c, 0x69, 0xa4, 0x0f, 0xb3, 0xfe, 0x43, 0xf7, 0xb3,
	0x9c, 0xa9, 0xd0, 0xb4, 0x9f, 0x16, 0x25, 0x58, 0xb4, 0x8a, 0xee, 0xb7, 0x3d, 0xca, 0x46, 0x30,
	0x9f, 0x2b, 0xcf, 0x40, 0x7c, 0x11, 0x83, 0x37, 0x4e, 0xe7, 0xb1, 0x36, 0xad, 0xdf, 0x40, 0x62,
	0x42, 0x19, 0x28, 0x4e, 0x3a, 0xa4, 0xd7, 0x10, 0x19, 0x66, 0x03, 0xea, 0xa4, 0x6b, 0xbe, 0xd7,
	0x21, 0xbd, 0xe6, 0xf0, 0x59, 0xff, 0xbf, 0x7b, 0xf6, 0xcf, 0x21, 0x31, 0x02, 0x89, 0xec, 0x98,
	0x3a, 0x3a, 0x9c, 0x02, 0x2f, 0xa3, 0xe0, 0xc5, 0x16, 0xc1, 0xe5, 0x32, 0x31, 0x2a, 0x98, 0x84,
	0x53, 0x10, 0x48, 0x67, 0x1f, 0x68, 0xd5, 0x5e, 0x8e, 0x3b, 0x9d, 0x72, 0xaf, 0x39, 0x3c, 0xda,
	0x22, 0xbc, 0xb0, 0x08, 0x0f, 0x2e, 0x1e, 0x24, 0x8c, 0xd3, 0xda, 0x2c, 0x86, 0x45, 0x34, 0xf1,
	0x79, 0xa5, 0x43, 0x7a, 0x15, 0xb1, 0x81, 0xec, 0x39, 0x6d, 0xe0, 0xf2, 0x52, 0x7f, 0x55, 0xbc,
	0x8a, 0xbd, 0xbf, 0x85, 0xee, 0xcf, 0x32, 0xdd, 0xcf, 0x0f, 0x64, 0x27, 0xd4, 0x31, 0xcb, 0xc8,
	0xba, 0x70, 0x38, 0x7c, 0xf9, 0xc8, 0x19, 0x90, 0x7f, 0xb5, 0x8c, 0x94, 0x40, 0x05, 0x7b, 0x45,
	0x0f, 0x3d, 0xeb, 0xac, 0x86, 0xf0, 0x4a, 0x07, 0x0a, 0x1d, 0x2b, 0x8b, 0x7f, 0xaa, 0xac, 0x45,
	0xcb, 0x91, 0xf6, 0xd1, 0x9d, 0x03, 0x91, 0x2e, 0xd9, 0x09, 0xad, 0x79, 0x10, 0x04, 0x32, 0xf4,
	0xb9, 0x83, 0x9e, 0xb9, 0x5b, 0xb6, 0x1d, 0x59, 0x96, 0xd8, 0xd0, 0xd9, 0x7b, 0xea, 0x2c, 0x12,
	0x15, 0xe3, 0x9d, 0x9b, 0xc3, 0xee, 0xe3, 0x8e, 0x7d, 0x4c, 0x54, 0x2c, 0x90, 0x9f, 0x65, 0x5a,
	0xdd, 0x35, 0xd3, 0x0e, 0x6d, 0x7a, 0x10, 0x1a, 0xa9, 0x43, 0x15, 0x4f, 0x7c, 0x5e, 0xc3, 0x37,
	0x92, 0x2f, 0xa5, 0xc6, 0xa9, 0x3b, 0xe5, 0xf1, 0xfa, 0x2e, 0x47, 0x19, 0xdf, 0x29, 0xef, 0xbc,
	0x24, 0x50, 0x61, 0x95, 0xda, 0xf0, 0xc6, 0x6e, 0x4a, 0x6d, 0xac, 0x52, 0x9b, 0xd3, 0x7d, 0x4a,
	0x53, 0xeb, 0x7d, 0x8c, 0xa2, 0x3b, 0xa6, 0xcd, 0xdc, 0xf8, 0xf4, 0x4d, 0x4f, 0x21, 0xfe, 0x82,
	0x49, 0x10, 0x4c, 0x22, 0xc3, 0x69, 0x2f, 0xdd, 0x3a, 0x97, 0x52, 0x86, 0xbb, 0x32, 0x37, 0x46,
	0x9b, 0x02, 0x95, 0x14, 0xa9, 0xb6, 0xa7, 0x4d, 0x71, 0x8c, 0xc5, 0x9b, 0xde, 0x08, 0x7c, 0x85,
	0x59, 0x57, 0x44, 0x86, 0x5f, 0x1f, 0xd1, 0x83, 0xc2, 0x0b, 0x62, 0x75, 0x6b, 0x5e, 0xab, 0x64,
	0x57, 0xda, 0xb4, 0xc8, 0xe9, 0xf8, 0xc7, 0xca, 0x25, 0xf7, 0x2b, 0x97, 0xfc, 0x5e, 0xb9, 0xe4,
	0xfb, 0xda, 0x2d, 0xdd, 0xaf, 0xdd, 0xd2, 0xaf, 0xb5, 0x5b, 0xfa, 0xf4, 0x66, 0xa6, 0xcd, 0xcd,
	0xe2, 0xba, 0xef, 0x41, 0x30, 0x38, 0x93, 0x46, 0x9e, 0xc1, 0xcc, 0x7e, 0xf2, 0xb7, 0x91, 0x5c,
	0xce, 0x41, 0xfa, 0x83, 0xdb, 0xe3, 0xcd, 0xef, 0xbf, 0xae, 0xe2, 0xc7, 0x7f, 0xf7, 0x27, 0x00,
	0x00, 0xff, 0xff, 0x7b, 0x46, 0x58, 0xbc, 0x48, 0x04, 0x00, 0x00,
}

func (m *CollectorProcEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectorProcEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CollectorProcEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.GroupSize != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.GroupSize))
		i--
		dAtA[i] = 0x30
	}
	if m.GroupId != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.GroupId))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEvents(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintEvents(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProcessEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.TypedEvent != nil {
		{
			size := m.TypedEvent.Size()
			i -= size
			if _, err := m.TypedEvent.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.ContainerId) > 0 {
		i -= len(m.ContainerId)
		copy(dAtA[i:], m.ContainerId)
		i = encodeVarintEvents(dAtA, i, uint64(len(m.ContainerId)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Host != nil {
		{
			size, err := m.Host.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.User != nil {
		{
			size, err := m.User.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Command != nil {
		{
			size, err := m.Command.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Pid != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.Pid))
		i--
		dAtA[i] = 0x18
	}
	if m.CollectionTime != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.CollectionTime))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcessEvent_Exec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessEvent_Exec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Exec != nil {
		{
			size, err := m.Exec.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *ProcessEvent_Exit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessEvent_Exit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Exit != nil {
		{
			size, err := m.Exit.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEvents(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *ProcessExec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessExec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessExec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExecTime != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.ExecTime))
		i--
		dAtA[i] = 0x10
	}
	if m.ForkTime != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.ForkTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcessExit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessExit) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessExit) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ExitCode != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.ExitCode))
		i--
		dAtA[i] = 0x18
	}
	if m.ExitTime != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.ExitTime))
		i--
		dAtA[i] = 0x10
	}
	if m.ExecTime != 0 {
		i = encodeVarintEvents(dAtA, i, uint64(m.ExecTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintEvents(dAtA []byte, offset int, v uint64) int {
	offset -= sovEvents(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CollectorProcEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovEvents(uint64(l))
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovEvents(uint64(l))
		}
	}
	if m.GroupId != 0 {
		n += 1 + sovEvents(uint64(m.GroupId))
	}
	if m.GroupSize != 0 {
		n += 1 + sovEvents(uint64(m.GroupSize))
	}
	return n
}

func (m *ProcessEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovEvents(uint64(m.Type))
	}
	if m.CollectionTime != 0 {
		n += 1 + sovEvents(uint64(m.CollectionTime))
	}
	if m.Pid != 0 {
		n += 1 + sovEvents(uint64(m.Pid))
	}
	if m.Command != nil {
		l = m.Command.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	if m.User != nil {
		l = m.User.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	if m.Host != nil {
		l = m.Host.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	l = len(m.ContainerId)
	if l > 0 {
		n += 1 + l + sovEvents(uint64(l))
	}
	if m.TypedEvent != nil {
		n += m.TypedEvent.Size()
	}
	return n
}

func (m *ProcessEvent_Exec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Exec != nil {
		l = m.Exec.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	return n
}
func (m *ProcessEvent_Exit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Exit != nil {
		l = m.Exit.Size()
		n += 1 + l + sovEvents(uint64(l))
	}
	return n
}
func (m *ProcessExec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ForkTime != 0 {
		n += 1 + sovEvents(uint64(m.ForkTime))
	}
	if m.ExecTime != 0 {
		n += 1 + sovEvents(uint64(m.ExecTime))
	}
	return n
}

func (m *ProcessExit) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExecTime != 0 {
		n += 1 + sovEvents(uint64(m.ExecTime))
	}
	if m.ExitTime != 0 {
		n += 1 + sovEvents(uint64(m.ExitTime))
	}
	if m.ExitCode != 0 {
		n += 1 + sovEvents(uint64(m.ExitCode))
	}
	return n
}

func sovEvents(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEvents(x uint64) (n int) {
	return sovEvents(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CollectorProcEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectorProcEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectorProcEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Host == nil {
				m.Host = &Host{}
			}
			if err := m.Host.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &SystemInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &ProcessEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			m.GroupId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupId |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupSize", wireType)
			}
			m.GroupSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GroupSize |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ProcEventType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectionTime", wireType)
			}
			m.CollectionTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CollectionTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pid", wireType)
			}
			m.Pid = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Pid |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Command == nil {
				m.Command = &Command{}
			}
			if err := m.Command.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.User == nil {
				m.User = &ProcessUser{}
			}
			if err := m.User.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Host == nil {
				m.Host = &Host{}
			}
			if err := m.Host.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContainerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProcessExec{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypedEvent = &ProcessEvent_Exec{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEvents
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEvents
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ProcessExit{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TypedEvent = &ProcessEvent_Exit{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessExec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessExec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessExec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForkTime", wireType)
			}
			m.ForkTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForkTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecTime", wireType)
			}
			m.ExecTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExecTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessExit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEvents
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessExit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessExit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecTime", wireType)
			}
			m.ExecTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExecTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitTime", wireType)
			}
			m.ExitTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExitTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExitCode", wireType)
			}
			m.ExitCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExitCode |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEvents(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEvents
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEvents(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEvents
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEvents
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEvents
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEvents
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEvents
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEvents        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEvents          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEvents = fmt.Errorf("proto: unexpected end of group")
)
