// Code generated by astool. DO NOT EDIT.

package propertyanyof

import (
	vocab "code.superseriousbusiness.org/activity/streams/vocab"
	"fmt"
	"net/url"
)

// ActivityStreamsAnyOfPropertyIterator is an iterator for a property. It is
// permitted to be one of multiple value types. At most, one type of value can
// be present, or none at all. Setting a value will clear the other types of
// values so that only one of the 'Is' methods will return true. It is
// possible to clear all values, so that this property is empty.
type ActivityStreamsAnyOfPropertyIterator struct {
	activitystreamsObjectMember                vocab.ActivityStreamsObject
	activitystreamsLinkMember                  vocab.ActivityStreamsLink
	activitystreamsAcceptMember                vocab.ActivityStreamsAccept
	activitystreamsActivityMember              vocab.ActivityStreamsActivity
	activitystreamsAddMember                   vocab.ActivityStreamsAdd
	funkwhaleAlbumMember                       vocab.FunkwhaleAlbum
	activitystreamsAnnounceMember              vocab.ActivityStreamsAnnounce
	gotosocialAnnounceApprovalMember           vocab.GoToSocialAnnounceApproval
	gotosocialAnnounceAuthorizationMember      vocab.GoToSocialAnnounceAuthorization
	gotosocialAnnounceRequestMember            vocab.GoToSocialAnnounceRequest
	activitystreamsApplicationMember           vocab.ActivityStreamsApplication
	activitystreamsArriveMember                vocab.ActivityStreamsArrive
	activitystreamsArticleMember               vocab.ActivityStreamsArticle
	funkwhaleArtistMember                      vocab.FunkwhaleArtist
	activitystreamsAudioMember                 vocab.ActivityStreamsAudio
	activitystreamsBlockMember                 vocab.ActivityStreamsBlock
	activitystreamsCollectionMember            vocab.ActivityStreamsCollection
	activitystreamsCollectionPageMember        vocab.ActivityStreamsCollectionPage
	activitystreamsCreateMember                vocab.ActivityStreamsCreate
	activitystreamsDeleteMember                vocab.ActivityStreamsDelete
	activitystreamsDislikeMember               vocab.ActivityStreamsDislike
	activitystreamsDocumentMember              vocab.ActivityStreamsDocument
	tootEmojiMember                            vocab.TootEmoji
	litepubEmojiReactMember                    vocab.LitePubEmojiReact
	activitystreamsEventMember                 vocab.ActivityStreamsEvent
	activitystreamsFlagMember                  vocab.ActivityStreamsFlag
	activitystreamsFollowMember                vocab.ActivityStreamsFollow
	activitystreamsGroupMember                 vocab.ActivityStreamsGroup
	tootHashtagMember                          vocab.TootHashtag
	tootIdentityProofMember                    vocab.TootIdentityProof
	activitystreamsIgnoreMember                vocab.ActivityStreamsIgnore
	activitystreamsImageMember                 vocab.ActivityStreamsImage
	activitystreamsIntransitiveActivityMember  vocab.ActivityStreamsIntransitiveActivity
	activitystreamsInviteMember                vocab.ActivityStreamsInvite
	activitystreamsJoinMember                  vocab.ActivityStreamsJoin
	activitystreamsLeaveMember                 vocab.ActivityStreamsLeave
	funkwhaleLibraryMember                     vocab.FunkwhaleLibrary
	activitystreamsLikeMember                  vocab.ActivityStreamsLike
	gotosocialLikeApprovalMember               vocab.GoToSocialLikeApproval
	gotosocialLikeAuthorizationMember          vocab.GoToSocialLikeAuthorization
	gotosocialLikeRequestMember                vocab.GoToSocialLikeRequest
	activitystreamsListenMember                vocab.ActivityStreamsListen
	activitystreamsMentionMember               vocab.ActivityStreamsMention
	activitystreamsMoveMember                  vocab.ActivityStreamsMove
	activitystreamsNoteMember                  vocab.ActivityStreamsNote
	activitystreamsOfferMember                 vocab.ActivityStreamsOffer
	activitystreamsOrderedCollectionMember     vocab.ActivityStreamsOrderedCollection
	activitystreamsOrderedCollectionPageMember vocab.ActivityStreamsOrderedCollectionPage
	activitystreamsOrganizationMember          vocab.ActivityStreamsOrganization
	activitystreamsPageMember                  vocab.ActivityStreamsPage
	activitystreamsPersonMember                vocab.ActivityStreamsPerson
	activitystreamsPlaceMember                 vocab.ActivityStreamsPlace
	activitystreamsProfileMember               vocab.ActivityStreamsProfile
	schemaPropertyValueMember                  vocab.SchemaPropertyValue
	activitystreamsQuestionMember              vocab.ActivityStreamsQuestion
	activitystreamsReadMember                  vocab.ActivityStreamsRead
	activitystreamsRejectMember                vocab.ActivityStreamsReject
	activitystreamsRelationshipMember          vocab.ActivityStreamsRelationship
	activitystreamsRemoveMember                vocab.ActivityStreamsRemove
	gotosocialReplyApprovalMember              vocab.GoToSocialReplyApproval
	gotosocialReplyAuthorizationMember         vocab.GoToSocialReplyAuthorization
	gotosocialReplyRequestMember               vocab.GoToSocialReplyRequest
	activitystreamsServiceMember               vocab.ActivityStreamsService
	activitystreamsTentativeAcceptMember       vocab.ActivityStreamsTentativeAccept
	activitystreamsTentativeRejectMember       vocab.ActivityStreamsTentativeReject
	activitystreamsTombstoneMember             vocab.ActivityStreamsTombstone
	funkwhaleTrackMember                       vocab.FunkwhaleTrack
	activitystreamsTravelMember                vocab.ActivityStreamsTravel
	activitystreamsUndoMember                  vocab.ActivityStreamsUndo
	activitystreamsUpdateMember                vocab.ActivityStreamsUpdate
	activitystreamsVideoMember                 vocab.ActivityStreamsVideo
	activitystreamsViewMember                  vocab.ActivityStreamsView
	unknown                                    interface{}
	iri                                        *url.URL
	alias                                      string
	myIdx                                      int
	parent                                     vocab.ActivityStreamsAnyOfProperty
}

// NewActivityStreamsAnyOfPropertyIterator creates a new ActivityStreamsAnyOf
// property.
func NewActivityStreamsAnyOfPropertyIterator() *ActivityStreamsAnyOfPropertyIterator {
	return &ActivityStreamsAnyOfPropertyIterator{alias: ""}
}

// deserializeActivityStreamsAnyOfPropertyIterator creates an iterator from an
// element that has been unmarshalled from a text or binary format.
func deserializeActivityStreamsAnyOfPropertyIterator(i interface{}, aliasMap map[string]string) (*ActivityStreamsAnyOfPropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if m, ok := i.(map[string]interface{}); ok {
		if v, err := mgr.DeserializeObjectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsObjectMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLinkActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsLinkMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAcceptActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsAcceptMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeActivityActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsActivityMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAddActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsAddMember: v,
				alias:                    alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAlbumFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                alias,
				funkwhaleAlbumMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsAnnounceMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                            alias,
				gotosocialAnnounceApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                                 alias,
				gotosocialAnnounceAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                           alias,
				gotosocialAnnounceRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeApplicationActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsApplicationMember: v,
				alias:                            alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArriveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsArriveMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArticleActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsArticleMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArtistFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                 alias,
				funkwhaleArtistMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAudioActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsAudioMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeBlockActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsBlockMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCollectionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsCollectionMember: v,
				alias:                           alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCollectionPageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsCollectionPageMember: v,
				alias:                               alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCreateActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsCreateMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDeleteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsDeleteMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDislikeActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsDislikeMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDocumentActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsDocumentMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEmojiToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:           alias,
				tootEmojiMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEmojiReactLitePub()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                   alias,
				litepubEmojiReactMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEventActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsEventMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeFlagActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsFlagMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeFollowActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsFollowMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeGroupActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsGroupMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeHashtagToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:             alias,
				tootHashtagMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIdentityProofToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                   alias,
				tootIdentityProofMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIgnoreActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsIgnoreMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeImageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsImageMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIntransitiveActivityActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsIntransitiveActivityMember: v,
				alias: alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeInviteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsInviteMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeJoinActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsJoinMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLeaveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsLeaveMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLibraryFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                  alias,
				funkwhaleLibraryMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsLikeMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                        alias,
				gotosocialLikeApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                             alias,
				gotosocialLikeAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                       alias,
				gotosocialLikeRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeListenActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsListenMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeMentionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsMentionMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeMoveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsMoveMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeNoteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsNoteMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOfferActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsOfferMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrderedCollectionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsOrderedCollectionMember: v,
				alias:                                  alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrderedCollectionPageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsOrderedCollectionPageMember: v,
				alias: alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrganizationActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsOrganizationMember: v,
				alias:                             alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsPageMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePersonActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsPersonMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePlaceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsPlaceMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeProfileActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsProfileMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePropertyValueSchema()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                     alias,
				schemaPropertyValueMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeQuestionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsQuestionMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReadActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsReadMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRejectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsRejectMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRelationshipActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsRelationshipMember: v,
				alias:                             alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRemoveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsRemoveMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                         alias,
				gotosocialReplyApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                              alias,
				gotosocialReplyAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                        alias,
				gotosocialReplyRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeServiceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsServiceMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTentativeAcceptActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsTentativeAcceptMember: v,
				alias:                                alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTentativeRejectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsTentativeRejectMember: v,
				alias:                                alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTombstoneActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsTombstoneMember: v,
				alias:                          alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTrackFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				alias:                alias,
				funkwhaleTrackMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTravelActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsTravelMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeUndoActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsUndoMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeUpdateActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsUpdateMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeVideoActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsVideoMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeViewActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAnyOfPropertyIterator{
				activitystreamsViewMember: v,
				alias:                     alias,
			}
			return this, nil
		}
	}
	this := &ActivityStreamsAnyOfPropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// GetActivityStreamsAccept returns the value of this property. When
// IsActivityStreamsAccept returns false, GetActivityStreamsAccept will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsAccept() vocab.ActivityStreamsAccept {
	return this.activitystreamsAcceptMember
}

// GetActivityStreamsActivity returns the value of this property. When
// IsActivityStreamsActivity returns false, GetActivityStreamsActivity will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsActivity() vocab.ActivityStreamsActivity {
	return this.activitystreamsActivityMember
}

// GetActivityStreamsAdd returns the value of this property. When
// IsActivityStreamsAdd returns false, GetActivityStreamsAdd will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsAdd() vocab.ActivityStreamsAdd {
	return this.activitystreamsAddMember
}

// GetActivityStreamsAnnounce returns the value of this property. When
// IsActivityStreamsAnnounce returns false, GetActivityStreamsAnnounce will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsAnnounce() vocab.ActivityStreamsAnnounce {
	return this.activitystreamsAnnounceMember
}

// GetActivityStreamsApplication returns the value of this property. When
// IsActivityStreamsApplication returns false, GetActivityStreamsApplication
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsApplication() vocab.ActivityStreamsApplication {
	return this.activitystreamsApplicationMember
}

// GetActivityStreamsArrive returns the value of this property. When
// IsActivityStreamsArrive returns false, GetActivityStreamsArrive will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsArrive() vocab.ActivityStreamsArrive {
	return this.activitystreamsArriveMember
}

// GetActivityStreamsArticle returns the value of this property. When
// IsActivityStreamsArticle returns false, GetActivityStreamsArticle will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsArticle() vocab.ActivityStreamsArticle {
	return this.activitystreamsArticleMember
}

// GetActivityStreamsAudio returns the value of this property. When
// IsActivityStreamsAudio returns false, GetActivityStreamsAudio will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsAudio() vocab.ActivityStreamsAudio {
	return this.activitystreamsAudioMember
}

// GetActivityStreamsBlock returns the value of this property. When
// IsActivityStreamsBlock returns false, GetActivityStreamsBlock will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsBlock() vocab.ActivityStreamsBlock {
	return this.activitystreamsBlockMember
}

// GetActivityStreamsCollection returns the value of this property. When
// IsActivityStreamsCollection returns false, GetActivityStreamsCollection
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsCollection() vocab.ActivityStreamsCollection {
	return this.activitystreamsCollectionMember
}

// GetActivityStreamsCollectionPage returns the value of this property. When
// IsActivityStreamsCollectionPage returns false,
// GetActivityStreamsCollectionPage will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsCollectionPage() vocab.ActivityStreamsCollectionPage {
	return this.activitystreamsCollectionPageMember
}

// GetActivityStreamsCreate returns the value of this property. When
// IsActivityStreamsCreate returns false, GetActivityStreamsCreate will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsCreate() vocab.ActivityStreamsCreate {
	return this.activitystreamsCreateMember
}

// GetActivityStreamsDelete returns the value of this property. When
// IsActivityStreamsDelete returns false, GetActivityStreamsDelete will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsDelete() vocab.ActivityStreamsDelete {
	return this.activitystreamsDeleteMember
}

// GetActivityStreamsDislike returns the value of this property. When
// IsActivityStreamsDislike returns false, GetActivityStreamsDislike will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsDislike() vocab.ActivityStreamsDislike {
	return this.activitystreamsDislikeMember
}

// GetActivityStreamsDocument returns the value of this property. When
// IsActivityStreamsDocument returns false, GetActivityStreamsDocument will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsDocument() vocab.ActivityStreamsDocument {
	return this.activitystreamsDocumentMember
}

// GetActivityStreamsEvent returns the value of this property. When
// IsActivityStreamsEvent returns false, GetActivityStreamsEvent will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsEvent() vocab.ActivityStreamsEvent {
	return this.activitystreamsEventMember
}

// GetActivityStreamsFlag returns the value of this property. When
// IsActivityStreamsFlag returns false, GetActivityStreamsFlag will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsFlag() vocab.ActivityStreamsFlag {
	return this.activitystreamsFlagMember
}

// GetActivityStreamsFollow returns the value of this property. When
// IsActivityStreamsFollow returns false, GetActivityStreamsFollow will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsFollow() vocab.ActivityStreamsFollow {
	return this.activitystreamsFollowMember
}

// GetActivityStreamsGroup returns the value of this property. When
// IsActivityStreamsGroup returns false, GetActivityStreamsGroup will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsGroup() vocab.ActivityStreamsGroup {
	return this.activitystreamsGroupMember
}

// GetActivityStreamsIgnore returns the value of this property. When
// IsActivityStreamsIgnore returns false, GetActivityStreamsIgnore will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsIgnore() vocab.ActivityStreamsIgnore {
	return this.activitystreamsIgnoreMember
}

// GetActivityStreamsImage returns the value of this property. When
// IsActivityStreamsImage returns false, GetActivityStreamsImage will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsImage() vocab.ActivityStreamsImage {
	return this.activitystreamsImageMember
}

// GetActivityStreamsIntransitiveActivity returns the value of this property. When
// IsActivityStreamsIntransitiveActivity returns false,
// GetActivityStreamsIntransitiveActivity will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsIntransitiveActivity() vocab.ActivityStreamsIntransitiveActivity {
	return this.activitystreamsIntransitiveActivityMember
}

// GetActivityStreamsInvite returns the value of this property. When
// IsActivityStreamsInvite returns false, GetActivityStreamsInvite will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsInvite() vocab.ActivityStreamsInvite {
	return this.activitystreamsInviteMember
}

// GetActivityStreamsJoin returns the value of this property. When
// IsActivityStreamsJoin returns false, GetActivityStreamsJoin will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsJoin() vocab.ActivityStreamsJoin {
	return this.activitystreamsJoinMember
}

// GetActivityStreamsLeave returns the value of this property. When
// IsActivityStreamsLeave returns false, GetActivityStreamsLeave will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsLeave() vocab.ActivityStreamsLeave {
	return this.activitystreamsLeaveMember
}

// GetActivityStreamsLike returns the value of this property. When
// IsActivityStreamsLike returns false, GetActivityStreamsLike will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsLike() vocab.ActivityStreamsLike {
	return this.activitystreamsLikeMember
}

// GetActivityStreamsLink returns the value of this property. When
// IsActivityStreamsLink returns false, GetActivityStreamsLink will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsLink() vocab.ActivityStreamsLink {
	return this.activitystreamsLinkMember
}

// GetActivityStreamsListen returns the value of this property. When
// IsActivityStreamsListen returns false, GetActivityStreamsListen will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsListen() vocab.ActivityStreamsListen {
	return this.activitystreamsListenMember
}

// GetActivityStreamsMention returns the value of this property. When
// IsActivityStreamsMention returns false, GetActivityStreamsMention will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsMention() vocab.ActivityStreamsMention {
	return this.activitystreamsMentionMember
}

// GetActivityStreamsMove returns the value of this property. When
// IsActivityStreamsMove returns false, GetActivityStreamsMove will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsMove() vocab.ActivityStreamsMove {
	return this.activitystreamsMoveMember
}

// GetActivityStreamsNote returns the value of this property. When
// IsActivityStreamsNote returns false, GetActivityStreamsNote will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsNote() vocab.ActivityStreamsNote {
	return this.activitystreamsNoteMember
}

// GetActivityStreamsObject returns the value of this property. When
// IsActivityStreamsObject returns false, GetActivityStreamsObject will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsObject() vocab.ActivityStreamsObject {
	return this.activitystreamsObjectMember
}

// GetActivityStreamsOffer returns the value of this property. When
// IsActivityStreamsOffer returns false, GetActivityStreamsOffer will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsOffer() vocab.ActivityStreamsOffer {
	return this.activitystreamsOfferMember
}

// GetActivityStreamsOrderedCollection returns the value of this property. When
// IsActivityStreamsOrderedCollection returns false,
// GetActivityStreamsOrderedCollection will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsOrderedCollection() vocab.ActivityStreamsOrderedCollection {
	return this.activitystreamsOrderedCollectionMember
}

// GetActivityStreamsOrderedCollectionPage returns the value of this property.
// When IsActivityStreamsOrderedCollectionPage returns false,
// GetActivityStreamsOrderedCollectionPage will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsOrderedCollectionPage() vocab.ActivityStreamsOrderedCollectionPage {
	return this.activitystreamsOrderedCollectionPageMember
}

// GetActivityStreamsOrganization returns the value of this property. When
// IsActivityStreamsOrganization returns false, GetActivityStreamsOrganization
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsOrganization() vocab.ActivityStreamsOrganization {
	return this.activitystreamsOrganizationMember
}

// GetActivityStreamsPage returns the value of this property. When
// IsActivityStreamsPage returns false, GetActivityStreamsPage will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsPage() vocab.ActivityStreamsPage {
	return this.activitystreamsPageMember
}

// GetActivityStreamsPerson returns the value of this property. When
// IsActivityStreamsPerson returns false, GetActivityStreamsPerson will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsPerson() vocab.ActivityStreamsPerson {
	return this.activitystreamsPersonMember
}

// GetActivityStreamsPlace returns the value of this property. When
// IsActivityStreamsPlace returns false, GetActivityStreamsPlace will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsPlace() vocab.ActivityStreamsPlace {
	return this.activitystreamsPlaceMember
}

// GetActivityStreamsProfile returns the value of this property. When
// IsActivityStreamsProfile returns false, GetActivityStreamsProfile will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsProfile() vocab.ActivityStreamsProfile {
	return this.activitystreamsProfileMember
}

// GetActivityStreamsQuestion returns the value of this property. When
// IsActivityStreamsQuestion returns false, GetActivityStreamsQuestion will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsQuestion() vocab.ActivityStreamsQuestion {
	return this.activitystreamsQuestionMember
}

// GetActivityStreamsRead returns the value of this property. When
// IsActivityStreamsRead returns false, GetActivityStreamsRead will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsRead() vocab.ActivityStreamsRead {
	return this.activitystreamsReadMember
}

// GetActivityStreamsReject returns the value of this property. When
// IsActivityStreamsReject returns false, GetActivityStreamsReject will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsReject() vocab.ActivityStreamsReject {
	return this.activitystreamsRejectMember
}

// GetActivityStreamsRelationship returns the value of this property. When
// IsActivityStreamsRelationship returns false, GetActivityStreamsRelationship
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsRelationship() vocab.ActivityStreamsRelationship {
	return this.activitystreamsRelationshipMember
}

// GetActivityStreamsRemove returns the value of this property. When
// IsActivityStreamsRemove returns false, GetActivityStreamsRemove will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsRemove() vocab.ActivityStreamsRemove {
	return this.activitystreamsRemoveMember
}

// GetActivityStreamsService returns the value of this property. When
// IsActivityStreamsService returns false, GetActivityStreamsService will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsService() vocab.ActivityStreamsService {
	return this.activitystreamsServiceMember
}

// GetActivityStreamsTentativeAccept returns the value of this property. When
// IsActivityStreamsTentativeAccept returns false,
// GetActivityStreamsTentativeAccept will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsTentativeAccept() vocab.ActivityStreamsTentativeAccept {
	return this.activitystreamsTentativeAcceptMember
}

// GetActivityStreamsTentativeReject returns the value of this property. When
// IsActivityStreamsTentativeReject returns false,
// GetActivityStreamsTentativeReject will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsTentativeReject() vocab.ActivityStreamsTentativeReject {
	return this.activitystreamsTentativeRejectMember
}

// GetActivityStreamsTombstone returns the value of this property. When
// IsActivityStreamsTombstone returns false, GetActivityStreamsTombstone will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsTombstone() vocab.ActivityStreamsTombstone {
	return this.activitystreamsTombstoneMember
}

// GetActivityStreamsTravel returns the value of this property. When
// IsActivityStreamsTravel returns false, GetActivityStreamsTravel will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsTravel() vocab.ActivityStreamsTravel {
	return this.activitystreamsTravelMember
}

// GetActivityStreamsUndo returns the value of this property. When
// IsActivityStreamsUndo returns false, GetActivityStreamsUndo will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsUndo() vocab.ActivityStreamsUndo {
	return this.activitystreamsUndoMember
}

// GetActivityStreamsUpdate returns the value of this property. When
// IsActivityStreamsUpdate returns false, GetActivityStreamsUpdate will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsUpdate() vocab.ActivityStreamsUpdate {
	return this.activitystreamsUpdateMember
}

// GetActivityStreamsVideo returns the value of this property. When
// IsActivityStreamsVideo returns false, GetActivityStreamsVideo will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsVideo() vocab.ActivityStreamsVideo {
	return this.activitystreamsVideoMember
}

// GetActivityStreamsView returns the value of this property. When
// IsActivityStreamsView returns false, GetActivityStreamsView will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetActivityStreamsView() vocab.ActivityStreamsView {
	return this.activitystreamsViewMember
}

// GetFunkwhaleAlbum returns the value of this property. When IsFunkwhaleAlbum
// returns false, GetFunkwhaleAlbum will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetFunkwhaleAlbum() vocab.FunkwhaleAlbum {
	return this.funkwhaleAlbumMember
}

// GetFunkwhaleArtist returns the value of this property. When IsFunkwhaleArtist
// returns false, GetFunkwhaleArtist will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetFunkwhaleArtist() vocab.FunkwhaleArtist {
	return this.funkwhaleArtistMember
}

// GetFunkwhaleLibrary returns the value of this property. When IsFunkwhaleLibrary
// returns false, GetFunkwhaleLibrary will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetFunkwhaleLibrary() vocab.FunkwhaleLibrary {
	return this.funkwhaleLibraryMember
}

// GetFunkwhaleTrack returns the value of this property. When IsFunkwhaleTrack
// returns false, GetFunkwhaleTrack will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetFunkwhaleTrack() vocab.FunkwhaleTrack {
	return this.funkwhaleTrackMember
}

// GetGoToSocialAnnounceApproval returns the value of this property. When
// IsGoToSocialAnnounceApproval returns false, GetGoToSocialAnnounceApproval
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialAnnounceApproval() vocab.GoToSocialAnnounceApproval {
	return this.gotosocialAnnounceApprovalMember
}

// GetGoToSocialAnnounceAuthorization returns the value of this property. When
// IsGoToSocialAnnounceAuthorization returns false,
// GetGoToSocialAnnounceAuthorization will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialAnnounceAuthorization() vocab.GoToSocialAnnounceAuthorization {
	return this.gotosocialAnnounceAuthorizationMember
}

// GetGoToSocialAnnounceRequest returns the value of this property. When
// IsGoToSocialAnnounceRequest returns false, GetGoToSocialAnnounceRequest
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialAnnounceRequest() vocab.GoToSocialAnnounceRequest {
	return this.gotosocialAnnounceRequestMember
}

// GetGoToSocialLikeApproval returns the value of this property. When
// IsGoToSocialLikeApproval returns false, GetGoToSocialLikeApproval will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialLikeApproval() vocab.GoToSocialLikeApproval {
	return this.gotosocialLikeApprovalMember
}

// GetGoToSocialLikeAuthorization returns the value of this property. When
// IsGoToSocialLikeAuthorization returns false, GetGoToSocialLikeAuthorization
// will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialLikeAuthorization() vocab.GoToSocialLikeAuthorization {
	return this.gotosocialLikeAuthorizationMember
}

// GetGoToSocialLikeRequest returns the value of this property. When
// IsGoToSocialLikeRequest returns false, GetGoToSocialLikeRequest will return
// an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialLikeRequest() vocab.GoToSocialLikeRequest {
	return this.gotosocialLikeRequestMember
}

// GetGoToSocialReplyApproval returns the value of this property. When
// IsGoToSocialReplyApproval returns false, GetGoToSocialReplyApproval will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialReplyApproval() vocab.GoToSocialReplyApproval {
	return this.gotosocialReplyApprovalMember
}

// GetGoToSocialReplyAuthorization returns the value of this property. When
// IsGoToSocialReplyAuthorization returns false,
// GetGoToSocialReplyAuthorization will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialReplyAuthorization() vocab.GoToSocialReplyAuthorization {
	return this.gotosocialReplyAuthorizationMember
}

// GetGoToSocialReplyRequest returns the value of this property. When
// IsGoToSocialReplyRequest returns false, GetGoToSocialReplyRequest will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetGoToSocialReplyRequest() vocab.GoToSocialReplyRequest {
	return this.gotosocialReplyRequestMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// GetLitePubEmojiReact returns the value of this property. When
// IsLitePubEmojiReact returns false, GetLitePubEmojiReact will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetLitePubEmojiReact() vocab.LitePubEmojiReact {
	return this.litepubEmojiReactMember
}

// GetSchemaPropertyValue returns the value of this property. When
// IsSchemaPropertyValue returns false, GetSchemaPropertyValue will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetSchemaPropertyValue() vocab.SchemaPropertyValue {
	return this.schemaPropertyValueMember
}

// GetTootEmoji returns the value of this property. When IsTootEmoji returns
// false, GetTootEmoji will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetTootEmoji() vocab.TootEmoji {
	return this.tootEmojiMember
}

// GetTootHashtag returns the value of this property. When IsTootHashtag returns
// false, GetTootHashtag will return an arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetTootHashtag() vocab.TootHashtag {
	return this.tootHashtagMember
}

// GetTootIdentityProof returns the value of this property. When
// IsTootIdentityProof returns false, GetTootIdentityProof will return an
// arbitrary value.
func (this ActivityStreamsAnyOfPropertyIterator) GetTootIdentityProof() vocab.TootIdentityProof {
	return this.tootIdentityProofMember
}

// GetType returns the value in this property as a Type. Returns nil if the value
// is not an ActivityStreams type, such as an IRI or another value.
func (this ActivityStreamsAnyOfPropertyIterator) GetType() vocab.Type {
	if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject()
	}
	if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink()
	}
	if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept()
	}
	if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity()
	}
	if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd()
	}
	if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum()
	}
	if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce()
	}
	if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval()
	}
	if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization()
	}
	if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest()
	}
	if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication()
	}
	if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive()
	}
	if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle()
	}
	if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist()
	}
	if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio()
	}
	if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock()
	}
	if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection()
	}
	if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage()
	}
	if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate()
	}
	if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete()
	}
	if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike()
	}
	if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument()
	}
	if this.IsTootEmoji() {
		return this.GetTootEmoji()
	}
	if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact()
	}
	if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent()
	}
	if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag()
	}
	if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow()
	}
	if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup()
	}
	if this.IsTootHashtag() {
		return this.GetTootHashtag()
	}
	if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof()
	}
	if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore()
	}
	if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage()
	}
	if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity()
	}
	if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite()
	}
	if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin()
	}
	if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave()
	}
	if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary()
	}
	if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike()
	}
	if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval()
	}
	if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization()
	}
	if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest()
	}
	if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen()
	}
	if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention()
	}
	if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove()
	}
	if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote()
	}
	if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer()
	}
	if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection()
	}
	if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage()
	}
	if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization()
	}
	if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage()
	}
	if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson()
	}
	if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace()
	}
	if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile()
	}
	if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue()
	}
	if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion()
	}
	if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead()
	}
	if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject()
	}
	if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship()
	}
	if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove()
	}
	if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval()
	}
	if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization()
	}
	if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest()
	}
	if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService()
	}
	if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept()
	}
	if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject()
	}
	if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone()
	}
	if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack()
	}
	if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel()
	}
	if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo()
	}
	if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate()
	}
	if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo()
	}
	if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView()
	}

	return nil
}

// HasAny returns true if any of the different values is set.
func (this ActivityStreamsAnyOfPropertyIterator) HasAny() bool {
	return this.IsActivityStreamsObject() ||
		this.IsActivityStreamsLink() ||
		this.IsActivityStreamsAccept() ||
		this.IsActivityStreamsActivity() ||
		this.IsActivityStreamsAdd() ||
		this.IsFunkwhaleAlbum() ||
		this.IsActivityStreamsAnnounce() ||
		this.IsGoToSocialAnnounceApproval() ||
		this.IsGoToSocialAnnounceAuthorization() ||
		this.IsGoToSocialAnnounceRequest() ||
		this.IsActivityStreamsApplication() ||
		this.IsActivityStreamsArrive() ||
		this.IsActivityStreamsArticle() ||
		this.IsFunkwhaleArtist() ||
		this.IsActivityStreamsAudio() ||
		this.IsActivityStreamsBlock() ||
		this.IsActivityStreamsCollection() ||
		this.IsActivityStreamsCollectionPage() ||
		this.IsActivityStreamsCreate() ||
		this.IsActivityStreamsDelete() ||
		this.IsActivityStreamsDislike() ||
		this.IsActivityStreamsDocument() ||
		this.IsTootEmoji() ||
		this.IsLitePubEmojiReact() ||
		this.IsActivityStreamsEvent() ||
		this.IsActivityStreamsFlag() ||
		this.IsActivityStreamsFollow() ||
		this.IsActivityStreamsGroup() ||
		this.IsTootHashtag() ||
		this.IsTootIdentityProof() ||
		this.IsActivityStreamsIgnore() ||
		this.IsActivityStreamsImage() ||
		this.IsActivityStreamsIntransitiveActivity() ||
		this.IsActivityStreamsInvite() ||
		this.IsActivityStreamsJoin() ||
		this.IsActivityStreamsLeave() ||
		this.IsFunkwhaleLibrary() ||
		this.IsActivityStreamsLike() ||
		this.IsGoToSocialLikeApproval() ||
		this.IsGoToSocialLikeAuthorization() ||
		this.IsGoToSocialLikeRequest() ||
		this.IsActivityStreamsListen() ||
		this.IsActivityStreamsMention() ||
		this.IsActivityStreamsMove() ||
		this.IsActivityStreamsNote() ||
		this.IsActivityStreamsOffer() ||
		this.IsActivityStreamsOrderedCollection() ||
		this.IsActivityStreamsOrderedCollectionPage() ||
		this.IsActivityStreamsOrganization() ||
		this.IsActivityStreamsPage() ||
		this.IsActivityStreamsPerson() ||
		this.IsActivityStreamsPlace() ||
		this.IsActivityStreamsProfile() ||
		this.IsSchemaPropertyValue() ||
		this.IsActivityStreamsQuestion() ||
		this.IsActivityStreamsRead() ||
		this.IsActivityStreamsReject() ||
		this.IsActivityStreamsRelationship() ||
		this.IsActivityStreamsRemove() ||
		this.IsGoToSocialReplyApproval() ||
		this.IsGoToSocialReplyAuthorization() ||
		this.IsGoToSocialReplyRequest() ||
		this.IsActivityStreamsService() ||
		this.IsActivityStreamsTentativeAccept() ||
		this.IsActivityStreamsTentativeReject() ||
		this.IsActivityStreamsTombstone() ||
		this.IsFunkwhaleTrack() ||
		this.IsActivityStreamsTravel() ||
		this.IsActivityStreamsUndo() ||
		this.IsActivityStreamsUpdate() ||
		this.IsActivityStreamsVideo() ||
		this.IsActivityStreamsView() ||
		this.iri != nil
}

// IsActivityStreamsAccept returns true if this property has a type of "Accept".
// When true, use the GetActivityStreamsAccept and SetActivityStreamsAccept
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsAccept() bool {
	return this.activitystreamsAcceptMember != nil
}

// IsActivityStreamsActivity returns true if this property has a type of
// "Activity". When true, use the GetActivityStreamsActivity and
// SetActivityStreamsActivity methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsActivity() bool {
	return this.activitystreamsActivityMember != nil
}

// IsActivityStreamsAdd returns true if this property has a type of "Add". When
// true, use the GetActivityStreamsAdd and SetActivityStreamsAdd methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsAdd() bool {
	return this.activitystreamsAddMember != nil
}

// IsActivityStreamsAnnounce returns true if this property has a type of
// "Announce". When true, use the GetActivityStreamsAnnounce and
// SetActivityStreamsAnnounce methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsAnnounce() bool {
	return this.activitystreamsAnnounceMember != nil
}

// IsActivityStreamsApplication returns true if this property has a type of
// "Application". When true, use the GetActivityStreamsApplication and
// SetActivityStreamsApplication methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsApplication() bool {
	return this.activitystreamsApplicationMember != nil
}

// IsActivityStreamsArrive returns true if this property has a type of "Arrive".
// When true, use the GetActivityStreamsArrive and SetActivityStreamsArrive
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsArrive() bool {
	return this.activitystreamsArriveMember != nil
}

// IsActivityStreamsArticle returns true if this property has a type of "Article".
// When true, use the GetActivityStreamsArticle and SetActivityStreamsArticle
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsArticle() bool {
	return this.activitystreamsArticleMember != nil
}

// IsActivityStreamsAudio returns true if this property has a type of "Audio".
// When true, use the GetActivityStreamsAudio and SetActivityStreamsAudio
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsAudio() bool {
	return this.activitystreamsAudioMember != nil
}

// IsActivityStreamsBlock returns true if this property has a type of "Block".
// When true, use the GetActivityStreamsBlock and SetActivityStreamsBlock
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsBlock() bool {
	return this.activitystreamsBlockMember != nil
}

// IsActivityStreamsCollection returns true if this property has a type of
// "Collection". When true, use the GetActivityStreamsCollection and
// SetActivityStreamsCollection methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsCollection() bool {
	return this.activitystreamsCollectionMember != nil
}

// IsActivityStreamsCollectionPage returns true if this property has a type of
// "CollectionPage". When true, use the GetActivityStreamsCollectionPage and
// SetActivityStreamsCollectionPage methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsCollectionPage() bool {
	return this.activitystreamsCollectionPageMember != nil
}

// IsActivityStreamsCreate returns true if this property has a type of "Create".
// When true, use the GetActivityStreamsCreate and SetActivityStreamsCreate
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsCreate() bool {
	return this.activitystreamsCreateMember != nil
}

// IsActivityStreamsDelete returns true if this property has a type of "Delete".
// When true, use the GetActivityStreamsDelete and SetActivityStreamsDelete
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsDelete() bool {
	return this.activitystreamsDeleteMember != nil
}

// IsActivityStreamsDislike returns true if this property has a type of "Dislike".
// When true, use the GetActivityStreamsDislike and SetActivityStreamsDislike
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsDislike() bool {
	return this.activitystreamsDislikeMember != nil
}

// IsActivityStreamsDocument returns true if this property has a type of
// "Document". When true, use the GetActivityStreamsDocument and
// SetActivityStreamsDocument methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsDocument() bool {
	return this.activitystreamsDocumentMember != nil
}

// IsActivityStreamsEvent returns true if this property has a type of "Event".
// When true, use the GetActivityStreamsEvent and SetActivityStreamsEvent
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsEvent() bool {
	return this.activitystreamsEventMember != nil
}

// IsActivityStreamsFlag returns true if this property has a type of "Flag". When
// true, use the GetActivityStreamsFlag and SetActivityStreamsFlag methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsFlag() bool {
	return this.activitystreamsFlagMember != nil
}

// IsActivityStreamsFollow returns true if this property has a type of "Follow".
// When true, use the GetActivityStreamsFollow and SetActivityStreamsFollow
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsFollow() bool {
	return this.activitystreamsFollowMember != nil
}

// IsActivityStreamsGroup returns true if this property has a type of "Group".
// When true, use the GetActivityStreamsGroup and SetActivityStreamsGroup
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsGroup() bool {
	return this.activitystreamsGroupMember != nil
}

// IsActivityStreamsIgnore returns true if this property has a type of "Ignore".
// When true, use the GetActivityStreamsIgnore and SetActivityStreamsIgnore
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsIgnore() bool {
	return this.activitystreamsIgnoreMember != nil
}

// IsActivityStreamsImage returns true if this property has a type of "Image".
// When true, use the GetActivityStreamsImage and SetActivityStreamsImage
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsImage() bool {
	return this.activitystreamsImageMember != nil
}

// IsActivityStreamsIntransitiveActivity returns true if this property has a type
// of "IntransitiveActivity". When true, use the
// GetActivityStreamsIntransitiveActivity and
// SetActivityStreamsIntransitiveActivity methods to access and set this
// property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsIntransitiveActivity() bool {
	return this.activitystreamsIntransitiveActivityMember != nil
}

// IsActivityStreamsInvite returns true if this property has a type of "Invite".
// When true, use the GetActivityStreamsInvite and SetActivityStreamsInvite
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsInvite() bool {
	return this.activitystreamsInviteMember != nil
}

// IsActivityStreamsJoin returns true if this property has a type of "Join". When
// true, use the GetActivityStreamsJoin and SetActivityStreamsJoin methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsJoin() bool {
	return this.activitystreamsJoinMember != nil
}

// IsActivityStreamsLeave returns true if this property has a type of "Leave".
// When true, use the GetActivityStreamsLeave and SetActivityStreamsLeave
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsLeave() bool {
	return this.activitystreamsLeaveMember != nil
}

// IsActivityStreamsLike returns true if this property has a type of "Like". When
// true, use the GetActivityStreamsLike and SetActivityStreamsLike methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsLike() bool {
	return this.activitystreamsLikeMember != nil
}

// IsActivityStreamsLink returns true if this property has a type of "Link". When
// true, use the GetActivityStreamsLink and SetActivityStreamsLink methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsLink() bool {
	return this.activitystreamsLinkMember != nil
}

// IsActivityStreamsListen returns true if this property has a type of "Listen".
// When true, use the GetActivityStreamsListen and SetActivityStreamsListen
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsListen() bool {
	return this.activitystreamsListenMember != nil
}

// IsActivityStreamsMention returns true if this property has a type of "Mention".
// When true, use the GetActivityStreamsMention and SetActivityStreamsMention
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsMention() bool {
	return this.activitystreamsMentionMember != nil
}

// IsActivityStreamsMove returns true if this property has a type of "Move". When
// true, use the GetActivityStreamsMove and SetActivityStreamsMove methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsMove() bool {
	return this.activitystreamsMoveMember != nil
}

// IsActivityStreamsNote returns true if this property has a type of "Note". When
// true, use the GetActivityStreamsNote and SetActivityStreamsNote methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsNote() bool {
	return this.activitystreamsNoteMember != nil
}

// IsActivityStreamsObject returns true if this property has a type of "Object".
// When true, use the GetActivityStreamsObject and SetActivityStreamsObject
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsObject() bool {
	return this.activitystreamsObjectMember != nil
}

// IsActivityStreamsOffer returns true if this property has a type of "Offer".
// When true, use the GetActivityStreamsOffer and SetActivityStreamsOffer
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsOffer() bool {
	return this.activitystreamsOfferMember != nil
}

// IsActivityStreamsOrderedCollection returns true if this property has a type of
// "OrderedCollection". When true, use the GetActivityStreamsOrderedCollection
// and SetActivityStreamsOrderedCollection methods to access and set this
// property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsOrderedCollection() bool {
	return this.activitystreamsOrderedCollectionMember != nil
}

// IsActivityStreamsOrderedCollectionPage returns true if this property has a type
// of "OrderedCollectionPage". When true, use the
// GetActivityStreamsOrderedCollectionPage and
// SetActivityStreamsOrderedCollectionPage methods to access and set this
// property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsOrderedCollectionPage() bool {
	return this.activitystreamsOrderedCollectionPageMember != nil
}

// IsActivityStreamsOrganization returns true if this property has a type of
// "Organization". When true, use the GetActivityStreamsOrganization and
// SetActivityStreamsOrganization methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsOrganization() bool {
	return this.activitystreamsOrganizationMember != nil
}

// IsActivityStreamsPage returns true if this property has a type of "Page". When
// true, use the GetActivityStreamsPage and SetActivityStreamsPage methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsPage() bool {
	return this.activitystreamsPageMember != nil
}

// IsActivityStreamsPerson returns true if this property has a type of "Person".
// When true, use the GetActivityStreamsPerson and SetActivityStreamsPerson
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsPerson() bool {
	return this.activitystreamsPersonMember != nil
}

// IsActivityStreamsPlace returns true if this property has a type of "Place".
// When true, use the GetActivityStreamsPlace and SetActivityStreamsPlace
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsPlace() bool {
	return this.activitystreamsPlaceMember != nil
}

// IsActivityStreamsProfile returns true if this property has a type of "Profile".
// When true, use the GetActivityStreamsProfile and SetActivityStreamsProfile
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsProfile() bool {
	return this.activitystreamsProfileMember != nil
}

// IsActivityStreamsQuestion returns true if this property has a type of
// "Question". When true, use the GetActivityStreamsQuestion and
// SetActivityStreamsQuestion methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsQuestion() bool {
	return this.activitystreamsQuestionMember != nil
}

// IsActivityStreamsRead returns true if this property has a type of "Read". When
// true, use the GetActivityStreamsRead and SetActivityStreamsRead methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsRead() bool {
	return this.activitystreamsReadMember != nil
}

// IsActivityStreamsReject returns true if this property has a type of "Reject".
// When true, use the GetActivityStreamsReject and SetActivityStreamsReject
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsReject() bool {
	return this.activitystreamsRejectMember != nil
}

// IsActivityStreamsRelationship returns true if this property has a type of
// "Relationship". When true, use the GetActivityStreamsRelationship and
// SetActivityStreamsRelationship methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsRelationship() bool {
	return this.activitystreamsRelationshipMember != nil
}

// IsActivityStreamsRemove returns true if this property has a type of "Remove".
// When true, use the GetActivityStreamsRemove and SetActivityStreamsRemove
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsRemove() bool {
	return this.activitystreamsRemoveMember != nil
}

// IsActivityStreamsService returns true if this property has a type of "Service".
// When true, use the GetActivityStreamsService and SetActivityStreamsService
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsService() bool {
	return this.activitystreamsServiceMember != nil
}

// IsActivityStreamsTentativeAccept returns true if this property has a type of
// "TentativeAccept". When true, use the GetActivityStreamsTentativeAccept and
// SetActivityStreamsTentativeAccept methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsTentativeAccept() bool {
	return this.activitystreamsTentativeAcceptMember != nil
}

// IsActivityStreamsTentativeReject returns true if this property has a type of
// "TentativeReject". When true, use the GetActivityStreamsTentativeReject and
// SetActivityStreamsTentativeReject methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsTentativeReject() bool {
	return this.activitystreamsTentativeRejectMember != nil
}

// IsActivityStreamsTombstone returns true if this property has a type of
// "Tombstone". When true, use the GetActivityStreamsTombstone and
// SetActivityStreamsTombstone methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsTombstone() bool {
	return this.activitystreamsTombstoneMember != nil
}

// IsActivityStreamsTravel returns true if this property has a type of "Travel".
// When true, use the GetActivityStreamsTravel and SetActivityStreamsTravel
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsTravel() bool {
	return this.activitystreamsTravelMember != nil
}

// IsActivityStreamsUndo returns true if this property has a type of "Undo". When
// true, use the GetActivityStreamsUndo and SetActivityStreamsUndo methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsUndo() bool {
	return this.activitystreamsUndoMember != nil
}

// IsActivityStreamsUpdate returns true if this property has a type of "Update".
// When true, use the GetActivityStreamsUpdate and SetActivityStreamsUpdate
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsUpdate() bool {
	return this.activitystreamsUpdateMember != nil
}

// IsActivityStreamsVideo returns true if this property has a type of "Video".
// When true, use the GetActivityStreamsVideo and SetActivityStreamsVideo
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsVideo() bool {
	return this.activitystreamsVideoMember != nil
}

// IsActivityStreamsView returns true if this property has a type of "View". When
// true, use the GetActivityStreamsView and SetActivityStreamsView methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsActivityStreamsView() bool {
	return this.activitystreamsViewMember != nil
}

// IsFunkwhaleAlbum returns true if this property has a type of "Album". When
// true, use the GetFunkwhaleAlbum and SetFunkwhaleAlbum methods to access and
// set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsFunkwhaleAlbum() bool {
	return this.funkwhaleAlbumMember != nil
}

// IsFunkwhaleArtist returns true if this property has a type of "Artist". When
// true, use the GetFunkwhaleArtist and SetFunkwhaleArtist methods to access
// and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsFunkwhaleArtist() bool {
	return this.funkwhaleArtistMember != nil
}

// IsFunkwhaleLibrary returns true if this property has a type of "Library". When
// true, use the GetFunkwhaleLibrary and SetFunkwhaleLibrary methods to access
// and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsFunkwhaleLibrary() bool {
	return this.funkwhaleLibraryMember != nil
}

// IsFunkwhaleTrack returns true if this property has a type of "Track". When
// true, use the GetFunkwhaleTrack and SetFunkwhaleTrack methods to access and
// set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsFunkwhaleTrack() bool {
	return this.funkwhaleTrackMember != nil
}

// IsGoToSocialAnnounceApproval returns true if this property has a type of
// "AnnounceApproval". When true, use the GetGoToSocialAnnounceApproval and
// SetGoToSocialAnnounceApproval methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialAnnounceApproval() bool {
	return this.gotosocialAnnounceApprovalMember != nil
}

// IsGoToSocialAnnounceAuthorization returns true if this property has a type of
// "AnnounceAuthorization". When true, use the
// GetGoToSocialAnnounceAuthorization and SetGoToSocialAnnounceAuthorization
// methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialAnnounceAuthorization() bool {
	return this.gotosocialAnnounceAuthorizationMember != nil
}

// IsGoToSocialAnnounceRequest returns true if this property has a type of
// "AnnounceRequest". When true, use the GetGoToSocialAnnounceRequest and
// SetGoToSocialAnnounceRequest methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialAnnounceRequest() bool {
	return this.gotosocialAnnounceRequestMember != nil
}

// IsGoToSocialLikeApproval returns true if this property has a type of
// "LikeApproval". When true, use the GetGoToSocialLikeApproval and
// SetGoToSocialLikeApproval methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialLikeApproval() bool {
	return this.gotosocialLikeApprovalMember != nil
}

// IsGoToSocialLikeAuthorization returns true if this property has a type of
// "LikeAuthorization". When true, use the GetGoToSocialLikeAuthorization and
// SetGoToSocialLikeAuthorization methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialLikeAuthorization() bool {
	return this.gotosocialLikeAuthorizationMember != nil
}

// IsGoToSocialLikeRequest returns true if this property has a type of
// "LikeRequest". When true, use the GetGoToSocialLikeRequest and
// SetGoToSocialLikeRequest methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialLikeRequest() bool {
	return this.gotosocialLikeRequestMember != nil
}

// IsGoToSocialReplyApproval returns true if this property has a type of
// "ReplyApproval". When true, use the GetGoToSocialReplyApproval and
// SetGoToSocialReplyApproval methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialReplyApproval() bool {
	return this.gotosocialReplyApprovalMember != nil
}

// IsGoToSocialReplyAuthorization returns true if this property has a type of
// "ReplyAuthorization". When true, use the GetGoToSocialReplyAuthorization
// and SetGoToSocialReplyAuthorization methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialReplyAuthorization() bool {
	return this.gotosocialReplyAuthorizationMember != nil
}

// IsGoToSocialReplyRequest returns true if this property has a type of
// "ReplyRequest". When true, use the GetGoToSocialReplyRequest and
// SetGoToSocialReplyRequest methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsGoToSocialReplyRequest() bool {
	return this.gotosocialReplyRequestMember != nil
}

// IsIRI returns true if this property is an IRI. When true, use GetIRI and SetIRI
// to access and set this property
func (this ActivityStreamsAnyOfPropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// IsLitePubEmojiReact returns true if this property has a type of "EmojiReact".
// When true, use the GetLitePubEmojiReact and SetLitePubEmojiReact methods to
// access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsLitePubEmojiReact() bool {
	return this.litepubEmojiReactMember != nil
}

// IsSchemaPropertyValue returns true if this property has a type of
// "PropertyValue". When true, use the GetSchemaPropertyValue and
// SetSchemaPropertyValue methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsSchemaPropertyValue() bool {
	return this.schemaPropertyValueMember != nil
}

// IsTootEmoji returns true if this property has a type of "Emoji". When true, use
// the GetTootEmoji and SetTootEmoji methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsTootEmoji() bool {
	return this.tootEmojiMember != nil
}

// IsTootHashtag returns true if this property has a type of "Hashtag". When true,
// use the GetTootHashtag and SetTootHashtag methods to access and set this
// property.
func (this ActivityStreamsAnyOfPropertyIterator) IsTootHashtag() bool {
	return this.tootHashtagMember != nil
}

// IsTootIdentityProof returns true if this property has a type of
// "IdentityProof". When true, use the GetTootIdentityProof and
// SetTootIdentityProof methods to access and set this property.
func (this ActivityStreamsAnyOfPropertyIterator) IsTootIdentityProof() bool {
	return this.tootIdentityProofMember != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsAnyOfPropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	var child map[string]string
	if this.IsActivityStreamsObject() {
		child = this.GetActivityStreamsObject().JSONLDContext()
	} else if this.IsActivityStreamsLink() {
		child = this.GetActivityStreamsLink().JSONLDContext()
	} else if this.IsActivityStreamsAccept() {
		child = this.GetActivityStreamsAccept().JSONLDContext()
	} else if this.IsActivityStreamsActivity() {
		child = this.GetActivityStreamsActivity().JSONLDContext()
	} else if this.IsActivityStreamsAdd() {
		child = this.GetActivityStreamsAdd().JSONLDContext()
	} else if this.IsFunkwhaleAlbum() {
		child = this.GetFunkwhaleAlbum().JSONLDContext()
	} else if this.IsActivityStreamsAnnounce() {
		child = this.GetActivityStreamsAnnounce().JSONLDContext()
	} else if this.IsGoToSocialAnnounceApproval() {
		child = this.GetGoToSocialAnnounceApproval().JSONLDContext()
	} else if this.IsGoToSocialAnnounceAuthorization() {
		child = this.GetGoToSocialAnnounceAuthorization().JSONLDContext()
	} else if this.IsGoToSocialAnnounceRequest() {
		child = this.GetGoToSocialAnnounceRequest().JSONLDContext()
	} else if this.IsActivityStreamsApplication() {
		child = this.GetActivityStreamsApplication().JSONLDContext()
	} else if this.IsActivityStreamsArrive() {
		child = this.GetActivityStreamsArrive().JSONLDContext()
	} else if this.IsActivityStreamsArticle() {
		child = this.GetActivityStreamsArticle().JSONLDContext()
	} else if this.IsFunkwhaleArtist() {
		child = this.GetFunkwhaleArtist().JSONLDContext()
	} else if this.IsActivityStreamsAudio() {
		child = this.GetActivityStreamsAudio().JSONLDContext()
	} else if this.IsActivityStreamsBlock() {
		child = this.GetActivityStreamsBlock().JSONLDContext()
	} else if this.IsActivityStreamsCollection() {
		child = this.GetActivityStreamsCollection().JSONLDContext()
	} else if this.IsActivityStreamsCollectionPage() {
		child = this.GetActivityStreamsCollectionPage().JSONLDContext()
	} else if this.IsActivityStreamsCreate() {
		child = this.GetActivityStreamsCreate().JSONLDContext()
	} else if this.IsActivityStreamsDelete() {
		child = this.GetActivityStreamsDelete().JSONLDContext()
	} else if this.IsActivityStreamsDislike() {
		child = this.GetActivityStreamsDislike().JSONLDContext()
	} else if this.IsActivityStreamsDocument() {
		child = this.GetActivityStreamsDocument().JSONLDContext()
	} else if this.IsTootEmoji() {
		child = this.GetTootEmoji().JSONLDContext()
	} else if this.IsLitePubEmojiReact() {
		child = this.GetLitePubEmojiReact().JSONLDContext()
	} else if this.IsActivityStreamsEvent() {
		child = this.GetActivityStreamsEvent().JSONLDContext()
	} else if this.IsActivityStreamsFlag() {
		child = this.GetActivityStreamsFlag().JSONLDContext()
	} else if this.IsActivityStreamsFollow() {
		child = this.GetActivityStreamsFollow().JSONLDContext()
	} else if this.IsActivityStreamsGroup() {
		child = this.GetActivityStreamsGroup().JSONLDContext()
	} else if this.IsTootHashtag() {
		child = this.GetTootHashtag().JSONLDContext()
	} else if this.IsTootIdentityProof() {
		child = this.GetTootIdentityProof().JSONLDContext()
	} else if this.IsActivityStreamsIgnore() {
		child = this.GetActivityStreamsIgnore().JSONLDContext()
	} else if this.IsActivityStreamsImage() {
		child = this.GetActivityStreamsImage().JSONLDContext()
	} else if this.IsActivityStreamsIntransitiveActivity() {
		child = this.GetActivityStreamsIntransitiveActivity().JSONLDContext()
	} else if this.IsActivityStreamsInvite() {
		child = this.GetActivityStreamsInvite().JSONLDContext()
	} else if this.IsActivityStreamsJoin() {
		child = this.GetActivityStreamsJoin().JSONLDContext()
	} else if this.IsActivityStreamsLeave() {
		child = this.GetActivityStreamsLeave().JSONLDContext()
	} else if this.IsFunkwhaleLibrary() {
		child = this.GetFunkwhaleLibrary().JSONLDContext()
	} else if this.IsActivityStreamsLike() {
		child = this.GetActivityStreamsLike().JSONLDContext()
	} else if this.IsGoToSocialLikeApproval() {
		child = this.GetGoToSocialLikeApproval().JSONLDContext()
	} else if this.IsGoToSocialLikeAuthorization() {
		child = this.GetGoToSocialLikeAuthorization().JSONLDContext()
	} else if this.IsGoToSocialLikeRequest() {
		child = this.GetGoToSocialLikeRequest().JSONLDContext()
	} else if this.IsActivityStreamsListen() {
		child = this.GetActivityStreamsListen().JSONLDContext()
	} else if this.IsActivityStreamsMention() {
		child = this.GetActivityStreamsMention().JSONLDContext()
	} else if this.IsActivityStreamsMove() {
		child = this.GetActivityStreamsMove().JSONLDContext()
	} else if this.IsActivityStreamsNote() {
		child = this.GetActivityStreamsNote().JSONLDContext()
	} else if this.IsActivityStreamsOffer() {
		child = this.GetActivityStreamsOffer().JSONLDContext()
	} else if this.IsActivityStreamsOrderedCollection() {
		child = this.GetActivityStreamsOrderedCollection().JSONLDContext()
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		child = this.GetActivityStreamsOrderedCollectionPage().JSONLDContext()
	} else if this.IsActivityStreamsOrganization() {
		child = this.GetActivityStreamsOrganization().JSONLDContext()
	} else if this.IsActivityStreamsPage() {
		child = this.GetActivityStreamsPage().JSONLDContext()
	} else if this.IsActivityStreamsPerson() {
		child = this.GetActivityStreamsPerson().JSONLDContext()
	} else if this.IsActivityStreamsPlace() {
		child = this.GetActivityStreamsPlace().JSONLDContext()
	} else if this.IsActivityStreamsProfile() {
		child = this.GetActivityStreamsProfile().JSONLDContext()
	} else if this.IsSchemaPropertyValue() {
		child = this.GetSchemaPropertyValue().JSONLDContext()
	} else if this.IsActivityStreamsQuestion() {
		child = this.GetActivityStreamsQuestion().JSONLDContext()
	} else if this.IsActivityStreamsRead() {
		child = this.GetActivityStreamsRead().JSONLDContext()
	} else if this.IsActivityStreamsReject() {
		child = this.GetActivityStreamsReject().JSONLDContext()
	} else if this.IsActivityStreamsRelationship() {
		child = this.GetActivityStreamsRelationship().JSONLDContext()
	} else if this.IsActivityStreamsRemove() {
		child = this.GetActivityStreamsRemove().JSONLDContext()
	} else if this.IsGoToSocialReplyApproval() {
		child = this.GetGoToSocialReplyApproval().JSONLDContext()
	} else if this.IsGoToSocialReplyAuthorization() {
		child = this.GetGoToSocialReplyAuthorization().JSONLDContext()
	} else if this.IsGoToSocialReplyRequest() {
		child = this.GetGoToSocialReplyRequest().JSONLDContext()
	} else if this.IsActivityStreamsService() {
		child = this.GetActivityStreamsService().JSONLDContext()
	} else if this.IsActivityStreamsTentativeAccept() {
		child = this.GetActivityStreamsTentativeAccept().JSONLDContext()
	} else if this.IsActivityStreamsTentativeReject() {
		child = this.GetActivityStreamsTentativeReject().JSONLDContext()
	} else if this.IsActivityStreamsTombstone() {
		child = this.GetActivityStreamsTombstone().JSONLDContext()
	} else if this.IsFunkwhaleTrack() {
		child = this.GetFunkwhaleTrack().JSONLDContext()
	} else if this.IsActivityStreamsTravel() {
		child = this.GetActivityStreamsTravel().JSONLDContext()
	} else if this.IsActivityStreamsUndo() {
		child = this.GetActivityStreamsUndo().JSONLDContext()
	} else if this.IsActivityStreamsUpdate() {
		child = this.GetActivityStreamsUpdate().JSONLDContext()
	} else if this.IsActivityStreamsVideo() {
		child = this.GetActivityStreamsVideo().JSONLDContext()
	} else if this.IsActivityStreamsView() {
		child = this.GetActivityStreamsView().JSONLDContext()
	}
	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ActivityStreamsAnyOfPropertyIterator) KindIndex() int {
	if this.IsActivityStreamsObject() {
		return 0
	}
	if this.IsActivityStreamsLink() {
		return 1
	}
	if this.IsActivityStreamsAccept() {
		return 2
	}
	if this.IsActivityStreamsActivity() {
		return 3
	}
	if this.IsActivityStreamsAdd() {
		return 4
	}
	if this.IsFunkwhaleAlbum() {
		return 5
	}
	if this.IsActivityStreamsAnnounce() {
		return 6
	}
	if this.IsGoToSocialAnnounceApproval() {
		return 7
	}
	if this.IsGoToSocialAnnounceAuthorization() {
		return 8
	}
	if this.IsGoToSocialAnnounceRequest() {
		return 9
	}
	if this.IsActivityStreamsApplication() {
		return 10
	}
	if this.IsActivityStreamsArrive() {
		return 11
	}
	if this.IsActivityStreamsArticle() {
		return 12
	}
	if this.IsFunkwhaleArtist() {
		return 13
	}
	if this.IsActivityStreamsAudio() {
		return 14
	}
	if this.IsActivityStreamsBlock() {
		return 15
	}
	if this.IsActivityStreamsCollection() {
		return 16
	}
	if this.IsActivityStreamsCollectionPage() {
		return 17
	}
	if this.IsActivityStreamsCreate() {
		return 18
	}
	if this.IsActivityStreamsDelete() {
		return 19
	}
	if this.IsActivityStreamsDislike() {
		return 20
	}
	if this.IsActivityStreamsDocument() {
		return 21
	}
	if this.IsTootEmoji() {
		return 22
	}
	if this.IsLitePubEmojiReact() {
		return 23
	}
	if this.IsActivityStreamsEvent() {
		return 24
	}
	if this.IsActivityStreamsFlag() {
		return 25
	}
	if this.IsActivityStreamsFollow() {
		return 26
	}
	if this.IsActivityStreamsGroup() {
		return 27
	}
	if this.IsTootHashtag() {
		return 28
	}
	if this.IsTootIdentityProof() {
		return 29
	}
	if this.IsActivityStreamsIgnore() {
		return 30
	}
	if this.IsActivityStreamsImage() {
		return 31
	}
	if this.IsActivityStreamsIntransitiveActivity() {
		return 32
	}
	if this.IsActivityStreamsInvite() {
		return 33
	}
	if this.IsActivityStreamsJoin() {
		return 34
	}
	if this.IsActivityStreamsLeave() {
		return 35
	}
	if this.IsFunkwhaleLibrary() {
		return 36
	}
	if this.IsActivityStreamsLike() {
		return 37
	}
	if this.IsGoToSocialLikeApproval() {
		return 38
	}
	if this.IsGoToSocialLikeAuthorization() {
		return 39
	}
	if this.IsGoToSocialLikeRequest() {
		return 40
	}
	if this.IsActivityStreamsListen() {
		return 41
	}
	if this.IsActivityStreamsMention() {
		return 42
	}
	if this.IsActivityStreamsMove() {
		return 43
	}
	if this.IsActivityStreamsNote() {
		return 44
	}
	if this.IsActivityStreamsOffer() {
		return 45
	}
	if this.IsActivityStreamsOrderedCollection() {
		return 46
	}
	if this.IsActivityStreamsOrderedCollectionPage() {
		return 47
	}
	if this.IsActivityStreamsOrganization() {
		return 48
	}
	if this.IsActivityStreamsPage() {
		return 49
	}
	if this.IsActivityStreamsPerson() {
		return 50
	}
	if this.IsActivityStreamsPlace() {
		return 51
	}
	if this.IsActivityStreamsProfile() {
		return 52
	}
	if this.IsSchemaPropertyValue() {
		return 53
	}
	if this.IsActivityStreamsQuestion() {
		return 54
	}
	if this.IsActivityStreamsRead() {
		return 55
	}
	if this.IsActivityStreamsReject() {
		return 56
	}
	if this.IsActivityStreamsRelationship() {
		return 57
	}
	if this.IsActivityStreamsRemove() {
		return 58
	}
	if this.IsGoToSocialReplyApproval() {
		return 59
	}
	if this.IsGoToSocialReplyAuthorization() {
		return 60
	}
	if this.IsGoToSocialReplyRequest() {
		return 61
	}
	if this.IsActivityStreamsService() {
		return 62
	}
	if this.IsActivityStreamsTentativeAccept() {
		return 63
	}
	if this.IsActivityStreamsTentativeReject() {
		return 64
	}
	if this.IsActivityStreamsTombstone() {
		return 65
	}
	if this.IsFunkwhaleTrack() {
		return 66
	}
	if this.IsActivityStreamsTravel() {
		return 67
	}
	if this.IsActivityStreamsUndo() {
		return 68
	}
	if this.IsActivityStreamsUpdate() {
		return 69
	}
	if this.IsActivityStreamsVideo() {
		return 70
	}
	if this.IsActivityStreamsView() {
		return 71
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsAnyOfPropertyIterator) LessThan(o vocab.ActivityStreamsAnyOfPropertyIterator) bool {
	idx1 := this.KindIndex()
	idx2 := o.KindIndex()
	if idx1 < idx2 {
		return true
	} else if idx1 > idx2 {
		return false
	} else if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject().LessThan(o.GetActivityStreamsObject())
	} else if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink().LessThan(o.GetActivityStreamsLink())
	} else if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept().LessThan(o.GetActivityStreamsAccept())
	} else if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity().LessThan(o.GetActivityStreamsActivity())
	} else if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd().LessThan(o.GetActivityStreamsAdd())
	} else if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum().LessThan(o.GetFunkwhaleAlbum())
	} else if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce().LessThan(o.GetActivityStreamsAnnounce())
	} else if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval().LessThan(o.GetGoToSocialAnnounceApproval())
	} else if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization().LessThan(o.GetGoToSocialAnnounceAuthorization())
	} else if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest().LessThan(o.GetGoToSocialAnnounceRequest())
	} else if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication().LessThan(o.GetActivityStreamsApplication())
	} else if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive().LessThan(o.GetActivityStreamsArrive())
	} else if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle().LessThan(o.GetActivityStreamsArticle())
	} else if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist().LessThan(o.GetFunkwhaleArtist())
	} else if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio().LessThan(o.GetActivityStreamsAudio())
	} else if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock().LessThan(o.GetActivityStreamsBlock())
	} else if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection().LessThan(o.GetActivityStreamsCollection())
	} else if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage().LessThan(o.GetActivityStreamsCollectionPage())
	} else if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate().LessThan(o.GetActivityStreamsCreate())
	} else if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete().LessThan(o.GetActivityStreamsDelete())
	} else if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike().LessThan(o.GetActivityStreamsDislike())
	} else if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument().LessThan(o.GetActivityStreamsDocument())
	} else if this.IsTootEmoji() {
		return this.GetTootEmoji().LessThan(o.GetTootEmoji())
	} else if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact().LessThan(o.GetLitePubEmojiReact())
	} else if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent().LessThan(o.GetActivityStreamsEvent())
	} else if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag().LessThan(o.GetActivityStreamsFlag())
	} else if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow().LessThan(o.GetActivityStreamsFollow())
	} else if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup().LessThan(o.GetActivityStreamsGroup())
	} else if this.IsTootHashtag() {
		return this.GetTootHashtag().LessThan(o.GetTootHashtag())
	} else if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof().LessThan(o.GetTootIdentityProof())
	} else if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore().LessThan(o.GetActivityStreamsIgnore())
	} else if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage().LessThan(o.GetActivityStreamsImage())
	} else if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity().LessThan(o.GetActivityStreamsIntransitiveActivity())
	} else if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite().LessThan(o.GetActivityStreamsInvite())
	} else if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin().LessThan(o.GetActivityStreamsJoin())
	} else if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave().LessThan(o.GetActivityStreamsLeave())
	} else if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary().LessThan(o.GetFunkwhaleLibrary())
	} else if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike().LessThan(o.GetActivityStreamsLike())
	} else if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval().LessThan(o.GetGoToSocialLikeApproval())
	} else if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization().LessThan(o.GetGoToSocialLikeAuthorization())
	} else if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest().LessThan(o.GetGoToSocialLikeRequest())
	} else if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen().LessThan(o.GetActivityStreamsListen())
	} else if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention().LessThan(o.GetActivityStreamsMention())
	} else if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove().LessThan(o.GetActivityStreamsMove())
	} else if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote().LessThan(o.GetActivityStreamsNote())
	} else if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer().LessThan(o.GetActivityStreamsOffer())
	} else if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection().LessThan(o.GetActivityStreamsOrderedCollection())
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage().LessThan(o.GetActivityStreamsOrderedCollectionPage())
	} else if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization().LessThan(o.GetActivityStreamsOrganization())
	} else if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage().LessThan(o.GetActivityStreamsPage())
	} else if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson().LessThan(o.GetActivityStreamsPerson())
	} else if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace().LessThan(o.GetActivityStreamsPlace())
	} else if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile().LessThan(o.GetActivityStreamsProfile())
	} else if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue().LessThan(o.GetSchemaPropertyValue())
	} else if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion().LessThan(o.GetActivityStreamsQuestion())
	} else if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead().LessThan(o.GetActivityStreamsRead())
	} else if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject().LessThan(o.GetActivityStreamsReject())
	} else if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship().LessThan(o.GetActivityStreamsRelationship())
	} else if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove().LessThan(o.GetActivityStreamsRemove())
	} else if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval().LessThan(o.GetGoToSocialReplyApproval())
	} else if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization().LessThan(o.GetGoToSocialReplyAuthorization())
	} else if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest().LessThan(o.GetGoToSocialReplyRequest())
	} else if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService().LessThan(o.GetActivityStreamsService())
	} else if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept().LessThan(o.GetActivityStreamsTentativeAccept())
	} else if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject().LessThan(o.GetActivityStreamsTentativeReject())
	} else if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone().LessThan(o.GetActivityStreamsTombstone())
	} else if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack().LessThan(o.GetFunkwhaleTrack())
	} else if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel().LessThan(o.GetActivityStreamsTravel())
	} else if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo().LessThan(o.GetActivityStreamsUndo())
	} else if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate().LessThan(o.GetActivityStreamsUpdate())
	} else if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo().LessThan(o.GetActivityStreamsVideo())
	} else if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView().LessThan(o.GetActivityStreamsView())
	} else if this.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	}
	return false
}

// Name returns the name of this property: "ActivityStreamsAnyOf".
func (this ActivityStreamsAnyOfPropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "ActivityStreamsAnyOf"
	} else {
		return "ActivityStreamsAnyOf"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this ActivityStreamsAnyOfPropertyIterator) Next() vocab.ActivityStreamsAnyOfPropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this ActivityStreamsAnyOfPropertyIterator) Prev() vocab.ActivityStreamsAnyOfPropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// SetActivityStreamsAccept sets the value of this property. Calling
// IsActivityStreamsAccept afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.clear()
	this.activitystreamsAcceptMember = v
}

// SetActivityStreamsActivity sets the value of this property. Calling
// IsActivityStreamsActivity afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.clear()
	this.activitystreamsActivityMember = v
}

// SetActivityStreamsAdd sets the value of this property. Calling
// IsActivityStreamsAdd afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.clear()
	this.activitystreamsAddMember = v
}

// SetActivityStreamsAnnounce sets the value of this property. Calling
// IsActivityStreamsAnnounce afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.clear()
	this.activitystreamsAnnounceMember = v
}

// SetActivityStreamsApplication sets the value of this property. Calling
// IsActivityStreamsApplication afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.clear()
	this.activitystreamsApplicationMember = v
}

// SetActivityStreamsArrive sets the value of this property. Calling
// IsActivityStreamsArrive afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.clear()
	this.activitystreamsArriveMember = v
}

// SetActivityStreamsArticle sets the value of this property. Calling
// IsActivityStreamsArticle afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.clear()
	this.activitystreamsArticleMember = v
}

// SetActivityStreamsAudio sets the value of this property. Calling
// IsActivityStreamsAudio afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.clear()
	this.activitystreamsAudioMember = v
}

// SetActivityStreamsBlock sets the value of this property. Calling
// IsActivityStreamsBlock afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.clear()
	this.activitystreamsBlockMember = v
}

// SetActivityStreamsCollection sets the value of this property. Calling
// IsActivityStreamsCollection afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.clear()
	this.activitystreamsCollectionMember = v
}

// SetActivityStreamsCollectionPage sets the value of this property. Calling
// IsActivityStreamsCollectionPage afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.clear()
	this.activitystreamsCollectionPageMember = v
}

// SetActivityStreamsCreate sets the value of this property. Calling
// IsActivityStreamsCreate afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.clear()
	this.activitystreamsCreateMember = v
}

// SetActivityStreamsDelete sets the value of this property. Calling
// IsActivityStreamsDelete afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.clear()
	this.activitystreamsDeleteMember = v
}

// SetActivityStreamsDislike sets the value of this property. Calling
// IsActivityStreamsDislike afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.clear()
	this.activitystreamsDislikeMember = v
}

// SetActivityStreamsDocument sets the value of this property. Calling
// IsActivityStreamsDocument afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.clear()
	this.activitystreamsDocumentMember = v
}

// SetActivityStreamsEvent sets the value of this property. Calling
// IsActivityStreamsEvent afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.clear()
	this.activitystreamsEventMember = v
}

// SetActivityStreamsFlag sets the value of this property. Calling
// IsActivityStreamsFlag afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.clear()
	this.activitystreamsFlagMember = v
}

// SetActivityStreamsFollow sets the value of this property. Calling
// IsActivityStreamsFollow afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.clear()
	this.activitystreamsFollowMember = v
}

// SetActivityStreamsGroup sets the value of this property. Calling
// IsActivityStreamsGroup afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.clear()
	this.activitystreamsGroupMember = v
}

// SetActivityStreamsIgnore sets the value of this property. Calling
// IsActivityStreamsIgnore afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.clear()
	this.activitystreamsIgnoreMember = v
}

// SetActivityStreamsImage sets the value of this property. Calling
// IsActivityStreamsImage afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.clear()
	this.activitystreamsImageMember = v
}

// SetActivityStreamsIntransitiveActivity sets the value of this property. Calling
// IsActivityStreamsIntransitiveActivity afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.clear()
	this.activitystreamsIntransitiveActivityMember = v
}

// SetActivityStreamsInvite sets the value of this property. Calling
// IsActivityStreamsInvite afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.clear()
	this.activitystreamsInviteMember = v
}

// SetActivityStreamsJoin sets the value of this property. Calling
// IsActivityStreamsJoin afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.clear()
	this.activitystreamsJoinMember = v
}

// SetActivityStreamsLeave sets the value of this property. Calling
// IsActivityStreamsLeave afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.clear()
	this.activitystreamsLeaveMember = v
}

// SetActivityStreamsLike sets the value of this property. Calling
// IsActivityStreamsLike afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.clear()
	this.activitystreamsLikeMember = v
}

// SetActivityStreamsLink sets the value of this property. Calling
// IsActivityStreamsLink afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.clear()
	this.activitystreamsLinkMember = v
}

// SetActivityStreamsListen sets the value of this property. Calling
// IsActivityStreamsListen afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.clear()
	this.activitystreamsListenMember = v
}

// SetActivityStreamsMention sets the value of this property. Calling
// IsActivityStreamsMention afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.clear()
	this.activitystreamsMentionMember = v
}

// SetActivityStreamsMove sets the value of this property. Calling
// IsActivityStreamsMove afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.clear()
	this.activitystreamsMoveMember = v
}

// SetActivityStreamsNote sets the value of this property. Calling
// IsActivityStreamsNote afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.clear()
	this.activitystreamsNoteMember = v
}

// SetActivityStreamsObject sets the value of this property. Calling
// IsActivityStreamsObject afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.clear()
	this.activitystreamsObjectMember = v
}

// SetActivityStreamsOffer sets the value of this property. Calling
// IsActivityStreamsOffer afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.clear()
	this.activitystreamsOfferMember = v
}

// SetActivityStreamsOrderedCollection sets the value of this property. Calling
// IsActivityStreamsOrderedCollection afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.clear()
	this.activitystreamsOrderedCollectionMember = v
}

// SetActivityStreamsOrderedCollectionPage sets the value of this property.
// Calling IsActivityStreamsOrderedCollectionPage afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.clear()
	this.activitystreamsOrderedCollectionPageMember = v
}

// SetActivityStreamsOrganization sets the value of this property. Calling
// IsActivityStreamsOrganization afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.clear()
	this.activitystreamsOrganizationMember = v
}

// SetActivityStreamsPage sets the value of this property. Calling
// IsActivityStreamsPage afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.clear()
	this.activitystreamsPageMember = v
}

// SetActivityStreamsPerson sets the value of this property. Calling
// IsActivityStreamsPerson afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.clear()
	this.activitystreamsPersonMember = v
}

// SetActivityStreamsPlace sets the value of this property. Calling
// IsActivityStreamsPlace afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.clear()
	this.activitystreamsPlaceMember = v
}

// SetActivityStreamsProfile sets the value of this property. Calling
// IsActivityStreamsProfile afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.clear()
	this.activitystreamsProfileMember = v
}

// SetActivityStreamsQuestion sets the value of this property. Calling
// IsActivityStreamsQuestion afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.clear()
	this.activitystreamsQuestionMember = v
}

// SetActivityStreamsRead sets the value of this property. Calling
// IsActivityStreamsRead afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.clear()
	this.activitystreamsReadMember = v
}

// SetActivityStreamsReject sets the value of this property. Calling
// IsActivityStreamsReject afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.clear()
	this.activitystreamsRejectMember = v
}

// SetActivityStreamsRelationship sets the value of this property. Calling
// IsActivityStreamsRelationship afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.clear()
	this.activitystreamsRelationshipMember = v
}

// SetActivityStreamsRemove sets the value of this property. Calling
// IsActivityStreamsRemove afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.clear()
	this.activitystreamsRemoveMember = v
}

// SetActivityStreamsService sets the value of this property. Calling
// IsActivityStreamsService afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsService(v vocab.ActivityStreamsService) {
	this.clear()
	this.activitystreamsServiceMember = v
}

// SetActivityStreamsTentativeAccept sets the value of this property. Calling
// IsActivityStreamsTentativeAccept afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.clear()
	this.activitystreamsTentativeAcceptMember = v
}

// SetActivityStreamsTentativeReject sets the value of this property. Calling
// IsActivityStreamsTentativeReject afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.clear()
	this.activitystreamsTentativeRejectMember = v
}

// SetActivityStreamsTombstone sets the value of this property. Calling
// IsActivityStreamsTombstone afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.clear()
	this.activitystreamsTombstoneMember = v
}

// SetActivityStreamsTravel sets the value of this property. Calling
// IsActivityStreamsTravel afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.clear()
	this.activitystreamsTravelMember = v
}

// SetActivityStreamsUndo sets the value of this property. Calling
// IsActivityStreamsUndo afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.clear()
	this.activitystreamsUndoMember = v
}

// SetActivityStreamsUpdate sets the value of this property. Calling
// IsActivityStreamsUpdate afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.clear()
	this.activitystreamsUpdateMember = v
}

// SetActivityStreamsVideo sets the value of this property. Calling
// IsActivityStreamsVideo afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.clear()
	this.activitystreamsVideoMember = v
}

// SetActivityStreamsView sets the value of this property. Calling
// IsActivityStreamsView afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetActivityStreamsView(v vocab.ActivityStreamsView) {
	this.clear()
	this.activitystreamsViewMember = v
}

// SetFunkwhaleAlbum sets the value of this property. Calling IsFunkwhaleAlbum
// afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.clear()
	this.funkwhaleAlbumMember = v
}

// SetFunkwhaleArtist sets the value of this property. Calling IsFunkwhaleArtist
// afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.clear()
	this.funkwhaleArtistMember = v
}

// SetFunkwhaleLibrary sets the value of this property. Calling IsFunkwhaleLibrary
// afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.clear()
	this.funkwhaleLibraryMember = v
}

// SetFunkwhaleTrack sets the value of this property. Calling IsFunkwhaleTrack
// afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.clear()
	this.funkwhaleTrackMember = v
}

// SetGoToSocialAnnounceApproval sets the value of this property. Calling
// IsGoToSocialAnnounceApproval afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.clear()
	this.gotosocialAnnounceApprovalMember = v
}

// SetGoToSocialAnnounceAuthorization sets the value of this property. Calling
// IsGoToSocialAnnounceAuthorization afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.clear()
	this.gotosocialAnnounceAuthorizationMember = v
}

// SetGoToSocialAnnounceRequest sets the value of this property. Calling
// IsGoToSocialAnnounceRequest afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.clear()
	this.gotosocialAnnounceRequestMember = v
}

// SetGoToSocialLikeApproval sets the value of this property. Calling
// IsGoToSocialLikeApproval afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.clear()
	this.gotosocialLikeApprovalMember = v
}

// SetGoToSocialLikeAuthorization sets the value of this property. Calling
// IsGoToSocialLikeAuthorization afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.clear()
	this.gotosocialLikeAuthorizationMember = v
}

// SetGoToSocialLikeRequest sets the value of this property. Calling
// IsGoToSocialLikeRequest afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.clear()
	this.gotosocialLikeRequestMember = v
}

// SetGoToSocialReplyApproval sets the value of this property. Calling
// IsGoToSocialReplyApproval afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.clear()
	this.gotosocialReplyApprovalMember = v
}

// SetGoToSocialReplyAuthorization sets the value of this property. Calling
// IsGoToSocialReplyAuthorization afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.clear()
	this.gotosocialReplyAuthorizationMember = v
}

// SetGoToSocialReplyRequest sets the value of this property. Calling
// IsGoToSocialReplyRequest afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.clear()
	this.gotosocialReplyRequestMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// SetLitePubEmojiReact sets the value of this property. Calling
// IsLitePubEmojiReact afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.clear()
	this.litepubEmojiReactMember = v
}

// SetSchemaPropertyValue sets the value of this property. Calling
// IsSchemaPropertyValue afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.clear()
	this.schemaPropertyValueMember = v
}

// SetTootEmoji sets the value of this property. Calling IsTootEmoji afterwards
// returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetTootEmoji(v vocab.TootEmoji) {
	this.clear()
	this.tootEmojiMember = v
}

// SetTootHashtag sets the value of this property. Calling IsTootHashtag
// afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetTootHashtag(v vocab.TootHashtag) {
	this.clear()
	this.tootHashtagMember = v
}

// SetTootIdentityProof sets the value of this property. Calling
// IsTootIdentityProof afterwards returns true.
func (this *ActivityStreamsAnyOfPropertyIterator) SetTootIdentityProof(v vocab.TootIdentityProof) {
	this.clear()
	this.tootIdentityProofMember = v
}

// SetType attempts to set the property for the arbitrary type. Returns an error
// if it is not a valid type to set on this property.
func (this *ActivityStreamsAnyOfPropertyIterator) SetType(t vocab.Type) error {
	if v, ok := t.(vocab.ActivityStreamsObject); ok {
		this.SetActivityStreamsObject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLink); ok {
		this.SetActivityStreamsLink(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAccept); ok {
		this.SetActivityStreamsAccept(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsActivity); ok {
		this.SetActivityStreamsActivity(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAdd); ok {
		this.SetActivityStreamsAdd(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleAlbum); ok {
		this.SetFunkwhaleAlbum(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAnnounce); ok {
		this.SetActivityStreamsAnnounce(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceApproval); ok {
		this.SetGoToSocialAnnounceApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceAuthorization); ok {
		this.SetGoToSocialAnnounceAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceRequest); ok {
		this.SetGoToSocialAnnounceRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsApplication); ok {
		this.SetActivityStreamsApplication(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsArrive); ok {
		this.SetActivityStreamsArrive(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsArticle); ok {
		this.SetActivityStreamsArticle(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleArtist); ok {
		this.SetFunkwhaleArtist(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAudio); ok {
		this.SetActivityStreamsAudio(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsBlock); ok {
		this.SetActivityStreamsBlock(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCollection); ok {
		this.SetActivityStreamsCollection(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCollectionPage); ok {
		this.SetActivityStreamsCollectionPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCreate); ok {
		this.SetActivityStreamsCreate(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDelete); ok {
		this.SetActivityStreamsDelete(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDislike); ok {
		this.SetActivityStreamsDislike(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDocument); ok {
		this.SetActivityStreamsDocument(v)
		return nil
	}
	if v, ok := t.(vocab.TootEmoji); ok {
		this.SetTootEmoji(v)
		return nil
	}
	if v, ok := t.(vocab.LitePubEmojiReact); ok {
		this.SetLitePubEmojiReact(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsEvent); ok {
		this.SetActivityStreamsEvent(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsFlag); ok {
		this.SetActivityStreamsFlag(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsFollow); ok {
		this.SetActivityStreamsFollow(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsGroup); ok {
		this.SetActivityStreamsGroup(v)
		return nil
	}
	if v, ok := t.(vocab.TootHashtag); ok {
		this.SetTootHashtag(v)
		return nil
	}
	if v, ok := t.(vocab.TootIdentityProof); ok {
		this.SetTootIdentityProof(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsIgnore); ok {
		this.SetActivityStreamsIgnore(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsImage); ok {
		this.SetActivityStreamsImage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsIntransitiveActivity); ok {
		this.SetActivityStreamsIntransitiveActivity(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsInvite); ok {
		this.SetActivityStreamsInvite(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsJoin); ok {
		this.SetActivityStreamsJoin(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLeave); ok {
		this.SetActivityStreamsLeave(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleLibrary); ok {
		this.SetFunkwhaleLibrary(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLike); ok {
		this.SetActivityStreamsLike(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeApproval); ok {
		this.SetGoToSocialLikeApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeAuthorization); ok {
		this.SetGoToSocialLikeAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeRequest); ok {
		this.SetGoToSocialLikeRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsListen); ok {
		this.SetActivityStreamsListen(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsMention); ok {
		this.SetActivityStreamsMention(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsMove); ok {
		this.SetActivityStreamsMove(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsNote); ok {
		this.SetActivityStreamsNote(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOffer); ok {
		this.SetActivityStreamsOffer(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrderedCollection); ok {
		this.SetActivityStreamsOrderedCollection(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrderedCollectionPage); ok {
		this.SetActivityStreamsOrderedCollectionPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrganization); ok {
		this.SetActivityStreamsOrganization(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPage); ok {
		this.SetActivityStreamsPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPerson); ok {
		this.SetActivityStreamsPerson(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPlace); ok {
		this.SetActivityStreamsPlace(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsProfile); ok {
		this.SetActivityStreamsProfile(v)
		return nil
	}
	if v, ok := t.(vocab.SchemaPropertyValue); ok {
		this.SetSchemaPropertyValue(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsQuestion); ok {
		this.SetActivityStreamsQuestion(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRead); ok {
		this.SetActivityStreamsRead(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsReject); ok {
		this.SetActivityStreamsReject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRelationship); ok {
		this.SetActivityStreamsRelationship(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRemove); ok {
		this.SetActivityStreamsRemove(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyApproval); ok {
		this.SetGoToSocialReplyApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyAuthorization); ok {
		this.SetGoToSocialReplyAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyRequest); ok {
		this.SetGoToSocialReplyRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsService); ok {
		this.SetActivityStreamsService(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTentativeAccept); ok {
		this.SetActivityStreamsTentativeAccept(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTentativeReject); ok {
		this.SetActivityStreamsTentativeReject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTombstone); ok {
		this.SetActivityStreamsTombstone(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleTrack); ok {
		this.SetFunkwhaleTrack(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTravel); ok {
		this.SetActivityStreamsTravel(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsUndo); ok {
		this.SetActivityStreamsUndo(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsUpdate); ok {
		this.SetActivityStreamsUpdate(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsVideo); ok {
		this.SetActivityStreamsVideo(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsView); ok {
		this.SetActivityStreamsView(v)
		return nil
	}

	return fmt.Errorf("illegal type to set on ActivityStreamsAnyOf property: %T", t)
}

// clear ensures no value of this property is set. Calling HasAny or any of the
// 'Is' methods afterwards will return false.
func (this *ActivityStreamsAnyOfPropertyIterator) clear() {
	this.activitystreamsObjectMember = nil
	this.activitystreamsLinkMember = nil
	this.activitystreamsAcceptMember = nil
	this.activitystreamsActivityMember = nil
	this.activitystreamsAddMember = nil
	this.funkwhaleAlbumMember = nil
	this.activitystreamsAnnounceMember = nil
	this.gotosocialAnnounceApprovalMember = nil
	this.gotosocialAnnounceAuthorizationMember = nil
	this.gotosocialAnnounceRequestMember = nil
	this.activitystreamsApplicationMember = nil
	this.activitystreamsArriveMember = nil
	this.activitystreamsArticleMember = nil
	this.funkwhaleArtistMember = nil
	this.activitystreamsAudioMember = nil
	this.activitystreamsBlockMember = nil
	this.activitystreamsCollectionMember = nil
	this.activitystreamsCollectionPageMember = nil
	this.activitystreamsCreateMember = nil
	this.activitystreamsDeleteMember = nil
	this.activitystreamsDislikeMember = nil
	this.activitystreamsDocumentMember = nil
	this.tootEmojiMember = nil
	this.litepubEmojiReactMember = nil
	this.activitystreamsEventMember = nil
	this.activitystreamsFlagMember = nil
	this.activitystreamsFollowMember = nil
	this.activitystreamsGroupMember = nil
	this.tootHashtagMember = nil
	this.tootIdentityProofMember = nil
	this.activitystreamsIgnoreMember = nil
	this.activitystreamsImageMember = nil
	this.activitystreamsIntransitiveActivityMember = nil
	this.activitystreamsInviteMember = nil
	this.activitystreamsJoinMember = nil
	this.activitystreamsLeaveMember = nil
	this.funkwhaleLibraryMember = nil
	this.activitystreamsLikeMember = nil
	this.gotosocialLikeApprovalMember = nil
	this.gotosocialLikeAuthorizationMember = nil
	this.gotosocialLikeRequestMember = nil
	this.activitystreamsListenMember = nil
	this.activitystreamsMentionMember = nil
	this.activitystreamsMoveMember = nil
	this.activitystreamsNoteMember = nil
	this.activitystreamsOfferMember = nil
	this.activitystreamsOrderedCollectionMember = nil
	this.activitystreamsOrderedCollectionPageMember = nil
	this.activitystreamsOrganizationMember = nil
	this.activitystreamsPageMember = nil
	this.activitystreamsPersonMember = nil
	this.activitystreamsPlaceMember = nil
	this.activitystreamsProfileMember = nil
	this.schemaPropertyValueMember = nil
	this.activitystreamsQuestionMember = nil
	this.activitystreamsReadMember = nil
	this.activitystreamsRejectMember = nil
	this.activitystreamsRelationshipMember = nil
	this.activitystreamsRemoveMember = nil
	this.gotosocialReplyApprovalMember = nil
	this.gotosocialReplyAuthorizationMember = nil
	this.gotosocialReplyRequestMember = nil
	this.activitystreamsServiceMember = nil
	this.activitystreamsTentativeAcceptMember = nil
	this.activitystreamsTentativeRejectMember = nil
	this.activitystreamsTombstoneMember = nil
	this.funkwhaleTrackMember = nil
	this.activitystreamsTravelMember = nil
	this.activitystreamsUndoMember = nil
	this.activitystreamsUpdateMember = nil
	this.activitystreamsVideoMember = nil
	this.activitystreamsViewMember = nil
	this.unknown = nil
	this.iri = nil
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsAnyOfPropertyIterator) serialize() (interface{}, error) {
	if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject().Serialize()
	} else if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink().Serialize()
	} else if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept().Serialize()
	} else if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity().Serialize()
	} else if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd().Serialize()
	} else if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum().Serialize()
	} else if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce().Serialize()
	} else if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval().Serialize()
	} else if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization().Serialize()
	} else if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest().Serialize()
	} else if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication().Serialize()
	} else if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive().Serialize()
	} else if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle().Serialize()
	} else if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist().Serialize()
	} else if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio().Serialize()
	} else if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock().Serialize()
	} else if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection().Serialize()
	} else if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage().Serialize()
	} else if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate().Serialize()
	} else if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete().Serialize()
	} else if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike().Serialize()
	} else if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument().Serialize()
	} else if this.IsTootEmoji() {
		return this.GetTootEmoji().Serialize()
	} else if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact().Serialize()
	} else if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent().Serialize()
	} else if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag().Serialize()
	} else if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow().Serialize()
	} else if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup().Serialize()
	} else if this.IsTootHashtag() {
		return this.GetTootHashtag().Serialize()
	} else if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof().Serialize()
	} else if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore().Serialize()
	} else if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage().Serialize()
	} else if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity().Serialize()
	} else if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite().Serialize()
	} else if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin().Serialize()
	} else if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave().Serialize()
	} else if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary().Serialize()
	} else if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike().Serialize()
	} else if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval().Serialize()
	} else if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization().Serialize()
	} else if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest().Serialize()
	} else if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen().Serialize()
	} else if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention().Serialize()
	} else if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove().Serialize()
	} else if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote().Serialize()
	} else if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer().Serialize()
	} else if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection().Serialize()
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage().Serialize()
	} else if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization().Serialize()
	} else if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage().Serialize()
	} else if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson().Serialize()
	} else if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace().Serialize()
	} else if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile().Serialize()
	} else if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue().Serialize()
	} else if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion().Serialize()
	} else if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead().Serialize()
	} else if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject().Serialize()
	} else if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship().Serialize()
	} else if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove().Serialize()
	} else if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval().Serialize()
	} else if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization().Serialize()
	} else if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest().Serialize()
	} else if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService().Serialize()
	} else if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept().Serialize()
	} else if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject().Serialize()
	} else if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone().Serialize()
	} else if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack().Serialize()
	} else if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel().Serialize()
	} else if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo().Serialize()
	} else if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate().Serialize()
	} else if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo().Serialize()
	} else if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView().Serialize()
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// ActivityStreamsAnyOfProperty is the non-functional property "anyOf". It is
// permitted to have one or more values, and of different value types.
type ActivityStreamsAnyOfProperty struct {
	properties []*ActivityStreamsAnyOfPropertyIterator
	alias      string
}

// DeserializeAnyOfProperty creates a "anyOf" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeAnyOfProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.ActivityStreamsAnyOfProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	propName := "anyOf"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "anyOf")
	}
	i, ok := m[propName]

	if ok {
		this := &ActivityStreamsAnyOfProperty{
			alias:      alias,
			properties: []*ActivityStreamsAnyOfPropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeActivityStreamsAnyOfPropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeActivityStreamsAnyOfPropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewActivityStreamsAnyOfProperty creates a new anyOf property.
func NewActivityStreamsAnyOfProperty() *ActivityStreamsAnyOfProperty {
	return &ActivityStreamsAnyOfProperty{alias: ""}
}

// AppendActivityStreamsAccept appends a Accept value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsActivity appends a Activity value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsAdd appends a Add value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    this.Len(),
		parent:                   this,
	})
}

// AppendActivityStreamsAnnounce appends a Announce value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsApplication appends a Application value to the back of a
// list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            this.Len(),
		parent:                           this,
	})
}

// AppendActivityStreamsArrive appends a Arrive value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsArticle appends a Article value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsAudio appends a Audio value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsBlock appends a Block value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsCollection appends a Collection value to the back of a
// list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           this.Len(),
		parent:                          this,
	})
}

// AppendActivityStreamsCollectionPage appends a CollectionPage value to the back
// of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               this.Len(),
		parent:                              this,
	})
}

// AppendActivityStreamsCreate appends a Create value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsDelete appends a Delete value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsDislike appends a Dislike value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsDocument appends a Document value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsEvent appends a Event value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsFlag appends a Flag value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsFollow appends a Follow value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsGroup appends a Group value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsIgnore appends a Ignore value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsImage appends a Image value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsIntransitiveActivity appends a IntransitiveActivity value
// to the back of a list of the property "anyOf". Invalidates iterators that
// are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendActivityStreamsInvite appends a Invite value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsJoin appends a Join value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsLeave appends a Leave value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsLike appends a Like value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsLink appends a Link value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsListen appends a Listen value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsMention appends a Mention value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsMove appends a Move value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsNote appends a Note value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsObject appends a Object value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsOffer appends a Offer value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsOrderedCollection appends a OrderedCollection value to the
// back of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  this.Len(),
		parent:                                 this,
	})
}

// AppendActivityStreamsOrderedCollectionPage appends a OrderedCollectionPage
// value to the back of a list of the property "anyOf". Invalidates iterators
// that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendActivityStreamsOrganization appends a Organization value to the back of a
// list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendActivityStreamsPage appends a Page value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsPerson appends a Person value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsPlace appends a Place value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsProfile appends a Profile value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsQuestion appends a Question value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsRead appends a Read value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsReject appends a Reject value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsRelationship appends a Relationship value to the back of a
// list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendActivityStreamsRemove appends a Remove value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsService appends a Service value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsService(v vocab.ActivityStreamsService) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsTentativeAccept appends a TentativeAccept value to the
// back of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                this.Len(),
		parent:                               this,
	})
}

// AppendActivityStreamsTentativeReject appends a TentativeReject value to the
// back of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                this.Len(),
		parent:                               this,
	})
}

// AppendActivityStreamsTombstone appends a Tombstone value to the back of a list
// of the property "anyOf". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          this.Len(),
		parent:                         this,
	})
}

// AppendActivityStreamsTravel appends a Travel value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsUndo appends a Undo value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsUpdate appends a Update value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsVideo appends a Video value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsView appends a View value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendActivityStreamsView(v vocab.ActivityStreamsView) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendFunkwhaleAlbum appends a Album value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendFunkwhaleArtist appends a Artist value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 this.Len(),
		parent:                this,
	})
}

// AppendFunkwhaleLibrary appends a Library value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  this.Len(),
		parent:                 this,
	})
}

// AppendFunkwhaleTrack appends a Track value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendGoToSocialAnnounceApproval appends a AnnounceApproval value to the back
// of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            this.Len(),
		parent:                           this,
	})
}

// AppendGoToSocialAnnounceAuthorization appends a AnnounceAuthorization value to
// the back of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 this.Len(),
		parent:                                this,
	})
}

// AppendGoToSocialAnnounceRequest appends a AnnounceRequest value to the back of
// a list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           this.Len(),
		parent:                          this,
	})
}

// AppendGoToSocialLikeApproval appends a LikeApproval value to the back of a list
// of the property "anyOf". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendGoToSocialLikeAuthorization appends a LikeAuthorization value to the back
// of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendGoToSocialLikeRequest appends a LikeRequest value to the back of a list
// of the property "anyOf". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendGoToSocialReplyApproval appends a ReplyApproval value to the back of a
// list of the property "anyOf". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendGoToSocialReplyAuthorization appends a ReplyAuthorization value to the
// back of a list of the property "anyOf". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              this.Len(),
		parent:                             this,
	})
}

// AppendGoToSocialReplyRequest appends a ReplyRequest value to the back of a list
// of the property "anyOf". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAnyOfProperty) AppendGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendIRI appends an IRI value to the back of a list of the property "anyOf"
func (this *ActivityStreamsAnyOfProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendLitePubEmojiReact appends a EmojiReact value to the back of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   this.Len(),
		parent:                  this,
	})
}

// AppendSchemaPropertyValue appends a PropertyValue value to the back of a list
// of the property "anyOf". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAnyOfProperty) AppendSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
		schemaPropertyValueMember: v,
	})
}

// AppendTootEmoji appends a Emoji value to the back of a list of the property
// "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendTootEmoji(v vocab.TootEmoji) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:           this.alias,
		myIdx:           this.Len(),
		parent:          this,
		tootEmojiMember: v,
	})
}

// AppendTootHashtag appends a Hashtag value to the back of a list of the property
// "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendTootHashtag(v vocab.TootHashtag) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:             this.alias,
		myIdx:             this.Len(),
		parent:            this,
		tootHashtagMember: v,
	})
}

// AppendTootIdentityProof appends a IdentityProof value to the back of a list of
// the property "anyOf". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAnyOfProperty) AppendTootIdentityProof(v vocab.TootIdentityProof) {
	this.properties = append(this.properties, &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		myIdx:                   this.Len(),
		parent:                  this,
		tootIdentityProofMember: v,
	})
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "anyOf". Invalidates iterators that are traversing using Prev.
// Returns an error if the type is not a valid one to set for this property.
func (this *ActivityStreamsAnyOfProperty) AppendType(t vocab.Type) error {
	n := &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, n)
	return nil
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this ActivityStreamsAnyOfProperty) At(index int) vocab.ActivityStreamsAnyOfPropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this ActivityStreamsAnyOfProperty) Begin() vocab.ActivityStreamsAnyOfPropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this ActivityStreamsAnyOfProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this ActivityStreamsAnyOfProperty) End() vocab.ActivityStreamsAnyOfPropertyIterator {
	return nil
}

// InsertActivityStreamsAccept inserts a Accept value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsAccept(idx int, v vocab.ActivityStreamsAccept) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsActivity inserts a Activity value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsActivity(idx int, v vocab.ActivityStreamsActivity) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAdd inserts a Add value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsAdd(idx int, v vocab.ActivityStreamsAdd) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    idx,
		parent:                   this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAnnounce inserts a Announce value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsAnnounce(idx int, v vocab.ActivityStreamsAnnounce) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsApplication inserts a Application value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsApplication(idx int, v vocab.ActivityStreamsApplication) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            idx,
		parent:                           this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsArrive inserts a Arrive value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsArrive(idx int, v vocab.ActivityStreamsArrive) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsArticle inserts a Article value at the specified index for
// a property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsArticle(idx int, v vocab.ActivityStreamsArticle) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAudio inserts a Audio value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsAudio(idx int, v vocab.ActivityStreamsAudio) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsBlock inserts a Block value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsBlock(idx int, v vocab.ActivityStreamsBlock) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCollection inserts a Collection value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsCollection(idx int, v vocab.ActivityStreamsCollection) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           idx,
		parent:                          this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCollectionPage inserts a CollectionPage value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsCollectionPage(idx int, v vocab.ActivityStreamsCollectionPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               idx,
		parent:                              this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCreate inserts a Create value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsCreate(idx int, v vocab.ActivityStreamsCreate) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDelete inserts a Delete value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsDelete(idx int, v vocab.ActivityStreamsDelete) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDislike inserts a Dislike value at the specified index for
// a property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsDislike(idx int, v vocab.ActivityStreamsDislike) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDocument inserts a Document value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsDocument(idx int, v vocab.ActivityStreamsDocument) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsEvent inserts a Event value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsEvent(idx int, v vocab.ActivityStreamsEvent) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsFlag inserts a Flag value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsFlag(idx int, v vocab.ActivityStreamsFlag) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsFollow inserts a Follow value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsFollow(idx int, v vocab.ActivityStreamsFollow) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsGroup inserts a Group value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsGroup(idx int, v vocab.ActivityStreamsGroup) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsIgnore inserts a Ignore value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsIgnore(idx int, v vocab.ActivityStreamsIgnore) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsImage inserts a Image value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsImage(idx int, v vocab.ActivityStreamsImage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsIntransitiveActivity inserts a IntransitiveActivity value
// at the specified index for a property "anyOf". Existing elements at that
// index and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsIntransitiveActivity(idx int, v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsInvite inserts a Invite value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsInvite(idx int, v vocab.ActivityStreamsInvite) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsJoin inserts a Join value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsJoin(idx int, v vocab.ActivityStreamsJoin) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLeave inserts a Leave value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsLeave(idx int, v vocab.ActivityStreamsLeave) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLike inserts a Like value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsLike(idx int, v vocab.ActivityStreamsLike) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLink inserts a Link value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsLink(idx int, v vocab.ActivityStreamsLink) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsListen inserts a Listen value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsListen(idx int, v vocab.ActivityStreamsListen) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsMention inserts a Mention value at the specified index for
// a property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsMention(idx int, v vocab.ActivityStreamsMention) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsMove inserts a Move value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsMove(idx int, v vocab.ActivityStreamsMove) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsNote inserts a Note value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsNote(idx int, v vocab.ActivityStreamsNote) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsObject inserts a Object value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsObject(idx int, v vocab.ActivityStreamsObject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOffer inserts a Offer value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsOffer(idx int, v vocab.ActivityStreamsOffer) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrderedCollection inserts a OrderedCollection value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsOrderedCollection(idx int, v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  idx,
		parent:                                 this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrderedCollectionPage inserts a OrderedCollectionPage
// value at the specified index for a property "anyOf". Existing elements at
// that index and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsOrderedCollectionPage(idx int, v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrganization inserts a Organization value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsOrganization(idx int, v vocab.ActivityStreamsOrganization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPage inserts a Page value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsPage(idx int, v vocab.ActivityStreamsPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPerson inserts a Person value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsPerson(idx int, v vocab.ActivityStreamsPerson) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPlace inserts a Place value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsPlace(idx int, v vocab.ActivityStreamsPlace) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsProfile inserts a Profile value at the specified index for
// a property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsProfile(idx int, v vocab.ActivityStreamsProfile) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsQuestion inserts a Question value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsQuestion(idx int, v vocab.ActivityStreamsQuestion) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRead inserts a Read value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsRead(idx int, v vocab.ActivityStreamsRead) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsReject inserts a Reject value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsReject(idx int, v vocab.ActivityStreamsReject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRelationship inserts a Relationship value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsRelationship(idx int, v vocab.ActivityStreamsRelationship) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRemove inserts a Remove value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsRemove(idx int, v vocab.ActivityStreamsRemove) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsService inserts a Service value at the specified index for
// a property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsService(idx int, v vocab.ActivityStreamsService) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTentativeAccept inserts a TentativeAccept value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsTentativeAccept(idx int, v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTentativeReject inserts a TentativeReject value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsTentativeReject(idx int, v vocab.ActivityStreamsTentativeReject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTombstone inserts a Tombstone value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsTombstone(idx int, v vocab.ActivityStreamsTombstone) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          idx,
		parent:                         this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTravel inserts a Travel value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsTravel(idx int, v vocab.ActivityStreamsTravel) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsUndo inserts a Undo value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsUndo(idx int, v vocab.ActivityStreamsUndo) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsUpdate inserts a Update value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsUpdate(idx int, v vocab.ActivityStreamsUpdate) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsVideo inserts a Video value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsVideo(idx int, v vocab.ActivityStreamsVideo) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsView inserts a View value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertActivityStreamsView(idx int, v vocab.ActivityStreamsView) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleAlbum inserts a Album value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertFunkwhaleAlbum(idx int, v vocab.FunkwhaleAlbum) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleArtist inserts a Artist value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertFunkwhaleArtist(idx int, v vocab.FunkwhaleArtist) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 idx,
		parent:                this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleLibrary inserts a Library value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertFunkwhaleLibrary(idx int, v vocab.FunkwhaleLibrary) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  idx,
		parent:                 this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleTrack inserts a Track value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertFunkwhaleTrack(idx int, v vocab.FunkwhaleTrack) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceApproval inserts a AnnounceApproval value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialAnnounceApproval(idx int, v vocab.GoToSocialAnnounceApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            idx,
		parent:                           this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceAuthorization inserts a AnnounceAuthorization value at
// the specified index for a property "anyOf". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialAnnounceAuthorization(idx int, v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 idx,
		parent:                                this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceRequest inserts a AnnounceRequest value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialAnnounceRequest(idx int, v vocab.GoToSocialAnnounceRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           idx,
		parent:                          this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeApproval inserts a LikeApproval value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialLikeApproval(idx int, v vocab.GoToSocialLikeApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeAuthorization inserts a LikeAuthorization value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialLikeAuthorization(idx int, v vocab.GoToSocialLikeAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeRequest inserts a LikeRequest value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialLikeRequest(idx int, v vocab.GoToSocialLikeRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyApproval inserts a ReplyApproval value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialReplyApproval(idx int, v vocab.GoToSocialReplyApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyAuthorization inserts a ReplyAuthorization value at the
// specified index for a property "anyOf". Existing elements at that index and
// higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialReplyAuthorization(idx int, v vocab.GoToSocialReplyAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              idx,
		parent:                             this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyRequest inserts a ReplyRequest value at the specified
// index for a property "anyOf". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertGoToSocialReplyRequest(idx int, v vocab.GoToSocialReplyRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Insert inserts an IRI value at the specified index for a property "anyOf".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertLitePubEmojiReact inserts a EmojiReact value at the specified index for a
// property "anyOf". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertLitePubEmojiReact(idx int, v vocab.LitePubEmojiReact) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   idx,
		parent:                  this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertSchemaPropertyValue inserts a PropertyValue value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertSchemaPropertyValue(idx int, v vocab.SchemaPropertyValue) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
		schemaPropertyValueMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootEmoji inserts a Emoji value at the specified index for a property
// "anyOf". Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertTootEmoji(idx int, v vocab.TootEmoji) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:           this.alias,
		myIdx:           idx,
		parent:          this,
		tootEmojiMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootHashtag inserts a Hashtag value at the specified index for a property
// "anyOf". Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertTootHashtag(idx int, v vocab.TootHashtag) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:             this.alias,
		myIdx:             idx,
		parent:            this,
		tootHashtagMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootIdentityProof inserts a IdentityProof value at the specified index
// for a property "anyOf". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) InsertTootIdentityProof(idx int, v vocab.TootIdentityProof) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		myIdx:                   idx,
		parent:                  this,
		tootIdentityProofMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "anyOf". Invalidates all iterators. Returns an error if the type
// is not a valid one to set for this property.
func (this *ActivityStreamsAnyOfProperty) InsertType(idx int, t vocab.Type) error {
	n := &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = n
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsAnyOfProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this ActivityStreamsAnyOfProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "anyOf" property.
func (this ActivityStreamsAnyOfProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this ActivityStreamsAnyOfProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].GetActivityStreamsObject()
			rhs := this.properties[j].GetActivityStreamsObject()
			return lhs.LessThan(rhs)
		} else if idx1 == 1 {
			lhs := this.properties[i].GetActivityStreamsLink()
			rhs := this.properties[j].GetActivityStreamsLink()
			return lhs.LessThan(rhs)
		} else if idx1 == 2 {
			lhs := this.properties[i].GetActivityStreamsAccept()
			rhs := this.properties[j].GetActivityStreamsAccept()
			return lhs.LessThan(rhs)
		} else if idx1 == 3 {
			lhs := this.properties[i].GetActivityStreamsActivity()
			rhs := this.properties[j].GetActivityStreamsActivity()
			return lhs.LessThan(rhs)
		} else if idx1 == 4 {
			lhs := this.properties[i].GetActivityStreamsAdd()
			rhs := this.properties[j].GetActivityStreamsAdd()
			return lhs.LessThan(rhs)
		} else if idx1 == 5 {
			lhs := this.properties[i].GetFunkwhaleAlbum()
			rhs := this.properties[j].GetFunkwhaleAlbum()
			return lhs.LessThan(rhs)
		} else if idx1 == 6 {
			lhs := this.properties[i].GetActivityStreamsAnnounce()
			rhs := this.properties[j].GetActivityStreamsAnnounce()
			return lhs.LessThan(rhs)
		} else if idx1 == 7 {
			lhs := this.properties[i].GetGoToSocialAnnounceApproval()
			rhs := this.properties[j].GetGoToSocialAnnounceApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 8 {
			lhs := this.properties[i].GetGoToSocialAnnounceAuthorization()
			rhs := this.properties[j].GetGoToSocialAnnounceAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 9 {
			lhs := this.properties[i].GetGoToSocialAnnounceRequest()
			rhs := this.properties[j].GetGoToSocialAnnounceRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 10 {
			lhs := this.properties[i].GetActivityStreamsApplication()
			rhs := this.properties[j].GetActivityStreamsApplication()
			return lhs.LessThan(rhs)
		} else if idx1 == 11 {
			lhs := this.properties[i].GetActivityStreamsArrive()
			rhs := this.properties[j].GetActivityStreamsArrive()
			return lhs.LessThan(rhs)
		} else if idx1 == 12 {
			lhs := this.properties[i].GetActivityStreamsArticle()
			rhs := this.properties[j].GetActivityStreamsArticle()
			return lhs.LessThan(rhs)
		} else if idx1 == 13 {
			lhs := this.properties[i].GetFunkwhaleArtist()
			rhs := this.properties[j].GetFunkwhaleArtist()
			return lhs.LessThan(rhs)
		} else if idx1 == 14 {
			lhs := this.properties[i].GetActivityStreamsAudio()
			rhs := this.properties[j].GetActivityStreamsAudio()
			return lhs.LessThan(rhs)
		} else if idx1 == 15 {
			lhs := this.properties[i].GetActivityStreamsBlock()
			rhs := this.properties[j].GetActivityStreamsBlock()
			return lhs.LessThan(rhs)
		} else if idx1 == 16 {
			lhs := this.properties[i].GetActivityStreamsCollection()
			rhs := this.properties[j].GetActivityStreamsCollection()
			return lhs.LessThan(rhs)
		} else if idx1 == 17 {
			lhs := this.properties[i].GetActivityStreamsCollectionPage()
			rhs := this.properties[j].GetActivityStreamsCollectionPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 18 {
			lhs := this.properties[i].GetActivityStreamsCreate()
			rhs := this.properties[j].GetActivityStreamsCreate()
			return lhs.LessThan(rhs)
		} else if idx1 == 19 {
			lhs := this.properties[i].GetActivityStreamsDelete()
			rhs := this.properties[j].GetActivityStreamsDelete()
			return lhs.LessThan(rhs)
		} else if idx1 == 20 {
			lhs := this.properties[i].GetActivityStreamsDislike()
			rhs := this.properties[j].GetActivityStreamsDislike()
			return lhs.LessThan(rhs)
		} else if idx1 == 21 {
			lhs := this.properties[i].GetActivityStreamsDocument()
			rhs := this.properties[j].GetActivityStreamsDocument()
			return lhs.LessThan(rhs)
		} else if idx1 == 22 {
			lhs := this.properties[i].GetTootEmoji()
			rhs := this.properties[j].GetTootEmoji()
			return lhs.LessThan(rhs)
		} else if idx1 == 23 {
			lhs := this.properties[i].GetLitePubEmojiReact()
			rhs := this.properties[j].GetLitePubEmojiReact()
			return lhs.LessThan(rhs)
		} else if idx1 == 24 {
			lhs := this.properties[i].GetActivityStreamsEvent()
			rhs := this.properties[j].GetActivityStreamsEvent()
			return lhs.LessThan(rhs)
		} else if idx1 == 25 {
			lhs := this.properties[i].GetActivityStreamsFlag()
			rhs := this.properties[j].GetActivityStreamsFlag()
			return lhs.LessThan(rhs)
		} else if idx1 == 26 {
			lhs := this.properties[i].GetActivityStreamsFollow()
			rhs := this.properties[j].GetActivityStreamsFollow()
			return lhs.LessThan(rhs)
		} else if idx1 == 27 {
			lhs := this.properties[i].GetActivityStreamsGroup()
			rhs := this.properties[j].GetActivityStreamsGroup()
			return lhs.LessThan(rhs)
		} else if idx1 == 28 {
			lhs := this.properties[i].GetTootHashtag()
			rhs := this.properties[j].GetTootHashtag()
			return lhs.LessThan(rhs)
		} else if idx1 == 29 {
			lhs := this.properties[i].GetTootIdentityProof()
			rhs := this.properties[j].GetTootIdentityProof()
			return lhs.LessThan(rhs)
		} else if idx1 == 30 {
			lhs := this.properties[i].GetActivityStreamsIgnore()
			rhs := this.properties[j].GetActivityStreamsIgnore()
			return lhs.LessThan(rhs)
		} else if idx1 == 31 {
			lhs := this.properties[i].GetActivityStreamsImage()
			rhs := this.properties[j].GetActivityStreamsImage()
			return lhs.LessThan(rhs)
		} else if idx1 == 32 {
			lhs := this.properties[i].GetActivityStreamsIntransitiveActivity()
			rhs := this.properties[j].GetActivityStreamsIntransitiveActivity()
			return lhs.LessThan(rhs)
		} else if idx1 == 33 {
			lhs := this.properties[i].GetActivityStreamsInvite()
			rhs := this.properties[j].GetActivityStreamsInvite()
			return lhs.LessThan(rhs)
		} else if idx1 == 34 {
			lhs := this.properties[i].GetActivityStreamsJoin()
			rhs := this.properties[j].GetActivityStreamsJoin()
			return lhs.LessThan(rhs)
		} else if idx1 == 35 {
			lhs := this.properties[i].GetActivityStreamsLeave()
			rhs := this.properties[j].GetActivityStreamsLeave()
			return lhs.LessThan(rhs)
		} else if idx1 == 36 {
			lhs := this.properties[i].GetFunkwhaleLibrary()
			rhs := this.properties[j].GetFunkwhaleLibrary()
			return lhs.LessThan(rhs)
		} else if idx1 == 37 {
			lhs := this.properties[i].GetActivityStreamsLike()
			rhs := this.properties[j].GetActivityStreamsLike()
			return lhs.LessThan(rhs)
		} else if idx1 == 38 {
			lhs := this.properties[i].GetGoToSocialLikeApproval()
			rhs := this.properties[j].GetGoToSocialLikeApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 39 {
			lhs := this.properties[i].GetGoToSocialLikeAuthorization()
			rhs := this.properties[j].GetGoToSocialLikeAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 40 {
			lhs := this.properties[i].GetGoToSocialLikeRequest()
			rhs := this.properties[j].GetGoToSocialLikeRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 41 {
			lhs := this.properties[i].GetActivityStreamsListen()
			rhs := this.properties[j].GetActivityStreamsListen()
			return lhs.LessThan(rhs)
		} else if idx1 == 42 {
			lhs := this.properties[i].GetActivityStreamsMention()
			rhs := this.properties[j].GetActivityStreamsMention()
			return lhs.LessThan(rhs)
		} else if idx1 == 43 {
			lhs := this.properties[i].GetActivityStreamsMove()
			rhs := this.properties[j].GetActivityStreamsMove()
			return lhs.LessThan(rhs)
		} else if idx1 == 44 {
			lhs := this.properties[i].GetActivityStreamsNote()
			rhs := this.properties[j].GetActivityStreamsNote()
			return lhs.LessThan(rhs)
		} else if idx1 == 45 {
			lhs := this.properties[i].GetActivityStreamsOffer()
			rhs := this.properties[j].GetActivityStreamsOffer()
			return lhs.LessThan(rhs)
		} else if idx1 == 46 {
			lhs := this.properties[i].GetActivityStreamsOrderedCollection()
			rhs := this.properties[j].GetActivityStreamsOrderedCollection()
			return lhs.LessThan(rhs)
		} else if idx1 == 47 {
			lhs := this.properties[i].GetActivityStreamsOrderedCollectionPage()
			rhs := this.properties[j].GetActivityStreamsOrderedCollectionPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 48 {
			lhs := this.properties[i].GetActivityStreamsOrganization()
			rhs := this.properties[j].GetActivityStreamsOrganization()
			return lhs.LessThan(rhs)
		} else if idx1 == 49 {
			lhs := this.properties[i].GetActivityStreamsPage()
			rhs := this.properties[j].GetActivityStreamsPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 50 {
			lhs := this.properties[i].GetActivityStreamsPerson()
			rhs := this.properties[j].GetActivityStreamsPerson()
			return lhs.LessThan(rhs)
		} else if idx1 == 51 {
			lhs := this.properties[i].GetActivityStreamsPlace()
			rhs := this.properties[j].GetActivityStreamsPlace()
			return lhs.LessThan(rhs)
		} else if idx1 == 52 {
			lhs := this.properties[i].GetActivityStreamsProfile()
			rhs := this.properties[j].GetActivityStreamsProfile()
			return lhs.LessThan(rhs)
		} else if idx1 == 53 {
			lhs := this.properties[i].GetSchemaPropertyValue()
			rhs := this.properties[j].GetSchemaPropertyValue()
			return lhs.LessThan(rhs)
		} else if idx1 == 54 {
			lhs := this.properties[i].GetActivityStreamsQuestion()
			rhs := this.properties[j].GetActivityStreamsQuestion()
			return lhs.LessThan(rhs)
		} else if idx1 == 55 {
			lhs := this.properties[i].GetActivityStreamsRead()
			rhs := this.properties[j].GetActivityStreamsRead()
			return lhs.LessThan(rhs)
		} else if idx1 == 56 {
			lhs := this.properties[i].GetActivityStreamsReject()
			rhs := this.properties[j].GetActivityStreamsReject()
			return lhs.LessThan(rhs)
		} else if idx1 == 57 {
			lhs := this.properties[i].GetActivityStreamsRelationship()
			rhs := this.properties[j].GetActivityStreamsRelationship()
			return lhs.LessThan(rhs)
		} else if idx1 == 58 {
			lhs := this.properties[i].GetActivityStreamsRemove()
			rhs := this.properties[j].GetActivityStreamsRemove()
			return lhs.LessThan(rhs)
		} else if idx1 == 59 {
			lhs := this.properties[i].GetGoToSocialReplyApproval()
			rhs := this.properties[j].GetGoToSocialReplyApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 60 {
			lhs := this.properties[i].GetGoToSocialReplyAuthorization()
			rhs := this.properties[j].GetGoToSocialReplyAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 61 {
			lhs := this.properties[i].GetGoToSocialReplyRequest()
			rhs := this.properties[j].GetGoToSocialReplyRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 62 {
			lhs := this.properties[i].GetActivityStreamsService()
			rhs := this.properties[j].GetActivityStreamsService()
			return lhs.LessThan(rhs)
		} else if idx1 == 63 {
			lhs := this.properties[i].GetActivityStreamsTentativeAccept()
			rhs := this.properties[j].GetActivityStreamsTentativeAccept()
			return lhs.LessThan(rhs)
		} else if idx1 == 64 {
			lhs := this.properties[i].GetActivityStreamsTentativeReject()
			rhs := this.properties[j].GetActivityStreamsTentativeReject()
			return lhs.LessThan(rhs)
		} else if idx1 == 65 {
			lhs := this.properties[i].GetActivityStreamsTombstone()
			rhs := this.properties[j].GetActivityStreamsTombstone()
			return lhs.LessThan(rhs)
		} else if idx1 == 66 {
			lhs := this.properties[i].GetFunkwhaleTrack()
			rhs := this.properties[j].GetFunkwhaleTrack()
			return lhs.LessThan(rhs)
		} else if idx1 == 67 {
			lhs := this.properties[i].GetActivityStreamsTravel()
			rhs := this.properties[j].GetActivityStreamsTravel()
			return lhs.LessThan(rhs)
		} else if idx1 == 68 {
			lhs := this.properties[i].GetActivityStreamsUndo()
			rhs := this.properties[j].GetActivityStreamsUndo()
			return lhs.LessThan(rhs)
		} else if idx1 == 69 {
			lhs := this.properties[i].GetActivityStreamsUpdate()
			rhs := this.properties[j].GetActivityStreamsUpdate()
			return lhs.LessThan(rhs)
		} else if idx1 == 70 {
			lhs := this.properties[i].GetActivityStreamsVideo()
			rhs := this.properties[j].GetActivityStreamsVideo()
			return lhs.LessThan(rhs)
		} else if idx1 == 71 {
			lhs := this.properties[i].GetActivityStreamsView()
			rhs := this.properties[j].GetActivityStreamsView()
			return lhs.LessThan(rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsAnyOfProperty) LessThan(o vocab.ActivityStreamsAnyOfProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("anyOf") with any alias.
func (this ActivityStreamsAnyOfProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "anyOf"
	} else {
		return "anyOf"
	}
}

// PrependActivityStreamsAccept prepends a Accept value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsActivity prepends a Activity value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAdd prepends a Add value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    0,
		parent:                   this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAnnounce prepends a Announce value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsApplication prepends a Application value to the front of
// a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            0,
		parent:                           this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsArrive prepends a Arrive value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsArticle prepends a Article value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAudio prepends a Audio value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsBlock prepends a Block value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCollection prepends a Collection value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           0,
		parent:                          this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCollectionPage prepends a CollectionPage value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               0,
		parent:                              this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCreate prepends a Create value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDelete prepends a Delete value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDislike prepends a Dislike value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDocument prepends a Document value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsEvent prepends a Event value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsFlag prepends a Flag value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsFollow prepends a Follow value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsGroup prepends a Group value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsIgnore prepends a Ignore value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsImage prepends a Image value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsIntransitiveActivity prepends a IntransitiveActivity
// value to the front of a list of the property "anyOf". Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsInvite prepends a Invite value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsJoin prepends a Join value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLeave prepends a Leave value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLike prepends a Like value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLink prepends a Link value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsListen prepends a Listen value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsMention prepends a Mention value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsMove prepends a Move value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsNote prepends a Note value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsObject prepends a Object value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOffer prepends a Offer value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrderedCollection prepends a OrderedCollection value to
// the front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  0,
		parent:                                 this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrderedCollectionPage prepends a OrderedCollectionPage
// value to the front of a list of the property "anyOf". Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrganization prepends a Organization value to the front
// of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPage prepends a Page value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPerson prepends a Person value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPlace prepends a Place value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsProfile prepends a Profile value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsQuestion prepends a Question value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRead prepends a Read value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsReject prepends a Reject value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRelationship prepends a Relationship value to the front
// of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRemove prepends a Remove value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsService prepends a Service value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsService(v vocab.ActivityStreamsService) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTentativeAccept prepends a TentativeAccept value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                0,
		parent:                               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTentativeReject prepends a TentativeReject value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                0,
		parent:                               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTombstone prepends a Tombstone value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          0,
		parent:                         this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTravel prepends a Travel value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsUndo prepends a Undo value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsUpdate prepends a Update value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsVideo prepends a Video value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsView prepends a View value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependActivityStreamsView(v vocab.ActivityStreamsView) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleAlbum prepends a Album value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleArtist prepends a Artist value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 0,
		parent:                this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleLibrary prepends a Library value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  0,
		parent:                 this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleTrack prepends a Track value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceApproval prepends a AnnounceApproval value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            0,
		parent:                           this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceAuthorization prepends a AnnounceAuthorization value
// to the front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 0,
		parent:                                this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceRequest prepends a AnnounceRequest value to the front
// of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           0,
		parent:                          this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeApproval prepends a LikeApproval value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeAuthorization prepends a LikeAuthorization value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeRequest prepends a LikeRequest value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyApproval prepends a ReplyApproval value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyAuthorization prepends a ReplyAuthorization value to the
// front of a list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              0,
		parent:                             this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyRequest prepends a ReplyRequest value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property "anyOf".
func (this *ActivityStreamsAnyOfProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependLitePubEmojiReact prepends a EmojiReact value to the front of a list of
// the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   0,
		parent:                  this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependSchemaPropertyValue prepends a PropertyValue value to the front of a
// list of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
		schemaPropertyValueMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootEmoji prepends a Emoji value to the front of a list of the property
// "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependTootEmoji(v vocab.TootEmoji) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:           this.alias,
		myIdx:           0,
		parent:          this,
		tootEmojiMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootHashtag prepends a Hashtag value to the front of a list of the
// property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependTootHashtag(v vocab.TootHashtag) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:             this.alias,
		myIdx:             0,
		parent:            this,
		tootHashtagMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootIdentityProof prepends a IdentityProof value to the front of a list
// of the property "anyOf". Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) PrependTootIdentityProof(v vocab.TootIdentityProof) {
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{{
		alias:                   this.alias,
		myIdx:                   0,
		parent:                  this,
		tootIdentityProofMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "anyOf". Invalidates all iterators. Returns an error if the type
// is not a valid one to set for this property.
func (this *ActivityStreamsAnyOfProperty) PrependType(t vocab.Type) error {
	n := &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append([]*ActivityStreamsAnyOfPropertyIterator{n}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// Remove deletes an element at the specified index from a list of the property
// "anyOf", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &ActivityStreamsAnyOfPropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsAnyOfProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// SetActivityStreamsAccept sets a Accept value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsAccept(idx int, v vocab.ActivityStreamsAccept) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsActivity sets a Activity value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsActivity(idx int, v vocab.ActivityStreamsActivity) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsAdd sets a Add value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsAdd(idx int, v vocab.ActivityStreamsAdd) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    idx,
		parent:                   this,
	}
}

// SetActivityStreamsAnnounce sets a Announce value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsAnnounce(idx int, v vocab.ActivityStreamsAnnounce) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsApplication sets a Application value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsApplication(idx int, v vocab.ActivityStreamsApplication) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            idx,
		parent:                           this,
	}
}

// SetActivityStreamsArrive sets a Arrive value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsArrive(idx int, v vocab.ActivityStreamsArrive) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsArticle sets a Article value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsArticle(idx int, v vocab.ActivityStreamsArticle) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsAudio sets a Audio value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsAudio(idx int, v vocab.ActivityStreamsAudio) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsBlock sets a Block value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsBlock(idx int, v vocab.ActivityStreamsBlock) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsCollection sets a Collection value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsCollection(idx int, v vocab.ActivityStreamsCollection) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           idx,
		parent:                          this,
	}
}

// SetActivityStreamsCollectionPage sets a CollectionPage value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsCollectionPage(idx int, v vocab.ActivityStreamsCollectionPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               idx,
		parent:                              this,
	}
}

// SetActivityStreamsCreate sets a Create value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsCreate(idx int, v vocab.ActivityStreamsCreate) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsDelete sets a Delete value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsDelete(idx int, v vocab.ActivityStreamsDelete) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsDislike sets a Dislike value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsDislike(idx int, v vocab.ActivityStreamsDislike) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsDocument sets a Document value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsDocument(idx int, v vocab.ActivityStreamsDocument) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsEvent sets a Event value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsEvent(idx int, v vocab.ActivityStreamsEvent) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsFlag sets a Flag value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsFlag(idx int, v vocab.ActivityStreamsFlag) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsFollow sets a Follow value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsFollow(idx int, v vocab.ActivityStreamsFollow) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsGroup sets a Group value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsGroup(idx int, v vocab.ActivityStreamsGroup) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsIgnore sets a Ignore value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsIgnore(idx int, v vocab.ActivityStreamsIgnore) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsImage sets a Image value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsImage(idx int, v vocab.ActivityStreamsImage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsIntransitiveActivity sets a IntransitiveActivity value to be
// at the specified index for the property "anyOf". Panics if the index is out
// of bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsIntransitiveActivity(idx int, v vocab.ActivityStreamsIntransitiveActivity) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
}

// SetActivityStreamsInvite sets a Invite value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsInvite(idx int, v vocab.ActivityStreamsInvite) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsJoin sets a Join value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsJoin(idx int, v vocab.ActivityStreamsJoin) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsLeave sets a Leave value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsLeave(idx int, v vocab.ActivityStreamsLeave) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsLike sets a Like value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsLike(idx int, v vocab.ActivityStreamsLike) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsLink sets a Link value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsLink(idx int, v vocab.ActivityStreamsLink) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsListen sets a Listen value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsListen(idx int, v vocab.ActivityStreamsListen) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsMention sets a Mention value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsMention(idx int, v vocab.ActivityStreamsMention) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsMove sets a Move value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsMove(idx int, v vocab.ActivityStreamsMove) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsNote sets a Note value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsNote(idx int, v vocab.ActivityStreamsNote) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsObject sets a Object value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsObject(idx int, v vocab.ActivityStreamsObject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsOffer sets a Offer value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsOffer(idx int, v vocab.ActivityStreamsOffer) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsOrderedCollection sets a OrderedCollection value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsOrderedCollection(idx int, v vocab.ActivityStreamsOrderedCollection) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  idx,
		parent:                                 this,
	}
}

// SetActivityStreamsOrderedCollectionPage sets a OrderedCollectionPage value to
// be at the specified index for the property "anyOf". Panics if the index is
// out of bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsOrderedCollectionPage(idx int, v vocab.ActivityStreamsOrderedCollectionPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
}

// SetActivityStreamsOrganization sets a Organization value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsOrganization(idx int, v vocab.ActivityStreamsOrganization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetActivityStreamsPage sets a Page value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsPage(idx int, v vocab.ActivityStreamsPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsPerson sets a Person value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsPerson(idx int, v vocab.ActivityStreamsPerson) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsPlace sets a Place value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsPlace(idx int, v vocab.ActivityStreamsPlace) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsProfile sets a Profile value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsProfile(idx int, v vocab.ActivityStreamsProfile) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsQuestion sets a Question value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsQuestion(idx int, v vocab.ActivityStreamsQuestion) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsRead sets a Read value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsRead(idx int, v vocab.ActivityStreamsRead) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsReject sets a Reject value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsReject(idx int, v vocab.ActivityStreamsReject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsRelationship sets a Relationship value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsRelationship(idx int, v vocab.ActivityStreamsRelationship) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetActivityStreamsRemove sets a Remove value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsRemove(idx int, v vocab.ActivityStreamsRemove) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsService sets a Service value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsService(idx int, v vocab.ActivityStreamsService) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsTentativeAccept sets a TentativeAccept value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsTentativeAccept(idx int, v vocab.ActivityStreamsTentativeAccept) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
}

// SetActivityStreamsTentativeReject sets a TentativeReject value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsTentativeReject(idx int, v vocab.ActivityStreamsTentativeReject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
}

// SetActivityStreamsTombstone sets a Tombstone value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsTombstone(idx int, v vocab.ActivityStreamsTombstone) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          idx,
		parent:                         this,
	}
}

// SetActivityStreamsTravel sets a Travel value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsTravel(idx int, v vocab.ActivityStreamsTravel) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsUndo sets a Undo value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsUndo(idx int, v vocab.ActivityStreamsUndo) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsUpdate sets a Update value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsUpdate(idx int, v vocab.ActivityStreamsUpdate) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsVideo sets a Video value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsVideo(idx int, v vocab.ActivityStreamsVideo) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsView sets a View value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetActivityStreamsView(idx int, v vocab.ActivityStreamsView) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetFunkwhaleAlbum sets a Album value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetFunkwhaleAlbum(idx int, v vocab.FunkwhaleAlbum) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetFunkwhaleArtist sets a Artist value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetFunkwhaleArtist(idx int, v vocab.FunkwhaleArtist) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 idx,
		parent:                this,
	}
}

// SetFunkwhaleLibrary sets a Library value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetFunkwhaleLibrary(idx int, v vocab.FunkwhaleLibrary) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  idx,
		parent:                 this,
	}
}

// SetFunkwhaleTrack sets a Track value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetFunkwhaleTrack(idx int, v vocab.FunkwhaleTrack) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetGoToSocialAnnounceApproval sets a AnnounceApproval value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialAnnounceApproval(idx int, v vocab.GoToSocialAnnounceApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            idx,
		parent:                           this,
	}
}

// SetGoToSocialAnnounceAuthorization sets a AnnounceAuthorization value to be at
// the specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialAnnounceAuthorization(idx int, v vocab.GoToSocialAnnounceAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 idx,
		parent:                                this,
	}
}

// SetGoToSocialAnnounceRequest sets a AnnounceRequest value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialAnnounceRequest(idx int, v vocab.GoToSocialAnnounceRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           idx,
		parent:                          this,
	}
}

// SetGoToSocialLikeApproval sets a LikeApproval value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialLikeApproval(idx int, v vocab.GoToSocialLikeApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetGoToSocialLikeAuthorization sets a LikeAuthorization value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialLikeAuthorization(idx int, v vocab.GoToSocialLikeAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetGoToSocialLikeRequest sets a LikeRequest value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialLikeRequest(idx int, v vocab.GoToSocialLikeRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetGoToSocialReplyApproval sets a ReplyApproval value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialReplyApproval(idx int, v vocab.GoToSocialReplyApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetGoToSocialReplyAuthorization sets a ReplyAuthorization value to be at the
// specified index for the property "anyOf". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialReplyAuthorization(idx int, v vocab.GoToSocialReplyAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              idx,
		parent:                             this,
	}
}

// SetGoToSocialReplyRequest sets a ReplyRequest value to be at the specified
// index for the property "anyOf". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetGoToSocialReplyRequest(idx int, v vocab.GoToSocialReplyRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property "anyOf".
// Panics if the index is out of bounds.
func (this *ActivityStreamsAnyOfProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// SetLitePubEmojiReact sets a EmojiReact value to be at the specified index for
// the property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetLitePubEmojiReact(idx int, v vocab.LitePubEmojiReact) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   idx,
		parent:                  this,
	}
}

// SetSchemaPropertyValue sets a PropertyValue value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetSchemaPropertyValue(idx int, v vocab.SchemaPropertyValue) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
		schemaPropertyValueMember: v,
	}
}

// SetTootEmoji sets a Emoji value to be at the specified index for the property
// "anyOf". Panics if the index is out of bounds. Invalidates all iterators.
func (this *ActivityStreamsAnyOfProperty) SetTootEmoji(idx int, v vocab.TootEmoji) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:           this.alias,
		myIdx:           idx,
		parent:          this,
		tootEmojiMember: v,
	}
}

// SetTootHashtag sets a Hashtag value to be at the specified index for the
// property "anyOf". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAnyOfProperty) SetTootHashtag(idx int, v vocab.TootHashtag) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:             this.alias,
		myIdx:             idx,
		parent:            this,
		tootHashtagMember: v,
	}
}

// SetTootIdentityProof sets a IdentityProof value to be at the specified index
// for the property "anyOf". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAnyOfProperty) SetTootIdentityProof(idx int, v vocab.TootIdentityProof) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAnyOfPropertyIterator{
		alias:                   this.alias,
		myIdx:                   idx,
		parent:                  this,
		tootIdentityProofMember: v,
	}
}

// SetType sets an arbitrary type value to the specified index of the property
// "anyOf". Invalidates all iterators. Returns an error if the type is not a
// valid one to set for this property. Panics if the index is out of bounds.
func (this *ActivityStreamsAnyOfProperty) SetType(idx int, t vocab.Type) error {
	n := &ActivityStreamsAnyOfPropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	(this.properties)[idx] = n
	return nil
}

// Swap swaps the location of values at two indices for the "anyOf" property.
func (this ActivityStreamsAnyOfProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
