/*
 * Copyright 2020-2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, soapy, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_soapy_block = R"doc()doc";


static const char* __doc_gr_soapy_block_block_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_block_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_make = R"doc()doc";


static const char* __doc_gr_soapy_block_get_driver_key = R"doc(A key that uniquely identifies the device driver. This key identifies the underlying implementation. Several variants of a product may share a driver.)doc";


static const char* __doc_gr_soapy_block_get_hardware_key = R"doc(A key that uniquely identifies the hardware. This key should be meaningful to the user to optimize for the underlying hardware.)doc";


static const char* __doc_gr_soapy_block_get_hardware_info = R"doc(Query a dictionary of available device information. This dictionary can any number of values like vendor name, product name, revisions, serials... This information can be displayed to the user to help identify the instantiated device.)doc";


static const char* __doc_gr_soapy_block_set_frontend_mapping = R"doc(Set the frontend mapping of available DSP units to RF frontends. This mapping controls channel mapping and channel availability.)doc";


static const char* __doc_gr_soapy_block_get_frontend_mapping = R"doc(Get the frontend mapping of available DSP units to RF frontends. This mapping describes channel mapping and channel availability.)doc";


static const char* __doc_gr_soapy_block_get_channel_info = R"doc(Query a dictionary of available channel information. This dictionary can any number of values like decoder type, version, available functions... This information can be displayed to the user to help identify the instantiated channel.)doc";


static const char* __doc_gr_soapy_block_set_sample_rate = R"doc(Set sample rate)doc";


static const char* __doc_gr_soapy_block_get_sample_rate = R"doc(Get the baseband sample rate of the RX chain.)doc";


static const char* __doc_gr_soapy_block_get_sample_rate_range = R"doc(Get the range of possible baseband sample rates.)doc";


static const char* __doc_gr_soapy_block_set_frequency_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_set_frequency_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_frequency_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_frequency_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_list_frequencies = R"doc(List available tunable elements in the chain. Elements should be in order RF to baseband.)doc";


static const char* __doc_gr_soapy_block_get_frequency_range_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_frequency_range_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_frequency_args_info = R"doc(Query the argument info description for stream args.)doc";


static const char* __doc_gr_soapy_block_set_bandwidth = R"doc(Set filter bandwidth)doc";


static const char* __doc_gr_soapy_block_get_bandwidth = R"doc(Get baseband filter width of the RX chain.)doc";


static const char* __doc_gr_soapy_block_get_bandwidth_range = R"doc(Get the range of possible baseband filter widths.)doc";


static const char* __doc_gr_soapy_block_list_antennas = R"doc(List available antennas for a channel)doc";


static const char* __doc_gr_soapy_block_set_antenna = R"doc(Set antenna for channel)doc";


static const char* __doc_gr_soapy_block_get_antenna = R"doc(Get the selected antenna on RX chain.)doc";


static const char* __doc_gr_soapy_block_has_gain_mode = R"doc(Return whether automatic gain control (AGC) is supported)doc";


static const char* __doc_gr_soapy_block_set_gain_mode = R"doc(Set automatic gain control (AGC))doc";


static const char* __doc_gr_soapy_block_get_gain_mode = R"doc(Get the automatic gain mode on the RX chain.)doc";


static const char* __doc_gr_soapy_block_list_gains = R"doc(List available amplification elements. Elements should be in order RF to baseband.)doc";


static const char* __doc_gr_soapy_block_set_gain_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_set_gain_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_gain_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_gain_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_gain_range_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_gain_range_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_has_frequency_correction = R"doc(Return whether frequency correction is supported)doc";


static const char* __doc_gr_soapy_block_set_frequency_correction = R"doc(Set frequency correction)doc";


static const char* __doc_gr_soapy_block_get_frequency_correction = R"doc(Get the frequency correction value.)doc";


static const char* __doc_gr_soapy_block_has_dc_offset_mode = R"doc(Return whether DC offset mode can be set)doc";


static const char* __doc_gr_soapy_block_set_dc_offset_mode = R"doc(Set DC offset mode)doc";


static const char* __doc_gr_soapy_block_get_dc_offset_mode = R"doc(Get the automatic DC offset correction mode.)doc";


static const char* __doc_gr_soapy_block_has_dc_offset = R"doc(Return whether manual dc offset correction is supported)doc";


static const char* __doc_gr_soapy_block_set_dc_offset = R"doc(Set dc offset correction)doc";


static const char* __doc_gr_soapy_block_get_dc_offset = R"doc(Get the DC offset correction.)doc";


static const char* __doc_gr_soapy_block_has_iq_balance = R"doc(Return whether manual IQ balance correction is supported)doc";


static const char* __doc_gr_soapy_block_set_iq_balance = R"doc(Set IQ balance correction)doc";


static const char* __doc_gr_soapy_block_get_iq_balance = R"doc(Get the IQ balance correction.)doc";


static const char* __doc_gr_soapy_block_has_iq_balance_mode = R"doc(Does the device support automatic frontend IQ balance correction?)doc";


static const char* __doc_gr_soapy_block_set_iq_balance_mode = R"doc(Set the automatic frontend IQ balance correction.)doc";


static const char* __doc_gr_soapy_block_get_iq_balance_mode = R"doc(Get the automatic IQ balance corrections mode.)doc";


static const char* __doc_gr_soapy_block_set_master_clock_rate = R"doc(Set master clock rate)doc";


static const char* __doc_gr_soapy_block_get_master_clock_rate = R"doc(Get the master clock rate of the device.)doc";


static const char* __doc_gr_soapy_block_get_master_clock_rates = R"doc(Get the range of available master clock rates.)doc";


static const char* __doc_gr_soapy_block_set_reference_clock_rate = R"doc(Set the reference clock rate of the device.)doc";


static const char* __doc_gr_soapy_block_get_reference_clock_rate = R"doc(Get the reference clock rate of the device.)doc";


static const char* __doc_gr_soapy_block_get_reference_clock_rates = R"doc(Get the range of available reference clock rates.)doc";


static const char* __doc_gr_soapy_block_list_clock_sources = R"doc(Get the list of available clock sources.)doc";


static const char* __doc_gr_soapy_block_set_clock_source = R"doc(Set the clock source)doc";


static const char* __doc_gr_soapy_block_get_clock_source = R"doc(Get the clock source of the device)doc";


static const char* __doc_gr_soapy_block_list_time_sources = R"doc(Get the list of available time sources.)doc";


static const char* __doc_gr_soapy_block_set_time_source = R"doc(Set the time source on the device)doc";


static const char* __doc_gr_soapy_block_get_time_source = R"doc(Get the time source of the device)doc";


static const char* __doc_gr_soapy_block_has_hardware_time = R"doc(Does this device have a hardware clock?)doc";


static const char* __doc_gr_soapy_block_get_hardware_time = R"doc(Read the time from the hardware clock on the device. The what argument can refer to a specific time counter.)doc";


static const char* __doc_gr_soapy_block_set_hardware_time = R"doc(Write the time to the hardware clock on the device. The what argument can refer to a specific time counter.)doc";


static const char* __doc_gr_soapy_block_list_sensors_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_sensor_info_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_sensor_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_list_sensors_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_sensor_info_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_sensor_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_list_register_interfaces = R"doc(Get a list of available register interfaces by name.)doc";


static const char* __doc_gr_soapy_block_write_register = R"doc(Write a register on the device given the interface name. This can represent a register on a soft CPU, FPGA, IC; the interpretation is up the implementation to decide.)doc";


static const char* __doc_gr_soapy_block_read_register = R"doc(Read a register on the device given the interface name.)doc";


static const char* __doc_gr_soapy_block_write_registers = R"doc(Write a memory block on the device given the interface name. This can represent a memory block on a soft CPU, FPGA, IC; the interpretation is up the implementation to decide.)doc";


static const char* __doc_gr_soapy_block_read_registers = R"doc(Read a memory block on the device given the interface name.)doc";


static const char* __doc_gr_soapy_block_get_setting_info_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_write_setting_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_setting_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_get_setting_info_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_write_setting_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_setting_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_list_gpio_banks = R"doc(Get a list of available GPIO banks by name.)doc";


static const char* __doc_gr_soapy_block_write_gpio_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_write_gpio_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_gpio = R"doc(Readback the value of a GPIO bank.)doc";


static const char* __doc_gr_soapy_block_write_gpio_dir_0 = R"doc()doc";


static const char* __doc_gr_soapy_block_write_gpio_dir_1 = R"doc()doc";


static const char* __doc_gr_soapy_block_read_gpio_dir = R"doc(Read the data direction of a GPIO bank. 1 bits represent outputs, 0 bits represent inputs.)doc";


static const char* __doc_gr_soapy_block_write_i2c = R"doc(Write to an available I2C slave. If the device contains multiple I2C masters, the address bits can encode which master.)doc";


static const char* __doc_gr_soapy_block_read_i2c = R"doc(Read from an available I2C slave. If the device contains multiple I2C masters, the address bits can encode which master.)doc";


static const char* __doc_gr_soapy_block_transact_spi = R"doc(Perform a SPI transaction and return the result. Its up to the implementation to set the clock rate, and read edge, and the write edge of the SPI core. SPI slaves without a readback pin will return 0.


If the device contains multiple SPI masters, the address bits can encode which master.)doc";


static const char* __doc_gr_soapy_block_list_uarts = R"doc(Enumerate the available UART devices.)doc";


static const char* __doc_gr_soapy_block_write_uart = R"doc(Write data to a UART device. Its up to the implementation to set the baud rate, carriage return settings, flushing on newline.)doc";


static const char* __doc_gr_soapy_block_read_uart = R"doc(Read bytes from a UART until timeout or newline. Its up to the implementation to set the baud rate, carriage return settings, flushing on newline.)doc";
