/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_eye_sink_c = R"doc(A graphical sink to display signals eye patterns.

This is a QT-based graphical sink which takes a set of a complex streams and plots them as an eye pattern. For each signal, both the signal's I and Q eye patterns are plotted. Eye patterns are 2 symbol's time long. Symbol rate must be an integer multiple of the sample rate to obtain the eye pattern.


Trigger occurs at the beginning of each stream used to plot the eye pattern; whilst a real eye diagram would be triggered with a (recovered) symbol clock. For these reasons, triggering of noisy and/or unsynchronized signals may lead to incorrect eye pattern.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.

Constructor Specific Documentation:

Build complex eye sink.

Args:
    size : number of points to plot at once
    samp_rate : sample rate (used to set x-axis labels)
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_eye_sink_c_eye_sink_c_0 = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_eye_sink_c_1 = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_make = R"doc(A graphical sink to display signals eye patterns.

This is a QT-based graphical sink which takes a set of a complex streams and plots them as an eye pattern. For each signal, both the signal's I and Q eye patterns are plotted. Eye patterns are 2 symbol's time long. Symbol rate must be an integer multiple of the sample rate to obtain the eye pattern.


Trigger occurs at the beginning of each stream used to plot the eye pattern; whilst a real eye diagram would be triggered with a (recovered) symbol clock. For these reasons, triggering of noisy and/or unsynchronized signals may lead to incorrect eye pattern.


The sink supports plotting streaming complex data or messages. The message port is named \"in\". The two modes cannot be used simultaneously, and  should be set to 0 when using the message mode. GRC handles this issue by providing the \"Complex Message\" type that removes the streaming port(s).


This sink can plot messages that contain either uniform vectors of complex 32 values (pmt::is_c32vector) or PDUs where the data is a uniform vector of complex 32 values.

Constructor Specific Documentation:

Build complex eye sink.

Args:
    size : number of points to plot at once
    samp_rate : sample rate (used to set x-axis labels)
    nconnections : number of signals connected to sink
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_eye_sink_c_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_y_axis = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_y_label = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_update_time = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_samp_rate = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_samp_per_symbol = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_trigger_mode = R"doc(Set up a trigger for the sink to know when to start plotting. Useful to isolate events and avoid noise.


The trigger modes are Free, Auto, Normal, and Tag (see gr::qtgui::trigger_mode). The first three are like a normal oscope trigger function. Free means free running with no trigger, auto will trigger if the trigger event is seen, but will still plot otherwise, and normal will hold until the trigger event is observed. The Tag trigger mode allows us to trigger off a specific stream tag. The tag trigger is based only on the name of the tag, so when a tag of the given name is seen, the trigger is activated.


In auto and normal mode, we look for the slope of the of the signal. Given a gr::qtgui::trigger_slope as either Positive or Negative, if the value between two samples moves in the given direction (x[1] > x[0] for Positive or x[1] < x[0] for Negative), then the trigger is activated.


With the complex eye sink, each input has two eye patterns drawn for the real and imaginary parts of the signal. When selecting the  value, channel 0 is the real signal and channel 1 is the imaginary signal. For more than 1 input stream, channel 2i is the real part of the ith input and channel (2i+1) is the imaginary part of the ith input channel.


The  value is specified in time based off the sample rate. If the sample rate of the block is set to 1, the delay is then also the sample number offset. This is the offset from the left-hand y-axis of the plot. It delays the signal to show the trigger event at the given delay along with some portion of the signal before the event. The delay must be within 0 - t_max where t_max is the maximum amount of time displayed on the eye pattern equal to 2 symbol time.)doc";


static const char* __doc_gr_qtgui_eye_sink_c_title = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_label = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_color = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_width = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_style = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_marker = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_line_alpha = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_set_size = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_menu = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_grid = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_autoscale = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_stem_plot = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_semilogx = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_semilogy = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_control_panel = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_tags_0 = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_tags_1 = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_enable_axis_labels = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_disable_legend = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_nsamps = R"doc()doc";


static const char* __doc_gr_qtgui_eye_sink_c_reset = R"doc()doc";
