/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_mmse_resampler_ff = R"doc(Resampling MMSE filter with float input, float output.

The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings \"resamp_ratio\" and \"mu\" and values are pmt floats.

Constructor Specific Documentation:

Build the resampling MMSE filter (float input, float output)

Args:
    phase_shift : The phase shift of the output signal to the input
    resamp_ratio : The resampling ratio = input_rate / output_rate.)doc";


static const char* __doc_gr_filter_mmse_resampler_ff_mmse_resampler_ff_0 = R"doc()doc";


static const char* __doc_gr_filter_mmse_resampler_ff_mmse_resampler_ff_1 = R"doc()doc";


static const char* __doc_gr_filter_mmse_resampler_ff_make = R"doc(Resampling MMSE filter with float input, float output.

The resampling ratio and mu parameters can be set with a pmt dict message. Keys are pmt symbols with the strings \"resamp_ratio\" and \"mu\" and values are pmt floats.

Constructor Specific Documentation:

Build the resampling MMSE filter (float input, float output)

Args:
    phase_shift : The phase shift of the output signal to the input
    resamp_ratio : The resampling ratio = input_rate / output_rate.)doc";


static const char* __doc_gr_filter_mmse_resampler_ff_mu = R"doc()doc";


static const char* __doc_gr_filter_mmse_resampler_ff_resamp_ratio = R"doc()doc";


static const char* __doc_gr_filter_mmse_resampler_ff_set_mu = R"doc()doc";


static const char* __doc_gr_filter_mmse_resampler_ff_set_resamp_ratio = R"doc()doc";
