/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_encoder = R"doc(Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

Constructor Specific Documentation:

Build the FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    input_item_size : size of a block of data for the encoder.
    output_item_size : size of a block of data the encoder will produce.)doc";


static const char* __doc_gr_fec_encoder_encoder_0 = R"doc()doc";


static const char* __doc_gr_fec_encoder_encoder_1 = R"doc()doc";


static const char* __doc_gr_fec_encoder_make = R"doc(Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

Constructor Specific Documentation:

Build the FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    input_item_size : size of a block of data for the encoder.
    output_item_size : size of a block of data the encoder will produce.)doc";


static const char* __doc_gr_fec_encoder_general_work = R"doc(compute output items from input items

WORK_CALLED_PRODUCE is used where not all outputs produce the same number of items. general_work must call produce() for each output to indicate the number of items actually produced.


WORK_DONE indicates that no more data will be produced by this block.


general_work must call consume or consume_each to indicate how many items were consumed on each input stream.)doc";


static const char* __doc_gr_fec_encoder_fixed_rate_ninput_to_noutput = R"doc(Given ninput samples, return number of output samples that will be produced. N.B. this is only defined if fixed_rate returns true. Generally speaking, you don't need to override this.)doc";


static const char* __doc_gr_fec_encoder_fixed_rate_noutput_to_ninput = R"doc(Given noutput samples, return number of input samples required to produce noutput. N.B. this is only defined if fixed_rate returns true. Generally speaking, you don't need to override this.)doc";


static const char* __doc_gr_fec_encoder_forecast = R"doc(Estimate input requirements given output request.

Given a request to product , estimate the number of data items required on each input stream. The estimate doesn't have to be exact, but should be close.)doc";
