/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_mpsk_snr_est_cc = R"doc(A block for computing SNR of a signal.

This block can be used to monitor and retrieve estimations of the signal SNR. It is designed to work in a flowgraph and passes all incoming data along to its output.


The block is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


The estimator is normally placed before clock recovery.

Constructor Specific Documentation:

Factory function returning shared pointer of this class

Args:
    type : the type of estimator to use gr::digital::snr_est_type_t \"snr_est_type_t\" for details about the available types
    tag_nsamples : after this many samples, a tag containing the SNR (key='snr') will be sent
    alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_mpsk_snr_est_cc_0 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_mpsk_snr_est_cc_1 = R"doc()doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_make = R"doc(A block for computing SNR of a signal.

This block can be used to monitor and retrieve estimations of the signal SNR. It is designed to work in a flowgraph and passes all incoming data along to its output.


The block is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


The estimator is normally placed before clock recovery.

Constructor Specific Documentation:

Factory function returning shared pointer of this class

Args:
    type : the type of estimator to use gr::digital::snr_est_type_t \"snr_est_type_t\" for details about the available types
    tag_nsamples : after this many samples, a tag containing the SNR (key='snr') will be sent
    alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_snr = R"doc(Return the estimated signal-to-noise ratio in decibels.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_type = R"doc(Return the type of estimator in use.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_tag_nsample = R"doc(Return how many samples between SNR tags.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_alpha = R"doc(Get the running-average coefficient.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_set_type = R"doc(Set type of estimator to use.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_set_tag_nsample = R"doc(Set the number of samples between SNR tags.)doc";


static const char* __doc_gr_digital_mpsk_snr_est_cc_set_alpha = R"doc(Set the running-average coefficient.)doc";
