/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_throttle = R"doc(throttle flow of samples such that the average rate does not exceed samples_per_sec.

input: one stream of itemsize; output: one stream of itemsize


N.B. this should only be used in GUI apps where there is no other rate limiting block. It is not intended nor effective at precisely controlling the rate of samples. That should be controlled by a source or sink tied to sample clock. E.g., a USRP or audio card.


You can insert this block \"in series\" with your sample flow, in which case it does a throttled copy of input to output. Alternatively, you can not connect its output and just connect this block's input in parallel to an existing block in your flow graph. In that case, Throttle will limit the rate at which samples are consumed; especially at higher rates, where the copying overhead might be significant, this is functionally not different to copying at a limited rate.

Constructor Specific Documentation:

Make a sptr to a Throttle block

Args:
    itemsize : Size of each item, e.g. 8 for gr_complex
    samples_per_sec : Number of items to be passed per second. Waiting time is calculated based on this.
    ignore_tags : Whether or not to react to \"rx_rate\" tags with a double value specifying a new rate.
    maximum_items_per_chunk : Limit the amount of items that are produced/consumed between waiting. Set to 0 (or leave at default) to always wait for the full duration dictated by the current size of workload items, divided by the samples_per_sec.)doc";


static const char* __doc_gr_blocks_throttle_throttle_0 = R"doc()doc";


static const char* __doc_gr_blocks_throttle_throttle_1 = R"doc()doc";


static const char* __doc_gr_blocks_throttle_make = R"doc(throttle flow of samples such that the average rate does not exceed samples_per_sec.

input: one stream of itemsize; output: one stream of itemsize


N.B. this should only be used in GUI apps where there is no other rate limiting block. It is not intended nor effective at precisely controlling the rate of samples. That should be controlled by a source or sink tied to sample clock. E.g., a USRP or audio card.


You can insert this block \"in series\" with your sample flow, in which case it does a throttled copy of input to output. Alternatively, you can not connect its output and just connect this block's input in parallel to an existing block in your flow graph. In that case, Throttle will limit the rate at which samples are consumed; especially at higher rates, where the copying overhead might be significant, this is functionally not different to copying at a limited rate.

Constructor Specific Documentation:

Make a sptr to a Throttle block

Args:
    itemsize : Size of each item, e.g. 8 for gr_complex
    samples_per_sec : Number of items to be passed per second. Waiting time is calculated based on this.
    ignore_tags : Whether or not to react to \"rx_rate\" tags with a double value specifying a new rate.
    maximum_items_per_chunk : Limit the amount of items that are produced/consumed between waiting. Set to 0 (or leave at default) to always wait for the full duration dictated by the current size of workload items, divided by the samples_per_sec.)doc";


static const char* __doc_gr_blocks_throttle_set_sample_rate = R"doc(Sets the sample rate in samples per second.)doc";


static const char* __doc_gr_blocks_throttle_sample_rate = R"doc(Get the sample rate in samples per second.)doc";
