/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_stream_mux = R"doc(Stream muxing block to multiplex many streams into one with a specified format.

Muxes N streams together producing an output stream that contains N0 items from the first stream, N1 items from the second, etc. and repeats:


[N0, N1, N2, ..., Nm, N0, N1, ...]

Constructor Specific Documentation:

Creates a stream muxing block to multiplex many streams into one with a specified format.

Args:
    itemsize : the item size of the stream
    lengths : a vector (list/tuple) specifying the number of items from each stream the mux together. Warning: this requires that at least as many items per stream are available or the system will wait indefinitely for the items.)doc";


static const char* __doc_gr_blocks_stream_mux_stream_mux = R"doc()doc";


static const char* __doc_gr_blocks_stream_mux_make = R"doc(Stream muxing block to multiplex many streams into one with a specified format.

Muxes N streams together producing an output stream that contains N0 items from the first stream, N1 items from the second, etc. and repeats:


[N0, N1, N2, ..., Nm, N0, N1, ...]

Constructor Specific Documentation:

Creates a stream muxing block to multiplex many streams into one with a specified format.

Args:
    itemsize : the item size of the stream
    lengths : a vector (list/tuple) specifying the number of items from each stream the mux together. Warning: this requires that at least as many items per stream are available or the system will wait indefinitely for the items.)doc";
