/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_short_to_float = R"doc(Convert stream of shorts to a stream of floats.

Constructor Specific Documentation:

Build a short to float block.

Args:
    vlen : vector length of data streams.
    scale : a scalar divider to change the output signal scale.)doc";


static const char* __doc_gr_blocks_short_to_float_short_to_float_0 = R"doc()doc";


static const char* __doc_gr_blocks_short_to_float_short_to_float_1 = R"doc()doc";


static const char* __doc_gr_blocks_short_to_float_make = R"doc(Convert stream of shorts to a stream of floats.

Constructor Specific Documentation:

Build a short to float block.

Args:
    vlen : vector length of data streams.
    scale : a scalar divider to change the output signal scale.)doc";


static const char* __doc_gr_blocks_short_to_float_scale = R"doc(Get the scalar divider value.)doc";


static const char* __doc_gr_blocks_short_to_float_set_scale = R"doc(Set the scalar divider value.)doc";
