/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_plateau_detector_fb = R"doc(Detects a plateau and marks the middle.

Detect a plateau of a-priori known height. Input is a stream of floats, the output is a stream of bytes. Whenever a plateau is detected, the middle of that plateau is marked with a '1' on the output stream (all other samples are left at zero).


You can use this in a Schmidl & Cox synchronisation algorithm to interpret the output of the normalized correlator. Just pass the length of the cyclic prefix (in samples) as the max_len parameter).


Unlike the peak detectors, you must the now the absolute height of the plateau. Whenever the amplitude exceeds the given threshold, it starts assuming the presence of a plateau.


An implicit hysteresis is provided by the fact that after detecting one plateau, it waits at least max_len samples before the next plateau can be detected.

Constructor Specific Documentation:



Args:
    max_len : Maximum length of the plateau
    threshold : Anything above this value is considered a plateau)doc";


static const char* __doc_gr_blocks_plateau_detector_fb_plateau_detector_fb_0 =
    R"doc()doc";


static const char* __doc_gr_blocks_plateau_detector_fb_plateau_detector_fb_1 =
    R"doc()doc";


static const char* __doc_gr_blocks_plateau_detector_fb_make = R"doc(Detects a plateau and marks the middle.

Detect a plateau of a-priori known height. Input is a stream of floats, the output is a stream of bytes. Whenever a plateau is detected, the middle of that plateau is marked with a '1' on the output stream (all other samples are left at zero).


You can use this in a Schmidl & Cox synchronisation algorithm to interpret the output of the normalized correlator. Just pass the length of the cyclic prefix (in samples) as the max_len parameter).


Unlike the peak detectors, you must the now the absolute height of the plateau. Whenever the amplitude exceeds the given threshold, it starts assuming the presence of a plateau.


An implicit hysteresis is provided by the fact that after detecting one plateau, it waits at least max_len samples before the next plateau can be detected.

Constructor Specific Documentation:



Args:
    max_len : Maximum length of the plateau
    threshold : Anything above this value is considered a plateau)doc";


static const char* __doc_gr_blocks_plateau_detector_fb_set_threshold = R"doc()doc";


static const char* __doc_gr_blocks_plateau_detector_fb_threshold = R"doc()doc";
